/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.ma.mbg.common.BgDescriptionColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DimensionDescriptionHelper {
    public static String parseDescriptionFormula(List members, String name) {
        if (members == null || members.isEmpty() || StringUtils.isEmpty((String)name)) {
            return null;
        }
        StringBuffer itemNumber = new StringBuffer();
        HashMap<Integer, String> bgItems = new HashMap<Integer, String>();
        for (int i = 0; i < members.size(); ++i) {
            String field = null;
            String srcNumber = null;
            BgDimensionMember member = (BgDimensionMember)members.get(i);
            if (member == null || member.getNumber() == null) {
                bgItems.clear();
                break;
            }
            if (!member.getType().equals(DimensionConstants.DEF_CURRENCY_NUMBER)) {
                if (member.getType().equals(DimensionConstants.DEF_ELEMENT_NUMBER)) {
                    field = DimensionConstants.DEF_ELEMENT_FIELD;
                    srcNumber = DimensionConstants.DEF_ELEMENT_SRCNUMBER;
                } else if (member.getType().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                    field = DimensionConstants.DEF_PERIOD_FIELD;
                    srcNumber = DimensionConstants.DEF_PERIOD_SRCNUMBER;
                } else if (member.getType().equals(DimensionConstants.DEF_SCENARIO_NUMBER)) {
                    field = DimensionConstants.DEF_SCENARIO_FIELD;
                    srcNumber = DimensionConstants.DEF_SCENARIO_SRCNUMBER;
                } else if (member.getType().equals(DimensionConstants.DEF_VERSION_NUMBER)) {
                    field = DimensionConstants.DEF_VERSION_FIELD;
                    srcNumber = DimensionConstants.DEF_VERSION_SRCNUMBER;
                } else if (!member.getType().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                    field = member.getAttribute();
                    srcNumber = member.getSrcNumber();
                }
            }
            if (field == null || srcNumber == null) continue;
            bgItems.put(DimensionCommonHelper.getField(field), DimensionFormulaHelper.getCombination(srcNumber, member.getNumber()));
        }
        if (bgItems.isEmpty()) {
            return null;
        }
        Object[] reffields = bgItems.keySet().toArray();
        Arrays.sort(reffields);
        for (int i = 0; i < reffields.length; ++i) {
            if (i != 0) {
                itemNumber.append(",");
            }
            itemNumber.append(bgItems.get(reffields[i]));
        }
        return DimensionDescriptionHelper.parseDescriptionFormula(itemNumber.toString(), name);
    }

    public static String parseDescriptionFormula(String memberNumber, String colName) {
        return BgNFSHelper.getFormulaFromParam(new String[]{memberNumber, colName, null, null, null});
    }

    public static boolean checkHashDescriptionFormula(Cell cell) {
        return BgNFSHelper.getCellData(cell, "des_col") != null;
    }

    public static void setDescriptionFormula(Cell cell, String formula, String orgId) {
        BgNFSHelper.setCellData(cell, "des_col", formula);
        if (orgId != null) {
            BgNFSHelper.setCellData(cell, MBGLayoutConstants.BG_ORGANIZATION, orgId);
        }
    }

    public static String getDescriptionOrgUnitId(Cell cell) {
        return (String)BgNFSHelper.getCellData(cell, MBGLayoutConstants.BG_ORGANIZATION);
    }

    public static String getDescriptionFormula(Cell cell) {
        return (String)BgNFSHelper.getCellData(cell, "des_col");
    }

    public static String getMemberNumber(String formula, Map cache) {
        if (StringUtils.isEmpty((String)formula)) {
            return null;
        }
        String[] params = BgNFSHelper.parseFormulaPara(cache, formula);
        return params[0];
    }

    public static String getDescriptionName(String formula, Map cache) {
        if (StringUtils.isEmpty((String)formula)) {
            return null;
        }
        String[] params = BgNFSHelper.parseFormulaPara(cache, formula);
        return params[1];
    }

    public static Map getQueryMap(Sheet sheet) {
        HashMap queryMap = new HashMap();
        DimensionDescriptionHelper.getQueryMap(queryMap, sheet);
        return queryMap;
    }

    public static Map getQueryMap(Book book) {
        HashMap queryMap = new HashMap();
        if (book != null) {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                DimensionDescriptionHelper.getQueryMap(queryMap, book.getSheet(i));
            }
        }
        return queryMap;
    }

    private static void getQueryMap(Map queryMap, Sheet sheet) {
        if (queryMap == null || sheet == null) {
            return;
        }
        for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
            Column col = sheet.getColumn(c, false);
            if (col == null || !(col.getUserObjectValue("des_col") instanceof BgDescriptionColumn)) continue;
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                Cell cell = sheet.getCell(r, c, false);
                if (!DimensionDescriptionHelper.checkHashDescriptionFormula(cell)) continue;
                String formula = DimensionDescriptionHelper.getDescriptionFormula(cell);
                String orgId = DimensionDescriptionHelper.getDescriptionOrgUnitId(cell);
                BgViewHelper.getSubMap(queryMap, orgId, true).put(formula, null);
            }
        }
    }
}

