/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.MbgMemberNodeCollection;
import com.kingdee.eas.ma.base.MbgMemberNodeFactory;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.MemberSegregationRuleEnum;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeException;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgdimDisplayMemberFactory;
import com.kingdee.eas.ma.mbg.DimensionPropSrcInfo;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IBgdimDisplayMember;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DimensionFilterHelper
implements KDTDataFillListener {
    private static Logger logger = Logger.getLogger((String)DimensionFilterHelper.class.getName());
    private static final String Projectisolate = "ProjectIsolate";
    private Context ctx;
    private BgDimensionBaseInfo dimension;
    private String orgId;
    private String[] orgUnitIds = null;
    private String bgSchemeId = null;
    private String bgOrgViewId = null;
    private String unitGroupId = null;
    private String dimensionViewID = null;
    private CostCenterOrgUnitInfo costUnit = null;
    private boolean queryCompany = false;
    private CompanyOrgUnitInfo company = null;
    private EntityObjectInfo entity;
    private Set cancelNumber = null;
    private String bgAccGroupId = null;
    private int segregationRule = 0;

    public String getBgAccGroupId() {
        return this.bgAccGroupId;
    }

    public void setBgAccGroupId(String bgAccGroupId) {
        this.bgAccGroupId = bgAccGroupId;
    }

    public BgDimensionBaseInfo getDimension() {
        return this.dimension;
    }

    public void setOrgUnitIds(String[] orgUnitIds) {
        this.orgUnitIds = orgUnitIds;
    }

    private DimensionFilterHelper(Context ctx, BgDimensionBaseInfo dimension, String orgId, String bgSchemeId, String bgOrgViewId, String unitGroupId) throws BOSException {
        this.ctx = ctx;
        this.dimension = dimension;
        this.orgId = orgId;
        this.bgSchemeId = bgSchemeId;
        this.bgOrgViewId = bgOrgViewId;
        if (unitGroupId == null) {
            try {
                if (this.getCostCenterOrgUnit() == null) {
                    IBgScheme is = null;
                    is = ctx == null ? BgSchemeFactory.getRemoteInstance() : BgSchemeFactory.getLocalInstance(ctx);
                    BgSchemeCollection col = is.getBgSchemeCollection("select orgUnit.id where id = '" + bgSchemeId + "'");
                    if (col != null && !col.isEmpty()) {
                        this.orgId = col.get(0).getOrgUnit().getId().toString();
                    }
                    this.unitGroupId = orgId;
                }
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
        } else {
            this.unitGroupId = unitGroupId;
        }
    }

    public CostCenterOrgUnitInfo getCostCenterOrgUnit() throws EASBizException, BOSException {
        if (this.costUnit == null) {
            this.costUnit = DimensionFilterHelper.queryCostCenter(this.ctx, this.orgId);
        }
        return this.costUnit;
    }

    public static CostCenterOrgUnitInfo queryCostCenter(Context ctx, String orgId) throws BOSException, EASBizException {
        String oql = "select id, number, name, longNumber, level, cu.id, isCompanyOrgUnit where id = '" + orgId + "'";
        ObjectBaseCollection col = null;
        col = ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance().getObjectBaseCollection(oql) : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getObjectBaseCollection(oql);
        if (col != null && !col.isEmpty()) {
            return (CostCenterOrgUnitInfo)col.get(0);
        }
        return null;
    }

    public CompanyOrgUnitInfo getCompanyOrgUnit() throws EASBizException, BOSException {
        if (!this.queryCompany) {
            CostCenterOrgUnitInfo cost = this.getCostCenterOrgUnit();
            if (cost.isIsCompanyOrgUnit()) {
                this.company = (CompanyOrgUnitInfo)NewOrgViewHelper.getOrgUnitInfo((Context)this.ctx, (String)this.orgId, (OrgType)OrgType.Company);
            } else {
                IOrgUnitRelation our = null;
                our = this.ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
                OrgUnitCollection col = our.getToUnit(this.orgId, 5, 1);
                if (col != null && !col.isEmpty()) {
                    this.company = (CompanyOrgUnitInfo)col.get(0);
                } else {
                    String[] numbers = cost.getLongNumber().split("!");
                    ICompanyOrgUnit cou = null;
                    cou = this.ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(new FilterInfo());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(Arrays.asList(numbers)), CompareType.INCLUDE));
                    evi.setSelector(new SelectorItemCollection());
                    evi.getSelector().add("id");
                    evi.getSelector().add("number");
                    evi.getSelector().add("name");
                    evi.getSelector().add("longNumber");
                    evi.getSelector().add("isAssistantOrg");
                    evi.getSelector().add("mainOrg");
                    evi.getSelector().add("accountTable.id");
                    CompanyOrgUnitCollection ccol = cou.getCompanyOrgUnitCollection(evi);
                    if (ccol != null && !ccol.isEmpty()) {
                        block0: for (int n = numbers.length - 1; n >= 0; --n) {
                            for (int c = 0; c < ccol.size(); ++c) {
                                if (!numbers[n].equals(ccol.get(c).getNumber())) continue;
                                this.company = ccol.get(c);
                                break block0;
                            }
                        }
                    }
                }
            }
            this.queryCompany = true;
        }
        return this.company;
    }

    public EntityObjectInfo getEntity() {
        if (this.entity == null) {
            this.loadEntity();
        }
        return this.entity;
    }

    public void loadEntity() {
        BOSObjectType bosType = null;
        if (this.dimension != null) {
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(this.dimension.getType())) {
                bosType = new BgOrgUnitInfo().getBOSType();
                if (DimensionCommonHelper.isOrgTreeDimension(this.dimension).booleanValue() && this.dimension.getViewId() != null) {
                    bosType = new FullOrgUnitInfo().getBOSType();
                }
            } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(this.dimension.getType())) {
                bosType = new BgPeriodDispInfo().getBOSType();
            } else if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(this.dimension.getType())) {
                bosType = new BgElementInfo().getBOSType();
            } else if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(this.dimension.getType())) {
                bosType = new CurrencyInfo().getBOSType();
            } else if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(this.dimension.getType())) {
                bosType = new BgScenarioInfo().getBOSType();
            } else if (DimensionConstants.DEF_VERSION_NUMBER.equals(this.dimension.getType())) {
                bosType = new BgVersionInfo().getBOSType();
            } else if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(this.dimension.getType()) || DimensionConstants.DEF_INDEX_NUMBER.equals(this.dimension.getType())) {
                bosType = new BgAccountInfo().getBOSType();
            } else if (!DimensionConstants.necessary.contains(this.dimension.getType())) {
                bosType = new MbgMemberInfo().getBOSType();
            }
        }
        if (bosType != null) {
            this.entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
        }
    }

    public boolean isTreeBase() {
        EntityObjectInfo treeBase = new EntityObjectInfo();
        treeBase.setPackage("com.kingdee.eas.framework.app");
        treeBase.setName("TreeBase");
        return this.getEntity().isSubFrom((BusinessObjectInfo)treeBase);
    }

    public EntityViewInfo getEntityView() throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(this.getSelector());
        evi.setSorter(this.getOrder());
        evi.setFilter(this.getFilter());
        return evi;
    }

    public SorterItemCollection getOrder() {
        String s;
        String flag = this.getFieldFlag();
        SorterItemCollection soic = new SorterItemCollection();
        this.addIsSysDataOrder(soic);
        if (this.isTreeBase()) {
            soic.add(new SorterItemInfo(flag + "longNumber"));
        }
        if ((s = this.getPropertyField("P01")) != null) {
            soic.add(new SorterItemInfo(flag + s));
        }
        if (soic.isEmpty()) {
            soic.add(new SorterItemInfo(flag + "number"));
        }
        return soic;
    }

    private void addIsSysDataOrder(SorterItemCollection soic) {
        if (this.dimension != null) {
            SorterItemInfo sort = null;
            if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(this.dimension.getType()) || DimensionConstants.DEF_VERSION_NUMBER.equals(this.dimension.getType())) {
                sort = new SorterItemInfo("isSysData");
            } else if (!DimensionConstants.defaultDim.contains(this.dimension.getType())) {
                sort = new SorterItemInfo("isSystemDefault");
            }
            if (sort != null) {
                sort.setSortType(SortType.DESCEND);
                soic.add(sort);
            }
        }
    }

    public ICoreBase getBizInterface() throws BOSException {
        if (this.ctx == null) {
            return (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)this.getEntity().getBOSType(), ICoreBase.class);
        }
        return (ICoreBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)this.getEntity().getBOSType());
    }

    public IDataProvider getQueryExecutor() {
        if (this.ctx == null) {
            return EntityExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)this.getEntity().getFullName()));
        }
        return EntityExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)MetaDataPK.create((String)this.getEntity().getFullName()));
    }

    public FilterInfo getFilter() throws EASBizException, BOSException {
        return this.getFilter(true);
    }

    public FilterInfo getFilter(boolean isSegregationRuleFilter) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        if (DimensionConstants.filterMemberDim.contains(this.dimension.getType())) {
            HashSet<String> ids = new HashSet<String>();
            List lst = this.dimension.getMember();
            if (lst != null && !lst.isEmpty()) {
                for (Object member : lst) {
                    if (member instanceof BgDimensionMember) {
                        ids.add(((BgDimensionMember)member).getAttribute());
                        continue;
                    }
                    if (!(member instanceof BgDimSettingsMemberInfo)) continue;
                    ids.add(((BgDimSettingsMemberInfo)member).getMemberID().toString());
                }
                if (!ids.isEmpty()) {
                    filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                }
            }
        } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(this.dimension.getType())) {
            HashSet<String> bgPeriodTypeNumbers = new HashSet<String>();
            for (int i = 0; i < this.dimension.getMember().size(); ++i) {
                bgPeriodTypeNumbers.add(((BgDimensionMember)this.dimension.getMember().get(i)).getNumber());
            }
            if (bgPeriodTypeNumbers.isEmpty()) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000="));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("type.number", bgPeriodTypeNumbers, CompareType.INCLUDE));
            }
        } else if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(this.dimension.getType())) {
            filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)this.dimension.getViewId()));
        } else if (!DimensionConstants.necessary.contains(this.dimension.getType())) {
            if (StringUtils.isEmpty((String)this.dimension.getViewId())) {
                throw new BgSchemeException(BgSchemeException.BGSCHEMEERROR);
            }
            if (isSegregationRuleFilter) {
                this.addSegregationRuleFilter(filter);
            }
            filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)this.dimension.getViewId()));
            if (filter.getMaskString() != null) {
                filter.setMaskString(filter.getMaskString() + " and #" + String.valueOf(filter.getFilterItems().size() - 1) + "");
            }
        } else if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(this.dimension.getType())) {
            if (DimensionCommonHelper.isOrgTreeDimension(this.dimension).booleanValue()) {
                this.addOrgTreeFilter(filter);
            } else {
                filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)this.dimension.getViewId()));
            }
        }
        return filter;
    }

    public boolean checkDimension() {
        String value = this.dimension.getValue();
        return value == null || !value.equals("BgVariateListUI") && !value.equals("BizCalcMainUI") && !value.equals("BizCalcDimensionMemberSelectF7UI") && !value.equals("FunctionSelectF7UI") && !value.equals("MbgIsMemberFunctionWizardUI");
    }

    private void addOrgTreeFilter(FilterInfo filter) throws BOSException {
        String oql = "select unit.id where tree.id = '" + this.dimension.getViewId() + "' and unit.isgrouping = 1";
        OrgStructureCollection colls = null;
        colls = this.ctx == null ? OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(oql) : OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureCollection(oql);
        if (colls != null && !colls.isEmpty()) {
            HashSet<String> ids = new HashSet<String>();
            for (int index = 0; index < colls.size(); ++index) {
                ids.add(colls.get(index).getUnit().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        }
    }

    public int getSegregationRule() {
        return this.segregationRule;
    }

    public void setSegregationRule(int segregationRule) {
        this.segregationRule = segregationRule;
    }

    private void addSegregationRuleFilter(FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        BgDimSettingsInfo dimSettingsInfo = null;
        BgDimSettingsCollection dimSettingCol = null;
        if (this.bgSchemeId != null) {
            if (this.bgOrgViewId == null) {
                sic.add("dimNumber");
                sic.add("members.memberID");
                sic.add("members.type");
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)this.bgSchemeId));
                filterInfo.getFilterItems().add(new FilterItemInfo("dimNumber", (Object)DimensionBaseConstants.DEF_ORGUNIT_NUMBER));
                evi.setSelector(sic);
                evi.setFilter(filterInfo);
                dimSettingCol = this.ctx == null ? BgDimSettingsFactory.getRemoteInstance().getBgDimSettingsCollection(evi) : BgDimSettingsFactory.getLocalInstance(this.ctx).getBgDimSettingsCollection(evi);
                if (dimSettingCol != null && !dimSettingCol.isEmpty()) {
                    int size = dimSettingCol.size();
                    for (int i = 0; i < size; ++i) {
                        BgDimSettingsMemberCollection col;
                        dimSettingsInfo = dimSettingCol.get(i);
                        if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimSettingsInfo.getDimNumber()) || (col = dimSettingsInfo.getMembers()) == null || col.isEmpty()) continue;
                        for (int j = 0; j < col.size(); ++j) {
                            if (!col.get(j).getType().equals((Object)MemberTypeEnum.budget)) continue;
                            this.bgOrgViewId = col.get(j).getMemberID().toString();
                        }
                    }
                }
            }
            sic = new SelectorItemCollection();
            sic.add("segregationRule");
            MbgViewInfo viewInfo = null;
            if (this.getSegregationRule() == 0) {
                viewInfo = this.ctx == null ? MbgViewFactory.getRemoteInstance().getMbgViewInfo((IObjectPK)new ObjectUuidPK(this.dimension.getViewId()), sic) : MbgViewFactory.getLocalInstance((Context)this.ctx).getMbgViewInfo((IObjectPK)new ObjectUuidPK(this.dimension.getViewId()), sic);
            } else {
                viewInfo = new MbgViewInfo();
                viewInfo.setSegregationRule(MemberSegregationRuleEnum.getEnum((int)this.getSegregationRule()));
            }
            if (MemberSegregationRuleEnum.SEGREGATEEQUALS.equals((Object)viewInfo.getSegregationRule()) && this.checkDimension()) {
                Set orgUnitIds = null;
                String[] _orgUnitIds = this.orgUnitIds;
                if (_orgUnitIds == null && this.orgId != null) {
                    _orgUnitIds = new String[]{this.orgId};
                }
                if ((orgUnitIds = this.ctx == null ? BgOrgUnitFactory.getRemoteInstance().getMbgDimOrgIds(this.dimension.getViewId(), this.bgSchemeId, _orgUnitIds, this.bgOrgViewId, this.unitGroupId) : BgOrgUnitFactory.getLocalInstance(this.ctx).getMbgDimOrgIds(this.dimension.getViewId(), this.bgSchemeId, _orgUnitIds, this.bgOrgViewId, this.unitGroupId)) != null && !orgUnitIds.isEmpty()) {
                    if (orgUnitIds.contains("findNoOne")) {
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgBaseConstants.nullID, CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitIds, CompareType.INCLUDE));
                    }
                }
            } else if (MemberSegregationRuleEnum.SEGREGATEORG.equals((Object)viewInfo.getSegregationRule())) {
                HashSet<String> orgidSet = new HashSet<String>();
                String[] _orgUnitIds = this.orgUnitIds;
                if (_orgUnitIds == null && this.orgId != null) {
                    _orgUnitIds = new String[]{this.orgId};
                }
                orgidSet.addAll(Arrays.asList(_orgUnitIds));
                if ("FunctionSelectF7UI".equals(this.dimension.getValue()) || "BizCalcMainUI".equals(this.dimension.getValue()) || "BgExamineMainUI".equals(this.dimension.getValue()) || "BgVariateListUI".equals(this.dimension.getValue()) || "IS_CANNT_FILTERORG".equals(this.dimension.getValue()) || this.unitGroupId != null) {
                    orgidSet.clear();
                    if (this.unitGroupId != null) {
                        OrgStructureInfo structInfo = null;
                        OrgStructureCollection col = null;
                        if (this.ctx == null) {
                            if (OrgStructureFactory.getRemoteInstance().exists("select tree.id, longNumber where unit.id = '" + this.unitGroupId + "'")) {
                                structInfo = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo("select tree.id, longNumber where unit.id = '" + this.unitGroupId + "'");
                                col = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select unit.id, unit.longNumber, unit.isCostOrgUnit where tree.id = '" + structInfo.getTree().getId() + "' and longNumber like '" + structInfo.getLongNumber() + "!%'");
                            } else {
                                col = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select unit.id, unit.longNumber, unit.isCostOrgUnit where tree.id = '" + this.unitGroupId + "' ");
                            }
                        } else if (OrgStructureFactory.getLocalInstance((Context)this.ctx).exists("select tree.id, longNumber where unit.id = '" + this.unitGroupId + "'")) {
                            structInfo = OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureInfo("select tree.id, longNumber where unit.id = '" + this.unitGroupId + "'");
                            col = OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureCollection("select unit.id, unit.longNumber, unit.isCostOrgUnit where tree.id = '" + structInfo.getTree().getId() + "' and longNumber like '" + structInfo.getLongNumber() + "!%'");
                        } else {
                            col = OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureCollection("select unit.id, unit.longNumber, unit.isCostOrgUnit where tree.id = '" + this.unitGroupId + "'");
                        }
                        for (int i = 0; i < col.size(); ++i) {
                            if (!col.get(i).getUnit().isIsCostOrgUnit()) continue;
                            orgidSet.add(col.get(i).getUnit().getId().toString());
                        }
                        if (orgidSet.isEmpty()) {
                            orgidSet.addAll(Arrays.asList(_orgUnitIds));
                        }
                    } else {
                        BgOrgUnitCollection orgColl = null;
                        orgColl = this.ctx == null ? BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("select orgUnitID where viewID = '" + this.bgOrgViewId + "'") : BgOrgUnitFactory.getLocalInstance(this.ctx).getBgOrgUnitCollection("select orgUnitID where viewID = '" + this.bgOrgViewId + "'");
                        for (int i = 0; i < orgColl.size(); ++i) {
                            orgidSet.add(orgColl.get(i).getOrgUnitID());
                        }
                    }
                }
                int length = filter.getFilterItems().size();
                if (viewInfo != null && viewInfo.getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEORG)) {
                    int i;
                    if (orgidSet.isEmpty()) {
                        orgidSet.addAll(Arrays.asList(_orgUnitIds));
                    }
                    EntityViewInfo viewinfo = new EntityViewInfo();
                    viewinfo.setFilter(new FilterInfo());
                    viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("mbgMember.viewId", (Object)this.dimension.getViewId(), CompareType.EQUALS));
                    viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", orgidSet, CompareType.INCLUDE));
                    MbgMemberNodeCollection coll = null;
                    try {
                        coll = this.ctx == null ? MbgMemberNodeFactory.getRemoteInstance().getMbgMemberNodeCollection(viewinfo) : MbgMemberNodeFactory.getLocalInstance((Context)this.ctx).getMbgMemberNodeCollection(viewinfo);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgidSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("isSystemDefault", (Object)1, CompareType.EQUALS));
                    int count = 0;
                    if (coll != null && !coll.isEmpty()) {
                        HashSet<String> memberids = new HashSet<String>();
                        for (i = 0; i < coll.size(); ++i) {
                            memberids.add(coll.get(i).getMbgMember().getId().toString());
                        }
                        filter.getFilterItems().add(new FilterItemInfo("id", memberids, CompareType.INCLUDE));
                        ++count;
                    }
                    StringBuffer maskString = new StringBuffer();
                    for (i = 0; i < length; ++i) {
                        maskString.append("#" + i).append(" and ");
                    }
                    if (count == 0) {
                        filter.setMaskString(maskString + " ( #" + String.valueOf(filter.getFilterItems().size() - 2) + " or #" + String.valueOf(filter.getFilterItems().size() - 1) + ")");
                    } else if (count == 1) {
                        filter.setMaskString(maskString + " ( #" + String.valueOf(filter.getFilterItems().size() - 3) + " or #" + String.valueOf(filter.getFilterItems().size() - 2) + " or #" + String.valueOf(filter.getFilterItems().size() - 1) + ")");
                    }
                }
            }
        } else if (this.bgSchemeId == null && this.bgOrgViewId != null) {
            sic = new SelectorItemCollection();
            sic.add("segregationRule");
            MbgViewInfo viewInfo = null;
            viewInfo = this.ctx == null ? MbgViewFactory.getRemoteInstance().getMbgViewInfo((IObjectPK)new ObjectUuidPK(this.dimension.getViewId()), sic) : MbgViewFactory.getLocalInstance((Context)this.ctx).getMbgViewInfo((IObjectPK)new ObjectUuidPK(this.dimension.getViewId()), sic);
            if (MemberSegregationRuleEnum.SEGREGATEEQUALS.equals((Object)viewInfo.getSegregationRule()) && this.checkDimension()) {
                Set orgUnitIds = null;
                orgUnitIds = this.ctx == null ? BgOrgUnitFactory.getRemoteInstance().getParentAndChildrenOrgUnitIds(this.orgId, this.bgOrgViewId) : BgOrgUnitFactory.getLocalInstance(this.ctx).getParentAndChildrenOrgUnitIds(this.orgId, this.bgOrgViewId);
                if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
                    if (orgUnitIds.contains("findNoOne")) {
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgBaseConstants.nullID, CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitIds, CompareType.INCLUDE));
                    }
                }
            }
        }
    }

    public void hideCancelRow(KDTable table) {
        Object[] list = table.getListenerList().getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof DimensionFilterHelper)) continue;
            table.removeKDTDataFillListener((KDTDataFillListener)((DimensionFilterHelper)list[i]));
        }
        table.addKDTDataFillListener((KDTDataFillListener)this);
    }

    public void afterDataFill(KDTDataRequestEvent e) {
        if (e != null && e.getSource() instanceof KDTable) {
            KDTable table = (KDTable)e.getSource();
            String number = null;
            for (int r = e.getFirstRow(); r <= e.getLastRow(); ++r) {
                IRow row = table.getRow(r);
                if (row.getCell("number") != null && row.getCell("number").getValue() != null) {
                    if (row.getCell("number").getValue() instanceof String) {
                        number = (String)row.getCell("number").getValue();
                    } else if (row.getCell("number").getValue() instanceof NumberExpandInfo) {
                        number = ((NumberExpandInfo)row.getCell("number").getValue()).getNumber();
                    }
                }
                if (number == null || !this.isCancel(number)) continue;
                row.getStyleAttributes().setHided(true);
            }
        }
    }

    public boolean isCancel(String number) {
        if (this.cancelNumber == null) {
            this.cancelNumber = new HashSet();
            try {
                IBgdimDisplayMember dimExpress = null;
                dimExpress = this.ctx == null ? BgdimDisplayMemberFactory.getRemoteInstance() : BgdimDisplayMemberFactory.getLocalInstance(this.ctx);
                Set freezedNumbers = dimExpress.getFreezedNums(this.bgSchemeId, this.dimension.getNumber());
                if (freezedNumbers != null && !freezedNumbers.isEmpty()) {
                    this.cancelNumber.addAll(freezedNumbers);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return this.cancelNumber.contains(number);
    }

    public SelectorItemCollection getSelector() {
        String flag = this.getFieldFlag();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(flag + "id");
        sic.add(flag + "number");
        sic.add(flag + "name");
        sic.add(flag + "description");
        if (this.isTreeBase()) {
            sic.add(flag + "longNumber");
            sic.add(flag + "level");
            sic.add(flag + "isLeaf");
            sic.add(flag + "description");
            sic.add(flag + "displayName");
        }
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(this.getDimension().getNumber()) && !DimensionCommonHelper.isOrgTreeDimension(this.getDimension()).booleanValue()) {
            sic.add(flag + "orgUnitId");
        }
        if (DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(this.getDimension().getNumber()) || !DimensionBaseConstants.necessary.contains(this.getDimension().getNumber())) {
            sic.add(flag + "isEnabled");
            sic.add(flag + "disabledDate");
        }
        return sic;
    }

    public String getFieldFlag() {
        String flag = "";
        return flag;
    }

    public String getPropertyField(String prop) {
        DimensionPropSrcInfo propSrc = this.getProperty(prop);
        if (propSrc != null) {
            return propSrc.getDimSrcPropName();
        }
        return null;
    }

    public DimensionPropSrcInfo getProperty(String prop) {
        return null;
    }

    public static DimensionFilterHelper getLocaleIntance(Context ctx, BgDimensionInfo dimension, String orgId, String bgSchemeId, String bgOrgViewId, String unitGroupId) {
        try {
            return new DimensionFilterHelper(ctx, dimension, orgId, bgSchemeId, bgOrgViewId, unitGroupId);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static DimensionFilterHelper getRemoteIntance(BgDimensionBaseInfo dimension, String[] orgUnitIds, String orgId, String bgSchemeId, String bgOrgViewId, String unitGroupId) {
        if (orgUnitIds == null || orgUnitIds.length == 0) {
            if (orgId != null) {
                return DimensionFilterHelper.getRemoteIntance(dimension, orgId, bgSchemeId, bgOrgViewId, unitGroupId);
            }
            return DimensionFilterHelper.getRemoteIntance(dimension, (String)null, bgSchemeId, bgOrgViewId, unitGroupId);
        }
        DimensionFilterHelper filterHelper = DimensionFilterHelper.getRemoteIntance(dimension, orgUnitIds[0], bgSchemeId, bgOrgViewId, unitGroupId);
        if (filterHelper != null) {
            filterHelper.setOrgUnitIds(orgUnitIds);
        }
        return filterHelper;
    }

    public static DimensionFilterHelper getRemoteIntance(BgDimensionBaseInfo dimension, String orgId, String bgSchemeId, String bgOrgViewId, String unitGroupId) {
        try {
            return new DimensionFilterHelper(null, dimension, orgId, bgSchemeId, bgOrgViewId, unitGroupId);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static DimensionFilterHelper getLocaleIntance(Context ctx, String orgId, String bgSchemeId, String bgOrgViewId, String unitGroupId, String dimensionViewID) {
        try {
            return new DimensionFilterHelper(ctx, orgId, bgSchemeId, bgOrgViewId, unitGroupId, dimensionViewID);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static DimensionFilterHelper getRemoteIntance(String orgId, String bgSchemeId, String bgOrgViewId, String unitGroupId, String dimensionViewID) {
        try {
            return new DimensionFilterHelper(null, orgId, bgSchemeId, bgOrgViewId, unitGroupId, dimensionViewID);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    private DimensionFilterHelper(Context ctx, String orgId, String bgSchemeId, String bgOrgViewId, String unitGroupId, String dimensionViewID) throws BOSException {
        this.ctx = ctx;
        this.dimension = this.dimension;
        this.orgId = orgId;
        this.bgSchemeId = bgSchemeId;
        this.bgOrgViewId = bgOrgViewId;
        this.dimensionViewID = dimensionViewID;
        if (unitGroupId == null) {
            try {
                if (this.getCostCenterOrgUnit() == null) {
                    IBgScheme is = null;
                    is = ctx == null ? BgSchemeFactory.getRemoteInstance() : BgSchemeFactory.getLocalInstance(ctx);
                    BgSchemeCollection col = is.getBgSchemeCollection("select orgUnit.id where id = '" + bgSchemeId + "'");
                    if (col != null && !col.isEmpty()) {
                        this.orgId = col.get(0).getOrgUnit().getId().toString();
                    }
                    this.unitGroupId = orgId;
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        } else {
            this.unitGroupId = unitGroupId;
        }
    }

    public MbgMemberCollection getSegregationOrg() throws EASBizException, BOSException {
        HashSet<String> orgidSet = new HashSet<String>();
        String[] _orgUnitIds = this.orgUnitIds;
        if (_orgUnitIds == null && this.orgId != null) {
            _orgUnitIds = new String[]{this.orgId};
        }
        orgidSet.addAll(Arrays.asList(_orgUnitIds));
        if (this.unitGroupId != null) {
            orgidSet.clear();
            OrgStructureInfo structInfo = null;
            OrgStructureCollection col = null;
            if (this.ctx == null) {
                structInfo = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo("select tree.id, longNumber where unit.id = '" + this.unitGroupId + "'");
                col = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select unit.id, unit.longNumber, unit.isCostOrgUnit where tree.id = '" + structInfo.getTree().getId() + "' and longNumber like '" + structInfo.getLongNumber() + "!%'");
            } else {
                structInfo = OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureInfo("select tree.id, longNumber where unit.id = '" + this.unitGroupId + "'");
                col = OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureCollection("select unit.id, unit.longNumber, unit.isCostOrgUnit where tree.id = '" + structInfo.getTree().getId() + "' and longNumber like '" + structInfo.getLongNumber() + "!%'");
            }
            for (int i = 0; i < col.size(); ++i) {
                if (!col.get(i).getUnit().isIsCostOrgUnit()) continue;
                orgidSet.add(col.get(i).getUnit().getId().toString());
            }
        }
        EntityViewInfo viewinfo = new EntityViewInfo();
        viewinfo.setFilter(new FilterInfo());
        viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("mbgMember.viewId", (Object)this.dimensionViewID, CompareType.EQUALS));
        viewinfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", orgidSet, CompareType.INCLUDE));
        MbgMemberNodeCollection coll = null;
        try {
            coll = this.ctx == null ? MbgMemberNodeFactory.getRemoteInstance().getMbgMemberNodeCollection(viewinfo) : MbgMemberNodeFactory.getLocalInstance((Context)this.ctx).getMbgMemberNodeCollection(viewinfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        viewinfo = new EntityViewInfo();
        viewinfo.setFilter(new FilterInfo());
        FilterInfo filter = viewinfo.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)this.dimensionViewID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgidSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isSystemDefault", (Object)1, CompareType.EQUALS));
        int count = 0;
        if (coll != null && !coll.isEmpty()) {
            HashSet<String> memberids = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                memberids.add(coll.get(i).getMbgMember().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", memberids, CompareType.INCLUDE));
            ++count;
        }
        if (count == 0) {
            filter.setMaskString("#0 and (#1 or #2)");
        } else if (count == 1) {
            filter.setMaskString("#0 and (#1 or #2 or #3)");
        }
        MbgMemberCollection membercoll = null;
        try {
            membercoll = this.ctx == null ? MbgMemberFactory.getRemoteInstance().getMbgMemberCollection(viewinfo) : MbgMemberFactory.getLocalInstance((Context)this.ctx).getMbgMemberCollection(viewinfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return membercoll;
    }
}

