/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.mbg.DimensionException;
import org.apache.log4j.Logger;

public class DimensionFormulaCheckHelper {
    private static Logger logger = Logger.getLogger((String)DimensionFormulaCheckHelper.class.getName());

    public String checkExpress(final String express) throws EASBizException {
        Object expStr = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)express);
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    Expression _expression = null;
                    try {
                        _expression = DimensionFormulaCheckHelper.this.checkExpression(expr);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Expression Trans Error:" + express), (Throwable)ex);
                        _expression = null;
                        throw new RuntimeException(ex);
                    }
                    return _expression;
                }
            });
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Expression Trans Error:", (Throwable)e);
            throw new DimensionException(DimensionException.BGCALCULATEEXPERROR);
        }
        return null;
    }

    protected Expression checkExpression(Expression funExpr) throws EASBizException {
        if (funExpr instanceof BinaryOperationExpr) {
            funExpr = this.checkBinaryOperationExpr((BinaryOperationExpr)funExpr);
        } else if (funExpr instanceof IntExpr || funExpr instanceof NumberExpr) {
            funExpr = this.checkBaseFunRxpr(funExpr);
        } else if (funExpr instanceof FunctionExpr) {
            funExpr = this.checkFunctionExpr((FunctionExpr)funExpr);
        } else if (funExpr instanceof UnaryOperationExpr) {
            funExpr = this.checkUnaryOperationExpr((UnaryOperationExpr)funExpr);
        } else if (funExpr instanceof StringExpr) {
            funExpr = this.checkStringExpr((StringExpr)funExpr);
        } else {
            throw new DimensionException(DimensionException.BGCALCULATEEXPERROR);
        }
        return funExpr;
    }

    private Expression checkStringExpr(StringExpr funExpr) throws DimensionException {
        if (funExpr.value.indexOf(":") <= 0) {
            throw new DimensionException(DimensionException.BGCALCULATEEXPERROR);
        }
        return funExpr;
    }

    private Expression checkUnaryOperationExpr(UnaryOperationExpr boExpr) throws EASBizException {
        return boExpr;
    }

    private Expression checkFunctionExpr(FunctionExpr funExpr) {
        return funExpr;
    }

    private Expression checkBaseFunRxpr(Expression funExpr) {
        return funExpr;
    }

    private Expression checkBinaryOperationExpr(BinaryOperationExpr boExpr) throws EASBizException {
        boExpr.left = this.checkExpression(boExpr.left);
        boExpr.right = this.checkExpression(boExpr.right);
        return boExpr;
    }
}

