/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.utils.MbgExportThreadProcessor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class MbgFixelQueryBgDataThread {
    private static final Logger logger = CoreUIObject.getLogger(MbgFixelQueryBgDataThread.class);
    private LinkedHashMap<String, BgFormInfo> bgFormInfoMap = null;
    private CoreUIObject ownerUI = null;
    private MbgExportThreadProcessor threadProcessor = null;

    public MbgFixelQueryBgDataThread(LinkedHashMap<String, BgFormInfo> bgFormInfoMap, CoreUIObject ownerUI, MbgExportThreadProcessor threadProcessor) {
        this.bgFormInfoMap = bgFormInfoMap;
        this.ownerUI = ownerUI;
        this.threadProcessor = threadProcessor;
        this.setThread();
        Thread thread = new Thread(){

            @Override
            public void run() {
                MbgFixelQueryBgDataThread.this.init();
            }
        };
        thread.start();
    }

    private void setThread() {
        String formId2 = null;
        for (String formId2 : this.bgFormInfoMap.keySet()) {
            BgFormInfo bgFormInfo = this.bgFormInfoMap.get(formId2);
            if (bgFormInfo.getBgTemplate().getFormType().getValue() != 0 && bgFormInfo.getBgTemplate().getFormType().getValue() != 8) continue;
            bgFormInfo.setUseThread(true);
        }
    }

    private void init() {
        BgFormInfo bgFormInfo;
        LinkedHashSet<String> formIds = new LinkedHashSet<String>();
        for (String formId : this.bgFormInfoMap.keySet()) {
            bgFormInfo = this.bgFormInfoMap.get(formId);
            if (bgFormInfo.getBgTemplate().getFormType().getValue() != 0 && bgFormInfo.getBgTemplate().getFormType().getValue() != 8) continue;
            formIds.add(formId);
        }
        if (formIds.isEmpty()) {
            return;
        }
        for (String formId : formIds) {
            bgFormInfo = this.bgFormInfoMap.get(formId);
            if (!bgFormInfo.isUseThread() || this.threadProcessor != null && !this.threadProcessor.requestProcess(formId)) continue;
            try {
                long st = System.currentTimeMillis();
                logger.info((Object)("******************* start getBgDataInfo (" + formId + ") : " + st));
                HashMap bgDataMap = BgFormFactory.getRemoteInstance().getBgDataInfo(bgFormInfo, null);
                logger.info((Object)("******************* end getBgDataInfo  (" + formId + ") : " + (System.currentTimeMillis() - st) + "ms"));
                if (bgDataMap == null) {
                    bgDataMap = new HashMap();
                }
                bgFormInfo.setThreadBgDataMap(bgDataMap);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }
}

