/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MbgViewListDescription;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MbgViewListDescriptionHelper {
    public static String successFromViews = "successFromViews";
    public static final String DESCRIPTION_CELL = "description_cell";
    public static final String DESCRIPTION_OBJECT = "description_object";
    public static final String OLD_DESCRIPTION_OBJECT = "old_description_object";
    public static final String IS_SET_WIDTH = "IS_SET_WIDTH";

    public static void setDescriptionCell(Cell cell, MbgViewListDesCellInfo desCellInfo) {
        if (cell != null) {
            cell.setUserObject(DESCRIPTION_OBJECT, (Object)desCellInfo);
            cell.setUserObject(OLD_DESCRIPTION_OBJECT, (Object)desCellInfo.getValue());
        }
    }

    public static void removeDesriptionCell(Cell cell) {
        if (cell != null) {
            cell.removeUserObject(DESCRIPTION_OBJECT);
        }
    }

    public static void buildDescriptionFormula(String orgUnitid, Cell cell, String rowcolAlais, List<BgDimensionMember> members, MbgViewListSheetManager sheetManager, Row row, Column col, boolean isCheckFull) {
        String _bgFormula;
        if (cell == null || members == null) {
            return;
        }
        BgDimensionMember _org = null;
        BgDimensionMember member = null;
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            member = members.get(i);
            if (member.getType() == null || !MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType())) continue;
            _org = member;
            break;
        }
        if (_org == null) {
            _org = MbgViewListDescriptionHelper.getOrgMember(sheetManager, row, col);
        }
        if (!StringUtils.isEmpty((String)(_bgFormula = MbgViewListDescriptionHelper.parseDescriptionFormula(members, rowcolAlais, isCheckFull)))) {
            MbgViewListDescriptionHelper.setDescriptionFormula(cell, _bgFormula, _org != null && BOSUuid.isValidLength((String)_org.getAttribute()) ? _org.getAttribute() : orgUnitid);
        }
    }

    public static String parseDescriptionFormula(List members, String name, boolean isCheckFull) {
        if (members == null) {
            return null;
        }
        StringBuffer itemNumber = new StringBuffer();
        HashMap<Integer, String> bgItems = new HashMap<Integer, String>();
        for (int i = 0; i < members.size(); ++i) {
            String field = null;
            String srcNumber = null;
            BgDimensionMember member = (BgDimensionMember)members.get(i);
            if (member.getNumber() == null) {
                if (!isCheckFull) continue;
                return null;
            }
            if (!member.getType().equals(DimensionConstants.DEF_CURRENCY_NUMBER)) {
                if (member.getType().equals(DimensionConstants.DEF_ELEMENT_NUMBER)) {
                    field = DimensionConstants.DEF_ELEMENT_FIELD;
                    srcNumber = DimensionConstants.DEF_ELEMENT_SRCNUMBER;
                } else if (member.getType().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                    field = DimensionConstants.DEF_PERIOD_FIELD;
                    srcNumber = DimensionConstants.DEF_PERIOD_SRCNUMBER;
                } else if (member.getType().equals(DimensionConstants.DEF_SCENARIO_NUMBER)) {
                    field = DimensionConstants.DEF_SCENARIO_FIELD;
                    srcNumber = DimensionConstants.DEF_SCENARIO_SRCNUMBER;
                } else if (member.getType().equals(DimensionConstants.DEF_VERSION_NUMBER)) {
                    field = DimensionConstants.DEF_VERSION_FIELD;
                    srcNumber = DimensionConstants.DEF_VERSION_SRCNUMBER;
                } else if (!member.getType().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                    field = member.getAttribute();
                    srcNumber = member.getSrcNumber();
                }
            }
            if (field == null || srcNumber == null) continue;
            bgItems.put(DimensionCommonHelper.getField(field), DimensionFormulaHelper.getCombination(srcNumber, member.getNumber()));
        }
        if (bgItems.isEmpty()) {
            return BgBaseConstants.noFindStr;
        }
        Object[] reffields = bgItems.keySet().toArray();
        Arrays.sort(reffields);
        for (int i = 0; i < reffields.length; ++i) {
            if (i != 0) {
                itemNumber.append(",");
            }
            itemNumber.append(bgItems.get(reffields[i]));
        }
        return itemNumber.toString();
    }

    public static String parseDescriptionFormula(String memberNumber, String colName) {
        return BgNFSHelper.getFormulaFromParam(new String[]{memberNumber, colName, null, null, null});
    }

    public static boolean checkHashDescriptionFormula(Cell cell) {
        return BgNFSHelper.getCellData(cell, DESCRIPTION_CELL) != null;
    }

    public static void setDescriptionFormula(Cell cell, String formula, String orgId) {
        BgNFSHelper.setCellData(cell, DESCRIPTION_CELL, formula);
        if (orgId != null) {
            BgNFSHelper.setCellData(cell, MBGLayoutConstants.BG_ORGANIZATION, orgId);
        }
    }

    public static void removeDescriptionFormula(Cell cell) {
        BgNFSHelper.removeCellData(cell, DESCRIPTION_CELL);
        BgNFSHelper.removeCellData(cell, MBGLayoutConstants.BG_ORGANIZATION);
    }

    public static String getDescriptionOrgUnitId(Cell cell) {
        return (String)BgNFSHelper.getCellData(cell, MBGLayoutConstants.BG_ORGANIZATION);
    }

    public static String getDescriptionFormula(Cell cell) {
        return (String)BgNFSHelper.getCellData(cell, DESCRIPTION_CELL);
    }

    public static String getMemberNumber(String formula, Map cache) {
        if (StringUtils.isEmpty((String)formula)) {
            return null;
        }
        String[] params = BgNFSHelper.parseFormulaPara(cache, formula);
        return params[0];
    }

    public static String getDescriptionName(String formula, Map cache) {
        if (StringUtils.isEmpty((String)formula)) {
            return null;
        }
        String[] params = BgNFSHelper.parseFormulaPara(cache, formula);
        return params[1];
    }

    public static Map getQueryMap(Sheet sheet) {
        HashMap queryMap = new HashMap();
        MbgViewListDescriptionHelper.getQueryMap(queryMap, sheet);
        return queryMap;
    }

    public static Map getQueryMap(Book book) {
        HashMap queryMap = new HashMap();
        if (book != null) {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                MbgViewListDescriptionHelper.getQueryMap(queryMap, book.getSheet(i));
            }
        }
        return queryMap;
    }

    private static void getQueryMap(Map queryMap, Sheet sheet) {
        if (queryMap == null || sheet == null) {
            return;
        }
        for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
            Column col = sheet.getColumn(c, false);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                Cell cell = sheet.getCell(r, c, false);
                if (!MbgViewListDescriptionHelper.checkHashDescriptionFormula(cell)) continue;
                String formula = MbgViewListDescriptionHelper.getDescriptionFormula(cell);
                String orgId = MbgViewListDescriptionHelper.getDescriptionOrgUnitId(cell);
                BgViewHelper.getSubMap(queryMap, orgId, true).put(formula, null);
            }
        }
    }

    public static BgDimensionMember getOrgMember(MbgViewListSheetManager sheetManager, Row row, Column col) {
        return MBGViewListFormCommonHelper.getOrgMember(sheetManager, row, col);
    }

    private static BgDimensionMember getOrgMember(MbgViewListRowCol object) {
        return MBGViewListFormCommonHelper.getOrgMember(object);
    }

    public static void clearViewlistDesEntries(Connection conn, IDimDataQuery bgFormInfo) throws SQLException, EASBizException {
        if (conn == null || bgFormInfo == null) {
            return;
        }
        BgDBUtils.executeUpdate((Connection)conn, (String)"delete From T_MBG_MbgViewListDesCell Where FID IN(Select FViewListDesId FROM T_MBG_MbgViewListDesCellEntry Where FBgFormId = ?)", (Object[])new Object[]{bgFormInfo.getId().toString()});
        BgDBUtils.executeUpdate((Connection)conn, (String)"delete From T_MBG_MbgViewListDesCellEntry where FBgFormId = ?", (Object[])new Object[]{bgFormInfo.getId().toString()});
    }

    public static void clearViewlistDesEntries(Context ctx, String bgTemplateId) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            MbgViewListDescriptionHelper.clearViewlistDesEntries(conn, bgTemplateId);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static void clearViewlistDesEntries(Connection conn, String bgTemplateId) throws SQLException, EASBizException {
        BgDBUtils.executeUpdate((Connection)conn, (String)"delete From T_MBG_MbgViewListDesCell Where FID IN(Select FViewListDesId FROM T_MBG_MbgViewListDesCellEntry Where FBgFormId = ?)", (Object[])new Object[]{bgTemplateId});
        BgDBUtils.executeUpdate((Connection)conn, (String)"delete From T_MBG_MbgViewListDesCellEntry where FBgFormId = ?", (Object[])new Object[]{bgTemplateId});
    }

    public static void clearEditNote(Connection conn, IDimDataQuery bgFormInfo) throws SQLException, EASBizException {
        if (conn == null || bgFormInfo == null) {
            return;
        }
        BgDBUtils.executeUpdate((Connection)conn, (String)"delete From T_MBG_MbgViewListEditNote where FBgFormID = ?", (Object[])new Object[]{bgFormInfo.getId().toString()});
    }

    public static void clearBgCommentRef(Connection conn, IDimDataQuery bgFormInfo) throws SQLException, EASBizException {
        if (conn == null || bgFormInfo == null) {
            return;
        }
        BgDBUtils.executeUpdate((Connection)conn, (String)"delete From T_MBG_BgCommentRef where FBgFormId = ?", (Object[])new Object[]{bgFormInfo.getId().toString()});
        Object[] objs = new Object[]{bgFormInfo.getBizBgScheme().getId().toString()};
        BgDBUtils.executeUpdate((Connection)conn, (String)"delete From T_MBG_BgComment Where FBgSchemeId = ? and not exists (Select de.fid From T_MBG_BgCommentRef de Where de.FBgCommentId = T_MBG_BgComment.fid)", (Object[])objs);
        BgDBUtils.executeUpdate((Connection)conn, (String)"delete From T_MBG_BgCommentEntry Where  not exists (Select de.fid From T_MBG_BgCommentRef de Where de.FBgCommentId = T_MBG_BgCommentEntry.FBgCommentId)");
    }

    public static BgFormCollection getBgFormColls(Context ctx, BgFormInfo bgForm, Set<String> curOrgNums, SelectorItemCollection sic, boolean isId) throws BOSException {
        if (bgForm == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        if (sic == null || sic.isEmpty()) {
            sic = new SelectorItemCollection();
            sic.add("id");
        }
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        state.add(new Integer(5));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("state", state, CompareType.NOTINCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgForm.getBgScheme().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplate.root.id", (Object)bgForm.getBgTemplate().getRootId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgForm.getBgPeriod().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("currency.id", (Object)bgForm.getCurrency().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)bgForm.getBgVersion().getId().toString()));
        if (isId) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", curOrgNums, CompareType.INCLUDE));
        } else {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.number", curOrgNums, CompareType.INCLUDE));
        }
        if (ctx == null) {
            return BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
        }
        return BgFormFactory.getLocalInstance(ctx).getBgFormCollection(evi);
    }

    public static boolean checkCellViewListDescription(Cell cell) {
        return cell != null && (MbgViewListDescriptionHelper.checkHashDescriptionFormula(cell) || ViewListHelper.getDimension(cell.getRowObject()) instanceof MbgViewListDescription || ViewListHelper.getDimension(cell.getSheet().getColumn(cell.getCol(), false)) instanceof MbgViewListDescription) && !(ViewListHelper.getHeadCellValue(cell) instanceof MbgViewListDescription);
    }

    public static boolean checkCellViewListDescriptionIsNumeric(Cell cell) {
        return MbgViewListDescriptionHelper.checkCellViewListDescription(cell) && (BgNFSHelper.checkIsNumericOfCell(cell) || cell.getValue() != null && BgNFSHelper.isPercentageNumerical(cell.getValue().getValue()));
    }
}

