/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.logger.MbgLoggerUtils;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MultiQueryCacheUtils {
    private static Logger logger = Logger.getLogger((String)MultiQueryCacheUtils.class.getName());
    private Map<String, Map<String, Set<String>>> memberCache = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, Boolean> globalMap = new HashMap<String, Boolean>();
    private Map<String, Map<String, Set<String>>> closureMap = new HashMap<String, Map<String, Set<String>>>();

    public static MultiQueryCacheUtils getIntance() {
        return new MultiQueryCacheUtils();
    }

    private boolean isGlobal(Connection conn, String viewId) throws BOSException {
        if (this.globalMap.isEmpty()) {
            IRowSet rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"Select FID, FSegregationRule FROM T_MBG_MbgView");
                while (rst.next()) {
                    this.globalMap.put(rst.getString("FID"), 1 == rst.getInt("FSegregationRule"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst);
            }
            if (this.globalMap.isEmpty()) {
                this.globalMap.put("000000000000000000000000000=", true);
            }
        }
        return Boolean.TRUE.equals(this.globalMap.get(viewId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> queryMembers(Context ctx, Connection conn, Collection<String> viewIds, Collection<String> orgUnitIds, IDimensionParameter parameter) throws Exception {
        HashMap<String, Set<String>> viewMembers = new HashMap<String, Set<String>>();
        if (ctx == null || conn == null || viewIds == null || viewIds.isEmpty() || orgUnitIds == null || orgUnitIds.isEmpty() || parameter == null) {
            return viewMembers;
        }
        TempTablePool pool = parameter.getTempTableManager(ctx).getTempTablePool();
        String tmpOrgUnit = null;
        String viewId2 = null;
        String number = null;
        String orgUnitId2 = null;
        Set memberSet = null;
        Map<String, Set<String>> subCache = null;
        StringBuffer sql = new StringBuffer();
        PreparedStatement pstmt = null;
        PreparedStatement noGlobalPst = null;
        PreparedStatement globalPst = null;
        ResultSet rst = null;
        boolean isGlobal = false;
        HashSet<String> _orgUnitIds = new HashSet<String>();
        HashSet<String> _needQueryOrgIds = new HashSet<String>();
        try {
            tmpOrgUnit = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_1 (FID VARCHAR(44) NOT NULL Primary Key, FNeedQuery INT)");
            if (tmpOrgUnit != null) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgUnit + " (FID) values (?)"), new HashSet<String>(orgUnitIds));
            }
            sql.append("select FViewId, FNumber, FOrgUnitId from T_MBG_MbgMember where FViewId = ? and  exists (select FID from " + tmpOrgUnit + " where FID = T_MBG_MbgMember.FOrgUnitId AND FNeedQuery = 1)");
            noGlobalPst = conn.prepareStatement(sql.toString());
            globalPst = conn.prepareStatement("select FViewId, FNumber, FOrgUnitId from T_MBG_MbgMember where FViewId = ?");
            for (String viewId2 : viewIds) {
                subCache = this.memberCache.get(viewId2);
                if (subCache == null) {
                    subCache = new HashMap<String, Set<String>>();
                    this.memberCache.put(viewId2, subCache);
                }
                _needQueryOrgIds.clear();
                _orgUnitIds.clear();
                isGlobal = this.isGlobal(conn, viewId2);
                if (isGlobal) {
                    pstmt = globalPst;
                    orgUnitId2 = "00000000-0000-0000-0000-000000000000CCE7AED4";
                    _orgUnitIds.add(orgUnitId2);
                    if (!this.memberCache.containsKey(viewId2) || !this.memberCache.get(viewId2).containsKey(orgUnitId2)) {
                        _needQueryOrgIds.add(orgUnitId2);
                    }
                } else {
                    pstmt = noGlobalPst;
                    _orgUnitIds.addAll(orgUnitIds);
                    for (String orgUnitId2 : _orgUnitIds) {
                        if (subCache.containsKey(orgUnitId2)) continue;
                        _needQueryOrgIds.add(orgUnitId2);
                    }
                }
                if (!_needQueryOrgIds.isEmpty()) {
                    if (!isGlobal) {
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpOrgUnit + " Set FNeedQuery = 0"));
                        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                        for (String id : _needQueryOrgIds) {
                            paramList.add(new Object[]{id});
                        }
                        BgDBUtils.executeBatch((Connection)conn, (String)("Update " + tmpOrgUnit + " Set FNeedQuery = 1 Where FID = ?"), paramList);
                    }
                    pstmt.setString(1, viewId2);
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        if (!isGlobal) {
                            orgUnitId2 = rst.getString("FOrgUnitId");
                        }
                        number = rst.getString("FNumber");
                        if (!subCache.containsKey(orgUnitId2)) {
                            subCache.put(orgUnitId2, new HashSet());
                        }
                        subCache.get(orgUnitId2).add(number);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                if (viewMembers.containsKey(viewId2)) {
                    memberSet = (Set)viewMembers.get(viewId2);
                } else {
                    memberSet = new HashSet();
                    viewMembers.put(viewId2, memberSet);
                }
                for (String orgUnitId2 : _orgUnitIds) {
                    if (!subCache.containsKey(orgUnitId2)) {
                        subCache.put(orgUnitId2, new HashSet());
                    }
                    memberSet.addAll(subCache.get(orgUnitId2));
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            SQLUtils.cleanup(noGlobalPst);
            SQLUtils.cleanup(globalPst);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpOrgUnit);
            throw throwable;
        }
        SQLUtils.cleanup(rst);
        SQLUtils.cleanup((Statement)noGlobalPst);
        SQLUtils.cleanup((Statement)globalPst);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpOrgUnit);
        return viewMembers;
    }

    private Map<String, Set<String>> getChildMap(Connection conn, String closureTable) throws BOSException {
        block6: {
            if (this.closureMap.containsKey(closureTable)) break block6;
            MbgLoggerUtils.logger((String)("start Load closureTable:" + closureTable));
            HashMap<String, Set<String>> childMap = new HashMap<String, Set<String>>();
            this.closureMap.put(closureTable, childMap);
            IRowSet rst = null;
            String FID = null;
            String FChildId = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("Select FID, FChildId FROM " + closureTable));
                while (rst.next()) {
                    FID = rst.getString("FID");
                    FChildId = rst.getString("FChildId");
                    if (!childMap.containsKey(FID)) {
                        childMap.put(FID, new HashSet());
                    }
                    ((Set)childMap.get(FID)).add(FChildId);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            MbgLoggerUtils.logger((String)("end Load closureTable:" + closureTable));
            return childMap;
        }
        return this.closureMap.get(closureTable);
    }

    public String querySubData(Context ctx, Connection conn, MbgDimInfo mbgDim, BOSUuid viewId, Collection<String> queryNums, Collection<String> insertNums) throws BOSException, EASBizException {
        String tmpSubTable = null;
        String closureTable = MbgVirtualView.getClosureTable((String)MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)viewId));
        Map<String, Set<String>> childMap = this.getChildMap(conn, closureTable);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        HashSet<String> dimNumSet = new HashSet<String>(queryNums.size());
        for (String string : queryNums) {
            dimNumSet.add(MultiQueryCacheUtils.getDimNumber(mbgDim.getSrcNumber(), string));
        }
        HashSet<String> memberSet = new HashSet<String>();
        try {
            for (String number : dimNumSet) {
                if (!childMap.containsKey(number)) continue;
                memberSet.addAll((Collection)childMap.get(number));
            }
            if (insertNums != null && !insertNums.isEmpty()) {
                dimNumSet.clear();
                for (String number : insertNums) {
                    dimNumSet.add(MultiQueryCacheUtils.getDimNumber(mbgDim.getSrcNumber(), number));
                }
                memberSet.addAll(dimNumSet);
            }
            tmpSubTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"Create Table TEML_KSQL_1 (FNumber NVARCHAR(84))");
            if (!memberSet.isEmpty()) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpSubTable + " (FNumber) Values (?)"), memberSet);
            }
        }
        catch (SQLException sQLException) {
            logger.error((Object)"sql error:", (Throwable)sQLException);
            throw new BOSException((Throwable)sQLException);
        }
        catch (Exception exception) {
            logger.error((Object)"sql error:", (Throwable)exception);
            throw new BOSException((Throwable)exception);
        }
        return tmpSubTable;
    }

    private static String getDimNumber(String srcNumber, String number) {
        return srcNumber + BgBaseConstants.SEP_FOUR_STR + number;
    }
}

