/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgDecomposeFacadeFactory;
import com.kingdee.eas.ma.mbg.BgDecomposeFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.IBgDecomposeFacade;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RangeDecomposeParamFilter {
    private BgDecomposeFormInfo info;
    private Set<String> subOrgIds;
    private Context ctx;
    private Map<String, Set<String>> formulas = new HashMap<String, Set<String>>();
    public boolean isFilter = false;

    public Map<String, Set<String>> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(Map<String, Set<String>> formulas) {
        this.formulas = formulas;
    }

    public RangeDecomposeParamFilter(Context ctx) {
        this.ctx = ctx;
    }

    public void doDecomposeParamFilter(BgDecomposeFormInfo info, Set<String> subOrgIds) throws Exception {
        if (!BgTemFormTypeEnum.VIEWLIST.equals((Object)info.getBgForm().getBgTemplate().getFormType())) {
            return;
        }
        if (!this.isFilter()) {
            return;
        }
        this.formulas = this.getBgDecomposeFacade().getSameFormByOrg((IObjectValue)info, subOrgIds);
    }

    private Set<String> parseDimSetData(Set<String> formulas) {
        HashSet<String> dimSet = new HashSet<String>();
        if (formulas == null || formulas.isEmpty()) {
            return dimSet;
        }
        String formulaStr2 = null;
        String[] params = null;
        for (String formulaStr2 : formulas) {
            params = BgNFSHelper.parseFormulaPara(formulaStr2);
            dimSet.add(params[0]);
        }
        return dimSet;
    }

    public static Map<String, Set<String>> parseFormluaData(BgSchemeDimensionHelper helper, Set<String> formulas) {
        HashMap<String, Set<String>> dimMap = new HashMap<String, Set<String>>();
        Map<String, BgDimensionInfo> dimensionBySrcNumber = helper.getDimensionBySrcNumber();
        for (String dimNumber : helper.getDimensions().keySet()) {
            dimMap.put(dimNumber, new HashSet());
        }
        if (formulas == null || formulas.isEmpty()) {
            return dimMap;
        }
        String formulaStr2 = null;
        String[] params = null;
        for (String formulaStr2 : formulas) {
            params = BgNFSHelper.parseFormulaPara(formulaStr2);
            String combinNumber = params[0];
            String[] splits = combinNumber.split(",");
            for (int s = 0; s < splits.length; ++s) {
                String dimNumber = splits[s];
                String[] numbers = dimNumber.split(":");
                ((Set)dimMap.get(dimensionBySrcNumber.get(numbers[0]).getNumber())).add(numbers[1]);
            }
            ((Set)dimMap.get(DimensionBaseConstants.DEF_PERIOD_NUMBER)).add(params[1]);
            ((Set)dimMap.get(DimensionBaseConstants.DEF_ELEMENT_NUMBER)).add(params[2]);
            ((Set)dimMap.get(DimensionBaseConstants.DEF_CURRENCY_NUMBER)).add(params[5]);
            ((Set)dimMap.get(DimensionBaseConstants.DEF_SCENARIO_NUMBER)).add(params[3]);
        }
        return dimMap;
    }

    public boolean checkIsExists(BgOrgUnitInfo OrgInfo, String dimMember) throws BOSException {
        Set<String> formulas = this.getFormulas().get(OrgInfo.getOrgUnitID());
        Set<String> dimSetData = this.parseDimSetData(formulas);
        return !dimSetData.isEmpty() && dimSetData.contains(dimMember);
    }

    public static RangeDecomposeParamFilter newInstance(Context ctx) {
        return new RangeDecomposeParamFilter(ctx);
    }

    private IBgDecomposeFacade getBgDecomposeFacade() throws BOSException {
        return null == this.ctx ? BgDecomposeFacadeFactory.getRemoteInstance() : BgDecomposeFacadeFactory.getLocalInstance(this.ctx);
    }

    public boolean isFilter() throws BOSException {
        IRowSet rs = null;
        String sql = "select FValue from T_MBG_Param where Fnumber = 'RangeDecomposeParamFilter'";
        try {
            ISQLExecutor executor = this.ctx != null ? SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sql) : SQLExecutorFactory.getRemoteInstance((String)sql);
            rs = executor.executeSQL();
            if (rs.next()) {
                this.isFilter = Boolean.parseBoolean(rs.getString(1));
            }
        }
        catch (SQLException var) {
            try {
                throw new BOSException((Throwable)var);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return this.isFilter;
    }
}

