/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.calcRow.ColExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.ExprParseHelper;
import com.kingdee.eas.ma.mbg.common.calcRow.IExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.RowExpr;
import com.kingdee.util.StringUtils;
import java.util.List;

public class ViewListCalculatorUtils {
    public static String convertFormula(MbgViewListSheetManager sheetManager, String formula, int curIndex) {
        if (StringUtils.isEmpty((String)formula)) {
            return "";
        }
        StringBuffer formulaStr = new StringBuffer("=");
        List<IExpr> exprs = ExprParseHelper.parse(formula);
        for (int i = 0; i < exprs.size(); ++i) {
            if (exprs.get(i) instanceof RowExpr) {
                formulaStr.append(ViewListCalculatorUtils.convertRowColExpr(sheetManager, ((RowExpr)exprs.get(i)).getRow() - 1, curIndex, true));
                continue;
            }
            if (exprs.get(i) instanceof ColExpr) {
                formulaStr.append(ViewListCalculatorUtils.convertRowColExpr(sheetManager, ((ColExpr)exprs.get(i)).getCol() - 1, curIndex, false));
                continue;
            }
            formulaStr.append(exprs.get(i).getFormula());
        }
        return formulaStr.toString();
    }

    private static String convertRowColExpr(MbgViewListSheetManager sheetManager, int rowColIndex, int curIndex, boolean isRow) {
        List<IMbgViewListObject> rowCols = null;
        rowCols = isRow ? sheetManager.getDimensionManager().getRows() : sheetManager.getDimensionManager().getColumns();
        if (rowCols.size() > rowColIndex && rowCols.get(rowColIndex) instanceof MbgViewListRowCol) {
            MbgViewListRowCol rowObject = (MbgViewListRowCol)rowCols.get(rowColIndex);
            if (isRow) {
                return ViewListCalculatorUtils.convertSumExpr(rowObject.getStartIndex(), curIndex, rowObject.getEndIndex(), curIndex);
            }
            return ViewListCalculatorUtils.convertSumExpr(curIndex, rowObject.getStartIndex(), curIndex, rowObject.getEndIndex());
        }
        return "0";
    }

    private static String convertSumExpr(int startRowIndex, int startColIndex, int endRowIndex, int endColIndex) {
        if (startRowIndex == endRowIndex && startColIndex == endColIndex) {
            return SheetBaseMath.getBlockA1Name((int)startRowIndex, (int)startColIndex, (boolean)false, (boolean)false);
        }
        return "SUM(" + SheetBaseMath.getBlockA1Name((int)startRowIndex, (int)startColIndex, (int)endRowIndex, (int)endColIndex, (boolean)false) + ")";
    }
}

