/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.eas.ma.base.utils.BgPropertyHelper;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.action.actions.viewListForm.ActionInsertRow;
import com.kingdee.eas.ma.mbg.client.autoFilter.DimensionMemberAutoFilterButton;
import com.kingdee.eas.ma.mbg.client.autoFilter.DimensionMemberAutoFilterHelper;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.template.ViewListBookContextManager;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterInfo;
import com.kingdee.eas.ma.mbg.common.ExpandMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.ViewListMemberRender;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class ViewlistCombinHelper {
    public static final String COMBIN_MEMBER = "COMBIN_MEMBER";
    public static final String COMBIN_NEW_ROW = "COMBIN_NEW_ROW";
    public static final String COMBIN_OLD_MEMBER = "COMBIN_OLD_MEMBER";

    public static void setCombinCellMember(ViewListProvider provider, Cell cell, BgDimensionMember oneMember) {
        if (provider == null || provider.getBgDimensionManager() == null || cell == null || oneMember == null) {
            return;
        }
        MbgViewListDimensionManager dimensionManager = provider.getBgDimensionManager();
        MbgViewListDimensionMember viewListMember = MbgViewListDimensionMember.getInstance(oneMember);
        String showType = null;
        showType = oneMember instanceof BgDimensionMember ? DimensionCommonHelper.searchDimension(oneMember.getType(), dimensionManager.getDimension()).getShowType() : DimensionCommonHelper.searchDimension(viewListMember.getType(), dimensionManager.getDimension()).getShowType();
        ExpandMember expandMember = (ExpandMember)ViewListMemberRender.createExpaneMember(viewListMember);
        if (expandMember instanceof ExpandMember) {
            expandMember.setLevel(0);
            ViewListHelper.setHeadCell(cell, expandMember, showType);
        } else {
            ViewListHelper.setHeadCell(cell, oneMember, showType);
        }
    }

    public static void fillProperty(ViewListProvider provider, Sheet sheet, int startRowIndex, int endRowIndex) {
        if (sheet == null || startRowIndex <= 0 || startRowIndex > endRowIndex) {
            return;
        }
        int maxCol = sheet.getMaxColIndex();
        for (int rIndex = startRowIndex; rIndex <= endRowIndex; ++rIndex) {
            Row row = sheet.getRow(rIndex, false);
            for (int cIndex = 0; cIndex <= maxCol; ++cIndex) {
                BgDimensionMember member;
                UserObject object;
                Cell _cell = row.getCell(cIndex, false);
                if (_cell == null || (object = _cell.getUserObject("dimensino.member")) == null || (member = BgDimensionParseCommonHelper.getMember(object.getValue())) == null) continue;
                MbgViewListDimensionMember viewListMember = MbgViewListDimensionMember.getInstance(member);
                ViewlistCombinHelper.fillProperty(provider, viewListMember, _cell);
            }
        }
    }

    private static void fillProperty(ViewListProvider provider, MbgViewListDimensionMember viewListMember, Cell cell) {
        Map<String, Map<String, String>> propMaps = provider.getPropMaps();
        if (propMaps == null || propMaps.isEmpty() || viewListMember == null) {
            return;
        }
        Sheet sheet = cell.getSheet();
        int maxCol = sheet.getMaxColIndex();
        int rowIndex = cell.getRow();
        Cell _cell = null;
        IMbgViewListObject colObject = null;
        MbgViewListAtribute attribute = null;
        MbgViewListAtribute oldAttribute = null;
        String key = null;
        String memberNumber = viewListMember.getNumber();
        for (int colIndex = 0; colIndex < maxCol; ++colIndex) {
            Column column = sheet.getColumn(colIndex, false);
            colObject = ViewListHelper.getDimension(column);
            _cell = sheet.getCell(rowIndex, colIndex, false);
            if (colObject == null || !(colObject instanceof MbgViewListAtribute) || _cell == null) continue;
            attribute = (MbgViewListAtribute)colObject;
            if (attribute.getPropertySort().getId() != null) {
                key = attribute.getDimNumber() + "_" + attribute.getPropertySort().getId();
            } else {
                String dimNumber = attribute.getDimNumber();
                key = attribute.getPropertySort().getNumber().equals(BgPropertyHelper.genDimNamePropertySortNumber((String)dimNumber)) ? attribute.getDimNumber() + "_" + BgPropertyHelper.genDimNamePropertySortNumber((String)dimNumber) : attribute.getDimNumber() + "_" + BgPropertyHelper.genDimDescPropertySortNumber((String)dimNumber);
            }
            if (!propMaps.containsKey(key)) continue;
            if (propMaps.get(key).containsKey(memberNumber) && !StringUtils.isEmpty((String)viewListMember.getType()) && attribute.getDimNumber().equals(viewListMember.getType())) {
                BgNFSHelper.setValue(_cell, propMaps.get(key).get(memberNumber));
                _cell.setUserObject("dimensino.member", (Object)attribute);
            } else if (_cell.getUserObject("dimensino.member") != null && _cell.getUserObject("dimensino.member").getValue() instanceof MbgViewListAtribute) {
                oldAttribute = (MbgViewListAtribute)_cell.getUserObject("dimensino.member").getValue();
                if (viewListMember.getType().equals(oldAttribute.getDimNumber())) {
                    BgNFSHelper.setValue(_cell, null);
                }
            } else {
                BgNFSHelper.setValue(_cell, null);
            }
            BgNFSHelper.setCellLocked(null, _cell, true);
        }
    }

    public static void setCombinMember(Row row, BgDimensionMember combinMember) {
        BgNFSHelper.setRowObject(row, COMBIN_MEMBER, combinMember);
    }

    public static BgDimensionMember getCombinMember(Row row) {
        return (BgDimensionMember)BgNFSHelper.getRowObject(row, COMBIN_MEMBER);
    }

    public static BgDimensionMember getCombinOldMember(Row row) {
        return (BgDimensionMember)BgNFSHelper.getRowObject(row, COMBIN_OLD_MEMBER);
    }

    public static void setCombinOldMember(Row row, BgDimensionMember combinMember) {
        BgNFSHelper.setRowObject(row, COMBIN_OLD_MEMBER, combinMember);
    }

    public static Boolean checkHasCombin(MbgViewListManager viewManager) {
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            List<IMbgViewListObject> rows = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getRows();
            for (int index = 0; index < rows.size(); ++index) {
                if (!(rows.get(index) instanceof MbgViewListRowCol) || !((MbgViewListRowCol)rows.get(index)).isCombin()) continue;
                return true;
            }
        }
        return false;
    }

    public static Boolean checkValueModeIsNullButEmptyMember(MbgViewListManager viewManager) {
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            List<IMbgViewListObject> rows = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getRows();
            for (int index = 0; index < rows.size(); ++index) {
                if (!(rows.get(index) instanceof MbgViewListRowCol)) continue;
                MbgViewListRowCol row = (MbgViewListRowCol)rows.get(index);
                List<MbgViewListDimensionInfo> dimensions = row.getDimensions();
                for (MbgViewListDimensionInfo dim : dimensions) {
                    if (!dim.getMemberValueType().equals((Object)DimensionMemberValueModeEnum.Null) || dim.getMember().size() != 0 || !dim.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Boolean checkRowIsCombin(Cell cell) {
        if (cell == null) {
            return false;
        }
        return ViewlistCombinHelper.checkRowIsCombin(cell.getRowObject());
    }

    public static Boolean checkRowIsCombin(Row row) {
        Boolean isCombin = false;
        if (row != null && ViewListHelper.getDimension(row) instanceof MbgViewListRowCol && ((MbgViewListRowCol)ViewListHelper.getDimension(row)).isCombin()) {
            isCombin = true;
        }
        return isCombin;
    }

    public static void setSelectedCell(Cell cell) {
        if (cell == null) {
            return;
        }
        cell.getSheet().getSheetOption().getSelection().clear();
        cell.getSheet().getSheetOption().getSelection().setActiveCell(cell.getRow(), cell.getCol());
        CellBlock newBlock = CellBlock.getNewCellBlock((int)cell.getRow(), (int)cell.getCol());
        cell.getSheet().getSheetOption().getSelection().changeSelection(newBlock, 2);
    }

    public static List<BgDimensionMember> getViewMembers(MbgViewListDimensionManager dimensionManager, List<KDPromptBox> viewF7List) {
        return BgViewHelper.getCurrPageMember(viewF7List, dimensionManager.getViewDimension());
    }

    public static List<BgDimensionMember> getPageMembers(MbgViewListDimensionManager dimensionManager, List<KDPromptBox> pageF7List) {
        return BgViewHelper.getCurrPageMember(pageF7List, dimensionManager.getPageDimension());
    }

    public static boolean checkCombinRowFullofMembers(Row row, Boolean isSetDimensionMember) {
        Boolean isFull = true;
        if (row == null) {
            return false;
        }
        HashMap<String, Boolean> dimMap = new HashMap<String, Boolean>();
        ArrayList<BgDimensionMember> memberSet = new ArrayList<BgDimensionMember>();
        HashMap<String, BgDimensionMember> dimNumMemberMap = new HashMap<String, BgDimensionMember>();
        BgDimensionMember member = null;
        Sheet sheet = row.getSheet();
        int maxCol = sheet.getMaxColIndex();
        for (int i = 0; i <= maxCol; ++i) {
            Object obj;
            Cell _cell = sheet.getCell(row.getRow(), i, false);
            if (_cell == null || ViewListHelper.getCombinDimension(_cell) == null) continue;
            Boolean isCellEmptyValue = BgNFSHelper.checkIsEmptyValue(_cell);
            dimMap.put(ViewListHelper.getCombinDimension(_cell).getNumber(), isCellEmptyValue);
            if (isCellEmptyValue.booleanValue() || ViewListHelper.getHeadCellValue(_cell) == null || (member = BgDimensionParseCommonHelper.getMember(obj = ViewListHelper.getHeadCellValue(_cell))) == null) continue;
            memberSet.add(member);
            dimNumMemberMap.put(member.getType(), member);
        }
        if (dimMap.isEmpty()) {
            isFull = false;
        } else {
            Iterator ite = dimMap.values().iterator();
            while (ite.hasNext()) {
                if (!((Boolean)ite.next()).booleanValue()) continue;
                isFull = false;
                break;
            }
            if (isFull.booleanValue() && isSetDimensionMember.booleanValue() && !memberSet.isEmpty() && memberSet.size() == dimMap.size()) {
                ViewListHelper.setDimensionMember(row, memberSet.toArray());
                BgDimensionMember combinMember = ViewlistCombinHelper.getCombinMemberByDimMember(row);
                ViewlistCombinHelper.setCombinMember(row, combinMember);
                ViewlistCombinHelper.reParseRowCol(row, false);
            }
        }
        return isFull;
    }

    private static void reParseRowCol(Row row, boolean isSingleSelectMember) {
        if (row == null) {
            return;
        }
        MbgViewListRowCol oldRowCol = (MbgViewListRowCol)ViewListHelper.getDimension(row);
        Sheet sheet = row.getSheet();
        int startIndex = oldRowCol.getStartIndex();
        int endIndex = oldRowCol.getEndIndex();
        BgDimensionMember tCombinMember = null;
        HashMap tMemberMap = new HashMap();
        if (!isSingleSelectMember) {
            oldRowCol.getCombinMembers().clear();
        }
        oldRowCol.getCombinMembers().clear();
        for (int index = startIndex; index <= endIndex; ++index) {
            Row tRow = sheet.getRow(index, false);
            if (oldRowCol != ViewListHelper.getDimension(tRow) || tRow == null) continue;
            BgDimensionMember bgDimensionMember = tCombinMember = ViewlistCombinHelper.getCombinMember(tRow) != null ? ViewlistCombinHelper.getCombinMember(tRow) : ViewlistCombinHelper.getCombinMemberByDimMember(tRow);
            if (tCombinMember != null) {
                oldRowCol.getCombinMembers().add(tCombinMember);
            }
            BgDimensionMember[] members = ViewListHelper.getDimensionMember(tRow);
            BgDimensionMember tMember = null;
            if (members == null) continue;
            for (int i = 0; i < members.length; ++i) {
                tMember = members[i];
                if (tMember == null || tMember.getType() == null) continue;
                if (!tMemberMap.containsKey(tMember.getType())) {
                    tMemberMap.put(tMember.getType(), new HashSet());
                }
                ((Set)tMemberMap.get(tMember.getType())).add(tMember);
            }
        }
        List<MbgViewListDimensionInfo> dimList = oldRowCol.getDimensions();
        for (int i = 0; i < dimList.size(); ++i) {
            MbgViewListDimensionInfo dimInfo = dimList.get(i);
            if (!tMemberMap.containsKey(dimInfo.getNumber())) continue;
            dimInfo.getMember().clear();
            dimInfo.getMember().addAll((Collection)tMemberMap.get(dimInfo.getNumber()));
            try {
                dimInfo.unParseMember();
                continue;
            }
            catch (DimensionException e) {
                e.printStackTrace();
            }
        }
    }

    public static Set<Integer> checkCombinRowsFullofMembers(Sheet sheet, int startRowIndex, int endRowIndex, Boolean isSetDimensionMember, boolean isSingleSelectMember) {
        HashSet<Integer> fullRowIndexs = new HashSet<Integer>();
        if (sheet == null) {
            return fullRowIndexs;
        }
        HashMap<String, Boolean> dimMap = null;
        ArrayList<BgDimensionMember> memberSet = null;
        HashMap<String, BgDimensionMember> dimNumMemberMap = null;
        BgDimensionMember member = null;
        int maxCol = sheet.getMaxColIndex();
        for (int rowIndex = startRowIndex; rowIndex <= endRowIndex; ++rowIndex) {
            Row row = sheet.getRow(rowIndex, false);
            dimMap = new HashMap<String, Boolean>();
            memberSet = new ArrayList<BgDimensionMember>();
            dimNumMemberMap = new HashMap<String, BgDimensionMember>();
            boolean isFull = true;
            for (int i = 0; i <= maxCol; ++i) {
                Cell _cell = sheet.getCell(row.getRow(), i, false);
                if (_cell == null || ViewListHelper.getCombinDimension(_cell) == null) continue;
                Boolean isCellEmptyValue = BgNFSHelper.checkIsEmptyValue(_cell);
                dimMap.put(ViewListHelper.getCombinDimension(_cell).getNumber(), isCellEmptyValue);
                Object obj = ViewListHelper.getHeadCellValue(_cell);
                member = BgDimensionParseCommonHelper.getMember(obj);
                memberSet.add(member);
                if (member == null) continue;
                dimNumMemberMap.put(member.getType(), member);
            }
            if (dimMap.isEmpty()) {
                isFull = false;
                continue;
            }
            Iterator ite = dimMap.values().iterator();
            while (ite.hasNext()) {
                if (!((Boolean)ite.next()).booleanValue()) continue;
                isFull = false;
                break;
            }
            if (!isSetDimensionMember.booleanValue() || memberSet.isEmpty() || memberSet.size() != dimMap.size()) continue;
            ViewListHelper.setDimensionMember(row, memberSet.toArray());
            BgDimensionMember combinMember = ViewlistCombinHelper.getCombinMemberByDimMember(row);
            ViewlistCombinHelper.setCombinMember(row, combinMember);
            if (!isFull) continue;
            ViewlistCombinHelper.reParseRowCol(row, isSingleSelectMember);
            fullRowIndexs.add(rowIndex);
        }
        return fullRowIndexs;
    }

    private static void reParseRowCol(Sheet sheet, int startRowIndex, int endRowIndex) {
        HashSet<MbgViewListRowCol> rowObjs = new HashSet<MbgViewListRowCol>();
        Row row = null;
        MbgViewListRowCol rowObject = null;
        for (int rIndex = startRowIndex; rIndex <= endRowIndex; ++rIndex) {
            row = sheet.getRow(rIndex, false);
            if (ViewListHelper.getDimension(row) instanceof MbgViewListRowCol) {
                rowObject = (MbgViewListRowCol)ViewListHelper.getDimension(row);
            }
            if (rowObjs.contains(rowObject)) continue;
            rowObjs.add(rowObject);
        }
        if (rowObjs.isEmpty()) {
            return;
        }
        for (MbgViewListRowCol oldRowCol : rowObjs) {
            int startIndex = oldRowCol.getStartIndex();
            int endIndex = oldRowCol.getEndIndex();
            BgDimensionMember tCombinMember = null;
            HashMap tMemberMap = new HashMap();
            oldRowCol.getCombinMembers().clear();
            for (int index = startIndex; index <= endIndex; ++index) {
                Row tRow = sheet.getRow(index, false);
                if (tRow == null) continue;
                tCombinMember = ViewlistCombinHelper.getCombinMember(tRow);
                if (tCombinMember != null) {
                    oldRowCol.getCombinMembers().add(tCombinMember);
                }
                BgDimensionMember[] members = ViewListHelper.getDimensionMember(tRow);
                BgDimensionMember tMember = null;
                if (members == null) continue;
                for (int i = 0; i < members.length; ++i) {
                    tMember = members[i];
                    if (tMember == null || StringUtils.isEmpty((String)tMember.getType()) || StringUtils.isEmpty((String)tMember.getNumber())) continue;
                    if (!tMemberMap.containsKey(tMember.getType())) {
                        tMemberMap.put(tMember.getType(), new HashSet());
                    }
                    ((Set)tMemberMap.get(tMember.getType())).add(tMember);
                }
            }
            List<MbgViewListDimensionInfo> dimList = oldRowCol.getDimensions();
            for (int i = 0; i < dimList.size(); ++i) {
                MbgViewListDimensionInfo dimInfo = dimList.get(i);
                if (!tMemberMap.containsKey(dimInfo.getNumber())) continue;
                dimInfo.getMember().clear();
                dimInfo.getMember().addAll((Collection)tMemberMap.get(dimInfo.getNumber()));
                try {
                    dimInfo.unParseMember();
                    continue;
                }
                catch (DimensionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void reParseCombinRowBySheet(MbgViewListDimensionManager dimensionManager, Sheet sheet) {
        if (dimensionManager == null || sheet == null) {
            return;
        }
        HashMap tmpMap = new HashMap();
        MbgViewListRowCol rowObject = null;
        int maxRowIndex = sheet.getMaxRowIndex();
        for (int rowIndex = 0; rowIndex <= maxRowIndex; ++rowIndex) {
            Row row = sheet.getRow(rowIndex, false);
            if (!ViewlistCombinHelper.checkRowIsCombin(row).booleanValue() || !(rowObject = (MbgViewListRowCol)ViewListHelper.getDimension(row)).isCombin()) continue;
            String key = ViewlistCombinHelper.getKey(rowObject);
            BgDimensionMember combinMember = ViewlistCombinHelper.getCombinMember(row);
            if (combinMember == null) {
                combinMember = ViewlistCombinHelper.getCombinMemberByDimMember(row);
            }
            if (combinMember == null || rowObject == null) continue;
            if (!tmpMap.containsKey(key)) {
                tmpMap.put(key, new ArrayList());
            }
            ((List)tmpMap.get(key)).add(combinMember);
        }
        List<IMbgViewListObject> rows = dimensionManager.getRows();
        for (int i = 0; i < rows.size(); ++i) {
            String key;
            if (!(rows.get(i) instanceof MbgViewListRowCol) || !tmpMap.containsKey(key = ViewlistCombinHelper.getKey(rowObject = (MbgViewListRowCol)rows.get(i)))) continue;
            rowObject.getCombinMembers().clear();
            rowObject.getCombinMembers().addAll((Collection)tmpMap.get(key));
            ViewlistCombinHelper.parseCombinMembers(rowObject);
        }
    }

    public static String getKey(MbgViewListRowCol row) {
        BgDimensionBaseInfo orgDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, row.getDimensions());
        if (orgDim != null && !orgDim.getMember().isEmpty()) {
            return ((BgDimensionMember)orgDim.getMember().get(0)).getNumber() + "," + row.getIndex();
        }
        return String.valueOf(row.getIndex());
    }

    public static void checkIsSelectRow(Selection sel) {
        if (sel == null) {
            return;
        }
        Selection.SelectIterator si = sel.getSelectIterator();
        while (si.hasNext()) {
            CellBlock cb = si.next();
            if (!cb.isCol()) continue;
            JOptionPane.showMessageDialog(null, MultiLanguageKeys.getLocalText((String)"KEY_MULTI_ROW_INS_ERROR_CONTENT"), MultiLanguageKeys.getLocalText((String)"KEY_MULTI_ROW_INS_ERROR_TITLE"), 0);
            SysUtil.abort();
        }
    }

    public boolean checkSelect(Selection sel) {
        if (sel == null) {
            return false;
        }
        Selection.SelectIterator si = sel.getSelectIterator();
        while (si.hasNext()) {
            CellBlock cb = si.next();
            if (!cb.isCol()) continue;
            return false;
        }
        return true;
    }

    public static Boolean isRowHasData(Row row, Sheet sheet) {
        Boolean isHasData = false;
        if (row == null || sheet == null) {
            return isHasData;
        }
        Cell cell = null;
        boolean hasBgFormula = false;
        Sheet.ICellsIterator ite = row.getCellsIterator(0, sheet.getMaxColIndex(), false, false);
        while (ite.hasNext()) {
            cell = ite.next();
            BigDecimal value = BgViewHelper.getNumeric(cell, null);
            hasBgFormula = BgNFSHelper.checkHasFormulaOfCell(cell);
            if (value == null || !hasBgFormula) continue;
            isHasData = true;
            break;
        }
        return isHasData;
    }

    public static void reSetStartAndEndIndex(Sheet sheet, MbgViewListDimensionManager dimensionManager) {
        int rowIndex;
        if (sheet == null) {
            return;
        }
        List<IMbgViewListObject> rows = dimensionManager.getRows();
        MbgViewListRowCol rowCol = null;
        for (int i = 0; i < rows.size(); ++i) {
            if (!(rows.get(i) instanceof MbgViewListRowCol)) continue;
            rowCol = (MbgViewListRowCol)rows.get(i);
            rowCol.setStartIndex(-1);
            rowCol.setEndIndex(-1);
        }
        Row row = null;
        for (rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
            row = sheet.getRow(rowIndex, false);
            if (!(ViewListHelper.getDimension(row) instanceof MbgViewListRowCol)) continue;
            rowCol = (MbgViewListRowCol)ViewListHelper.getDimension(row);
            rowCol.setStartIndex(-1);
            rowCol.setEndIndex(-1);
        }
        for (rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
            row = sheet.getRow(rowIndex, false);
            if (!(ViewListHelper.getDimension(row) instanceof MbgViewListRowCol)) continue;
            rowCol = (MbgViewListRowCol)ViewListHelper.getDimension(row);
            if (rowCol.getStartIndex() < 0 || rowCol.getStartIndex() > rowIndex) {
                rowCol.setStartIndex(rowIndex);
            }
            if (rowCol.getEndIndex() >= 0 && rowCol.getEndIndex() >= rowIndex) continue;
            rowCol.setEndIndex(rowIndex);
        }
    }

    public static void parseCombinMembers(MbgViewListRowCol row, Map<String, Map<String, BgDimensionMember>> queryMembers) {
        List<Object[]> members;
        if (!(!row.isCombin() || row.getCombinMembers().isEmpty() && row.getCombinSelectMembers().isEmpty() || (members = ViewlistCombinHelper.getDimMembersByCombinMembers(row)).isEmpty())) {
            HashMap tmpMap = new HashMap();
            for (int i = 0; i < members.size(); ++i) {
                Object[] memberArr = members.get(i);
                for (int j = 0; j < memberArr.length; ++j) {
                    if (!(memberArr[j] instanceof MbgViewListDimensionMember)) continue;
                    MbgViewListDimensionMember curMember = (MbgViewListDimensionMember)memberArr[j];
                    if (queryMembers == null || queryMembers.isEmpty() || !queryMembers.containsKey(curMember.getType()) || !queryMembers.get(curMember.getType()).containsKey(curMember.getNumber())) continue;
                    curMember.setSortValue(queryMembers.get(curMember.getType()).get(curMember.getNumber()).getSortValue());
                    curMember.setLongName(queryMembers.get(curMember.getType()).get(curMember.getNumber()).getLongName());
                    curMember.setLeaf(queryMembers.get(curMember.getType()).get(curMember.getNumber()).isLeaf());
                    curMember.setLevel(queryMembers.get(curMember.getType()).get(curMember.getNumber()).getLevel());
                    if (!tmpMap.containsKey(curMember.getType())) {
                        tmpMap.put(curMember.getType(), new ArrayList());
                    }
                    ((List)tmpMap.get(curMember.getType())).add(curMember);
                }
            }
            if (tmpMap.isEmpty()) {
                return;
            }
            for (int d = 0; d < row.getDimensions().size(); ++d) {
                MbgViewListDimensionInfo dimension = row.getDimensions().get(d);
                dimension.getMember().clear();
                if (!tmpMap.containsKey(dimension.getNumber())) continue;
                List subList = (List)tmpMap.get(dimension.getNumber());
                dimension.getMember().addAll(subList);
            }
        }
    }

    public static void parseCombinMembers(MbgViewListRowCol row) {
        ViewlistCombinHelper.parseCombinMembers(row, true);
    }

    public static void parseCombinMembers(MbgViewListRowCol row, boolean isClearOtherDimMembers) {
        List<Object[]> members;
        if (!(!row.isCombin() || row.getCombinMembers().isEmpty() && row.getCombinSelectMembers().isEmpty() || (members = ViewlistCombinHelper.getDimMembersByCombinMembers(row)).isEmpty())) {
            HashMap tmpMap = new HashMap();
            for (int i = 0; i < members.size(); ++i) {
                Object[] memberArr = members.get(i);
                for (int j = 0; j < memberArr.length; ++j) {
                    if (!(memberArr[j] instanceof MbgViewListDimensionMember)) continue;
                    MbgViewListDimensionMember curMember = (MbgViewListDimensionMember)memberArr[j];
                    if (!tmpMap.containsKey(curMember.getType())) {
                        tmpMap.put(curMember.getType(), new ArrayList());
                    }
                    ((List)tmpMap.get(curMember.getType())).add(curMember);
                }
            }
            if (tmpMap.isEmpty()) {
                return;
            }
            for (int d = 0; d < row.getDimensions().size(); ++d) {
                MbgViewListDimensionInfo dimension = row.getDimensions().get(d);
                if (!isClearOtherDimMembers) continue;
                dimension.getMember().clear();
                if (!tmpMap.containsKey(dimension.getNumber())) continue;
                List subList = (List)tmpMap.get(dimension.getNumber());
                dimension.getMember().addAll(subList);
            }
        }
    }

    private static void setLevelConfig(MbgViewListDimensionMember member, MbgViewListRowCol rowObject) {
        if (member == null || rowObject == null) {
            return;
        }
        if (member.getType().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
            member.setLevel(0);
        }
    }

    public static BgDimensionMember getCombinMemberByDimMember(Row row) {
        BgDimensionMember newMember = null;
        if (row == null) {
            return newMember;
        }
        BgDimensionMember[] rowMembers = ViewListHelper.getDimensionMember(row);
        return ViewlistCombinHelper.getCombinMemberByDimMember(rowMembers);
    }

    public static BgDimensionMember getCombinMemberByDimMember(BgDimensionMember[] rowMembers) {
        return DimensionCommonHelper.getCombinMemberByDimMember(rowMembers);
    }

    public static List<Object[]> getDimMembersByCombinMembers(MbgViewListRowCol object) {
        return DimensionCommonHelper.getDimMembersByCombinMembers(object);
    }

    public static List<BgDimensionMember[]> getDimMembersByCombinMembers(List<MbgViewListDimensionInfo> dims, List combinMembers, boolean isCombinSelect) {
        int i;
        ArrayList<BgDimensionMember[]> members = new ArrayList<BgDimensionMember[]>();
        BgDimensionMember[] objects = null;
        HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>();
        MbgViewListDimensionInfo dim = null;
        boolean isHasOrgDim = false;
        List orgMember = null;
        for (i = 0; i < dims.size(); ++i) {
            if (!(dims.get(i) instanceof MbgViewListDimensionInfo)) continue;
            dimIndexMap.put(dims.get(i).getNumber(), i);
        }
        for (i = 0; i < dims.size(); ++i) {
            dim = dims.get(i);
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
            isHasOrgDim = true;
            orgMember = dim.getMember();
            if (orgMember == null || orgMember.isEmpty()) break;
            for (int x = 0; x < orgMember.size(); ++x) {
                if (!(orgMember.get(x) instanceof MbgViewListDimensionMember)) continue;
                ((MbgViewListDimensionMember)orgMember.get(x)).setLevel(0);
            }
            break;
        }
        int dimCount = dims.size();
        for (int i2 = 0; i2 < combinMembers.size(); ++i2) {
            BgDimensionMember comMember = (BgDimensionMember)combinMembers.get(i2);
            String[] numbers = DimensionFormulaHelper.splitCombinations(comMember.getNumber());
            String[] srcNumbers = DimensionFormulaHelper.splitCombinations(comMember.getSrcNumber());
            String[] types = DimensionFormulaHelper.splitCombinations(comMember.getType());
            String[] attributes = DimensionFormulaHelper.splitCombinations(comMember.getAttribute());
            String[] names = comMember.getName().split(DimensionConstants.TICK_SEPARATOR, -1);
            objects = new BgDimensionMember[dimCount];
            for (int m = 0; m < numbers.length; ++m) {
                MbgViewListDimensionMember newMember = new MbgViewListDimensionMember(types[m], attributes[m], names[m], numbers[m]);
                if (srcNumbers != null) {
                    newMember.setSrcNumber(srcNumbers[m]);
                }
                if (!dimIndexMap.containsKey(types[m])) continue;
                objects[((Integer)dimIndexMap.get((Object)types[m])).intValue()] = newMember;
            }
            if (isCombinSelect && isHasOrgDim && dimIndexMap.containsKey(DimensionConstants.DEF_ORGUNIT_NUMBER) && orgMember != null && !orgMember.isEmpty()) {
                if (orgMember.get(0) instanceof MbgViewListDimensionMember) {
                    objects[((Integer)dimIndexMap.get((Object)DimensionConstants.DEF_ORGUNIT_NUMBER)).intValue()] = (MbgViewListDimensionMember)orgMember.get(0);
                } else if (orgMember.get(0) instanceof BgDimensionMember) {
                    objects[((Integer)dimIndexMap.get((Object)DimensionConstants.DEF_ORGUNIT_NUMBER)).intValue()] = MbgViewListDimensionMember.getInstance((BgDimensionMember)orgMember.get(0));
                }
            }
            members.add(objects);
        }
        return members;
    }

    public static void removeDataChengeListeners(KDBizPromptBox box) {
        if (box == null) {
            return;
        }
        DataChangeListener[] listeners = (DataChangeListener[])box.getListeners(DataChangeListener.class);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            box.removeDataChangeListener(listeners[i]);
        }
        SelectorListener[] listeners1 = (SelectorListener[])box.getListeners(SelectorListener.class);
        for (int i = listeners1.length - 2; i >= 0; i -= 2) {
            box.removeSelectorListener(listeners1[i]);
        }
    }

    public static void removeAllConbinBox(BgSpreadCoreViewUI baseUI) {
        if (baseUI != null && baseUI.getContextManager() instanceof ViewListBookContextManager) {
            ViewListBookContextManager contextManager = (ViewListBookContextManager)baseUI.getContextManager();
            contextManager.removeCombinBoxs();
        }
    }

    public static void sortMap(Map<Integer, Row> selectRowMap) {
        if (selectRowMap == null) {
            return;
        }
        Collections.sort(new ArrayList<Integer>(selectRowMap.keySet()), new Comparator(){

            public int compare(Object o1, Object o2) {
                return (Integer)o2 - (Integer)o1;
            }
        });
    }

    public static Map<MbgViewListRowCol, Map<Integer, Row>> getSelectRowMap(Sheet sheet) {
        LinkedHashMap<MbgViewListRowCol, Map<Integer, Row>> selectRowMap = new LinkedHashMap<MbgViewListRowCol, Map<Integer, Row>>();
        if (sheet == null) {
            return selectRowMap;
        }
        Range rangeSel = sheet.getSelectionRange();
        for (int i = 0; i < rangeSel.size(); ++i) {
            CellBlock block = rangeSel.getBlock(i);
            for (int r = block.getRow(); r <= block.getRow2(); ++r) {
                MbgViewListRowCol rowObject;
                Row row = sheet.getRow(r, true);
                if (row == null || !(ViewListHelper.getDimension(row) instanceof MbgViewListRowCol) || (rowObject = (MbgViewListRowCol)ViewListHelper.getDimension(row)) == null || !rowObject.isCombin()) continue;
                if (!selectRowMap.containsKey(rowObject)) {
                    selectRowMap.put(rowObject, new LinkedHashMap());
                }
                ((Map)selectRowMap.get(rowObject)).put(r, row);
            }
        }
        return selectRowMap;
    }

    public static void insertRows(Sheet sheet, ViewListProvider provider, MbgViewListDimensionManager dimensionManager, BookContextManager contextManager, int needNewRowCount, boolean isLoadFromDB) {
        ActionInsertRow actionInsertRow = new ActionInsertRow();
        actionInsertRow.setSheet(sheet);
        actionInsertRow.setProvide(provider);
        actionInsertRow.setDimensionManager(dimensionManager);
        actionInsertRow.doBatchInsertRow(ViewlistCombinHelper.getSelectRowMap(sheet), contextManager.getSpreadContext(), needNewRowCount, isLoadFromDB);
        contextManager.getSpreadContext().getSpread().repaint();
    }

    public static void setInsertRowFlag(Row row) {
        BgNFSHelper.setRowObject(row, COMBIN_NEW_ROW, COMBIN_NEW_ROW);
    }

    public static boolean isInsertRow(Row row) {
        return BgNFSHelper.getRowObject(row, COMBIN_NEW_ROW) != null;
    }

    public static void clearInsertRowFlag(Book book) {
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            int maxRowIndex = sheet.getMaxRowIndex();
            for (int r = 0; r < maxRowIndex; ++r) {
                Row row = sheet.getRow(r, false);
                if (row == null || !ViewlistCombinHelper.checkRowIsCombin(row).booleanValue() || !ViewlistCombinHelper.isInsertRow(row)) continue;
                BgNFSHelper.clearRowSign(row, COMBIN_NEW_ROW);
            }
        }
    }

    public static int getColumnCount(KDSSheet sheet) {
        if (sheet != null) {
            for (int c = sheet.getColumnCount() - 1; c >= 0; --c) {
                for (int r = 0; r < sheet.getRowCount(); ++r) {
                    KDSCell cell = sheet.getCell(r, c, false);
                    if (cell == null || cell.getValue() == null || cell.getValue().toString().trim().length() <= 0) continue;
                    return c + 1;
                }
            }
        }
        return 0;
    }

    public static void reloadMemberfilter(BookContextManager context, ViewListProvider provider, MbgViewListDimensionManager dimensionManager, Sheet sheet) {
        DimensionMemberFilterInfo memberFilter = provider.getMemberFilter();
        if (!memberFilter.isEnableFilter()) {
            return;
        }
        List lst = dimensionManager.getRowDimension();
        HashSet<String> dimNumbers = new HashSet<String>();
        for (int i = 0; i < lst.size(); ++i) {
            if (!(lst.get(i) instanceof BgDimensionBaseInfo)) continue;
            dimNumbers.add(((BgDimensionBaseInfo)lst.get(i)).getNumber());
        }
        if (!dimNumbers.isEmpty()) {
            HashMap<String, BgDimensionBaseInfo> dimMap = new HashMap<String, BgDimensionBaseInfo>();
            String dimNumber2 = null;
            BgDimensionBaseInfo curDimension = null;
            for (String dimNumber2 : dimNumbers) {
                curDimension = DimensionCommonHelper.searchDimension(dimNumber2, dimensionManager);
                dimMap.put(dimNumber2, curDimension);
            }
            int maxCol = sheet.getMaxColIndex();
            int maxRow = sheet.getMaxRowIndex();
            for (int rIndex = 0; rIndex <= maxRow; ++rIndex) {
                for (int cIndex = 0; cIndex <= maxCol; ++cIndex) {
                    Cell cell = sheet.getCell(rIndex, cIndex, false);
                    if (cell == null || (curDimension = DimensionMemberAutoFilterHelper.getFilterDimension(cell)) == null || !dimMap.containsKey(curDimension.getNumber())) continue;
                    DimensionMemberAutoFilterHelper.setFilterDimension(cell, (BgDimensionBaseInfo)dimMap.get(curDimension.getNumber()));
                }
            }
            KDSpread spread = context.getSpreadContext().getSpread();
            int fhC = spread.getFixHorizonCount();
            int fvC = spread.getFixVerticalCount();
            int hC = spread.getHorizonCount();
            int vC = spread.getVerticalCount();
            for (int i = fvC; i < vC; ++i) {
                for (int j = fhC; j < hC; ++j) {
                    SpreadView sv = (SpreadView)spread.getView(i, j);
                    for (int c = sv.getComponentCount() - 1; c >= 0; --c) {
                        DimensionMemberAutoFilterButton button;
                        if (!(sv.getComponent(c) instanceof DimensionMemberAutoFilterButton) || (curDimension = (button = (DimensionMemberAutoFilterButton)((Object)sv.getComponent(c))).getFilterUI().getDimension()) == null || !dimMap.containsKey(curDimension.getNumber())) continue;
                        button.getFilterUI().setDimension((BgDimensionBaseInfo)dimMap.get(curDimension.getNumber()));
                    }
                }
            }
        }
    }

    public static boolean isHasHidedCombinMember(MbgViewListRowCol rowObject) {
        boolean hasHidedCombinMember = false;
        if (rowObject != null && !rowObject.getCombinMembers().isEmpty()) {
            List<BgDimensionMember> combinMembers = rowObject.getCombinMembers();
            Iterator<BgDimensionMember> ite = combinMembers.iterator();
            while (ite.hasNext()) {
                if (!ite.next().isHide()) continue;
                hasHidedCombinMember = true;
                break;
            }
        }
        return hasHidedCombinMember;
    }

    public static boolean membersEqual(BgDimensionMember m1, BgDimensionMember m2) {
        if (m1 == m2) {
            return true;
        }
        return m1 != null && m2 != null && m1.toString().equals(m2.toString());
    }
}

