/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.analysisReport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateCollection;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateFactory;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateInfo;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateNodeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgAnalysRptTemplate;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAnalysRptDispatchUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.utils.BgAnalysRptDispatchUtils");
    public static final String RESOURCE_STR = "com.kingdee.eas.ma.mbg.client.BgSchemeDispatchResource";
    public static final String RES = "com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource";
    private static int MSGLENGTH = 7;

    public static BgAnalysRptTemplateCollection getBgTemplateColls(String bgSchemeId, String orgUnitId) throws BOSException {
        return BgAnalysRptDispatchUtils.getBgTemplateColls(null, bgSchemeId, orgUnitId);
    }

    public static BgAnalysRptTemplateCollection getBgTemplateColls(Context ctx, String bgSchemeId, String orgUnitId) throws BOSException {
        BgAnalysRptTemplateCollection colls = new BgAnalysRptTemplateCollection();
        if (StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgUnitId)) {
            return colls;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)("Select FBgAnalysRptTemplateID FROM T_MBg_BgAnalysRptTemplateNode Where FOrgUnitId = '" + orgUnitId + "'"), CompareType.INNER));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgAnalysRptDispatchUtils.getSelectBgTemplate());
        view.getSorter().add(new SorterItemInfo("number"));
        IBgAnalysRptTemplate iBgTemplate = null;
        iBgTemplate = ctx == null ? BgAnalysRptTemplateFactory.getRemoteInstance() : BgAnalysRptTemplateFactory.getLocalInstance(ctx);
        return iBgTemplate.getBgAnalysRptTemplateCollection(view);
    }

    public static SelectorItemCollection getSelectBgTemplate() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgScheme.id");
        sic.add("id");
        sic.add("templateStatus");
        sic.add("number");
        sic.add("name");
        sic.add("root.id");
        sic.add("createtime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("creator.number");
        sic.add("lastupdatetime");
        sic.add("lastupdateuser.id");
        sic.add("lastupdateuser.name");
        sic.add("lastupdateuser.number");
        return sic;
    }

    public static CompanyOrgUnitCollection getCompanyOrgUnit() throws BOSException {
        return BgAnalysRptDispatchUtils.getCompanyOrgUnit(null);
    }

    public static CompanyOrgUnitCollection getCompanyOrgUnit(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("number");
        ICompanyOrgUnit iCompany = null;
        iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return iCompany.getCompanyOrgUnitCollection(view);
    }

    public static List<String[]> dispatchTemplate(Context ctx, BgSchemeInfo bgScheme, BgAnalysRptTemplateInfo bgTemplate, List<String> orgUnitIds, Map<String, FullOrgUnitInfo> orgUnitMap, String treeID) throws BOSException, EASBizException {
        if (ctx == null || bgScheme == null || bgTemplate == null || orgUnitIds == null || orgUnitIds.isEmpty() || orgUnitMap == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        FullOrgUnitInfo orgUnit = null;
        String _bgSchemeId = bgScheme.getId().toString();
        String _bgTemplateId = bgTemplate.getId().toString();
        Object _dispTemplateId = null;
        String sqlTree = "";
        BOSObjectType type = new BgAnalysRptTemplateNodeInfo().getBOSType();
        ArrayList<String[]> paramList = null;
        Object[] objectTree = null;
        Connection conn = null;
        try {
            Object[] objectArray;
            conn = BgDBUtils.getConnection((Context)ctx);
            String string = sqlTree = treeID == null ? "FTreeID is null" : "FTreeID = ?";
            if (treeID == null) {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = bgTemplate.getNumber();
                objectArray2[1] = _bgTemplateId;
                objectArray = objectArray2;
                objectArray2[2] = _bgSchemeId;
            } else {
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = bgTemplate.getNumber();
                objectArray3[1] = _bgTemplateId;
                objectArray3[2] = _bgSchemeId;
                objectArray = objectArray3;
                objectArray3[3] = treeID;
            }
            objectTree = objectArray;
            StringBuffer sql = new StringBuffer("Select FOrgUnitId FROM T_MBG_BgAnalysRptTemplateNode Where FBgAnalysRptTemplateID IN (Select FID FROM T_MBG_BgAnalysRptTemplate Where FNumber = ? AND FID <> ? AND FBgSchemeId = ?) AND " + sqlTree + "  AND FOrgUnitId IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            paramList = MbgSqlHelper.getBatchParams((Object[])objectTree, (Object[])orgUnitIds.toArray(), (int)50);
            List orgNumberRepeat = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)paramList);
            paramList = new ArrayList<String[]>();
            for (String _orgUnitId : orgUnitIds) {
                orgUnit = orgUnitMap.get(_orgUnitId);
                if (orgUnit == null) continue;
                if (orgNumberRepeat.contains(_orgUnitId)) {
                    result.add(BgAnalysRptDispatchUtils.getDispatchResult(bgTemplate, (OrgUnitInfo)orgUnit, false, BgSchemeDispatchConstants.DISPATCH_FAIL_NUMBER));
                    continue;
                }
                paramList.add(new String[]{BOSUuid.create((BOSObjectType)type).toString(), _orgUnitId, treeID, _bgTemplateId, _bgTemplateId, _orgUnitId});
                result.add(BgAnalysRptDispatchUtils.getDispatchResult(bgTemplate, (OrgUnitInfo)orgUnit, true, BgSchemeDispatchConstants.DISPATCH_SUCCESS));
            }
            if (!paramList.isEmpty()) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Insert Into T_MBG_BgAnalysRptTemplateNode(FID, FBgAnalysRptTemplateID, FOrgUnitId, FTreeID) Select ?, FID, ?, ? FROM T_MBG_BgAnalysRptTemplate Where FID = ? AND NOT EXISTS (Select FID FROM T_MBG_BgAnalysRptTemplateNode Where FBgAnalysRptTemplateID = ? AND FOrgUnitId = ?)", paramList);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    public static SelectorItemCollection getBgSchemeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("dateFrom");
        sic.add("dateTo");
        sic.add("period");
        sic.add("isFormal");
        sic.add("refDims.id");
        sic.add("refDims.bgDimName");
        sic.add("refDims.bgDimNumber");
        return sic;
    }

    public static SelectorItemCollection getBgTemplateSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("templateStatus");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("root.id");
        return sic;
    }

    public static Map<String, FullOrgUnitInfo> getOrgUnitInfo(Context ctx, List<String> orgUnitIds, String treeId) throws BOSException, EASBizException {
        if (orgUnitIds == null || orgUnitIds.isEmpty()) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        HashMap<String, FullOrgUnitInfo> orgUnitMap = new HashMap<String, FullOrgUnitInfo>();
        FullOrgUnitInfo _unitInfo = null;
        int index = 0;
        int size = orgUnitIds.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _id = null;
        String _cuId = null;
        StringBuffer sql = new StringBuffer();
        String tableName = treeId == null ? "T_ORG_CostCenter" : "t_org_baseunit";
        sql.append("select FId, FName_" + ctx.getLocale() + ", FNumber, FControlUnitId from " + tableName + " where FId IN (");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= 50) {
                    if (pos < size) {
                        pstmt.setString(k, orgUnitIds.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _id = rst.getString("FId");
                    _cuId = rst.getString("FControlUnitId");
                    _unitInfo = new FullOrgUnitInfo();
                    _unitInfo.setId(BOSUuid.read((String)_id));
                    _unitInfo.setName(rst.getString(2));
                    _unitInfo.setNumber(rst.getString("FNumber"));
                    _unitInfo.setCU(new CtrlUnitInfo());
                    _unitInfo.getCU().setId(BOSUuid.read((String)_cuId));
                    orgUnitMap.put(_id, _unitInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return orgUnitMap;
    }

    public static String[] getDispatchResult(BgAnalysRptTemplateInfo template, OrgUnitInfo orgUnit, boolean isSuccess, String resultStr, String param) {
        String[] result = new String[MSGLENGTH];
        result[0] = String.valueOf(isSuccess);
        result[1] = resultStr;
        result[2] = template.getNumber();
        result[3] = template.getName();
        result[4] = orgUnit.getNumber();
        result[5] = orgUnit.getName();
        result[6] = param;
        return result;
    }

    public static String[] getDispatchResult(BgAnalysRptTemplateInfo template, OrgUnitInfo orgUnit, boolean isSuccess, String resultStr) {
        String[] result = new String[MSGLENGTH];
        result[0] = String.valueOf(isSuccess);
        result[1] = resultStr;
        result[2] = template.getNumber();
        result[3] = template.getName();
        result[4] = orgUnit.getNumber();
        result[5] = orgUnit.getName();
        return result;
    }

    public static String[] getDispatchResult(BgAnalysRptTemplateInfo template, boolean isSuccess, String resultStr) {
        String[] result = new String[MSGLENGTH];
        result[0] = String.valueOf(isSuccess);
        result[1] = resultStr;
        result[2] = template.getNumber();
        result[3] = template.getName();
        return result;
    }

    public static String[] getDispatchResult(boolean isSuccess, String resultStr) {
        String[] result = new String[MSGLENGTH];
        result[0] = String.valueOf(isSuccess);
        result[1] = resultStr;
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<BOSUuid> dispatchCheckRefBgForm(Context ctx, BOSUuid bgSchemeId, BOSUuid bgTemplateRootId, List<String> orgUnitIds, String treeID) throws BOSException {
        HashSet<BOSUuid> refBgTemplateIdSet = new HashSet<BOSUuid>();
        if (ctx == null) return refBgTemplateIdSet;
        if (bgTemplateRootId == null) return refBgTemplateIdSet;
        if (orgUnitIds == null) {
            return refBgTemplateIdSet;
        }
        String _bgTemplateRootId = bgTemplateRootId.toString();
        int index = 0;
        int size = orgUnitIds.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FOrgUnitId from T_MBG_BgAnalysReport f where f.FBgTemplateID = ? and f.FOrgUnitId IN (");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, _bgTemplateRootId);
                for (int k = 2; k <= 51; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, orgUnitIds.get(pos));
                        continue;
                    }
                    pstmt.setString(k, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    refBgTemplateIdSet.add(BOSUuid.read((String)rst.getString("FOrgUnitId")));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"dispatchCheckRefBgForm Error: ", (Throwable)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"dispatchCheckRefBgForm Error: ", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return refBgTemplateIdSet;
    }
}

