/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.data.BizMbgDataControlUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AuditParam {
    private static final Logger logger = Logger.getLogger(AuditParam.class);
    public static final int AUDIT_TYPE_SUBMIT = -1;
    public static final int AUDIT_TYPE_AUDIT = 0;
    public static final int AUDIT_TYPE_UNAUDIT = 1;
    public static final int AUDIT_TYPE_UNIONREPORT = 2;
    public static final int AUDIT_TYPE_UNUNIONREPORT = 3;
    public static final int AUDIT_TYPE_RECEIVE = 4;
    public static final int AUDIT_TYPE_UNRECEIVE = 5;
    public static final int AUDIT_TYPE_UNIONBACK = 6;
    public static final int AUDIT_TYPE_COURSE = 7;
    public static final int AUDIT_TYPE_BACK = 8;
    public static final int AUDIT_TYPE_CERTIFICATE = 9;
    public static final int AUDIT_TYPE_UNCERTIFICATE = 10;
    public static final int AUDIT_TYPE_AUDITCANCEL = 11;
    public Context ctx = null;
    public TempTablePool pool = null;
    public int auditType = 0;
    public String tmpOrgUnit = null;
    public String tmpPOrgUnit = null;
    public String tmpBgIndex = null;
    public String tmpBgPeriod = null;
    public String tmpBgElement = null;
    public String tmpCurrency = null;
    public String tmpScenario = null;
    public Map<String, String> tmpExtMap = new HashMap<String, String>();
    public String tmpDataId = null;
    public String tmpAudOrgUnit = null;
    public String tmpBillIds = null;
    public String audSchemeId = null;
    public String audOrgUnitId = null;
    public String audUserId = null;
    public int audState = 0;
    public int audFormState = 0;
    public String currtBillId = null;
    public BOSUuid bgOrgViewId = null;
    public String unionId = null;
    public String cubeName = null;
    public String cubeEntry = null;
    public Set<String> cubes = new HashSet<String>();
    public BgOrgUnitInfo audOrgUnit = null;
    public BgSchemeInfo bgScheme = null;
    public Set<String> auditMbgDims = null;
    public boolean isSynChildForm = true;
    public Map<String, IDimDataQuery> billMap = new HashMap<String, IDimDataQuery>();
    public Map<BOSUuid, IMbgViewBase> mbgViewCache = new HashMap<BOSUuid, IMbgViewBase>();
    public Map<String, BgOrgUnitInfo> bgOrgUnitMap = new HashMap<String, BgOrgUnitInfo>();
    public Map<String, MbgDimInfo> mbgDims = new HashMap<String, MbgDimInfo>();
    public Map<String, MbgDimInfo> srcDims = new HashMap<String, MbgDimInfo>();
    public final Map<String, Map<String, String[]>> noEditFormMap = new HashMap<String, Map<String, String[]>>();
    public final Map<String, Set<String>> parentOrgNumbers = new HashMap<String, Set<String>>();
    private BgSchemeAccIntHelper accIntHelper = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private boolean isInit = false;

    public AuditParam(Context ctx) {
        this.ctx = ctx;
        this.pool = TempTablePool.getInstance((Context)ctx);
    }

    public IDimDataQuery getCacheValue(Connection conn, String billId, BizMbgDataControlUtils utils) throws Exception {
        IDimDataQuery model = this.billMap.get(billId);
        if (model == null) {
            model = utils.queryData(this.ctx, conn, billId);
            this.billMap.put(billId, model);
        }
        return model;
    }

    public IMbgViewBase getCacheView(Context ctx, IDimDataQuery model) throws Exception {
        if (ctx == null || model == null) {
            return null;
        }
        IMbgViewBase view = this.mbgViewCache.get(model.getId());
        if (view == null) {
            long begin = System.currentTimeMillis();
            logger.debug((Object)("begin parse model view : number = '" + model.getNumber() + "' !"));
            view = model.getView(ctx, this.bgScheme);
            this.mbgViewCache.put(model.getId(), view);
            logger.debug((Object)("end parse model view : number = '" + model.getNumber() + "' ! use = " + (System.currentTimeMillis() - begin) + "ms."));
        }
        return view;
    }

    public void convertParams(Map<String, String> auditParams) {
        if (auditParams != null) {
            this.isSynChildForm = !Boolean.FALSE.toString().equalsIgnoreCase(auditParams.get("AUDIT_SYN_CHILD"));
        }
    }

    public BgSchemeAccIntHelper getAccIntHelper() throws EASBizException, BOSException {
        if (this.accIntHelper == null || !this.accIntHelper.getSchemeHelper().getBgSchemeId().equals(this.getSchemeHelper().getBgSchemeId()) || !this.accIntHelper.getBgDataTable().equals(this.cubeName)) {
            this.accIntHelper = new BgSchemeAccIntHelper(this.ctx, this.getSchemeHelper(), this.cubeName);
        }
        return this.accIntHelper;
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null || !this.schemeHelper.getBgSchemeId().equals(this.audSchemeId)) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.ctx, this.audSchemeId);
        }
        return this.schemeHelper;
    }

    public void initTmpTable() throws Exception {
        if (this.isInit) {
            return;
        }
        if (this.tmpBgIndex == null) {
            this.tmpBgIndex = BgDBUtils.createTmpTable((TempTablePool)this.pool, (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84), FIntID INT)");
            BgDBUtils.createIndex((TempTablePool)this.pool, (String)this.tmpBgIndex, (String)"FNumber", (boolean)false, (boolean)false);
            BgDBUtils.createIndex((TempTablePool)this.pool, (String)this.tmpBgIndex, (String)"FIntID", (boolean)false, (boolean)false);
        }
        if (this.tmpBgPeriod == null) {
            this.tmpBgPeriod = BgDBUtils.createTmpTable((TempTablePool)this.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntID INT)");
            BgDBUtils.createIndex((TempTablePool)this.pool, (String)this.tmpBgPeriod, (String)"FID", (boolean)false, (boolean)false);
            BgDBUtils.createIndex((TempTablePool)this.pool, (String)this.tmpBgIndex, (String)"FIntID", (boolean)false, (boolean)false);
        }
        if (this.tmpBgElement == null) {
            this.tmpBgElement = BgDBUtils.createTmpTable((TempTablePool)this.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntID INT)");
            BgDBUtils.createIndex((TempTablePool)this.pool, (String)this.tmpBgElement, (String)"FID", (boolean)false, (boolean)false);
            BgDBUtils.createIndex((TempTablePool)this.pool, (String)this.tmpBgElement, (String)"FIntID", (boolean)false, (boolean)false);
        }
        if (this.tmpCurrency == null) {
            this.tmpCurrency = BgDBUtils.createTmpTable((TempTablePool)this.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.createIndex((TempTablePool)this.pool, (String)this.tmpCurrency, (String)"FID", (boolean)false, (boolean)false);
        }
        if (this.tmpScenario == null) {
            this.tmpScenario = BgDBUtils.createTmpTable((TempTablePool)this.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
            BgDBUtils.createIndex((TempTablePool)this.pool, (String)this.tmpScenario, (String)"FID", (boolean)false, (boolean)false);
        }
        this.initTmpExtTable();
        this.isInit = true;
    }

    public void initTmpExtTable() throws BOSException, EASBizException, Exception {
        if (!this.auditMbgDims.isEmpty()) {
            String tmpTable = null;
            for (String mbgDimNumber : this.auditMbgDims) {
                if (DimensionBaseConstants.DEF_INDEX_NUMBER.equals(mbgDimNumber) || this.unionId == null && DimensionBaseConstants.DEF_CSL_NUMBER.equals(mbgDimNumber) || this.tmpExtMap.containsKey(mbgDimNumber)) continue;
                tmpTable = BgDBUtils.createTmpTable((TempTablePool)this.pool, (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84), FIntID INT)");
                BgDBUtils.createIndex((TempTablePool)this.pool, (String)tmpTable, (String)"FNumber", (boolean)false, (boolean)false);
                BgDBUtils.createIndex((TempTablePool)this.pool, (String)tmpTable, (String)"FIntID", (boolean)false, (boolean)false);
                this.tmpExtMap.put(mbgDimNumber, tmpTable);
            }
        }
    }

    public String getTmpBgIndex() throws Exception {
        this.initTmpTable();
        return this.tmpBgIndex;
    }

    public String getTmpBgPeriod() throws Exception {
        this.initTmpTable();
        return this.tmpBgPeriod;
    }

    public String getTmpBgElement() throws Exception {
        this.initTmpTable();
        return this.tmpBgElement;
    }

    public String getTmpCurrency() throws Exception {
        this.initTmpTable();
        return this.tmpCurrency;
    }

    public String getTmpScenario() throws Exception {
        this.initTmpTable();
        return this.tmpScenario;
    }

    public Map<String, String> getTmpExtMap() throws Exception {
        this.initTmpExtTable();
        return this.tmpExtMap;
    }

    public String getField(String field) throws EASBizException, BOSException {
        if (this.getAccIntHelper().isUseAccInt()) {
            return "FIntID";
        }
        return field;
    }

    public void release() {
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.tmpOrgUnit);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.tmpPOrgUnit);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.tmpBgIndex);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.tmpBgPeriod);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.tmpBgElement);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.tmpCurrency);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.tmpScenario);
        if (this.tmpExtMap != null && !this.tmpExtMap.isEmpty()) {
            Iterator<String> iter = this.tmpExtMap.values().iterator();
            while (iter.hasNext()) {
                BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)iter.next());
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.tmpDataId);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.tmpAudOrgUnit);
        BgDBUtils.releaseTmpTable((TempTablePool)this.pool, (String)this.tmpBillIds);
    }
}

