/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNActualRecordProcessUI;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Map;

public class BgActualRecordDisplayValueProvider
implements IDisplayValueProvider {
    private BgNActualRecordProcessUI ui = null;

    private BgActualRecordDisplayValueProvider() {
    }

    public BgActualRecordDisplayValueProvider(Component component) {
        if (component != null && component instanceof BgNActualRecordProcessUI) {
            this.ui = (BgNActualRecordProcessUI)((Object)component);
        }
    }

    public BigDecimal getCoefficient() {
        return this.ui.getMeasureUnit().getCoefficient();
    }

    public int getPrecision() {
        return this.ui.getBgFormInfo().getCurrency().getPrecision();
    }

    public Map getMeasureUnitMap() {
        return this.ui.getMeasureUnitMap();
    }

    public Map getCurrencyMap() {
        return this.ui.getCurrencyMap();
    }

    public Map getFormulaMap() {
        return this.ui.getFormulaMap();
    }

    public Object getDisplayValue(Cell cell, int viewMode) {
        if (cell != null) {
            if (viewMode == 0) {
                if (!BgNFSHelper.checkIsEmptyValue(cell)) {
                    if (cell.getValue().getValue() instanceof GregorianCalendar) {
                        return cell.getText();
                    }
                    String _text = cell.getText();
                    if (!StringUtils.isEmpty((String)_text)) {
                        if ("#DIV/0!".equals(_text) || _text.indexOf("#BAD FUNCTION") >= 0) {
                            Object obj = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
                            if (obj instanceof ReportCalculateErrorProvider) {
                                ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj;
                                if ("#DIV/0!".equals(_text)) {
                                    return rcep.getZeroDivDisplayAs();
                                }
                                if (_text.indexOf("#BAD FUNCTION") >= 0) {
                                    return rcep.getExceptionReplacer();
                                }
                            }
                            return _text;
                        }
                        if (BgNFSHelper.checkHasPercentage(cell)) {
                            return cell.getText();
                        }
                        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                            String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(_formulaStr, _text, false);
                            }
                            return this.getMeasureUnitDisplayValue(_formulaStr, _text, true);
                        }
                        if (BgNFSHelper.checkHasGatFormulaOfCell(cell)) {
                            String _formulaStr = BgNFSHelper.getGatFormulaOfCell(cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(_formulaStr, _text, false);
                            }
                            return this.getMeasureUnitDisplayValue(_formulaStr, _text, true);
                        }
                        return this.getDefMeasureUnitDisplayValue(cell, _text);
                    }
                }
            } else if (viewMode == 1) {
                String _text;
                if (cell.hasFormula()) {
                    return cell.getFormula();
                }
                if (!BgNFSHelper.checkIsEmptyValue(cell) && !StringUtils.isEmpty((String)(_text = cell.getValue().getValue().toString()))) {
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                        if (this.getMeasureUnitMap().isEmpty()) {
                            return this.getMeasureUnitDisplayValue(_formulaStr, _text, false);
                        }
                        return this.getMeasureUnitDisplayValue(_formulaStr, _text, true);
                    }
                    return this.getDefMeasureUnitDisplayValue(cell, _text);
                }
            } else if (viewMode == 10) {
                if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                    return BgNFSHelper.getDisplayFormula(BgNFSHelper.getFormulaOfCell(cell), this.ui.getFormulaMap());
                }
                if (!BgNFSHelper.checkIsEmptyValue(cell)) {
                    String _text = cell.getValue().getValue().toString();
                    return this.getDefMeasureUnitDisplayValue(cell, _text);
                }
            }
        }
        return null;
    }

    protected Object getMeasureUnitDisplayValue(String formulaStr, Object obj, boolean useMeasureUnit) {
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        CurrencyInfo _currencyInfo = null;
        _formulaStr = formulaStr;
        _parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), _formulaStr);
        if (_parameter != null) {
            if (_parameter.length == 6) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
                }
                if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                    _precision = _currencyInfo.getPrecision();
                }
            } else if (_parameter.length == 4) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
                }
                if (!StringUtils.isEmpty((String)_parameter[3]) && this.getCurrencyMap().containsKey(_parameter[3])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[3]);
                    _precision = _currencyInfo.getPrecision();
                }
            }
        }
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    protected Object getDefMeasureUnitDisplayValue(Cell cell, Object obj) {
        if (!BgNFSHelper.checkHasNumbericOfCell(cell) || !BgNFSHelper.checkIsNumericOfCell(cell)) {
            return obj;
        }
        String _text = null;
        int precision = this.getPrecision();
        try {
            precision = BgNFSHelper.getDigitOfNumber(cell, precision);
            _text = this.getDisplayValue(obj, this.getCoefficient(), precision);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(coefficient, 8, 4);
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat((int)precision);
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }
}

