/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgSchemeNodeCollection;
import com.kingdee.eas.ma.budget.BgSchemeNodeInfo;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public final class BgExportHelper {
    private static Logger logger = Logger.getLogger((String)BgExportHelper.class.getName());
    private static String fileFormat = ".xls";

    public static String getFileFormat() {
        return fileFormat;
    }

    public static void setFileFormat(String fileFormat) {
        BgExportHelper.fileFormat = fileFormat;
    }

    protected static IPermission getPermissionInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    private static IBgScheme getBgSchemeInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    private static IBgTemplate getBgTemplateInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFile(String filepath, BgSchemeInfo bgSchemeInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo, String formmat) {
        BgExportHelper.setFileFormat(formmat);
        HashSet<BOSUuid> orgRangesSet = new HashSet<BOSUuid>();
        UserInfo userInfo = null;
        BgSchemeInfo _bgSchemeInfo = null;
        FullOrgUnitCollection orgRangesColl = null;
        TreeModel model = null;
        DefaultKingdeeTreeNode root = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("rootId");
        sic.add("orgUnit.id");
        try {
            _bgSchemeInfo = BgExportHelper.getBgSchemeInterface().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeInfo.getId()), sic);
            userInfo = SysContext.getSysContext().getCurrentUserInfo();
            model = BgNFSHelper.getOrgTreeModel(_bgSchemeInfo.getOrgUnit().getId().toString(), null);
            root = (DefaultKingdeeTreeNode)model.getRoot();
            orgRangesColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()));
            for (int i = 0; i < orgRangesColl.size(); ++i) {
                orgRangesSet.add(orgRangesColl.get(i).getId());
            }
            BgExportHelper.exportOrgUnit(root, _bgSchemeInfo, bgPeriodInfo, currencyInfo, filepath, orgRangesSet);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    private static void exportOrgUnit(DefaultKingdeeTreeNode node, BgSchemeInfo bgSchemeInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo, String filepath, Set orgRangeSet) throws Exception {
        FullOrgUnitInfo orgUnitInfo;
        OrgStructureInfo oui;
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null && orgRangeSet.contains((orgUnitInfo = oui.getUnit()).getId())) {
            String _tmpFilepath = filepath + "/" + orgUnitInfo.getName().trim();
            BgExportHelper.saveOrgFlepath(_tmpFilepath, orgUnitInfo);
            try {
                BgExportHelper.saveExcelFile(_tmpFilepath, orgUnitInfo, bgSchemeInfo, bgPeriodInfo, currencyInfo);
            }
            catch (Exception ex) {
                logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"17_BgExportHelper") + orgUnitInfo.getName() + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"18_BgExportHelper")));
                logger.error((Object)ex);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultKingdeeTreeNode _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                BgExportHelper.exportOrgUnit(_node, bgSchemeInfo, bgPeriodInfo, currencyInfo, _tmpFilepath, orgRangeSet);
            }
        }
    }

    private static void saveOrgFlepath(String filepath, FullOrgUnitInfo orgUnitInfo) {
        File orgFile = new File(filepath);
        if (!orgFile.exists()) {
            orgFile.mkdir();
        }
        orgFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveExcelFile(String filepath, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo) throws Exception {
        BgSchemeInfo _bgSchemeInfo = null;
        BgTemplateInfo _bgTemplateInfo = null;
        BgSchemeNodeInfo _bgSchemeNodeInfo2 = null;
        BgSchemeNodeCollection _bgSchemeNodeCol = null;
        try {
            _bgSchemeInfo = BgExportHelper.getBgSchemeByCurrOrgUnit(orgUnitInfo, bgSchemeInfo);
            if (_bgSchemeInfo != null && _bgSchemeInfo.getBgSchemeNodes() != null) {
                _bgSchemeNodeCol = _bgSchemeInfo.getBgSchemeNodes();
                for (BgSchemeNodeInfo _bgSchemeNodeInfo2 : _bgSchemeNodeCol) {
                    try {
                        _bgTemplateInfo = _bgSchemeNodeInfo2.getBgTemplate();
                        _bgTemplateInfo = BgExportHelper.getBgTemplateInfo(_bgTemplateInfo);
                        BgExportHelper.saveBgTemplateToExcelFile(filepath, orgUnitInfo, _bgSchemeInfo, _bgTemplateInfo, bgPeriodInfo, currencyInfo);
                    }
                    catch (Exception ex) {
                        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"17_BgExportHelper") + orgUnitInfo.getName() + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"19_BgExportHelper") + bgSchemeInfo.getName() + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"20_BgExportHelper") + _bgTemplateInfo.getName() + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"21_BgExportHelper")));
                        logger.error((Object)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    private static void saveBgTemplateToExcelFile(String filepath, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, BgTemplateInfo bgTemplateInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo) throws Exception {
        String filename = filepath + "/" + BgExportHelper.getFileName(orgUnitInfo, bgSchemeInfo, bgTemplateInfo, bgPeriodInfo, currencyInfo);
        BgExportHelper.checkFile(filename);
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        _book = bgTemplateInfo.getBook();
        if (BgExportHelper.getFileFormat().equals(".xls")) {
            try {
                _kdsBook = BookToKDSBook.traslate((Book)_book);
                int sheetSize = _book.getSheetCount();
                for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    _kdsSheet = _kdsBook.getSheet((Object)new Integer(sheetIndex));
                    rowCount = _sheet.getMaxRowIndex();
                    colCount = _sheet.getMaxColIndex();
                    for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                        for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                            _cell = _sheet.getCell(rowIndex, colIndex, false);
                            if (!BgNFSHelper.checkIsEmptyValue(_cell)) {
                                _kdsSheet.getCell(rowIndex, colIndex, true).setValue(BgNFSHelper.getValue(_cell));
                            }
                            if (!BgNFSHelper.checkHasExpression(_cell) || !(_cell.getValue().getValue() instanceof SyntaxErrorException)) continue;
                            _kdsSheet.getCell(rowIndex, colIndex, true).setValue((Object)Variant.nullVariant);
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
            finally {
                BgExportHelper.saveFile(_kdsBook, filename);
                logger.info((Object)(filename + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"22_BgExportHelper")));
                _kdsBook = null;
            }
        } else if (BgExportHelper.getFileFormat().equals(".xlsx")) {
            BgExportHelper.saveFileExcel2007(_book, filename);
        }
    }

    private static void saveFileExcel2007(Book _book, String filename) throws IOException {
        if (_book == null || StringUtils.isEmpty((String)filename)) {
            return;
        }
        BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
        bookDataWrapper.setExportFormula(false);
        bookDataWrapper.setExportCustomerFomulas(false);
        bookDataWrapper.setShowValue(true);
        bookDataWrapper.setExportHideCols(true);
        bookDataWrapper.setExportHideRows(true);
        SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
        booksc.write(filename);
    }

    private static BgSchemeInfo getBgSchemeByCurrOrgUnit(FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo) throws Exception {
        BgSchemeInfo _bgSchemeInfo = null;
        BgSchemeCollection _bgSchemeCol = null;
        SelectorItemCollection sic = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("rootId", (Object)bgSchemeInfo.getRootId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("rootId");
        sic.add("bgSchemeNodes.bgTemplate.id");
        sic.add("bgSchemeNodes.bgTemplate.name");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        _bgSchemeCol = BgExportHelper.getBgSchemeInterface().getBgSchemeCollection(view);
        if (_bgSchemeCol != null && !_bgSchemeCol.isEmpty()) {
            _bgSchemeInfo = _bgSchemeCol.get(0);
        }
        return _bgSchemeInfo;
    }

    private static BgTemplateInfo getBgTemplateInfo(BgTemplateInfo bgTemplateInfo) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("data");
        BgTemplateInfo _bgTemplateInfo = null;
        _bgTemplateInfo = BgExportHelper.getBgTemplateInterface().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgTemplateInfo.getId()), sic);
        return _bgTemplateInfo;
    }

    private static String getFileName(FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, BgTemplateInfo bgTemplateInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo) {
        StringBuffer filename = new StringBuffer();
        filename.append(orgUnitInfo.getName().trim());
        filename.append("_");
        filename.append(bgSchemeInfo.getName().trim());
        filename.append("_");
        filename.append(bgTemplateInfo.getName().trim());
        filename.append("_");
        filename.append(bgPeriodInfo.getName().trim());
        filename.append("_");
        filename.append(currencyInfo.getName().trim());
        if (BgExportHelper.getFileFormat().equals(".xls")) {
            filename.append(".xls");
        } else if (BgExportHelper.getFileFormat().equals(".xlsx")) {
            filename.append(".xlsx");
        }
        return filename.toString();
    }

    private static void checkFile(String filename) throws Exception {
        if (StringUtils.isEmpty((String)filename)) {
            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"23_BgExportHelper")});
        }
        File file = null;
        try {
            file = new File(filename);
            if (file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            file = null;
        }
    }

    private static void saveFile(KDSBook book, String filename) {
        if (book == null || StringUtils.isEmpty((String)filename)) {
            return;
        }
        try {
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
            em.exportToExcel(book, filename);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public static String getDefaultDirtory() {
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase(Locale.ENGLISH).startsWith("window")) {
            return "C:";
        }
        return FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
    }
}

