/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgRefBgCurrencyInfo;
import com.kingdee.eas.ma.budget.BgRefBgItemCombinInfo;
import com.kingdee.eas.ma.budget.BgRefBgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgFacadeHelper {
    private static final Logger logger = Logger.getLogger(BgFacadeHelper.class);

    public static final String[] checkFormulaIsEctypeInTmp(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgFormId, List formulaList) throws EASBizException {
        String[] formulaInfo;
        ResultSet rst;
        PreparedStatement pstmt;
        block12: {
            if (conn == null || orgUnitId == null || bgSchemeId == null || bgFormId == null || formulaList == null || formulaList.isEmpty()) {
                return null;
            }
            pstmt = null;
            rst = null;
            int index = 0;
            int batchSize = 200;
            int size = formulaList.size();
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            formulaInfo = null;
            String noFindStr = "#";
            String formulaStr = null;
            String tmpBgFormId = null;
            String _orgUnitId = orgUnitId.toString();
            String _bgSchemeId = bgSchemeId.toString();
            StringBuffer tmpsql = new StringBuffer(1024);
            tmpsql.append("Select TOP 1 FFormula, FBgFormId from T_BG_BgTmpData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
            for (index = 1; index < batchSize; ++index) {
                tmpsql.append("?,");
            }
            tmpsql.append("?)");
            tmpsql.append(" and (FBgFormId <> ?)");
            try {
                pos = 0;
                pstmt = conn.prepareStatement(tmpsql.toString());
                for (index = 0; index < count && (formulaStr == null || tmpBgFormId == null); ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int y = 3;
                    while (y < batchSize + 3) {
                        if (pos < size) {
                            pstmt.setString(y, (String)formulaList.get(pos));
                        } else {
                            pstmt.setString(y, noFindStr);
                        }
                        ++y;
                        ++pos;
                    }
                    pstmt.setString(batchSize + 3, bgFormId.toString());
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        formulaStr = rst.getString(1);
                        tmpBgFormId = rst.getString(2);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
                if (formulaStr == null || tmpBgFormId == null) break block12;
                BgFormInfo tmpInfo = BgInfoHelper.getBgFormInfo(conn, BOSUuid.read(tmpBgFormId), false);
                if (tmpInfo != null) {
                    formulaInfo = new String[]{formulaStr, tmpInfo.getName()};
                    break block12;
                }
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        return formulaInfo;
    }

    public static final String[] checkFormulaIsEctypeInTmpData(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgFormId, List formulaList) throws EASBizException {
        String[] formulaInfo;
        ResultSet rst;
        PreparedStatement pstmt;
        block12: {
            if (conn == null || orgUnitId == null || bgSchemeId == null || bgFormId == null || formulaList == null || formulaList.isEmpty()) {
                return null;
            }
            pstmt = null;
            rst = null;
            int index = 0;
            int batchSize = 200;
            int size = formulaList.size();
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            formulaInfo = null;
            String noFindStr = "#";
            String formulaStr = null;
            String tmpBgFormId = null;
            String _orgUnitId = orgUnitId.toString();
            String _bgSchemeId = bgSchemeId.toString();
            StringBuffer tmpsql = new StringBuffer(1024);
            tmpsql.append("Select TOP 1 FFormula, FBgFormId from T_BG_BgTmpData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
            for (index = 1; index < batchSize; ++index) {
                tmpsql.append("?,");
            }
            tmpsql.append("?)");
            tmpsql.append(" and (FBgFormId <> ?)");
            try {
                pos = 0;
                pstmt = conn.prepareStatement(tmpsql.toString());
                for (index = 0; index < count && (formulaStr == null || tmpBgFormId == null); ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int y = 3;
                    while (y < batchSize + 3) {
                        if (pos < size) {
                            pstmt.setString(y, (String)formulaList.get(pos));
                        } else {
                            pstmt.setString(y, noFindStr);
                        }
                        ++y;
                        ++pos;
                    }
                    pstmt.setString(batchSize + 3, bgFormId.toString());
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        formulaStr = rst.getString(1);
                        tmpBgFormId = rst.getString(2);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
                if (formulaStr == null || tmpBgFormId == null) break block12;
                BgFormInfo tmpInfo = BgInfoHelper.getBgFormInfo(conn, BOSUuid.read(tmpBgFormId), false);
                if (tmpInfo != null) {
                    formulaInfo = new String[]{formulaStr, tmpInfo.getName()};
                    break block12;
                }
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        return formulaInfo;
    }

    public static final String[] checkFormulaIsEctype(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgFormId, List formulaList) throws EASBizException {
        String[] formulaInfo;
        block21: {
            if (conn == null || orgUnitId == null || bgSchemeId == null || bgFormId == null || formulaList == null || formulaList.isEmpty()) {
                return null;
            }
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            int index = 0;
            int batchSize = 200;
            int size = formulaList.size();
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            formulaInfo = null;
            String noFindStr = "#";
            String formulaStr = null;
            String tmpBgFormId = null;
            String _orgUnitId = orgUnitId.toString();
            String _bgSchemeId = bgSchemeId.toString();
            StringBuffer sql = new StringBuffer(1024);
            StringBuffer tmpsql = new StringBuffer(1024);
            sql.append("Select TOP 1 FFormula, FBgFormId from T_BG_BgData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
            tmpsql.append("Select TOP 1 FFormula, FBgFormId from T_BG_BgTmpData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
            for (index = 1; index < batchSize; ++index) {
                sql.append("?,");
                tmpsql.append("?,");
            }
            sql.append("?)");
            tmpsql.append("?)");
            sql.append(" and (FBgFormId <> ?)");
            tmpsql.append(" and (FBgFormId <> ?)");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                for (index = 0; index < count && (formulaStr == null || tmpBgFormId == null); ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int x = 3;
                    while (x < batchSize + 3) {
                        if (pos < size) {
                            pstmt.setString(x, (String)formulaList.get(pos));
                        } else {
                            pstmt.setString(x, noFindStr);
                        }
                        ++x;
                        ++pos;
                    }
                    pstmt.setString(batchSize + 3, bgFormId.toString());
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        formulaStr = rst.getString(1);
                        tmpBgFormId = rst.getString(2);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
                if (formulaStr != null && tmpBgFormId != null) {
                    BgFormInfo tmpInfo = BgInfoHelper.getBgFormInfo(conn, BOSUuid.read(tmpBgFormId), false);
                    if (tmpInfo != null) {
                        formulaInfo = new String[]{formulaStr, tmpInfo.getName()};
                    } else {
                        throw new BgFormException(BgFormException.NOBGFORMINFO);
                    }
                }
                if (formulaInfo != null) break block21;
                pos = 0;
                pstmt = conn.prepareStatement(tmpsql.toString());
                for (index = 0; index < count && (formulaStr == null || tmpBgFormId == null); ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int y = 3;
                    while (y < batchSize + 3) {
                        if (pos < size) {
                            pstmt.setString(y, (String)formulaList.get(pos));
                        } else {
                            pstmt.setString(y, noFindStr);
                        }
                        ++y;
                        ++pos;
                    }
                    pstmt.setString(batchSize + 3, bgFormId.toString());
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        formulaStr = rst.getString(1);
                        tmpBgFormId = rst.getString(2);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
                if (formulaStr == null || tmpBgFormId == null) break block21;
                BgFormInfo tmpInfo = BgInfoHelper.getBgFormInfo(conn, BOSUuid.read(tmpBgFormId), false);
                if (tmpInfo != null) {
                    formulaInfo = new String[]{formulaStr, tmpInfo.getName()};
                    break block21;
                }
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
        }
        return formulaInfo;
    }

    public static final void addNewBgDataBudgetValue(Connection conn, BgFormInfo bgFormInfo, List formulas, List bValues, List aValues, List bgItemList, List bgPeriodList, List bgElementList, List currencyList, Map bgItemMap, Map bgPeriodMap, Map bgElementMap, Map currencyMap, List isCtrlList, List isFlexCtrlList, List flexCtrlParamList, List periodCtrlPolicyList, List isGroupCtrlList, List groupCtrlNoList, List isAllowAccessList, List isFromSuperList, List isCtrlAllowChangeList, List sheetNameList, List ctrlModelFromList, UserInfo userInfo, Date date) throws EASBizException {
        if (conn == null || bgFormInfo == null || formulas == null || bValues == null || bgItemList == null || bgPeriodList == null || bgElementList == null || currencyList == null || bgItemMap == null || bgPeriodMap == null || bgElementMap == null || currencyMap == null || isCtrlList == null || isFlexCtrlList == null || flexCtrlParamList == null || periodCtrlPolicyList == null || isGroupCtrlList == null || groupCtrlNoList == null || isAllowAccessList == null || sheetNameList == null) {
            return;
        }
        if (formulas.isEmpty() || formulas.size() != bValues.size() || formulas.size() != aValues.size()) {
            return;
        }
        PreparedStatement pstmt = null;
        BigDecimal bValue = null;
        BigDecimal aValue = null;
        BigDecimal cValue = null;
        BOSObjectType type = new BgDataInfo().getBOSType();
        int batchSize = 200;
        int batchIndex = 0;
        String ctrlString = null;
        String _bgItemId = null;
        String _bgPeriodId = null;
        String _bgElementId = null;
        String _currencyId = null;
        String _bgFormId = bgFormInfo.getId().toString();
        String _orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        String _bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        String _bgTemplateId = bgFormInfo.getBgTemplate().getId().toString();
        String _userId = userInfo.getId().toString();
        try {
            pstmt = conn.prepareStatement("Insert Into T_BG_BgData (FID, FBgValue, FBgActual,FBizActual, FBgBalance, FFormula, FBgPeriodId, FBgFormId, FBgElementId,FCurrencyId, FOrgUnitId, FBgSchemeId, FBgTemplateId, FBgItemCombinId,FIsControl, FIsFlexible, FFlexParam, FCtrlType, FIsGroupCtrl, FGroupNo, FSheetName, FCreatorId, FCreateTime, FLastupdateUserId, FlastupdateTime, FIsAllowAccess, FIsFromSuper, FIsCtrlAllowChange,FCtrlModeFrom,FDataState) Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)");
            int count = formulas.size();
            for (int index = 0; index < count; ++index) {
                bValue = (BigDecimal)bValues.get(index);
                aValue = (BigDecimal)aValues.get(index);
                if (bValue.scale() < 0) {
                    bValue = bValue.setScale(0);
                }
                if (aValue.scale() < 0) {
                    aValue = aValue.setScale(0);
                }
                pstmt.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                pstmt.setBigDecimal(2, bValue.setScale(8, 4));
                pstmt.setBigDecimal(3, aValue.setScale(8, 4));
                pstmt.setBigDecimal(4, aValue.setScale(8, 4));
                pstmt.setBigDecimal(5, bValue.setScale(8, 4));
                pstmt.setString(6, formulas.get(index).toString());
                _bgPeriodId = (String)bgPeriodMap.get(bgPeriodList.get(index));
                if (_bgPeriodId == null) {
                    logger.debug((Object)("bgPeriod number error:" + bgPeriodList.get(index).toString()));
                    throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{bgPeriodList.get(index).toString()});
                }
                pstmt.setString(7, _bgPeriodId);
                pstmt.setString(8, _bgFormId);
                _bgElementId = (String)bgElementMap.get(bgElementList.get(index));
                if (_bgElementId == null) {
                    logger.debug((Object)("bgElement number error:" + bgElementList.get(index).toString()));
                    throw new BgFormException(BgFormException.SUBMITNOELEMENT, (Object[])new String[]{bgElementList.get(index).toString()});
                }
                pstmt.setString(9, _bgElementId);
                _currencyId = (String)currencyMap.get(currencyList.get(index));
                if (_currencyId == null) {
                    logger.debug((Object)("currency number error:" + currencyList.get(index).toString()));
                    throw new BgFormException(BgFormException.SUBMITNOCURRENCY, (Object[])new String[]{currencyList.get(index).toString()});
                }
                pstmt.setString(10, _currencyId);
                pstmt.setString(11, _orgUnitId);
                pstmt.setString(12, _bgSchemeId);
                pstmt.setString(13, _bgTemplateId);
                _bgItemId = (String)bgItemMap.get(bgItemList.get(index));
                if (_bgItemId == null) {
                    logger.debug((Object)("bgItem number error:" + bgItemList.get(index).toString()));
                    throw new BgFormException(BgFormException.SUBMITNOITEM, (Object[])new String[]{bgItemList.get(index).toString()});
                }
                pstmt.setString(14, _bgItemId);
                ctrlString = (String)isCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(15, 1);
                } else {
                    pstmt.setInt(15, 0);
                }
                ctrlString = (String)isFlexCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(16, 1);
                } else {
                    pstmt.setInt(16, 0);
                }
                try {
                    cValue = new BigDecimal(flexCtrlParamList.get(index).toString());
                }
                catch (Exception ex) {
                    cValue = BgConstants.BIGZERO;
                }
                if (cValue.scale() < 0) {
                    cValue = cValue.setScale(0);
                }
                pstmt.setBigDecimal(17, cValue);
                ctrlString = (String)periodCtrlPolicyList.get(index);
                if (ctrlString != null) {
                    try {
                        pstmt.setInt(18, new Integer(ctrlString));
                    }
                    catch (Exception ex) {
                        pstmt.setInt(18, 10);
                    }
                } else {
                    pstmt.setInt(18, 10);
                }
                ctrlString = (String)isGroupCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(19, 1);
                } else {
                    pstmt.setInt(19, 0);
                }
                pstmt.setString(20, (String)groupCtrlNoList.get(index));
                pstmt.setString(21, (String)sheetNameList.get(index));
                pstmt.setString(22, _userId);
                pstmt.setDate(23, date);
                pstmt.setString(24, _userId);
                pstmt.setDate(25, date);
                ctrlString = (String)isAllowAccessList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.FALSE.toString())) {
                    pstmt.setInt(26, 0);
                } else {
                    pstmt.setInt(26, 1);
                }
                ctrlString = (String)isFromSuperList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(27, 1);
                } else {
                    pstmt.setInt(27, 0);
                }
                ctrlString = (String)isCtrlAllowChangeList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.FALSE.toString())) {
                    pstmt.setInt(28, 0);
                } else {
                    pstmt.setInt(28, 1);
                }
                Object obj = ctrlModelFromList.get(index);
                if (obj instanceof Integer) {
                    pstmt.setInt(29, (Integer)obj);
                } else {
                    pstmt.setInt(29, 1);
                }
                pstmt.setInt(30, 1);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage());
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void updateBgDataBudgetValue(Connection conn, BOSUuid bgFormId, List formulas, List bValues, List aValues, List isCtrlList, List isFlexCtrlList, List flexCtrlParamList, List periodCtrlPolicyList, List isGroupCtrlList, List groupCtrlNoList, List isFromSuperList, List isCtrlAllowChangeList, List isAllowAccessList, List sheetNameList, List ctrlModelFromList, UserInfo userInfo, Date date) throws EASBizException {
        if (bgFormId == null || formulas == null || bValues == null || aValues == null || formulas.size() != bValues.size() || formulas.size() != aValues.size()) {
            return;
        }
        PreparedStatement pstmt = null;
        BigDecimal bValue = null;
        BigDecimal aValue = null;
        BigDecimal ctrlValue = null;
        int batchSize = 200;
        int batchIndex = 0;
        String _userId = userInfo.getId().toString();
        String formulaStr = null;
        String ctrlString = null;
        String _bgFormId = bgFormId.toString();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set FBgValue = ?, FBgActual = ?, FBizActual = ?, FIsControl = ?, FIsFlexible = ?, FFlexParam = ?, FCtrlType = ?, FIsGroupCtrl = ?, FGroupNo = ?, FIsFromSuper = ?, FIsCtrlAllowChange = ?, FSheetName = ?, FLastupdateUserId = ?, FLastupdateTime = ? , FIsAllowAccess = ?,FCtrlModeFrom = ? where FBgFormId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int count = formulas.size();
            for (int index = 0; index < count; ++index) {
                formulaStr = (String)formulas.get(index);
                bValue = (BigDecimal)bValues.get(index);
                aValue = (BigDecimal)aValues.get(index);
                if (bValue.scale() < 0) {
                    bValue = bValue.setScale(0);
                }
                if (aValue.scale() < 0) {
                    aValue = aValue.setScale(0);
                }
                pstmt.setBigDecimal(1, bValue.setScale(8, 4));
                pstmt.setBigDecimal(2, aValue.setScale(8, 4));
                pstmt.setBigDecimal(3, aValue.setScale(8, 4));
                ctrlString = (String)isCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(4, 1);
                } else {
                    pstmt.setInt(4, 0);
                }
                ctrlString = (String)isFlexCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(5, 1);
                } else {
                    pstmt.setInt(5, 0);
                }
                ctrlString = (String)flexCtrlParamList.get(index);
                try {
                    ctrlValue = new BigDecimal(ctrlString);
                }
                catch (Exception ex) {
                    ctrlValue = BgConstants.BIGZERO;
                }
                if (ctrlValue.scale() < 0) {
                    ctrlValue = ctrlValue.setScale(0);
                }
                pstmt.setBigDecimal(6, ctrlValue);
                ctrlString = (String)periodCtrlPolicyList.get(index);
                if (ctrlString != null) {
                    try {
                        pstmt.setInt(7, new Integer(ctrlString));
                    }
                    catch (Exception ex) {
                        pstmt.setInt(7, 10);
                    }
                } else {
                    pstmt.setInt(7, 10);
                }
                ctrlString = (String)isGroupCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(8, 1);
                } else {
                    pstmt.setInt(8, 0);
                }
                pstmt.setString(9, (String)groupCtrlNoList.get(index));
                ctrlString = (String)isFromSuperList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(10, 1);
                } else {
                    pstmt.setInt(10, 0);
                }
                ctrlString = (String)isCtrlAllowChangeList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(11, 1);
                } else {
                    pstmt.setInt(11, 0);
                }
                pstmt.setString(12, (String)sheetNameList.get(index));
                pstmt.setString(13, _userId);
                pstmt.setDate(14, date);
                ctrlString = (String)isAllowAccessList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.FALSE.toString())) {
                    pstmt.setInt(15, 0);
                } else {
                    pstmt.setInt(15, 1);
                }
                Object obj = ctrlModelFromList.get(index);
                if (obj instanceof Integer) {
                    pstmt.setInt(16, (Integer)obj);
                } else {
                    pstmt.setInt(16, 1);
                }
                pstmt.setString(17, _bgFormId);
                pstmt.setString(18, formulaStr);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static final void updateBgDataBudgetValue(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, List formulas, List values, List isCtrlList, List isFlexCtrlList, List flexCtrlParamList, List periodCtrlPolicyList, List isGroupCtrlList, List groupCtrlNoList) throws EASBizException {
        if (orgUnitId == null || bgSchemeId == null || formulas == null || values == null || formulas.size() != values.size()) {
            return;
        }
        PreparedStatement pstmt = null;
        BigDecimal value = null;
        BigDecimal ctrlValue = null;
        int batchSize = 200;
        int batchIndex = 0;
        String formulaStr = null;
        String ctrlString = null;
        String _orgUnitId = orgUnitId.toString();
        String _bgSchemeId = bgSchemeId.toString();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set FBgValue = ?, FIsControl = ?, FIsFlexible = ?, FFlexParam = ?, FCtrlType = ?, FIsGroupCtrl = ?, FGroupNo = ? where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int count = formulas.size();
            for (int index = 0; index < count; ++index) {
                formulaStr = (String)formulas.get(index);
                value = (BigDecimal)values.get(index);
                pstmt.setBigDecimal(1, value.setScale(8, 4));
                ctrlString = (String)isCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(2, 1);
                } else {
                    pstmt.setInt(2, 0);
                }
                ctrlString = (String)isFlexCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(3, 1);
                } else {
                    pstmt.setInt(3, 0);
                }
                ctrlString = (String)flexCtrlParamList.get(index);
                try {
                    ctrlValue = new BigDecimal(ctrlString);
                }
                catch (Exception ex) {
                    ctrlValue = BgConstants.BIGZERO;
                }
                pstmt.setBigDecimal(4, ctrlValue.setScale(8, 4));
                ctrlString = (String)periodCtrlPolicyList.get(index);
                if (ctrlString != null) {
                    try {
                        pstmt.setInt(5, new Integer(ctrlString));
                    }
                    catch (Exception ex) {
                        pstmt.setInt(5, 10);
                    }
                } else {
                    pstmt.setInt(5, 10);
                }
                ctrlString = (String)isGroupCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(6, 1);
                } else {
                    pstmt.setInt(6, 0);
                }
                pstmt.setString(7, (String)groupCtrlNoList.get(index));
                pstmt.setString(8, _orgUnitId);
                pstmt.setString(9, _bgSchemeId);
                pstmt.setString(10, formulaStr);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static final int updateBgDataBudgetValue(Connection conn, BOSUuid bgFormId, String formula, BigDecimal value) throws EASBizException {
        int result = 0;
        if (conn == null || bgFormId == null || formula == null || value == null) {
            return result;
        }
        if (value.scale() < 0) {
            value = value.setScale(0);
        }
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set FBgValue = ? where FBgFormId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId.toString());
            pstmt.setString(2, formula);
            pstmt.setBigDecimal(3, value);
            result = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        return result;
    }

    public static final int updateBgDataBudgetValue(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, String formula, BigDecimal value) throws EASBizException {
        int result = 0;
        if (conn == null || orgUnitId == null || bgSchemeId == null || formula == null || value == null) {
            return result;
        }
        if (value.scale() < 0) {
            value = value.setScale(0);
        }
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set FBgValue = ? where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgSchemeId.toString());
            pstmt.setString(3, formula);
            pstmt.setBigDecimal(3, value);
            result = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        return result;
    }

    public static final void removeBgDataBudgetValue(Connection conn, BOSUuid bgFormId, List formulas) throws EASBizException {
        if (conn == null || bgFormId == null || formulas == null) {
            return;
        }
        PreparedStatement pstmt = null;
        int batchSize = 200;
        int batchIndex = 0;
        String formulaStr = null;
        String _bgFormId = bgFormId.toString();
        StringBuffer sql = new StringBuffer();
        sql.append("delete T_BG_BgData where FBgFormId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int in = formulas.size();
            for (int i = 0; i < in; ++i) {
                formulaStr = (String)formulas.get(i);
                pstmt.setString(1, _bgFormId);
                pstmt.setString(2, formulaStr);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static final void checkValue(String value, int rowIndex, int colIndex) throws EASBizException {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        BigDecimal _value = null;
        try {
            _value = new BigDecimal(value);
        }
        catch (Exception ex) {
            _value = BgConstants.BIGZERO;
        }
        BgFacadeHelper.checkValue(_value, rowIndex, colIndex);
    }

    public static final void checkValue(BigDecimal value, int rowIndex, int colIndex) throws EASBizException {
        if (value == null) {
            return;
        }
        int compareValue = value.compareTo(BgConstants.BIGZERO);
        if (compareValue > 0) {
            if (BgNFSHelper.checkHasOverstepMax(value)) {
                throw new BgFormException(BgFormException.VALUEHASOVERSTEPMAX, (Object[])new String[]{TableToolkit.xy2range((int)colIndex, (int)rowIndex)});
            }
        } else if (compareValue < 0 && BgNFSHelper.checkHasOverstepMin(value)) {
            throw new BgFormException(BgFormException.VALUEHASOVERSTEPMIN, (Object[])new String[]{TableToolkit.xy2range((int)colIndex, (int)rowIndex)});
        }
    }

    public static final Map getBgItemMap(Connection conn, Map bgItemMap, List bgItemList) throws BOSException, EASBizException {
        if (conn == null || bgItemList == null || bgItemList.isEmpty()) {
            return new HashMap();
        }
        HashSet<String> _bgItemSet = new HashSet<String>();
        ArrayList<String> _bgItemList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgItemId = null;
        String bgItemKey = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FKey from T_BG_BgItemCombination where FKey IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        if (bgItemMap == null) {
            bgItemMap = new HashMap<String, String>();
        }
        int in = bgItemList.size();
        for (int i = 0; i < in; ++i) {
            bgItemKey = (String)bgItemList.get(i);
            if (bgItemMap.containsKey(bgItemKey) || _bgItemSet.contains(bgItemKey)) continue;
            _bgItemSet.add(bgItemKey);
            _bgItemList.add(bgItemKey);
        }
        size = _bgItemList.size();
        count = (size - 1) / batchNum + 1;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgItemList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgItemId = rst.getString(1);
                    bgItemKey = rst.getString(2);
                    bgItemMap.put(bgItemKey, bgItemId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgItemMap;
    }

    public static final Map createBgItemMap(Context ctx, Map bgItemMap, List bgItemList, String orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || bgItemMap == null || bgItemList == null) {
            return new HashMap();
        }
        if (bgItemList.isEmpty()) {
            return bgItemMap;
        }
        String bgItemKey2 = null;
        String bgItemId = null;
        ArrayList<String> createNew = new ArrayList<String>();
        HashSet<String> _bgItemSet = new HashSet<String>();
        Hashtable _bgItemMap = null;
        int count = bgItemList.size();
        for (int index = 0; index < count; ++index) {
            bgItemKey2 = (String)bgItemList.get(index);
            if (bgItemMap.containsKey(bgItemKey2) || _bgItemSet.contains(bgItemKey2)) continue;
            createNew.add(bgItemKey2.replaceAll("_", ","));
            _bgItemSet.add(bgItemKey2);
        }
        IBgTemplate ibgTemplate = null;
        try {
            ibgTemplate = BgTemplateFactory.getLocalInstance((Context)ctx);
            if (ibgTemplate == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            _bgItemMap = ibgTemplate.getItemCombinIds(createNew, BgSHelper.getIsolateOrg((Context)ctx, (String)orgUnitId));
            if (_bgItemMap != null && !_bgItemMap.isEmpty()) {
                for (String bgItemKey2 : _bgItemMap.keySet()) {
                    bgItemId = (String)_bgItemMap.get(bgItemKey2);
                    bgItemMap.put(bgItemKey2.replaceAll(",", "_"), bgItemId);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgItemMap;
    }

    public static final Map getBgPeriodMap(Connection conn, Map bgPeriodMap, List bgPeriodList) throws EASBizException {
        if (conn == null || bgPeriodList == null || bgPeriodList.isEmpty()) {
            return new HashMap();
        }
        HashSet<String> _bgPeriodSet = new HashSet<String>();
        ArrayList<String> _bgPeriodList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgPeriodId = null;
        String bgPeriodNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BG_BgPeriod where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        if (bgPeriodMap == null) {
            bgPeriodMap = new HashMap<String, String>();
        }
        int in = bgPeriodList.size();
        for (int i = 0; i < in; ++i) {
            bgPeriodNum = (String)bgPeriodList.get(i);
            if (bgPeriodMap.containsKey(bgPeriodNum) || _bgPeriodSet.contains(bgPeriodNum)) continue;
            _bgPeriodSet.add(bgPeriodNum);
            _bgPeriodList.add(bgPeriodNum);
        }
        size = _bgPeriodList.size();
        count = (size - 1) / batchNum + 1;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgPeriodList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgPeriodId = rst.getString(1);
                    bgPeriodNum = rst.getString(2);
                    bgPeriodMap.put(bgPeriodNum, bgPeriodId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgPeriodMap;
    }

    public static final Map getBgElementMap(Connection conn, Map bgElementMap, List bgElementList) throws EASBizException {
        if (conn == null || bgElementList == null || bgElementList.isEmpty()) {
            return new HashMap();
        }
        HashSet<String> _bgElementSet = new HashSet<String>();
        ArrayList<String> _bgElementList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgElementId = null;
        String bgElementNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BG_BgElement where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        if (bgElementMap == null) {
            bgElementMap = new HashMap<String, String>();
        }
        int in = bgElementList.size();
        for (int i = 0; i < in; ++i) {
            bgElementNum = (String)bgElementList.get(i);
            if (bgElementMap.containsKey(bgElementNum) || _bgElementSet.contains(bgElementNum)) continue;
            _bgElementSet.add(bgElementNum);
            _bgElementList.add(bgElementNum);
        }
        size = _bgElementList.size();
        count = (size - 1) / batchNum + 1;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgElementList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgElementId = rst.getString(1);
                    bgElementNum = rst.getString(2);
                    bgElementMap.put(bgElementNum, bgElementId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgElementMap;
    }

    public static final Map getCurrencyMap(Connection conn, Map currencyMap, List currencyList) throws EASBizException {
        if (conn == null || currencyList == null || currencyList.isEmpty()) {
            return new HashMap();
        }
        HashSet<String> _currencySet = new HashSet<String>();
        ArrayList<String> _currencyList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String currencyId = null;
        String currencyNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BD_Currency where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        if (currencyMap == null) {
            currencyMap = new HashMap<String, String>();
        }
        int in = currencyList.size();
        for (int i = 0; i < in; ++i) {
            currencyNum = (String)currencyList.get(i);
            if (currencyMap.containsKey(currencyNum) || _currencySet.contains(currencyNum)) continue;
            _currencySet.add(currencyNum);
            _currencyList.add(currencyNum);
        }
        size = _currencyList.size();
        count = (size - 1) / batchNum + 1;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_currencyList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    currencyId = rst.getString(1);
                    currencyNum = rst.getString(2);
                    currencyMap.put(currencyNum, currencyId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return currencyMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void dealRefBgItem(Context ctx, BOSUuid bgFormId, Set refBgItemSet, Map refBgItemMap) throws EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        block16: {
            if (ctx == null) return;
            if (bgFormId == null) return;
            if (refBgItemSet == null) return;
            if (refBgItemSet.isEmpty()) return;
            if (refBgItemMap == null) {
                return;
            }
            int batchSize = 100;
            int batchIndex = 0;
            String bgItemKey2222222 = null;
            String bgItemId = null;
            String _bgFormId = bgFormId.toString();
            BgRefBgItemCombinInfo bgRefItemInfo = new BgRefBgItemCombinInfo();
            conn = null;
            pstmt = null;
            TempTablePool pool = null;
            String _tableName = null;
            String _createSql = "Create Table TMP_Table_Name(FID VARCHAR(44) NOT NULL, FBgFormID VARCHAR(44) NOT NULL, FBgItemCombinId VARCHAR(44) NOT NULL)";
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                _tableName = pool.createDBSystemTempTable(_createSql, conn);
                pstmt = conn.prepareStatement("INSERT INTO " + _tableName + "(FID, FBgFormID, FBgItemCombinId) VALUES (?, ?, ?)");
                for (String bgItemKey2222222 : refBgItemSet) {
                    if (!refBgItemMap.containsKey(bgItemKey2222222)) {
                        throw new BgFormException(BgFormException.SUBMITNOITEM, (Object[])new String[]{bgItemKey2222222});
                    }
                    bgItemId = (String)refBgItemMap.get(bgItemKey2222222);
                    if (StringUtils.isEmpty((String)bgItemId)) {
                        throw new BgFormException(BgFormException.SUBMITNOITEM, (Object[])new String[]{bgItemKey2222222});
                    }
                    pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefItemInfo.getBOSType()).toString());
                    pstmt.setString(2, BOSUuid.read((String)_bgFormId).toString());
                    pstmt.setString(3, BOSUuid.read((String)bgItemId).toString());
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
                String _tmpSql = "Insert Into T_BG_BgRefBgItemCombin(FID, FBgFormID, FBgItemCombinId) Select FID, FBgFormID, FBgItemCombinId from " + _tableName;
                pstmt = conn.prepareStatement(_tmpSql);
                pstmt.executeUpdate();
                if (pool == null) break block16;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                    catch (Exception ex3) {
                        logger.error((Object)ex3);
                        throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex3.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        try {
                            pool.releaseDBSystemTempTable(_tableName, conn);
                        }
                        catch (Exception ex4) {
                            logger.error((Object)"releaseDBSystemTempTable:", (Throwable)ex4);
                        }
                    }
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseDBSystemTempTable(_tableName, conn);
            }
            catch (Exception ex) {
                logger.error((Object)"releaseDBSystemTempTable:", (Throwable)ex);
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static final void clearRefBgItem(Connection conn, BOSUuid bgFormId, Map refBgItemMap, List delBgItemList) throws EASBizException {
        if (conn == null || bgFormId == null || refBgItemMap == null || refBgItemMap.isEmpty() || delBgItemList == null || delBgItemList.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgItemKey2 = null;
        String bgItemId = null;
        String _bgFormId = bgFormId.toString();
        HashSet<String> delBgItemSet = new HashSet<String>();
        for (String bgItemKey2 : delBgItemList) {
            delBgItemSet.add(bgItemKey2);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgItemCombin WHERE FBgFormID = ? AND FBgItemCombinId = ?");
            for (String bgItemKey2 : delBgItemSet) {
                bgItemId = (String)refBgItemMap.get(bgItemKey2);
                if (!StringUtils.isEmpty((String)bgItemId)) {
                    pstmt.setString(1, _bgFormId);
                    pstmt.setString(2, bgItemId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOITEM, (Object[])new String[]{bgItemKey2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefBgItem(Connection conn, BOSUuid bgFormId) throws EASBizException {
        BgFacadeHelper.clearRefBgItem(conn, bgFormId.toString());
    }

    public static final void clearRefBgItem(Connection conn, String bgFormId) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgItemCombin WHERE FBgFormID = ?");
            pstmt.setString(1, bgFormId);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void dealRefBgItemCombin(Connection conn) throws EASBizException {
        if (conn == null) {
            return;
        }
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_BG_BgItemCombination where FID not in (select distinct FBgItemCombinId from T_BG_BgRefBgItemCombin) and FID not in (select distinct FBgItemCombinId from T_BG_BgTemRefBgItemCombin) and FID not in (select distinct FBgItemCombinId from T_BG_BgControlItemMap)");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static final void dealRefBgItemCombin(Connection conn, String bgFormId) throws EASBizException {
        if (conn == null) {
            return;
        }
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_BG_BgItemCombination where FID not in (select distinct FBgItemCombinId from T_BG_BgRefBgItemCombin) and FID not in (select distinct FBgItemCombinId from T_BG_BgTemRefBgItemCombin) and FID not in (select distinct FBgItemCombinId from T_BG_BgControlItemMap)");
        if (!StringUtils.isEmpty((String)bgFormId)) {
            sql.append(" and FID in (select distinct FBgItemCombinId from T_BG_BgData where FBgFormId = ?)");
        }
        try {
            pstmt = conn.prepareStatement(sql.toString());
            if (!StringUtils.isEmpty((String)bgFormId)) {
                pstmt.setString(1, bgFormId);
            }
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static final void dealRefBgItemCombin(Connection conn, List bgItemRemoveList, Map bgItemRomoveMap) throws EASBizException {
        if (conn == null || bgItemRemoveList == null || bgItemRemoveList.isEmpty() || bgItemRomoveMap == null) {
            return;
        }
        String id = null;
        String number2 = null;
        ArrayList<String> _bgItemRemoveList = new ArrayList<String>();
        HashSet<String> _bgItemRemoveSet = new HashSet<String>();
        for (String number2 : bgItemRemoveList) {
            if (_bgItemRemoveSet.contains(number2)) continue;
            _bgItemRemoveSet.add(number2);
            id = (String)bgItemRomoveMap.get(number2);
            if (id == null) continue;
            _bgItemRemoveList.add(number2);
        }
        int index = 0;
        int batchNum = 200;
        int size = _bgItemRemoveList.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_BG_BgItemCombination where FID not in (select distinct FBgItemCombinId from T_BG_BgRefBgItemCombin) and FID not in (select distinct FBgItemCombinId from T_BG_BgTemRefBgItemCombin) and FID not in (select distinct FBgItemCombinId from T_BG_BgControlItemMap) and FID in (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?, ");
        }
        sql.append("?)");
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgItemRemoveList.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                pstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void dealRefBgPeriod(Context ctx, BOSUuid bgFormId, Set refBgPeriodSet, Map refBgPeriodMap) throws EASBizException {
        if (ctx == null) return;
        if (bgFormId == null) return;
        if (refBgPeriodSet == null) return;
        if (refBgPeriodSet.isEmpty()) return;
        if (refBgPeriodMap == null) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgPeriodNumbr2222222 = null;
        String bgPeriodId = null;
        String _bgFormId = bgFormId.toString();
        BgRefBgPeriodInfo bgRefPeriodInfo = new BgRefBgPeriodInfo();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BgRefBgPeriod(FID, FBgFormID, FBgPeriodID) VALUES (?, ?, ?)");
            for (String bgPeriodNumbr2222222 : refBgPeriodSet) {
                if (!refBgPeriodMap.containsKey(bgPeriodNumbr2222222)) {
                    throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{bgPeriodNumbr2222222});
                }
                bgPeriodId = (String)refBgPeriodMap.get(bgPeriodNumbr2222222);
                if (StringUtils.isEmpty((String)bgPeriodId)) {
                    throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{bgPeriodNumbr2222222});
                }
                pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefPeriodInfo.getBOSType()).toString());
                pstmt.setString(2, BOSUuid.read((String)_bgFormId).toString());
                pstmt.setString(3, BOSUuid.read((String)bgPeriodId).toString());
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static final void clearRefBgPeriod(Connection conn, BOSUuid bgFormId, Map refBgPeriodMap, List delBgPeriodList) throws EASBizException {
        if (conn == null || bgFormId == null || refBgPeriodMap == null || refBgPeriodMap.isEmpty() || delBgPeriodList == null || delBgPeriodList.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgPeriodNum2 = null;
        String bgPeriodId = null;
        String _bgFormId = bgFormId.toString();
        HashSet<String> delBgPeriodSet = new HashSet<String>();
        for (String bgPeriodNum2 : delBgPeriodList) {
            delBgPeriodSet.add(bgPeriodNum2);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgPeriod WHERE FBgFormID = ? AND FBgPeriodID = ?");
            for (String bgPeriodNum2 : delBgPeriodSet) {
                bgPeriodId = (String)refBgPeriodMap.get(bgPeriodNum2);
                if (!StringUtils.isEmpty((String)bgPeriodId)) {
                    pstmt.setString(1, _bgFormId);
                    pstmt.setString(2, bgPeriodId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{bgPeriodNum2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefBgPeriod(Connection conn, BOSUuid bgFormId) throws EASBizException {
        BgFacadeHelper.clearRefBgPeriod(conn, bgFormId.toString());
    }

    public static final void clearRefBgPeriod(Connection conn, String bgFormId) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgPeriod WHERE FBgFormID = ?");
            pstmt.setString(1, bgFormId);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void dealRefBgElement(Context ctx, BOSUuid bgFormId, Set refBgElementSet, Map refBgElementMap) throws EASBizException {
        if (ctx == null) return;
        if (bgFormId == null) return;
        if (refBgElementSet == null) return;
        if (refBgElementSet.isEmpty()) return;
        if (refBgElementMap == null) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgElementId = null;
        String bgElementNum2222222 = null;
        String _bgFormId = bgFormId.toString();
        BgRefBgPeriodInfo bgRefElementInfo = new BgRefBgPeriodInfo();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BgRefBgElement(FID, FBgFormID, FBgElementID) VALUES (?,?,?)");
            for (String bgElementNum2222222 : refBgElementSet) {
                if (!refBgElementMap.containsKey(bgElementNum2222222)) {
                    throw new BgFormException(BgFormException.SUBMITNOELEMENT, (Object[])new String[]{bgElementNum2222222});
                }
                bgElementId = (String)refBgElementMap.get(bgElementNum2222222);
                if (StringUtils.isEmpty((String)bgElementId)) {
                    throw new BgFormException(BgFormException.SUBMITNOELEMENT, (Object[])new String[]{bgElementNum2222222});
                }
                pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefElementInfo.getBOSType()).toString());
                pstmt.setString(2, BOSUuid.read((String)_bgFormId).toString());
                pstmt.setString(3, BOSUuid.read((String)bgElementId).toString());
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static final void clearRefBgElement(Connection conn, BOSUuid bgFormId, Map refBgElementMap, List delBgElementList) throws EASBizException {
        if (conn == null || bgFormId == null || refBgElementMap == null || refBgElementMap.isEmpty() || delBgElementList == null || delBgElementList.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgElementNum2 = null;
        String bgElementId = null;
        String _bgFormId = bgFormId.toString();
        HashSet<String> delBgElementSet = new HashSet<String>();
        for (String bgElementNum2 : delBgElementList) {
            delBgElementSet.add(bgElementNum2);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgElement WHERE FBgFormID = ? AND FBgElementID = ?");
            for (String bgElementNum2 : delBgElementSet) {
                bgElementId = (String)refBgElementMap.get(bgElementNum2);
                if (!StringUtils.isEmpty((String)bgElementId)) {
                    pstmt.setString(1, _bgFormId);
                    pstmt.setString(2, bgElementId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOELEMENT, (Object[])new String[]{bgElementNum2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefBgElement(Connection conn, BOSUuid bgFormId) throws EASBizException {
        BgFacadeHelper.clearRefBgElement(conn, bgFormId.toString());
    }

    public static final void clearRefBgElement(Connection conn, String bgFormId) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgElement WHERE FBgFormID = ?");
            pstmt.setString(1, bgFormId);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void dealRefCurrency(Context ctx, BOSUuid bgFormId, Set refCurrencySet, Map refCurrencyMap) throws EASBizException {
        if (ctx == null) return;
        if (bgFormId == null) return;
        if (refCurrencySet == null) return;
        if (refCurrencySet.isEmpty()) return;
        if (refCurrencyMap == null) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String currencyId = null;
        String currencyNum2222222 = null;
        String _bgFormId = bgFormId.toString();
        BgRefBgCurrencyInfo bgRefCurrencyInfo = new BgRefBgCurrencyInfo();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BgRefBgCurrency(FID, FBgFormID, FBgCurrencyID) VALUES (?, ?, ?)");
            for (String currencyNum2222222 : refCurrencySet) {
                if (!refCurrencyMap.containsKey(currencyNum2222222)) {
                    throw new BgFormException(BgFormException.SUBMITNOCURRENCY, (Object[])new String[]{currencyNum2222222});
                }
                currencyId = (String)refCurrencyMap.get(currencyNum2222222);
                if (StringUtils.isEmpty((String)currencyId)) {
                    throw new BgFormException(BgFormException.SUBMITNOCURRENCY, (Object[])new String[]{currencyNum2222222});
                }
                pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefCurrencyInfo.getBOSType()).toString());
                pstmt.setString(2, BOSUuid.read((String)_bgFormId).toString());
                pstmt.setString(3, BOSUuid.read((String)currencyId).toString());
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static final void clearRefCurrency(Connection conn, BOSUuid bgFormId, Map refCurrencyMap, List delCurrencyList) throws EASBizException {
        if (conn == null || bgFormId == null || refCurrencyMap == null || refCurrencyMap.isEmpty() || delCurrencyList == null || delCurrencyList.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String currencyNum2 = null;
        String currencyId = null;
        String _bgFormId = bgFormId.toString();
        HashSet<String> delCurrencySet = new HashSet<String>();
        for (String currencyNum2 : delCurrencyList) {
            delCurrencySet.add(currencyNum2);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgCurrency WHERE FBgFormID = ? AND FBgCurrencyID = ?");
            for (String currencyNum2 : delCurrencySet) {
                currencyId = (String)refCurrencyMap.get(currencyNum2);
                if (!StringUtils.isEmpty((String)currencyId)) {
                    pstmt.setString(1, _bgFormId);
                    pstmt.setString(2, currencyId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOCURRENCY, (Object[])new String[]{currencyNum2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearRefCurrency(Connection conn, BOSUuid bgFormId) throws EASBizException {
        BgFacadeHelper.clearRefCurrency(conn, bgFormId.toString());
    }

    public static final void clearRefCurrency(Connection conn, String bgFormId) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgCurrency WHERE FBgFormID = ?");
            pstmt.setString(1, bgFormId);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void clearFormulaOfForm(Connection conn, BOSUuid bgFormId) throws EASBizException {
        BgFacadeHelper.clearFormulaOfForm(conn, bgFormId.toString());
    }

    public static final void clearFormulaOfForm(Connection conn, String bgFormId) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgData WHERE FBgFormID = ?");
            pstmt.setString(1, bgFormId);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static IUIActionPostman prepareCustomAction(IUIObject uiObject, IItemAction action, String classname) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)uiObject);
        handler.setAvailabe(true);
        String actionName = null;
        String methodName = null;
        Method _method = null;
        RequestContext request = null;
        actionName = BgFacadeHelper.getActionName(action.getItemAction());
        try {
            methodName = "prepare" + actionName;
            _method = uiObject.getClass().getMethod(methodName, IItemAction.class);
            if (_method != null) {
                request = (RequestContext)_method.invoke((Object)uiObject, action);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        if (request != null) {
            request.setMethodName("handle" + actionName);
            request.setClassName(classname);
        }
        handler.setRequestContext(request);
        return handler;
    }

    private static String getActionName(ItemAction action) {
        String actionName = action.getClass().getName();
        if (actionName.indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        return actionName;
    }
}

