/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.client.tools.XMLHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgXMLImportOrExportFactory;
import com.kingdee.eas.ma.nbudget.BgXMLImportOrExportInfo;
import java.io.File;
import java.math.BigDecimal;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BgFormExportHelper {
    public static void exportToXML(BgFormInfo info, String fileName) throws Exception {
        if (info == null || fileName == null) {
            return;
        }
        Document doc = BgFormExportHelper.assemblyXML1(info);
        XMLHelper.writeXML((Document)doc, (File)new File(fileName));
    }

    public static Document assemblyXML1(BgFormInfo info) throws Exception {
        Book book = info.getBook();
        if (book == null || info.getBgTemplate() == null) {
            return null;
        }
        BgXMLImportOrExportInfo xmlInfo = new BgXMLImportOrExportInfo();
        xmlInfo.setId(BOSUuid.create((BOSObjectType)xmlInfo.getBOSType()));
        xmlInfo.setBook(book);
        IObjectPK pk = BgXMLImportOrExportFactory.getRemoteInstance().addnew(xmlInfo);
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("Schema");
        Element idElement = root.addElement("ID");
        idElement.addAttribute("value", pk.toString());
        Element templateElement = root.addElement("BgTemplateID");
        String bgTemplateId = info.getBgTemplate().getId().toString();
        templateElement.addAttribute("value", bgTemplateId);
        return doc;
    }

    public static Document assemblyXML(BgFormInfo info, int sheetIndex) throws Exception {
        Book book = info.getBook();
        if (book == null || info.getBgTemplate() == null) {
            return null;
        }
        Sheet sheet = book.getSheet(sheetIndex);
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("Schema");
        Element templateElement = root.addElement("BgTemplateID");
        String bgTemplateId = info.getBgTemplate().getId().toString();
        templateElement.addAttribute("value", bgTemplateId);
        Element sheetElement = root.addElement("SheetIndex");
        sheetElement.addAttribute("value", String.valueOf(sheetIndex));
        Cell cell = null;
        Element cellElement = null;
        Element bgItemElement = null;
        Element bgFormula = null;
        Element expression = null;
        String[] bgItemInfo = null;
        String formulaStr = null;
        String expressionStr = null;
        for (int row = 0; row < sheet.getMaxRowIndex() + 1; ++row) {
            for (int col = 0; col < sheet.getMaxColIndex() + 1; ++col) {
                cell = sheet.getCell(row, col, false);
                if (cell == null) continue;
                cellElement = root.addElement("Cell");
                String value = "";
                if (cell.getValue() != null && cell.getValue().getValue() != null) {
                    Object obj = cell.getValue().getValue();
                    if (obj instanceof String) {
                        value = (String)obj;
                    } else if (obj instanceof BigDecimal) {
                        BigDecimal big = (BigDecimal)obj;
                        value = big.toString();
                    }
                }
                cellElement.addAttribute("value", value);
                cellElement.addAttribute("row", String.valueOf(row));
                cellElement.addAttribute("col", String.valueOf(col));
                if (BgNFSHelper.checkHasBgItemInfo(cell)) {
                    bgItemInfo = BgNFSHelper.getBgItemInfo(cell);
                    bgItemElement = cellElement.addElement("BgItem");
                    bgItemElement.addAttribute("value", value);
                    bgItemElement.addAttribute("bgFillType", bgItemInfo[0]);
                    bgItemElement.addAttribute("bgFillValue", bgItemInfo[1]);
                    bgItemElement.addAttribute("bgFillValue_itemId", bgItemInfo[2]);
                }
                if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                    bgFormula = cellElement.addElement("BgFormula");
                    formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                    bgFormula.addAttribute("value", formulaStr);
                }
                if (!BgNFSHelper.checkHasExpression(cell)) continue;
                expression = cellElement.addElement("Expression");
                expressionStr = BgNFSHelper.getExpression(cell);
                expression.addAttribute("value", expressionStr);
            }
        }
        return doc;
    }
}

