/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemMappingInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.CreateBgTemFromRptException;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgItemGroup;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.app.RptBasePointObject;
import com.kingdee.eas.ma.nbudget.app.RptItemImportObject;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Point;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgImportFromRptHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.app.BgImportFromRptHelper");
    private static final String TAGE = "~!~";
    private static final String SYSTEM_BASE_LONGNUMBER = "hbbbllx!xtjczl";
    private static final String SYSTEM_BASE_FID = "w7yKCAEXEADgAAJjwKgSED6hTUY=";
    private static final String HAND_INPUT_FID = "w7yKCAEXEADgAAJ8wKgSED6hTUY=";
    private BgItemGroupInfo sgsrGroupInfo = null;
    private BgItemGroupInfo sysGroupInfo = null;
    private static final String GROUP_HAND_INPUT_TYPE = "HANG_INPUT";
    private static final String GROUP_SYSTEM_BASE_TYPE = "SYSTEM_BASE";
    public static final String POSTFIX_GROUPCOMMREPORT = "_gb";
    public static final String POSTFIX_SUMREPORT = "_hz";
    public static final String POSTFIX_CSLREPORT = "_hb";
    private IBgItemGroup iBgItemGroup = null;
    private IBgItem iBgItem = null;
    private static final String CUSTOMER_ASSTACTTYPE = "customer";
    private static final String MATERIAL_ASSTACTTYPE = "material";
    private static final String PROVIDER_ASSTACTTYPE = "provider";
    private static final String GENERAL_ASSACTTYPE = "generalAssActType";
    private static final String SELF_INPUT = "handMade";
    private static final int IMPORT_TEMPLATE = -1;
    private String defaultCurrencyNumber = "";
    private String defaultPeriodNumber = "NoExist";

    public static void convertRptTemplateNumber2BgTemplateNumber(TemplateInfo rptTempInfo) {
        if (rptTempInfo.getTemplateType().getValue() == 6 || rptTempInfo.getTemplateType().getValue() == 10) {
            rptTempInfo.setNumber(rptTempInfo.getNumber() + POSTFIX_GROUPCOMMREPORT);
        }
        if (rptTempInfo.getTemplateType().getValue() == 3 || rptTempInfo.getTemplateType().getValue() == 11) {
            rptTempInfo.setNumber(rptTempInfo.getNumber() + POSTFIX_SUMREPORT);
        }
        if (rptTempInfo.getTemplateType().getValue() == 5 || rptTempInfo.getTemplateType().getValue() == 13) {
            rptTempInfo.setNumber(rptTempInfo.getNumber() + POSTFIX_CSLREPORT);
        }
    }

    public void init(Context ctx) throws BOSException, EASBizException {
        this.iBgItemGroup = this.getGroupBizInterface(ctx);
        this.iBgItem = this.getBgItemBizInterface(ctx);
        try {
            this.getDefaultGroupInfo(ctx, GROUP_HAND_INPUT_TYPE);
            this.getDefaultGroupInfo(ctx, GROUP_SYSTEM_BASE_TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void convertRptTemplateBook2BgTemplateBook(Context ctx, TemplateInfo reportTem, BgTemplateInfo templateInfo, StringBuffer msg, String orgUnitId) throws EASBizException, BOSException {
        if (msg == null) {
            msg = new StringBuffer();
        }
        templateInfo.setName(reportTem.getName());
        templateInfo.setNumber(reportTem.getNumber());
        MeasureUnitCollection col = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection("where measureUnitGroup.number='BUDGET' and isBaseUnit = 1");
        if (col == null || col.isEmpty()) {
            throw new CreateBgTemFromRptException(CreateBgTemFromRptException.BGBASEMEAUSREUNITNOTEXIT);
        }
        templateInfo.setDefaultMeasureUnit(col.get(0));
        Book rptTemplateBook = null;
        try {
            rptTemplateBook = reportTem.getBook();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, (Throwable)e);
        }
        if (rptTemplateBook == null) {
            return;
        }
        Book bookBg = this.process(ctx, rptTemplateBook, msg, -1, null, templateInfo.getNumber(), orgUnitId);
        try {
            templateInfo.setBook(bookBg);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, (Throwable)e);
        }
    }

    public String convertRptFormBook2BgFormBook(Context ctx, String rptId, BgFormInfo bgFormInfo, String currencyNumber, String periodNumber, int importType, boolean isAddNew, Map formulaMap, String bgTempNumber, String checkMsg, String orgUnitId) throws Exception {
        this.defaultCurrencyNumber = currencyNumber;
        this.defaultPeriodNumber = periodNumber;
        Map actualMap = null;
        IBgForm ibgForm = null;
        Book rptFormBook = null;
        StringBuffer msg = new StringBuffer();
        CslReportInfo cslRptInfo = (CslReportInfo)CslReportFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(rptId), this.getRptSelector());
        byte[] _data = cslRptInfo.getData();
        if (_data == null || _data.length == 0) {
            return checkMsg;
        }
        rptFormBook = cslRptInfo.getBook();
        Book bgFormbook = this.process(ctx, rptFormBook, msg, importType, formulaMap, bgTempNumber, orgUnitId);
        boolean canSave = this.check(bgFormbook);
        if (isAddNew) {
            if (canSave) {
                BgNFSHelper.checkBookSign(bgFormbook);
                if (importType == 1) {
                    BgNFSHelper.setBudget((IObjectValue)bgFormInfo);
                    actualMap = this.getActualData(bgFormInfo.getBook());
                    this.setActualData(bgFormbook, actualMap);
                }
                bgFormInfo.setBook(bgFormbook);
                ibgForm = BgFormFactory.getLocalInstance((Context)ctx);
                if (importType == 2) {
                    BgNFSHelper.setActual((IObjectValue)bgFormInfo);
                }
                if (!formulaMap.isEmpty()) {
                    ibgForm.save((CoreBaseInfo)bgFormInfo);
                }
            } else {
                checkMsg = "FormulaRepeatCantSave";
            }
        }
        return checkMsg;
    }

    private boolean check(Book book) {
        HashMap formulaMap = new HashMap();
        boolean canSave = true;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet currentSheet = book.getSheet(i);
            int maxRow = currentSheet.getMaxRowIndex();
            int maxCol = currentSheet.getMaxColIndex();
            block1: for (int rIndex = 0; rIndex <= maxRow; ++rIndex) {
                for (int cIndex = 0; cIndex <= maxCol; ++cIndex) {
                    Cell tempCell = currentSheet.getCell(rIndex, cIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(tempCell)) continue;
                    String formulaStr = BgNFSHelper.getFormulaOfCell(tempCell);
                    if (formulaMap.containsKey(formulaStr)) {
                        canSave = false;
                        continue block1;
                    }
                    formulaMap.put(formulaStr, null);
                }
            }
        }
        return canSave;
    }

    private Map getActualData(Book book) {
        HashMap<String, BigDecimal> actualMap = new HashMap<String, BigDecimal>();
        if (book == null) {
            return actualMap;
        }
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet currentSheet = book.getSheet(i);
            int maxRow = currentSheet.getMaxRowIndex();
            int maxCol = currentSheet.getMaxColIndex();
            for (int rIndex = 0; rIndex <= maxRow; ++rIndex) {
                for (int cIndex = 0; cIndex <= maxCol; ++cIndex) {
                    String formulaStr;
                    Cell tempCell = currentSheet.getCell(rIndex, cIndex, false);
                    String[] param = null;
                    if (!BgNFSHelper.checkHasFormulaOfCell(tempCell) || (param = BgNFSHelper.parseFormulaPara(null, formulaStr = BgNFSHelper.getFormulaOfCell(tempCell))) == null || param.length != 6 || BgNConstants.ZERO.equals(BgNFSHelper.getActualValue(tempCell))) continue;
                    String _key = param[0] + "_" + param[2] + "_" + param[1] + "_" + param[5];
                    actualMap.put(_key, BgNFSHelper.getActualValue(tempCell));
                }
            }
        }
        return actualMap;
    }

    private void setActualData(Book book, Map actualMap) {
        if (book == null || actualMap == null || actualMap.isEmpty()) {
            return;
        }
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet currentSheet = book.getSheet(i);
            int maxRow = currentSheet.getMaxRowIndex();
            int maxCol = currentSheet.getMaxColIndex();
            for (int rIndex = 0; rIndex <= maxRow; ++rIndex) {
                for (int cIndex = 0; cIndex <= maxCol; ++cIndex) {
                    String _key;
                    String formulaStr;
                    Cell tempCell = currentSheet.getCell(rIndex, cIndex, false);
                    String[] param = null;
                    if (!BgNFSHelper.checkHasFormulaOfCell(tempCell) || (param = BgNFSHelper.parseFormulaPara(null, formulaStr = BgNFSHelper.getFormulaOfCell(tempCell))) == null || param.length != 6 || !actualMap.containsKey(_key = param[0] + "_" + param[2] + "_" + param[1] + "_" + param[5])) continue;
                    BigDecimal value = (BigDecimal)actualMap.get(_key);
                    BgNFSHelper.setActualValue(tempCell, value);
                }
            }
        }
    }

    private SelectorItemCollection getRptSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        return sic;
    }

    private Book process(Context ctx, Book reportBook, StringBuffer msg, int importType, Map formulaMap, String bgTemplateNumber, String orgUnitId) throws EASBizException, BOSException {
        HashMap elementMap = new HashMap();
        HashMap bgPeriodMap = new HashMap();
        Book bgBook = Book.Manager.getNewBook((String)reportBook.getName(), (int)reportBook.getSheetCount());
        Sheet reportSheet = null;
        Sheet templateSheet = null;
        Row reportRow = null;
        Row templateRow = null;
        Cell reportCell = null;
        Cell templateCell = null;
        String formula = null;
        Object value = null;
        HashMap cellMap = new HashMap();
        List allBaseInfoList = null;
        HashMap rptNumberMap = new HashMap();
        HashMap spreadNumberMap = new HashMap();
        bgBook.setCalculate(false);
        int sheetCount = reportBook.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            reportSheet = reportBook.getSheet(i);
            templateSheet = bgBook.getSheet(i);
            templateSheet.copySheetFrom(reportSheet);
            templateSheet.setName(reportSheet.getSheetName());
            allBaseInfoList = this.getAllBasePointInfo(reportSheet);
            int maxRowIndex = reportSheet.getMaxRowIndex() + 1;
            for (int j = 0; j < maxRowIndex; ++j) {
                reportRow = reportSheet.getRow(j, false);
                if (reportRow == null) continue;
                templateRow = templateSheet.getRow(j, true);
                int maxColIndex = reportSheet.getMaxColIndex() + 1;
                for (int k = 0; k < maxColIndex; ++k) {
                    reportCell = reportRow.getCell(k, false);
                    if (reportCell == null) continue;
                    templateCell = templateRow.getCell(k, true);
                    if (this.checkIsInTheBasePointRange(j, k, allBaseInfoList)) continue;
                    if (reportCell.hasFormula()) {
                        formula = BgNFSHelper.getExpression(reportCell);
                        BgNTemplateHelper.setBgDataValue(templateCell, "BG_BUDGET_EXPRESSIONS", formula, false);
                        BgNTemplateHelper.setBgDataValue(templateCell, "BG_ACTUAL_EXPRESSIONS", formula, false);
                        BgNTemplateHelper.setBgDataValue(templateCell, "BG_ADD_EXPRESSIONS", formula, false);
                        BgNFSHelper.setExpression(templateCell, formula);
                        value = BgNFSHelper.getValue(reportCell);
                        BgNFSHelper.setValue(templateCell, value);
                        continue;
                    }
                    value = BgNFSHelper.getValue(reportCell);
                    BgNFSHelper.setValue(templateCell, value);
                    BgNFSHelper.setNumberFormat(templateCell, "@");
                }
            }
            this.parseRptBook(ctx, reportSheet, templateSheet, allBaseInfoList, msg, rptNumberMap, spreadNumberMap, elementMap, bgPeriodMap, cellMap, importType);
        }
        if (rptNumberMap.isEmpty()) {
            return bgBook;
        }
        boolean canRepeat = BgSHelper.isBgItemNumberRepeat((Context)ctx);
        List mappingList = this.getAllItemMappingInfo(ctx, rptNumberMap, canRepeat, orgUnitId);
        List itemList = null;
        this.getRptItemLongNumber(ctx, rptNumberMap);
        StringBuffer rptNumberQueryStr = new StringBuffer("(");
        for (String rptNumber : rptNumberMap.keySet()) {
            boolean hasMapping = false;
            int size = mappingList.size();
            for (int i = 0; i < size; ++i) {
                BgItemMappingInfo info = (BgItemMappingInfo)mappingList.get(i);
                if (!info.getRptNumber().equals(rptNumber)) continue;
                hasMapping = true;
                break;
            }
            if (hasMapping) continue;
            rptNumberQueryStr.append("'" + rptNumber + "',");
        }
        rptNumberQueryStr.delete(rptNumberQueryStr.length() - 1, rptNumberQueryStr.length()).append(")");
        itemList = this.getAllExistBgItem(ctx, canRepeat, rptNumberQueryStr.toString(), itemList, orgUnitId);
        this.checkRptItemExistInBgItem(rptNumberMap, mappingList, itemList);
        HashMap mapTemPeriod = new HashMap();
        HashMap mapTemItem = new HashMap();
        this.checkAllExit(ctx, bgPeriodMap, "t_bg_Bgperiod", mapTemPeriod, msg);
        HashMap temMapElement = new HashMap();
        this.checkAllElementExit(ctx, elementMap, temMapElement, msg, bgTemplateNumber);
        if (!spreadNumberMap.isEmpty()) {
            rptNumberQueryStr = new StringBuffer("(");
            Iterator it = spreadNumberMap.keySet().iterator();
            while (it.hasNext()) {
                rptNumberQueryStr.append("'" + (String)it.next() + "',");
            }
            rptNumberQueryStr.delete(rptNumberQueryStr.length() - 1, rptNumberQueryStr.length()).append(")");
            this.getAllExistBgItem(ctx, canRepeat, rptNumberQueryStr.toString(), itemList, orgUnitId);
        }
        this.spreadNumberConvertBgItemObj(spreadNumberMap, itemList);
        this.reBuildBgItemFormula(bgPeriodMap, msg, "t_bg_Bgperiod", mapTemPeriod);
        this.reBuildBgItemFormula(elementMap, msg, "t_Bg_bgelement", temMapElement);
        this.convertItemFormula(cellMap, rptNumberMap, spreadNumberMap, msg, formulaMap, importType);
        if (itemList != null) {
            itemList.clear();
        }
        if (mappingList != null) {
            mappingList.clear();
        }
        return bgBook;
    }

    private void convertItemFormula(Map cellMap, Map rptNumberMap, Map spreadNumberMap, StringBuffer msg, Map formulaMap, int importType) {
        if (cellMap == null || cellMap.isEmpty()) {
            return;
        }
        HashSet<String> noExistNumberSet = new HashSet<String>();
        HashSet<String> errorCombineSet = new HashSet<String>();
        BigDecimal value = null;
        for (String cellKey : cellMap.keySet()) {
            StringTokenizer st = new StringTokenizer(cellKey, "^*^");
            String asstActType = "";
            String formulaStr = "";
            String[] param = null;
            String newFormula = "";
            Cell cell = (Cell)cellMap.get(cellKey);
            if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
            formulaStr = BgNFSHelper.getFormulaOfCell(cell);
            if (st.hasMoreTokens()) {
                asstActType = st.nextToken();
            }
            if ((param = BgNFSHelper.parseFormulaPara(null, formulaStr)) == null || param.length == 0) {
                BgNFSHelper.clearFormulaOfCell((Cell)cellMap.get(cellKey));
                continue;
            }
            String[] rptAndSpreadNumber = param[0].split("_");
            String rptNumber = rptAndSpreadNumber[0];
            String spreadNumber = rptAndSpreadNumber[1];
            RptItemImportObject rptObj = null;
            RptItemImportObject spreadObj = null;
            if (rptNumberMap.containsKey(rptNumber)) {
                rptObj = (RptItemImportObject)rptNumberMap.get(rptNumber);
            }
            if (spreadNumberMap.containsKey(asstActType)) {
                Map spreadMap = (Map)spreadNumberMap.get(asstActType);
                if (spreadMap.containsKey(spreadNumber)) {
                    spreadObj = (RptItemImportObject)spreadMap.get(spreadNumber);
                }
            } else {
                BgNFSHelper.clearFormulaOfCell(cell);
                continue;
            }
            if (rptObj == null) {
                BgNFSHelper.clearFormulaOfCell((Cell)cellMap.get(cellKey));
                noExistNumberSet.add(rptNumber);
                continue;
            }
            if (spreadObj == null) {
                BgNFSHelper.clearFormulaOfCell((Cell)cellMap.get(cellKey));
                String[] tempNumber = spreadNumber.split("!");
                noExistNumberSet.add(tempNumber[tempNumber.length - 1]);
                continue;
            }
            String combineNumber = this.getCombineBgItem(rptObj, spreadObj);
            if ("".equals(combineNumber)) {
                BgNFSHelper.clearFormulaOfCell((Cell)cellMap.get(cellKey));
                String[] tempNumber = spreadNumber.split("!");
                errorCombineSet.add(rptNumber + "," + tempNumber[tempNumber.length - 1]);
                continue;
            }
            param[0] = combineNumber;
            if (param[5] != null && param[5].trim().length() == 0) {
                param[5] = this.defaultCurrencyNumber;
            }
            int offset = -10000;
            if (param[1].indexOf("Y") == -1 || param[1].indexOf(".") == -1) {
                offset = Integer.valueOf(param[1]);
                if (param[1] != null && param[1].trim().length() > 0 && offset > -10000 && !this.defaultPeriodNumber.equals("NoExist")) {
                    param[1] = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression(this.defaultPeriodNumber, offset);
                }
            }
            newFormula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\"," + param[4] + ",\"" + param[5] + "\")";
            BgNFSHelper.setFormulaOfCell(cell, newFormula);
            if (importType == -1 || formulaMap == null) continue;
            String key = param[0] + "_" + param[2] + "_" + param[1] + "_" + param[5];
            if (importType == 2) {
                value = BgNFSHelper.getActualValue(cell);
                formulaMap.put(key, value);
            }
            if (importType == 1) {
                value = BgNFSHelper.getBudgetValue(cell);
                formulaMap.put(key, value);
            }
            if (importType == 3) {
                if (BgNFSHelper.getValue(cell) != null && BgNFSHelper.getValue(cell) instanceof BigDecimal) {
                    value = (BigDecimal)BgNFSHelper.getValue(cell);
                }
                if (value != null && value.doubleValue() != 0.0) {
                    formulaMap.put(key, value);
                }
            }
            value = null;
        }
        if (errorCombineSet.size() > 0) {
            for (String errorInfo : errorCombineSet) {
                msg.append(new CreateBgTemFromRptException(CreateBgTemFromRptException.BGITEMCOMBINEERROR, (Object[])new String[]{errorInfo}).getMessage() + "\n\r");
            }
        }
        if (noExistNumberSet.size() > 0) {
            for (String errorInfo : noExistNumberSet) {
                msg.append(new CreateBgTemFromRptException(CreateBgTemFromRptException.BGITEMNOTEXIT, (Object[])new String[]{errorInfo}).getMessage() + "\n\r");
            }
        }
    }

    private String getCombineBgItem(RptItemImportObject rptObj, RptItemImportObject spreadObj) {
        String combineNumber = "";
        if (rptObj.getRefField() == null || spreadObj.getRefField() == null) {
            return combineNumber;
        }
        if (rptObj.getRefField().compareTo(spreadObj.getRefField()) < 0) {
            combineNumber = rptObj.getNumber() + "," + spreadObj.getNumber();
        }
        if (rptObj.getRefField().compareTo(spreadObj.getRefField()) > 0) {
            combineNumber = spreadObj.getNumber() + "," + rptObj.getNumber();
        }
        if (rptObj.getRefField().compareTo(spreadObj.getRefField()) == 0) {
            combineNumber = "";
        }
        return combineNumber;
    }

    private void spreadNumberConvertBgItemObj(Map spreadMap, List itemList) {
        if (spreadMap == null || spreadMap.isEmpty()) {
            return;
        }
        for (String asstActType : spreadMap.keySet()) {
            Map numberMap = (Map)spreadMap.get(asstActType);
            block1: for (String number : numberMap.keySet()) {
                if (SELF_INPUT.equals(asstActType)) {
                    String tempNumber = number;
                    tempNumber = tempNumber.replaceAll("\\.", "#").replaceAll("!", "@").replaceAll("_", "-");
                    tempNumber = tempNumber + SELF_INPUT;
                    for (int i = 0; i < itemList.size(); ++i) {
                        RptItemImportObject obj = (RptItemImportObject)itemList.get(i);
                        if (!obj.getNumber().equals(tempNumber)) continue;
                        numberMap.put(number, obj);
                        continue block1;
                    }
                    continue;
                }
                for (int i = 0; i < itemList.size(); ++i) {
                    String bgLongNumber;
                    String rptLongNumber;
                    RptItemImportObject obj = (RptItemImportObject)itemList.get(i);
                    String[] numbers = number.split("\\!");
                    if ((CUSTOMER_ASSTACTTYPE.equals(asstActType) || MATERIAL_ASSTACTTYPE.equals(asstActType) || PROVIDER_ASSTACTTYPE.equals(asstActType)) && (rptLongNumber = number).equals(bgLongNumber = obj.getLongNumber().replaceAll(asstActType, "").replaceAll("group", ""))) {
                        numberMap.put(number, obj);
                        continue block1;
                    }
                    String rptTempNumber = this.number2BgItemNumber(numbers[numbers.length - 1], asstActType, "");
                    if (!rptTempNumber.equals(obj.getNumber())) continue;
                    numberMap.put(number, obj);
                    continue block1;
                }
            }
        }
    }

    private void getRptItemLongNumber(Context ctx, Map rptNumberMap) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer query = new StringBuffer();
        Connection conn = null;
        query.append("(");
        Iterator it = rptNumberMap.keySet().iterator();
        while (it.hasNext()) {
            query.append("'" + it.next() + "',");
        }
        query.delete(query.length() - 1, query.length());
        query.append(")");
        StringBuffer sql = new StringBuffer("select FNumber,FName_" + ctx.getLocale() + " as name,FLongNumber from T_Csl_RPTItem");
        if (query.toString().trim().length() <= 2) {
            return;
        }
        sql.append(" where FNumber in " + query.toString());
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                RptItemImportObject obj = new RptItemImportObject();
                String number = rst.getString("FNumber");
                obj.setName(rst.getString("name"));
                obj.setNumber(number);
                obj.setLongNumber(rst.getString("FLongNumber"));
                rptNumberMap.put(number, obj);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private List dealWithBgItemAndBgItemGroup(Context ctx, Map spreadNumberMap, Map allNumberMap, boolean canRepeat, String orgUnitId) throws EASBizException, BOSException {
        if (spreadNumberMap == null || spreadNumberMap.isEmpty()) {
            return null;
        }
        List itemList = null;
        List bgItemGroupList = this.getAllBgItemGroup(ctx);
        Map asstactTypeMap = this.getAsstActInfo(ctx, spreadNumberMap);
        BgItemGroupInfo groupInfo = null;
        Iterator it = spreadNumberMap.keySet().iterator();
        while (it.hasNext()) {
            Map asstActTypeMap;
            groupInfo = null;
            String asstActType = (String)it.next();
            if (SELF_INPUT.equals(asstActType)) {
                asstActTypeMap = (Map)spreadNumberMap.get(asstActType);
                this.dealWithSpreadItem(ctx, asstActTypeMap, asstActType, this.sgsrGroupInfo, null, allNumberMap);
                continue;
            }
            groupInfo = this.getExistBgItemGroup(asstActType, bgItemGroupList);
            if (groupInfo != null) {
                asstActTypeMap = (Map)spreadNumberMap.get(asstActType);
                this.dealWithSpreadItem(ctx, asstActTypeMap, asstActType, groupInfo, asstactTypeMap.get(asstActType), allNumberMap);
                continue;
            }
            BgItemGroupInfo newInfo = this.addBgItemGroup(bgItemGroupList, asstactTypeMap, asstActType);
            if (newInfo == null) continue;
            Map asstActTypeMap2 = (Map)spreadNumberMap.get(asstActType);
            this.dealWithSpreadItem(ctx, asstActTypeMap2, asstActType, newInfo, asstactTypeMap.get(asstActType), allNumberMap);
        }
        StringBuffer queryStr = new StringBuffer("(");
        for (String str : allNumberMap.keySet()) {
            queryStr.append("'" + str.split(TAGE)[0] + "',");
        }
        queryStr.delete(queryStr.length() - 1, queryStr.length()).append(")");
        itemList = this.getAllExistBgItem(ctx, canRepeat, queryStr.toString(), itemList, orgUnitId);
        for (int i = 0; i < itemList.size(); ++i) {
            RptItemImportObject existObj = (RptItemImportObject)itemList.get(i);
            Iterator it2 = allNumberMap.keySet().iterator();
            while (it2.hasNext()) {
                String tempStr = (String)it2.next();
                String[] tempstrs = tempStr.split(TAGE);
                String number = tempstrs[0];
                String lNumber = tempstrs[1];
                if (!existObj.getLongNumber().equals(lNumber) && !existObj.getNumber().equals(number)) continue;
                it2.remove();
            }
        }
        if (!allNumberMap.isEmpty()) {
            RptItemImportObject obj;
            BgItemCollection col = new BgItemCollection();
            ArrayList<RptItemImportObject> tempList = new ArrayList<RptItemImportObject>();
            queryStr = new StringBuffer("(");
            for (String str : allNumberMap.keySet()) {
                obj = (RptItemImportObject)allNumberMap.get(str);
                tempList.add(obj);
                queryStr.append("'" + str.split(TAGE)[0] + "',");
            }
            queryStr.delete(queryStr.length() - 1, queryStr.length()).append(")");
            Collections.sort(tempList);
            for (int i = 0; i < tempList.size(); ++i) {
                BgItemInfo bgItemInfo = new BgItemInfo();
                obj = (RptItemImportObject)tempList.get(i);
                bgItemInfo.setId(BOSUuid.create((BOSObjectType)bgItemInfo.getBOSType()));
                bgItemInfo.setNumber(obj.getNumber());
                bgItemInfo.setName(obj.getName());
                bgItemInfo.setLongNumber(obj.getLongNumber());
                bgItemInfo.setBgItemGroup(obj.getGroupInfo());
                bgItemInfo.setRefField(obj.getRefField());
                bgItemInfo.setIsEffective(true);
                bgItemInfo.setLevel(obj.getLevel());
                bgItemInfo.setOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
                col.add(bgItemInfo);
            }
            BgItemFactory.getLocalInstance((Context)ctx).importItems(col, orgUnitId, null);
        }
        return this.getAllExistBgItem(ctx, canRepeat, queryStr.toString(), itemList, orgUnitId);
    }

    private BgItemGroupInfo addBgItemGroup(List bgItemGroupList, Map asstactTypeMap, String asstActType) throws BOSException, EASBizException {
        if (asstactTypeMap == null || asstactTypeMap.isEmpty()) {
            return null;
        }
        BgItemGroupInfo bgGroupInfo = null;
        if (asstactTypeMap.containsKey(asstActType)) {
            AsstActTypeInfo asstInfo = (AsstActTypeInfo)asstactTypeMap.get(asstActType);
            String number = this.number2BgItemNumber(asstInfo.getNumber(), asstActType, "");
            number = this.getBgGroupNumber(asstInfo.getNumber(), bgItemGroupList, asstActType);
            String longNumber = "hbbbllx!xtjczl!" + number;
            bgGroupInfo = new BgItemGroupInfo();
            bgGroupInfo.setAsstActType(asstActType);
            bgGroupInfo.setNumber(number);
            bgGroupInfo.setName(asstInfo.getName());
            bgGroupInfo.setLongNumber(longNumber);
            bgGroupInfo.setParent(this.sysGroupInfo);
            bgGroupInfo.setId(BOSUuid.create((BOSObjectType)bgGroupInfo.getBOSType()));
            bgGroupInfo.setLevel(this.sysGroupInfo.getLevel() + 1);
            bgGroupInfo.setIsCash(false);
            this.iBgItemGroup.addnew((CoreBaseInfo)bgGroupInfo);
        }
        return bgGroupInfo;
    }

    private String getBgGroupNumber(String number, List itemGroupList, String asstActType) {
        if (itemGroupList == null || itemGroupList.size() == 0) {
            return number;
        }
        for (int i = 0; i < itemGroupList.size(); ++i) {
            BgItemGroupInfo info = (BgItemGroupInfo)itemGroupList.get(i);
            if (!number.equals(info.getNumber())) continue;
            number = number + asstActType;
            break;
        }
        return number;
    }

    private BgItemGroupInfo getExistBgItemGroup(String asstActType, List bgItemGroupList) {
        if (bgItemGroupList == null || bgItemGroupList.size() == 0) {
            return null;
        }
        for (int i = 0; i < bgItemGroupList.size(); ++i) {
            BgItemGroupInfo info = (BgItemGroupInfo)bgItemGroupList.get(i);
            if (!asstActType.equals(info.getAsstActType())) continue;
            return info;
        }
        return null;
    }

    private BgItemGroupInfo getDefaultGroupInfo(Context ctx, String groupType) throws EASBizException, BOSException {
        if (GROUP_HAND_INPUT_TYPE.equals(groupType) && this.sgsrGroupInfo == null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)HAND_INPUT_FID));
            this.sgsrGroupInfo = (BgItemGroupInfo)this.getGroupBizInterface(ctx).getValue((IObjectPK)pk);
            return this.sgsrGroupInfo;
        }
        if (GROUP_SYSTEM_BASE_TYPE.equals(groupType) && this.sysGroupInfo == null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)SYSTEM_BASE_FID));
            this.sysGroupInfo = (BgItemGroupInfo)this.getGroupBizInterface(ctx).getValue((IObjectPK)pk);
            return this.sysGroupInfo;
        }
        return null;
    }

    private IBgItemGroup getGroupBizInterface(Context ctx) throws BOSException {
        if (this.iBgItemGroup == null) {
            this.iBgItemGroup = BgItemGroupFactory.getLocalInstance((Context)ctx);
        }
        return this.iBgItemGroup;
    }

    private IBgItem getBgItemBizInterface(Context ctx) throws BOSException {
        if (this.iBgItem == null) {
            this.iBgItem = BgItemFactory.getLocalInstance((Context)ctx);
        }
        return this.iBgItem;
    }

    private void dealWithSpreadItem(Context ctx, Map asstActTypeMap, String asstActType, BgItemGroupInfo groupInfo, Object asstActTypeObj, Map allNumberMap) throws EASBizException, BOSException {
        if (SELF_INPUT.equals(asstActType)) {
            HashSet<String> numberSet = new HashSet<String>();
            for (String spreadNumber : asstActTypeMap.keySet()) {
                String name = null;
                String[] params = spreadNumber.split(TAGE);
                if (params != null && params.length == 2) {
                    int endIndex;
                    int beginIndex;
                    spreadNumber = params[0];
                    if (spreadNumber.indexOf("-") != -1 && (beginIndex = spreadNumber.indexOf("-") + 1) < (endIndex = spreadNumber.length())) {
                        name = spreadNumber.substring(spreadNumber.indexOf("-") + 1, spreadNumber.length());
                    }
                    if (name == null) {
                        name = params[1];
                    }
                }
                numberSet.add(spreadNumber);
                spreadNumber = spreadNumber + SELF_INPUT;
                RptItemImportObject obj = new RptItemImportObject();
                obj.setName(name);
                obj.setLongNumber(spreadNumber);
                obj.setAsstActType(SELF_INPUT);
                obj.setNumber(spreadNumber);
                obj.setRefField(groupInfo.getRefField());
                obj.setLevel(1);
                obj.setEffective(false);
                obj.setGroupInfo(groupInfo);
                allNumberMap.put(spreadNumber + TAGE + spreadNumber, obj);
            }
            asstActTypeMap.clear();
            for (String number : numberSet) {
                asstActTypeMap.put(number, null);
            }
            return;
        }
        if (CUSTOMER_ASSTACTTYPE.equals(asstActType) || MATERIAL_ASSTACTTYPE.equals(asstActType) || PROVIDER_ASSTACTTYPE.equals(asstActType)) {
            StringBuffer sql = new StringBuffer("");
            StringBuffer groupSql = new StringBuffer("");
            String queryStr = this.getQueryString(asstActType, asstActTypeMap, false);
            String groupStr = this.getQueryString(asstActType, asstActTypeMap, true);
            if (CUSTOMER_ASSTACTTYPE.equals(asstActType)) {
                sql.append("select testGroup.*,customer.FNumber as itemNumber,customer.FName_" + ctx.getLocale() + "    as itemName from  (select distinct csGroup.Fid as FID, csGroup.FNumber as groupNumber,    csGroup.FLongNumber as groupLNumber,csGroup.FName_" + ctx.getLocale() + "    as groupName,csGroup.FLevel as groupLevel from T_BD_CSSPGroup csGroup,    T_BD_CSSPGroupStandard groupStandard    where csGroup.Fcsspgroupstandardid = groupStandard.Fid    and csGroup.FDeletedStatus = 1 and (groupStandard.Ftype = 0    or groupStandard.Ftype = 1)) testGroup left outer join T_BD_Customer customer     on customer.FBrowseGroupID = testGroup.FID and customer.FEffectedStatus=2");
                groupSql.append("select distinct csGroup.Fid as FID, csGroup.FNumber as groupNumber,    csGroup.FLongNumber as groupLNumber,csGroup.FName_" + ctx.getLocale() + "    as groupName,csGroup.FLevel as groupLevel from T_BD_CSSPGroup csGroup,    T_BD_CSSPGroupStandard groupStandard    where csGroup.Fcsspgroupstandardid = groupStandard.Fid    and csGroup.FDeletedStatus = 1 and (groupStandard.Ftype = 0    or groupStandard.Ftype = 1) ");
                if (groupStr != null && groupStr.trim().length() > 2) {
                    groupSql.append("and  csGroup.FNumber in " + groupStr);
                }
                if (queryStr != null && queryStr.trim().length() > 2) {
                    sql.append(" where customer.FNumber IN " + queryStr);
                }
            }
            if (MATERIAL_ASSTACTTYPE.equals(asstActType)) {
                sql.append(" select csGroup.FNumber as groupNumber,csGroup.FLongNumber as groupLNumber,csGroup.FName_" + ctx.getLocale() + " as  groupName,csGroup.FLevel as groupLevel,customer.FNumber as itemNumber,customer.FName_" + ctx.getLocale() + " as itemName from T_BD_MaterialGroup csGroup,T_BD_Material customer where customer.FMaterialGroupID = csGroup.FID and FEffectedStatus=2 order by groupLevel");
                groupSql.append("select csGroup.FNumber as groupNumber,csGroup.FLongNumber as groupLNumber,csGroup.FName_" + ctx.getLocale() + " as  groupName,csGroup.FLevel as groupLevel from T_BD_MaterialGroup csGroup ");
                if (groupStr != null && groupStr.trim().length() > 2) {
                    groupSql.append("where csGroup.FNumber in " + groupStr);
                }
                if (queryStr != null && queryStr.trim().length() > 2) {
                    sql.append(" where customer.FNumber IN " + queryStr);
                }
            }
            if (PROVIDER_ASSTACTTYPE.equals(asstActType)) {
                sql.append("   select testGroup.*,customer.FNumber as itemNumber,customer.FName_" + ctx.getLocale() + "    as itemName from  (select distinct csGroup.Fid as FID, csGroup.FNumber as groupNumber,    csGroup.FLongNumber as groupLNumber,csGroup.FName_" + ctx.getLocale() + "    as groupName,csGroup.FLevel as groupLevel from T_BD_CSSPGroup csGroup,    T_BD_CSSPGroupStandard groupStandard    where csGroup.Fcsspgroupstandardid = groupStandard.Fid     and csGroup.FDeletedStatus = 1 and (groupStandard.Ftype = 0    or groupStandard.Ftype = 2)) testGroup left outer join T_BD_Supplier customer     on customer.FBrowseGroupID = testGroup.FID and customer.FEffectedStatus=2");
                groupSql.append("select distinct csGroup.Fid as FID, csGroup.FNumber as groupNumber,    csGroup.FLongNumber as groupLNumber,csGroup.FName_" + ctx.getLocale() + "    as groupName,csGroup.FLevel as groupLevel from T_BD_CSSPGroup csGroup,    T_BD_CSSPGroupStandard groupStandard    where csGroup.Fcsspgroupstandardid = groupStandard.Fid     and csGroup.FDeletedStatus = 1 and (groupStandard.Ftype = 0    or groupStandard.Ftype = 2) ");
                if (groupStr != null && groupStr.trim().length() > 2) {
                    groupSql.append("and  csGroup.FNumber in " + groupStr);
                }
                if (queryStr != null && queryStr.trim().length() > 2) {
                    sql.append(" where customer.FNumber IN " + queryStr);
                }
            }
            this.dealWithSpecialSpreadGroupItem(ctx, groupSql.toString(), asstActType, allNumberMap, groupInfo);
            this.dealWithSpecialSpreadItem(ctx, sql.toString(), asstActType, allNumberMap, groupInfo);
        } else if (asstActType != null && asstActType.startsWith(GENERAL_ASSACTTYPE)) {
            String queryStr = this.getQueryString(asstActType, asstActTypeMap, true);
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeObj;
            String groupId = asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
            StringBuffer sql = new StringBuffer("select FNumber,FLongNumber,FName_" + ctx.getLocale() + " as name,FLevel from T_BD_GeneralAsstActType where FGroupId = '" + groupId + "'");
            if (queryStr != null && queryStr.trim().length() > 2) {
                sql.append(" and FNumber IN " + queryStr);
            }
            this.dealWithGeneralSpreadItem(ctx, sql.toString(), asstActType, allNumberMap, groupInfo);
        } else {
            String queryStr = this.getQueryString(asstActType, asstActTypeMap, true);
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeObj;
            String tableName = asstActTypeInfo.getRealtionDataObject();
            String colLongNumberName = "FLongNumber";
            String colLevelName = "FLevel";
            boolean hasLongNumber = this.checkColumnExist(ctx, tableName, colLongNumberName);
            boolean hasLevel = this.checkColumnExist(ctx, tableName, colLevelName);
            StringBuffer sql = new StringBuffer("select FNumber,FName_" + ctx.getLocale() + " as name ");
            if (hasLongNumber) {
                sql.append(",FLongNumber");
            }
            if (hasLevel) {
                sql.append(",FLevel ");
            }
            sql.append("from " + tableName);
            if (queryStr != null && queryStr.trim().length() > 2) {
                sql.append(" where FNumber IN " + queryStr);
            }
            if (hasLevel) {
                sql.append(" order by FLevel");
            }
            this.dealWithOtherSpreadItem(ctx, sql.toString(), hasLongNumber, hasLevel, asstActType, allNumberMap, groupInfo);
        }
    }

    private String getQueryString(String asstActType, Map asstActTypeMap, boolean isNeedAll) {
        if (asstActTypeMap == null || asstActTypeMap.isEmpty()) {
            return "";
        }
        if (asstActType == null) {
            asstActType = "";
        }
        HashSet<String> numberSet = new HashSet<String>();
        StringBuffer queryStr = null;
        for (String spreadNumber : asstActTypeMap.keySet()) {
            String[] numbers;
            if (spreadNumber == null || spreadNumber.trim().length() <= 0 || (numbers = spreadNumber.split("\\!")) == null || numbers.length <= 0) continue;
            for (int i = 0; i < numbers.length; ++i) {
                numberSet.add(numbers[i]);
            }
        }
        if (numberSet.size() == 0) {
            return "";
        }
        queryStr = new StringBuffer("(");
        Iterator<Object> it = numberSet.iterator();
        while (it.hasNext()) {
            queryStr.append("'" + (String)it.next() + "',");
        }
        queryStr.delete(queryStr.length() - 1, queryStr.length()).append(")");
        return queryStr.toString();
    }

    private void dealWithSpecialSpreadItem(Context ctx, String sql, String asstActType, Map allNumberMap, BgItemGroupInfo groupInfo) throws SQLDataException, BgException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String groupLNumber = rst.getString("groupLNumber");
                int groupLevel = rst.getInt("groupLevel");
                groupLNumber = this.lNnumber2BgItemLNumber(groupLNumber, asstActType, "group");
                if (rst.getString("itemNumber") == null || rst.getString("itemNumber").trim().length() <= 0) continue;
                RptItemImportObject obj = new RptItemImportObject();
                String itemName = rst.getString("itemName");
                String itemNumber = rst.getString("itemNumber");
                itemNumber = this.number2BgItemNumber(itemNumber, asstActType, "");
                String itemLNumber = groupLNumber + "!" + itemNumber;
                int itemLevel = groupLevel + 1;
                obj.setName(itemName);
                obj.setNumber(itemNumber);
                obj.setLongNumber(itemLNumber);
                obj.setLevel(itemLevel);
                obj.setEffective(false);
                obj.setAsstActType(asstActType);
                obj.setRefField(groupInfo.getRefField());
                obj.setGroupInfo(groupInfo);
                allNumberMap.put(itemNumber + TAGE + itemLNumber, obj);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void dealWithSpecialSpreadGroupItem(Context ctx, String sql, String asstActType, Map allNumberMap, BgItemGroupInfo groupInfo) throws SQLDataException, BgException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                RptItemImportObject obj = new RptItemImportObject();
                String groupName = rst.getString("groupName");
                String groupNumber = rst.getString("groupNumber");
                String groupLNumber = rst.getString("groupLNumber");
                int groupLevel = rst.getInt("groupLevel");
                groupNumber = this.number2BgItemNumber(groupNumber, asstActType, "group");
                groupLNumber = this.lNnumber2BgItemLNumber(groupLNumber, asstActType, "group");
                obj.setName(groupName);
                obj.setNumber(groupNumber);
                obj.setLongNumber(groupLNumber);
                obj.setLevel(groupLevel);
                obj.setRefField(groupInfo.getRefField());
                obj.setGroupInfo(groupInfo);
                obj.setAsstActType(asstActType);
                obj.setEffective(false);
                allNumberMap.put(groupNumber + TAGE + groupLNumber, obj);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void dealWithGeneralSpreadItem(Context ctx, String sql, String asstActType, Map allNumberMap, BgItemGroupInfo groupInfo) throws SQLDataException, BgException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                RptItemImportObject obj = new RptItemImportObject();
                String name = rst.getString("name");
                String number = rst.getString("FNumber");
                String longNumber = rst.getString("FLongNumber");
                int level = rst.getInt("FLevel");
                number = this.number2BgItemNumber(number, asstActType, "");
                longNumber = this.lNnumber2BgItemLNumber(longNumber, asstActType, "");
                obj.setName(name);
                obj.setNumber(number);
                obj.setLongNumber(longNumber);
                obj.setLevel(level);
                obj.setAsstActType(asstActType);
                obj.setEffective(false);
                obj.setGroupInfo(groupInfo);
                obj.setRefField(groupInfo.getRefField());
                allNumberMap.put(number + TAGE + longNumber, obj);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void dealWithOtherSpreadItem(Context ctx, String sql, boolean hasLongNumber, boolean hasLevel, String asstActType, Map allNumberMap, BgItemGroupInfo groupInfo) throws SQLDataException, BgException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String number;
                RptItemImportObject obj = new RptItemImportObject();
                String name = rst.getString("name");
                String longNumber = number = rst.getString("FNumber");
                int level = 1;
                if (hasLongNumber) {
                    longNumber = rst.getString("FLongNumber");
                }
                if (hasLevel) {
                    level = rst.getInt("FLevel");
                }
                number = this.number2BgItemNumber(number, asstActType, "");
                longNumber = this.lNnumber2BgItemLNumber(longNumber, asstActType, "");
                obj.setName(name);
                obj.setNumber(number);
                obj.setLongNumber(longNumber);
                obj.setLevel(level);
                obj.setAsstActType(asstActType);
                obj.setEffective(false);
                obj.setGroupInfo(groupInfo);
                obj.setRefField(groupInfo.getRefField());
                allNumberMap.put(number + TAGE + longNumber, obj);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private String number2BgItemNumber(String number, String type, String group) {
        if (number.indexOf(".") != -1) {
            number = number.replaceAll("\\.", type + group + ".");
        }
        number = number + type + group;
        return number;
    }

    private String lNnumber2BgItemLNumber(String lnumber, String type, String group) {
        if (lnumber.indexOf(".") != -1) {
            lnumber = lnumber.replaceAll("\\.", type + group + ".");
        }
        if (lnumber.indexOf("!") != -1) {
            lnumber = lnumber.replaceAll("\\!", type + group + "!");
        }
        lnumber = lnumber + type + group;
        return lnumber;
    }

    private boolean checkColumnExist(Context ctx, String tableName, String colName) throws SQLDataException, BgException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        boolean hasColumn = false;
        Connection conn = null;
        StringBuffer query = new StringBuffer();
        String sql = "select * from KSQL_USERCOLUMNS where KSQL_COL_NAME =? and KSQL_COL_TABNAME=?";
        sql = sql + query.toString();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, colName);
            pstmt.setString(2, tableName);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                hasColumn = true;
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return hasColumn;
    }

    private Map getAsstActInfo(Context ctx, Map spreadNumberMap) throws SQLDataException, BgException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, AsstActTypeInfo> result = new HashMap<String, AsstActTypeInfo>();
        Connection conn = null;
        StringBuffer query = new StringBuffer();
        query.append(" where FAsstHGAttribute in(");
        Iterator it = spreadNumberMap.keySet().iterator();
        while (it.hasNext()) {
            query.append("'" + it.next() + "',");
        }
        query.delete(query.length() - 1, query.length());
        query.append(")");
        String sql = "select FNumber,FName_" + ctx.getLocale() + " as name,FAsstHGAttribute,FDefaultQueryName,FGlAsstActTypeGrpID,FRealtionDataObject from t_bd_AsstActType";
        sql = sql + query.toString();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                AsstActTypeInfo info = new AsstActTypeInfo();
                String asstActType = rst.getString("FAsstHGAttribute");
                GeneralAsstActTypeGroupInfo groupInfo = new GeneralAsstActTypeGroupInfo();
                if (asstActType != null && asstActType.startsWith(GENERAL_ASSACTTYPE)) {
                    groupInfo.setId(BOSUuid.read((String)rst.getString("FGlAsstActTypeGrpID")));
                }
                info.setNumber(rst.getString("FNumber"));
                info.setName(rst.getString("name"));
                info.setAsstHGAttribute(asstActType);
                info.setGlAsstActTypeGrp(groupInfo);
                info.setRealtionDataObject(rst.getString("FRealtionDataObject"));
                result.put(asstActType, info);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    private List getAllBgItemGroup(Context ctx) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<BgItemGroupInfo> result = new ArrayList<BgItemGroupInfo>();
        Connection conn = null;
        StringBuffer sql = new StringBuffer("select FID,FNumber,FLongNumber,FAsstActType,FRefField from T_Bg_BgItemGroup ");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                BgItemGroupInfo info = new BgItemGroupInfo();
                info.setNumber(rst.getString("FNumber"));
                info.setLongNumber(rst.getString("FLongNumber"));
                info.setAsstActType(rst.getString("FAsstActType"));
                info.setId(BOSUuid.read((String)rst.getString("FID")));
                info.setRefField(rst.getString("FRefField"));
                result.add(info);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    private boolean checkIsInTheBasePointRange(int row, int col, List allBaseInfoList) {
        boolean isInTheRange = false;
        if (allBaseInfoList == null || allBaseInfoList.size() <= 0) {
            return false;
        }
        for (int i = 0; i < allBaseInfoList.size(); ++i) {
            RptBasePointObject obj = (RptBasePointObject)allBaseInfoList.get(i);
            if (obj.getBeginRowIndex() > row || row > obj.getEndRowIndex() || obj.getBeginColIndex() > col || col > obj.getEndColIndex()) continue;
            isInTheRange = true;
        }
        return isInTheRange;
    }

    private List getAllBasePointInfo(Sheet currentSheet) {
        ArrayList basePointList = null;
        DynaParameters param = null;
        AsstActTypeUtils assistantType = null;
        basePointList = DynamicTemplateUtility.getBasePointList((Sheet)currentSheet);
        if (basePointList == null) {
            return new ArrayList();
        }
        ArrayList<RptBasePointObject> basePointInfoList = new ArrayList<RptBasePointObject>();
        int size = basePointList.size();
        for (int index = 0; index < size; ++index) {
            Point point = (Point)basePointList.get(index);
            if (point == null || (param = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)currentSheet, (int)point.y, (int)point.x)) == null) continue;
            assistantType = param.getAssistantType();
            int spreadStyle = -1;
            int rowCount = -1;
            int colCount = -1;
            int left = point.x;
            int top = point.y;
            spreadStyle = param.getSpreadStyle();
            if (spreadStyle == 0) {
                rowCount = param.getDefaultCounter() + 1;
                colCount = this.getColCount(currentSheet, left, top);
                if (param.isIncludeSum()) {
                    ++rowCount;
                }
            } else if (spreadStyle == 1) {
                rowCount = this.getRowCount(currentSheet, left, top);
                colCount = param.getDefaultCounter() + 1;
                if (param.isIncludeSum()) {
                    ++colCount;
                }
            }
            RptBasePointObject obj = new RptBasePointObject();
            obj.setBeginRowIndex(top);
            obj.setEndRowIndex(top + rowCount);
            obj.setBeginColIndex(left);
            obj.setEndColIndex(left + colCount);
            obj.setAssistantType(assistantType);
            obj.setSpreadStyleIndex(spreadStyle);
            basePointInfoList.add(obj);
        }
        return basePointInfoList;
    }

    private void parseRptBook(Context ctx, Sheet rptSheet, Sheet tempSheet, List allBaseInfoList, StringBuffer msg, Map rptNumberMap, Map spreadNumberMap, Map elementMap, Map bgPeriodMap, Map cellMap, int importType) throws BOSException, EASBizException {
        if (allBaseInfoList == null || allBaseInfoList.size() <= 0) {
            return;
        }
        Row reportRow = null;
        Row templateRow = null;
        int size = allBaseInfoList.size();
        for (int i = 0; i < size; ++i) {
            Object value;
            String formula;
            Object value2;
            String cellKey;
            ItemFormula bgItemFormula;
            Map<String, Object> asstActTypeMap;
            String handName;
            String elementType;
            String asstActType;
            String spreadNumber;
            Object value3;
            Cell tempCell;
            Cell baseCell;
            Cell rptCell;
            int colIndex;
            ItemFormula rptFormula;
            int rowIndex;
            RptBasePointObject obj = (RptBasePointObject)allBaseInfoList.get(i);
            if (obj.getSpreadStyleIndex() == 0) {
                for (rowIndex = obj.getBeginRowIndex(); rowIndex <= obj.getEndRowIndex(); ++rowIndex) {
                    reportRow = rptSheet.getRow(rowIndex, false);
                    if (reportRow == null) continue;
                    templateRow = tempSheet.getRow(rowIndex, true);
                    rptFormula = null;
                    for (colIndex = obj.getBeginColIndex(); colIndex <= obj.getEndColIndex(); ++colIndex) {
                        rptCell = reportRow.getCell(colIndex, false);
                        if (rptCell == null) continue;
                        if (rowIndex == obj.getBeginRowIndex() && colIndex == obj.getBeginColIndex()) {
                            baseCell = templateRow.getCell(colIndex, true);
                            BgNFSHelper.clearFormulaOfCell(baseCell);
                            BgNFSHelper.setValue(baseCell, null);
                            continue;
                        }
                        if (rowIndex == obj.getBeginRowIndex()) {
                            tempCell = templateRow.getCell(colIndex, true);
                            if (!BgNFSHelper.checkHasFormulaOfCell(rptCell)) continue;
                            rptFormula = BgNFSHelper.getItemFormula(rptCell);
                            String rptNumber = rptFormula.getItemNumber();
                            rptNumberMap.put(rptNumber, null);
                            value3 = BgNFSHelper.getValue(rptCell);
                            BgNFSHelper.clearFormulaOfCell(tempCell);
                            BgNFSHelper.setValue(tempCell, value3);
                            continue;
                        }
                        tempCell = templateRow.getCell(colIndex, true);
                        boolean hasItemFormula = BgNFSHelper.checkHasFormulaOfCell(rptCell);
                        if (hasItemFormula) {
                            rptFormula = BgNFSHelper.getItemFormula(rptCell);
                            spreadNumber = rptFormula.getDItemNumber();
                            asstActType = obj.getAssistantType().getAsstHGAttribute();
                            elementType = rptFormula.getDataElementNumber();
                            if ("".equals(asstActType) || "null".equals(asstActType)) {
                                asstActType = SELF_INPUT;
                            }
                            if (SELF_INPUT.equals(asstActType)) {
                                spreadNumber = spreadNumber.replaceAll("\\.", "#").replaceAll("!", "@").replaceAll("_", "-");
                                handName = this.getHandInputNameByRow(rowIndex, colIndex, rptSheet);
                                if (handName == null || handName.trim().length() <= 0) {
                                    handName = spreadNumber;
                                }
                                spreadNumber = spreadNumber + TAGE + handName.trim();
                            }
                            if (spreadNumberMap.containsKey(asstActType)) {
                                asstActTypeMap = (Map)spreadNumberMap.get(asstActType);
                                asstActTypeMap.put(spreadNumber, null);
                            } else {
                                asstActTypeMap = new HashMap();
                                asstActTypeMap.put(spreadNumber, null);
                                spreadNumberMap.put(asstActType, asstActTypeMap);
                            }
                            bgItemFormula = this.convertRptItemFormula2BgItemFormula(rptFormula, tempCell, elementMap, bgPeriodMap, asstActType);
                            cellKey = asstActType + "^*^" + bgItemFormula.getFormula() + "^*^" + rptFormula.getDataElementNumber() + rptFormula.getValueType();
                            if (!cellMap.containsKey(cellKey)) {
                                BgNFSHelper.setItemFormula(tempCell, bgItemFormula);
                                cellMap.put(cellKey, tempCell);
                            }
                            if (importType != -1 && (value2 = BgNFSHelper.getValue(rptCell)) != null && value2 instanceof BigDecimal) {
                                if (importType == 1) {
                                    BgNFSHelper.setValue(tempCell, value2);
                                    BgNFSHelper.setBudgetValue(tempCell, (BigDecimal)value2);
                                }
                                if (importType == 2) {
                                    BgNFSHelper.setActualValue(tempCell, (BigDecimal)value2);
                                }
                                if (importType == 3) {
                                    if ("AMOUNT".equals(elementType) || "ENDBALANCE".equals(elementType)) {
                                        BgNFSHelper.setValue(tempCell, value2);
                                    } else {
                                        BgNFSHelper.setValue(tempCell, null);
                                    }
                                }
                            }
                        }
                        if (rptCell.hasFormula()) {
                            formula = BgNFSHelper.getExpression(rptCell);
                            if (hasItemFormula) {
                                BgNTemplateHelper.setBgDataValue(tempCell, "BG_BUDGET_EXPRESSIONS", formula, false);
                                continue;
                            }
                            BgNTemplateHelper.setBgDataValue(tempCell, "BG_BUDGET_EXPRESSIONS", formula, false);
                            BgNTemplateHelper.setBgDataValue(tempCell, "BG_ACTUAL_EXPRESSIONS", formula, false);
                            BgNTemplateHelper.setBgDataValue(tempCell, "BG_ADD_EXPRESSIONS", formula, false);
                            value = BgNFSHelper.getValue(rptCell);
                            BgNFSHelper.setValue(tempCell, value);
                            continue;
                        }
                        if (hasItemFormula) continue;
                        value3 = BgNFSHelper.getValue(rptCell);
                        BgNFSHelper.setValue(tempCell, value3);
                        BgNFSHelper.setNumberFormat(tempCell, "@");
                    }
                }
            }
            if (obj.getSpreadStyleIndex() != 1) continue;
            for (rowIndex = obj.getBeginRowIndex(); rowIndex <= obj.getEndRowIndex(); ++rowIndex) {
                reportRow = rptSheet.getRow(rowIndex, false);
                if (reportRow == null) continue;
                templateRow = tempSheet.getRow(rowIndex, true);
                rptFormula = null;
                for (colIndex = obj.getBeginColIndex(); colIndex <= obj.getEndColIndex(); ++colIndex) {
                    rptCell = reportRow.getCell(colIndex, false);
                    if (rptCell == null) continue;
                    if (rowIndex == obj.getBeginRowIndex() && colIndex == obj.getBeginColIndex()) {
                        baseCell = templateRow.getCell(colIndex, true);
                        BgNFSHelper.clearFormulaOfCell(baseCell);
                        BgNFSHelper.setValue(baseCell, null);
                        continue;
                    }
                    if (colIndex == obj.getBeginColIndex()) {
                        tempCell = templateRow.getCell(colIndex, true);
                        if (!BgNFSHelper.checkHasFormulaOfCell(rptCell)) continue;
                        rptFormula = BgNFSHelper.getItemFormula(rptCell);
                        String rptNumber = rptFormula.getItemNumber();
                        rptNumberMap.put(rptNumber, null);
                        value3 = BgNFSHelper.getValue(rptCell);
                        BgNFSHelper.clearFormulaOfCell(tempCell);
                        BgNFSHelper.setValue(tempCell, value3);
                        continue;
                    }
                    tempCell = templateRow.getCell(colIndex, true);
                    boolean hasItemFormula = BgNFSHelper.checkHasFormulaOfCell(rptCell);
                    if (hasItemFormula) {
                        rptFormula = BgNFSHelper.getItemFormula(rptCell);
                        spreadNumber = rptFormula.getDItemNumber();
                        asstActType = obj.getAssistantType().getAsstHGAttribute();
                        elementType = rptFormula.getDataElementNumber();
                        if ("".equals(asstActType)) {
                            asstActType = SELF_INPUT;
                        }
                        if (SELF_INPUT.equals(asstActType)) {
                            spreadNumber = spreadNumber.replaceAll("\\.", "#").replaceAll("!", "@").replaceAll("_", "-");
                            handName = this.getHandInputNameByCol(rowIndex, colIndex, rptSheet);
                            if (handName == null || handName.trim().length() <= 0) {
                                handName = spreadNumber;
                            }
                            spreadNumber = spreadNumber + TAGE + handName;
                        }
                        if (spreadNumberMap.containsKey(asstActType)) {
                            asstActTypeMap = (Map)spreadNumberMap.get(asstActType);
                            asstActTypeMap.put(spreadNumber, null);
                        } else {
                            asstActTypeMap = new HashMap();
                            asstActTypeMap.put(spreadNumber, null);
                            spreadNumberMap.put(asstActType, asstActTypeMap);
                        }
                        bgItemFormula = this.convertRptItemFormula2BgItemFormula(rptFormula, tempCell, elementMap, bgPeriodMap, asstActType);
                        cellKey = asstActType + "^*^" + bgItemFormula.getFormula() + "^*^" + rptFormula.getDataElementNumber() + rptFormula.getValueType();
                        if (!cellMap.containsKey(cellKey)) {
                            BgNFSHelper.setItemFormula(tempCell, bgItemFormula);
                            cellMap.put(cellKey, tempCell);
                        }
                        if (importType != -1 && (value2 = BgNFSHelper.getValue(rptCell)) != null && value2 instanceof BigDecimal) {
                            if (importType == 1) {
                                BgNFSHelper.setValue(tempCell, value2);
                                BgNFSHelper.setBudgetValue(tempCell, (BigDecimal)value2);
                            }
                            if (importType == 2) {
                                BgNFSHelper.setActualValue(tempCell, (BigDecimal)value2);
                            }
                            if (importType == 3) {
                                if ("AMOUNT".equals(elementType) || "ENDBALANCE".equals(elementType)) {
                                    BgNFSHelper.setValue(tempCell, value2);
                                } else {
                                    BgNFSHelper.setValue(tempCell, null);
                                }
                            }
                        }
                    }
                    if (rptCell.hasFormula()) {
                        formula = BgNFSHelper.getExpression(rptCell);
                        if (hasItemFormula) {
                            BgNTemplateHelper.setBgDataValue(tempCell, "BG_BUDGET_EXPRESSIONS", formula, false);
                            continue;
                        }
                        BgNTemplateHelper.setBgDataValue(tempCell, "BG_BUDGET_EXPRESSIONS", formula, false);
                        BgNTemplateHelper.setBgDataValue(tempCell, "BG_ACTUAL_EXPRESSIONS", formula, false);
                        BgNTemplateHelper.setBgDataValue(tempCell, "BG_ADD_EXPRESSIONS", formula, false);
                        value = BgNFSHelper.getValue(rptCell);
                        BgNFSHelper.setValue(tempCell, value);
                        continue;
                    }
                    if (hasItemFormula) continue;
                    value3 = BgNFSHelper.getValue(rptCell);
                    BgNFSHelper.setValue(tempCell, value3);
                    BgNFSHelper.setNumberFormat(tempCell, "@");
                }
            }
        }
    }

    private String getHandInputNameByRow(int rowIndex, int colIndex, Sheet rptSheet) {
        String handName = "";
        Cell cell = null;
        if (rptSheet == null) {
            return handName;
        }
        for (int i = colIndex - 1; i >= 0; --i) {
            cell = rptSheet.getCell(rowIndex, i, false);
            if (BgNFSHelper.checkHasFormulaOfCell(cell) || cell == null || cell.getValue() == Variant.nullVariant) continue;
            handName = cell.getValue().toString();
            break;
        }
        return handName;
    }

    private String getHandInputNameByCol(int rowIndex, int colIndex, Sheet rptSheet) {
        String handName = "";
        Cell cell = null;
        if (rptSheet == null) {
            return handName;
        }
        for (int i = rowIndex - 1; i >= 0; --i) {
            cell = rptSheet.getCell(i, colIndex, false);
            if (BgNFSHelper.checkHasFormulaOfCell(cell) || cell == null || cell.getValue() == Variant.nullVariant) continue;
            handName = cell.getValue().toString();
            break;
        }
        return handName;
    }

    private void checkRptItemExistInBgItem(Map rptNumberMap, List mappingList, List itemList) {
        boolean isExist = false;
        if (rptNumberMap.isEmpty()) {
            return;
        }
        for (String rptNumber : rptNumberMap.keySet()) {
            int i;
            int size;
            isExist = false;
            RptItemImportObject rptObj = (RptItemImportObject)rptNumberMap.get(rptNumber);
            if (rptObj == null) {
                rptNumberMap.put(rptNumber, null);
                continue;
            }
            if (mappingList != null && mappingList.size() > 0) {
                size = mappingList.size();
                for (i = 0; i < size; ++i) {
                    BgItemMappingInfo info = (BgItemMappingInfo)mappingList.get(i);
                    if (!rptObj.getNumber().equals(info.getRptNumber())) continue;
                    rptObj.setNumber(info.getBgNumber());
                    rptObj.setRefField(info.getRefField());
                    isExist = true;
                    break;
                }
            }
            if (isExist) continue;
            if (itemList != null && itemList.size() > 0) {
                size = itemList.size();
                for (i = 0; i < size; ++i) {
                    RptItemImportObject bgItemObj = (RptItemImportObject)itemList.get(i);
                    if (rptObj.getLongNumber().equals(bgItemObj.getLongNumber())) {
                        rptObj.setRefField(bgItemObj.getRefField());
                        isExist = true;
                    }
                    if (isExist) break;
                }
            }
            if (isExist) continue;
            rptNumberMap.put(rptNumber, null);
        }
    }

    private int getColCount(Sheet curSheet, int left, int top) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
            return i;
        }
        return 1;
    }

    private int getRowCount(Sheet curSheet, int left, int top) {
        int height;
        for (int i = height = curSheet.getMaxRowIndex(); i > top; --i) {
            Cell cell = curSheet.getCell(i, left, false);
            if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
            return i;
        }
        return 1;
    }

    private ItemFormula convertRptItemFormula2BgItemFormula(ItemFormula reportItemFormula, Cell templateCell, Map elementMap, Map bgPeriodMap, String asstActType) {
        if (StringUtils.isEmpty((String)reportItemFormula.getFormula())) {
            return null;
        }
        int year = 0;
        int period = 0;
        String bgPeriodNumber = "";
        String rptNumber = reportItemFormula.getItemNumber();
        String spreadNumber = reportItemFormula.getDItemNumber();
        String datatypeNumber = reportItemFormula.getDataElementNumber();
        reportItemFormula.getYearOffSet();
        reportItemFormula.getYear();
        reportItemFormula.getPeriodOffSet();
        reportItemFormula.getPeriod();
        if (SELF_INPUT.equals(asstActType)) {
            spreadNumber = spreadNumber.replaceAll("\\.", "#").replaceAll("!", "@").replaceAll("_", "-");
        }
        year = reportItemFormula.getYearOffSet();
        period = reportItemFormula.getPeriodOffSet();
        int valueType = reportItemFormula.getValueType();
        if (year >= 1900) {
            if (period > 0) {
                bgPeriodNumber = bgPeriodNumber + year + "Y";
                bgPeriodNumber = bgPeriodNumber + ".";
                if (period < 10) {
                    bgPeriodNumber = bgPeriodNumber + "0";
                }
                bgPeriodNumber = bgPeriodNumber + period + "M";
            } else {
                bgPeriodNumber = period + "";
            }
        } else {
            bgPeriodNumber = period + "";
        }
        if (bgPeriodMap == null) {
            bgPeriodMap = new HashMap<String, Vector>();
        }
        Vector cellPeriodVec = null;
        try {
            Integer.parseInt(bgPeriodNumber);
        }
        catch (NumberFormatException e) {
            logger.debug((Object)e);
            if (bgPeriodMap.containsKey(bgPeriodNumber) && bgPeriodMap.get(bgPeriodNumber) != null) {
                cellPeriodVec = (Vector)bgPeriodMap.get(bgPeriodNumber);
            } else {
                cellPeriodVec = new Vector();
                bgPeriodMap.put(bgPeriodNumber, cellPeriodVec);
            }
            cellPeriodVec.add(templateCell);
        }
        if (elementMap == null) {
            elementMap = new HashMap<String, Vector>();
        }
        String elementNumber = datatypeNumber + TAGE + valueType;
        Vector cellVec = null;
        if (elementMap.containsKey(elementNumber)) {
            cellVec = (Vector)elementMap.get(elementNumber);
        } else {
            cellVec = new Vector();
            elementMap.put(elementNumber, cellVec);
        }
        cellVec.add(templateCell);
        elementMap.put(elementNumber, cellVec);
        String itemFormula = "=BgItem(\"" + rptNumber + "_" + spreadNumber + "\",\"" + bgPeriodNumber + "\",\"\",\"BgData\",true,\"\")";
        ItemFormula item = new ItemFormula(itemFormula);
        item.putExt(TAGE, elementNumber);
        return item;
    }

    private void checkAllExit(Context ctx, Map bgItemMap, String tableName, HashMap mapTemPeriod, StringBuffer msg) throws EASBizException, BOSException {
        if (bgItemMap == null || bgItemMap.isEmpty()) {
            return;
        }
        StringBuffer str = new StringBuffer("select distinct fid,fnumber from " + tableName + " ");
        boolean isfirst = true;
        Iterator iter = bgItemMap.keySet().iterator();
        while (iter.hasNext()) {
            if (isfirst) {
                isfirst = false;
                str.append(" where fnumber='" + iter.next() + "' ");
                continue;
            }
            str.append(" or fnumber='" + iter.next() + "' ");
        }
        IRowSet row = null;
        try {
            row = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (row.next()) {
                mapTemPeriod.put(row.getString("fnumber"), row.getString("fid"));
            }
        }
        catch (SQLException sqlE) {
            logger.error((Object)sqlE);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)sqlE);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
        }
        String number2 = null;
        if (msg == null) {
            msg = new StringBuffer();
        }
        for (String number2 : bgItemMap.keySet()) {
            if (mapTemPeriod.get(number2) == null || mapTemPeriod.get(number2).toString().length() < 0) {
                if ("t_bg_Bgperiod".equalsIgnoreCase(tableName)) {
                    msg.append(new CreateBgTemFromRptException(CreateBgTemFromRptException.BGPERIODNOTEXIT, (Object[])new String[]{number2}).getMessage() + "\n\r");
                    continue;
                }
                if (!"t_bg_Bgitem".equalsIgnoreCase(tableName)) continue;
                msg.append(new CreateBgTemFromRptException(CreateBgTemFromRptException.BGITEMNOTEXIT, (Object[])new String[]{number2}).getMessage() + "\n\r");
                continue;
            }
            if ("t_bg_Bgperiod".equalsIgnoreCase(tableName)) {
                if (!bgItemMap.containsKey(number2) || bgItemMap.get(number2) == null) continue;
                bgItemMap.put(number2, null);
                continue;
            }
            if (!"t_bg_Bgitem".equalsIgnoreCase(tableName) || !bgItemMap.containsKey(number2) || bgItemMap.get(number2) == null) continue;
            bgItemMap.put(number2, null);
        }
    }

    private void checkAllElementExit(Context ctx, Map bgElementMap, HashMap temMap, StringBuffer msg, String bgTempNumber) throws EASBizException, BOSException {
        if (bgElementMap == null || bgElementMap.isEmpty()) {
            return;
        }
        if (msg == null) {
            msg = new StringBuffer();
        }
        StringBuffer str = new StringBuffer("select  fid,FElementTypeNumber,FBgElementNumber,FGetDataType from T_BG_ElementMap ");
        boolean isfirst = true;
        String key2 = null;
        String[] param = null;
        int dataType = -1;
        String getDataTypeNumber = null;
        int rptType = 0;
        if (bgTempNumber == null) {
            rptType = -1;
        } else if (bgTempNumber.endsWith(POSTFIX_GROUPCOMMREPORT)) {
            rptType = 0;
        } else if (bgTempNumber.endsWith(POSTFIX_SUMREPORT)) {
            rptType = 20;
        } else if (bgTempNumber.endsWith(POSTFIX_CSLREPORT)) {
            rptType = 10;
        }
        Iterator iter = bgElementMap.keySet().iterator();
        while (iter.hasNext()) {
            dataType = -1;
            getDataTypeNumber = null;
            key2 = (String)iter.next();
            if (key2 == null || key2.trim().length() < 1 || key2.split(TAGE).length < 2) continue;
            param = key2.split(TAGE);
            dataType = Integer.parseInt(param[1]);
            getDataTypeNumber = param[0];
            if (isfirst) {
                isfirst = false;
                str.append("\n\r\t where (FRptTmpType=" + rptType + " and  FGetDataType = " + dataType + " and FElementTypeNumber ='" + getDataTypeNumber + "') ");
                continue;
            }
            str.append("\n\r\t or (FRptTmpType=" + rptType + " and  FGetDataType = " + dataType + " and FElementTypeNumber ='" + getDataTypeNumber + "') ");
        }
        IRowSet row = null;
        try {
            row = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (row.next()) {
                temMap.put(row.getString("FElementTypeNumber") + TAGE + row.getString("FGetDataType"), row.getString("FBgElementNumber"));
            }
        }
        catch (SQLException sqlE) {
            logger.error((Object)sqlE);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)sqlE);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, (Throwable)e);
        }
        for (String key2 : bgElementMap.keySet()) {
            if (temMap.get(key2) != null) continue;
            param = key2.split(TAGE);
            msg.append(new CreateBgTemFromRptException(CreateBgTemFromRptException.BGELEMENTNOTEXIT, (Object[])new String[]{key2, param[0], ValueTypeEnum.getEnum((int)Integer.parseInt(param[1])).getAlias()}).getMessage() + "\n\r");
        }
    }

    private void reBuildBgItemFormula(Map temMapCell, StringBuffer msg, String table, HashMap mapTemTrueValue) {
        if (temMapCell == null || temMapCell.isEmpty()) {
            return;
        }
        Set keySet = temMapCell.keySet();
        String strTem2 = null;
        String formula = null;
        Vector vecCell = null;
        Cell cell2 = null;
        HashMap mapFormulaMap = new HashMap();
        String[] param = null;
        String elementNumRpt = null;
        for (String strTem2 : keySet) {
            if ("t_Bg_bgelement".equalsIgnoreCase(table) && (strTem2 == null || strTem2.trim().length() < 1) || (vecCell = (Vector)temMapCell.get(strTem2)) == null || vecCell.isEmpty()) continue;
            for (Cell cell2 : vecCell) {
                formula = BgNFSHelper.getFormulaOfCell(cell2);
                if (StringUtils.isEmpty((String)formula)) continue;
                if ("t_Bg_bgelement".equalsIgnoreCase(table)) {
                    elementNumRpt = BgNFSHelper.getExtValue(cell2, TAGE);
                    if (StringUtils.isEmpty((String)elementNumRpt)) {
                        BgNFSHelper.clearFormulaOfCell(cell2);
                        continue;
                    }
                    param = BgNFSHelper.parseFormulaPara(mapFormulaMap, formula);
                    if (mapTemTrueValue.containsKey(elementNumRpt)) {
                        param[2] = (String)mapTemTrueValue.get(elementNumRpt);
                        if (StringUtils.isEmpty((String)param[2])) {
                            BgNFSHelper.clearFormulaOfCell(cell2);
                            continue;
                        }
                        formula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\"," + param[4] + ",\"" + param[5] + "\")";
                        BgNFSHelper.setFormulaOfCell(cell2, formula);
                        continue;
                    }
                    BgNFSHelper.clearFormulaOfCell(cell2);
                    continue;
                }
                if ("t_bg_Bgperiod".equalsIgnoreCase(table)) {
                    param = BgNFSHelper.parseFormulaPara(mapFormulaMap, formula);
                    formula = "=BgItem(\"" + param[0] + "\",\"\",\"" + param[2] + "\",\"" + param[3] + "\"," + param[4] + ",\"" + param[5] + "\")";
                    BgNFSHelper.setFormulaOfCell(cell2, formula, true);
                    continue;
                }
                if (!"t_bg_BgItem".equalsIgnoreCase(table)) continue;
                BgNFSHelper.clearFormulaOfCell(cell2);
            }
        }
    }

    private List getAllExistBgItem(Context ctx, boolean canRepeat, String queryStr, List resultList, String orgID) throws EASBizException, BOSException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Set orgSet = null;
        Object _number = null;
        StringBuffer query = new StringBuffer();
        if (resultList == null) {
            resultList = new ArrayList<RptItemImportObject>();
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            query.append("select item.FNumber,item.FName_" + ctx.getLocale() + " as itemName,item.FRefField,item.FLongNumber,itemgroup.FAsstActType from T_BG_BgItem item, T_BG_BgItemGroup itemgroup where item.FBgItemGroupID =itemgroup.Fid ");
            if (queryStr.trim().length() <= 2) {
                ArrayList<RptItemImportObject> arrayList = resultList;
                return arrayList;
            }
            query.append(" and item.FNumber in " + queryStr);
            try {
                if (!BgSHelper.isBgItemIsolate((Context)ctx)) {
                    query.append(" and item.FOrgUnitId = '00000000-0000-0000-0000-000000000000CCE7AED4'");
                } else {
                    query.append(" and item.FOrgUnitId = '" + orgID + "'");
                }
            }
            catch (Exception e) {
                logger.error((Object)"error:", (Throwable)e);
            }
            pstmt = conn.prepareStatement(query.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                RptItemImportObject obj = new RptItemImportObject();
                obj.setNumber(rst.getString("FNumber"));
                obj.setLongNumber(rst.getString("FLongNumber"));
                obj.setName(rst.getString("itemName"));
                obj.setAsstActType(rst.getString("FAsstActType"));
                obj.setRefField(rst.getString("FRefField"));
                resultList.add(obj);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        if (orgSet != null) {
            orgSet.clear();
        }
        return resultList;
    }

    public static Set getOrgUnitIds(Connection conn, BOSUuid orgUnitId, boolean canRepeat) throws EASBizException {
        HashSet<String> orgUnitIdSet = new HashSet<String>();
        if (conn == null || orgUnitId == null) {
            return orgUnitIdSet;
        }
        ArrayList<String> _tmpList = new ArrayList<String>();
        String[] numberStr = null;
        String _number = null;
        String _longnumber = null;
        String _orgUnitId = null;
        StringBuffer query = new StringBuffer();
        _orgUnitId = orgUnitId.toString();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FNumber, FLongNumber from T_ORG_CostCenter where FID = ?");
            pstmt.setString(1, _orgUnitId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                _number = rst.getString(1);
                _longnumber = rst.getString(2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty((String)_number) && !StringUtils.isEmpty((String)_longnumber)) {
                query.append("select FID from T_ORG_CostCenter where ");
                numberStr = _longnumber.split("\\!");
                if (numberStr != null) {
                    query.append(" FNumber IN (");
                    int in = numberStr.length;
                    for (int i = 0; i < in; ++i) {
                        query.append("?,");
                        _tmpList.add(numberStr[i]);
                    }
                    query.delete(query.length() - 1, query.length());
                    query.append(") ");
                }
                if (!canRepeat) {
                    query.append(" or FLongNumber like ?");
                    _tmpList.add(_longnumber + "!%");
                }
                pstmt = conn.prepareStatement(query.toString());
                BgNSQLHelper.setParams(pstmt, _tmpList);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgUnitIdSet.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return orgUnitIdSet;
    }

    private List getAllItemMappingInfo(Context ctx, Map rptNumberMap, boolean canRepeat, String orgID) throws BOSException, EASBizException {
        orgID = BgSHelper.getIsolateOrg((String)orgID);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<BgItemMappingInfo> result = new ArrayList<BgItemMappingInfo>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer query = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        query.append("(");
        Object it = rptNumberMap.keySet().iterator();
        while (it.hasNext()) {
            query.append("?,");
            _tmpList.add(it.next().toString());
        }
        query.delete(query.length() - 1, query.length());
        query.append(")");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sql.append("select distinct mapping.FRptNumber, mapping.FBgNumber,item.FRefField,item.FLongNumber from T_BG_BGItemMapping mapping,t_Bg_BgItem item where mapping.FBgNumber =item.FNumber and item.FOrgUnitId = ?");
            _tmpList.add(orgID);
            if (query.toString().trim().length() <= 2) {
                it = result;
                return it;
            }
            sql.append(" and FRptNumber in" + query.toString());
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams(pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                BgItemMappingInfo info = new BgItemMappingInfo();
                info.setRptNumber(rst.getString("FRptNumber"));
                info.setBgNumber(rst.getString("FBgNumber"));
                info.setRefField(rst.getString("FRefField"));
                info.setLongNumber(rst.getString("FLongNumber"));
                result.add(info);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return result;
    }
}

