/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.eas.ma.nbudget.BgRowColIdObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgNEnumeraInfo {
    private BgOneEnumInfo[] enums = null;

    private BgNEnumeraInfo() {
    }

    public static BgNEnumeraInfo getInstance(IBgItemEnumFacade bgItem, Map enumMap, Map rowIds, Map colIds) throws Exception {
        if (bgItem == null || enumMap == null || rowIds == null || colIds == null || rowIds.isEmpty() || colIds.isEmpty()) {
            return null;
        }
        BgNEnumeraInfo enumInfo = new BgNEnumeraInfo();
        enumInfo.enums = new BgOneEnumInfo[enumMap.size()];
        int index = 0;
        Iterator it = enumMap.values().iterator();
        while (it.hasNext()) {
            enumInfo.enums[index] = enumInfo.getOneEnumInfo(bgItem, (Map)it.next(), rowIds, colIds);
            ++index;
        }
        return enumInfo;
    }

    private BgOneEnumInfo getOneEnumInfo(IBgItemEnumFacade bgItem, Map enumMap, Map rowIds, Map colIds) throws Exception {
        List colArea;
        if (bgItem == null || enumMap == null || rowIds == null || colIds == null || rowIds.isEmpty() || colIds.isEmpty()) {
            return null;
        }
        BgOneEnumInfo o = new BgOneEnumInfo();
        o.beginRow = BgNEnumeraInfo.getSheetIndex(rowIds, enumMap.get("AreaRowId"));
        o.endRow = BgNEnumeraInfo.getSheetIndex(rowIds, enumMap.get("AreaRow1Id"));
        o.beginCol = BgNEnumeraInfo.getSheetIndex(colIds, enumMap.get("AreaColId"));
        o.endCol = BgNEnumeraInfo.getSheetIndex(colIds, enumMap.get("AreaCol1Id"));
        Map itemArea = (Map)enumMap.get("EnumItemArea");
        if (itemArea != null && !itemArea.isEmpty()) {
            BgOneEnumInfo.access$502(o, new BgItemEnumInfo[itemArea.size()]);
            int index = 0;
            Iterator it = itemArea.values().iterator();
            while (it.hasNext()) {
                ((BgOneEnumInfo)o).itemAreas[index] = o.getBgItemEnum(bgItem, (Map)it.next(), rowIds, colIds);
                ++index;
            }
        }
        if ((colArea = (List)enumMap.get("EnumCollArea")) != null && !colArea.isEmpty()) {
            BgOneEnumInfo.access$702(o, new BgColEnumInfo[colArea.size()]);
            int index = 0;
            Iterator it = colArea.iterator();
            while (it.hasNext()) {
                ((BgOneEnumInfo)o).colAreas[index] = o.getBgColEnum((Map)it.next(), rowIds, colIds);
                ++index;
            }
        }
        return o;
    }

    private static int getSheetIndex(Map ids, Object singId) {
        int index = -1;
        if (ids != null && !ids.isEmpty()) {
            if (ids.get(singId) instanceof Integer) {
                index = (Integer)ids.get(singId);
            } else if (ids.get(singId) instanceof BgRowColIdObject) {
                index = ((BgRowColIdObject)ids.get(singId)).getCurrIndex();
            }
        }
        return index;
    }

    public BgOneEnumInfo getEnumInfo(int rowIndex) {
        if (this.enums != null && this.enums.length > 0) {
            for (int i = 0; i < this.enums.length; ++i) {
                BgOneEnumInfo o = this.enums[i];
                if (o.getBeginRow() > rowIndex || o.getEndRow() < rowIndex) continue;
                return o;
            }
        }
        return null;
    }

    public String toString() {
        if (this.enums == null) {
            return "{ BgNEnumeraInfo [null] }";
        }
        StringBuffer s = new StringBuffer();
        s.append("{ BgNEnumeraInfo [\n");
        for (int i = 0; i < this.enums.length; ++i) {
            s.append("  ").append(this.enums[i]).append("\n");
        }
        s.append("]}");
        return s.toString();
    }

    public class BgColEnumInfo {
        private int beginRow = -1;
        private int endRow = -1;
        private int beginCol = -1;
        private int endCol = -1;

        private BgColEnumInfo() {
        }

        public int getBeginRow() {
            return this.beginRow;
        }

        public int getEndRow() {
            return this.endRow;
        }

        public int getBeginCol() {
            return this.beginCol;
        }

        public int getEndCol() {
            return this.endCol;
        }
    }

    public class BgItemEnumInfo {
        private int beginRow = -1;
        private int endRow = -1;
        private int beginCol = -1;
        private int endCol = -1;
        private String itemGroup = null;
        private Set itemNumbers = null;

        private BgItemEnumInfo() {
        }

        public String getItemGroup() {
            return this.itemGroup;
        }

        public boolean isCanFill(String number) {
            if (number == null || number.length() <= 0) {
                return false;
            }
            if (this.itemNumbers == null) {
                return true;
            }
            return this.itemNumbers.contains(number);
        }

        public int getBeginRow() {
            return this.beginRow;
        }

        public int getEndRow() {
            return this.endRow;
        }

        public int getBeginCol() {
            return this.beginCol;
        }

        public int getEndCol() {
            return this.endCol;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("     {BgItemEnumInfo BeginRow:").append(this.beginRow).append(" EndRow:").append(this.endRow).append(" BeginCol:").append(this.beginCol).append(" EndCol:").append(this.endCol);
            s.append(" ItemGroup:").append(this.itemGroup).append(" ItemNumbers:").append(this.itemNumbers).append(" }");
            return s.toString();
        }
    }

    public class BgOneEnumInfo {
        private int beginRow = -1;
        private int endRow = -1;
        private int beginCol = -1;
        private int endCol = -1;
        private BgItemEnumInfo[] itemAreas = null;
        private BgColEnumInfo[] colAreas = null;

        private BgOneEnumInfo() {
        }

        public int getBeginRow() {
            return this.beginRow;
        }

        public int getEndRow() {
            return this.endRow;
        }

        public int getBeginCol() {
            return this.beginCol;
        }

        public int getEndCol() {
            return this.endCol;
        }

        public BgItemEnumInfo getBgItemEnumInfo(int rowIndex, int colIndex) {
            if (this.itemAreas != null && this.itemAreas.length > 0) {
                for (int i = 0; i < this.itemAreas.length; ++i) {
                    BgItemEnumInfo e = this.itemAreas[i];
                    if (rowIndex < e.getBeginRow() || rowIndex > e.getEndRow() || colIndex < e.getBeginCol() || colIndex > e.getEndCol()) continue;
                    return e;
                }
            }
            return null;
        }

        public BgColEnumInfo getBgColEnumInfo(int rowIndex, int colIndex) {
            BgColEnumInfo colEnum = null;
            return colEnum;
        }

        private BgItemEnumInfo getBgItemEnum(IBgItemEnumFacade bgItem, Map areaMap, Map rowIds, Map colIds) throws Exception {
            if (bgItem == null || areaMap == null || rowIds == null || colIds == null || rowIds.isEmpty() || colIds.isEmpty()) {
                return null;
            }
            BgItemEnumInfo item = new BgItemEnumInfo();
            item.beginRow = BgNEnumeraInfo.getSheetIndex(rowIds, areaMap.get("AreaRowId"));
            item.endRow = BgNEnumeraInfo.getSheetIndex(rowIds, areaMap.get("AreaRow1Id"));
            item.beginCol = BgNEnumeraInfo.getSheetIndex(colIds, areaMap.get("AreaColId"));
            item.endCol = BgNEnumeraInfo.getSheetIndex(colIds, areaMap.get("AreaCol1Id"));
            String bgItemGroup = (String)areaMap.get("BgItemGroup");
            Set bgItemNumbers = (Set)areaMap.get("BgItem");
            if (bgItemNumbers != null && !bgItemNumbers.isEmpty()) {
                item.itemNumbers = bgItem.getNumbers(new HashSet(bgItemNumbers));
            } else if (bgItemGroup != null && bgItemGroup.length() > 0) {
                item.itemNumbers = bgItem.getNumbers(bgItemGroup);
            }
            item.itemGroup = bgItemGroup;
            return item;
        }

        private BgColEnumInfo getBgColEnum(Map areaMap, Map rowIds, Map colIds) {
            if (areaMap == null || rowIds == null || colIds == null || rowIds.isEmpty() || colIds.isEmpty()) {
                return null;
            }
            BgColEnumInfo col = new BgColEnumInfo();
            return col;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("  { BgOneEnumInfo BeginRow:").append(this.beginRow).append(" EndRow:").append(this.endRow).append(" BeginCol:").append(this.beginCol).append(" EndCol:").append(this.endCol).append("\n");
            s.append("    ItemArea[ \n");
            if (this.itemAreas != null && this.itemAreas.length > 0) {
                for (int i = 0; i < this.itemAreas.length; ++i) {
                    s.append(this.itemAreas[i]);
                }
            } else {
                s.append("null");
            }
            s.append("]");
            s.append("  }");
            return s.toString();
        }

        static /* synthetic */ BgItemEnumInfo[] access$502(BgOneEnumInfo x0, BgItemEnumInfo[] x1) {
            x0.itemAreas = x1;
            return x1;
        }

        static /* synthetic */ BgColEnumInfo[] access$702(BgOneEnumInfo x0, BgColEnumInfo[] x1) {
            x0.colAreas = x1;
            return x1;
        }
    }

    public static interface IBgItemEnumFacade {
        public Set getNumbers(String var1) throws Exception;

        public Set getNumbers(HashSet var1) throws Exception;
    }
}

