/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class BgSpecialBudgetHelper {
    public static final String Special_ROW = "Special_ROW";
    public static final String Special_COL = "Special_COL";
    public static final String Special_ROW2 = "Special_ROW2";
    public static final String Special_COL2 = "Special_COL2";
    public static final String Special_Area = "Special_Area";
    public static final String Special_Begin_Cell = "Special_Begin_Cell";
    public static final String Special_End_Cell = "Special_End_Cell";
    public static final int ROW_STYLE = 1;
    public static final int COL_STYLE = 2;
    public static final int onlySpecial = 3;
    public static final int hadOther = 2;
    public static final int noSpecial = 1;
    public static final String res = "com.kingdee.eas.ma.nbudget.BgSpecialFormResource";
    public static final String OrgUint = "orgUnit";
    public static final String BgScheme = "bgScheme";
    public static final String BgTemplate = "bgTemplate";
    public static final String Currency = "currency";
    public static final String BgPeriod = "bgPeriod";
    public static final String BgItemGroup = "bgItemGroup";
    public static final String BgItem = "bgItem";

    public static void settingSpecialArea(Book book) {
        if (book == null) {
            return;
        }
        Sheet sheet = book.getActiveSheet();
        BgSpecialBudgetHelper.clearSpecialArea(sheet);
        if (sheet != null) {
            String cSign;
            Column column;
            String rSign;
            Range range = sheet.getSelectionRange();
            CellBlock block = range.getBlock(0);
            int rowIndex = block.getRow();
            int rowIndex2 = block.getRow2();
            int colIndex = block.getCol();
            int colIndex2 = block.getCol2();
            Row row = sheet.getRow(rowIndex, true);
            if (!BgNFSHelper.checkHasSign(sheet.getRow(rowIndex, true))) {
                rSign = BOSUuid.create((String)"BBBCCAAA").toString();
                BgNFSHelper.setRowSign(row, rSign);
            }
            if (!BgNFSHelper.checkHasSign(row = sheet.getRow(rowIndex2, true))) {
                rSign = BOSUuid.create((String)"BBBCCAAA").toString();
                BgNFSHelper.setRowSign(row, rSign);
            }
            if (!BgNFSHelper.checkHasSign(column = sheet.getColumn(colIndex, true))) {
                cSign = BOSUuid.create((String)"CCCAABBB").toString();
                BgNFSHelper.setColSign(column, cSign);
            }
            if (!BgNFSHelper.checkHasSign(column = sheet.getColumn(colIndex2, true))) {
                cSign = BOSUuid.create((String)"CCCAABBB").toString();
                BgNFSHelper.setColSign(column, cSign);
            }
            HashMap<String, String> areaMap = new HashMap<String, String>();
            sheet.setUserObject(Special_Area, areaMap);
            areaMap.put(Special_ROW, BgNFSHelper.getRowSign(sheet.getRow(rowIndex, false)));
            areaMap.put(Special_ROW2, BgNFSHelper.getRowSign(sheet.getRow(rowIndex2, false)));
            areaMap.put(Special_COL, BgNFSHelper.getColSign(sheet.getColumn(colIndex, false)));
            areaMap.put(Special_COL2, BgNFSHelper.getColSign(sheet.getColumn(colIndex2, false)));
            Cell beginCell = sheet.getCell(rowIndex, colIndex, true);
            Cell endCell = sheet.getCell(rowIndex2, colIndex2, true);
            beginCell.setUserObject(Special_Begin_Cell, (Object)(BgNFSHelper.getRowSign(sheet.getRow(rowIndex, false)) + BgNFSHelper.getColSign(sheet.getColumn(colIndex, false))));
            endCell.setUserObject(Special_End_Cell, (Object)(BgNFSHelper.getRowSign(sheet.getRow(rowIndex2, false)) + BgNFSHelper.getColSign(sheet.getColumn(colIndex2, false))));
        }
    }

    public static boolean checkInSpecialAreaRange(Sheet sheet) {
        if (sheet == null) {
            return false;
        }
        Range range = sheet.getSelectionRange();
        Rectangle rect = BgSpecialBudgetHelper.getSpecialArea(sheet);
        if (rect == null) {
            return false;
        }
        Object cell = null;
        int size = range.size();
        for (int i = 0; i < size; ++i) {
            CellBlock block = range.getBlock(i);
            int row = block.getRow();
            int row2 = block.getRow2();
            int col = block.getCol();
            int col2 = block.getCol2();
            for (int rowIndex = row; rowIndex <= row2; ++rowIndex) {
                for (int colIndex = col; colIndex <= col2; ++colIndex) {
                    if (rect.x > rowIndex || rowIndex > rect.height || rect.y > colIndex || colIndex > rect.width) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void clearSpecialAreaContent(Book book) {
        if (book == null) {
            return;
        }
        Sheet sheet = null;
        Cell cell = null;
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            sheet = book.getSheet(i);
            Rectangle rect = BgSpecialBudgetHelper.getSpecialArea(sheet);
            if (rect == null) continue;
            int maxRowIndex = sheet.getMaxRowIndex();
            int maxColIndex = sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= maxRowIndex; ++rowIndex) {
                for (int colIndex = 0; colIndex <= maxColIndex; ++colIndex) {
                    if (rect.x > rowIndex || rowIndex > rect.height || rect.y > colIndex || colIndex > rect.width || (cell = sheet.getCell(rowIndex, colIndex, false)) == null) continue;
                    BgNTemplateHelper.clearAll(cell, false);
                }
            }
        }
    }

    public static boolean checkInRange(int row, int col, Rectangle rect) {
        return rect.x <= row && row <= rect.height && rect.y <= col && col <= rect.width;
    }

    private static void clearSpecialArea(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        UserObject obj = sheet.getUserObject(Special_Area);
        if (obj instanceof Map) {
            ((Map)obj).clear();
        }
        sheet.removeUserObject(Special_Area);
        int maxRowIndex = sheet.getMaxRowIndex();
        int maxColIndex = sheet.getMaxColIndex();
        Cell cell = null;
        for (int rowIndex = 0; rowIndex <= maxRowIndex; ++rowIndex) {
            for (int colIndex = 0; colIndex <= maxColIndex; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                if (cell == null) continue;
                cell.removeUserObject(Special_Begin_Cell);
                cell.removeUserObject(Special_End_Cell);
            }
        }
        Range range = sheet.getSelectionRange();
        CellBlock block = range.getBlock(0);
        int row = block.getRow();
        int row2 = block.getRow2();
        int col = block.getCol();
        int col2 = block.getCol2();
        for (int rowIndex = row; rowIndex <= row2; ++rowIndex) {
            for (int colIndex = col; colIndex <= col2; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                BgNTemplateHelper.clearAll(cell, false);
            }
        }
    }

    public static Rectangle getSpecialArea(Sheet sheet) {
        if (sheet == null) {
            return null;
        }
        Map areaMap = (Map)sheet.getUserObjectValue(Special_Area);
        if (areaMap == null) {
            return null;
        }
        String rowId = (String)areaMap.get(Special_ROW);
        String row2Id = (String)areaMap.get(Special_ROW2);
        String colId = (String)areaMap.get(Special_COL);
        String col2Id = (String)areaMap.get(Special_COL2);
        int row = -1;
        int row2 = -1;
        int col = -1;
        int col2 = -1;
        if (rowId == null || row2Id == null || colId == null || col2Id == null) {
            return null;
        }
        int maxRowIndex = sheet.getMaxRowIndex();
        int maxColIndex = sheet.getMaxColIndex();
        Row _row = null;
        Column _column = null;
        String _sign = null;
        for (int rowIndex = 0; rowIndex <= maxRowIndex; ++rowIndex) {
            _row = sheet.getRow(rowIndex, false);
            if (_row == null || !BgNFSHelper.checkHasSign(_row)) continue;
            _sign = BgNFSHelper.getRowSign(_row);
            if (_sign.equals(rowId)) {
                row = rowIndex;
            }
            if (!_sign.equals(row2Id)) continue;
            row2 = rowIndex;
        }
        for (int colIndex = 0; colIndex <= maxColIndex; ++colIndex) {
            _column = sheet.getColumn(colIndex, false);
            if (_row == null || !BgNFSHelper.checkHasSign(_column)) continue;
            _sign = BgNFSHelper.getColSign(_column);
            if (_sign.equals(colId)) {
                col = colIndex;
            }
            if (!_sign.equals(col2Id)) continue;
            col2 = colIndex;
        }
        if (row == -1 || row2 == -1 || col == -1 || col2 == -1) {
            return null;
        }
        return new Rectangle(row, col, col2, row2);
    }

    public static int getAreaStyle(Rectangle rect) {
        if (rect == null) {
            return -1;
        }
        if (rect.height - rect.x == 0) {
            return 1;
        }
        if (rect.width - rect.y == 0) {
            return 2;
        }
        return -1;
    }

    public static boolean checkAreaValid(Book book) {
        Sheet sheet = book.getActiveSheet();
        if (sheet == null) {
            return false;
        }
        Range range = sheet.getSelectionRange();
        if (range.size() != 1) {
            return false;
        }
        CellBlock block = range.getBlock(0);
        int rowOffset = block.getRow2() - block.getRow();
        int colOffset = block.getCol2() - block.getCol();
        if (rowOffset > 1000 || colOffset > 1000) {
            return false;
        }
        return rowOffset == 0 || colOffset == 0;
    }

    public static void fillAndbuildFormula(Book book, BgItemInfo info, Context ctx) throws EASBizException, BOSException {
        if (book == null || info == null) {
            return;
        }
        Sheet sheet = null;
        int sheetCount = book.getSheetCount();
        int areaStyle = -1;
        Rectangle rect = null;
        boolean needReDo = false;
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            rect = BgSpecialBudgetHelper.getSpecialArea(sheet);
            areaStyle = BgSpecialBudgetHelper.getAreaStyle(rect);
            if (rect == null) continue;
            BgSpecialBudgetHelper.fillBgItem(sheet, rect, info);
            BgSpecialBudgetHelper.buildFormula(sheet, rect, areaStyle, info);
            needReDo = true;
        }
        if (needReDo) {
            BgNTemplateHelper.dealWith(book, info.getOrgUnit().getId().toString(), new HashMap(), false, false, false, false, ctx);
        }
    }

    private static void buildFormula(Sheet sheet, Rectangle rect, int areaStyle, BgItemInfo info) {
        if (sheet == null || rect == null || areaStyle < 0 || info == null || StringUtils.isEmpty((String)info.getNumber())) {
            return;
        }
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = 0;
        int colCount = 0;
        colIndex = rect.y;
        rowIndex = rect.x;
        if (areaStyle == 1) {
            rowCount = rect.x;
            colCount = sheet.getMaxColIndex();
        }
        if (areaStyle == 2) {
            rowCount = rect.height;
            colCount = sheet.getMaxColIndex();
        }
        String formulaString = null;
        String newFormula = null;
        String itemNumber = info.getNumber();
        String[] param = null;
        while (rowIndex <= rowCount) {
            for (colIndex = rect.y; colIndex <= colCount; ++colIndex) {
                Cell cell = sheet.getCell(rowIndex, colIndex, false);
                if (!BgNFSHelper.checkHasFormulaOfCell(cell) || (param = BgNFSHelper.parseFormulaPara(null, formulaString = BgNFSHelper.getFormulaOfCell(cell))) == null) continue;
                param[0] = itemNumber + "," + param[0];
                if (param.length == 4) {
                    newFormula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\")";
                }
                if (param.length == 6) {
                    newFormula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\"," + param[4] + ",\"" + param[5] + "\")";
                }
                BgNFSHelper.setEditFormulaOfCell(cell, true);
                BgNFSHelper.setFormulaOfCell(cell, newFormula);
            }
            ++rowIndex;
        }
    }

    private static void fillBgItem(Sheet sheet, Rectangle rect, BgItemInfo info) {
        if (sheet == null || rect == null || info == null || info.getId() == null) {
            return;
        }
        int colIndex = rect.y;
        int rowCount = rect.height;
        int colCount = rect.width;
        Cell cell = null;
        for (int rowIndex = rect.x; rowIndex <= rowCount; ++rowIndex) {
            for (colIndex = rect.y; colIndex <= colCount; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, true);
                BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_item", true);
                BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", info.getNumber(), true);
                BgNTemplateHelper.setBgDataValue(cell, "bgFillValue_itemId", info.getId().toString(), true);
                BgNTemplateHelper.setValue(cell, info.getName(), true);
                BgNFSHelper.setNumberFormat(cell, "@");
            }
        }
    }
}

