/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.client.BudgetUtilForClient;
import com.kingdee.eas.ma.nbudget.BgWorkPaperFactory;
import com.kingdee.eas.ma.nbudget.BgWorkPaperInfo;
import com.kingdee.eas.ma.nbudget.client.BgNWorkPaperEditUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkPaperProcessUI;
import com.kingdee.eas.util.SysUtil;
import java.util.Map;

public class BgWorkPaperProvider
extends IBookProvider {
    private BgWorkPaperProcessUI own = null;
    private String[] sheetIds = null;

    public BgWorkPaperProvider(BgWorkPaperProcessUI ui) {
        this.own = ui;
    }

    public IObjectValue createNewReport() throws Exception {
        UIContext uiContext = new UIContext(this.own.getUIContext().get("Owner"));
        uiContext.put((Object)"ORG_UNIT", this.own.getUIContext().get("ORG_UNIT"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean isSubmt = false;
        IObjectValue model = null;
        if (uiWindow.getUIObject() instanceof BgNWorkPaperEditUI) {
            isSubmt = ((BgNWorkPaperEditUI)uiWindow.getUIObject()).isSubmit();
            if (isSubmt) {
                model = uiWindow.getUIObject().getDataObject();
            }
            this.setEditValue(model);
        }
        if (!isSubmt || !(model instanceof BgWorkPaperInfo)) {
            SysUtil.abort();
        }
        return model;
    }

    public String getBizFactoryName() {
        return "com.kingdee.eas.ma.nbudget.BgWorkPaperFactory";
    }

    public ICoreBase getBizInterface() throws Exception {
        return BgWorkPaperFactory.getRemoteInstance();
    }

    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getWorkPaperInfo() == null) {
            this.setEditValue(this.createNewReport());
        }
        if (this.getWorkPaperInfo().getData() != null) {
            book = this.getWorkPaperInfo().getBook();
        }
        if (book != null) {
            if (OprtState.ADDNEW.equals(this.own.getOprtState())) {
                this.sheetIds = new String[book.getSheetCount()];
                int in = book.getSheetCount();
                for (int i = 0; i < in; ++i) {
                    this.sheetIds[i] = book.getSheet(i).getID();
                }
            }
            BudgetUtilForClient.prepareReportInfo4Display((ReportBaseInfo)this.getWorkPaperInfo(), (Book)book);
        }
        return book;
    }

    public void restoreSheetId(Book book) {
        if (book != null && this.sheetIds != null && book.getSheetCount() == this.sheetIds.length) {
            int in = book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                book.getSheet(i).setID(this.sheetIds[i]);
            }
        }
    }

    public void restoreBook(Book book) throws Exception {
        BudgetUtilForClient.prepareReportInfo4Save((ReportBaseInfo)this.getWorkPaperInfo(), (Book)book);
        this.getWorkPaperInfo().setBook(book);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.ma.nbudget.client.BgNWorkPaperEditUI";
    }

    public IObjectValue queryEditData(IObjectPK pk) throws Exception {
        return super.queryEditData(pk);
    }

    public BgWorkPaperInfo getWorkPaperInfo() {
        BgWorkPaperInfo info = null;
        if (this.getEditValue() instanceof BgWorkPaperInfo) {
            info = (BgWorkPaperInfo)this.getEditValue();
        }
        return info;
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.halfYear");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.week");
        sic.add("periodType");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.orgUnit.id");
        sic.add("bgScheme.orgUnit.number");
        sic.add("bgScheme.orgUnit.name");
        sic.add("bgWorkTemplate.id");
        sic.add("bgWorkTemplate.number");
        sic.add("bgWorkTemplate.name");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("workPaperMeasureUnit.id");
        sic.add("workPaperMeasureUnit.bgElement.id");
        sic.add("workPaperMeasureUnit.bgElement.number");
        sic.add("workPaperMeasureUnit.bgElement.name");
        sic.add("workPaperMeasureUnit.measureUnit.id");
        sic.add("workPaperMeasureUnit.measureUnit.number");
        sic.add("workPaperMeasureUnit.measureUnit.coefficient");
        sic.add("measureUnit.id");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("currency.id");
        sic.add("currency.number");
        sic.add("currency.precision");
        sic.add("currency.name");
        sic.add("orgTree.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        return sic;
    }
}

