/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgAdjustException;
import com.kingdee.eas.ma.budget.BgDataFacadeFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.BgElementDialog;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgActualAdjustTypeEnum;
import com.kingdee.eas.ma.nbudget.BgActualBillEntryCollection;
import com.kingdee.eas.ma.nbudget.BgActualBillFactory;
import com.kingdee.eas.ma.nbudget.BgActualBillInfo;
import com.kingdee.eas.ma.nbudget.BgActualBillStateEnum;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgActualBillEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgActualBillEditUI
extends AbstractBgActualBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgActualBillEditUI.class);
    protected FullOrgUnitInfo orgUnitInfo = null;
    protected BgSchemeInfo bgSchemeRootInfo = null;
    private Map paramValue = null;
    protected String bgItemColIndex = "bgItemCmbName";
    protected String bgElementColIndex = "bgElement";
    protected String currencyColIndex = "currency";
    protected String bgPeriodColIndex = "bgPeriod";
    protected String adjustTypeColIndex = "adjustType";
    protected String adjustApplyColIndex = "adjustApply";
    protected String adjustCauseColIndex = "adjustCause";
    protected String formulaColIndex = "formula";
    protected String bgItemIdColIndex = "bgItemId";

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.bgSchemeRootInfo != null) {
            this.editData.setBgScheme(this.bgSchemeRootInfo);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.paramValue = BgNSHelper.getAllParamValue();
        this.prmtBgForm.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object newValue = e.getNewValue();
                Object oldValue = e.getOldValue();
                if (newValue != null && oldValue != null) {
                    BgFormInfo newInfo = (BgFormInfo)newValue;
                    BgFormInfo oldInfo = (BgFormInfo)oldValue;
                    if (!newInfo.getId().equals((Object)oldInfo.getId())) {
                        BgActualBillEditUI.this.kdtEntry.removeRows();
                    }
                }
            }
        });
        this.initSystemInfo();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtNumber.setRequired(true);
        this.prmtBgScheme.setRequired(true);
        this.prmtBgForm.setRequired(true);
    }

    protected IObjectValue createNewData() {
        BgActualBillInfo bgActualBillInfo = new BgActualBillInfo();
        bgActualBillInfo.setCU((CtrlUnitInfo)this.getUIContext().get("ORGUNIT_CU"));
        bgActualBillInfo.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get("ORGUNIT"));
        bgActualBillInfo.setState(BgActualBillStateEnum.Edited);
        bgActualBillInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        bgActualBillInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return bgActualBillInfo;
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtBgScheme.getData() == null) {
            this.prmtBgScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAdjustBillResource", (String)"isCantNullOfBgScheme"));
            SysUtil.abort();
        }
        super.actionAddLine_actionPerformed(e);
    }

    @Override
    public void actionAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNewLine_actionPerformed(e);
        if (this.getDetailTable() != null) {
            this.addLine(this.kdtEntry);
            this.kdtEntry.addRow();
            IRow row = this.kdtEntry.getRow(this.kdtEntry.getRowCount() - 1);
            this.initEntryRow(row);
        }
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteLine_actionPerformed(e);
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgActualBillFactory.getRemoteInstance();
    }

    protected IBgForm getFormInterface() throws BOSException {
        return BgFormFactory.getRemoteInstance();
    }

    public CoreBillBaseInfo getEditData() {
        return this.editData;
    }

    protected HashMap verifyAdjust(BgActualBillEntryCollection billEntry) throws BOSException, EASBizException {
        ((BgActualBillInfo)this.getEditData()).getEntry();
        return null;
    }

    protected void initSystemInfo() throws EASBizException, BOSException {
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("ORGUNIT");
        this.initSelectInfo();
        try {
            if (this.getOprtState().equals("ADDNEW")) {
                this.actionAddNewLine_actionPerformed(null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
    }

    protected void initSelectInfo() throws EASBizException, BOSException {
        Object prmtSelect = null;
        Object comSelect = null;
        Object formattedTextField = null;
        this.initPrmtBgScheme();
        this.initPrmtBgForm();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    protected void kdtEntry_editStopped(KDTEditEvent e) throws Exception {
        super.kdtEntry_editStopped(e);
        IRow row = this.kdtEntry.getRow(e.getRowIndex());
        if (row != null && this.prmtOrgUnit.getValue() != null && this.prmtBgForm.getValue() != null && this.prmtBgScheme.getValue() != null && row.getCell("bgItemCmbName").getValue() != null && row.getCell("bgElement").getValue() != null && row.getCell("currency").getValue() != null && row.getCell("bgPeriod").getValue() != null) {
            BOSUuid orgUnitId = ((FullOrgUnitInfo)this.prmtOrgUnit.getValue()).getId();
            BOSUuid bgFormId = ((BgFormInfo)this.prmtBgForm.getValue()).getId();
            BOSUuid bgSchemeId = ((BgSchemeInfo)this.prmtBgScheme.getValue()).getId();
            StringBuffer formula = new StringBuffer("=BgItem(");
            formula.append("\"" + ((VisualItemInfo)row.getCell("bgItemCmbName").getValue()).getNumber() + "\",");
            formula.append("\"" + ((BgPeriodInfo)row.getCell("bgPeriod").getValue()).getNumber() + "\",");
            formula.append("\"" + ((BgElementInfo)row.getCell("bgElement").getValue()).getNumber() + "\",");
            formula.append("\"BgData\",");
            formula.append("true,");
            formula.append("\"" + ((CurrencyInfo)row.getCell("currency").getValue()).getNumber() + "\"");
            formula.append(")");
            try {
                BgDataInfo bgDataInfo = BgActualBillFactory.getRemoteInstance().getBudgetData(orgUnitId, bgSchemeId, bgFormId, formula.toString());
            }
            catch (BgAdjustException ex) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"26_BgActualBillEditUI"));
                row.getCell(e.getColIndex()).setValue(null);
            }
        }
    }

    protected void initPrmtBgScheme() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.orgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    protected void initPrmtBgForm() {
        if (this.orgUnitInfo == null) {
            return;
        }
        this.prmtBgForm.setValue(null);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.orgUnitInfo.getId().toString(), CompareType.EQUALS));
        if (this.prmtBgScheme.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)((BgSchemeInfo)this.prmtBgScheme.getValue()).getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)"000000000000000000000000000", CompareType.EQUALS));
        }
        filter.setMaskString("#0 and #1 ");
        view.setFilter(filter);
        this.prmtBgForm.setEntityViewInfo(view);
    }

    protected void initEntryRow(IRow row) throws EASBizException, BOSException {
        row.getCell(this.bgItemColIndex).setValue((Object)new BgItemInfo());
        KDBizPromptBox prmtSelect = null;
        KDComboBox comSelect = null;
        KDFormattedTextField formattedTextField = null;
        prmtSelect = new KDBizPromptBox();
        NewBgItemDialog bgItemDialog = new NewBgItemDialog((IUIObject)this);
        prmtSelect.setSelector((KDPromptSelector)bgItemDialog);
        prmtSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgActualBillEditUI.this.bgVisualItemInfo_dataChanged(eventObj);
            }
        });
        this.kdtEntry.getColumn(this.bgItemColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setSelector((KDPromptSelector)new BgPeriodDialog((CoreUIObject)this));
        prmtSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgActualBillEditUI.this.bgPeriodInfo_dataChanged(eventObj);
            }
        });
        this.kdtEntry.getColumn(this.bgPeriodColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        comSelect = new KDComboBox();
        BgNFCHelper.setCurrency(comSelect, this.editData.getOrgUnit().getId(), true);
        comSelect.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BgActualBillEditUI.this.currencyInfo_propertyChange(evt);
            }
        });
        this.kdtEntry.getColumn(this.currencyColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comSelect));
        prmtSelect = new KDBizPromptBox();
        BgElementDialog bgElementDialog = new BgElementDialog((IUIObject)this);
        bgElementDialog.setIsChooseOne(true);
        prmtSelect.setSelector((KDPromptSelector)bgElementDialog);
        prmtSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgActualBillEditUI.this.bgElementInfo_dataChanged(eventObj);
            }
        });
        this.kdtEntry.getColumn(this.bgElementColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        comSelect = new KDComboBox();
        comSelect.addItems(BgActualAdjustTypeEnum.getEnumList().toArray());
        this.kdtEntry.getColumn(this.adjustTypeColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comSelect));
        formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(10);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.kdtEntry.getColumn(this.adjustApplyColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.kdtEntry.getColumn(this.adjustApplyColIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(this.adjustApplyColIndex).getStyleAttributes().setNumberFormat("#,##0.000");
    }

    protected void bgVisualItemInfo_dataChanged(DataChangeEvent e) {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        int n = rowIndex = rowIndex <= -1 ? 0 : rowIndex;
        if (e.getNewValue() != null && !(e.getNewValue() instanceof VisualItemInfo)) {
            this.getDetailTable().getCell(rowIndex, this.bgItemIdColIndex).setValue(null);
            this.getDetailTable().getCell(rowIndex, this.bgItemColIndex).setValue(null);
            SysUtil.abort();
        }
    }

    protected void bgPeriodInfo_dataChanged(DataChangeEvent e) {
    }

    protected void currencyInfo_propertyChange(PropertyChangeEvent e) {
    }

    protected void bgElementInfo_dataChanged(DataChangeEvent e) {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        IRow row = this.getDetailTable().getRow(rowIndex);
        if (!(e.getNewValue() instanceof BgElementInfo)) {
            row.getCell(this.bgElementColIndex).setValue(null);
            SysUtil.abort();
        }
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        this.initPrmtBgForm();
    }

    @Override
    protected void prmtBgForm_willShow(SelectorEvent e) throws Exception {
    }

    @Override
    public void actionViewBgForm_actionPerformed(ActionEvent e) throws Exception {
        boolean checkreuslt;
        super.actionViewBgForm_actionPerformed(e);
        if (this.kdtEntry.getRowCount() <= 0) {
            return;
        }
        int rowIndex = this.kdtEntry.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"27_BgActualBillEditUI"));
            SysUtil.abort();
        }
        IRow row = this.kdtEntry.getRow(rowIndex);
        String bgDataId = ((String[])row.getUserObject())[0];
        String bgFormId = BgDataFacadeFactory.getRemoteInstance().getBgFormid(bgDataId);
        String fullOrgUnitID = ((String[])row.getUserObject())[1];
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        FullOrgUnitCollection orgCol = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.CostCenter, null, "bg_formActualBill01_list");
        boolean flag = false;
        for (int i = 0; i < orgCol.size(); ++i) {
            String orgUnitID = orgCol.get(i).getId().toString();
            if (!fullOrgUnitID.equals(orgUnitID)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"28_BgActualBillEditUI"));
            SysUtil.abort();
        }
        if (BgSHelper.isBgPermissionUsed() && !(checkreuslt = BgFormFacadeFactory.getRemoteInstance().checkDatePermission(bgFormId))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"29_BgActualBillEditUI"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)bgFormId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgNFormProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected boolean veryfyEntryContent() {
        IRow row = null;
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            row = this.kdtEntry.getRow(i);
            if (row == null || row.getCell("bgItemCmbName").getValue() != null && row.getCell("bgElement").getValue() != null && row.getCell("currency").getValue() != null && row.getCell("bgPeriod").getValue() != null) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"30_BgActualBillEditUI"));
            return false;
        }
        return true;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (!this.veryfyEntryContent()) {
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }
}

