/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAdjustFacadeFactory;
import com.kingdee.eas.ma.budget.BgCollectFacadeFactory;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPastRecordFactory;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgAdjustFacade;
import com.kingdee.eas.ma.budget.IBgCollectFacade;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgPastRecord;
import com.kingdee.eas.ma.nbudget.BgAdjustDataValue;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgAdjCurOrgView;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BgAdjCurOrgView
extends AbstractBgAdjCurOrgView {
    private static final long serialVersionUID = 9158987905047608611L;
    private IBgAdjustFacade iFacade = null;
    private IBgCollectFacade ibgCollectFacade = null;
    private String formulaStr = null;
    private List orgUnitList = null;
    protected Map bgFormIdsMap = null;
    BigDecimal sumAmount = BgNConstants.ZERO;
    BigDecimal measure = null;
    int decimal = 8;

    protected IBgAdjustFacade getFacade() throws Exception {
        if (this.iFacade == null) {
            this.iFacade = BgAdjustFacadeFactory.getRemoteInstance();
        }
        return this.iFacade;
    }

    protected IBgCollectFacade getBgCollectInterface() throws Exception {
        if (this.ibgCollectFacade == null) {
            this.ibgCollectFacade = BgCollectFacadeFactory.getRemoteInstance();
        }
        return this.ibgCollectFacade;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.processInitSystem();
        this.processInitHeadInfo();
        this.processBodyInfo();
    }

    private void processInitSystem() {
        this.txtBgDataType.setText("");
        this.txtBgElementName.setText("");
        this.txtBgItemName.setText("");
        this.txtBgItemNumber.setText("");
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.contBgItemName.setEnabled(false);
        this.contBgItemNumber.setEnabled(false);
        this.contBgElementName.setEnabled(false);
        this.contBgDataType.setEnabled(false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processInitHeadInfo() throws Exception {
        this.measure = this.getUIContext().get("GATHER_MEASUREUNIT") != null ? (BigDecimal)this.getUIContext().get("GATHER_MEASUREUNIT") : BgConstants.ONE;
        this.formulaStr = (String)this.getUIContext().get("GATHER_FORMULA");
        String[] parameter = BgNFSHelper.parseFormulaPara(null, this.formulaStr);
        if (parameter != null) {
            CurrencyInfo currencyInfo;
            if (parameter[0] != null && parameter[0].trim().length() > 0) {
                HashSet<String> bgItemsSet = new HashSet<String>();
                HashMap<String, String> bgItemsMap = new HashMap<String, String>();
                String bgItemsName = null;
                String[] bgItems = parameter[0].split(",");
                int n = bgItems.length;
                for (int i = 0; i < n; ++i) {
                    bgItemsSet.add(bgItems[i]);
                }
                try {
                    IBgItem ibgItem = BgItemFactory.getRemoteInstance();
                    if (ibgItem == null) {
                        throw new BgException(BgException.NOINSTANCE);
                    }
                    String orgUnitId = BgSHelper.getIsolateOrg((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", bgItemsSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    view.getSelector().addObjectCollection((IObjectCollection)sic);
                    BgItemInfo bgItemInfo2222222 = null;
                    BgItemCollection bgItemCol = ibgItem.getBgItemCollection(view);
                    for (BgItemInfo bgItemInfo2222222 : bgItemCol) {
                        if (bgItemsMap.containsKey(bgItemInfo2222222.getNumber())) continue;
                        bgItemsMap.put(bgItemInfo2222222.getNumber(), bgItemInfo2222222.getName());
                    }
                    if (bgItemCol != null) {
                        bgItemCol.clear();
                    }
                    int n2 = bgItems.length;
                    for (int i = 0; i < n2; ++i) {
                        bgItemsName = i == 0 ? (String)bgItemsMap.get(bgItems[i]) : bgItemsName + "|" + bgItemsMap.get(bgItems[i]);
                    }
                }
                catch (BOSException ex) {
                    try {
                        throw ex;
                        catch (EASBizException ex2) {
                            throw ex2;
                        }
                    }
                    catch (Throwable throwable) {
                        this.txtBgItemNumber.setText(parameter[0]);
                        this.txtBgItemName.setText(bgItemsName);
                        throw throwable;
                    }
                }
                this.txtBgItemNumber.setText(parameter[0]);
                this.txtBgItemName.setText(bgItemsName);
            } else {
                this.txtBgItemNumber.setText("");
                this.txtBgItemName.setText("");
            }
            if (parameter[2] != null && parameter[2].trim().length() > 0) {
                String bgElementName = null;
                try {
                    IBgElement ibgElement = BgElementFactory.getRemoteInstance();
                    if (ibgElement == null) {
                        throw new BgException(BgException.NOINSTANCE);
                    }
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)parameter[2], CompareType.EQUALS));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    view.getSelector().addObjectCollection((IObjectCollection)sic);
                    BgElementCollection bgElementCol = ibgElement.getBgElementCollection(view);
                    bgElementName = !bgElementCol.isEmpty() ? bgElementCol.get(0).getName() : "";
                    if (bgElementCol != null) {
                        bgElementCol.clear();
                    }
                }
                catch (BOSException ex) {
                    try {
                        throw ex;
                        catch (EASBizException ex3) {
                            throw ex3;
                        }
                    }
                    catch (Throwable throwable) {
                        this.txtBgElementName.setText(bgElementName);
                        throw throwable;
                    }
                }
                this.txtBgElementName.setText(bgElementName);
            }
            if (parameter[3] != null && parameter[3].trim().length() > 0) {
                this.txtBgDataType.setText(BgDataTypeEnum.BgData.getAlias());
            }
            if (parameter != null && parameter[5] != null && (currencyInfo = BgSHelper.getCurrencyInfo(null, (String)parameter[5], null)) != null) {
                this.decimal = currencyInfo.getPrecision();
            }
        }
    }

    private void processBodyInfo() throws Exception {
        Map uiContext = this.getUIContext();
        Object data = uiContext.get("BgAdjustDataValue");
        if (data != null && data instanceof BgAdjustDataValue) {
            this.processDataValue((BgAdjustDataValue)data);
        } else {
            this.queryFormDataBase();
        }
    }

    private void processDataValue(BgAdjustDataValue data) {
        IRow row = this.insertRow(data.getOrgUnitId());
        BigDecimal adjVal = data.getAdjValue();
        if (adjVal == null) {
            row.getCell("beforeAdj").setValue(null);
            row.getCell("money").setValue(null);
            row.getCell("afterAdj").setValue(null);
        } else {
            row.getCell("beforeAdj").setValue((Object)data.getOldValue().divide(this.measure, this.decimal, 4));
            row.getCell("money").setValue((Object)adjVal.divide(this.measure, this.decimal, 4));
            row.getCell("afterAdj").setValue((Object)data.getNewValue().divide(this.measure, this.decimal, 4));
        }
        row.getCell("type").setValue((Object)BgPastSourceEnum.ADJUST);
        row.getCell("adjustor").setValue((Object)data.getAdjustor());
        row.getCell("adjustTime").setValue((Object)data.getAdjusttime());
        this.sumAmount = this.sumAmount.add(adjVal == null ? BgNConstants.ZERO : adjVal.divide(this.measure, this.decimal, 4));
        this.txtTotalAmt.setText(this.sumAmount.toString());
    }

    private void queryFormDataBase() throws BOSException, EASBizException {
        Map adjustMap = null;
        String formulaString = null;
        if (this.getUIContext().get("bgFormAdjust") == null) {
            return;
        }
        adjustMap = (Map)this.getUIContext().get("bgFormAdjust");
        if (this.getUIContext().get("formulaRecord") == null) {
            return;
        }
        formulaString = (String)this.getUIContext().get("formulaRecord");
        this.sumAmount = this.sumAmount.setScale(4);
        IBgPastRecord bgPastRecord = BgPastRecordFactory.getRemoteInstance();
        if (bgPastRecord == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        IRow row = null;
        String[] para = null;
        int i = 0;
        int n = 0;
        List pastRecord = bgPastRecord.getValue(adjustMap, formulaString);
        if (pastRecord != null && !pastRecord.isEmpty()) {
            n = pastRecord.size();
            for (i = 0; i < n; ++i) {
                para = (String[])pastRecord.get(i);
                row = this.insertRow(para[0]);
                BigDecimal adjVal = new BigDecimal(para[6]);
                row.getCell("money").setValue(adjVal == null ? null : adjVal.divide(this.measure, this.decimal, 4));
                row.getCell("beforeAdj").setValue((Object)para[4]);
                row.getCell("afterAdj").setValue((Object)para[5]);
                row.getCell("auditor").setValue((Object)para[9]);
                row.getCell("auditTime").setValue((Object)para[10]);
                this.sumAmount = this.sumAmount.add(adjVal == null ? BgNConstants.ZERO : adjVal.divide(this.measure, this.decimal, 4));
            }
        }
        this.txtTotalAmt.setText(this.sumAmount.toString());
    }

    private IRow insertRow(String info) {
        int index;
        int size = this.tblMain.getRowCount();
        for (index = 0; index < size && info.compareTo(this.tblMain.getCell(index, 0).getValue().toString()) >= 0; ++index) {
        }
        return this.tblMain.addRow(index);
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            // empty if block
        }
        return re;
    }
}

