/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.ReCalculateFacadeFactory;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeEntryInfo;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeEntryTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeFactory;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemePeriodInfo;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeTemSheetInfo;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.BgReCalcSchemeHelper;
import com.kingdee.eas.ma.nbudget.SheetInfo;
import com.kingdee.eas.ma.nbudget.SheetObject;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCalculateSchemeGuideUI;
import com.kingdee.eas.ma.nbudget.client.BgCalculatePeriodOrderDialog;
import com.kingdee.eas.ma.nbudget.client.BgCalculateSchemeListUI;
import com.kingdee.eas.ma.nbudget.client.BgTemplateSheetDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BgCalculateSchemeGuideUI
extends AbstractBgCalculateSchemeGuideUI {
    private static final long serialVersionUID = -2159952691647145687L;
    private static final Logger logger = CoreUIObject.getLogger(BgCalculateSchemeGuideUI.class);
    protected OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit();

    public void onLoad() throws Exception {
        super.onLoad();
        String pk = (String)this.getUIContext().get("ID");
        this.initObj(pk);
        this.initUI();
        this.initOrg();
        this.initBgScheme();
        this.initPeriod();
        this.tblTem.checkParsed();
        this.tblCol.checkParsed();
        this.initTemTbl();
        this.initColTbl();
        KDCheckBox cb = new KDCheckBox();
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgCalculateSchemeGuideUI.this.tblColCheckBox_actionPerformed(e);
            }
        });
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)cb);
        this.tblCol.getColumn(1).setEditor((ICellEditor)editor);
        this.tblTem.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent arg0) {
            }

            public void editStopping(KDTEditEvent arg0) {
            }

            public void editStopped(KDTEditEvent arg0) {
            }

            public void editStarting(KDTEditEvent arg0) {
                BgCalculateSchemeGuideUI.this.tblTem_editStarting(arg0);
            }

            public void editStarted(KDTEditEvent arg0) {
            }

            public void editCanceled(KDTEditEvent arg0) {
            }
        });
    }

    protected void tblColCheckBox_actionPerformed(ActionEvent e) {
        int rIndex = this.tblCol.getSelectManager().getActiveRowIndex();
        IRow row = this.tblCol.getRow(rIndex);
        if (rIndex < 0) {
            return;
        }
        if (e.getSource() instanceof KDCheckBox) {
            KDCheckBox cb = (KDCheckBox)e.getSource();
            boolean isLockFirst = false;
            if (cb.isSelected()) {
                if (row.getCell(7).getValue() instanceof Boolean) {
                    row.getCell(6).setValue((Object)Boolean.FALSE);
                } else {
                    isLockFirst = true;
                }
                row.getCell(4).getStyleAttributes().setLocked(false);
            } else {
                row.getCell(6).setValue((Object)Boolean.FALSE);
                isLockFirst = true;
                row.getCell(4).getStyleAttributes().setLocked(true);
            }
            row.getCell(6).getStyleAttributes().setLocked(isLockFirst);
        }
    }

    private void initTemTbl() throws Exception {
        BgPeriodDialog period = new BgPeriodDialog((CoreUIObject)this, true);
        KDBizPromptBox prmtSelect = null;
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        prmtSelect.setSelector((KDPromptSelector)period);
        prmtSelect.setDisplayFormat("$name$");
        this.tblTem.getColumn("periods").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
    }

    private void initColTbl() throws Exception {
        KDBizPromptBox prmtSelect = null;
        BgTemplateSheetDialog tb = new BgTemplateSheetDialog();
        tb.setFlag(true);
        String bgTemId = null;
        for (int i = 0; i < this.tblCol.getRowCount() && this.tblCol.getCell(i, 0).getValue() != null; ++i) {
            bgTemId = this.tblCol.getCell(i, 0).getValue().toString();
            tb.setBgTemId(bgTemId);
            tb.setBgTemName((String)this.tblCol.getCell(i, 3).getValue());
            prmtSelect = new KDBizPromptBox();
            prmtSelect.setEditable(false);
            prmtSelect.setSelector((KDPromptSelector)tb);
            this.tblCol.getCell(i, 4).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        }
    }

    private void initPeriod() {
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this, true);
        this.prmtPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtPeriod.setRequired(true);
        this.prmtCurrency.setRequired(true);
        this.prmtPeriod.setEnabledMultiSelection(true);
        this.prmtPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    BgCalculateSchemeGuideUI.this.prmtPeriod_dataChanged(eventObj);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                    BgCalculateSchemeGuideUI.this.handUIException(e);
                }
            }
        });
    }

    @Override
    protected void prmtPeriod_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null && e.getNewValue() instanceof Object[]) {
            Object[] obj = (Object[])e.getNewValue();
            if (obj.length == 0 || obj[0] == null) {
                return;
            }
            BgPeriodInfo[] periods = (BgPeriodInfo[])e.getNewValue();
            List<BgPeriodInfo> list = Arrays.asList(periods);
            BgReCalcSchemeHelper.sortPeriodCol(list);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                periods[i] = list.get(i);
            }
            e.setNewValue((Object)periods);
        }
    }

    public void initObj(String pk) throws Exception {
    }

    protected void initBgScheme() {
        EntityViewInfo view = null;
        FilterInfo filter = null;
        if (this.org != null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.org.getId().toString()));
            filter.setMaskString("#0");
            if (BgSHelper.isBgPermissionUsed()) {
                HashSet<String> orgSet = new HashSet<String>();
                orgSet.add(this.org.getId().toString());
                filter = BgPermissionHelper.addBgSchemePermission(this.getUserPk().toString(), orgSet, filter);
            }
            view.setFilter(filter);
            this.prmtBgScheme.setEntityViewInfo(view);
        }
    }

    protected void initOrg() {
        BgCostCenterOrgViewF7 orgF7 = new BgCostCenterOrgViewF7((IUIObject)this);
        if (this.getUIContext().get("select_org") instanceof OrgUnitInfo) {
            orgF7.setRootUnitID(((OrgUnitInfo)this.getUIContext().get("select_org")).getId().toString());
            this.org = (OrgUnitInfo)this.getUIContext().get("select_org");
        } else {
            orgF7.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        }
        orgF7.setMultiSelect(false);
        orgF7.setIsShowSub(true);
        orgF7.setTitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"SelectOrgUnit"));
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgF7);
        this.org.put("treeType", (Object)new Integer(5));
        this.prmtOrgUnit.setValue((Object)this.org);
        this.prmtOrgUnit.setEditFormat("$id$");
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setValue((Object)((OrgUnitInfo)this.getUIContext().get("select_org")));
    }

    private void initUI() {
        this.KDPEdit.setVisible(true);
        this.kDPFirst.setVisible(false);
        this.kDPSecond.setVisible(false);
        this.kDPEnd.setVisible(false);
        Icon bg = EASResource.getIcon((String)"imgGuide_pic338");
        this.kDLabel1.setIcon(bg);
        this.kDLabel2.setIcon(bg);
        this.kDLabel3.setIcon(bg);
        this.kDLabel4.setIcon(bg);
        this.btnALToR.setEnabled(true);
        this.btnARToL.setEnabled(true);
        this.btnEditCancel.setEnabled(true);
        this.btnEditConfirm.setEnabled(true);
        this.btnEditNext.setEnabled(true);
        this.btnEditUp.setEnabled(false);
        this.btnEndCancel.setEnabled(true);
        this.btnEndConfirm.setEnabled(true);
        this.btnEndNext.setEnabled(false);
        this.btnEndUp.setEnabled(true);
        this.btnFirstCancel.setEnabled(true);
        this.btnFirstConfirm.setEnabled(true);
        this.btnFirstNext.setEnabled(true);
        this.btnFirstUp.setEnabled(true);
        this.btnLToR.setEnabled(true);
        this.btnRToL.setEnabled(true);
        this.btnSecondCancel.setEnabled(true);
        this.btnSecondConfirm.setEnabled(true);
        this.btnSecondDown.setEnabled(true);
        this.btnSecondUp.setEnabled(true);
        this.btnTemDown.setEnabled(true);
        this.btnTemUp.setEnabled(true);
        this.txtNumber.setRequired(true);
        this.KDMName.setRequired(true);
        this.prmtOrgUnit.setEnabled(false);
        this.prmtBgScheme.setRequired(true);
        this.btnFirstConfirm.setEnabled(false);
        this.btnSecondConfirm.setEnabled(false);
        this.btnEditConfirm.setEnabled(false);
        this.btnLToR.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnRToL.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnTemDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnTemUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnALToR.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnARToL.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.KDMDes.setMaxLength(255);
        this.KDMName.setMaxLength(255);
        this.txtNumber.setMaxLength(255);
        this.KDMName.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
        this.KDMDes.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
    }

    @Override
    public void actionALToR_actionPerformed(ActionEvent e) throws Exception {
        int count = this.kdlLeft.getElementCount();
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Object value = this.kdlLeft.getElement(i);
            this.kdlRight.addElement(value);
        }
        this.kdlLeft.removeAllElements();
    }

    @Override
    public void actionARToL_actionPerformed(ActionEvent e) throws Exception {
        int count = this.kdlRight.getElementCount();
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Object value = this.kdlRight.getElement(i);
            this.kdlLeft.addElement(value);
        }
        this.kdlRight.removeAllElements();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"31_BgCalculateSchemeGuideUI")) == 0) {
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        BgCalculateSchemeInfo info = new BgCalculateSchemeInfo();
        this.verify(info);
        BgCalculateSchemeFactory.getRemoteInstance().addnew((CoreBaseInfo)info);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"32_BgCalculateSchemeGuideUI"));
        Object obj = this.getUIContext().get("Owner");
        if (obj instanceof BgCalculateSchemeListUI) {
            ((BgCalculateSchemeListUI)((Object)obj)).refreshList();
        }
        this.getUIWindow().close();
    }

    protected void verify(BgCalculateSchemeInfo info) throws Exception {
        info.setNumber(this.txtNumber.getText());
        info.setName(this.KDMName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim());
        info.setDescription(this.KDMDes.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim());
        FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
        orgInfo.setId(((OrgUnitInfo)this.prmtOrgUnit.getData()).getId());
        info.setOrgUnit(orgInfo);
        info.setBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
        info.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
        BgCalculateSchemeEntryInfo calInfo = new BgCalculateSchemeEntryInfo();
        BgCalculateSchemeEntryTemplateInfo calTemInfo = new BgCalculateSchemeEntryTemplateInfo();
        BgCalculateSchemeTemSheetInfo temSheetInfo = new BgCalculateSchemeTemSheetInfo();
        BgCalculateSchemePeriodInfo periodInfo = new BgCalculateSchemePeriodInfo();
        BgTemplateInfo temInfo = new BgTemplateInfo();
        SheetInfo[] sheetObj = null;
        BgPeriodCollection periodObj = null;
        BOSUuid id = null;
        Object obj = null;
        boolean hasData = false;
        int m = 0;
        for (int i = 0; i < this.tblCol.getRowCount() && this.tblCol.getCell(i, 0).getValue() != null; ++i) {
            obj = this.tblCol.getCell(i, 7).getValue();
            if (!((Boolean)this.tblCol.getCell(i, 1).getValue()).booleanValue() && (!(obj instanceof Boolean) || !((Boolean)obj).booleanValue())) continue;
            hasData = true;
            temInfo.setId((BOSUuid)this.tblCol.getCell(i, 0).getValue());
            calTemInfo.setTemplate(temInfo);
            temInfo = new BgTemplateInfo();
            SheetObject sheetObject = (SheetObject)this.tblCol.getCell(i, 4).getValue();
            if (sheetObject != null && (sheetObj = sheetObject.getSheetsInfo()) != null) {
                for (int j = 0; j < sheetObj.length; ++j) {
                    temSheetInfo.setSheetId(BOSUuid.read((String)sheetObj[j].getSheetId()));
                    temSheetInfo.setSheetName(sheetObj[j].getSheetName());
                    temSheetInfo.setSheetNumber(sheetObj[j].getBgFormId());
                    calTemInfo.getSheet().add(temSheetInfo);
                    temSheetInfo = new BgCalculateSchemeTemSheetInfo();
                }
            }
            if ((periodObj = (BgPeriodCollection)this.tblCol.getCell(i, "periodObj").getValue()) != null) {
                for (int k = 0; k < periodObj.size(); ++k) {
                    periodInfo.setPeriod(periodObj.get(k));
                    periodInfo.setSeq(k);
                    calTemInfo.getPeriod().add(periodInfo);
                    periodInfo = new BgCalculateSchemePeriodInfo();
                }
            } else {
                BgPeriodInfo[] periods = null;
                periods = (BgPeriodInfo[])this.prmtPeriod.getData();
                int jn = periods.length;
                for (int j = 0; j < jn; ++j) {
                    periodInfo.setPeriod(periods[j]);
                    periodInfo.setSeq(j);
                    calTemInfo.getPeriod().add(periodInfo);
                    periodInfo = new BgCalculateSchemePeriodInfo();
                }
            }
            id = BOSUuid.create((BOSObjectType)calTemInfo.getBOSType());
            calTemInfo.setId(id);
            calTemInfo.setSeq(m);
            calInfo.setTemplate(calTemInfo);
            calTemInfo = new BgCalculateSchemeEntryTemplateInfo();
            calInfo.setIsCollect((Boolean)this.tblCol.getCell(i, 1).getValue());
            obj = this.tblCol.getCell(i, 6).getValue();
            if (obj instanceof Boolean) {
                calInfo.setIsCollectFirst((Boolean)obj);
            } else {
                calInfo.setIsCollectFirst(false);
            }
            obj = this.tblCol.getCell(i, 7).getValue();
            if (obj instanceof Boolean) {
                calInfo.setIsCalculate((Boolean)obj);
            } else {
                calInfo.setIsCalculate(false);
            }
            id = BOSUuid.create((BOSObjectType)calInfo.getBOSType());
            calInfo.setId(id);
            calInfo.setSeq(m);
            ++m;
            info.getEntry().add(calInfo);
            calInfo = new BgCalculateSchemeEntryInfo();
        }
        if (!hasData) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgCalcSchemeResource", (String)"nothaveselectcollectorrecalctempcantsave"));
            SysUtil.abort();
        }
        if (this.prmtPeriod.getText() != null && this.prmtPeriod.getText().length() <= 1000) {
            info.setPeriodNums(this.prmtPeriod.getText());
        } else if (this.prmtPeriod.getText() != null) {
            info.setPeriodNums(this.prmtPeriod.getText().substring(0, 1000));
        }
        id = BOSUuid.create((BOSObjectType)info.getBOSType());
        info.setId(id);
        BgCalculateSchemeInfo pInfo = new BgCalculateSchemeInfo();
        pInfo.setId(id);
        info.setParent(pInfo);
        info.setRootId(id);
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        this.initFirstTem();
    }

    @Override
    public void actionEditNext_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgCalcSchemeResource", (String)"numbercantnull"));
            this.txtNumber.requestFocus();
            return;
        }
        if (this.KDMName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() == null || this.KDMName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgCalcSchemeResource", (String)"namecantnull"));
            this.KDMName.requestFocus();
            return;
        }
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgCalcSchemeResource", (String)"bgschemecantnull"));
            this.prmtBgScheme.requestFocus();
            return;
        }
        this.KDPEdit.setVisible(false);
        this.kDPFirst.setVisible(true);
        this.kDPSecond.setVisible(false);
        this.kDPEnd.setVisible(false);
        this.btnFirstConfirm.setEnabled(false);
        this.btnSecondConfirm.setEnabled(false);
        this.btnEditConfirm.setEnabled(false);
    }

    protected void initFirstTem() throws Exception {
        Object obj = this.prmtBgScheme.getData();
        if (obj instanceof BgSchemeInfo) {
            this.kdlLeft.removeAllElements();
            this.kdlRight.removeAllElements();
            BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
            List templateList = ReCalculateFacadeFactory.getRemoteInstance().getTemplateBySchemeID(_bgSchemeInfo.getId().toString());
            int num = templateList.size();
            for (int i = 0; i < num; ++i) {
                this.kdlLeft.addElement(templateList.get(i));
            }
        }
    }

    @Override
    public void actionEndUp_actionPerformed(ActionEvent e) throws Exception {
        this.KDPEdit.setVisible(false);
        this.kDPFirst.setVisible(false);
        this.kDPSecond.setVisible(true);
        this.kDPEnd.setVisible(false);
        this.btnFirstConfirm.setEnabled(false);
        this.btnSecondConfirm.setEnabled(false);
        this.btnEditConfirm.setEnabled(false);
    }

    @Override
    public void actionFirstNext_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtPeriod.getData() == null || this.prmtPeriod.getData() instanceof Object[] && ((Object[])this.prmtPeriod.getData()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgCalcSchemeResource", (String)"bgperiodcantnull"));
            this.prmtPeriod.requestFocus();
            return;
        }
        if (this.prmtCurrency.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgCalcSchemeResource", (String)"currencycantnull"));
            this.prmtCurrency.requestFocus();
            return;
        }
        this.KDPEdit.setVisible(false);
        this.kDPFirst.setVisible(false);
        this.kDPSecond.setVisible(true);
        this.kDPEnd.setVisible(false);
        this.btnFirstConfirm.setEnabled(false);
        this.btnSecondConfirm.setEnabled(false);
        this.btnEditConfirm.setEnabled(false);
        this.initSecond();
    }

    protected void initSecond() {
        this.tblTem.removeRows();
        int count = this.kdlRight.getElementCount();
        if (count == 0) {
            return;
        }
        this.tblTem.addRows(count);
        BgTemplateInfo temInfo = new BgTemplateInfo();
        BgCalculatePeriodOrderDialog tb = new BgCalculatePeriodOrderDialog((CoreUIObject)this);
        BgPeriodInfo[] periods = null;
        periods = (BgPeriodInfo[])this.prmtPeriod.getData();
        BgPeriodCollection periodCol = new BgPeriodCollection();
        ArrayList<BgPeriodInfo> list = new ArrayList<BgPeriodInfo>();
        for (int j = 0; j < periods.length; ++j) {
            list.add(periods[j]);
        }
        periodCol = BgReCalcSchemeHelper.sortPeriodCol(list);
        tb.setBgPeriodCol(periodCol);
        KDBizPromptBox prmtSelect = null;
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        prmtSelect.setSelector((KDPromptSelector)tb);
        prmtSelect.setDisplayFormat("$name$");
        this.tblTem.getColumn("periods").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        for (int i = 0; i < count; ++i) {
            temInfo = (BgTemplateInfo)this.kdlRight.getElement(i);
            this.tblTem.getCell(i, 0).setValue((Object)temInfo.getId());
            this.tblTem.getCell(i, 1).setValue((Object)temInfo.getName());
            this.tblTem.getCell(i, "temObj").setValue((Object)temInfo);
            this.tblTem.getCell(i, "periods").setValue((Object)periodCol);
        }
        this.tblTem.getColumn("temObj").getStyleAttributes().setHided(true);
    }

    protected void initEnd() {
        int i;
        int rCount = this.kdlRight.getElementCount();
        int lCount = this.kdlLeft.getElementCount();
        if (rCount == 0 && lCount == 0) {
            return;
        }
        this.tblCol.removeRows();
        this.tblCol.addRows(rCount + lCount);
        BgTemplateInfo temInfo = new BgTemplateInfo();
        for (i = 0; i < lCount; ++i) {
            temInfo = (BgTemplateInfo)this.kdlLeft.getElement(i);
            this.tblCol.getCell(i, 0).setValue((Object)temInfo.getId());
            this.tblCol.getCell(i, 1).setValue((Object)Boolean.FALSE);
            this.tblCol.getCell(i, 2).setValue((Object)temInfo.getNumber());
            this.tblCol.getCell(i, 3).setValue((Object)temInfo.getName());
            this.tblCol.getCell(i, 4).getStyleAttributes().setLocked(true);
            this.tblCol.getCell(i, 6).setValue((Object)Boolean.FALSE);
            this.tblCol.getCell(i, 6).getStyleAttributes().setLocked(true);
        }
        for (i = 0; i < rCount; ++i) {
            temInfo = (BgTemplateInfo)this.tblTem.getCell(i, "temObj").getValue();
            this.tblCol.getCell(lCount + i, 0).setValue((Object)temInfo.getId());
            this.tblCol.getCell(lCount + i, 1).setValue((Object)Boolean.FALSE);
            this.tblCol.getCell(lCount + i, 2).setValue((Object)temInfo.getNumber());
            this.tblCol.getCell(lCount + i, 3).setValue((Object)temInfo.getName());
            this.tblCol.getCell(lCount + i, 6).setValue((Object)Boolean.FALSE);
            this.tblCol.getCell(lCount + i, 6).getStyleAttributes().setLocked(true);
            this.tblCol.getCell(lCount + i, 7).setValue((Object)Boolean.TRUE);
            this.tblCol.getCell(lCount + i, 7).getStyleAttributes().setLocked(true);
            this.tblCol.getCell(lCount + i, "periodObj").setValue(this.tblTem.getCell(i, "periods").getValue());
            this.tblCol.getCell(lCount + i, 4).getStyleAttributes().setLocked(true);
        }
    }

    public void tblTem_editStarting(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 2) {
            BgPeriodCollection col = null;
            col = (BgPeriodCollection)this.tblTem.getCell(rowIndex, "periods").getValue();
            KDBizPromptBox prmtSelect = (KDBizPromptBox)this.tblTem.getColumn("periods").getEditor().getComponent();
            BgCalculatePeriodOrderDialog pd = (BgCalculatePeriodOrderDialog)prmtSelect.getSelector();
            pd.setBgPeriodCol(col);
        }
    }

    @Override
    public void actionFirstUp_actionPerformed(ActionEvent e) throws Exception {
        this.KDPEdit.setVisible(true);
        this.kDPFirst.setVisible(false);
        this.kDPSecond.setVisible(false);
        this.kDPEnd.setVisible(false);
        this.btnFirstConfirm.setEnabled(false);
        this.btnSecondConfirm.setEnabled(false);
        this.btnEditConfirm.setEnabled(false);
    }

    @Override
    public void actionLToR_actionPerformed(ActionEvent e) throws Exception {
        Object[] objAry = this.kdlLeft.getSelectedValues();
        int length = objAry.length;
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.kdlLeft.removeElement(objAry[i]);
            this.kdlRight.addElement(objAry[i]);
        }
    }

    @Override
    public void actionRToL_actionPerformed(ActionEvent e) throws Exception {
        Object[] objAry = this.kdlRight.getSelectedValues();
        int length = objAry.length;
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.kdlRight.removeElement(objAry[i]);
            this.kdlLeft.addElement(objAry[i]);
        }
    }

    @Override
    public void actionSecondDown_actionPerformed(ActionEvent e) throws Exception {
        this.KDPEdit.setVisible(false);
        this.kDPFirst.setVisible(false);
        this.kDPSecond.setVisible(false);
        this.kDPEnd.setVisible(true);
        this.btnFirstConfirm.setEnabled(false);
        this.btnSecondConfirm.setEnabled(false);
        this.btnEditConfirm.setEnabled(false);
        this.initEnd();
        this.initColTbl();
    }

    @Override
    public void actionSecondUp_actionPerformed(ActionEvent e) throws Exception {
        this.KDPEdit.setVisible(false);
        this.kDPFirst.setVisible(true);
        this.kDPSecond.setVisible(false);
        this.kDPEnd.setVisible(false);
        this.btnFirstConfirm.setEnabled(false);
        this.btnSecondConfirm.setEnabled(false);
        this.btnEditConfirm.setEnabled(false);
    }

    @Override
    public void actionTemDown_actionPerformed(ActionEvent e) throws Exception {
        int eleCount = this.kdlRight.getElementCount();
        if (eleCount == 0 || eleCount == 1) {
            return;
        }
        int selectIndex = this.kdlRight.getSelectedIndex();
        if (selectIndex == -1 || selectIndex == eleCount - 1) {
            return;
        }
        int targetIndex = selectIndex + 1;
        Object targetVal = this.kdlRight.getElement(targetIndex);
        Object selectVal = this.kdlRight.getElement(selectIndex);
        this.kdlRight.setElement(targetVal, selectIndex);
        this.kdlRight.setElement(selectVal, targetIndex);
        this.kdlRight.setSelectedIndex(targetIndex);
    }

    @Override
    public void actionTemUp_actionPerformed(ActionEvent e) throws Exception {
        int eleCount = this.kdlRight.getElementCount();
        if (eleCount == 0 || eleCount == 1) {
            return;
        }
        int selectIndex = this.kdlRight.getSelectedIndex();
        if (selectIndex == -1 || selectIndex == 0) {
            return;
        }
        int targetIndex = selectIndex - 1;
        Object targetVal = this.kdlRight.getElement(targetIndex);
        Object selectVal = this.kdlRight.getElement(selectIndex);
        this.kdlRight.setElement(targetVal, selectIndex);
        this.kdlRight.setElement(selectVal, targetIndex);
        this.kdlRight.setSelectedIndex(targetIndex);
    }
}

