/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeFactory;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemePeriodCollection;
import com.kingdee.eas.ma.nbudget.BgReCalcSchemeHelper;
import com.kingdee.eas.ma.nbudget.IBgCalculateScheme;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCalculateSchemeViewUI;
import com.kingdee.eas.ma.nbudget.client.BgCalculatePeriodOrderUI;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCalculateSchemeViewUI
extends AbstractBgCalculateSchemeViewUI {
    private static final long serialVersionUID = 4726172492374468650L;
    private static final Logger logger = CoreUIObject.getLogger(BgCalculateSchemeViewUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.showData();
        this.kdtEntry.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BgCalculateSchemeViewUI.this.kdtEntry_tableClicked(e);
                }
                catch (Exception exc) {
                    BgCalculateSchemeViewUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void kdtEntry_tableClicked(KDTMouseEvent e) throws Exception {
        block4: {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            if (colIndex == 2 && e.getClickCount() == 2) {
                BgCalculateSchemePeriodCollection col = (BgCalculateSchemePeriodCollection)((Object)this.kdtEntry.getCell(rowIndex, colIndex).getUserObject());
                BgPeriodCollection periodCol = new BgPeriodCollection();
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    periodCol.add(col.get(i).getPeriod());
                }
                IUIFactory uiFactory = null;
                IUIWindow bgPeriodOrderDialog = null;
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"periodObj", (Object)periodCol);
                uiContext.put((Object)"doNothing", null);
                try {
                    uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                    bgPeriodOrderDialog = uiFactory.create(BgCalculatePeriodOrderUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
                    bgPeriodOrderDialog.show();
                }
                catch (BOSException ex) {
                    logger.error((Object)"error", (Throwable)ex);
                    if (bgPeriodOrderDialog == null) break block4;
                    bgPeriodOrderDialog.close();
                }
            }
        }
    }

    protected void showData() throws Exception {
        String id = (String)this.getUIContext().get("object_pk");
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BgCalculateSchemeInfo info = this.getBizInterface().getBgCalculateSchemeInfo((IObjectPK)pk, this.getSelectors());
        BgReCalcSchemeHelper.sortBgCalcSchemeInfosTemplateAndPeriods(info);
        this.txtName.setText(info.getName());
        this.txtName.setEnabled(false);
        this.txtNumber.setText(info.getNumber());
        this.txtNumber.setEnabled(false);
        this.prmtPeriod.setValue((Object)info.getPeriodNums());
        this.prmtPeriod.setEnabled(false);
        this.prmtCurrency.setValue((Object)info.getCurrency());
        this.prmtCurrency.setEnabled(false);
        this.prmtBgScheme.setValue((Object)info.getBgScheme());
        this.prmtBgScheme.setEnabled(false);
        this.prmtOrgUnit.setValue((Object)info.getOrgUnit());
        this.prmtOrgUnit.setEnabled(false);
        this.kDBizMultiLangArea1.setDefaultLangItemData((Object)info.getDescription());
        this.kDBizMultiLangArea1.setEnabled(false);
        this.kdtEntry.checkParsed();
        this.kdtEntry.addRows(info.getEntry().size());
        this.kdtEntry.getStyleAttributes().setLocked(true);
        StringBuffer sb = null;
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            int x;
            int xn;
            this.kdtEntry.getCell(i, "templateName").setValue((Object)info.getEntry().get(i).getTemplate().getTemplate().getName());
            this.kdtEntry.getCell(i, "templateNumber").setValue((Object)info.getEntry().get(i).getTemplate().getTemplate().getNumber());
            if (info.getEntry().get(i).getTemplate().getPeriod() != null && info.getEntry().get(i).getTemplate().getPeriod().size() > 0) {
                sb = new StringBuffer("[");
                xn = info.getEntry().get(i).getTemplate().getPeriod().size();
                for (x = 0; x < xn; ++x) {
                    if (x == xn - 1) {
                        sb.append(info.getEntry().get(i).getTemplate().getPeriod().get(x).getPeriod().getName());
                        continue;
                    }
                    sb.append(info.getEntry().get(i).getTemplate().getPeriod().get(x).getPeriod().getName()).append(",");
                }
                sb.append("]");
                this.kdtEntry.getCell(i, "periods").setValue((Object)sb.toString());
                this.kdtEntry.getCell(i, "periods").setUserObject((Object)info.getEntry().get(i).getTemplate().getPeriod());
            }
            if (info.getEntry().get(i).getTemplate().getSheet() != null && info.getEntry().get(i).getTemplate().getSheet().size() > 0) {
                sb = new StringBuffer("[");
                xn = info.getEntry().get(i).getTemplate().getSheet().size();
                for (x = 0; x < xn; ++x) {
                    if (x == xn - 1) {
                        sb.append(info.getEntry().get(i).getTemplate().getSheet().get(x).getSheetName());
                        continue;
                    }
                    sb.append(info.getEntry().get(i).getTemplate().getSheet().get(x).getSheetName()).append(";");
                }
                sb.append("]");
                this.kdtEntry.getCell(i, "sheets").setValue((Object)sb.toString());
            }
            this.kdtEntry.getCell(i, "isCalculate").setValue((Object)info.getEntry().get(i).isIsCalculate());
            this.kdtEntry.getCell(i, "isCollect").setValue((Object)info.getEntry().get(i).isIsCollect());
            this.kdtEntry.getCell(i, "isCollectFirst").setValue((Object)info.getEntry().get(i).isIsCollectFirst());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.bgCalculateScheme.id"));
        sic.add(new SelectorItemInfo("entry.template.template.id"));
        sic.add(new SelectorItemInfo("entry.template.template.name"));
        sic.add(new SelectorItemInfo("entry.template.template.number"));
        sic.add(new SelectorItemInfo("entry.template.seq"));
        sic.add(new SelectorItemInfo("entry.template.sheet.id"));
        sic.add(new SelectorItemInfo("entry.template.sheet.sheetId"));
        sic.add(new SelectorItemInfo("entry.template.sheet.sheetName"));
        sic.add(new SelectorItemInfo("entry.template.period.id"));
        sic.add(new SelectorItemInfo("entry.template.period.seq"));
        sic.add(new SelectorItemInfo("entry.template.period.period.name"));
        sic.add(new SelectorItemInfo("entry.template.period.period.number"));
        sic.add(new SelectorItemInfo("entry.template.period.period.periodType"));
        sic.add(new SelectorItemInfo("entry.template.period.period.beginDate"));
        sic.add(new SelectorItemInfo("entry.template.period.period.endDate"));
        sic.add(new SelectorItemInfo("entry.isCollect"));
        sic.add(new SelectorItemInfo("entry.isCollectFirst"));
        sic.add(new SelectorItemInfo("entry.isCalculate"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("bgScheme.name"));
        sic.add(new SelectorItemInfo("bgScheme.number"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("periodNums"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        return sic;
    }

    protected IBgCalculateScheme getBizInterface() throws Exception {
        return BgCalculateSchemeFactory.getRemoteInstance();
    }
}

