/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.client.CodingRuleIntermilNOBox;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public final class BgCodeNumberCHelper {
    private static final Logger logger = Logger.getLogger(BgCodeNumberCHelper.class);

    public static boolean hasCodeNumber(IObjectValue model, String orgUnitId) {
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist(model, orgUnitId);
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return result;
    }

    public static boolean hasCodeNumber(IObjectValue model, String orgUnitId, String property) {
        return BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId, property, null);
    }

    public static boolean hasCodeNumber(IObjectValue model, String orgUnitId, String property, String fieldName) {
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId);
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist(model, orgUnitId, property, BgCodeNumberCHelper.getParmCodingRule(fieldName));
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return result;
    }

    private static ParmCodingRule getParmCodingRule(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        ParmCodingRule pcr = new ParmCodingRule();
        pcr.setCustomProperty(fieldName);
        return pcr;
    }

    public static boolean hasDisplayNumber(IObjectValue model, String orgUnitId) {
        boolean isAddView = false;
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return isAddView;
        }
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleInfo = codingRuleManager.getCodingRule(model, orgUnitId);
            if (codingRuleInfo != null && codingRuleInfo.isIsAddView()) {
                isAddView = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return isAddView;
    }

    public static boolean hasDisplayNumber(IObjectValue model, String orgUnitId, String property) {
        return BgCodeNumberCHelper.hasDisplayNumber(model, orgUnitId, property, null);
    }

    public static boolean hasDisplayNumber(IObjectValue model, String orgUnitId, String property, String fieldName) {
        boolean isAddView = false;
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId);
        }
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return isAddView;
        }
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleInfo = codingRuleManager.getCodingRule(model, orgUnitId, property, BgCodeNumberCHelper.getParmCodingRule(fieldName));
            if (codingRuleInfo != null && codingRuleInfo.isIsAddView()) {
                isAddView = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return isAddView;
    }

    public static void applyNumber(KDTextField txtNumber, IObjectValue model, String orgUnitId, String property, boolean hasCodeNumber, boolean hasAddNewShow) {
        BgCodeNumberCHelper.applyNumber(txtNumber, model, orgUnitId, property, hasCodeNumber, hasAddNewShow, null);
    }

    public static void applyNumber(KDTextField txtField, IObjectValue model, String orgUnitId, String property, boolean hasCodeNumber, boolean hasAddNewShow, String fieldName) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (StringUtils.isEmpty((String)orgUnitId)) {
                orgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
            String customString = null;
            String number = "";
            if (iCodingRuleManager.isUseIntermitNumber(model, orgUnitId, property)) {
                if (iCodingRuleManager.isUserSelect(model, orgUnitId, property)) {
                    CodingRuleIntermilNOBox intermilNOF7 = new CodingRuleIntermilNOBox(model, orgUnitId, property, customString);
                    Object object = null;
                    if (iCodingRuleManager.isDHExist(model, orgUnitId, property)) {
                        intermilNOF7.show();
                        object = intermilNOF7.getData();
                    }
                    if (object != null) {
                        number = object.toString();
                    }
                } else {
                    number = iCodingRuleManager.getNumber(model, orgUnitId, property, customString, BgCodeNumberCHelper.getParmCodingRule(fieldName));
                }
            } else if (hasAddNewShow) {
                number = iCodingRuleManager.getNumber(model, orgUnitId, property, customString, BgCodeNumberCHelper.getParmCodingRule(fieldName));
            }
            BgCodeNumberCHelper.prepareNumber(txtField, model, fieldName, number, hasCodeNumber, hasAddNewShow);
            if (iCodingRuleManager.isModifiable(model, orgUnitId, property)) {
                BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            }
            return;
        }
        catch (Exception err) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_CodingRule"), (Throwable)err);
            BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            return;
        }
    }

    public static String getNumberCodeRule(IObjectValue model, String orgUnitId, String property, String fieldName) throws BOSException, EASBizException {
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        String number = null;
        ICodingRuleManager icm = CodingRuleManagerFactory.getRemoteInstance();
        boolean hasCode = false;
        ParmCodingRule pcr = null;
        if ("name".equals(fieldName)) {
            pcr = new ParmCodingRule();
            pcr.setCustomProperty(fieldName);
        }
        if (hasCode = icm.isExist(model, orgUnitId, property, pcr)) {
            if (icm.isUseIntermitNumber(model, orgUnitId, property) && "number".equals(fieldName)) {
                number = icm.getNonbreakNumber(model, orgUnitId, property, fieldName);
            } else {
                CodingRuleInfo codingRule = icm.getCodingRule(model, orgUnitId, property, pcr);
                number = icm.getNumber(model, codingRule);
            }
        }
        return number;
    }

    public static void applyNumber(KDTextField txtField, IObjectValue model, String orgUnitId, boolean hasCodeNumber, boolean hasAddNewShow) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (StringUtils.isEmpty((String)orgUnitId)) {
                orgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
            String number = "";
            if (iCodingRuleManager.isUseIntermitNumber(model, orgUnitId)) {
                if (iCodingRuleManager.isUserSelect(model, orgUnitId)) {
                    CodingRuleIntermilNOBox intermilNOF7 = new CodingRuleIntermilNOBox(model, orgUnitId, null, null);
                    Object object = null;
                    if (iCodingRuleManager.isDHExist(model, orgUnitId)) {
                        intermilNOF7.show();
                        object = intermilNOF7.getData();
                    }
                    if (object != null) {
                        number = object.toString();
                    }
                } else {
                    number = iCodingRuleManager.readNumber(model, orgUnitId);
                }
            } else if (hasAddNewShow) {
                number = iCodingRuleManager.getNumber(model, orgUnitId);
            }
            BgCodeNumberCHelper.prepareNumber(txtField, model, null, number, hasCodeNumber, hasAddNewShow);
            if (iCodingRuleManager.isModifiable(model, orgUnitId)) {
                BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            }
            return;
        }
        catch (Exception err) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_CodingRule"), (Throwable)err);
            BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            return;
        }
    }

    private static void prepareNumber(KDTextField txtField, IObjectValue model, String fieldName, String number, boolean hasCodeNumber, boolean hasAddNewShow) {
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = "number";
        }
        if (!StringUtils.isEmpty((String)number)) {
            model.setString(fieldName, number);
        }
        if (hasCodeNumber) {
            BgCodeNumberCHelper.setNumberTextDisable(txtField);
            if (hasAddNewShow) {
                txtField.setText(number);
            }
        }
    }

    private static void setNumberTextEnabled(KDTextField txtField) {
        txtField.setEnabled(true);
        txtField.setEditable(true);
    }

    private static void setNumberTextDisable(KDTextField txtField) {
        txtField.setEnabled(false);
        txtField.setEditable(false);
    }

    public static void dealNameCodeRule(KDTextField txtField, IObjectValue model, String orgUnitId, String property, String fieldName, EditUI ui) {
        boolean re;
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        if (StringUtils.isEmpty((String)property)) {
            property = "sourceType";
        }
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = "name";
        }
        if (re = BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId, property, fieldName)) {
            txtField.setEnabled(false);
            re = BgCodeNumberCHelper.hasDisplayNumber(model, orgUnitId, property, fieldName);
            if (re) {
                if (ui != null) {
                    ui.storeFields();
                }
                BgCodeNumberCHelper.applyNumber(txtField, model, orgUnitId, property, true, true, fieldName);
            }
        }
    }
}

