/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.ma.budget.BgAnalyseBaseFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisSimpleObjFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.IDataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchAndDealDataAnalysisSystemFacade;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnaylsisFilter2UI;
import com.kingdee.eas.ma.nbudget.BgCombinDataFilterParam;
import com.kingdee.eas.ma.nbudget.BgElimFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgWorkDataInfo;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateInfo;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCombinDataMainUI;
import com.kingdee.eas.ma.nbudget.client.BgCombinDataFilter2UI;
import com.kingdee.eas.ma.nbudget.client.BgCombinDataFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.TypeConversionUtils;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCombinDataMainUI
extends AbstractBgCombinDataMainUI {
    private static final long serialVersionUID = -3260793721927486540L;
    private static final Logger logger = CoreUIObject.getLogger(BgCombinDataMainUI.class);
    private BgCombinDataFilterUI filterUI;
    private BgCombinDataFilter2UI filter2UI;
    private FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade = new FetchAndDealDataAnalysisSystemFacade();
    public static final String resourcePath = "com.kingdee.eas.ma.budget.BgFormAnalyseLableResource";
    protected static final BigDecimal ONE = new BigDecimal("1.00");
    private Map muMap = new HashMap();
    private BigDecimal coefficient = BgNConstants.ONE;
    private int decimal = 8;
    private DecimalFormat decFormat = null;
    private boolean isNeedToFetchTheLastData = true;

    public BigDecimal getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(BigDecimal coefficient) {
        this.coefficient = coefficient;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public DecimalFormat getDecFormat() {
        return this.decFormat;
    }

    public void setDecFormat(DecimalFormat decFormat) {
        this.decFormat = decFormat;
    }

    protected int getWidthOfDialog() {
        return 300;
    }

    protected int getHeightOfDialog() {
        return 380;
    }

    protected void setUITitle() {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgEliminationResource", (String)"combinDataTitle"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuery() {
        this.clearCache();
        BgCombinDataFilterParam filter1Params = this.getFilterUIParams();
        if (((Object)((Object)filter1Params)).toString() == null) {
            if (!this.resetFilterParam()) {
                SysUtil.abort();
            }
            return;
        }
        Map dataMap = null;
        Map measureUnitInfoMap = filter1Params.getMeasureUnitInfoMap();
        BgCombinDataFilterParam filter2Params = this.getFilterUI2Params();
        try {
            dataMap = BgElimFacadeFactory.getRemoteInstance().queryWorkData((Object)filter1Params);
            if (measureUnitInfoMap == null || measureUnitInfoMap.size() <= 0) {
                measureUnitInfoMap = BgElimFacadeFactory.getRemoteInstance().queryElementUnitMap((Object)filter1Params);
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        finally {
            this.init((FilterParam)filter1Params, (FilterParam)filter2Params, measureUnitInfoMap);
            this.fillSheet(dataMap, filter1Params, filter2Params, measureUnitInfoMap);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setFilterParam(this.getFilterUI().getCustomerParams());
        if (this.hasOtherFilterUI()) {
            KDPanel[] panels = this.getOtherFilterUI();
            int n = panels.length;
            for (int i = 0; i < n; ++i) {
                this.setFilterParam(((CustomerQueryPanel)panels[i]).getCustomerParams());
            }
        }
        this.executeQuery();
    }

    protected void init(FilterParam filterParam, FilterParam filter2Params, Map measureUnitInfoMap) {
        BgCombinDataFilterParam _combinDataParam = (BgCombinDataFilterParam)filterParam;
        this.setDecimal(_combinDataParam.getCurrencyInfo().getPrecision());
        if (this.getDecimal() > 0) {
            this.setDecFormat(BgNationalFormatUIUtil.getDecimalFormat((int)this.getDecimal()));
        } else {
            this.setDecFormat(new DecimalFormat("#,##0%", BgNationalFormatUIUtil.getDecimalFormatSymbols()));
        }
        this.initMeasureUnitMap(filterParam);
        this.clearAnalyseSheet();
        this.initAnalyseData(filterParam, filter2Params, measureUnitInfoMap);
    }

    protected void initAnalyseData(FilterParam filterParam, FilterParam filter2Params, Map measureUnitInfoMap) {
        BgCombinDataFilterParam filterParam1 = (BgCombinDataFilterParam)filterParam;
        BgCombinDataFilterParam filterParam2 = (BgCombinDataFilterParam)filter2Params;
        FullOrgUnitInfo orgUnitInfo2 = null;
        FullOrgUnitInfo[] orgUnitInfos = null;
        KDTable sheet = null;
        orgUnitInfos = filterParam1.getFullOrgUnitInfoAry();
        if (orgUnitInfos != null) {
            for (FullOrgUnitInfo orgUnitInfo2 : orgUnitInfos) {
                sheet = this.addAnalyseSheet(orgUnitInfo2.getId().toString(), orgUnitInfo2.getName());
                this.initHeadOfSheet(sheet, filterParam1, filterParam2, measureUnitInfoMap);
            }
            this.initUserConfig();
        }
    }

    protected void initHeadOfSheet(KDTable sheet, BgCombinDataFilterParam filterParam1, BgCombinDataFilterParam filterParam2, Map measureUnitInfoMap) {
        if (sheet == null) {
            return;
        }
        IRow row1 = null;
        IRow row2 = null;
        Class<?> cls = null;
        sheet.setRefresh(false);
        sheet.checkParsed();
        List analyElementList = filterParam2.getAnalysisElement();
        int analyElementSize = analyElementList.size();
        sheet.addColumns(1);
        sheet.getColumn(0).setKey("bgItem");
        sheet.getColumn(0).setWidth(150);
        sheet.getColumn(0).getStyleAttributes().setLocked(true);
        try {
            cls = Class.forName("com.kingdee.eas.ma.budget.analysiscolumn.impls.CombinDataAnalysisElement");
        }
        catch (ClassNotFoundException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        sheet.addColumns(analyElementSize * measureUnitInfoMap.size());
        row1 = sheet.addHeadRow();
        row1.getCell(0).setValue((Object)BgAnalyseHelper.getMessage((String)"bgitem"));
        row2 = sheet.addHeadRow();
        sheet.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        String elementName = "";
        int j = 0;
        if (cls == null) {
            return;
        }
        Iterator iter = measureUnitInfoMap.keySet().iterator();
        while (iter.hasNext()) {
            elementName = ((BgElementInfo)iter.next()).getName();
            for (int k = 0; k < analyElementSize; ++k) {
                String fieldName = (String)analyElementList.toArray()[k];
                try {
                    Field f = cls.getField(fieldName);
                    row2.getCell(j * analyElementSize + k + 1).setValue((Object)EASResource.getString((String)resourcePath, (String)f.get(fieldName).toString()));
                    sheet.getColumn(j * analyElementSize + k + 1).setKey("key" + (j * analyElementSize + k + 1));
                    continue;
                }
                catch (SecurityException ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    continue;
                }
                catch (NoSuchFieldException ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                }
            }
            row1.getCell(j * analyElementSize + 1).setValue((Object)elementName);
            sheet.getHeadMergeManager().mergeBlock(0, j * analyElementSize + 1, 0, j * analyElementSize + analyElementSize);
            ++j;
        }
        sheet.reLayoutAndPaint();
        sheet.setRefresh(true);
    }

    protected void fillSheet(Map dataMap, BgCombinDataFilterParam filterParam, BgCombinDataFilterParam filter2Params, Map measureUnitInfoMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        KDTable sheet = null;
        IRow row = null;
        Map bgDataMap = null;
        List tmpList = null;
        List analyElementList = filter2Params.getAnalysisElement();
        String elementId = "";
        String elementNumber = "";
        String bgItemNumber = "";
        BgWorkDataInfo bgWorkDataInfo = null;
        BgElementInfo bgElementInfo2 = null;
        BigDecimal amountUnit = ONE;
        int len = 0;
        int analyElementSize = analyElementList.size();
        BigDecimal bgValue = DataDealCenter.ZERO;
        BigDecimal bgActualValue = DataDealCenter.ZERO;
        String tmp = "";
        String filldata = "";
        int in = this.getSheetSize();
        for (int i = 0; i < in; ++i) {
            sheet = (KDTable)this.getSheet(i);
            if (sheet == null || !dataMap.containsKey(sheet.getID())) continue;
            bgDataMap = (Map)dataMap.get(sheet.getID());
            sheet.setRefresh(false);
            Iterator iterTmp = bgDataMap.keySet().iterator();
            while (iterTmp.hasNext()) {
                bgItemNumber = iterTmp.next().toString();
                tmpList = (List)bgDataMap.get(bgItemNumber);
                if (tmpList == null || tmpList.size() <= 0) continue;
                row = sheet.addRow();
                row.getStyleAttributes().setLocked(true);
                row.getCell(0).setValue((Object)((BgWorkDataInfo)tmpList.get(0)).getBgItemName());
                bgValue = DataDealCenter.ZERO;
                bgActualValue = DataDealCenter.ZERO;
                for (int k = 0; k < tmpList.size(); ++k) {
                    bgWorkDataInfo = (BgWorkDataInfo)tmpList.get(k);
                    len = 0;
                    for (BgElementInfo bgElementInfo2 : measureUnitInfoMap.keySet()) {
                        elementId = bgElementInfo2.getId().toString();
                        if (filterParam.getMeasureUnitInfoMap() != null && filterParam.getMeasureUnitInfoMap().size() > 0) {
                            elementNumber = bgElementInfo2.getNumber().toString();
                            amountUnit = this.reSetAmountUnit(elementNumber, measureUnitInfoMap);
                        } else {
                            amountUnit = TypeConversionUtils.objToBigDecimal(measureUnitInfoMap.get(bgElementInfo2));
                        }
                        if (elementId.equals(bgWorkDataInfo.getBgElement().getId().toString())) {
                            if (bgWorkDataInfo.getDataType().getValue() == 1) {
                                bgValue = bgWorkDataInfo.getConsolidAmount();
                                bgValue = bgValue.divide(amountUnit, this.decimal, 4);
                            } else if (bgWorkDataInfo.getDataType().getValue() == 2) {
                                bgActualValue = bgWorkDataInfo.getConsolidAmount();
                                bgActualValue = bgActualValue.divide(amountUnit, this.decimal, 4);
                            }
                            for (int j = 0; j < analyElementSize; ++j) {
                                String fieldName = (String)analyElementList.toArray()[j];
                                if ("col4".equals(fieldName)) {
                                    if (bgWorkDataInfo.getDataType().getValue() != 1) continue;
                                    row.getCell(len * analyElementSize + j + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                    row.getCell(len * analyElementSize + j + 1).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", this.getDecimal()));
                                    row.getCell(len * analyElementSize + j + 1).setValue((Object)bgValue);
                                    continue;
                                }
                                if ("col0".equals(fieldName)) {
                                    if (bgWorkDataInfo.getDataType().getValue() != 2) continue;
                                    row.getCell(len * analyElementSize + j + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                    row.getCell(len * analyElementSize + j + 1).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", this.getDecimal()));
                                    row.getCell(len * analyElementSize + j + 1).setValue((Object)bgActualValue);
                                    continue;
                                }
                                if ("col1".equals(fieldName)) {
                                    row.getCell(len * analyElementSize + j + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                    if (bgValue.compareTo(DataDealCenter.ZERO) == 0) {
                                        tmp = this.decFormat.format(BgNConstants.ZERO);
                                        row.getCell(len * analyElementSize + j + 1).setValue((Object)(tmp + "%"));
                                        continue;
                                    }
                                    filldata = this.decFormat.format(bgActualValue.multiply(new BigDecimal(100)).divide(bgValue, this.decimal, 4));
                                    row.getCell(len * analyElementSize + j + 1).setValue((Object)(filldata + "%"));
                                    continue;
                                }
                                if ("col2".equals(fieldName)) {
                                    row.getCell(len * analyElementSize + j + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                    row.getCell(len * analyElementSize + j + 1).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", this.getDecimal()));
                                    row.getCell(len * analyElementSize + j + 1).setValue((Object)bgValue.subtract(bgActualValue));
                                    continue;
                                }
                                if (!"col3".equals(fieldName)) continue;
                                row.getCell(len * analyElementSize + j + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                if (bgValue.compareTo(DataDealCenter.ZERO) == 0) {
                                    tmp = this.decFormat.format(BgNConstants.ZERO);
                                    row.getCell(len * analyElementSize + j + 1).setValue((Object)(tmp + "%"));
                                    continue;
                                }
                                filldata = this.decFormat.format(bgValue.subtract(bgActualValue).multiply(new BigDecimal(100)).divide(bgValue, this.decimal, 4));
                                row.getCell(len * analyElementSize + j + 1).setValue((Object)(String.valueOf(filldata) + "%"));
                            }
                        }
                        ++len;
                    }
                }
            }
            sheet.setRefresh(true);
        }
    }

    private BigDecimal reSetAmountUnit(String element, Map amountUnitMap) {
        if (amountUnitMap == null || amountUnitMap.size() == 0) {
            return ONE;
        }
        for (BgElementInfo elementInfo : amountUnitMap.keySet()) {
            if (!elementInfo.getNumber().equals(element)) continue;
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)amountUnitMap.get(elementInfo);
            return measureUnitInfo.getCoefficient();
        }
        return ONE;
    }

    protected void clearAnalyseSheet() {
        if (this.getMainTabPane() != null) {
            this.getMainTabPane().removeAll();
        }
    }

    protected boolean isNeedToFetchTheLastData() {
        return this.isNeedToFetchTheLastData;
    }

    protected void setNeedToFetchTheLastData(boolean isNeedToFetchTheLastData) {
        this.isNeedToFetchTheLastData = isNeedToFetchTheLastData;
    }

    private boolean resetFilterParam() {
        try {
            CommonQueryDialog dialog = this.getCommonQueryDialog();
            if (!dialog.show()) {
                return false;
            }
            this.setFilterParam(this.getFilterUI().getCustomerParams(), BgCombinDataFilterUI.FILTER_UI_KEY);
            KDPanel[] ary = this.getOtherFilterUI();
            this.setFilterParam(((NewBgCompareAndAnaylsisFilter2UI)ary[0]).getCustomerParams(), BgCombinDataFilter2UI.FILTER_UI_KEY);
            this.executeQuery();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return true;
    }

    protected boolean getDefaultFilterParam() throws Exception {
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION)) {
            this.setSolutionId(ds.getId());
            int size = ds.getQueryPanelInfo().size();
            for (int i = 0; i < size; ++i) {
                QueryPanelInfo info = ds.getQueryPanelInfo().get(i);
                CustomerParams cp = new CustomerParams().getCustomerParams(info.getCustomerParams());
                this.setFilterParam(cp, info.getPanelClassName());
            }
        }
        return this.getFilterParam() != null;
    }

    private void setFilterParam(CustomerParams cp, String filterUIKey) {
        if (cp == null) {
            return;
        }
        BgAnalyseFilterBaseUI filterUI = this.getFilterUIByFilterUIKey(filterUIKey);
        if (filterUI instanceof BgCombinDataFilterUI) {
            BgCombinDataFilterUI filter1UI = (BgCombinDataFilterUI)filterUI;
            BgCombinDataFilterParam filter1Param = filter1UI.getOwnFilterParam();
            FullOrgUnitInfo[] ccouiAry = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeFullOrgUnit((String)cp.getCustomerParam("OrgUnitKey"));
            filter1Param.setFullOrgUnitInfoAry(ccouiAry);
            BgWorkTemplateInfo workTemplate = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgWorkTemplateInfo((String)cp.getCustomerParam("BgWorkTemplateId"));
            filter1Param.setBgWorkTemplateInfo(workTemplate);
            BgSchemeInfo scheme = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgSchemeInfo((String)cp.getCustomerParam("BgSchemeID"));
            filter1Param.setBgSchemeInfo(scheme);
            BgPeriodInfo sInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo((String)cp.getCustomerParam("BeginPeriodID"));
            filter1Param.setBeginPeriod(sInfo);
            BgPeriodInfo eInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo((String)cp.getCustomerParam("EndPeriodID"));
            filter1Param.setEndPeriod(eInfo);
            CurrencyInfo currency = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCurrencyInfo((String)cp.getCustomerParam("CurrencyID"));
            filter1Param.setCurrencyInfo(currency);
            Map measureMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeMeasureUnit((String)cp.getCustomerParam("BgMeasureUnitKey"));
            filter1Param.setMeasureUnitInfoMap(measureMap);
        } else if (filterUI instanceof BgCombinDataFilter2UI) {
            BgCombinDataFilter2UI filter2UI = (BgCombinDataFilter2UI)filterUI;
            List analysisEleList = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisElement((String)cp.getCustomerParam("BgSimpleAnalysisElement"));
            filter2UI.getOwnFilterParam().setAnalysisElement(analysisEleList);
        }
        this.defaultFilterParam = new BgAnalyseBaseFilterParam();
    }

    private BgAnalyseFilterBaseUI getFilterUIByFilterUIKey(String filterUIKey) {
        if (BgCombinDataFilterUI.FILTER_UI_KEY.equals(filterUIKey)) {
            try {
                if (this.filterUI == null) {
                    this.filterUI = new BgCombinDataFilterUI();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
            return this.filterUI;
        }
        if (BgCombinDataFilter2UI.FILTER_UI_KEY.equals(filterUIKey)) {
            try {
                if (this.filter2UI == null) {
                    this.filter2UI = new BgCombinDataFilter2UI();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
            return this.filter2UI;
        }
        return null;
    }

    protected BgAnalyseFilterBaseUI getFilterUI() {
        try {
            if (this.filterUI == null) {
                this.filterUI = new BgCombinDataFilterUI();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        return this.filterUI;
    }

    protected boolean hasOtherFilterUI() {
        return true;
    }

    protected KDPanel[] getOtherFilterUI() {
        try {
            if (this.filter2UI == null) {
                this.filter2UI = new BgCombinDataFilter2UI();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        return new KDPanel[]{this.filter2UI};
    }

    protected BgAnalyseFilterBaseUI getFilter2UI() {
        KDPanel[] ary = this.getOtherFilterUI();
        BgCombinDataFilter2UI filter2UI = (BgCombinDataFilter2UI)ary[0];
        return filter2UI;
    }

    protected BgCombinDataFilterParam getFilterUIParams() {
        BgCombinDataFilterUI tempFilterUI = (BgCombinDataFilterUI)this.getFilterUI();
        BgCombinDataFilterParam filterParam = tempFilterUI.getOwnFilterParam();
        return filterParam;
    }

    protected BgCombinDataFilterParam getFilterUI2Params() {
        KDPanel[] panels = this.getOtherFilterUI();
        this.filter2UI = (BgCombinDataFilter2UI)panels[0];
        return this.filter2UI.getOwnFilterParam();
    }

    public boolean destroyWindow() {
        this.clearCache();
        boolean re = super.destroyWindow();
        if (re) {
            this.muMap.clear();
        }
        return re;
    }

    protected final FetchAndDealDataAnalysisSystemFacade getAnalysisSysFacade() {
        return this.fetchAndDealDataFacade;
    }

    private void clearCache() {
        IDataDealCenter ddc = this.getAnalysisSysFacade().getDataDealCenter();
        if (ddc != null) {
            ddc.getFetchDataFactory().clearAllCache();
        }
    }

    protected void initMeasureUnitMap(FilterParam filterParam) {
        this.muMap.clear();
        BgCombinDataFilterParam _combinDataParam = (BgCombinDataFilterParam)filterParam;
        if (_combinDataParam.getBgWorkTemplateInfo().getDefaultMeasureUnit() != null) {
            this.setCoefficient(_combinDataParam.getBgWorkTemplateInfo().getDefaultMeasureUnit().getCoefficient());
        }
        if (_combinDataParam.getMuMap() != null) {
            Map.Entry _entry2 = null;
            BgElementInfo elementInfo = null;
            MeasureUnitInfo unitInfo = null;
            for (Map.Entry _entry2 : _combinDataParam.getMuMap().entrySet()) {
                elementInfo = (BgElementInfo)_entry2.getKey();
                unitInfo = (MeasureUnitInfo)_entry2.getValue();
                if (elementInfo == null || unitInfo == null) continue;
                this.muMap.put(elementInfo.getNumber(), unitInfo.getCoefficient());
            }
        }
    }
}

