/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.ma.budget.BudgetCtrlCaller;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.client.AbstractBgControlUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgControlUI
extends AbstractBgControlUI {
    private static final long serialVersionUID = -4784776805089627173L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRequest.setEnabled(true);
        this.btnReturn.setEnabled(true);
    }

    @Override
    protected void btnRequest_actionPerformed(ActionEvent e) throws Exception {
        super.btnRequest_actionPerformed(e);
        String billId = this.billIds.getText();
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        if (billId.indexOf(",") > 0) {
            this.showDialog(billId, true);
        } else {
            BudgetCtrlCaller.specialApprove(null, (BOSUuid)BOSUuid.read((String)billId));
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"34_BgControlUI"));
    }

    @Override
    protected void btnReturn_actionPerformed(ActionEvent e) throws Exception {
        super.btnReturn_actionPerformed(e);
        String billId = this.billIds.getText();
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        if (billId.indexOf(",") > 0) {
            this.showDialog(billId, false);
        } else {
            BudgetCtrlCaller.returnBudget(null, (BOSUuid)BOSUuid.read((String)billId));
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"35_BgControlUI"));
    }

    private void showDialog(String billIds, final boolean hasRequest) {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        final String[] _billIds = billIds.split(",");
        if (_billIds == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                String _billId2 = null;
                for (String _billId2 : _billIds) {
                    if (hasRequest) {
                        BudgetCtrlCaller.specialApprove(null, (BOSUuid)BOSUuid.read((String)_billId2));
                        continue;
                    }
                    BudgetCtrlCaller.returnBudget(null, (BOSUuid)BOSUuid.read((String)_billId2));
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }
}

