/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.rpt.util.ColorCellEditor;
import com.kingdee.eas.fi.rpt.util.ColorUtil;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.nbudget.BgCourseFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgCourseHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.IBgCourseFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCourseColorUI;
import com.kingdee.eas.ma.nbudget.client.BgFormCourseListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCourseColorUI
extends AbstractBgCourseColorUI {
    private static final long serialVersionUID = 8084530716441730578L;
    private static Logger logger = CoreUIObject.getLogger(BgCourseColorUI.class);
    private BgFormCourseListUI ui = null;
    private boolean isStartBasisApproved = BgNSHelper.isStartBasisApproved();

    public BgCourseColorUI() throws Exception {
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Cut");
        this.tblMain.getActionMap().remove("Copy");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object _obj = this.getUIContext().get("Owner");
        if (_obj != null && _obj instanceof BgFormCourseListUI) {
            this.ui = (BgFormCourseListUI)((Object)_obj);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.init();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    protected void init() throws Exception {
        IRow row = null;
        this.tblMain.getColumn("color").setEditor((ICellEditor)new ColorCellEditor());
        Map<Integer, Color> stateColorMap = this.ui.getStateColorMap();
        Set<Integer> bgFormStateEnumSet = this.getBgFormStateEnumSet();
        int key = -1;
        Color color = null;
        for (Map.Entry<Integer, Color> entry : stateColorMap.entrySet()) {
            key = entry.getKey();
            if (!bgFormStateEnumSet.contains(key)) continue;
            color = entry.getValue();
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)BgFormStateEnum.getEnum((int)key));
            row.getCell(1).setValue((Object)ColorUtil.getColorDesc((Color)color));
            row.getCell(1).getStyleAttributes().setBackground(color);
        }
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                super.editStopped(e);
                if (e.getColIndex() == BgCourseColorUI.this.tblMain.getColumnIndex("color") && e.getValue() != null) {
                    Color color = ColorUtil.parseColor((Object)e.getValue());
                    BgCourseColorUI.this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).getStyleAttributes().setBackground(color);
                }
            }
        });
    }

    protected Set<Integer> getBgFormStateEnumSet() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(100);
        set.add(97);
        set.add(1);
        set.add(40);
        set.add(41);
        set.add(42);
        set.add(102);
        set.add(103);
        if (this.isStartBasisApproved) {
            set.add(14);
            set.add(3);
            set.add(2);
        }
        return set;
    }

    protected IBgCourseFacade getInterface() throws Exception {
        return BgCourseFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.ui == null) {
            return;
        }
        IRow row = null;
        BgFormStateEnum _state = null;
        Object _obj = null;
        String _color = null;
        HashMap<Integer, String> colorScheme = new HashMap<Integer, String>();
        Map<Integer, Color> stateColorMap = this.ui.getStateColorMap();
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            _state = (BgFormStateEnum)row.getCell(0).getValue();
            _obj = row.getCell(1).getValue();
            _color = _obj != null && _obj instanceof String && !StringUtils.isEmpty((String)_obj.toString()) ? (String)_obj : ColorUtil.getColorDesc((Color)BgCourseHelper.COUNT_COLOR);
            if (stateColorMap.containsKey(_state.getValue())) {
                stateColorMap.put(new Integer(_state.getValue()), ColorUtil.parseColor((Object)_obj));
            }
            colorScheme.put(new Integer(_state.getValue()), _color);
        }
        this.ui.initColor();
        this.ui.fillColor();
        this.getInterface().saveColorScheme(colorScheme);
        this.getUIWindow().close();
    }
}

