/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.rpt.util.ColorCellEditor;
import com.kingdee.eas.fi.rpt.util.ColorUtil;
import com.kingdee.eas.ma.nbudget.BgCourseHelper;
import com.kingdee.eas.ma.nbudget.BgCslFormFactory;
import com.kingdee.eas.ma.nbudget.BgCslFormStateEnum;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.IBgCslForm;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCslFormColorUI;
import com.kingdee.eas.ma.nbudget.client.BgCslFormListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCslFormColorUI
extends AbstractBgCslFormColorUI {
    private static final long serialVersionUID = 325239278509543623L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslFormColorUI.class);
    private BgCslFormListUI ui = null;
    private boolean isStartBasisApproved = false;
    private Map paramValue = null;

    public boolean isStartBasisApproved() {
        return this.isStartBasisApproved;
    }

    public void setStartBasisApproved(boolean isStartBasisApproved) {
        this.isStartBasisApproved = isStartBasisApproved;
    }

    public BgCslFormColorUI() throws Exception {
        this.setParamValue(BgNSHelper.getAllParamValue());
        this.setStartBasisApproved(BgNSHelper.isStartReportApproved(this.getParamValue()));
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Cut");
        this.tblMain.getActionMap().remove("Copy");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object _obj = this.getUIContext().get("Owner");
        if (_obj != null && _obj instanceof BgCslFormListUI) {
            this.ui = (BgCslFormListUI)_obj;
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.init();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    protected void init() throws Exception {
        IRow row = null;
        Color _color = null;
        this.tblMain.getColumn("color").setEditor((ICellEditor)new ColorCellEditor());
        _color = this.ui != null ? this.ui.getCOUNT_COLOR() : BgCourseHelper.COUNT_COLOR;
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)BgCslFormStateEnum.count);
        row.getCell(1).setValue((Object)ColorUtil.getColorDesc((Color)_color));
        row.getCell(1).getStyleAttributes().setBackground(_color);
        _color = this.ui != null ? this.ui.getEDIT_COLOR() : BgCourseHelper.EDIT_COLOR;
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)BgCslFormStateEnum.EDIT);
        row.getCell(1).setValue((Object)ColorUtil.getColorDesc((Color)_color));
        row.getCell(1).getStyleAttributes().setBackground(_color);
        if (this.isStartBasisApproved()) {
            _color = this.ui != null ? this.ui.getBASISAPPROVED_COLOR() : BgCourseHelper.BASISAPPROVED_COLOR;
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)BgCslFormStateEnum.LocalLevelFinished);
            row.getCell(1).setValue((Object)ColorUtil.getColorDesc((Color)_color));
            row.getCell(1).getStyleAttributes().setBackground(_color);
            _color = this.ui != null ? this.ui.getREPORT_COLOR() : BgCourseHelper.REPORT_COLOR;
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)BgCslFormStateEnum.Report);
            row.getCell(1).setValue((Object)ColorUtil.getColorDesc((Color)_color));
            row.getCell(1).getStyleAttributes().setBackground(_color);
            _color = this.ui != null ? this.ui.getCERTIFICATE_COLOR() : BgCourseHelper.CERTIFICATE_COLOR;
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)BgCslFormStateEnum.Approved);
            row.getCell(1).setValue((Object)ColorUtil.getColorDesc((Color)_color));
            row.getCell(1).getStyleAttributes().setBackground(_color);
            _color = this.ui != null ? this.ui.getBACK_COLOR() : BgCourseHelper.BACK_COLOR;
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)BgCslFormStateEnum.Backed);
            row.getCell(1).setValue((Object)ColorUtil.getColorDesc((Color)_color));
            row.getCell(1).getStyleAttributes().setBackground(_color);
        }
        _color = this.ui != null ? this.ui.getFINISHED_COLOR() : BgCourseHelper.FINISHED_COLOR;
        row = this.tblMain.addRow();
        row.getCell(0).setValue((Object)BgCslFormStateEnum.AUDITED);
        row.getCell(1).setValue((Object)ColorUtil.getColorDesc((Color)_color));
        row.getCell(1).getStyleAttributes().setBackground(_color);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                super.editStopped(e);
                if (e.getColIndex() == BgCslFormColorUI.this.tblMain.getColumnIndex("color") && e.getValue() != null) {
                    Color color = ColorUtil.parseColor((Object)e.getValue());
                    BgCslFormColorUI.this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).getStyleAttributes().setBackground(color);
                }
            }
        });
    }

    protected IBgCslForm getInterface() throws Exception {
        return BgCslFormFactory.getRemoteInstance();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        IRow row = null;
        BgCslFormStateEnum _state = null;
        Object _obj = null;
        String _color = null;
        HashMap<Integer, String> colorScheme = new HashMap<Integer, String>();
        if (this.ui != null) {
            if (this.isStartBasisApproved()) {
                this.ui.setCOUNT_COLOR(ColorUtil.parseColor((Object)this.tblMain.getCell(0, 1).getValue()));
                this.ui.setEDIT_COLOR(ColorUtil.parseColor((Object)this.tblMain.getCell(1, 1).getValue()));
                this.ui.setBASISAPPROVED_COLOR(ColorUtil.parseColor((Object)this.tblMain.getCell(2, 1).getValue()));
                this.ui.setREPORT_COLOR(ColorUtil.parseColor((Object)this.tblMain.getCell(3, 1).getValue()));
                this.ui.setCERTIFICATE_COLOR(ColorUtil.parseColor((Object)this.tblMain.getCell(4, 1).getValue()));
                this.ui.setBACK_COLOR(ColorUtil.parseColor((Object)this.tblMain.getCell(5, 1).getValue()));
                this.ui.setFINISHED_COLOR(ColorUtil.parseColor((Object)this.tblMain.getCell(6, 1).getValue()));
            } else {
                this.ui.setCOUNT_COLOR(ColorUtil.parseColor((Object)this.tblMain.getCell(0, 1).getValue()));
                this.ui.setEDIT_COLOR(ColorUtil.parseColor((Object)this.tblMain.getCell(1, 1).getValue()));
                this.ui.setFINISHED_COLOR(ColorUtil.parseColor((Object)this.tblMain.getCell(2, 1).getValue()));
            }
            this.ui.initColor();
            this.ui.fillColor();
        }
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            _state = (BgCslFormStateEnum)((Object)row.getCell(0).getValue());
            _obj = row.getCell(1).getValue();
            _color = _obj != null && _obj instanceof String && !StringUtils.isEmpty((String)_obj.toString()) ? (String)_obj : ColorUtil.getColorDesc((Color)BgCourseHelper.COUNT_COLOR);
            colorScheme.put(new Integer(_state.getValue()), _color);
        }
        this.getInterface().saveColorScheme(colorScheme);
        this.getUIWindow().close();
    }

    public void setParamValue(Map paramValue) {
        this.paramValue = paramValue;
    }

    public Map getParamValue() {
        return this.paramValue;
    }
}

