/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgCslFormFactory;
import com.kingdee.eas.ma.nbudget.BgCslFormInfo;
import com.kingdee.eas.ma.nbudget.BgCslFormMeasureUnitCollection;
import com.kingdee.eas.ma.nbudget.BgCslFormMeasureUnitInfo;
import com.kingdee.eas.ma.nbudget.BgCslFormStateEnum;
import com.kingdee.eas.ma.nbudget.BgCslTemMeasureUnitInfo;
import com.kingdee.eas.ma.nbudget.BgCslTemplateFactory;
import com.kingdee.eas.ma.nbudget.BgCslTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgElimContext;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.IBgCslForm;
import com.kingdee.eas.ma.nbudget.IBgCslTemplate;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCslFormEditUI;
import com.kingdee.eas.ma.nbudget.client.BgCodeNumberCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgCslFormEditUI
extends AbstractBgCslFormEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgCslFormEditUI.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.nbudget.client.BgCslResource";
    private boolean isSubmit = false;
    private Map elementMap = null;
    private boolean hasProperty = false;
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;

    public void onLoad() throws Exception {
        this.beforeOnLoad();
        super.onLoad();
        this.afterOnLoad();
    }

    protected void beforeOnLoad() throws Exception {
        this.setUITitle(this.getUITitle() + " - " + this.getOperStateMsg());
    }

    protected void afterOnLoad() throws Exception {
        this.initBgSchemeF7();
        this.initBgPeriodF7();
        this.initMeasureUnitInfo();
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = this.editData.getOrgUnit().getId().toString();
            boolean re = BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, OUID, "sourceType");
            if (re) {
                this.setHasProperty(true);
            } else {
                this.setHasProperty(false);
                re = BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, OUID);
            }
            this.setHasCodeNumber(re);
            if (this.isHasCodeNumber()) {
                re = this.isHasProperty() ? BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, OUID, "sourceType") : BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, OUID);
                this.setHasShowCodeNumber(re);
            }
            if (this.isHasCodeNumber()) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
            this.getNumberByCodingRule((IObjectValue)this.editData, OUID);
            BgCodeNumberCHelper.dealNameCodeRule(this.txtName, (IObjectValue)this.editData, OUID, "sourceType", "name", this);
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            if (this.isHasProperty()) {
                BgCodeNumberCHelper.applyNumber(this.txtNumber, (IObjectValue)this.editData, orgId, "sourceType", this.isHasCodeNumber(), this.isHasShowCodeNumber());
            } else {
                BgCodeNumberCHelper.applyNumber(this.txtNumber, (IObjectValue)this.editData, orgId, this.isHasCodeNumber(), this.isHasShowCodeNumber());
            }
        }
    }

    protected void initBgSchemeF7() throws Exception {
        String orgUnitId = null;
        OrgUnitInfo orgUnit = BgElimContext.getInstance().getCurMappedOrgUnit();
        orgUnitId = orgUnit != null ? orgUnit.getId().toString() : "NONE_ORGUNIT_ID";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.Id", (Object)orgUnitId));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setFilter(filter);
        view.setSorter(sorter);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    protected void initBgPeriodF7() throws Exception {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
    }

    protected void initMeasureUnitInfo() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("number");
        sic.add(sort);
        view.setSorter(sic);
        IRow row = null;
        BgElementInfo eInfo2 = null;
        BgElementCollection bgECol = null;
        this.tblMeasureUnit.setRefresh(false);
        this.tblMeasureUnit.checkParsed();
        bgECol = this.getBgElementInterface().getBgElementCollection(view);
        this.elementMap = new HashMap();
        if (bgECol != null && !bgECol.isEmpty()) {
            this.tblMeasureUnit.getColumn(0).getStyleAttributes().setLocked(true);
            this.tblMeasureUnit.getColumn(1).getStyleAttributes().setLocked(true);
            this.tblMeasureUnit.getColumn(2).getStyleAttributes().setLocked(true);
            this.tblMeasureUnit.getColumn(3).getStyleAttributes().setLocked(true);
            for (BgElementInfo eInfo2 : bgECol) {
                this.elementMap.put(eInfo2.getNumber(), eInfo2);
                row = this.tblMeasureUnit.addRow();
                row.getCell(0).setValue((Object)eInfo2.getId().toString());
                row.getCell(1).setValue((Object)eInfo2.getNumber());
                row.getCell(2).setValue((Object)eInfo2.getName());
                row.getCell(3).setValue((Object)eInfo2.getDataType().getAlias());
                row.setUserObject((Object)eInfo2);
            }
        }
        this.tblMeasureUnit.setRefresh(false);
        this.tblMeasureUnit.reLayoutAndPaint();
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("coefficient"));
        MeasureUnitInfo muInfo2 = null;
        MeasureUnitCollection muCol = null;
        KDTDefaultCellEditor editor = null;
        KDComboBox comboBox = new KDComboBox();
        DefaultComboBoxModel<MeasureUnitInfo> model = new DefaultComboBoxModel<MeasureUnitInfo>();
        try {
            muCol = this.getMeasureUnitInterface().getMeasureUnitCollection(muView);
            this.cbxMeasureUnit.removeAllItems();
            if (muCol != null && !muCol.isEmpty()) {
                for (MeasureUnitInfo muInfo2 : muCol) {
                    this.cbxMeasureUnit.addItem((Object)muInfo2);
                    model.addElement(muInfo2);
                }
            }
            comboBox.setModel(model);
            editor = new KDTDefaultCellEditor((JComboBox)comboBox);
            this.tblMeasureUnit.getColumn(4).setEditor((ICellEditor)editor);
            if (!OprtState.ADDNEW.equals(this.getOprtState())) {
                if (this.editData.getMeasureUnit() != null) {
                    BgNFCHelper.setSelectObject(this.cbxMeasureUnit, this.editData.getMeasureUnit());
                }
                this.loadMeasureUnitInfo(this.editData);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.verify(e);
            String msg = BgCslFormFactory.getRemoteInstance().checkHasExist(this.editData.getOrgUnit().getId().toString(), this.editData.getBgScheme().getId().toString(), this.editData.getBgCslTemplate().getId().toString(), this.editData.getBgPeriod().getId().toString(), this.editData.getCurrency().getId().toString(), this.editData.getDataType().getValue(), this.editData.getNumber());
            if (!StringUtils.isEmpty((String)msg)) {
                BgNFCHelper.showWarning((Component)((Object)this), EASResource.getString((String)RESOURCE, (String)msg));
            }
            this.editData.put("BgCostCenterNum", BgElimContext.getInstance().getCurMappedOrgUnit());
            this.submitBgCslFormInfo();
            this.isSubmit = true;
            this.destroyWindow();
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return false;
        }
        return super.isModify();
    }

    private void submitBgCslFormInfo() throws Exception {
        this.storeFields();
        BgCslTemplateInfo _bgCslTemplateInfo = null;
        _bgCslTemplateInfo = (BgCslTemplateInfo)this.prmtBgCslTemplate.getData();
        _bgCslTemplateInfo = this.getBgCslTemplateInfo(_bgCslTemplateInfo.getId(), true);
        this.editData.setData(_bgCslTemplateInfo.getData());
        IRow row = null;
        BgCslFormMeasureUnitCollection muc = this.editData.getCslFormMeasureUnit();
        muc.clear();
        BgCslFormMeasureUnitInfo mu = null;
        BOSUuid id = null;
        int count = this.tblMeasureUnit.getBody().size();
        for (int index = 0; index < count; ++index) {
            row = this.tblMeasureUnit.getRow(index);
            if (!(row.getCell(4).getValue() instanceof MeasureUnitInfo)) continue;
            mu = new BgCslFormMeasureUnitInfo();
            mu.setBgCslForm(this.editData);
            mu.setBgElement((BgElementInfo)row.getUserObject());
            mu.setMeasureUnit((MeasureUnitInfo)row.getCell(4).getValue());
            id = row.getCell("id").getValue() instanceof BOSUuid ? (BOSUuid)row.getCell("id").getValue() : (row.getCell("id").getValue() instanceof String ? BOSUuid.read((String)((String)row.getCell("id").getValue())) : BOSUuid.create((BOSObjectType)mu.getBOSType()));
            mu.setId(id);
            muc.add(mu);
        }
    }

    protected BgCslTemplateInfo getBgCslTemplateInfo(BOSUuid bgCslTemplateId, boolean hasLoadData) throws Exception {
        if (bgCslTemplateId == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("lastUpdateTime");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.measureUnit.*");
        sic.add("defaultMeasureUnit.id");
        if (hasLoadData) {
            sic.add("data");
        }
        return this.getBgCslTemplateInterface().getBgCslTemplateInfo((IObjectPK)new ObjectUuidPK(bgCslTemplateId), sic);
    }

    protected void fillWorkTemplateMeasureUnit(BgCslTemplateInfo template) {
        HashMap<String, BgCslFormMeasureUnitInfo> measureUnit = null;
        if (template == null) {
            this.cbxMeasureUnit.setSelectedIndex(-1);
        } else {
            BgNFCHelper.setSelectObject(this.cbxMeasureUnit, template.getDefaultMeasureUnit());
            if (template.getBgMeasureUnit() != null && !template.getBgMeasureUnit().isEmpty()) {
                measureUnit = new HashMap<String, BgCslFormMeasureUnitInfo>();
                BgCslTemMeasureUnitInfo tmu = null;
                BgCslFormMeasureUnitInfo pmu = null;
                for (int i = 0; i < template.getBgMeasureUnit().size(); ++i) {
                    tmu = template.getBgMeasureUnit().get(i);
                    pmu = new BgCslFormMeasureUnitInfo();
                    pmu.setBgElement(tmu.getBgElement());
                    pmu.setMeasureUnit(tmu.getMeasureUnit());
                    measureUnit.put(pmu.getBgElement().getId().toString(), pmu);
                }
            }
        }
        this.resetMeasureUnitMap(measureUnit);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.txtNumber.isEnabled()) {
                this.txtNumber.setText(this.txtNumber.getText().trim());
            }
            if (this.isHasCodeNumber()) {
                if (this.isHasShowCodeNumber() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
                    this.txtNumber.requestFocus();
                    BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noNumber"));
                }
                if (this.isHasShowCodeNumber()) {
                    String msg = ((IBgCslForm)this.getBizInterface()).checkNumber(this.editData.getOrgUnit().getId().toString(), this.txtNumber.getText().trim(), (IObjectValue)this.editData, true);
                    if (!StringUtil.isEmpty((String)msg)) {
                        BgNFCHelper.showWarning((Component)((Object)this), EASResource.getString((String)RESOURCE, (String)msg));
                    }
                } else {
                    String msg = ((IBgCslForm)this.getBizInterface()).checkNumber(this.editData.getOrgUnit().getId().toString(), this.txtNumber.getText().trim(), (IObjectValue)this.editData, false);
                    if (!StringUtil.isEmpty((String)msg)) {
                        BgNFCHelper.showWarning((Component)((Object)this), EASResource.getString((String)RESOURCE, (String)msg));
                    }
                }
            } else {
                String msg;
                if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                    this.txtNumber.requestFocus();
                    BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noNumber"));
                }
                if (!StringUtil.isEmpty((String)(msg = ((IBgCslForm)this.getBizInterface()).checkNumber(this.editData.getOrgUnit().getId().toString(), this.txtNumber.getText().trim(), (IObjectValue)this.editData, true)))) {
                    BgNFCHelper.showWarning((Component)((Object)this), EASResource.getString((String)RESOURCE, (String)msg));
                }
            }
            if (StringUtils.isEmpty((String)this.txtName.getText()) && this.txtName.isEnabled()) {
                this.txtName.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noName"));
            }
            if (this.prmtBgScheme.getData() == null || !(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
                this.prmtBgScheme.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noBgScheme"));
            }
            if (!(this.prmtBgCslTemplate.getData() instanceof BgCslTemplateInfo)) {
                this.prmtBgCslTemplate.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), EASResource.getString((String)RESOURCE, (String)"noCslTemplate"));
            }
            if (this.prmtBgPeriod.getData() == null || !(this.prmtBgPeriod.getData() instanceof BgPeriodInfo)) {
                this.prmtBgPeriod.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noPeriod"));
            }
            if (!(this.prmtCurrency.getData() instanceof CurrencyInfo)) {
                this.prmtCurrency.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noCurrency"));
            }
        }
    }

    protected void loadMeasureUnitInfo(BgCslFormInfo info) throws Exception {
        BgCslFormMeasureUnitInfo mu = null;
        HashMap<BOSUuid, BgCslFormMeasureUnitInfo> bgElementMuMap = null;
        if (info.getCslFormMeasureUnit() != null || !info.getCslFormMeasureUnit().isEmpty()) {
            bgElementMuMap = new HashMap<BOSUuid, BgCslFormMeasureUnitInfo>();
            for (int i = 0; i < info.getCslFormMeasureUnit().size(); ++i) {
                mu = info.getCslFormMeasureUnit().get(i);
                bgElementMuMap.put(mu.getBgElement().getId(), mu);
            }
        }
        this.resetMeasureUnitMap(bgElementMuMap);
    }

    protected void resetMeasureUnitMap(Map map) {
        IRow row = null;
        BgElementInfo bgElementInfo = null;
        int rowCount = this.tblMeasureUnit.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.tblMeasureUnit.getRow(rowIndex);
            bgElementInfo = (BgElementInfo)row.getUserObject();
            BgCslFormMeasureUnitInfo mu = null;
            if (map != null && map.get(bgElementInfo.getId().toString()) instanceof BgCslFormMeasureUnitInfo) {
                mu = (BgCslFormMeasureUnitInfo)map.get(bgElementInfo.getId().toString());
                row.getCell(4).setValue((Object)mu.getMeasureUnit());
                row.getCell("id").setValue((Object)mu.getId());
                continue;
            }
            row.getCell("id").setValue(null);
            row.getCell(4).setValue(null);
        }
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.makeName();
    }

    @Override
    protected void prmtBgCslTemplate_dataChanged(DataChangeEvent e) throws Exception {
        this.makeName();
        BgCslTemplateInfo _bgCslTemplateInfo = (BgCslTemplateInfo)this.prmtBgCslTemplate.getData();
        if (_bgCslTemplateInfo != null) {
            this.fillWorkTemplateMeasureUnit(this.getBgCslTemplateInfo(_bgCslTemplateInfo.getId(), false));
        }
    }

    protected void makeName() {
        if (this.txtName.isEnabled() && this.prmtOrgUnit.getData() instanceof FullOrgUnitInfo && this.prmtBgPeriod.getData() instanceof BgPeriodInfo && this.prmtBgCslTemplate.getData() instanceof BgCslTemplateInfo) {
            StringBuffer name = new StringBuffer();
            name.append(((FullOrgUnitInfo)this.prmtOrgUnit.getData()).getName());
            name.append("-");
            name.append(((BgPeriodInfo)this.prmtBgPeriod.getData()).getName());
            name.append("-");
            name.append(((BgCslTemplateInfo)this.prmtBgCslTemplate.getData()).getName());
            if (name.length() > this.txtName.getMaxLength()) {
                this.txtName.setText(name.substring(0, this.txtName.getMaxLength()));
            } else {
                this.txtName.setText(name.toString());
            }
        }
    }

    protected IObjectValue createNewData() {
        BgCslFormInfo info = new BgCslFormInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setState(BgCslFormStateEnum.EDIT);
        info.setStartDate(new Date());
        info.setEndDate(info.getStartDate());
        info.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
        FullOrgUnitInfo org = (FullOrgUnitInfo)this.getUIContext().get("ORG_UNIT");
        info.setOrgUnit(org);
        info.setCU(org.getCU());
        CompanyOrgUnitInfo companyInfo = null;
        try {
            companyInfo = BgNWorkPaperHelper.getCompanyByOrgUnit(null, (OrgUnitInfo)info.getOrgUnit());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (companyInfo != null) {
            info.setCompany(companyInfo);
        } else {
            companyInfo = SysContext.getSysContext().getCurrentFIUnit();
            info.setCompany(companyInfo);
        }
        try {
            BgElimContext ctx = BgElimContext.getInstance();
            info.setDataType(ctx.getCurBgDataType());
            BgSchemeInfo bgscheme = ctx.getCurBgScheme();
            info.setBgScheme(bgscheme);
            if (bgscheme instanceof BgSchemeInfo) {
                this.prmtBgScheme.setEnabled(false);
            } else {
                this.prmtBgScheme.setEnabled(true);
            }
            BgPeriodInfo period = ctx.getCurBgPeriod();
            info.setBgPeriod(period);
            if (period instanceof BgPeriodInfo) {
                this.prmtBgPeriod.setEnabled(false);
            } else {
                this.prmtBgPeriod.setEnabled(true);
            }
            info.setOrgTree(ctx.getCurOrgBound());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgCslFormFactory.getRemoteInstance();
    }

    protected IBgCslTemplate getBgCslTemplateInterface() throws Exception {
        return BgCslTemplateFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    public boolean isSubmit() {
        return this.isSubmit;
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)key) : "";
    }

    protected IMeasureUnit getMeasureUnitInterface() throws Exception {
        return MeasureUnitFactory.getRemoteInstance();
    }

    protected IBgElement getBgElementInterface() throws Exception {
        return BgElementFactory.getRemoteInstance();
    }

    protected String getOperStateMsg() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return this.getMessageStr(this.getOprtState());
        }
        return null;
    }

    public boolean isHasProperty() {
        return this.hasProperty;
    }

    public void setHasProperty(boolean hasProperty) {
        this.hasProperty = hasProperty;
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }
}

