/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.TimeMark;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.client.mutex.DataObjectMutex;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgCourseException;
import com.kingdee.eas.ma.nbudget.BgCslFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgCslFormFactory;
import com.kingdee.eas.ma.nbudget.BgCslFormInfo;
import com.kingdee.eas.ma.nbudget.BgCslFormMeasureUnitCollection;
import com.kingdee.eas.ma.nbudget.BgCslFormMeasureUnitInfo;
import com.kingdee.eas.ma.nbudget.BgCslFormPropertyAdapter;
import com.kingdee.eas.ma.nbudget.BgCslFormProvider;
import com.kingdee.eas.ma.nbudget.BgCslFormStateEnum;
import com.kingdee.eas.ma.nbudget.BgCslHelper;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.Excel2007Reader;
import com.kingdee.eas.ma.nbudget.IBgCslFacade;
import com.kingdee.eas.ma.nbudget.IBgCslForm;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCslFormProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgCslFormDisplayValueProvider;
import com.kingdee.eas.ma.nbudget.client.BgCslFormExamineResultUI;
import com.kingdee.eas.ma.nbudget.client.BgCslFormExamineViewUI;
import com.kingdee.eas.ma.nbudget.client.BgCslFormMenuManager;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.BgUserCellDisplayProvider;
import com.kingdee.eas.ma.nbudget.client.Excel2007FileFilter;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.ma.nbudget.client.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.nbudget.client.NumberCellTextEditor;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgCslFormProcessUI
extends AbstractBgCslFormProcessUI
implements IBgNumberCellDisplayHelper {
    private static final long serialVersionUID = 5748576172357343011L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslFormProcessUI.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.nbudget.client.BgCslResource";
    private boolean createNewBook = true;
    private Map measureUnitMap = new HashMap();
    private Map currencyMap = new HashMap();
    private boolean isSheetCheck = true;
    private boolean isBgExmaineCheck = true;
    private int activeSheetIndex = -1;
    private String formulaStr = null;
    private String formulaPos = null;
    private Color backColor = null;
    protected IBookProvider provider = null;
    private String xNum = null;
    private IBgElimContext ctx = BgElimContextHelper.getBgElimContext();

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.getBookProvider() instanceof BgCslFormProvider) {
                ((BgCslFormProvider)this.getBookProvider()).restoreSheetId(this.getBook());
            }
            this.getSpreadManager().getModifyManager().setModified();
        }
        if (this.isAudit() && OprtState.VIEW.equals(this.getOprtState())) {
            DataObjectMutex mutextControl = new DataObjectMutex();
            try {
                mutextControl.requestDataObjectLock(this.getEditData().getId().toString());
            }
            catch (Throwable e) {
                logger.error((Object)"", e);
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        this.initCurrencyInfo();
        this.initMeasureUnitInfo();
        this.btnUnLock.setEnabled(true);
        this.btnUnLock.setVisible(true);
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.menuItemImport.setVisible(true);
            this.menuItemImport.setEnabled(true);
        }
    }

    @Override
    protected void initSystemOtherInfo() throws Exception {
        Object obj;
        super.initSystemOtherInfo();
        if (this.getUIContext().get("OPEN_FORMULA") != null && (obj = this.getUIContext().get("Owner")) != null && obj instanceof BgExamineViewUI) {
            this.setFormulaStr(((BgExamineViewUI)obj).getSelectOfFormula());
            ((BgExamineViewUI)obj).putSelectOfUI(this.getReportId(), (BgNProcessUI)this);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.isAudit()) {
            this.actionAudit.setVisible(true);
            this.actionAudit.setEnabled(true);
            this.menuItemBgAudit.setEnabled(true);
            this.actionUnAudit.setVisible(true);
            this.actionUnAudit.setEnabled(false);
            this.menuItemBgUnAudit.setEnabled(false);
        } else if (this.isUnAudit()) {
            this.actionAudit.setVisible(true);
            this.actionAudit.setEnabled(false);
            this.menuItemBgAudit.setEnabled(false);
            this.actionUnAudit.setVisible(true);
            this.actionUnAudit.setEnabled(true);
            this.menuItemBgUnAudit.setEnabled(true);
        } else {
            this.actionAudit.setVisible(false);
            this.actionUnAudit.setVisible(false);
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getEditData() != null) {
            return new ObjectUuidPK(this.getEditData().getOrgUnit().getId());
        }
        return super.getOrgPK(action);
    }

    @Override
    protected void initToolbar() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        if (this.isAudit() || this.isUnAudit()) {
            toolBarManager.addFirstGroupItem((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionUnAudit), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())), "common");
            toolBarManager.addFirstGroupItem((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAudit), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())), "common");
        }
        super.initToolbar();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        int res;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getEditData().getId().toString());
        BgCslFormInfo info = BgCslFormFactory.getRemoteInstance().getBgCslFormInfo("select id,state where id='" + ids.get(0) + "'");
        if (info.getState().getValue() != 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"cannotAudit"));
            SysUtil.abort();
        }
        if ((res = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"confirmAudit"), this.getEditData().getName()))) != 0) {
            return;
        }
        if (BgParamCHelper.isCompulsionReportCheck()) {
            if (!this.isCheckReportPass(null, false)) {
                this.setSheetCheck(false);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"cantAuditOfCheck"));
                SysUtil.abort();
            } else {
                this.setSheetCheck(true);
            }
        } else {
            this.setSheetCheck(true);
        }
        if (this.getFacadeInterface().canExamine(new String[]{this.getReportId().toString()})) {
            this.xNum = BgCslHelper.returnExamineX(new BOSUuid[]{this.getReportId()}, this);
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    Object[] result = BgCslFormProcessUI.this.getFacadeInterface().examines(new BOSUuid[]{BgCslFormProcessUI.this.getReportId()}, BgCslFormProcessUI.this.xNum);
                    HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                    bgExamineCheckMap.put("BgExamineChecked", result[0]);
                    bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                    return bgExamineCheckMap;
                }

                public void afterExec(Object result) throws Exception {
                    if (result != null && result instanceof HashMap) {
                        BgCslFormProcessUI.this.openBgExamineViewUI(result);
                        Map bgExamineCheckMap = (Map)result;
                        Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                        if (bgExCheck.booleanValue()) {
                            BgCslFormProcessUI.this.setBgExmaineCheck(true);
                        } else {
                            BgCslFormProcessUI.this.setBgExmaineCheck(false);
                        }
                    } else {
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                    }
                }
            });
            dialog.show();
        }
        if (!this.isSheetCheck() || !this.isBgExmaineCheck()) {
            MsgBox.showInfo((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "cantAudit"));
            SysUtil.abort();
        }
        Object object = this.getUIContext().get("IS_ROOT");
        Object startFlag = this.getUIContext().get("IS_STARTED");
        if (startFlag != null && startFlag instanceof Boolean && Boolean.FALSE.equals(startFlag)) {
            BgCslFormFactory.getRemoteInstance().audit(ids);
        } else if (object != null && object instanceof Boolean && Boolean.FALSE.equals(object)) {
            BgCslFormFactory.getRemoteInstance().notRootAudit(ids);
        } else {
            BgCslFormFactory.getRemoteInstance().audit(ids);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditSuccess"));
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        ArrayList<String> pkIds = new ArrayList<String>();
        Object object = this.getUIContext().get("ID");
        if (object != null) {
            pkIds.add(object.toString());
            BgCslFormFactory.getRemoteInstance().bantchUpdateState(pkIds, BgCslFormStateEnum.Backed, BgCslFormStateEnum.EDIT, "");
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        int res;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getEditData().getId().toString());
        Object object = this.getUIContext().get("IS_ROOT");
        BgCslFormInfo info = BgCslFormFactory.getRemoteInstance().getBgCslFormInfo("select id,state where id='" + ids.get(0) + "'");
        if (!Boolean.FALSE.equals(object) && info.getState().getValue() != 2) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"cannotUnAudit"));
            SysUtil.abort();
        }
        if ((res = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"confirmUnAudit"), this.getEditData().getName()))) != 0) {
            return;
        }
        Object startFlag = this.getUIContext().get("IS_STARTED");
        Object flag = this.getUIContext().get("$actionLevelLocalUnAprovel");
        if (startFlag != null && startFlag instanceof Boolean && Boolean.FALSE.equals(object)) {
            if (flag != null && flag instanceof Boolean && Boolean.TRUE.equals(flag)) {
                BgCslFormFactory.getRemoteInstance().notRootUnAudit(ids);
            } else {
                BgCslFormFactory.getRemoteInstance().unAudit(ids);
            }
        } else if (object != null && object instanceof Boolean && Boolean.FALSE.equals(object)) {
            BgCslFormFactory.getRemoteInstance().notRootUnAudit(ids);
        } else {
            BgCslFormFactory.getRemoteInstance().unAudit(ids);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unAuditSuccess"));
    }

    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        TimeMark mark = this.getTimeMark();
        if (mark != null) {
            mark.Start();
        }
        BgCslHelper.calculateReport(null, this.getBook(), this.getEditData(), new ArrayList(this.getFormulaMap().keySet()));
        super.actionCalculate_actionPerformed(e);
        if (mark != null) {
            mark.Stop();
        }
    }

    public void actionCalculateSelectedSheet_actionPerformed(ActionEvent e) throws Exception {
        int i;
        TimeMark mark = this.getTimeMark();
        if (mark != null) {
            mark.Start();
        }
        for (i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setEnableCalculation(false);
        }
        this.getBook().getActiveSheet().setEnableCalculation(true);
        BgCslHelper.calculateReport(null, this.getBook(), this.getEditData(), new ArrayList(this.getFormulaMap().keySet()));
        for (i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setEnableCalculation(true);
        }
        super.actionCalculateSelectedSheet_actionPerformed(e);
        if (mark != null) {
            mark.Stop();
        }
    }

    @Override
    public void actionBgExamineCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionBgExamineCheck_actionPerformed(e);
        if (!OprtState.VIEW.equals(this.getOprtState()) && (this.getBook().getUndoManager().canUndo() || OprtState.ADDNEW.equals(this.getOprtState()))) {
            this.actionSave_actionPerformed(e);
        }
        if (this.getFacadeInterface().canExamine(new String[]{this.getReportId().toString()})) {
            this.xNum = BgCslHelper.returnExamineX(new BOSUuid[]{this.getReportId()}, this);
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            LongTimeDialog dialog = null;
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    Object[] result = BgCslFormProcessUI.this.getFacadeInterface().examines(new BOSUuid[]{BgCslFormProcessUI.this.getReportId()}, BgCslFormProcessUI.this.xNum);
                    HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                    bgExamineCheckMap.put("BgExamineChecked", result[0]);
                    bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                    return bgExamineCheckMap;
                }

                public void afterExec(Object result) throws Exception {
                    if (result != null && result instanceof HashMap) {
                        BgCslFormProcessUI.this.openBgExamineViewUI(result);
                    } else {
                        MsgBox.showWarning((String)BgCslFormProcessUI.this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "error"));
                    }
                }
            });
            dialog.show();
        } else {
            MsgBox.showInfo((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "cantCheckBgExamine"));
        }
    }

    @Override
    public void actionOpenExamineReport_actionPerformed(ActionEvent e) throws Exception {
        if (this.getReportId() == null) {
            return;
        }
        boolean isCanExamine = false;
        try {
            isCanExamine = this.getFacadeInterface().canExamine(new String[]{this.getReportId().toString()});
        }
        catch (Exception ee) {
            MsgBox.showInfo((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "examineFirst"));
            return;
        }
        if (isCanExamine) {
            UIContext uiContext = new UIContext((Object)this);
            ArrayList<String> bgFormIds = new ArrayList<String>();
            bgFormIds.add(this.getReportId().toString());
            uiContext.put((Object)"BG_FORM_IDS", bgFormIds);
            uiContext.put((Object)"BG_EXAMINE_IDS", null);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgCslFormExamineResultUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showInfo((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "cantCheckBgExamine"));
        }
    }

    @Override
    public void onShow() {
        String _formulaPos;
        super.onShow();
        this.showUiTitle();
        if (this.getFormulaStr() != null && !StringUtils.isEmpty((String)(_formulaPos = this.getFormulaPos()))) {
            Rect rect = TableToolkit.range2xy((String)_formulaPos);
            BgNFSHelper.setFocusOfCell(this.getSpreadManager().getSpreadContainer(), this.getActiveSheetIndex(), rect.getYBase(), rect.getXBase());
        }
    }

    protected void showUiTitle() {
        String msgKey = this.getOprtState();
        if (this.isAudit() || this.isUnAudit()) {
            msgKey = "AUDIT";
        }
        StringBuffer title = new StringBuffer();
        title.append(EASResource.getString((String)RESOURCE, (String)"bgCslForm")).append(" - ").append(BgNFCHelper.getMessageStr(msgKey));
        String _name = this.getEditData().getName();
        if (!StringUtils.isEmpty((String)_name)) {
            title.append(" - ").append(_name);
        }
        this.setUITitle(title.toString());
    }

    @Override
    public IMenuStrategy getBudgetMenuStrategy() {
        return new BgCslFormMenuManager((Component)((Object)this));
    }

    public Book getBook() {
        Book book = null;
        if (this.createNewBook && OprtState.ADDNEW.equals(this.getOprtState())) {
            this.createNewBook = false;
            try {
                book = this.getBookProvider().loadBook();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                SysUtil.abort();
            }
        } else {
            book = super.getBook();
        }
        return book;
    }

    @Override
    public IBookProvider getBudgetProvider() {
        if (this.provider == null) {
            this.provider = new BgCslFormProvider(this);
        }
        return this.provider;
    }

    public BgCslFormInfo getEditData() {
        return (BgCslFormInfo)this.getBookProvider().getEditValue();
    }

    @Override
    public MeasureUnitInfo getMeasureUnit() {
        return this.getEditData().getMeasureUnit();
    }

    protected boolean isAudit() {
        return "BGFORM_AUDIT".equals(this.getUIContext().get("BGFORM_AUDIT_TYPE"));
    }

    protected boolean isUnAudit() {
        return "BGFORM_ANTIAUDIT".equals(this.getUIContext().get("BGFORM_AUDIT_TYPE"));
    }

    @Override
    protected void showCell(Cell cell) throws Exception {
        super.showCell(cell);
        if (cell == null) {
            return;
        }
        boolean hasFormula = false;
        boolean hasExpression = false;
        String _formulaStr = null;
        String _tmpformulaStr = null;
        Object _value = null;
        Object _itemFormula = null;
        hasFormula = BgNFSHelper.checkHasFormulaOfCell(cell);
        if (hasFormula) {
            _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                _tmpformulaStr = BgCslHelper.checkFormula(this.getFormulaMap(), _formulaStr, this.getBookProvider().getEditValue());
                if (StringUtils.isEmpty((String)_tmpformulaStr)) {
                    throw new BgException(BgException.BGITEMPARSEERROR, (Object[])new String[]{_formulaStr});
                }
                if (!_formulaStr.equals(_tmpformulaStr)) {
                    BgNFSHelper.setFormulaOfCell(cell, _tmpformulaStr);
                    _formulaStr = _tmpformulaStr;
                }
                BgNFSHelper.setFormulaEditOfDisable(cell);
            }
        }
        if (hasExpression = BgNFSHelper.checkHasExpression(cell)) {
            String _expression;
            BgNFSHelper.checkExpression(cell, this.getBookProvider().getEditValue(), null);
            String expression = BgNFSHelper.getExpression(cell);
            if (!StringUtils.isEmpty((String)expression) && (_expression = BgNExpressionHelper.checkExpression(cell, expression, this.getBookProvider().getEditValue(), this.ctx.getCurMappedOrgUnit().getNumber(), null)) != null && !expression.equalsIgnoreCase(_expression.replaceAll(" ", ""))) {
                cell.setFormula(_expression);
                cell.setValue(cell.getValue());
            }
        }
        if (BgNFSHelper.checkIsLinkCell(cell) && !BgNFSHelper.checkHasTextOfCell(cell)) {
            Range range = cell.getSheet().getRange(cell);
            range.setIgnoreProtected(true);
            StyleAttributes sa = Styles.getEmptySA();
            sa.setNumberFormat("@");
            range.setStyle(sa, Styles.getEmptySA());
        }
    }

    @Override
    protected void cell_Selection_Changed(SheetChangeEvent e) throws Exception {
        super.cell_Selection_Changed(e);
        if (e.getChangedBlocks() != null && e.getSheet() != null) {
            Sheet _sheet = e.getSheet();
            String companyNumber = BgNExpressionHelper.getCompanyNumber(null, this.getBookProvider().getEditValue());
            Cell _cell = null;
            CellBlock _block = null;
            SortedCellBlockArray _blocks = null;
            _blocks = e.getChangedBlocks();
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            int size = _blocks.size();
            for (int index = 0; index < size; ++index) {
                _block = _blocks.getBlock(index);
                int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
                int rowEnd = maxRow;
                for (int rowBegin = _block.getRow(); rowBegin <= rowEnd; ++rowBegin) {
                    int colEnd = maxCol;
                    for (int colBegin = _block.getCol(); colBegin <= colEnd; ++colBegin) {
                        _cell = _sheet.getCell(rowBegin, colBegin, false);
                        if (BgNFSHelper.checkHasExpression(_cell)) {
                            BgNFSHelper.checkExpression(_cell, this.getBookProvider().getEditValue(), companyNumber);
                        }
                        if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                        this.getSpreadManager().setItemFormulaEnable(false);
                    }
                }
            }
        }
    }

    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (this.isAudit() && OprtState.VIEW.equals(this.getOprtState())) {
            DataObjectMutex mutextControl = new DataObjectMutex();
            mutextControl.releaseDataObjectLock(this.getEditData().getId().toString());
        }
        return re;
    }

    @Override
    protected BgUserCellDisplayProvider getCellDisplayRender() {
        BgUserCellDisplayProvider render = new BgUserCellDisplayProvider();
        render.setDisplayValueProvider(new BgCslFormDisplayValueProvider((Component)((Object)this)));
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new DefaultItemRenderProvider());
        return render;
    }

    @Override
    protected void showAllBook() throws Exception {
        super.showAllBook();
        this.afterLockedAndProtection();
    }

    protected void afterLockedAndProtection() {
        Book _book = null;
        Sheet _sheet = null;
        _book = this.getBook();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgNFSHelper.setBookProtection(_book, true, BgNFSHelper.getBookOperation());
            int in = _book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                _sheet = _book.getSheet(i);
                BgNFSHelper.setSheetProtection(_sheet, true, BgNFSHelper.getOnlySelectCellOperation());
            }
        } else {
            BgNFSHelper.setBookProtection(_book, true, null);
            int in = _book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                _sheet = _book.getSheet(i);
                BgNFSHelper.setSheetProtection(_sheet, true, BgNWorkPaperHelper.getSheetOperation());
            }
        }
    }

    public void showFormula(String formulaStr) {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return;
        }
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        String _tmpformulaStr = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        Cell _tmpCell = null;
        _book = this.getBook();
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            StyleAttributes sa;
            Range range;
            _sheet = _book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    _tmpformulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    if (formulaStr.equals(_tmpformulaStr)) {
                        _tmpCell = _cell;
                        continue;
                    }
                    if (!_tmpformulaStr.equals(this.formulaStr)) continue;
                    BgNFSHelper.setBackGroup(_cell, this.getBackColor());
                    range = _cell.getSheet().getRange(_cell);
                    range.setIgnoreProtected(true);
                    sa = Styles.getEmptySA();
                    sa.setBackground(this.getBackColor());
                    range.setStyle(sa, Styles.getEmptySA());
                }
            }
            if (_tmpCell == null) continue;
            this.setFormulaStr(BgNFSHelper.getFormulaOfCell(_tmpCell));
            this.setBackColor(_tmpCell.getStyle().getBackground());
            range = _tmpCell.getSheet().getRange(_tmpCell);
            range.setIgnoreProtected(true);
            sa = Styles.getEmptySA();
            sa.setBackground(Color.RED);
            range.setStyle(sa, Styles.getEmptySA());
            _book.setActiveSheet(_tmpCell.getSheet().getSheetIndex());
            _sheet.getRange(_tmpCell).select();
            break;
        }
    }

    @Override
    public Map getMeasureUnitMap() {
        return this.measureUnitMap;
    }

    public void setMeasureUnitMap(Map measureUnitMap) {
        this.measureUnitMap = measureUnitMap;
    }

    protected void initMeasureUnitInfo() throws Exception {
        this.setMeasureUnitMap(this.getMeasureUnitMap(this.getEditData()));
        if (this.getMeasureUnitMap() == null) {
            this.setMeasureUnitMap(new HashMap());
        }
    }

    protected void initCurrencyInfo() throws Exception {
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = CurrencyFactory.getRemoteInstance().getCurrencyCollection();
        if (currencyCol != null && !currencyCol.isEmpty()) {
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                this.getCurrencyMap().put(currencyInfo2.getNumber(), currencyInfo2);
            }
        }
    }

    protected Map getMeasureUnitMap(BgCslFormInfo model) {
        if (model == null) {
            return new HashMap();
        }
        if (model.getCslFormMeasureUnit() != null && !model.getCslFormMeasureUnit().isEmpty()) {
            HashMap<String, BigDecimal> measureUnit = new HashMap<String, BigDecimal>();
            BgCslFormMeasureUnitInfo muInfo = null;
            BgCslFormMeasureUnitCollection muCol = model.getCslFormMeasureUnit();
            Iterator iter = muCol.iterator();
            while (iter.hasNext()) {
                muInfo = (BgCslFormMeasureUnitInfo)iter.next();
                measureUnit.put(muInfo.getBgElement().getNumber(), muInfo.getMeasureUnit().getCoefficient());
            }
            return measureUnit;
        }
        return new HashMap();
    }

    public Map getCurrencyMap() {
        return this.currencyMap;
    }

    public void setCurrencyMap(Map currencyMap) {
        this.currencyMap = currencyMap;
    }

    public IBgCslForm getBgCslFormInterface() throws Exception {
        return BgCslFormFactory.getRemoteInstance();
    }

    public IBgCslFacade getFacadeInterface() throws Exception {
        return BgCslFacadeFactory.getRemoteInstance();
    }

    protected void openBgExamineViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.openBgExamineModel()).create(BgCslFormExamineViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String openBgExamineModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected BOSUuid getReportId() {
        return BOSUuid.read((String)this.getBillId());
    }

    public String getFormulaStr() {
        return this.formulaStr;
    }

    public void setFormulaStr(String formulaStr) {
        this.formulaStr = formulaStr;
    }

    public int getActiveSheetIndex() {
        return this.activeSheetIndex;
    }

    public void setActiveSheetIndex(int activeSheetIndex) {
        this.activeSheetIndex = activeSheetIndex;
    }

    public String getFormulaPos() {
        return this.formulaPos;
    }

    public void setFormulaPos(String formulaPos) {
        this.formulaPos = formulaPos;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color backColor) {
        this.backColor = backColor;
    }

    public boolean isSheetCheck() {
        return this.isSheetCheck;
    }

    public void setSheetCheck(boolean isSheetCheck) {
        this.isSheetCheck = isSheetCheck;
    }

    public boolean isBgExmaineCheck() {
        return this.isBgExmaineCheck;
    }

    public void setBgExmaineCheck(boolean isBgExmaineCheck) {
        this.isBgExmaineCheck = isBgExmaineCheck;
    }

    @Override
    public IReportPropertyAdapter getBudgetPropertyAdapter() {
        BgCslFormPropertyAdapter adapter = new BgCslFormPropertyAdapter();
        try {
            adapter.setOrgTreeNumber(BgElimContextHelper.getBgElimContext().getCurOrgBound().getNumber());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return adapter;
    }

    @Override
    protected void actionAfterDeleteRow(NotifyEvent e) throws Exception {
    }

    @Override
    protected void actionAfterInsertCell(NotifyEvent e) throws Exception {
    }

    @Override
    protected void actionAfterInsertCol(NotifyEvent e) throws Exception {
    }

    @Override
    protected void actionAfterInsertRow(NotifyEvent e) throws Exception {
    }

    @Override
    protected void actionBeforeCellMerge(NotifyEvent e) throws Exception {
    }

    @Override
    protected void actionBeforeDeleteCell(NotifyEvent e) throws Exception {
    }

    @Override
    protected void actionBeforeDeleteCol(NotifyEvent e) throws Exception {
    }

    @Override
    protected void actionBeforeDeleteRow(NotifyEvent e) throws Exception {
    }

    public void actionLockCells_actionPerformed(ActionEvent e) throws Exception {
        this.getBook().getUndoManager().startGroup();
        try {
            BgNFSHelper.setCellLocked(this.getBook().getActiveSheet(), this.getBook().getActiveSheet().getSelectionRange(), true);
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    public void actionUnLockCells_actionPerformed(ActionEvent e) throws Exception {
        this.beforeUnLockCell();
        this.getBook().getUndoManager().startGroup();
        try {
            BgNFSHelper.setCellLocked(this.getBook().getActiveSheet(), this.getBook().getActiveSheet().getSelectionRange(), false);
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    protected void beforeUnLockCell() throws Exception {
        Sheet _sheet = null;
        Cell _cell = null;
        ArrayList _blocks = null;
        CellBlock _block = null;
        int rowBegin = 0;
        int rowEnd = 0;
        int colBegin = 0;
        int colEnd = 0;
        int rowIndex = 0;
        int colIndex = 0;
        _sheet = this.getBook().getActiveSheet();
        _blocks = _sheet.getSheetOption().getSelection().toSelectionBlocks();
        int rowCount = _sheet.getMaxRowIndex();
        int colCount = _sheet.getMaxColIndex();
        if (_blocks != null) {
            int in = _blocks.size();
            for (int i = 0; i < in; ++i) {
                _block = (CellBlock)_blocks.get(i);
                if (_block == null) continue;
                rowBegin = _block.getRow();
                rowEnd = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                colBegin = _block.getCol();
                colEnd = _block.getCol2() > colCount ? colCount : _block.getCol2();
                for (rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                    for (colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasCertificate(_cell)) continue;
                        throw new BgCourseException(BgCourseException.CHECKCERTIFICATE);
                    }
                }
            }
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "fileExport"));
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + "//" + this.getEditData().getName() + ".xls"));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            FileFilter fileFilter = fc.getFileFilter();
            File file = fc.getSelectedFile();
            if (file.getName().indexOf(".") == -1) {
                String with = null;
                if (fileFilter instanceof ExcelFileFilter) {
                    with = ".xls";
                }
                if (fileFilter instanceof Excel2007FileFilter) {
                    with = ".xlsx";
                }
                file = new File(fc.getSelectedFile() + with);
            }
            if (file != null && file.exists()) {
                int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "existsFile"));
                if (re == 1 || re == 2) {
                    return;
                }
                file.delete();
            }
            Map _parameter = this.getExportImportParmeter(false, null);
            String fileName = file.getPath();
            try {
                BgNFCHelper.exportBookContent(fileName, _parameter, fileFilter);
                String exportSuccess = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgFormImportAndExportResource", (String)"exportSucceed");
                MsgBox.showInfo((String)exportSuccess);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
            }
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "fileImport"));
        fileChooser.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            FileFilter filter = fileChooser.getFileFilter();
            File file = fileChooser.getSelectedFile();
            KDSBook books = null;
            Map parmeter = null;
            if (file == null || !file.isFile()) {
                return;
            }
            String fileName = file.getPath();
            if (filter instanceof ExcelFileFilter) {
                books = POIXlsReader.parse((String)fileName);
            } else if (filter instanceof Excel2007FileFilter) {
                books = new Excel2007Reader().parse(fileName);
            }
            parmeter = this.getExportImportParmeter(true, books);
            if (parmeter != null && !parmeter.isEmpty()) {
                try {
                    this.importBookContent(parmeter, filter);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new BgNFormException(BgNFormException.FILEIMPORTERROR);
                }
            }
        }
    }

    protected void importBookContent(Map parmeter, FileFilter filter) throws Exception {
        BgNFCHelper.importExcel(parmeter, filter);
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    protected BigDecimal getMeasureUnitCoefficient() {
        BigDecimal _coefficient = this.getEditData().getMeasureUnit() != null ? this.getEditData().getMeasureUnit().getCoefficient() : BgNConstants.ONE;
        return _coefficient;
    }

    protected Map getExportImportParmeter(boolean isImport, KDSBook kdsBook) throws Exception {
        if (isImport && kdsBook == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"openFileError"));
            SysUtil.abort();
        }
        Book _book = this.getBook();
        BigDecimal _coefficient = this.getMeasureUnitCoefficient();
        HashMap<String, Object> _parameter = new HashMap<String, Object>();
        if (isImport && kdsBook != null) {
            _parameter.put("IMPORT_BOOK", _book);
            _parameter.put("IMPORT_KDSBOOK", kdsBook);
            _parameter.put("IMPORT_COEFFICIENT", _coefficient);
            _parameter.put("IMPORT_MEASUREUNIT", this.getMeasureUnitMap());
            _parameter.put("IMPORT_BGFORMULA", this.getFormulaMap());
            _parameter.put("IMPORT_DATA", Boolean.TRUE);
        } else if (!isImport) {
            Book tempBook = SpreadHelper.copyBook((Book)_book);
            _parameter.put("EXPORT_BOOK", tempBook);
            _parameter.put("EXPORT_COEFFICIENT", _coefficient);
            _parameter.put("EXPORT_MEASUREUNIT", this.getMeasureUnitMap());
            _parameter.put("EXPORT_BGFORMULA", this.getFormulaMap());
            _parameter.put("EXPORT_DATA", Boolean.TRUE);
        }
        return _parameter;
    }

    @Override
    protected void initSystemInfo() throws Exception {
        super.initSystemInfo();
        this.setEditor((ICellEditor)new NumberCellTextEditor(this));
    }

    @Override
    protected ICellEditor getCellEditor(Sheet sheet, int rowIndex, int colIndex) {
        return this.getEditor();
    }

    @Override
    public boolean isMenuItemMeasReplace() {
        return false;
    }
}

