/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgActualRecordCollection;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgActualRecordStateEnum;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgSchemeNodeCollection;
import com.kingdee.eas.ma.budget.BgSchemeNodeFactory;
import com.kingdee.eas.ma.budget.BgSchemeNodeInfo;
import com.kingdee.eas.ma.budget.BgTemMeasureUnitCollection;
import com.kingdee.eas.ma.budget.BgTemMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgSchemeNode;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgIEException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.Excel2007Reader;
import com.kingdee.eas.ma.nbudget.client.AbstractBgDataImportUI;
import com.kingdee.eas.ma.nbudget.client.BgCodeNumberCHelper;
import com.kingdee.eas.ma.nbudget.client.BgImportResultUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.Excel2007FileFilter;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgDataImportUI
extends AbstractBgDataImportUI {
    private static final long serialVersionUID = -1761721871767388968L;
    private static final Logger logger = CoreUIObject.getLogger(BgDataImportUI.class);
    private static int msgre = 1;
    private boolean isRelease = false;
    private String fileFormat = ".xls";
    private IPermission iPermission = null;
    private IBgScheme ibgScheme = null;
    private IBgSchemeNode ibgSchemeNode = null;
    private IBgTemplate ibgTemplate = null;
    private IFullOrgUnit ifullOrgUnit = null;
    private INewOrgViewFacade iNewOrgFacade = null;
    private IBgForm ibgForm = null;
    private IBgFormFacade ibgFormFacade = null;
    private IBgPeriod ibgPeriod = null;
    private ICurrency iCurrency = null;
    private IBgActualRecord ibgActualRecord = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initDataInfo();
        BgSchemeInfo obj = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        BgClientHelper.isMutex((Component)((Object)this), (String)obj.getId().toString(), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        BgClientHelper.applyMutexService((Component)((Object)this), (String)obj.getId().toString(), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        this.isRelease = true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectFilepath.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)BgDataImportUI.this.prmtBgScheme.getData();
                IObjectPK pk = LogUtil.beginLog(null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "bgScheme_import"), (BOSObjectType)_bgSchemeInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(_bgSchemeInfo.getId()), (String)(_bgSchemeInfo.getNumber() + " - " + _bgSchemeInfo.getName()), (String)"bgScheme_import");
                msgre = 1;
                int importType = 0;
                if (BgDataImportUI.this.rbBudget.isSelected()) {
                    importType = 0;
                } else if (BgDataImportUI.this.rbAdjust.isSelected()) {
                    importType = 1;
                } else if (BgDataImportUI.this.rbActual.isSelected()) {
                    importType = 2;
                } else if (BgDataImportUI.this.rbAddActual.isSelected()) {
                    importType = 3;
                }
                Map result = null;
                try {
                    result = BgDataImportUI.this.importFile(BgDataImportUI.this.txtFilepath.getText(), _bgSchemeInfo, importType);
                }
                catch (Exception ex) {
                    BgDataImportUI.this.handUIExceptionAndAbort(ex);
                }
                if (result != null) {
                    result.put("IMPORT_TYPE", new Integer(importType));
                }
                LogUtil.afterLog(null, (IObjectPK)pk);
                return result;
            }

            public void afterExec(Object result) throws Exception {
                if (result != null && result instanceof Map) {
                    BgDataImportUI.this.openImportResultViewUI(result);
                }
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    protected void openImportResultViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.openImportResultModel()).create(BgImportResultUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected String openImportResultModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void btnSelectFilepath_actionPerformed(ActionEvent e) throws Exception {
        String path = this.txtFilepath.getText();
        KDFileChooser fc = new KDFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "import"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.setCurrentDirectory(new File(path));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            FileFilter fileFilter = fc.getFileFilter();
            this.txtFilepath.setText(file.getPath());
            if (fileFilter instanceof ExcelFileFilter) {
                this.fileFormat = ".xls";
            }
            if (fileFilter instanceof Excel2007FileFilter) {
                this.fileFormat = ".xlsx";
            }
        }
    }

    protected void initDataInfo() throws Exception {
        this.initBgSchemeInfo();
        this.initFilepath();
    }

    protected void initBgSchemeInfo() throws Exception {
        this.prmtBgScheme.setEnabled(false);
        Object obj = this.getUIContext().get("BGSCHEME_INFO");
        if (obj != null && obj instanceof BgSchemeInfo) {
            this.prmtBgScheme.setData(obj);
        }
    }

    protected void initFilepath() throws Exception {
        this.txtFilepath.setEditable(true);
    }

    protected void verifyInput() throws Exception {
        if (this.prmtBgScheme.getData() == null || !(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectInBgScheme"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtFilepath.getText())) {
            this.txtFilepath.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectInFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtFilepath.getText());
            if (!file.isDirectory()) {
                this.txtFilepath.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    protected IPermission getPermissionInterface() throws Exception {
        if (this.iPermission == null) {
            this.iPermission = PermissionFactory.getRemoteInstance();
        }
        return this.iPermission;
    }

    protected IBgScheme getBgSchemeInterface() throws Exception {
        if (this.ibgScheme == null) {
            this.ibgScheme = BgSchemeFactory.getRemoteInstance();
        }
        return this.ibgScheme;
    }

    protected IBgSchemeNode getBgSchemeNodeInterface() throws Exception {
        if (this.ibgSchemeNode == null) {
            this.ibgSchemeNode = BgSchemeNodeFactory.getRemoteInstance();
        }
        return this.ibgSchemeNode;
    }

    protected IBgTemplate getBgTemplateInterface() throws Exception {
        if (this.ibgTemplate == null) {
            this.ibgTemplate = BgTemplateFactory.getRemoteInstance();
        }
        return this.ibgTemplate;
    }

    protected IFullOrgUnit getFullOrgUnitInterface() throws Exception {
        if (this.ifullOrgUnit == null) {
            this.ifullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        }
        return this.ifullOrgUnit;
    }

    protected INewOrgViewFacade getOrgFacadeInterface() throws Exception {
        if (this.iNewOrgFacade == null) {
            this.iNewOrgFacade = NewOrgViewFacadeFactory.getRemoteInstance();
        }
        return this.iNewOrgFacade;
    }

    protected IBgForm getBgFormInterface() throws Exception {
        if (this.ibgForm == null) {
            this.ibgForm = BgFormFactory.getRemoteInstance();
        }
        return this.ibgForm;
    }

    protected IBgFormFacade getFacadeInterface() throws Exception {
        if (this.ibgFormFacade == null) {
            this.ibgFormFacade = BgFormFacadeFactory.getRemoteInstance();
        }
        return this.ibgFormFacade;
    }

    protected IBgPeriod getBgPeriodInterface() throws Exception {
        if (this.ibgPeriod == null) {
            this.ibgPeriod = BgPeriodFactory.getRemoteInstance();
        }
        return this.ibgPeriod;
    }

    protected ICurrency getCurrencyInterface() throws Exception {
        if (this.iCurrency == null) {
            this.iCurrency = CurrencyFactory.getRemoteInstance();
        }
        return this.iCurrency;
    }

    protected IBgActualRecord getBgActualInterface() throws Exception {
        if (this.ibgActualRecord == null) {
            this.ibgActualRecord = BgActualRecordFactory.getRemoteInstance();
        }
        return this.ibgActualRecord;
    }

    public Map importFile(String filepath, BgSchemeInfo bgSchemeInfo, int importType) throws Exception {
        HashSet<BOSUuid> orgRangesSet = new HashSet<BOSUuid>();
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>();
        HashMap dataMap = new HashMap();
        ArrayList orgUnitList = new ArrayList();
        HashMap imOrgUnitMap = new HashMap();
        HashMap imOrgFileMap = new HashMap();
        UserInfo userInfo = null;
        BgSchemeInfo _bgSchemeInfo = null;
        FullOrgUnitCollection orgRangesColl = null;
        TreeModel model = null;
        DefaultKingdeeTreeNode root = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("rootId");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        resultMap.put("IMPORT_ORGUNIT_LIST", orgUnitList);
        resultMap.put("IMPORT_ORGUNIT_INFO", imOrgUnitMap);
        resultMap.put("IMPORT_ORGUNIT_FILES", imOrgFileMap);
        _bgSchemeInfo = this.getBgSchemeInterface().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeInfo.getId()), sic);
        userInfo = SysContext.getSysContext().getCurrentUserInfo();
        model = BgNFSHelper.getOrgTreeModel(_bgSchemeInfo.getOrgUnit().getId().toString(), null);
        root = (DefaultKingdeeTreeNode)model.getRoot();
        orgRangesColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()));
        for (int i = 0; i < orgRangesColl.size(); ++i) {
            orgRangesSet.add(orgRangesColl.get(i).getId());
        }
        this.importOrgUnitFile(root, filepath, _bgSchemeInfo, orgRangesSet, importType, resultMap, dataMap);
        return resultMap;
    }

    private void importOrgUnitFile(DefaultKingdeeTreeNode node, String filepath, BgSchemeInfo bgSchemeInfo, Set orgRangeSet, int importType, Map resultMap, Map dataMap) throws Exception {
        OrgStructureInfo oui;
        FullOrgUnitInfo orgUnitInfo = null;
        FullOrgUnitInfo _tmpOrgUnitInfo = null;
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null) {
            orgUnitInfo = oui.getUnit();
            if (StringUtils.isEmpty((String)orgUnitInfo.getName())) {
                return;
            }
            if (orgRangeSet.contains(orgUnitInfo.getId())) {
                File _file = null;
                File _tmpFile2 = null;
                File[] _files = null;
                _file = new File(filepath);
                if (_file.exists() && _file.isDirectory()) {
                    for (File _tmpFile2 : _file.listFiles()) {
                        if (_tmpFile2 == null || !_tmpFile2.isDirectory() || !_tmpFile2.getName().equalsIgnoreCase(orgUnitInfo.getName().trim())) continue;
                        if (orgUnitInfo.getCU() == null) {
                            _tmpOrgUnitInfo = this.getFullOrgUnitInterface().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getOrgUnitCUIdSelector());
                            orgUnitInfo.setCU(_tmpOrgUnitInfo.getCU());
                        }
                        String _tmpFilepath = filepath + "/" + orgUnitInfo.getName().trim();
                        this.importExcelFile(_tmpFilepath, orgUnitInfo, bgSchemeInfo, importType, resultMap, dataMap);
                        for (int i = 0; i < node.getChildCount(); ++i) {
                            DefaultKingdeeTreeNode _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                            this.importOrgUnitFile(_node, _tmpFilepath, bgSchemeInfo, orgRangeSet, importType, resultMap, dataMap);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importExcelFile(String filepath, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, int importType, Map resultMap, Map dataMap) {
        File _file = null;
        File _tmpFile2 = null;
        File[] _files = null;
        List orgUnitList = (List)resultMap.get("IMPORT_ORGUNIT_LIST");
        Map imOrgUnitMap = (Map)resultMap.get("IMPORT_ORGUNIT_INFO");
        Map imOrgFileMap = (Map)resultMap.get("IMPORT_ORGUNIT_FILES");
        HashMap imFileResultMap = new HashMap();
        ArrayList<String> imFileName = new ArrayList<String>();
        ArrayList<String> imFileResult = new ArrayList<String>();
        imFileResultMap.put("IMPORT_FILES_NAME", imFileName);
        imFileResultMap.put("IMPORT_FILES_RESULT", imFileResult);
        String _orgUnitId = orgUnitInfo.getId().toString();
        String _succeed = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "import_succeed");
        orgUnitList.add(_orgUnitId);
        imOrgUnitMap.put(_orgUnitId, orgUnitInfo.getName());
        imOrgFileMap.put(_orgUnitId, imFileResultMap);
        _file = new File(filepath);
        if (_file.exists() && _file.isDirectory()) {
            for (File _tmpFile2 : _file.listFiles()) {
                if (_tmpFile2 == null || !_tmpFile2.isFile() || !this.checkFilename(_tmpFile2, bgSchemeInfo)) continue;
                imFileName.add(_tmpFile2.getName());
                try {
                    switch (importType) {
                        case 0: {
                            this.importBudgetFile(_tmpFile2, orgUnitInfo, bgSchemeInfo, resultMap, dataMap);
                            break;
                        }
                        case 1: {
                            this.importAdjustFile(_tmpFile2, orgUnitInfo, bgSchemeInfo, resultMap, dataMap);
                            break;
                        }
                        case 2: {
                            this.importActualFile(_tmpFile2, orgUnitInfo, bgSchemeInfo, resultMap, dataMap);
                            break;
                        }
                        case 3: {
                            this.importAddActualFile(_tmpFile2, orgUnitInfo, bgSchemeInfo, resultMap, dataMap);
                            break;
                        }
                    }
                    imFileResult.add(_succeed);
                }
                catch (Exception ex) {
                    imFileResult.add(ex.getMessage());
                    logger.error((Object)ex);
                }
            }
        }
    }

    private void importBudgetFile(File file, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, Map resultMap, Map dataMap) throws Exception {
        if (file == null) {
            return;
        }
        BgFormInfo _bgFormInfo = (BgFormInfo)this.parseFilename(file, orgUnitInfo, dataMap, 0);
        this.importFormExcelFile(file, _bgFormInfo, true);
        BgNFSHelper.setBudget((IObjectValue)_bgFormInfo);
        this.getBgFormInterface().save((CoreBaseInfo)_bgFormInfo);
    }

    private void importAdjustFile(File file, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, Map resultMap, Map dataMap) throws Exception {
        if (file == null) {
            return;
        }
        BgFormInfo _bgFormInfo = (BgFormInfo)this.parseFilename(file, orgUnitInfo, dataMap, 1);
        this.importFormExcelFile(file, _bgFormInfo, true);
        BgNFSHelper.setBudget((IObjectValue)_bgFormInfo);
        this.getBgFormInterface().save((CoreBaseInfo)_bgFormInfo);
    }

    private void importActualFile(File file, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, Map resultMap, Map dataMap) throws Exception {
        if (file == null) {
            return;
        }
        BgFormInfo _bgFormInfo = (BgFormInfo)this.parseFilename(file, orgUnitInfo, dataMap, 2);
        this.importFormExcelFile(file, _bgFormInfo, false);
        BgNFSHelper.setBudget((IObjectValue)_bgFormInfo);
        this.getBgFormInterface().save((CoreBaseInfo)_bgFormInfo);
    }

    private void importAddActualFile(File file, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, Map resultMap, Map dataMap) throws Exception {
        if (file == null) {
            return;
        }
        BgActualRecordInfo _recordInfo = (BgActualRecordInfo)this.parseFilename(file, orgUnitInfo, dataMap, 3);
        this.importFormExcelFile(file, _recordInfo);
        this.getBgActualInterface().save((CoreBaseInfo)_recordInfo);
    }

    private boolean checkFilename(File file, BgSchemeInfo bgSchemeInfo) {
        if (file == null || bgSchemeInfo == null || StringUtils.isEmpty((String)file.getName())) {
            return false;
        }
        String _filename = file.getName();
        String[] _parameter = _filename.split("_");
        int _length = _filename.length();
        if (!_filename.substring(_length - 5).equalsIgnoreCase(this.fileFormat)) {
            return false;
        }
        if (_parameter == null || _parameter.length != 5) {
            return false;
        }
        return _parameter[1].equals(bgSchemeInfo.getName().trim());
    }

    private IObjectValue parseFilename(File file, FullOrgUnitInfo orgUnitInfo, Map dataMap, int type) throws Exception {
        BgSchemeInfo _bgSchemeInfo = null;
        BgTemplateInfo _bgTemplateInfo = null;
        Object _bgFormInfo = null;
        BgPeriodInfo _bgPeriodInfo = null;
        CurrencyInfo _currencyInfo = null;
        Map<String, BgSchemeInfo> bgSchemeMap = null;
        Map<String, BgTemplateInfo> bgTemplateMap = null;
        Map<String, BgPeriodInfo> bgPeriodMap = null;
        Map<String, CurrencyInfo> currencyMap = null;
        String key = null;
        String _orgUnitName = null;
        String[] parameter = null;
        if (dataMap.containsKey("SCHEME")) {
            bgSchemeMap = (Map)dataMap.get("SCHEME");
        } else {
            bgSchemeMap = new HashMap();
            dataMap.put("SCHEME", bgSchemeMap);
        }
        if (dataMap.containsKey("TEMPLATE")) {
            bgTemplateMap = (Map)dataMap.get("TEMPLATE");
        } else {
            bgTemplateMap = new HashMap();
            dataMap.put("TEMPLATE", bgTemplateMap);
        }
        if (dataMap.containsKey("PERIOD")) {
            bgPeriodMap = (Map)dataMap.get("PERIOD");
        } else {
            bgPeriodMap = new HashMap();
            dataMap.put("PERIOD", bgPeriodMap);
        }
        if (dataMap.containsKey("CURRENCY")) {
            currencyMap = (Map)dataMap.get("CURRENCY");
        } else {
            currencyMap = new HashMap();
            dataMap.put("CURRENCY", currencyMap);
        }
        parameter = this.fileFormat.equals(".xls") ? file.getName().replaceAll(".xls", "").split("_") : file.getName().replaceAll(".xlsx", "").split("_");
        if (StringUtils.isEmpty((String)parameter[0]) || StringUtils.isEmpty((String)parameter[1]) || StringUtils.isEmpty((String)parameter[2]) || StringUtils.isEmpty((String)parameter[3]) || StringUtils.isEmpty((String)parameter[4])) {
            throw new BgIEException(BgIEException.ERRORFILENAME, new String[]{file.getName()});
        }
        _orgUnitName = orgUnitInfo.getName().trim();
        key = parameter[0];
        if (!key.trim().equals(_orgUnitName)) {
            throw new BgIEException(BgIEException.ERRORORGUNIT, new String[]{parameter[0]});
        }
        key = orgUnitInfo.getId().toString() + "_" + parameter[1];
        if (bgSchemeMap.containsKey(key)) {
            _bgSchemeInfo = (BgSchemeInfo)bgSchemeMap.get(key);
        } else {
            _bgSchemeInfo = this.getBgSchemeInfo(orgUnitInfo.getId().toString(), parameter[1]);
            if (_bgSchemeInfo != null) {
                bgSchemeMap.put(key, _bgSchemeInfo);
            }
        }
        if (_bgSchemeInfo == null) {
            throw new BgIEException(BgIEException.ERRORBGSCHEME, new String[]{_orgUnitName, parameter[1]});
        }
        key = _bgSchemeInfo.getId().toString() + "_" + parameter[2];
        if (bgTemplateMap.containsKey(key)) {
            _bgTemplateInfo = (BgTemplateInfo)bgTemplateMap.get(key);
        } else {
            _bgTemplateInfo = this.getBgTemplateInfo(orgUnitInfo.getId().toString(), _bgSchemeInfo.getId().toString(), parameter[2]);
            if (_bgTemplateInfo != null) {
                bgTemplateMap.put(key, _bgTemplateInfo);
            }
        }
        if (_bgTemplateInfo == null) {
            throw new BgIEException(BgIEException.ERRORBGTEMPLATE, new String[]{_orgUnitName, _bgSchemeInfo.getName(), parameter[2]});
        }
        if (bgPeriodMap.containsKey(parameter[3])) {
            _bgPeriodInfo = (BgPeriodInfo)bgPeriodMap.get(parameter[3]);
        } else {
            _bgPeriodInfo = this.getPeriodInfo(parameter[3]);
            if (_bgPeriodInfo != null) {
                bgPeriodMap.put(parameter[3], _bgPeriodInfo);
            }
        }
        if (_bgPeriodInfo == null) {
            throw new BgIEException(BgIEException.ERRORBGPERIOD, new String[]{parameter[3]});
        }
        if (currencyMap.containsKey(parameter[4])) {
            _currencyInfo = (CurrencyInfo)currencyMap.get(parameter[4]);
        } else {
            _currencyInfo = this.getCurrencyInfo(parameter[4]);
            if (_currencyInfo != null) {
                currencyMap.put(parameter[4], _currencyInfo);
            }
        }
        if (_currencyInfo == null) {
            throw new BgIEException(BgIEException.ERRORCURRENCY, new String[]{parameter[3]});
        }
        _bgFormInfo = this.existForm(orgUnitInfo.getId().toString(), _bgSchemeInfo.getId().toString(), _bgTemplateInfo.getId().toString(), _bgPeriodInfo.getId().toString(), type);
        if (_bgFormInfo != null) {
            BgClientHelper.isMutex_throwException((String)_bgFormInfo.getId().toString(), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            if (type == 0 || type == 2) {
                if (msgre == 1) {
                    msgre = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"question"));
                }
                if (msgre == 2) {
                    throw new BgIEException(BgIEException.NOUPDATE);
                }
                _bgFormInfo = _bgFormInfo.getState().getValue() == 1 ? this.getBgFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(_bgFormInfo.getId()), BgNFSHelper.getSelectors()) : null;
            } else if (type == 1) {
                if (_bgFormInfo.getState().getValue() == 2) {
                    BgFormInfo _tmpBgFormInfo = this.existAdjustForm(_bgFormInfo.getId().toString());
                    if (_tmpBgFormInfo == null) {
                        if (!this.getPermissionInterface().hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), "bg_formAdjust02_formAdjust")) {
                            throw new BgIEException(BgIEException.NOPERMISSIONADJUST);
                        }
                        IObjectPK pk = this.getFacadeInterface().clone(_bgFormInfo.getId(), BgFormDataSourceEnum.ADJUST, BgFormStateEnum.Adjusted);
                        _bgFormInfo = this.getBgFormInterface().getBgFormInfo(pk, BgNFSHelper.getSelectors());
                    } else {
                        if (msgre == 1) {
                            msgre = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"question"));
                        }
                        if (msgre == 2) {
                            throw new BgIEException(BgIEException.NOUPDATE);
                        }
                        _bgFormInfo = this.getBgFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(_tmpBgFormInfo.getId()), BgNFSHelper.getSelectors());
                    }
                } else {
                    _bgFormInfo = null;
                }
            } else if (type == 3) {
                if (_bgFormInfo.getState().getValue() == 2) {
                    _bgFormInfo = this.getBgFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(_bgFormInfo.getId()), BgNFSHelper.getSelectors());
                    BgActualRecordInfo _recordInfo = this.existAddForm((BgFormInfo)_bgFormInfo);
                    if (_recordInfo == null) {
                        if (!this.getPermissionInterface().hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), "bg_actralRecord_addNew")) {
                            throw new BgIEException(BgIEException.NOPERMISSIONADDSHEET);
                        }
                        _recordInfo = this.createNewActualRecordInfo((BgFormInfo)_bgFormInfo);
                    } else if (_recordInfo.getState().getValue() != 1) {
                        throw new BgIEException(BgIEException.ERRORADDACTUALSTATE);
                    }
                    if (msgre == 1) {
                        msgre = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"question"));
                    }
                    if (msgre == 2) {
                        throw new BgIEException(BgIEException.NOUPDATE);
                    }
                    return _recordInfo;
                }
                _bgFormInfo = null;
            }
        } else if (type == 0 || type == 2) {
            if (!this.getPermissionInterface().hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), "bg_form02_addNew")) {
                throw new BgIEException(BgIEException.NOPERMISSIONBGFORM);
            }
            _bgFormInfo = this.createNewFormInfo(orgUnitInfo, _bgSchemeInfo, _bgTemplateInfo, _bgPeriodInfo, _currencyInfo);
        } else {
            _bgFormInfo = null;
        }
        if (_bgFormInfo == null) {
            throw new BgIEException(BgIEException.ERRORBGFORM);
        }
        return _bgFormInfo;
    }

    private SelectorItemCollection getOrgUnitCUIdSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("CU.id");
        sic.add("CU.name");
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgSchemeInfo getBgSchemeInfo(String orgUnitId, String bgSchemeName) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)bgSchemeName, CompareType.EQUALS));
        view.setFilter(filter);
        BgSchemeInfo _bgSchemeInfo = null;
        BgSchemeCollection _bgSchemeCol = null;
        try {
            _bgSchemeCol = this.getBgSchemeInterface().getBgSchemeCollection(view);
            if (_bgSchemeCol != null && !_bgSchemeCol.isEmpty()) {
                _bgSchemeInfo = _bgSchemeCol.get(0);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return _bgSchemeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgTemplateInfo getBgTemplateInfo(String orgUnitId, String bgSchemeId, String bgTemplateName) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        view.setFilter(filter);
        BgSchemeNodeInfo _bgSchemeNodeInfo = null;
        BgSchemeNodeCollection _bgSchemeNodeCol = null;
        BgTemplateInfo _bgTemplateInfo = null;
        BgTemplateCollection _bgTemplateCol = null;
        HashSet<String> bgTemplateIdSet = new HashSet<String>();
        try {
            _bgSchemeNodeCol = this.getBgSchemeNodeInterface().getBgSchemeNodeCollection(view);
            if (_bgSchemeNodeCol != null && !_bgSchemeNodeCol.isEmpty()) {
                int in = _bgSchemeNodeCol.size();
                for (int i = 0; i < in; ++i) {
                    _bgSchemeNodeInfo = _bgSchemeNodeCol.get(i);
                    bgTemplateIdSet.add(_bgSchemeNodeInfo.getBgTemplate().getId().toString());
                }
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", bgTemplateIdSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)bgTemplateName, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
                view.setFilter(filter);
                view.getSelector().addObjectCollection((IObjectCollection)this.getTemplateIdSelector());
                _bgTemplateCol = this.getBgTemplateInterface().getBgTemplateCollection(view);
                if (_bgTemplateCol != null && !_bgTemplateCol.isEmpty()) {
                    _bgTemplateInfo = _bgTemplateCol.get(0);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return _bgTemplateInfo;
    }

    private SelectorItemCollection getTemplateIdSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        return sic;
    }

    private SelectorItemCollection getBgTemplateSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("data");
        sic.add("bgType.id");
        sic.add("defaultMeasureUnit.id");
        sic.add("defaultMeasureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgPeriodInfo getPeriodInfo(String bgPeriodName) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)bgPeriodName, CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo _bgPeriodInfo = null;
        BgPeriodCollection _bgPeriodCol = null;
        try {
            _bgPeriodCol = this.getBgPeriodInterface().getBgPeriodCollection(view);
            if (_bgPeriodCol != null && !_bgPeriodCol.isEmpty()) {
                _bgPeriodInfo = _bgPeriodCol.get(0);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return _bgPeriodInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CurrencyInfo getCurrencyInfo(String currencyName) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)currencyName, CompareType.EQUALS));
        view.setFilter(filter);
        CurrencyInfo _currencyInfo = null;
        CurrencyCollection _currencyCol = null;
        try {
            _currencyCol = this.getCurrencyInterface().getCurrencyCollection(view);
            if (_currencyCol != null && !_currencyCol.isEmpty()) {
                _currencyInfo = _currencyCol.get(0);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return _currencyInfo;
    }

    private BgFormInfo existForm(String orgUnitId, String bgSchemeId, String bgTemplateId, String bgPeriodId, int type) throws Exception {
        BgFormInfo _result;
        block6: {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.id", (Object)bgTemplateId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgPeriodId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(15), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(5), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(4), CompareType.NOTEQUALS));
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getBgFormSelector());
            _result = null;
            BgFormInfo _tmpFormInfo2 = null;
            BgFormCollection _bgFormCol = null;
            _bgFormCol = this.getBgFormInterface().getBgFormCollection(view);
            if (_bgFormCol == null || _bgFormCol.isEmpty()) break block6;
            if (_bgFormCol.size() == 1) {
                _result = _bgFormCol.get(0);
                break block6;
            }
            for (BgFormInfo _tmpFormInfo2 : _bgFormCol) {
                if (_tmpFormInfo2.getState().getValue() != 2) continue;
                _result = _tmpFormInfo2;
                break;
            }
        }
        return _result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgFormInfo existAdjustForm(String bgFormId) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adjust.id", (Object)bgFormId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(4), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getBgFormSelector());
        BgFormInfo result = null;
        BgFormCollection _bgFormCol = null;
        try {
            _bgFormCol = this.getBgFormInterface().getBgFormCollection(view);
            if (_bgFormCol != null && !_bgFormCol.isEmpty()) {
                result = _bgFormCol.get(0);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgActualRecordInfo existAddForm(BgFormInfo bgFormInfo) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgForm.id", (Object)bgFormInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.number", (Object)bgFormInfo.getBgPeriod().getNumber(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("data");
        sic.add("measureUnit.*");
        sic.add("bgForm.measureUnit.*");
        sic.add("bgForm.bgMeasureUnit.*");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        BgActualRecordInfo _result = null;
        BgActualRecordCollection _bgAddFormCol = null;
        try {
            _bgAddFormCol = this.getBgActualInterface().getBgActualRecordCollection(view);
            if (_bgAddFormCol != null && !_bgAddFormCol.isEmpty()) {
                _result = _bgAddFormCol.get(0);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return _result;
    }

    private SelectorItemCollection getBgFormSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        return sic;
    }

    private BgFormInfo createNewFormInfo(FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, BgTemplateInfo bgTemplateInfo, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo) throws Exception {
        boolean hasCodeShowOfAddNew;
        BgFormInfo bgFormInfo = new BgFormInfo();
        bgFormInfo.setId(BOSUuid.create((BOSObjectType)bgFormInfo.getBOSType()));
        bgFormInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        bgFormInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bgFormInfo.setStartDate(new Date());
        bgFormInfo.setEndDate(bgFormInfo.getStartDate());
        bgFormInfo.setState(BgFormStateEnum.Edited);
        bgFormInfo.setDataSource(BgFormDataSourceEnum.CURRENTWORKOUT);
        bgFormInfo.setAdjust(bgFormInfo);
        bgFormInfo.setVersionNo(BgConstants.ONE);
        bgFormInfo.setOrgUnit(orgUnitInfo);
        bgFormInfo.setCU(orgUnitInfo.getCU());
        try {
            CompanyOrgUnitInfo companyInfo = this.getCompanyByOrgUnit((OrgUnitInfo)bgFormInfo.getOrgUnit());
            if (companyInfo != null) {
                bgFormInfo.setCompany(companyInfo);
            } else {
                bgFormInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            }
        }
        catch (Exception ex) {
            bgFormInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            logger.error((Object)ex);
        }
        String CUID = bgFormInfo.getCU().getId().toString();
        boolean hasCodeNumber = BgNFSHelper.hasNumber(CUID, (IObjectValue)bgFormInfo, null);
        if (hasCodeNumber && (hasCodeShowOfAddNew = BgNFSHelper.hasDisplayNumber(CUID, (IObjectValue)bgFormInfo, null))) {
            BgNFSHelper.setNumber(CUID, (IObjectValue)bgFormInfo);
        }
        bgFormInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        bgFormInfo.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        bgFormInfo.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
        bgFormInfo.setBgScheme(bgSchemeInfo);
        bgFormInfo.setBgTemplate(bgTemplateInfo);
        bgFormInfo.setBgPeriod(bgPeriodInfo);
        bgFormInfo.setCurrency(currencyInfo);
        String bgFormName = null;
        bgFormName = bgFormInfo.getCU().getId().equals((Object)orgUnitInfo.getId()) ? bgFormInfo.getCU().getName() + "_" + bgPeriodInfo.getName() + "_" + bgTemplateInfo.getName() : bgFormInfo.getCU().getName() + "_" + orgUnitInfo.getName() + "_" + bgPeriodInfo.getName() + "_" + bgTemplateInfo.getName();
        bgFormInfo.setName(bgFormName.length() > 80 ? bgFormName.substring(1, 80) : bgFormName);
        bgFormInfo.setStartDate(new Date());
        bgFormInfo.setEndDate(bgFormInfo.getStartDate());
        ObjectUuidPK pk = null;
        BgTemplateInfo _bgTemplateInfo = null;
        pk = new ObjectUuidPK(bgFormInfo.getBgTemplate().getId());
        _bgTemplateInfo = this.getBgTemplateInterface().getBgTemplateInfo((IObjectPK)pk, this.getBgTemplateSelector());
        bgFormInfo.setZipData(_bgTemplateInfo.getZipData());
        bgFormInfo.setBgType(_bgTemplateInfo.getBgType());
        bgFormInfo.setMeasureUnit(_bgTemplateInfo.getDefaultMeasureUnit());
        if (_bgTemplateInfo.getBgMeasureUnit() != null && !_bgTemplateInfo.getBgMeasureUnit().isEmpty()) {
            BgMeasureUnitInfo bgMeasureUnit = null;
            BgTemMeasureUnitInfo bgTemInfo2 = null;
            BgTemMeasureUnitCollection bgTemCol = _bgTemplateInfo.getBgMeasureUnit();
            for (BgTemMeasureUnitInfo bgTemInfo2 : bgTemCol) {
                bgMeasureUnit = new BgMeasureUnitInfo();
                bgMeasureUnit.setBgForm(bgFormInfo);
                bgMeasureUnit.setBgElement(bgTemInfo2.getBgElement());
                bgMeasureUnit.setMeasureUnit(bgTemInfo2.getMeasureUnit());
                bgFormInfo.getBgMeasureUnit().add(bgMeasureUnit);
            }
        }
        this.dealAddNewBook(bgFormInfo);
        return bgFormInfo;
    }

    private CompanyOrgUnitInfo getCompanyByOrgUnit(OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return (CompanyOrgUnitInfo)orgUnitInfo.cast(CompanyOrgUnitInfo.class);
        }
        OrgUnitInfo parent = this.getOrgFacadeInterface().getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(parent);
        }
        return null;
    }

    private void dealAddNewBook(BgFormInfo bgFormInfo) throws Exception {
        if (bgFormInfo == null) {
            return;
        }
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String _formulaStr = null;
        String _tmpformulaStr = null;
        _book = bgFormInfo.getBook();
        BgNFSHelper.disableUndo(_book);
        BgNFSHelper.disableCal(_book);
        String companyNumber = BgNExpressionHelper.getCompanyNumber(null, (IObjectValue)bgFormInfo);
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = _book.getSheet(sheetIndex);
            BgNFSHelper.replaceSheetSign(_sheet);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                        _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                        if (!_formulaStr.equals(_tmpformulaStr = BgNFSHelper.checkFormula(null, _formulaStr, (IObjectValue)bgFormInfo))) {
                            BgNFSHelper.setFormulaOfCell(_cell, _tmpformulaStr);
                            _formulaStr = _tmpformulaStr;
                        }
                        BgNFSHelper.setFormulaEditOfDisable(_cell);
                        BgNFSHelper.setValue(_cell, BgNConstants.ZERO);
                        BgNFSHelper.setBudgetValue(_cell, BgNConstants.ZERO);
                        BgNFSHelper.setActualValue(_cell, BgNConstants.ZERO);
                    }
                    BgNFSHelper.checkExpressions(_cell, (IObjectValue)bgFormInfo, 0, companyNumber);
                    if (!BgNFSHelper.checkHasBgItemInfo(_cell) && !BgNFSHelper.checkHasBgPeriodInfo(_cell) && !BgNFSHelper.checkHasBgElementInfo(_cell) && !BgNFSHelper.checkHasCurrencyInfo(_cell) && !BgNFSHelper.checkHasLinked(_cell)) continue;
                    BgNFSHelper.setNumberFormat(_cell, "@");
                }
            }
        }
        BgNFSHelper.checkBookSign(_book);
        bgFormInfo.setBook(_book);
    }

    private BgActualRecordInfo createNewActualRecordInfo(BgFormInfo bgFormInfo) throws Exception {
        BgActualRecordInfo bgActualRecordInfo = new BgActualRecordInfo();
        bgActualRecordInfo.setId(BOSUuid.create((BOSObjectType)bgActualRecordInfo.getBOSType()));
        bgActualRecordInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        bgActualRecordInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bgActualRecordInfo.setBgForm(bgFormInfo);
        bgActualRecordInfo.setZipData(bgFormInfo.getZipData());
        bgActualRecordInfo.setBgPeriod(bgFormInfo.getBgPeriod());
        bgActualRecordInfo.setMeasureUnit(bgFormInfo.getMeasureUnit());
        bgActualRecordInfo.setCU(bgFormInfo.getCU());
        bgActualRecordInfo.setState(BgActualRecordStateEnum.Edited);
        try {
            CompanyOrgUnitInfo companyInfo = this.getCompanyByOrgUnit((OrgUnitInfo)bgFormInfo.getOrgUnit());
            if (companyInfo != null) {
                bgActualRecordInfo.setCompany(companyInfo);
            } else {
                bgActualRecordInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            }
        }
        catch (Exception ex) {
            bgActualRecordInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            logger.error((Object)ex);
        }
        String number = BgCodeNumberCHelper.getNumberCodeRule((IObjectValue)bgActualRecordInfo, bgActualRecordInfo.getCompany().getId().toString(), "sourceType", "number");
        String name = BgCodeNumberCHelper.getNumberCodeRule((IObjectValue)bgActualRecordInfo, bgActualRecordInfo.getCompany().getId().toString(), "sourceType", "name");
        if (number == null) {
            SecureRandom random = new SecureRandom();
            long randNum = random.nextLong();
            while (randNum <= 0L) {
                randNum = random.nextLong();
            }
            String randomStr = String.valueOf(randNum);
            if (randomStr.length() > 13) {
                randomStr = randomStr.substring(0, 13);
            }
            number = "Bga-" + randomStr;
        }
        if (name == null) {
            name = bgFormInfo.getName();
        }
        bgActualRecordInfo.setNumber(number);
        bgActualRecordInfo.setName(name);
        this.dealAddNewActualRecordBook(bgActualRecordInfo);
        return bgActualRecordInfo;
    }

    private void dealAddNewActualRecordBook(BgActualRecordInfo bgActualRecordInfo) throws Exception {
        if (bgActualRecordInfo == null) {
            return;
        }
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String _expression = null;
        _book = bgActualRecordInfo.getBook();
        BgNFSHelper.disableUndo(_book);
        BgNFSHelper.disableCal(_book);
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = _book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    _expression = BgNFSHelper.loadExpression(_cell, 2);
                    if (!StringUtils.isEmpty((String)_expression)) {
                        BgNFSHelper.setExpression(_cell, _expression);
                    }
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    BgNFSHelper.setValue(_cell, BgNConstants.ZERO);
                }
            }
        }
        bgActualRecordInfo.setBook(_book);
    }

    private void importFormExcelFile(File file, BgFormInfo bgFormInfo, boolean hasBudget) throws Exception {
        if (file == null || bgFormInfo == null) {
            return;
        }
        KDSBook _kdBook = null;
        KDSSheet _kdSheet = null;
        KDSCell _kdCell = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int _kdSheetIndex = 0;
        int _kdSheetSize = 0;
        int _sheetSize = 0;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String formulaStr = null;
        String userId = null;
        String[] parameter = null;
        BigDecimal _value = null;
        BigDecimal _oldValue = null;
        BigDecimal _coefficient = null;
        BigDecimal _tmpCof = null;
        HashMap<String, BigDecimal> measureMap = new HashMap<String, BigDecimal>();
        HashMap<String, BgFormDiversityData> adjustMap = null;
        BgMeasureUnitInfo muInfo2 = null;
        BgFormDiversityData divData = null;
        Date date = new Date();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        userId = user.getId().toString();
        _coefficient = bgFormInfo.getMeasureUnit().getCoefficient();
        if (bgFormInfo.getBgMeasureUnit() != null && !bgFormInfo.getBgMeasureUnit().isEmpty()) {
            for (BgMeasureUnitInfo muInfo2 : bgFormInfo.getBgMeasureUnit()) {
                measureMap.put(muInfo2.getBgElement().getNumber(), muInfo2.getMeasureUnit().getCoefficient());
            }
        }
        try {
            if (BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo)) {
                byte[] data = bgFormInfo.getAdjustMapData();
                if (data == null || data.length == 0) {
                    adjustMap = new HashMap<String, BgFormDiversityData>();
                } else {
                    InputStream is = ZipUtil.unpack((byte[])data);
                    ObjectInputStream ois = new ObjectInputStream(is);
                    adjustMap = (HashMap<String, BgFormDiversityData>)ois.readObject();
                    is.close();
                    ois.close();
                    if (adjustMap == null) {
                        adjustMap = new HashMap<String, BgFormDiversityData>();
                    }
                }
            }
            if (this.fileFormat.equals(".xls")) {
                _kdBook = POIXlsReader.parse((String)file.getPath());
            } else if (this.fileFormat.equals(".xlsx")) {
                _kdBook = new Excel2007Reader().parse(file.getPath());
            }
            if (_kdBook != null) {
                _kdSheetSize = _kdBook.getSheetCount();
            }
            if (_kdSheetSize != (_sheetSize = (_book = bgFormInfo.getBook()).getSheetCount())) {
                throw new BgIEException(BgIEException.ERRORSHEETSIZE);
            }
            if (_kdBook == null) {
                return;
            }
            for (_kdSheetIndex = 0; _kdSheetIndex < _kdSheetSize; ++_kdSheetIndex) {
                _kdSheet = _kdBook.getSheet((Object)new Integer(_kdSheetIndex));
                _sheet = _book.getSheetByName(_kdSheet.getName());
                if (_sheet == null) continue;
                if (this.fileFormat.equals(".xls")) {
                    rowCount = _kdSheet.getRowCount();
                    colCount = _kdSheet.getColumnCount();
                } else if (this.fileFormat.equals(".xlsx")) {
                    rowCount = _kdSheet.getExpandedRows() + 1;
                    colCount = _kdSheet.getExpandedColumns() + 1;
                }
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _kdCell = _kdSheet.getCell(rowIndex, colIndex, false);
                        if (_kdCell == null || _kdCell.getValue() == null) continue;
                        _cell = _sheet.getCell(rowIndex, colIndex, true);
                        _tmpCof = _coefficient;
                        if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                            formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                            parameter = BgNFSHelper.parseFormulaPara(null, formulaStr);
                            _oldValue = BgNFSHelper.getBudgetValue(_cell);
                            if (!measureMap.isEmpty() && measureMap.containsKey(parameter[2])) {
                                _tmpCof = (BigDecimal)measureMap.get(parameter[2]);
                            }
                            try {
                                _value = new BigDecimal(_kdCell.getValue().toString().trim().replaceAll(",", ""));
                                if (!BgNFSHelper.checkHasPercentage(_cell)) {
                                    _value = _value.multiply(_tmpCof);
                                }
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                            if (hasBudget) {
                                BgNFSHelper.setValue(_cell, _value);
                                BgNFSHelper.setBudgetValue(_cell, _value);
                            } else {
                                BgNFSHelper.setActualValue(_cell, _value);
                            }
                            if (adjustMap == null || _oldValue.compareTo(_value) == 0) continue;
                            if (adjustMap.containsKey(formulaStr)) {
                                divData = (BgFormDiversityData)adjustMap.get(formulaStr);
                            } else {
                                divData = new BgFormDiversityData();
                                divData.setFormula(formulaStr);
                                divData.setOldValue(_oldValue);
                                adjustMap.put(formulaStr, divData);
                            }
                            divData.setNewValue(_value);
                            divData.setAdjustor(userId);
                            divData.setAdjustTime(date);
                            BgNFSHelper.setBackGroup(_cell, BgNConstants.EDIT_COLOR);
                            continue;
                        }
                        if (BgNFSHelper.checkIsNumeric(_kdCell.getValue())) {
                            if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                                try {
                                    _value = new BigDecimal(_kdCell.getValue().toString().trim().replaceAll(",", ""));
                                    _value = _value.multiply(_tmpCof);
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                }
                                BgNFSHelper.setValue(_cell, _value);
                                continue;
                            }
                            if (StringUtils.isEmpty((String)_kdCell.getValue().toString())) continue;
                            _cell.setValue(new Variant((Object)_kdCell.getValue().toString()));
                            continue;
                        }
                        if (StringUtils.isEmpty((String)_kdCell.getValue().toString())) continue;
                        _cell.setValue(new Variant((Object)_kdCell.getValue().toString()));
                    }
                }
            }
            bgFormInfo.setBook(_book);
            if (BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo) && adjustMap != null && !adjustMap.isEmpty()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(adjustMap);
                bgFormInfo.setAdjustMapData(ZipUtil.pack((ByteArrayOutputStream)baos));
                baos.close();
                oos.close();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            _kdBook = null;
            _kdSheet = null;
            _book = null;
            _sheet = null;
        }
    }

    private void importFormExcelFile(File file, BgActualRecordInfo bgActualRecordInfo) throws Exception {
        if (file == null || bgActualRecordInfo == null) {
            return;
        }
        KDSBook _kdBook = null;
        KDSSheet _kdSheet = null;
        KDSCell _kdCell = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int _kdSheetIndex = 0;
        int _kdSheetSize = 0;
        int _sheetSize = 0;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        BigDecimal _value = null;
        BigDecimal _coefficient = null;
        _coefficient = bgActualRecordInfo.getMeasureUnit().getCoefficient();
        try {
            _kdBook = POIXlsReader.parse((String)file.getPath());
            _kdSheetSize = _kdBook.getSheetCount();
            _book = bgActualRecordInfo.getBook();
            _sheetSize = _book.getSheetCount();
            if (_kdSheetSize != _sheetSize) {
                throw new BgIEException(BgIEException.ERRORSHEETSIZE);
            }
            for (_kdSheetIndex = 0; _kdSheetIndex < _kdSheetSize; ++_kdSheetIndex) {
                _kdSheet = _kdBook.getSheet((Object)new Integer(_kdSheetIndex));
                _sheet = _book.getSheetByName(_kdSheet.getName());
                if (_sheet == null) continue;
                rowCount = _kdSheet.getRowCount();
                colCount = _kdSheet.getColumnCount();
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _kdCell = _kdSheet.getCell(rowIndex, colIndex, false);
                        if (_kdCell == null || _kdCell.getValue() == null) continue;
                        _cell = _sheet.getCell(rowIndex, colIndex, true);
                        if (StringUtils.isEmpty((String)_kdCell.getValue().toString())) continue;
                        if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                            try {
                                _value = new BigDecimal(_kdCell.getValue().toString().trim().replaceAll(",", ""));
                                _value = _value.multiply(_coefficient);
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                            BgNFSHelper.setValue(_cell, _value);
                            continue;
                        }
                        if (BgNFSHelper.checkIsNumeric(_kdCell.getValue())) {
                            if (BgNFSHelper.checkIsNumericOfCell(_cell)) {
                                try {
                                    _value = new BigDecimal(_kdCell.getValue().toString().trim().replaceAll(",", ""));
                                    _value = _value.multiply(_coefficient);
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                }
                                BgNFSHelper.setValue(_cell, _value);
                                continue;
                            }
                            if (StringUtils.isEmpty((String)_kdCell.getValue().toString())) continue;
                            _cell.setValue(new Variant((Object)_kdCell.getValue().toString()));
                            continue;
                        }
                        if (StringUtils.isEmpty((String)_kdCell.getValue().toString())) continue;
                        _cell.setValue(new Variant((Object)_kdCell.getValue().toString()));
                    }
                }
            }
            bgActualRecordInfo.setBook(_book);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            _kdBook = null;
            _kdSheet = null;
            _book = null;
            _sheet = null;
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.iPermission = null;
            this.ibgScheme = null;
            this.ibgSchemeNode = null;
            this.ibgTemplate = null;
            this.ifullOrgUnit = null;
            this.iNewOrgFacade = null;
            this.ibgForm = null;
            this.ibgFormFacade = null;
            this.ibgPeriod = null;
            this.iCurrency = null;
            this.ibgActualRecord = null;
        }
        return re;
    }

    protected boolean checkBeforeWindowClosing() {
        boolean bclose = super.checkBeforeWindowClosing();
        if (bclose && this.isRelease) {
            BgSchemeInfo obj = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
            BgClientHelper.releaseMutexService((String)obj.getId().toString());
        }
        return bclose;
    }
}

