/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgDecException;
import com.kingdee.eas.ma.budget.BgDecomposerStateEnum;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.SchemeAssignMsgObj;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.ProgressDialogUI;
import com.kingdee.eas.ma.nbudget.BgDecompActualRecordFactory;
import com.kingdee.eas.ma.nbudget.BgDecompActualRecordInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.IBgDecompActualRecord;
import com.kingdee.eas.ma.nbudget.IRefBgDecActualRecord;
import com.kingdee.eas.ma.nbudget.RefBgDecActualRecordCollection;
import com.kingdee.eas.ma.nbudget.RefBgDecActualRecordFactory;
import com.kingdee.eas.ma.nbudget.RefBgDecActualRecordInfo;
import com.kingdee.eas.ma.nbudget.client.AbstractBgDecompActualRecordAddUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgDecompActualRecordAddUI
extends AbstractBgDecompActualRecordAddUI
implements AssignSolutionInterface {
    private static final Logger logger = CoreUIObject.getLogger(BgDecompActualRecordAddUI.class);
    private String resource = "com.kingdee.eas.ma.nbudget.client.BgActualRecordDecompResource";
    private Map returnData = null;
    protected Vector orgUnits = null;
    protected Map orgUnitMap = null;
    protected Map orgIdsMap = null;
    private boolean isSubmit = true;
    private boolean isOK = true;
    private String errorStr = "";
    protected boolean isCancel = true;
    private final SchemeAssignMsgObj MSG_ORG = new SchemeAssignMsgObj("decOrg", EASResource.getString((String)this.resource, (String)"decompOrg"), 1);
    private final SchemeAssignMsgObj MSG_RESULT = new SchemeAssignMsgObj("decResult", EASResource.getString((String)this.resource, (String)"decompResult"), 1);
    private final SchemeAssignMsgObj MSG_CONTEXT = new SchemeAssignMsgObj("decContext", EASResource.getString((String)this.resource, (String)"context"), 1);
    public Vector orgs = null;

    @Override
    public void storeFields() {
        super.storeFields();
        this.orgUnitMap.clear();
        this.orgIdsMap.clear();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.orgUnitMap = new HashMap();
        this.orgIdsMap = new HashMap();
        this.initTree();
        this.initPrompt();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDisSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.checkBoxIncludeChild.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnDisSelectAll.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.btnQuit.setEnabled(true);
    }

    public void initTree() throws Exception {
        String rootUnitID = this.getCurrentCostCenterOrgUnitInfo().getId().toString();
        TreeModel treeModel = BgNFSHelper.getFullTreeModel(rootUnitID);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        root.setChecked(true);
        root.setCheckBoxEnabled(false);
        this.kDTree.setModel(treeModel);
        this.kDTree.setShowCheckBox(true);
    }

    public void initPrompt() throws BgCollectException, BOSException {
        String orgUnitId = null;
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        orgUnitId = orgUnit != null ? orgUnit.getId().toString() : "NONE_ORGUNIT_ID";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.Id", (Object)orgUnitId));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        FullOrgUnitInfo ouInfo = this.getCurrentFullOrgUnitInfoUsedInBg();
        if (ouInfo == null) {
            throw new BgCollectException(BgCollectException.CURRENTHASNOCOSTCENTER);
        }
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(ouInfo.getId().toString());
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            FilterInfo f1 = BgPermissionHelper.addBgFormPermissionFormActualRecord(user, orgSet, new FilterInfo());
            filter.mergeFilter(f1, "AND");
        }
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setFilter(filter);
        view.setSorter(sorter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bgForm.id");
        sic.add("bgForm.name");
        sic.add("bgForm.number");
        this.promptBoxActualRecord.setSelectorCollection(sic);
        this.promptBoxActualRecord.setEntityViewInfo(view);
        this.promptBoxActualRecord.setEnabled(true);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("otherCon");
        sic.add("adjustMapData");
        sic.add("kdtData");
        sic.add("orgUnit.*");
        sic.add("bgActualRecord.*");
        sic.add("refBgDecActualRecord.*");
        return sic;
    }

    protected IObjectValue createNewData() {
        BgDecompActualRecordInfo bgDecomActual = new BgDecompActualRecordInfo();
        if (this.editData == null) {
            bgDecomActual.setState(BgDecomposerStateEnum.DECOMPOSER);
            bgDecomActual.setOrgUnit(this.getCurrentFullOrgUnitInfoUsedInBg());
            return bgDecomActual;
        }
        return this.editData;
    }

    protected FullOrgUnitInfo getCurrentFullOrgUnitInfoUsedInBg() {
        CostCenterOrgUnitInfo costCenterInfo = this.getCurrentCostCenterOrgUnitInfo();
        if (costCenterInfo != null) {
            FullOrgUnitInfo ouInfo = new FullOrgUnitInfo();
            ouInfo.setId(BOSUuid.read((String)costCenterInfo.getId().toString()));
            return ouInfo;
        }
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgDecompActualRecordFactory.getRemoteInstance();
    }

    protected IBgDecompActualRecord getInterface() throws Exception {
        return BgDecompActualRecordFactory.getRemoteInstance();
    }

    protected IBgDecompActualRecord getInterfaceCast() throws Exception {
        return (IBgDecompActualRecord)this.getBizInterface();
    }

    protected CostCenterOrgUnitInfo getCurrentCostCenterOrgUnitInfo() {
        return SysContext.getSysContext().getCurrentCostUnit();
    }

    @Override
    protected void promptBoxActualRecord_dataChanged(DataChangeEvent e) throws Exception {
        this.orgUnitMap.clear();
        this.orgIdsMap.clear();
        this.setTreeIsCheck(false);
        if (this.promptBoxActualRecord.getData() instanceof BgActualRecordInfo) {
            BgActualRecordInfo bgActualRecordinfo = (BgActualRecordInfo)this.promptBoxActualRecord.getData();
            this.textFieldBgForm.setText(bgActualRecordinfo.getBgForm().getName());
            this.editData.setBgActualRecord(bgActualRecordinfo);
            this.editData.setName(bgActualRecordinfo.getName());
            this.editData.setNumber(bgActualRecordinfo.getNumber());
            this.initCostCenter(bgActualRecordinfo.getBgForm().getId());
        } else {
            this.btnConfirm.setEnabled(false);
            this.textFieldBgForm.setText("");
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setTreeIsCheck(true);
    }

    @Override
    public void actionDisSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setTreeIsCheck(false);
    }

    public void setTreeIsCheck(boolean status) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot();
        if (this.kDTree.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.kDTree.getSelectionPath().getLastPathComponent();
        }
        if (root == null) {
            return;
        }
        if (this.checkBoxIncludeChild.isSelected()) {
            Enumeration nodeEnum = root.breadthFirstEnumeration();
            DefaultKingdeeTreeNode node = null;
            while (nodeEnum.hasMoreElements()) {
                node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
                if (!this.canTheNodeBeSelected(node)) continue;
                node.setChecked(status);
            }
        } else {
            if (root != (DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot()) {
                root.setChecked(status);
            }
            DefaultKingdeeTreeNode node = null;
            for (int i = 0; i < root.getChildCount(); ++i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (!this.canTheNodeBeSelected(node)) continue;
                node.setChecked(status);
            }
        }
        this.kDTree.repaint();
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    protected void beforeStoreFields(ActionEvent ex) {
        try {
            super.beforeStoreFields(ex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.editData.setBgActualRecord((BgActualRecordInfo)this.promptBoxActualRecord.getData());
            if (this.editData.getBgActualRecord() == null) {
                BgCollectException e = new BgCollectException(BgCollectException.HASNOBGFORMINBGCOLLECTFORM);
                this.handleException((Exception)e);
                SysUtil.abort();
            }
            if (this.promptBoxActualRecord.getData() != null) {
                BgActualRecordInfo bgActualRecordInfo = (BgActualRecordInfo)this.promptBoxActualRecord.getData();
                this.initCostCenter(bgActualRecordInfo.getBgForm().getId());
            }
            this.orgCheck((DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot());
            this.editData.getRefBgDecActualRecord().clear();
            ArrayList ouIdList = new ArrayList();
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot();
            this.traceNode(root, ouIdList);
            IRefBgDecActualRecord iRefBgDecActualRecord = RefBgDecActualRecordFactory.getRemoteInstance();
            RefBgDecActualRecordCollection refRefBgDecActualRecordCols = iRefBgDecActualRecord.loadRefBgActualDecByBgActual(this.editData.getBgActualRecord(), ouIdList);
            if (refRefBgDecActualRecordCols != null) {
                int count = refRefBgDecActualRecordCols.size();
                for (int i = 0; i < count; ++i) {
                    RefBgDecActualRecordInfo child = refRefBgDecActualRecordCols.get(i);
                    child.setBgDecompser(this.editData);
                }
                this.editData.getRefBgDecActualRecord().addCollection(refRefBgDecActualRecordCols);
            }
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
    }

    protected void traceNode(DefaultKingdeeTreeNode root, List orgUnitList) {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                orgUnitList.add(orgUnitInfo.getId().toString());
            }
            this.traceNode(node, orgUnitList);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getData().getId() == null) {
            this.getData().setId(BOSUuid.create((BOSObjectType)this.getData().getBOSType()));
        }
        this.checkCanSubmit();
        this.isOK = true;
        this.isSubmit = true;
        this.beforeStoreFields(e);
        this.setOrgs();
        try {
            this.addBgActualRecordToChildren();
        }
        catch (Exception e1) {
            this.isSubmit = false;
            this.setErrorStr(e1.getMessage());
            SysUtil.abort();
        }
        this.setCancel(false);
        super.actionSubmit_actionPerformed(e);
        this.orgUnitMap.clear();
        this.orgIdsMap.clear();
        BgFormHelper.refreshBgFormList((CoreUI)this);
        this.returnData = new HashMap();
        this.returnData.put("getData", this.getData());
        this.returnData.put("getOrgs", this.getOrgs());
        this.returnData.put("isCancel", new Boolean(this.isCancel()));
        this.returnData.put("isSubmit", new Boolean(this.isSubmit()));
        this.returnData.put("getErrorStr", this.getErrorStr());
        this.returnData.put("setUITitle", ((BgActualRecordInfo)this.promptBoxActualRecord.getData()).getName() + " " + ((BgActualRecordInfo)this.promptBoxActualRecord.getData()).getBgForm().getName());
        this.getInterfaceCast().addNewData(this.getDecIdsMap(this.editData));
    }

    private Map getDecIdsMap(BgDecompActualRecordInfo editData) {
        HashMap decIds = new HashMap();
        HashMap<String, Object> refIds = new HashMap<String, Object>();
        decIds.put("decId", this.getUIContext().get("ID"));
        decIds.put("mainFormId", editData.getBgActualRecord().getId().toString());
        RefBgDecActualRecordCollection coll = editData.getRefBgDecActualRecord();
        for (int i = 0; i < coll.size(); ++i) {
            refIds.put(coll.get(i).getBgActualRecord().getId().toString(), null);
        }
        decIds.put("refIds", refIds);
        return decIds;
    }

    private void addBgActualRecordToChildren() throws Exception {
        BgActualRecordInfo bgActualRecordInfo = (BgActualRecordInfo)this.promptBoxActualRecord.getData();
        UIContext map = new UIContext((Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)map);
        if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
            List errorList;
            ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
            this.initParameterValue(ui, bgActualRecordInfo);
            ui.init();
            window.show();
            if (ui.isCancel()) {
                SysUtil.abort();
            }
            if ((errorList = ui.getReturnData()) != null && errorList.size() > 0) {
                StringBuffer error = new StringBuffer();
                int size = errorList.size();
                for (int i = 0; i < size; ++i) {
                    error.append(errorList.get(i) + "\r\n");
                }
                MsgBox.showError((Component)((Object)this), (String)error.toString());
                SysUtil.abort();
            }
        }
    }

    private void initParameterValue(ProgressDialogUI ui, BgActualRecordInfo bgActualRecordInfo) {
        Class[] cla = new Class[]{String.class, String.class, Boolean.TYPE, String.class, String.class, String.class};
        ui.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"369_BgDecompActualAddNewUI"));
        ui.setInvokeClass(this.getMetaDataPK().getFullName());
        ui.setInvokeMethod("invokeMethod");
        ui.setInvokeMethodParmeterType(cla);
        ui.setShowTableMessage(true);
        Vector<Object[]> vecPrameterValue = new Vector<Object[]>();
        String value = null;
        String key2 = null;
        Object[] objOld = null;
        Object[] objNew = null;
        for (String key2 : this.orgIdsMap.keySet()) {
            value = (String)this.orgIdsMap.get(key2);
            if (objOld != null) {
                objNew = new Object[]{objOld[0], objOld[1], Boolean.TRUE, value, key2, bgActualRecordInfo.getId().toString()};
                objOld = new Object[]{value, key2, Boolean.FALSE};
            } else {
                objOld = new Object[]{value, key2, Boolean.FALSE};
                objNew = new Object[]{null, null, Boolean.FALSE, value, key2, bgActualRecordInfo.getId().toString()};
            }
            vecPrameterValue.add(objNew);
        }
        if (objOld != null) {
            objNew = new Object[]{objOld[0], objOld[1], Boolean.TRUE, value, key2, bgActualRecordInfo.getId().toString()};
            vecPrameterValue.add(objNew);
        }
        int size = vecPrameterValue.size();
        int objNewlength = objNew == null ? 0 : objNew.length;
        Object[][] valueMethod = new Object[size][objNewlength];
        for (int i = 0; i < size; ++i) {
            Object[] obj = (Object[])vecPrameterValue.get(i);
            for (int j = 0; j < objNewlength; ++j) {
                valueMethod[i][j] = obj[j];
            }
        }
        ui.setInvokeMethodParmeterValue(valueMethod);
        ui.setCountSum(vecPrameterValue.size() - 1);
    }

    public void checkCanSubmit() {
        this.orgIdsMap.clear();
        this.orgCheck((DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot());
        if (this.promptBoxActualRecord.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resource, (String)"actualNull"));
            SysUtil.abort();
            return;
        }
        if (this.textFieldBgForm.getText().trim().length() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resource, (String)"bgFormNull"));
            SysUtil.abort();
            return;
        }
        if (this.orgUnitMap.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resource, (String)"orgNoSelected"));
            SysUtil.abort();
            return;
        }
        try {
            List list = BgDecompActualRecordFactory.getRemoteInstance().checkChildOrg(this.orgIdsMap, (IObjectValue)this.editData.getBgActualRecord());
            if (list.size() != 0) {
                if (list.get(0).toString().startsWith("@", 0)) {
                    MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resource, (String)"periodRepeat"), list.get(0).toString().substring(1, list.get(0).toString().length())));
                } else {
                    MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resource, (String)"cantDecomp_one"), list.get(0)));
                }
                SysUtil.abort();
                return;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void orgMapAdd(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                OrgStructureInfo osi = (OrgStructureInfo)node.getUserObject();
                FullOrgUnitInfo orgInfo = osi.getUnit();
                this.orgUnitMap.put(orgInfo.getId().toString(), orgInfo);
            }
            if (node.isLeaf()) continue;
            this.orgMapAdd(node);
        }
    }

    protected void initCostCenter(BOSUuid bgFormId) throws Exception {
        HashMap getCollectInfo = null;
        try {
            getCollectInfo = this.getFormInterface().getFormDecomposerInfo(bgFormId, 2);
            if (getCollectInfo != null && !getCollectInfo.isEmpty()) {
                Object id = null;
                String orgUnitId2 = null;
                this.orgUnitMap.clear();
                for (String orgUnitId2 : getCollectInfo.keySet()) {
                    if (this.orgUnitMap.containsKey(orgUnitId2)) continue;
                    this.orgUnitMap.put(orgUnitId2, null);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    protected IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    private void orgCheck(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        OrgStructureInfo posi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        FullOrgUnitInfo pOrgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                BgDecException e;
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                if (!root.isChecked()) {
                    posi = (OrgStructureInfo)root.getUserObject();
                    pOrgUnitInfo = posi.getUnit();
                    e = new BgCollectException(BgCollectException.NOSELECTPARENTNODE, (Object[])new String[]{orgUnitInfo.getName(), pOrgUnitInfo.getName()});
                    this.handleException((Exception)e);
                    SysUtil.abort();
                }
                if (!this.orgUnitMap.containsKey(orgUnitInfo.getId().toString())) {
                    e = new BgDecException(BgDecException.ERRORORG, (Object[])new String[]{orgUnitInfo.getName()});
                    this.handleException((Exception)e);
                    SysUtil.abort();
                }
                this.orgIdsMap.put(orgUnitInfo.getId().toString(), orgUnitInfo.getName());
            }
            this.orgCheck(node);
        }
    }

    private void disSelectedTree(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            node.setChecked(false);
            this.disSelectedTree(subNode);
        }
    }

    public void setOrgs() {
        this.orgUnits = new Vector();
        try {
            this.orgUnits.add(((OrgStructureInfo)((DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot()).getUserObject()).getUnit());
            this.orgs((DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"errorData"));
            SysUtil.abort();
        }
    }

    protected void orgs(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                this.orgUnits.add(orgUnitInfo);
            }
            this.orgs(node);
        }
    }

    private void inputOrgUnitTraceNode(DefaultKingdeeTreeNode root, Vector orgUnit) {
        if (root == null || orgUnit == null || orgUnit.isEmpty()) {
            return;
        }
        HashMap orgIds = new HashMap();
        for (int i = 0; i < orgUnit.size(); ++i) {
            orgIds.put(((FullOrgUnitInfo)orgUnit.get(i)).getId().toString(), null);
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            osi = (OrgStructureInfo)node.getUserObject();
            orgUnitInfo = osi.getUnit();
            if (orgUnit != null && orgIds.containsKey(orgUnitInfo.getId().toString())) {
                node.setChecked(true);
            } else {
                node.setChecked(false);
            }
            this.inputOrgUnitTraceNode(node, orgUnit);
        }
    }

    public boolean cancel() throws Exception {
        return true;
    }

    public void clear() throws Exception {
        this.promptBoxActualRecord.setData(null);
        this.textFieldBgForm.setText("");
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot();
        this.disSelectedTree(root);
        root.setChecked(true);
        this.kDTree.repaint();
    }

    public void clearSolutionList() throws Exception {
    }

    public boolean conferm(Object invokeUi) throws Exception {
        ActionEvent e = new ActionEvent(this.btnConfirm, 1001, "");
        this.actionSubmit_actionPerformed(e);
        return true;
    }

    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        return null;
    }

    public String getNewConfermLabel() {
        return null;
    }

    public Map getReturnData() throws Exception {
        return this.returnData;
    }

    public void reloadSolution(Object o) throws Exception {
        try {
            HashMap loadData;
            if (o instanceof Map && (loadData = (HashMap)o) != null && loadData.size() > 0 && !this.loadDataToUI(loadData)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme"));
            }
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme"));
        }
    }

    private boolean loadDataToUI(Map loadData) throws Exception {
        this.promptBoxActualRecord.setData(null);
        this.promptBoxActualRecord.setValue(null);
        this.inputOrgUnitTraceNode((DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot(), null);
        this.kDTree.requestFocus();
        if (loadData.get("bgFormName") == null || loadData.get("bgActualRecord") == null) {
            return false;
        }
        BgActualRecordInfo bgActualRecordInfo = new BgActualRecordInfo();
        bgActualRecordInfo = (BgActualRecordInfo)loadData.get("bgActualRecord");
        this.promptBoxActualRecord.setData((Object)bgActualRecordInfo);
        this.textFieldBgForm.setText(loadData.get("bgFormName").toString());
        if (loadData.get("orgUnits") != null && ((Vector)loadData.get("orgUnits")).size() > 0) {
            this.orgs = (Vector)loadData.get("orgUnits");
            this.loadSolutionToOrg((DefaultKingdeeTreeNode)this.kDTree.getModel().getRoot());
        }
        return true;
    }

    private void loadSolutionToOrg(DefaultKingdeeTreeNode root) {
        if (this.orgs == null || root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            osi = (OrgStructureInfo)node.getUserObject();
            orgUnitInfo = osi.getUnit();
            if (this.orgs.contains(orgUnitInfo)) {
                node.setChecked(true);
            }
            if (node.isLeaf()) continue;
            this.loadSolutionToOrg(node);
        }
    }

    public Object saveSolution() throws Exception {
        if (this.promptBoxActualRecord.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgActualRecordDecompResource", (String)"selectActual"));
            SysUtil.abort();
        }
        this.setOrgs();
        HashMap<String, Object> saveData = new HashMap<String, Object>();
        saveData.put("bgFormName", this.textFieldBgForm.getText());
        saveData.put("bgActualRecord", (BgActualRecordInfo)this.promptBoxActualRecord.getData());
        saveData.put("orgUnits", this.orgUnits);
        return saveData;
    }

    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        if (uicontext.get("selfPanelUiName") != null) {
            oql.append(" and uiName='" + (String)uicontext.get("selfPanelUiName") + "' ");
        }
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    public BgDecompActualRecordInfo getData() {
        return this.editData;
    }

    private SelectorItemCollection getFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.rootId"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    public Object invokeMethod(String orgName, String orgThisId, boolean isTrueUpdate, String orgNext, String orgNextId, String bgActualId) throws Exception {
        Object[] obj;
        block8: {
            obj = new Object[3];
            try {
                boolean isAssignSuccess = true;
                String errorMsg = "";
                if (orgName == null || orgThisId == null || orgNext == null || orgNextId == null) break block8;
                if (isTrueUpdate) {
                    HashMap<SchemeAssignMsgObj, String> map;
                    block9: {
                        obj[1] = map = new HashMap<SchemeAssignMsgObj, String>();
                        map.put(this.MSG_ORG, orgName);
                        try {
                            HashMap<String, Object> orgMap = new HashMap<String, Object>();
                            orgMap.put(orgThisId, null);
                            this.getInterface().addBgActualRecordToChildren(orgMap, bgActualId);
                            isTrueUpdate = false;
                        }
                        catch (Exception e) {
                            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"370_BgDecompActualAddNewUI"), (Throwable)e);
                            isAssignSuccess = false;
                            if (!(e instanceof BgFormException)) break block9;
                            errorMsg = ((BgFormException)((Object)e)).getMessage();
                        }
                    }
                    if (isAssignSuccess) {
                        map.put(this.MSG_RESULT, EASResource.getString((String)this.resource, (String)"success"));
                    } else {
                        map.put(this.MSG_RESULT, EASResource.getString((String)this.resource, (String)"failed"));
                        map.put(this.MSG_CONTEXT, MessageFormat.format(EASResource.getString((String)this.resource, (String)"failedReson_one"), orgName));
                    }
                }
                String objTemp = MessageFormat.format(EASResource.getString((String)this.resource, (String)"extractData"), orgNext);
                obj[0] = new HashMap<String, String>().put("objTemp", objTemp);
            }
            catch (Exception exc) {
                if (Utils.isRPCException((Throwable)exc) && Utils.getRPCErrorCode((Throwable)exc) == 1002 || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                    throw new BOSException(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"374_BgCollectActualEditUI"));
                }
                throw exc;
            }
        }
        return obj;
    }

    public boolean isOK() {
        return this.isOK;
    }

    public void setOK(boolean isOK) {
        this.isOK = isOK;
    }

    public boolean isSubmit() {
        return this.isSubmit;
    }

    public void setSubmit(boolean isSubmit) {
        this.isSubmit = isSubmit;
    }

    public String getErrorStr() {
        return this.errorStr;
    }

    public void setErrorStr(String errorStr) {
        this.errorStr = errorStr;
    }

    public Vector getOrgs() {
        return this.orgUnits;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }
}

