/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgElimContext;
import com.kingdee.eas.ma.nbudget.BgElimFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgElimContextUI;
import com.kingdee.eas.ma.nbudget.client.BgElimContextManager;
import com.kingdee.eas.ma.nbudget.client.UnionCombinDataF7;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgElimContextUI
extends AbstractBgElimContextUI {
    private static final Logger logger = CoreUIObject.getLogger(BgElimContextUI.class);
    public static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    private BgElimContext ctx = BgElimContext.getInstance();
    private BgElimContextManager manager = BgElimContextManager.getInstance();
    private Map orgUnitMapping = null;

    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.ctx.isInitialized()) {
            MainFrameCallBack.addPropertyChangeListener((String)"ReLogin", (PropertyChangeListener)this.manager);
        }
        this.orgUnitMapping = BgElimFacadeFactory.getRemoteInstance().getOrgMapping(null);
        this.refresh();
        if (this.ctx.isInitialized()) {
            this.bgElimContextToUI();
        }
    }

    @Override
    protected void F7Company_willShow(SelectorEvent e) throws Exception {
        super.F7Company_willShow(e);
        if (this.listOrgBound.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"Msg_NoFindOrgBound"));
            return;
        }
    }

    @Override
    protected void promptBgScheme_willShow(SelectorEvent e) throws Exception {
        super.promptBgScheme_willShow(e);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
        OrgUnitInfo orgUnitInfo = this.getOrgUnitFromMapping(orgTreeInfo);
        if (orgUnitInfo == null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"AABBCC", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isFiling", (Object)0, CompareType.EQUALS));
        this.promptBgScheme.setEntityViewInfo(view);
    }

    @Override
    protected void listOrgBound_actionPerformed(ActionEvent e) throws Exception {
        super.listOrgBound_actionPerformed(e);
        this.refreshCompany();
        this.refreshBgScheme();
    }

    @Override
    protected void cmdOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.check()) {
            boolean isCancel = this.closeBgElimUIs();
            this.getUIWindow().close();
            if (!isCancel) {
                HashMap logDatas = new HashMap();
                this.setLogDatas(logDatas);
            }
        }
    }

    public void setLogDatas(HashMap logDatas) throws BOSException {
        logDatas.put("FItemName", "ma_budget_BgElimContext_Change");
        logDatas.put("FID", this.getID());
        logDatas.put("FUserID", this.getUserId());
        logDatas.put("FUserName", this.getUserName());
        logDatas.put("FClientIP", this.getClientIp());
        logDatas.put("FClientName", this.getClientName());
        logDatas.put("FOccurTime", new Timestamp(System.currentTimeMillis()));
        logDatas.put("FEntityAlias_L2", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"392_CSLSysContextUI"));
        logDatas.put("FEntityAlias_L3", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"393_CSLSysContextUI"));
        logDatas.put("FInstanceNo", this.getInstanceNO());
        logDatas.put("FCompanyName_L2", this.getCurrOrgUnit());
        logDatas.put("FCompanyName_L3", this.getCurrOrgUnit());
        AppLogFactory.getRemoteInstance().writeLog(logDatas);
    }

    private String getID() {
        AppLogInfo appLogInfo = new AppLogInfo();
        String id = BOSUuid.create((BOSObjectType)appLogInfo.getBOSType()).toString();
        return id;
    }

    private String getUserId() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getId().toString();
    }

    private String getUserName() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getNumber();
    }

    private String getClientIp() {
        String obj = SysContext.getSysContext().getClientIP();
        return obj == null ? "" : obj.toString();
    }

    private String getClientName() {
        String obj = SysContext.getSysContext().getClientName();
        return obj == null ? "" : obj.toString();
    }

    public String getInstanceNO() throws BOSException {
        String CurOrgBound = null;
        if (this.ctx != null && this.ctx.getCurOrgBound() != null) {
            CurOrgBound = this.ctx.getCurOrgBound().getName();
        }
        String retValue = CurOrgBound;
        return retValue;
    }

    private String getCurrOrgUnit() {
        String obj = SysContext.getSysContext().getCurrentOrgUnit().getName();
        return obj == null ? "" : obj.toString();
    }

    @Override
    protected void cmdCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private boolean check() {
        if (this.listOrgBound.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"Msg_NoFindOrgBound"));
            return false;
        }
        if (this.F7Company.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"Msg_NoFindOrgGroup"));
            return false;
        }
        return this.comboDataType.getSelectedItem() != null;
    }

    private boolean closeBgElimUIs() throws BOSException, EASBizException {
        boolean isCancel = false;
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"IsCloseBgElimUIs")) == 0) {
            this.setContext(this.ctx);
            this.manager.notifyCTXChanged();
            isCancel = false;
        } else {
            isCancel = true;
        }
        return isCancel;
    }

    private boolean isChanged() throws EASBizException, BOSException {
        if (!this.ctx.isInitialized()) {
            return true;
        }
        BgElimContext c = null;
        try {
            c = (BgElimContext)this.ctx.clone();
        }
        catch (CloneNotSupportedException e) {
            super.handUIException((Throwable)e);
        }
        this.setContext(c);
        return !this.ctx.equals(c);
    }

    private void refresh() throws EASBizException, BOSException {
        this.refreshDataType();
        this.refreshOrgBound();
        this.refreshCompany();
        this.refreshBgScheme();
        this.refreshBgPeriod();
    }

    private void refreshDataType() throws EASBizException, BOSException {
        this.comboDataType.removeAllItems();
        this.comboDataType.addItems(BgDataTypeEnum.getEnumList().toArray());
        this.comboDataType.setSelectedItem((Object)BgDataTypeEnum.BgData);
    }

    private void refreshOrgBound() throws EASBizException, BOSException {
        OrgTreeCollection ocn = BgEliminationHelper.getOrgTreeCollection();
        this.listOrgBound.removeAllItems();
        if (ocn != null) {
            this.listOrgBound.addItems(ocn.toArray());
        }
    }

    private void refreshBgPeriod() throws EASBizException, BOSException {
        BgPeriodDialog dialog = new BgPeriodDialog();
        this.promptBgPeriod.setSelector((KDPromptSelector)dialog);
        this.promptBgPeriod.setEditable(false);
    }

    private void refreshBgScheme() throws EASBizException, BOSException {
        OrgUnitInfo orgUnitInfo;
        OrgTreeInfo orgTreeInfo;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (this.listOrgBound.getSelectedItem() != null && (orgTreeInfo = (OrgTreeInfo)this.listOrgBound.getSelectedItem()) != null && orgTreeInfo.getId() != null && (orgUnitInfo = (OrgUnitInfo)BgEliminationHelper.getValueFromMap(this.orgUnitMapping, orgTreeInfo.getId().toString())) != null && orgUnitInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"AABBCC", CompareType.EQUALS));
        }
        this.promptBgScheme.setData(null);
        this.promptBgScheme.setEntityViewInfo(view);
        this.promptBgScheme.setEditable(false);
    }

    private void refreshCompany() {
        OrgTreeInfo orgTreeInfo = null;
        if (this.listOrgBound.getSelectedItem() != null) {
            this.F7Company.setValue(null);
            orgTreeInfo = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
            UnionCombinDataF7 oldf7 = (UnionCombinDataF7)this.F7Company.getSelector();
            UnionCombinDataF7 f7 = new UnionCombinDataF7((IUIObject)this, 2);
            if (oldf7 == null || !orgTreeInfo.getId().toString().equals(oldf7.getTreeID())) {
                f7.setTreeID(orgTreeInfo.getId().toString());
            } else {
                f7 = oldf7;
            }
            HashMap map = null;
            try {
                map = (HashMap)PermissionFactory.getRemoteInstance().getUnionUnits(BgEliminationHelper.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), BgEliminationHelper.getPK((IObjectValue)orgTreeInfo));
            }
            catch (EASBizException e) {
                super.handUIException((Throwable)e);
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
            this.F7Company.setSelector((KDPromptSelector)f7);
            this.F7Company.setEnabled(true);
        } else {
            this.F7Company.setValue(null);
            this.F7Company.setEnabled(false);
        }
    }

    private void setContext(BgElimContext c) throws EASBizException, BOSException {
        if (this.listOrgBound.getSelectedItem() == null || this.F7Company.getValue() == null) {
            return;
        }
        c.setCurOrgBound((OrgTreeInfo)this.listOrgBound.getSelectedItem());
        c.setCurOrgGroup(OrgClientUtils.getPromptValue((KDBizPromptBox)this.F7Company));
        c.setCurBgScheme((BgSchemeInfo)this.promptBgScheme.getData());
        c.setCurBgPeriod((BgPeriodInfo)this.promptBgPeriod.getData());
        c.setCurBgDataType((BgDataTypeEnum)this.comboDataType.getSelectedItem());
        c.setCurMappedOrgUnit(this.getOrgUnitFromMapping((OrgTreeInfo)this.listOrgBound.getSelectedItem()));
    }

    private void bgElimContextToUI() {
        try {
            this.listOrgBound.setSelectedItem((Object)this.ctx.getCurOrgBound());
            this.F7Company.setData((Object)this.ctx.getCurOrgGroup());
            this.promptBgScheme.setData((Object)this.ctx.getCurBgScheme());
            this.promptBgPeriod.setData((Object)this.ctx.getCurBgPeriod());
            this.comboDataType.setSelectedItem((Object)this.ctx.getCurBgDataType());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
    }

    private OrgUnitInfo getOrgUnitFromMapping(OrgTreeInfo orgTreeInfo) {
        if (this.orgUnitMapping == null || orgTreeInfo == null || orgTreeInfo.getId() == null) {
            return null;
        }
        OrgTreeInfo t2 = null;
        for (OrgTreeInfo t2 : this.orgUnitMapping.keySet()) {
            if (!orgTreeInfo.getId().equals((Object)t2.getId())) continue;
            return (OrgUnitInfo)this.orgUnitMapping.get(t2);
        }
        return null;
    }
}

