/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.client.AbstractBgElimOrgTreeUI;
import com.kingdee.eas.ma.nbudget.client.IBgElimContextUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgElimOrgTreeUI
extends AbstractBgElimOrgTreeUI
implements IBgElimContextUI {
    private static final Logger logger = CoreUIObject.getLogger(BgElimOrgTreeUI.class);
    IBgElimContext ctx = BgElimContextHelper.getBgElimContext();

    public void onLoad() throws Exception {
        this.btnRefresh.setText("");
        this.txtOrgTree.setEditable(false);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.kDScrollPane1.setBorder(LineBorder.createGrayLineBorder());
        if (BgElimContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            BgElimContextHelper.registUIObject(this);
            this.loadFields();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(BgElimContextHelper.getBgElimContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    public boolean destroyWindow() {
        BgElimContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, this);
    }

    private void refresh() throws BOSException {
        this.txtOrgTree.setText(this.ctx.getCurOrgBound().toString());
        DefaultKingdeeTreeNode rootNode = null;
        try {
            OrgUnitInfo root = this.ctx.getCurOrgGroup();
            rootNode = BgEliminationHelper.getUnionDebtTree(root, this.ctx.getCurOrgBound(), false, false);
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)rootNode);
        this.tree.setModel((TreeModel)model);
        this.tree.expandAllNodes(true, (TreeNode)rootNode);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }
}

