/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgElimTemplateEntryInfo;
import com.kingdee.eas.ma.nbudget.BgElimTemplateFactory;
import com.kingdee.eas.ma.nbudget.BgElimTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.BizDirectionEnum;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.client.AbstractBgElimTemplateEditUI;
import com.kingdee.eas.ma.nbudget.client.IBgElimContextUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Observable;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BgElimTemplateEditUI
extends AbstractBgElimTemplateEditUI
implements IBgElimContextUI {
    private static final Logger logger = CoreUIObject.getLogger(BgElimTemplateEditUI.class);
    private static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    private IBgElimContext ctx = BgElimContextHelper.getBgElimContext();
    private String orgUnitId = null;
    protected String commentColIndex = "comment";
    protected String bizDirectionColIndex = "bizDirection";
    protected String bgItemIdColIndex = "bgItemId";
    protected String bgItemNumberColIndex = "bgItemNumber";
    protected String bgItemNameColIndex = "bgItemName";
    private String[] especialChar = new String[]{"|", "_", "*", "/", "%"};

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.ctx.getCurMappedOrgUnit() != null) {
            this.setOrgUnitId(this.ctx.getCurMappedOrgUnit().getId().toString());
        }
        this.init();
    }

    private void init() {
        this.comboElimType.removeItem((Object)BgElimTypeEnum.None);
        this.comboElimType.removeItem((Object)BgElimTypeEnum.All);
        this.resetBgItemF7();
        this.getDetailTable().getColumn(this.bgItemNameColIndex).getStyleAttributes().setLocked(true);
        this.getDetailTable().getColumn(this.bgItemIdColIndex).getStyleAttributes().setHided(true);
        KDComboBox cmbDC = new KDComboBox();
        cmbDC.addItems(BizDirectionEnum.getEnumList().toArray());
        this.getDetailTable().getColumn(this.bizDirectionColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDC));
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.comboDiffDeal.setSelectedIndex(0);
            IRow row = null;
            row = this.getDetailTable().addRow();
            row.getCell(this.bizDirectionColIndex).setValue((Object)BizDirectionEnum.Borrow);
            row = this.getDetailTable().addRow();
            row.getCell(this.bizDirectionColIndex).setValue((Object)BizDirectionEnum.loan);
            this.txtNumber.setEditable(true);
            this.btnAddLine.setEnabled(true);
            this.btnInsertLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.menuItemAddLine.setEnabled(true);
            this.menuItemInsertLine.setEnabled(true);
            this.menuItemRemoveLine.setEnabled(true);
            this.kDWorkButtonAddLine.setEnabled(true);
            this.kDWorkButtonRemoveLine.setEnabled(true);
        }
    }

    private void resetBgItemF7() {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        NewBgItemDialog dialog = new NewBgItemDialog((IUIObject)this);
        try {
            if (StringUtils.isEmpty((String)this.orgUnitId)) {
                dialog.setOrgUnitId("NULL_ORGUNITID");
            } else {
                dialog.setOrgUnitId(this.orgUnitId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        dialog.setElimType((BgElimTypeEnum)((Object)this.comboElimType.getSelectedItem()));
        dialog.setSelectCombinItem(false);
        dialog.setMulSelect(false);
        prmtSelect.setSelector((KDPromptSelector)dialog);
        prmtSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgElimTemplateEditUI.this.bgVisualItemInfo_dataChanged(eventObj);
            }
        });
        this.getDetailTable().getColumn(this.bgItemNumberColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setDisplayFormat("$number$");
        prmtSelect.setCommitFormat("$number$");
    }

    protected void bgVisualItemInfo_dataChanged(DataChangeEvent e) {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        int n = rowIndex = rowIndex <= -1 ? 0 : rowIndex;
        if (e.getNewValue() != null) {
            if (e.getNewValue() instanceof BgItemObject) {
                BgItemObject bgItem = (BgItemObject)e.getNewValue();
                this.getDetailTable().getCell(rowIndex, this.bgItemNumberColIndex).setUserObject((Object)bgItem);
                this.getDetailTable().getCell(rowIndex, this.bgItemNameColIndex).setValue((Object)bgItem.getResult().get(0).getName());
                this.getDetailTable().getCell(rowIndex, this.bgItemNumberColIndex).setValue((Object)bgItem.getResult().get(0).getNumber());
            } else if (e.getNewValue() instanceof String) {
                this.getDetailTable().getCell(rowIndex, this.bgItemNumberColIndex).setValue(e.getNewValue());
            }
        }
    }

    @Override
    protected void comboElimType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboElimType_itemStateChanged(e);
        IRow row = null;
        for (int i = 0; i < this.getDetailTable().getRowCount(); ++i) {
            row = this.getDetailTable().getRow(i);
            row.getCell(this.bgItemIdColIndex).setValue(null);
            row.getCell(this.bgItemNumberColIndex).setValue(null);
            row.getCell(this.bgItemNameColIndex).setValue(null);
            row.getCell(this.bgItemNumberColIndex).setUserObject(null);
        }
        this.resetBgItemF7();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.btnWFViewSubmitProccess.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnCopyLine.setVisible(false);
        this.toolBar.remove((Component)this.btnAttachment);
        this.toolBar.remove((Component)this.btnAuditResult);
        this.menuBar.remove((Component)this.menuWorkflow);
        this.menuBar.remove((Component)this.menuView);
        this.menuBar.remove((Component)this.menuBiz);
        this.menuEdit.remove((JMenuItem)this.menuItemCreateFrom);
        this.menuEdit.remove((JMenuItem)this.menuItemCreateTo);
        this.menuEdit.remove((JMenuItem)this.menuItemCopy);
        this.menuEdit.remove((JMenuItem)this.menuItemCopyFrom);
        this.menuFile.remove((JMenuItem)this.menuItemSubmit);
        this.menuFile.remove((JMenuItem)this.menuSubmitOption);
        this.menuFile.remove((JMenuItem)this.rMenuItemSubmit);
        this.menuFile.remove((JMenuItem)this.rMenuItemSubmitAndAddNew);
        this.menuFile.remove((JMenuItem)this.rMenuItemSubmitAndPrint);
        this.menuFile.remove((JMenuItem)this.MenuItemAttachment);
        this.menuFile.remove((JMenuItem)this.menuItemPageSetup);
        this.menuFile.remove((JMenuItem)this.menuItemPrint);
        this.menuFile.remove((JMenuItem)this.menuItemPrintPreview);
        this.menuFile.remove((JMenuItem)this.menuItemSendMail);
        this.menuTable1.remove((JMenuItem)this.menuItemCopyLine);
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.editData.isIsEffective()) {
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.setCanEdit(false);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setCanEdit(false);
            this.btnAddNew.setEnabled(false);
            this.menuItemAddNew.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
        }
        this.kDWorkButtonAddLine.setText("");
        this.kDWorkButtonRemoveLine.setText("");
        this.kDWorkButtonAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.kDWorkButtonRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.getDetailTable().getColumn(this.commentColIndex).setWidth(250);
        this.getDetailTable().getColumn(this.bgItemNameColIndex).setWidth(150);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            if (this.editData.getTreeId() == null && this.ctx.getCurOrgBound() != null) {
                this.editData.setTreeId(this.ctx.getCurOrgBound().getId().toString());
            }
            if (this.editData.getOrgUnitId() == null && this.ctx.getCurMappedOrgUnit() != null) {
                this.editData.setOrgUnitId(this.ctx.getCurMappedOrgUnit().getId().toString());
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void setCanEdit(boolean editable) {
        this.btnEdit.setEnabled(editable);
        this.menuItemEdit.setEnabled(editable);
        this.btnAddLine.setEnabled(editable);
        this.btnCopyLine.setEnabled(editable);
        this.btnInsertLine.setEnabled(editable);
        this.btnRemoveLine.setEnabled(editable);
        this.menuItemAddLine.setEnabled(editable);
        this.menuItemCopyLine.setEnabled(editable);
        this.menuItemInsertLine.setEnabled(editable);
        this.menuItemRemoveLine.setEnabled(editable);
        this.kDWorkButtonAddLine.setEnabled(editable);
        this.kDWorkButtonRemoveLine.setEnabled(editable);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int re;
        super.verifyInput(e);
        if (StringUtil.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"numberEmpty"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        } else {
            String textNum = this.txtNumber.getText();
            for (int i = 0; i < this.especialChar.length; ++i) {
                if (textNum.indexOf(this.especialChar[i]) == -1) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"numberHasEspecialChar"));
                this.txtNumber.requestFocus();
                SysUtil.abort();
            }
        }
        if (StringUtil.isEmpty((String)this.txtName.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"nameEmpty"));
            this.txtName.requestFocus();
            SysUtil.abort();
        }
        if (this.getDetailTable().getRowCount() < 2) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"elimTemplateEntryLessThenTwoRow"));
            SysUtil.abort();
        }
        IRow row = null;
        HashSet<Object> dcSet = new HashSet<Object>();
        HashSet<Object> itemNumbers = new HashSet<Object>();
        Object obj = null;
        BgItemObject bgItemObject = null;
        String longNum = null;
        String longNum2 = null;
        ArrayList<String> longNumList1 = new ArrayList<String>();
        ArrayList<String> longNumList2 = new ArrayList<String>();
        for (int i = 0; i < this.getDetailTable().getRowCount(); ++i) {
            row = this.getDetailTable().getRow(i);
            obj = row.getCell(this.bgItemNumberColIndex).getValue();
            bgItemObject = (BgItemObject)row.getCell(this.bgItemNumberColIndex).getUserObject();
            if (obj == null) {
                MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"bgItemEmpty"));
                SysUtil.abort();
            }
            if (!StringUtils.isEmpty((String)(longNum = bgItemObject != null ? bgItemObject.getResult().get(0).getLongNumber() : (String)obj))) {
                longNum = longNum.replaceAll("\\.", "\\!");
                longNumList1.add(longNum);
                longNumList2.add(longNum);
            }
            itemNumbers.add(obj);
            dcSet.add(row.getCell("bizDirection").getValue());
        }
        if (itemNumbers.size() < this.getDetailTable().getRowCount()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"elimTemplateItemRepeated"));
            SysUtil.abort();
        }
        if (dcSet.size() < 2) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"elimTemplateEntryLessThenTwoRow"));
            SysUtil.abort();
        }
        boolean isNested = false;
        for (int i = 0; i < longNumList1.size() && !isNested; ++i) {
            longNum = (String)longNumList1.get(i);
            for (int j = 0; j < longNumList2.size(); ++j) {
                longNum2 = (String)longNumList2.get(j);
                if (this.checkItemRef(longNum, longNum2) <= 1) continue;
                isNested = true;
                break;
            }
            longNumList2.remove(longNum);
        }
        if (isNested && (re = MsgBox.showConfirm2((String)EASResource.getString((String)RES_PATH, (String)"elimTemplateItemNested"))) != 0) {
            SysUtil.abort();
        }
    }

    private int checkItemRef(String longNum, String longNum2) {
        int ref = 0;
        if (!StringUtils.isEmpty((String)longNum) && !StringUtils.isEmpty((String)longNum2)) {
            if (longNum.length() >= longNum2.length()) {
                if (longNum.equals(longNum2)) {
                    ref = 1;
                } else if (longNum.indexOf(longNum2 + "!") != -1) {
                    ref = 2;
                }
            } else if (longNum2.indexOf(longNum + "!") != -1) {
                ref = 3;
            }
        }
        return ref;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.init();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSave_actionPerformed(e);
        }
        catch (Exception ex) {
            if (ex instanceof BTPException && "904".equals(((BTPException)ex).getSubCode())) {
                String[] msgs = ((BTPException)ex).getMessage().split(":");
                if (msgs != null && msgs.length == 2) {
                    throw new BgCtrlException(BgCtrlException.NOTACROSS, (Object[])new String[]{msgs[1]});
                }
            }
            throw ex;
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewData() {
        return new BgElimTemplateInfo();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BgElimTemplateEntryInfo entry = new BgElimTemplateEntryInfo();
        return entry;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgElimTemplateFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("elimType"));
        sic.add(new SelectorItemInfo("diffDeal"));
        sic.add(new SelectorItemInfo("isEffective"));
        sic.add(new SelectorItemInfo("entries.comment"));
        sic.add(new SelectorItemInfo("entries.bgItemId"));
        sic.add(new SelectorItemInfo("entries.bizDirection"));
        sic.add(new SelectorItemInfo("entries.bgItemNumber"));
        sic.add(new SelectorItemInfo("entries.bgItemName"));
        sic.add(new SelectorItemInfo("treeId"));
        sic.add(new SelectorItemInfo("orgUnitId"));
        return sic;
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, (CoreUI)this);
    }

    public boolean destroyWindow() {
        BgElimContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    protected IObjectPK getOrgPK() {
        try {
            if (this.ctx.getCurOrgGroup() != null) {
                return new ObjectUuidPK(this.ctx.getCurOrgGroup().getId());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            this.handUIException(e);
        }
        return super.getOrgPK();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        try {
            if (this.ctx.getCurOrgGroup() != null) {
                return new ObjectUuidPK(this.ctx.getCurOrgGroup().getId());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            this.handUIException(e);
        }
        return super.getOrgPK(action);
    }
}

