/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.OpenModelInfo;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgElimSourceEnum;
import com.kingdee.eas.ma.nbudget.BgElimStatusEnum;
import com.kingdee.eas.ma.nbudget.BgEliminationFactory;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgEliminationListUI;
import com.kingdee.eas.ma.nbudget.client.BgEliminationEditUI;
import com.kingdee.eas.ma.nbudget.client.IBgElimContextUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgEliminationListUI
extends AbstractBgEliminationListUI
implements IBgElimContextUI {
    private static final Logger logger = CoreUIObject.getLogger(BgEliminationListUI.class);
    public static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";

    public void onLoad() throws Exception {
        if (BgElimContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            BgElimContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.tblMain.getDataRequestManager().setPageRowCount(this.MaxReturnRowCount);
        this.init();
    }

    private void init() throws Exception {
        if (this.bgElimContext.getCurBgDataType() != null) {
            this.comboDataType.setSelectedItem((Object)this.bgElimContext.getCurBgDataType());
        }
        this.refreshBgSchemeF7();
        this.refreshBgPeriodF7();
        this.tblMain.getGroupManager().setGroup(true);
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            if (i < 4) {
                this.tblMain.getColumn(i).setGroup(true);
                this.tblMain.getColumn(i).setMergeable(true);
                continue;
            }
            this.tblMain.getColumn(i).setGroup(false);
            this.tblMain.getColumn(i).setMergeable(false);
        }
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
    }

    private void refreshBgSchemeF7() throws BOSException {
        if (this.bgElimContext.getCurBgScheme() != null) {
            this.prmtScheme.setData((Object)this.bgElimContext.getCurBgScheme());
            this.prmtScheme.setEnabled(false);
        } else {
            String orgUnitId = null;
            OrgUnitInfo orgUnit = this.bgElimContext.getCurMappedOrgUnit();
            orgUnitId = orgUnit != null ? orgUnit.getId().toString() : "NONE_ORGUNIT_ID";
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.Id", (Object)orgUnitId));
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("number"));
            view.setFilter(filter);
            view.setSorter(sorter);
            this.prmtScheme.setEntityViewInfo(view);
            this.prmtScheme.setEnabled(true);
        }
    }

    private void refreshBgPeriodF7() throws BOSException {
        if (this.bgElimContext.getCurBgPeriod() != null) {
            this.prmtPeriod.setData((Object)this.bgElimContext.getCurBgPeriod());
            this.prmtPeriod.setEnabled(false);
        } else {
            BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
            this.prmtPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
            this.prmtPeriod.setEnabled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.menuItemAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnBatchAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditbatch"));
        this.menuItemBatchAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditbatch"));
        this.btnBatchAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unauditbatch"));
        this.menuItemBatchAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unauditbatch"));
        this.btnQuery.setText(EASResource.getString((String)RES_PATH, (String)"conditionQuery"));
        this.itemViewFlow.setVisible(false);
        this.btnCancel.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = viewInfo.getFilter();
        if (filter == null) {
            filter = new FilterInfo();
            viewInfo.setFilter(filter);
        }
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtScheme.getData();
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.prmtPeriod.getData();
        BgDataTypeEnum dataType = (BgDataTypeEnum)this.comboDataType.getSelectedItem();
        if (dataType != null) {
            BgEliminationHelper.replaceFilterItems(filter, new FilterItemInfo("dataType", (Object)("" + dataType.getValue()), CompareType.EQUALS));
        }
        if (orgUnitInfo != null && orgUnitInfo.getId() != null) {
            BgEliminationHelper.replaceFilterItems(filter, new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        } else {
            BgEliminationHelper.replaceFilterItems(filter, new FilterItemInfo("orgUnit.id", (Object)"NULL_ORGUNIT_ID", CompareType.EQUALS));
        }
        if (bgSchemeInfo != null && bgSchemeInfo.getNumber() != null) {
            BgEliminationHelper.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)bgSchemeInfo.getNumber(), CompareType.EQUALS));
        }
        if (bgPeriodInfo != null && bgPeriodInfo.getNumber() != null) {
            BgEliminationHelper.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.number", (Object)bgPeriodInfo.getNumber(), CompareType.EQUALS));
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        if (!this.treeOrgUnit.isEnabled()) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            this.tblMain.removeRows();
            this.enableBtns(false);
            if (this.isInit()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"SelectPermiUnit"));
                this.enableBtns(false);
                SysUtil.abort();
            }
        } else {
            FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
            if (orgUnitInfo == null) {
                return;
            }
            this.buildTreeFilter();
            this.execQuery();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgEliminationFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BgEliminationEditUI.class.getName();
    }

    @Override
    protected void bgScheme_dataChanged(DataChangeEvent e) throws Exception {
        this.execQuery();
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    protected void prmtPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.execQuery();
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ORG_UNIT", (Object)this.getOrgUnitInfo());
            uiContext.put((Object)"ID", (Object)id);
            uiContext.put((Object)"Status", (Object)"STATUS_AUDIT");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            if (this.isDoRefresh(uiWindow)) {
                this.refresh(e);
            }
        }
    }

    @Override
    public void actionAnitAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ORG_UNIT", (Object)this.getOrgUnitInfo());
            uiContext.put((Object)"ID", (Object)id);
            uiContext.put((Object)"Status", (Object)"STATUS_ANTI_AUDIT");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            if (this.isDoRefresh(uiWindow)) {
                this.refresh(e);
            }
        }
    }

    @Override
    public void actionBatchAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        boolean result = BgEliminationFactory.getRemoteInstance().audit(ids);
        if (result) {
            this.setMessageText(EASResource.getString((String)RES_PATH, (String)"batchAuditSuccess"));
            this.showMessage();
        } else {
            this.setMessageText(EASResource.getString((String)RES_PATH, (String)"batchAuditFail"));
            this.showMessage();
        }
        this.refreshList();
    }

    @Override
    public void actionBatchAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        boolean result = BgEliminationFactory.getRemoteInstance().antiAudit(ids);
        if (result) {
            this.setMessageText(EASResource.getString((String)RES_PATH, (String)"batchAntiAuditSuccess"));
            this.showMessage();
        } else {
            this.setMessageText(EASResource.getString((String)RES_PATH, (String)"batchAntiAuditFail"));
            this.showMessage();
        }
        this.refreshList();
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            String status = row.getCell("status").getValue().toString();
            String source = row.getCell("source").getValue().toString();
            if (BgElimStatusEnum.Audited.toString().equals(status)) {
                this.btnAudit.setEnabled(false);
                this.menuItemAudit.setEnabled(false);
                this.btnBatchAudit.setEnabled(false);
                this.menuItemBatchAudit.setEnabled(false);
                this.btnUnAudit.setEnabled(true);
                this.menuItemAntiAudit.setEnabled(true);
                this.btnBatchAntiAudit.setEnabled(true);
                this.menuItemBatchAntiAudit.setEnabled(true);
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnEdit.setEnabled(false);
                this.menuItemEdit.setEnabled(false);
            } else {
                this.btnAudit.setEnabled(true);
                this.menuItemAudit.setEnabled(true);
                this.btnBatchAudit.setEnabled(true);
                this.menuItemBatchAudit.setEnabled(true);
                this.btnUnAudit.setEnabled(false);
                this.menuItemAntiAudit.setEnabled(false);
                this.btnBatchAntiAudit.setEnabled(false);
                this.menuItemBatchAntiAudit.setEnabled(false);
                this.btnRemove.setEnabled(true);
                this.menuItemRemove.setEnabled(true);
                if (BgElimSourceEnum.manual.toString().equals(source)) {
                    this.btnEdit.setEnabled(true);
                    this.menuItemEdit.setEnabled(true);
                } else {
                    this.btnEdit.setEnabled(false);
                    this.menuItemEdit.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, (CoreUI)this);
    }

    public boolean destroyWindow() {
        BgElimContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"ORG_UNIT", (Object)this.getOrgUnitInfo());
        super.prepareUIContext(uiContext, e);
    }

    protected IObjectPK getOrgPK() {
        String _orgUnitId = this.getOrgUnitId();
        if (!StringUtils.isEmpty((String)_orgUnitId)) {
            return new ObjectUuidPK(BOSUuid.read((String)_orgUnitId));
        }
        return super.getOrgPK();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        String _orgUnitId = this.getOrgUnitId();
        if (!StringUtils.isEmpty((String)_orgUnitId)) {
            return new ObjectUuidPK(BOSUuid.read((String)_orgUnitId));
        }
        return super.getOrgPK(action);
    }

    protected String getEditUIModal() {
        OpenModelInfo openModelInfo = (OpenModelInfo)UIFrameContext.getInstance().getProperty((Object)"OpenModel");
        if (openModelInfo != null) {
            if (openModelInfo.isIsOpenInFour()) {
                return "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
            }
            if (openModelInfo.isIsOpenInNewTab()) {
                return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            }
            if (openModelInfo.isIsOpenInWindow()) {
                return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
            }
        }
        return "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
    }

    public String getPermissionNum() {
        return "bgElimination001_list";
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    protected boolean isUseForElim() {
        return true;
    }

    protected boolean isOnlyShowGroup() {
        return true;
    }
}

