/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.budget.BgAnalyseFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgExecuteFilterParam;
import com.kingdee.eas.ma.nbudget.client.AbstractBgExecuteAnalyseFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgExecuteAnalyseFilterUI
extends AbstractBgExecuteAnalyseFilterUI {
    private static final long serialVersionUID = 6789766979665173730L;
    private static final Logger logger = CoreUIObject.getLogger(BgExecuteAnalyseFilterUI.class);
    private static final String BGFORM_ID = "BGFORM_ID";
    private static final String BGITEM_BEGIN_NUNBER = "BGITEM_BEGIN_NUNBER";
    private static final String BGITEM_END_NUMBER = "BGITEM_END_NUMBER";
    private static final String BGELEMENT_ID = "BGELEMENT_ID";
    private static final String CURRENCY_ID = "CURRENCY_ID";
    private static final String SHOW_NUMBER = "SHOW_NUMBER";
    private static final String DISPLAYSOURCEORG = "DISPLAY_SOURCE_ORG";
    private static final String BYBILLORGQUERY = "BY_BILLORG_QUERY";

    public BgExecuteAnalyseFilterUI() throws Exception {
    }

    public BgExecuteAnalyseFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.comBgForm.setLimitedSize(false);
        this.comBgForm.setComboPopupWidth(300);
    }

    protected FilterParam createNewFilterParam() {
        return new BgExecuteFilterParam();
    }

    public String getUITitle() {
        return BgAnalyseHelper.getMessage((String)"bgEAFilterTitle");
    }

    protected boolean hasNewScheme() {
        return true;
    }

    protected void initFilter() throws Exception {
        super.initFilter();
        NewBgItemDialog bgItemSelect = new NewBgItemDialog((IUIObject)this);
        String orgUnitId = null;
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            orgUnitId = ((OrgUnitInfo)this.prmtOrgUnit.getData()).getId().toString();
        }
        if (StringUtils.isEmpty(orgUnitId)) {
            bgItemSelect.setOrgUnitId("NULL_ORGUNITID");
        } else {
            bgItemSelect.setOrgUnitId(orgUnitId);
        }
        this.prmtBgItemBegin.setSelector((KDPromptSelector)bgItemSelect);
        this.prmtBgItemEnd.setSelector((KDPromptSelector)bgItemSelect);
    }

    public void clear() {
        super.clear();
        this.prmtBgItemBegin.setData(null);
        this.prmtBgItemEnd.setData(null);
        this.prmtCurrency.setData(null);
        this.prmtBgElement.setData(null);
        this.showNumber.setSelected(false);
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            if (!(this.prmtBgPeriodBegin.getData() instanceof BgPeriodInfo)) {
                this.prmtBgPeriodBegin.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage((String)"selectBgPeriodBegin"));
                return false;
            }
            if (!(this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo)) {
                this.prmtBgPeriodEnd.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage((String)"selectBgPeriodEnd"));
                return false;
            }
            if (this.prmtBgItemBegin.getData() != null && !(this.prmtBgItemBegin.getData() instanceof VisualItemInfo)) {
                this.prmtBgItemBegin.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage((String)"selectBgItemBegin"));
                return false;
            }
            if (this.prmtBgItemEnd.getData() != null && !(this.prmtBgItemEnd.getData() instanceof VisualItemInfo)) {
                this.prmtBgItemEnd.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage((String)"selectBgItemEnd"));
                return false;
            }
            if (this.prmtBgElement.getData() != null && !(this.prmtBgElement.getData() instanceof BgElementInfo)) {
                this.prmtBgElement.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage((String)"selectBgElement"));
                return false;
            }
        }
        return re;
    }

    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam instanceof BgExecuteFilterParam) {
            BgExecuteFilterParam _filterParam = (BgExecuteFilterParam)filterParam;
            if (_filterParam.getBgFormInfo() != null) {
                BgNFCHelper.setSelectObject(this.comBgForm, _filterParam.getBgFormInfo());
            }
            if (_filterParam.getBeginBgItem() != null) {
                this.prmtBgItemBegin.setData((Object)_filterParam.getBeginBgItem());
            } else {
                this.prmtBgItemBegin.setData(null);
            }
            if (_filterParam.getEndBgItem() != null) {
                this.prmtBgItemEnd.setData((Object)_filterParam.getEndBgItem());
            } else {
                this.prmtBgItemEnd.setData(null);
            }
            if (_filterParam.getBgElementInfo() != null) {
                this.prmtBgElement.setData((Object)_filterParam.getBgElementInfo());
            } else {
                this.prmtBgElement.setData(null);
            }
            if (_filterParam.getCurrency() != null) {
                this.prmtCurrency.setData((Object)_filterParam.getCurrency());
            } else {
                this.prmtCurrency.setData(null);
            }
            this.showNumber.setSelected(_filterParam.getHasShowNumber() == null ? false : _filterParam.getHasShowNumber());
            this.displayBillSourceOrgunit.setSelected(_filterParam.isDisplayBillSourceOrgUnit());
            this.byBillSourceOrgunit.setSelected(_filterParam.isByBillSourceOrgunitQuery());
        }
    }

    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam instanceof BgExecuteFilterParam) {
            BgExecuteFilterParam _filterParam = (BgExecuteFilterParam)filterParam;
            if (this.comBgForm.getSelectedItem() instanceof BgFormInfo) {
                _filterParam.setBgFormInfo((BgFormInfo)this.comBgForm.getSelectedItem());
            } else {
                _filterParam.setBgFormInfo(null);
            }
            if (this.prmtBgItemBegin.getData() instanceof VisualItemInfo) {
                _filterParam.setBeginBgItem((VisualItemInfo)this.prmtBgItemBegin.getData());
            } else {
                _filterParam.setBeginBgItem(null);
            }
            if (this.prmtBgItemEnd.getData() instanceof VisualItemInfo) {
                _filterParam.setEndBgItem((VisualItemInfo)this.prmtBgItemEnd.getData());
            } else {
                _filterParam.setEndBgItem(null);
            }
            if (this.prmtBgElement.getData() instanceof BgElementInfo) {
                _filterParam.setBgElementInfo((BgElementInfo)this.prmtBgElement.getData());
            } else {
                _filterParam.setBgElementInfo(null);
            }
            if (this.prmtCurrency.getData() instanceof CurrencyInfo) {
                _filterParam.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
            } else {
                _filterParam.setCurrency(null);
            }
            if (this.showNumber.isSelected()) {
                _filterParam.setHasShowNumber(Boolean.TRUE);
            } else {
                _filterParam.setHasShowNumber(Boolean.FALSE);
            }
            if (this.byBillSourceOrgunit.isSelected()) {
                _filterParam.setByBillSourceOrgunitQuery(true);
            } else {
                _filterParam.setByBillSourceOrgunitQuery(false);
            }
            if (this.displayBillSourceOrgunit.isSelected()) {
                _filterParam.setDisplayBillSourceOrgUnit(true);
            } else {
                _filterParam.setDisplayBillSourceOrgUnit(false);
            }
        }
    }

    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        FilterParam _fp = super.getFilterParam(mainParam, filterParam);
        BgExecuteFilterParam _mainParam = null;
        BgExecuteFilterParam _filterParam = null;
        if (_fp instanceof BgExecuteFilterParam) {
            _mainParam = (BgExecuteFilterParam)_fp;
            _filterParam = (BgExecuteFilterParam)filterParam;
            if (_filterParam.getBgFormInfo() != null) {
                _mainParam.setBgFormInfo(_filterParam.getBgFormInfo());
            } else {
                _mainParam.setBgFormInfo(null);
            }
            if (_filterParam.getBeginBgItem() != null) {
                _mainParam.setBeginBgItem(_filterParam.getBeginBgItem());
            } else {
                _mainParam.setBeginBgItem(null);
            }
            if (_filterParam.getEndBgItem() != null) {
                _mainParam.setEndBgItem(_filterParam.getEndBgItem());
            } else {
                _mainParam.setEndBgItem(null);
            }
            if (_filterParam.getBgElementInfo() != null) {
                _mainParam.setBgElementInfo(_filterParam.getBgElementInfo());
            } else {
                _mainParam.setBgElementInfo(null);
            }
            if (_filterParam.getCurrency() != null) {
                _mainParam.setCurrency(_filterParam.getCurrency());
            } else {
                _mainParam.setCurrency(null);
            }
            _mainParam.setHasShowNumber(_filterParam.getHasShowNumber());
            _mainParam.setDisplayBillSourceOrgUnit(_filterParam.isDisplayBillSourceOrgUnit());
            _mainParam.setByBillSourceOrgunitQuery(_filterParam.isByBillSourceOrgunitQuery());
        }
        return _fp;
    }

    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgExecuteFilterParam)) {
            return;
        }
        String tmpStr = null;
        BgExecuteFilterParam _filterParam = (BgExecuteFilterParam)filterParam;
        try {
            tmpStr = cp.getCustomerParam(BGFORM_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgFormInfo(new BgFormInfo());
                _filterParam.getBgFormInfo().setId(BOSUuid.read((String)tmpStr));
            }
            if (!StringUtils.isEmpty((String)(tmpStr = cp.getCustomerParam(BGITEM_BEGIN_NUNBER)))) {
                _filterParam.setBeginBgItem(new VisualItemInfo());
                _filterParam.getBeginBgItem().setNumber(tmpStr);
            } else {
                _filterParam.setBeginBgItem(null);
            }
            tmpStr = cp.getCustomerParam(BGITEM_END_NUMBER);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setEndBgItem(new VisualItemInfo());
                _filterParam.getEndBgItem().setNumber(tmpStr);
            } else {
                _filterParam.setEndBgItem(null);
            }
            tmpStr = cp.getCustomerParam(BGELEMENT_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgElementInfo(new BgElementInfo());
                _filterParam.getBgElementInfo().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setBgElementInfo(null);
            }
            tmpStr = cp.getCustomerParam(CURRENCY_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setCurrency(new CurrencyInfo());
                _filterParam.getCurrency().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setCurrency(null);
            }
            tmpStr = cp.getCustomerParam(SHOW_NUMBER);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setHasShowNumber(Boolean.valueOf(tmpStr));
            } else {
                _filterParam.setHasShowNumber(Boolean.FALSE);
            }
            tmpStr = cp.getCustomerParam(DISPLAYSOURCEORG);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setDisplayBillSourceOrgUnit(Boolean.valueOf(tmpStr));
            } else {
                _filterParam.setDisplayBillSourceOrgUnit(false);
            }
            tmpStr = cp.getCustomerParam(BYBILLORGQUERY);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setByBillSourceOrgunitQuery(Boolean.valueOf(tmpStr));
            } else {
                _filterParam.setByBillSourceOrgunitQuery(false);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
    }

    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgAnalyseFilterParam)) {
            return;
        }
        BgExecuteFilterParam _filterParam = (BgExecuteFilterParam)filterParam;
        if (_filterParam.getBgFormInfo() != null) {
            cp.addCustomerParam(BGFORM_ID, _filterParam.getBgFormInfo().getId().toString());
        } else {
            cp.removeCustomerParam(BGFORM_ID);
        }
        if (_filterParam.getBeginBgItem() != null) {
            cp.addCustomerParam(BGITEM_BEGIN_NUNBER, _filterParam.getBeginBgItem().getNumber());
        } else {
            cp.removeCustomerParam(BGITEM_BEGIN_NUNBER);
        }
        if (_filterParam.getEndBgItem() != null) {
            cp.addCustomerParam(BGITEM_END_NUMBER, _filterParam.getEndBgItem().getNumber());
        } else {
            cp.removeCustomerParam(BGITEM_END_NUMBER);
        }
        if (_filterParam.getBgElementInfo() != null) {
            cp.addCustomerParam(BGELEMENT_ID, _filterParam.getBgElementInfo().getId().toString());
        } else {
            cp.removeCustomerParam(BGELEMENT_ID);
        }
        if (_filterParam.getCurrency() != null) {
            cp.addCustomerParam(CURRENCY_ID, _filterParam.getCurrency().getId().toString());
        } else {
            cp.removeCustomerParam(CURRENCY_ID);
        }
        cp.addCustomerParam(SHOW_NUMBER, _filterParam.getHasShowNumber().toString());
        cp.addCustomerParam(DISPLAYSOURCEORG, String.valueOf(_filterParam.isDisplayBillSourceOrgUnit()));
        cp.addCustomerParam(BYBILLORGQUERY, String.valueOf(_filterParam.isByBillSourceOrgunitQuery()));
    }

    protected void orgUnit_dataChanged(DataChangeEvent e) throws Exception {
        NewBgItemDialog bgItemSelect = new NewBgItemDialog((IUIObject)this);
        String orgUnitId = "";
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null) {
            if (obj instanceof FullOrgUnitInfo) {
                orgUnitId = ((FullOrgUnitInfo)obj).getId().toString();
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnitId = ((OrgUnitInfo[])obj)[0].getId().toString();
            }
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            bgItemSelect.setOrgUnitId("NULL_ORGUNITID");
        } else {
            bgItemSelect.setOrgUnitId(orgUnitId);
        }
        this.prmtBgItemBegin.setSelector((KDPromptSelector)bgItemSelect);
        this.prmtBgItemEnd.setSelector((KDPromptSelector)bgItemSelect);
        super.orgUnit_dataChanged(e);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    protected void byBillSourceOrgunit_stateChanged(ChangeEvent e) throws Exception {
        if (this.byBillSourceOrgunit.isSelected() && this.displayBillSourceOrgunit.isSelected()) {
            this.displayBillSourceOrgunit.setSelected(false);
        }
    }

    @Override
    protected void displayBillSourceOrgunit_stateChanged(ChangeEvent e) throws Exception {
        if (this.displayBillSourceOrgunit.isSelected() && this.byBillSourceOrgunit.isSelected()) {
            this.byBillSourceOrgunit.setSelected(false);
        }
    }
}

