/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.print.PrintBookTrans;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.NewWinMainUI;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgAnalyseBaseFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisDoForBook;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisFacadeFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgIOHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptFacadeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTraceFilterParam;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.IDoForBook;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisSimpleObjFilterParam;
import com.kingdee.eas.ma.budget.PrintConfigInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.RatePopoInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchStandardDataForBgFormulaFactory;
import com.kingdee.eas.ma.budget.analysiscolumn.listener.CustomerQueryConditionObserver;
import com.kingdee.eas.ma.budget.analysiscolumn.listener.ICustomerQueryConditionChangeListener;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgFormulaHelper;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgTraceMainUI;
import com.kingdee.eas.ma.budget.client.BgViewActualCtrlUI;
import com.kingdee.eas.ma.budget.client.BgViewBudgetCtrlUI;
import com.kingdee.eas.ma.budget.client.BudgetUserCellDisplayProvider;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisFilterUI;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisMainUI;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnaylsisFilter2UI;
import com.kingdee.eas.ma.budget.client.NumberExpandInfo;
import com.kingdee.eas.ma.budget.client.OrgUnitRender;
import com.kingdee.eas.ma.nbudget.BgFormColumnAnalyseFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.IBgFormColumnAnalyseFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgFormColumnAnalyseMainUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgFormColumnAnalyseMainUI
extends AbstractBgFormColumnAnalyseMainUI {
    private static final Logger logger = CoreUIObject.getLogger(BgFormColumnAnalyseMainUI.class);
    protected FilterParam defaultFilterParam = null;
    private CommonQueryDialog dialog = null;
    protected IMetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.budget", "BgElementQuery");
    private BOSUuid solutionId = null;
    protected SpreadContext sc;
    protected Book book;
    public static final String Analysis_Element_Cls = "AnalysisElementCls";
    protected static final BigDecimal ONE = new BigDecimal("1.00");
    private static final long serialVersionUID = 1133432990146680429L;
    protected static final String COL_KEY = "bgCompareAndAnalysisColKey";
    protected static final String NEW_ANALYSIS_COL_KEY = "AnalysisColKey";
    public static final String ANALYSIS_FLAG = "ANALYSIS_FLAG";
    protected static final String TITLE_FLAG = "TITLE_FLAG";
    protected static final String ADD_ROW_FLAG = "add_row_flag";
    protected static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    private OrgUnitRender render;
    private static CostCenterOrgUnitInfo[] CACHE_ARY;
    private Map CACHE_MAP;
    private NewBgCompareAndAnalysisFilterUI filterUI;
    private NewBgCompareAndAnaylsisFilter2UI filter2UI;
    protected boolean isDisplayZero;
    private FetchStandardDataForBgFormulaFactory factory;
    public static final String THIS_ROW_HAS_DAIL_NUMBER_FORMAT = "THIS_ROW_HAS_DAIL_NUMBER_FORMAT";

    protected BOSUuid getSolutionId() {
        return this.solutionId;
    }

    protected void setSolutionId(BOSUuid solutionId) {
        this.solutionId = solutionId;
    }

    public IMetaDataPK getQueryPk() {
        return this.mainQueryPk;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle();
        boolean hasDefaultQuery = this.getDefaultFilterParam();
        if (hasDefaultQuery) {
            this.executeQuery();
            this.loadPrintConfigInfo();
        } else {
            this.dialog = this.getCommonQueryDialog();
            if (this.dialog.show()) {
                CommonQueryPanel queryPanel = this.dialog.getCommonqueryPanel();
                this.solutionId = queryPanel.getCurrentSolution() != null ? queryPanel.getCurrentSolution().getId() : null;
                this.setFilterParam(this.getFilterUI().getCustomerParams());
                if (this.hasOtherFilterUI()) {
                    KDPanel[] panels = this.getOtherFilterUI();
                    int n = panels.length;
                    for (int i = 0; i < n; ++i) {
                        this.setFilterParam(((CustomerQueryPanel)panels[i]).getCustomerParams());
                    }
                }
                this.executeQuery();
                this.loadPrintConfigInfo();
            } else {
                SysUtil.abort();
            }
        }
        this.initBtn();
    }

    protected void setFilterParam(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.setFilterParam((FilterParam)this.getFilterUI().getFilterObject(cp));
    }

    public void setFilterParam(FilterParam filterParam) {
        if (filterParam == null) {
            filterParam = new NewBgCompareAndAnalysisFilterParam();
        }
        this.defaultFilterParam = filterParam;
    }

    protected void setUITitle() {
        this.setUITitle(BgAnalyseHelper.getMessage((String)"mainTitle"));
    }

    protected void loadPrintConfigInfo() throws Exception {
        if (this.solutionId == null) {
            return;
        }
        PrintConfigInfo configInfo = null;
        configInfo = (PrintConfigInfo)this.getInterface().getPrintConfig(this.solutionId.toString());
        if (configInfo.getData() != null && configInfo.getData().length > 0) {
            if (this.hasSpreadContext()) {
                Book _book = null;
                _book = IOHelper.unpackBook((byte[])configInfo.getData());
                if (this.getSpreadContext() != null && this.getSpreadContext().getBook() != null && _book != null && _book.getSheetCount() == this.getSpreadContext().getBook().getSheetCount()) {
                    PrintBookTrans.copyPrintSetup((Book)_book, (Book)this.getSpreadContext().getBook());
                }
            } else {
                KDF _kdf = null;
                KDTable _table = null;
                _kdf = ZipKDF.unpack((byte[])configInfo.getData());
                int in = this.getSheetSize();
                for (int i = 0; i < in; ++i) {
                    _table = (KDTable)this.getSheet(i);
                    _table.getPrintManager().setFromKDF(_kdf);
                }
            }
        }
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new CommonQueryDialog();
        this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
        this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.dialog.setEntityViewInfo(new EntityViewInfo());
        this.dialog.setQueryObjectPK(this.mainQueryPk);
        this.dialog.setTitle(this.getFilterUI().getUITitle());
        this.dialog.setWidth(this.getWidthOfDialog());
        this.dialog.setHeight(this.getHeightOfDialog());
        this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        if (this.hasOtherFilterUI()) {
            KDPanel[] other = this.getOtherFilterUI();
            int n = other.length;
            for (int i = 0; i < n; ++i) {
                this.dialog.addUserPanel(other[i]);
            }
        }
        this.dialog.setShowFilter(false);
        this.dialog.setShowSorter(false);
        return this.dialog;
    }

    protected int getWidthOfDialog() {
        return 290;
    }

    protected IBgAnalyseFacade getInterface() throws Exception {
        return BgAnalyseFacadeFactory.getRemoteInstance();
    }

    protected void initBtn() {
    }

    protected int getSheetSize() {
        int sheetSize = 0;
        Component obj = null;
        int in = this.getMainTabPane().getTabCount();
        for (int i = 0; i < in; ++i) {
            obj = this.getMainTabPane().getComponentAt(i);
            if (obj instanceof KDTable) {
                sheetSize = 1;
                continue;
            }
            if (!(obj instanceof KDPanel)) continue;
            KDPanel panel = (KDPanel)obj;
            int jn = panel.getComponentCount();
            for (int j = 0; j < jn; ++j) {
                obj = panel.getComponent(j);
                if (!(obj instanceof KDTable)) continue;
                ++sheetSize;
            }
        }
        return sheetSize;
    }

    protected Object getSheet(int index) {
        Component obj = null;
        KDTable sheet = null;
        obj = this.getMainTabPane().getComponentAt(index);
        if (obj instanceof KDTable) {
            return (KDTable)obj;
        }
        if (obj instanceof KDPanel) {
            KDPanel panel = (KDPanel)obj;
            int n = panel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                obj = panel.getComponent(i);
                if (!(obj instanceof KDTable)) continue;
                sheet = (KDTable)obj;
            }
        }
        return sheet;
    }

    protected KDTabbedPane getMainTabPane() {
        return this.TabPaneMain;
    }

    protected boolean getDefaultFilterParam() throws Exception {
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION)) {
            this.setSolutionId(ds.getId());
            int size = ds.getQueryPanelInfo().size();
            for (int i = 0; i < size; ++i) {
                QueryPanelInfo info = ds.getQueryPanelInfo().get(i);
                CustomerParams cp = new CustomerParams().getCustomerParams(info.getCustomerParams());
                this.setFilterParam(cp, info.getPanelClassName());
            }
        }
        return this.getFilterParam() != null;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.sc != null) {
            this.sc.getPrintManager().print();
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.sc != null) {
            this.sc.getPrintManager().printPreview();
        }
        this.setPrintConfigInfo();
    }

    protected void setPrintConfigInfo() throws Exception {
        if (this.solutionId == null) {
            return;
        }
        Book _book = null;
        KDF _kdf = null;
        KDTable _table = null;
        PrintConfigInfo printConfigInfo = new PrintConfigInfo();
        if (this.hasSpreadContext()) {
            int sheetSize = this.getSpreadContext().getBook().getSheetCount();
            _book = Book.Manager.getNewBook((String)"PRINT", (int)sheetSize);
            PrintBookTrans.copyPrintSetup((Book)this.getSpreadContext().getBook(), (Book)_book);
            printConfigInfo.setData(IOHelper.packBook((Book)_book));
        } else {
            _kdf = new KDF();
            int in = this.getSheetSize();
            for (int i = 0; i < in; ++i) {
                _table = (KDTable)this.getSheet(i);
                _kdf.addTable((IDObject)_table);
                _table.getPrintManager().saveToKDF(_kdf);
            }
            printConfigInfo.setData(ZipKDF.pack((KDF)_kdf));
        }
        this.getInterface().setPrintConfig(this.solutionId.toString(), (Object)printConfigInfo);
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"39_BgFormColumnAnalyseMainUI"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setSelectedFile(new File(BgAnalyseHelper.getDefaultFileName()));
        if (fc.showSaveDialog((Component)((Object)this)) == 0 && (file = fc.getSelectedFile()) != null) {
            if (file.exists()) {
                int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "existsFile"));
                if (re == 1 || re == 2) {
                    return;
                }
                file.delete();
            }
            try {
                this.exportBookContent(file);
            }
            catch (Exception ex) {
                throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
            }
        }
    }

    protected void exportBookContent(File file) throws Exception {
        Book _book = this.sc.getBook();
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        String _filename = file.getPath();
        _kdsBook = new KDSBook(_filename);
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            _kdsSheet = new KDSSheet(_kdsBook, _sheet.getSheetName());
            _kdsBook.addSheet(null, _kdsSheet);
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, true);
                    if (_cell == null || _cell.getValue() == Variant.nullVariant) continue;
                    _kdsCell.setValue((Object)_cell.getValue());
                }
            }
        }
        ExportManager em = new ExportManager();
        em.exportToExcel(_kdsBook, _filename);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        Range selectRange = this.sc.getBook().getActiveSheet().getRange(0, 0);
        selectRange.select();
        this.sc.getSpread().scrollCellVisible(0, 0);
        this.loadPrintConfigInfo();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.getCommonQueryDialog();
        if (dialog.show()) {
            NewBgCompareAndAnalysisFilterUI filterui = this.getFilterUI();
            filterui.setOwnFilterParam(null);
            NewBgCompareAndAnaylsisFilter2UI filter2ui = (NewBgCompareAndAnaylsisFilter2UI)this.getFilter2UI();
            filter2ui.setOwnFilterParam(null);
            this.setFilterParam(this.getFilterUI().getCustomerParams());
            this.setFilterParam(this.getFilter2UI().getCustomerParams());
            CommonQueryPanel queryPanel = dialog.getCommonqueryPanel();
            if (queryPanel.getCurrentSolution() != null) {
                this.setSolutionId(queryPanel.getCurrentSolution().getId());
            }
            this.executeQuery();
            this.loadPrintConfigInfo();
        }
    }

    private void setFilterParam(CustomerParams cp, String filterUIKey) {
        if (cp == null) {
            return;
        }
        BgAnalyseFilterBaseUI filterUI = this.getFilterUIByFilterUIKey(filterUIKey);
        if (filterUI instanceof NewBgCompareAndAnalysisFilterUI) {
            NewBgCompareAndAnalysisFilterUI filter1UI = (NewBgCompareAndAnalysisFilterUI)filterUI;
            NewBgCompareAndAnalysisFilterParam filter1Param = filter1UI.getOwnFilterParam();
            CostCenterOrgUnitInfo[] ccouiAry = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCostCenterOrgUnit((String)cp.getCustomerParam("OrgUnitKey"));
            filter1Param.setCostCenterOrgUnitInfoAry(ccouiAry);
            BgSchemeInfo scheme = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgSchemeInfo((String)cp.getCustomerParam("BgSchemeID"));
            filter1Param.setBgSchemeInfo(scheme);
            String bgFormId = cp.getCustomerParam("BgFormID");
            filter1Param.setBgFormID(bgFormId);
            Map titleMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisAndTitleColKey((String)cp.getCustomerParam("BgTitleColKey"));
            filter1Param.setTitleColsMap(titleMap);
            Map analysisMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisAndTitleColKey((String)cp.getCustomerParam("BgAnalysisColKey"));
            filter1Param.setAnalysisColsMap(analysisMap);
            BgPeriodInfo sInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo((String)cp.getCustomerParam("BeginPeriodID"));
            filter1Param.setBeginPeriod(sInfo);
            BgPeriodInfo eInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo((String)cp.getCustomerParam("EndPeriodID"));
            filter1Param.setEndPeriod(eInfo);
            CurrencyInfo currency = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCurrencyInfo((String)cp.getCustomerParam("CurrencyID"));
            filter1Param.setCurrencyInfo(currency);
            Map measureMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeMeasureUnit((String)cp.getCustomerParam("BgMeasureUnitKey"));
            filter1Param.setMeasureUnitInfoMap(measureMap);
            String isSum = cp.getCustomerParam("IsSum");
            filter1Param.setShowColRow(Boolean.valueOf(isSum).booleanValue());
        } else if (filterUI instanceof NewBgCompareAndAnaylsisFilter2UI) {
            NewBgCompareAndAnaylsisFilter2UI filter2UI = (NewBgCompareAndAnaylsisFilter2UI)filterUI;
            List analysisEleList = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisElement((String)cp.getCustomerParam("BgSimpleAnalysisElement"));
            filter2UI.getOwnFilterParam().setAnalysisElement(analysisEleList);
        }
        this.defaultFilterParam = new BgAnalyseBaseFilterParam();
    }

    protected NewBgCompareAndAnalysisFilterUI getFilterUI() {
        try {
            if (this.filterUI == null) {
                this.filterUI = new NewBgCompareAndAnalysisFilterUI();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return this.filterUI;
    }

    protected BgAnalyseFilterBaseUI getFilter2UI() {
        KDPanel[] ary = this.getOtherFilterUI();
        NewBgCompareAndAnaylsisFilter2UI filter2UI = (NewBgCompareAndAnaylsisFilter2UI)ary[0];
        return filter2UI;
    }

    protected boolean hasOtherFilterUI() {
        return true;
    }

    protected KDPanel[] getOtherFilterUI() {
        try {
            if (this.filter2UI == null) {
                this.filter2UI = new NewBgCompareAndAnaylsisFilter2UI();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        CustomerQueryConditionObserver.getIntance().attach((ICustomerQueryConditionChangeListener)this.filter2UI);
        return new KDPanel[]{this.filter2UI};
    }

    private IBgFormColumnAnalyseFacade getFacade() throws BOSException {
        return BgFormColumnAnalyseFacadeFactory.getRemoteInstance();
    }

    protected void executeQuery() {
        this.clearCache();
        NewBgCompareAndAnalysisFilterParam filter1Params = this.getFilterUIParams();
        NewBgCompareAndAnalysisFilterParam filter2Params = this.getFilterUI2Params();
        Map returnData = null;
        HashMap<String, NewBgCompareAndAnalysisFilterParam> param = new HashMap<String, NewBgCompareAndAnalysisFilterParam>();
        param.put("PARAM1", filter1Params);
        param.put("PARAM2", filter2Params);
        try {
            returnData = this.getFacade().initData(param);
            if (returnData != null && !returnData.isEmpty()) {
                this.book = IOHelper.unpackBook((byte[])((byte[])returnData.get("BOOK")));
                this.book.setCalculate(false);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (this.sc != null) {
            this.TabPaneMain.remove((Component)this.sc);
        }
        if (this.book != null && this.book.getSheet(0) != null) {
            this.sc = new SpreadContext();
            this.sc.addBookChangeListener(new BookChangeListener(){

                public void changed(BookChangeEvent e) {
                    if (e.isSheetActive()) {
                        BgFormColumnAnalyseMainUI.this.onSheetActive(e.getSheet());
                    }
                }
            });
            this.sc.setBook(this.book);
            this.TabPaneMain.add((Component)this.sc, (Object)"Center");
            this.TabPaneMain.setTitleAt(0, this.getTabPaneMainUITitle());
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"40_BgFormColumnAnalyseMainUI"));
            SysUtil.abort();
        }
        this.addTableListener();
        BudgetUserCellDisplayProvider dp = new BudgetUserCellDisplayProvider();
        dp.addRenderProvider((IRenderProvider)new OrgUnitRender());
        this.sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)dp);
        BgFormColumnAnalyseMainUI.setAllNumberRightA(this.sc.getBook().getSheet(0));
        this.sc.repaint();
        for (int i = this.sc.getBook().getSheetCount() - 1; i >= 0; --i) {
            this.sc.getBook().getSheet(i).getRange(0, 0).select();
        }
        this.sc.getSpread().scrollCellVisible(0, 0);
    }

    public boolean destroyWindow() {
        this.clearCache();
        return super.destroyWindow();
    }

    private void clearCache() {
        CACHE_ARY = null;
        if (this.CACHE_MAP != null) {
            this.CACHE_MAP.clear();
        }
        if (this.book != null) {
            this.book = null;
        }
    }

    protected final List getAnalysisColIndexList(Sheet sheet) {
        ArrayList<Integer> analysisColIndexList = new ArrayList<Integer>();
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject(col, NEW_ANALYSIS_COL_KEY);
            if (!(obj instanceof String) || !ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            analysisColIndexList.add(new Integer(i));
        }
        return analysisColIndexList;
    }

    private BigDecimal reSetAmountUnit(String element, Map amountUnitMap) {
        if (amountUnitMap == null || amountUnitMap.size() == 0) {
            return ONE;
        }
        for (BgElementInfo elementInfo : amountUnitMap.keySet()) {
            if (!elementInfo.getNumber().equals(element)) continue;
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)amountUnitMap.get(elementInfo);
            return measureUnitInfo.getCoefficient();
        }
        return ONE;
    }

    protected void fillSubOrgDataToTable(Sheet sheet, List analysisColsList, int initRowIndex, String orgUnitId, Map amountUnitMap) throws EASBizException, BOSException {
    }

    private BgAnalyseFilterBaseUI getFilterUIByFilterUIKey(String filterUIKey) {
        if (NewBgCompareAndAnalysisFilterUI.class.getName().equals(filterUIKey)) {
            try {
                if (this.filterUI == null) {
                    this.filterUI = new NewBgCompareAndAnalysisFilterUI();
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
            return this.filterUI;
        }
        if (NewBgCompareAndAnaylsisFilter2UI.class.getName().equals(filterUIKey)) {
            try {
                if (this.filter2UI == null) {
                    this.filter2UI = new NewBgCompareAndAnaylsisFilter2UI();
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
            return this.filter2UI;
        }
        return null;
    }

    protected Book addAndInitTable(NewBgCompareAndAnalysisFilterParam filter1Params) {
        if (this.book != null) {
            return this.book;
        }
        if (this.sc != null) {
            this.TabPaneMain.remove((Component)this.sc);
        }
        String bgFormID = filter1Params.getBgFormID();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgFormID));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("data"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        Book book = null;
        try {
            BgFormInfo bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormCollection(viewInfo).get(0);
            if (bgFormInfo == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"5_BgFormColumnAnalyseFacadeControllerBean"));
                SysUtil.abort();
            }
            BgIOHelper bih = new BgIOHelper();
            bih.setIDoForBook((IDoForBook)new BgCompareAndAnalysisDoForBook());
            book = bih.getBook(bgFormInfo.getData());
            book.setCalculate(false);
        }
        catch (Exception ex) {
            if (book != null) {
                book = null;
            }
            ExceptionHandler.handle((Throwable)ex);
            SysUtil.abort();
        }
        if (book != null && book.getSheet(0) != null) {
            this.sc = new SpreadContext();
            this.sc.addBookChangeListener(new BookChangeListener(){

                public void changed(BookChangeEvent e) {
                    if (e.isSheetActive()) {
                        BgFormColumnAnalyseMainUI.this.onSheetActive(e.getSheet());
                    }
                }
            });
            this.sc.setBook(book);
            this.TabPaneMain.add((Component)this.sc, (Object)"Center");
            this.TabPaneMain.setTitleAt(0, this.getTabPaneMainUITitle());
        }
        return book;
    }

    protected void onSheetActive(Sheet sheet) {
        BgFormColumnAnalyseMainUI.setAllNumberRightA(sheet);
    }

    protected String getTabPaneMainUITitle() {
        return EASResource.getString((String)resourcePath, (String)"BgCompareAndAnalysisTitle");
    }

    protected int constructSheet(NewBgCompareAndAnalysisFilterParam filter1Param, List analysisElementList, Sheet sheet) {
        Map analysisColsMap = filter1Param.getAnalysisColsMap();
        String sheetID = sheet.getID();
        String sheetName = sheet.getSheetName();
        String key = sheetID + "&" + sheetName;
        List analysisColsList = (List)analysisColsMap.get(key);
        if (analysisColsList == null) {
            return 0;
        }
        Map titleColsMap = filter1Param.getTitleColsMap();
        List titleColsList = null;
        if (titleColsMap != null) {
            titleColsList = (List)titleColsMap.get(key);
        }
        if (titleColsList != null && titleColsList.size() != 0) {
            this.removeUnRequiredCols(titleColsList, analysisColsList, sheet);
        } else {
            this.removeUnRequiredCols(analysisColsList, sheet);
        }
        int rowIndex = this.locateAddedNewRowIndex(sheet);
        Row addRow = BgNFSHelper.addRow(sheet, rowIndex);
        addRow.setUserObject(ADD_ROW_FLAG, (Object)"addRow");
        this.addAnalysisCols(analysisElementList, rowIndex, sheet);
        this.removeOldColumns(sheet);
        this.accessorizeNewTable(analysisElementList.size(), rowIndex, sheet);
        this.addOrgUnitByCol(filter1Param, rowIndex + 1, sheet);
        return rowIndex;
    }

    private void removeUnRequiredCols(List titleList, List analysisList, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (titleList.contains(new Integer(i))) {
                BgNFSHelper.setColObject(sheet.getColumn(i, false), COL_KEY, TITLE_FLAG);
                continue;
            }
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject(sheet.getColumn(i, false), COL_KEY, ANALYSIS_FLAG);
                continue;
            }
            try {
                BgNFSHelper.removeColumn(sheet, i);
                continue;
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
        }
    }

    private void removeUnRequiredCols(List analysisList, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject(sheet.getColumn(i, false), COL_KEY, ANALYSIS_FLAG);
                continue;
            }
            BgNFSHelper.setColObject(sheet.getColumn(i, false), COL_KEY, TITLE_FLAG);
        }
    }

    protected int getHeightOfDialog() {
        return 400;
    }

    private void addTableListener() {
        this.sc.getSpread().setMouseController(3, (IMouseController)new MyTableMouseController(this.sc));
        this.sc.getBook().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                BgFormColumnAnalyseMainUI.this.sc.getSpread().scrollCellVisible(0, 0);
            }
        });
    }

    private IFullOrgUnit getFullOrgUnitInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    private void addOrgUnitByCol(NewBgCompareAndAnalysisFilterParam filter1Param, int beginRow, Sheet sheet) {
        CostCenterOrgUnitInfo[] orgInfoAry = filter1Param.getCostCenterOrgUnitInfoAry();
        int num = orgInfoAry.length;
        String[] companyIds = new String[num];
        for (int i = 0; i < num; ++i) {
            companyIds[i] = orgInfoAry[i].getId().toString();
        }
        if (companyIds != null && companyIds.length != 0) {
            FullOrgUnitInfo baseOrgUnit = null;
            try {
                baseOrgUnit = (FullOrgUnitInfo)this.getFullOrgUnitInterface().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyIds[0])));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            Column column = BgNFSHelper.addColumn(sheet, 0);
            int colIndex = column.getCol();
            sheet.getColRange(colIndex, colIndex).setColumnWidth(200);
            if (companyIds.length > 1) {
                this.render = new OrgUnitRender();
                BudgetUserCellDisplayProvider dp = new BudgetUserCellDisplayProvider();
                dp.addRenderProvider((IRenderProvider)this.render);
                this.sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)dp);
            }
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            MergeBlocks blocks = sheet.getMerger(false);
            for (int rowIndex = beginRow; rowIndex < rowCount; ++rowIndex) {
                if (!this.checkHasBgItem(sheet, rowIndex)) continue;
                if (blocks != null && !blocks.isEmpty()) {
                    for (int i = 0; i < colCount; ++i) {
                        if (sheet.getCell(rowIndex, i, false) == null) continue;
                        sheet.getMerger(false).remove(sheet.getCell(rowIndex, i, false).getMerge(false));
                    }
                }
                this.addExpandInfo(sheet.getCell(rowIndex, column.getCol(), true), baseOrgUnit, companyIds.length);
            }
        }
    }

    protected void addExpandInfo(Cell cell, FullOrgUnitInfo orgUnitInfo, int orgNum) {
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
        expandInfo.setLevel(0);
        expandInfo.setExpandStatus(false);
        expandInfo.setLeaf(false);
        this.setCellStyle(cell);
        BgNFCHelper.setNumberExpandInfo(cell, expandInfo);
        if (orgNum == 1) {
            BgNFSHelper.setValue(cell, orgUnitInfo.getName());
        }
    }

    protected void setCellStyle(Cell cell) {
    }

    private boolean checkHasBgItem(Sheet sheet, int rowIndex) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int colIndex = colNum - 1; colIndex >= 0; --colIndex) {
            Column col = sheet.getColumn(colIndex, false);
            Object colKey = BgNFSHelper.getColObject(col, NEW_ANALYSIS_COL_KEY);
            if (colKey == null || !ANALYSIS_FLAG.equals(colKey)) continue;
            Cell cell = sheet.getCell(rowIndex, colIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell(cell);
            String bgFormula = BgNFSHelper.getExpression(cell);
            if (bgItem != null && !"".equals(bgItem)) {
                return true;
            }
            if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula((String)bgFormula)) continue;
            return true;
        }
        return false;
    }

    private void accessorizeNewTable(int mergeColNum, int rowIndex, Sheet sheet) {
        int num = sheet.getMaxColIndex();
        for (int i = num - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject(col, NEW_ANALYSIS_COL_KEY);
            if (!(obj instanceof String) || !ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            for (int j = rowIndex - 1; j >= 0; --j) {
                Cell cell = sheet.getCell(j, i, false);
                if (cell == null || !BgNFSHelper.checkHasCurrencyInfo(cell) && !BgNFSHelper.checkHasBgElementInfo(cell) && !BgNFSHelper.checkHasBgItemInfo(cell) && !BgNFSHelper.checkHasBgPeriodInfo(cell)) continue;
                sheet.getRange(j, i, j, mergeColNum + i - 1).merge();
            }
        }
    }

    private boolean isRealAnalysisCol(Column column, Sheet sheet) {
        int colIndex = column.getCol();
        int num = sheet.getMaxColIndex() + 11;
        for (int i = 0; i < num; ++i) {
            String tempBgItem;
            Cell cell = sheet.getCell(i, colIndex, false);
            if (cell == null) continue;
            String bgItem = BgNFSHelper.getFormulaOfCell(cell);
            String bgFormula = BgNFSHelper.getExpression(cell);
            if (bgItem != null && !"".equals(bgItem)) {
                return true;
            }
            if (bgFormula == null || bgFormula.equals("") || !BgFormulaHelper.isSingleBgFormula((String)bgFormula) || "".equals(tempBgItem = AnalysisColumnTool.changeBgFormulaToBgItem((String)bgFormula))) continue;
            return true;
        }
        return false;
    }

    private void addAnalysisCols(List analysisElementList, int rowIndex, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column col = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject(col, COL_KEY);
            if (!ANALYSIS_FLAG.equals(colKey)) continue;
            if (!this.isRealAnalysisCol(col, sheet)) {
                BgNFSHelper.setColObject(col, COL_KEY, null);
                continue;
            }
            int num = analysisElementList.size();
            for (int j = 0; j < num; ++j) {
                int colIndex = i + j + 1;
                Column column = BgNFSHelper.addColumn(sheet, colIndex);
                String proName = analysisElementList.get(j).toString();
                BgNFSHelper.setColObject(column, COL_KEY, proName);
            }
        }
    }

    private void removeOldColumns(Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column oldCol = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject(oldCol, COL_KEY);
            Row row = null;
            if (colKey == null || !ANALYSIS_FLAG.equals(colKey)) continue;
            int newAnalysisColIndex = i + 1;
            Column newAnalysisCol = sheet.getColumn(newAnalysisColIndex, false);
            BgNFSHelper.setColObject(newAnalysisCol, NEW_ANALYSIS_COL_KEY, ANALYSIS_FLAG);
            int num = sheet.getMaxRowIndex() + 1;
            for (int j = 0; j < num; ++j) {
                Cell newCell;
                Cell cell;
                row = sheet.getRow(j, false);
                if (row != null && row.getUserObjectValue(ADD_ROW_FLAG) != null && row.getUserObjectValue(ADD_ROW_FLAG).toString().equals("addRow") || (cell = sheet.getCell(j, i, false)) == null) continue;
                String bgItem = BgNFSHelper.getFormulaOfCell(cell);
                String bgFormula = BgNFSHelper.getExpression(cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setFormulaOfCell(newCell, bgItem, true);
                } else if (BgNFSHelper.checkHasExpression(cell)) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setExpression(newCell, bgFormula);
                }
                Object txtCellObj = BgNFSHelper.getValue(cell);
                if (txtCellObj == null) continue;
                String txtCell = txtCellObj.toString();
                Cell newCell2 = sheet.getCell(j, newAnalysisColIndex, true);
                BgNFSHelper.setValue(newCell2, txtCell);
            }
            boolean isDelete = BgNFSHelper.removeColumn(sheet, i);
            if (isDelete) continue;
            BgNFSHelper.setSheetProtection(sheet, false);
            BgNFSHelper.removeColumn(sheet, i);
        }
    }

    protected void fillDataToEntireTbl(Sheet sheet, int rowIndex, String orgUnitId, Map amountUnitMap, int difRowNum) {
    }

    private String findBgItem(Sheet sheet, int rowIndex, int colIndex, int difRowNum) {
        if (difRowNum == 0) {
            return null;
        }
        Cell cell = sheet.getCell(rowIndex - difRowNum, colIndex, false);
        String bgItem = BgNFSHelper.getFormulaOfCell(cell);
        if (bgItem != null && !"".equals(bgItem)) {
            return bgItem;
        }
        return null;
    }

    private int locateAddedNewRowIndex(Sheet sheet) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        boolean continueFlag = true;
        int rowIndex = 0;
        block0: for (int i = 0; i < rowCount && continueFlag; ++i) {
            for (int j = 0; j < colCount && continueFlag; ++j) {
                Cell cell = sheet.getCell(i, j, false);
                String bgItem = BgNFSHelper.getFormulaOfCell(cell);
                String bgFormula = BgNFSHelper.getExpression(cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    rowIndex = cell.getRow();
                    continueFlag = false;
                    continue block0;
                }
                if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula((String)bgFormula)) continue;
                rowIndex = cell.getRow();
                continueFlag = false;
                continue block0;
            }
        }
        return rowIndex;
    }

    protected NewBgCompareAndAnalysisFilterParam getFilterUIParams() {
        NewBgCompareAndAnalysisFilterUI tempFilterUI = this.getFilterUI();
        NewBgCompareAndAnalysisFilterParam filterParam = tempFilterUI.getOwnFilterParam();
        return filterParam;
    }

    protected NewBgCompareAndAnalysisFilterParam getFilterUI2Params() {
        KDPanel[] panels = this.getOtherFilterUI();
        this.filter2UI = (NewBgCompareAndAnaylsisFilter2UI)panels[0];
        return this.filter2UI.getOwnFilterParam();
    }

    protected void setTreeDisplayStyle(Cell cell, NumberExpandInfo expandInfo, Sheet sheet) {
        try {
            this.expandTable(cell, expandInfo, sheet);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        BgFormColumnAnalyseMainUI.setAllNumberRightA(sheet);
        this.sc.getSpread().repaint();
    }

    private void expandTable(Cell cell, NumberExpandInfo parentExpandInfo, Sheet sheet) throws EASBizException, BOSException {
        Row childRow = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            BgNFCHelper.setNumberExpandInfo(cell, parentExpandInfo);
            int beginRowIndex = cell.getRow() + 1;
            int rowCount = sheet.getMaxRowIndex() + 1;
            ArrayList<Integer> delList = new ArrayList<Integer>();
            for (int rowIndex = beginRowIndex; rowIndex < rowCount; ++rowIndex) {
                NumberExpandInfo childExpandInfo;
                Cell tempCell;
                childRow = sheet.getRow(rowIndex, false);
                if (childRow == null || (tempCell = childRow.getCell(0, false)) == null || (childExpandInfo = BgNFCHelper.getNumberExpandInfo(tempCell)) == null) continue;
                longnumber = childExpandInfo.getLongNumber();
                if (!longnumber.startsWith(plongnumber + "!")) break;
                delList.add(new Integer(childRow.getRow()));
            }
            this.deleteUnvisibleRows(sheet, delList, beginRowIndex);
        } else {
            int rowIndex;
            parentExpandInfo.setExpandStatus(true);
            BgNFCHelper.setNumberExpandInfo(cell, parentExpandInfo);
            int rowCount = sheet.getMaxRowIndex() + 1;
            if (rowIndex >= rowCount - 1) {
                this.addChildRowByOrgUnitParentInfo(sheet, rowIndex, parentExpandInfo);
            } else {
                for (rowIndex = cell.getRow(); rowIndex < rowCount - 1; ++rowIndex) {
                    childRow = sheet.getRow(rowIndex, false);
                    NumberExpandInfo childExpandInfo = BgNFCHelper.getNumberExpandInfo(childRow.getCell(0, false));
                    if (childExpandInfo != null) {
                        longnumber = childExpandInfo.getLongNumber();
                        if (rowIndex != cell.getRow()) break;
                        this.addChildRowByOrgUnitParentInfo(sheet, rowIndex, parentExpandInfo);
                        break;
                    }
                    if (rowIndex != cell.getRow()) continue;
                    this.addChildRowByOrgUnitParentInfo(sheet, rowIndex, parentExpandInfo);
                }
            }
        }
    }

    private void deleteUnvisibleRows(Sheet sheet, List rowIndexList, int endRowIndex) {
        int rowIndex;
        BgNFSHelper.setSheetProtection(sheet, false);
        for (int i = rowIndexList.size() - 1; i > -1 && (rowIndex = Integer.valueOf(rowIndexList.get(i).toString()).intValue()) >= endRowIndex; --i) {
            BgNFSHelper.removeRow(sheet, rowIndex);
        }
    }

    private void addChildRowByOrgUnitParentInfo(Sheet sheet, int beginRow, NumberExpandInfo parentExpandInfo) throws EASBizException, BOSException {
    }

    private void fillDataToSumRow(Sheet sheet, int sumRowIndex, int subNodeSize, int analysisElementNum, List analysisColIndexList, int analysisColIndex) {
        for (int j = 0; j < analysisElementNum; ++j) {
            int colIndex = j + analysisColIndex;
            Cell cell = sheet.getCell(sumRowIndex, colIndex, true);
            BgNFSHelper.setValue(cell, this.countSumVal(sheet, sumRowIndex, subNodeSize, colIndex));
        }
    }

    private void fillDataToEntireSumRow(Sheet sheet, int sumRowIndex, int subNodeSize, int analysisElementNum, List analysisColIndexList) {
        int colCount = sheet.getMaxColIndex() + 1;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            Object obj = BgNFSHelper.getColObject(sheet.getColumn(colIndex, true), NEW_ANALYSIS_COL_KEY);
            if (obj instanceof String) {
                String colKey = obj.toString();
                if (!ANALYSIS_FLAG.equals(colKey)) continue;
                this.fillDataToSumRow(sheet, sumRowIndex, subNodeSize, analysisElementNum, analysisColIndexList, colIndex);
                continue;
            }
            String bgItem = BgNFSHelper.getFormulaOfCell(sheet.getCell(sumRowIndex - 1, colIndex, true));
            if (bgItem == null || "".equals(bgItem)) continue;
            BgNFSHelper.setValue(sheet.getCell(sumRowIndex, colIndex, true), this.countSumVal(sheet, sumRowIndex, subNodeSize, colIndex));
        }
    }

    private Object countSumVal(Sheet sheet, int sumRowIndex, int subNodeSize, int colIndex) {
        Object obj = null;
        BigDecimal sumVal = new BigDecimal("0.00");
        BigDecimal fenmuVal = new BigDecimal("0.00");
        BigDecimal fenziVal = new BigDecimal("0.00");
        RatePopoInfo rateInfo = null;
        boolean isRateData = false;
        int scale = 2;
        for (int i = 1; i <= subNodeSize; ++i) {
            BigDecimal val;
            obj = BgNFSHelper.getValue(sheet.getCell(sumRowIndex + i, colIndex, false));
            if (obj instanceof String) {
                val = this.getNumberFromStrForm((String)obj);
                if (val == null) {
                    return "";
                }
                sumVal = sumVal.add(val);
                continue;
            }
            if (obj instanceof BigDecimal) {
                val = (BigDecimal)obj;
                sumVal = sumVal.add(val);
                continue;
            }
            if (!(obj instanceof RatePopoInfo)) continue;
            rateInfo = (RatePopoInfo)obj;
            fenmuVal = fenmuVal.add(rateInfo.getFenmu());
            fenziVal = fenziVal.add(rateInfo.getFenzi());
            isRateData = true;
            if (rateInfo.getScale() <= 2) continue;
            scale = rateInfo.getScale();
        }
        if (isRateData) {
            rateInfo = new RatePopoInfo(fenziVal, fenmuVal);
            rateInfo.setScale(scale);
            rateInfo.initReuslt();
            return rateInfo.toString();
        }
        return DataDealCenter.decFormat.format(sumVal);
    }

    private BigDecimal getNumberFromStrForm(String str) {
        BigDecimal bg = null;
        if (str.indexOf("%") != -1) {
            return null;
        }
        str = str.replaceAll(",", "");
        try {
            bg = new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            return bg;
        }
        return bg;
    }

    private List getSubNodeList(List subNodeLNList, CostCenterOrgUnitInfo[] ary) {
        ArrayList<CostCenterOrgUnitInfo> subNodeList = new ArrayList<CostCenterOrgUnitInfo>();
        for (CostCenterOrgUnitInfo tempInfo : ary) {
            String tempLN = tempInfo.getLongNumber();
            if (!subNodeLNList.contains(tempLN)) continue;
            subNodeList.add(tempInfo);
        }
        return subNodeList;
    }

    private NumberExpandInfo copyOrgUnitInfoToExpendInfo(CostCenterOrgUnitInfo orgUnitInfo, Map map) {
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLevel(orgUnitInfo.getLevel());
        String longNumber = orgUnitInfo.getLongNumber();
        expandInfo.setLongNumber(longNumber);
        if (map.get(longNumber) != null) {
            expandInfo.setLeaf(false);
        } else {
            expandInfo.setLeaf(true);
        }
        return expandInfo;
    }

    protected Map dealWithOrgUnit(CostCenterOrgUnitInfo[] array) {
        Map map;
        if (!this.compareArray(array)) {
            return this.CACHE_MAP;
        }
        this.CACHE_MAP = map = AnalysisColumnTool.dealWithOrgUnit((OrgUnitInfo[])array);
        return map;
    }

    private boolean compareArray(CostCenterOrgUnitInfo[] newAry) {
        if (CACHE_ARY == null) {
            CACHE_ARY = newAry;
            return true;
        }
        if (newAry.length != CACHE_ARY.length) {
            return false;
        }
        List<CostCenterOrgUnitInfo> list = Arrays.asList(CACHE_ARY);
        for (CostCenterOrgUnitInfo tempInfo : newAry) {
            if (list.contains(tempInfo)) continue;
            return false;
        }
        return true;
    }

    protected String getQueryMainName() {
        return NewBgCompareAndAnalysisMainUI.class.getName();
    }

    public void actionViewAdjustValue_actionPerformed(ActionEvent e) throws Exception {
        String[] conditionAry = this.getQueryConditions();
        NewBgCompareAndAnalysisFilterParam filterParams = this.getFilterUIParams();
        List list = BgCompareAndAnalysisFacadeFactory.getRemoteInstance().getBudgetViewValueList(filterParams, conditionAry[0], conditionAry[1]);
        if (list == null) {
            return;
        }
        this.createViewUI(list, "budget", conditionAry[1]);
    }

    public void actionViewActualValue_actionPerformed(ActionEvent e) throws Exception {
        String[] conditionAry = this.getQueryActualConditions();
        NewBgCompareAndAnalysisFilterParam filterParams = this.getFilterUIParams();
        this.showDialogWindow((IUIObject)this, conditionAry[0], conditionAry[1], conditionAry[2], filterParams);
    }

    protected String[] getQueryActualConditions() {
        NumberExpandInfo expandInfo;
        Sheet sheet = this.sc.getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        if (range == null || range.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PleaseSelect"));
            SysUtil.abort();
        }
        CellBlock block = (CellBlock)range.getAt(0);
        int beginRowIndex = block.getRow();
        String orgUnitID = null;
        String orgUnitName = null;
        String formula = this.searchFormulaBySelectedBlock(sheet, block, beginRowIndex);
        if (formula == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectedRowWithNoFormula"));
            SysUtil.abort();
        }
        if ((expandInfo = BgNFCHelper.getNumberExpandInfo(sheet.getCell(beginRowIndex, 0, false))) == null) {
            orgUnitID = (String)sheet.getCell(beginRowIndex, 0, false).getUserObjectValue("orgUnitId");
            orgUnitName = (String)sheet.getCell(beginRowIndex, 0, false).getUserObjectValue("orgUnitName");
        }
        if (expandInfo != null) {
            orgUnitID = expandInfo.getId();
            orgUnitName = expandInfo.getName();
        }
        if (orgUnitID == null && formula == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectedRowWithNoFormula"));
            SysUtil.abort();
        }
        return new String[]{orgUnitID, orgUnitName, formula};
    }

    public void showDialogWindow(IUIObject ui, String orgId, String orgName, String formula, NewBgCompareAndAnalysisFilterParam param) throws Exception {
        BgTraceFilterParam traceParam = new BgTraceFilterParam();
        String[] ary = null;
        OrgUnitInfo info = new OrgUnitInfo();
        if (orgId == null) {
            ary = formula.split("&");
            if (ary.length < 2) {
                return;
            }
            info.setNumber(ary[1]);
            formula = ary[0];
        } else {
            info.setName(orgName);
            info.setId(BOSUuid.read((String)orgId));
        }
        traceParam.setOrgUnitInfoAry(new OrgUnitInfo[]{info});
        String bgSchemeID = param.getBgSchemeInfo().getId().toString();
        traceParam.setBgSchemeId(bgSchemeID);
        Sheet sheet = this.sc.getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        if (range == null || range.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PleaseSelect"));
            SysUtil.abort();
        }
        CellBlock block = (CellBlock)range.getAt(0);
        int col = block.getCol();
        Column column = sheet.getColumn(col, false);
        boolean isShowDict = false;
        if (column != null && BgNFSHelper.getColObject(column, COL_KEY) != null) {
            String colName = (String)BgNFSHelper.getColObject(column, COL_KEY);
            if (colName.equals("col0")) {
                isShowDict = true;
                traceParam.setBeginPeriod(param.getBeginPeriod());
                traceParam.setEndPeriod(param.getEndPeriod());
            } else {
                SysUtil.abort();
            }
        } else {
            SysUtil.abort();
        }
        List idList = BgRptFacadeFactory.getRemoteInstance().getBgDataIDByFormula(traceParam, formula);
        String uiName = BgTraceMainUI.class.getName();
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"filterParam", (Object)traceParam);
        uiContext.put((Object)"isDirectShow", (Object)new Boolean(true));
        uiContext.put((Object)"isDirectShowNotExecute", (Object)new Boolean(isShowDict));
        uiContext.put((Object)"bgDataIDList", (Object)idList);
        uiContext.put((Object)"formula", (Object)formula);
        BgFormColumnAnalyseMainUI.isNeedToDelOldWin(uiContext, uiName);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public static boolean isNeedToDelOldWin(UIContext uiContext, String uiName) throws UIException {
        Frame frame = UIFactoryHelper.getMainFrame((Map)uiContext);
        NewWinMainUI mainUI = ((NewMainFrame)frame).getMainUI();
        IUIObject uiObject = mainUI.getUiManager().findUIObject(uiName, (Map)uiContext, null, OprtState.VIEW);
        if (uiObject != null) {
            uiObject.getUIWindow().close();
            return true;
        }
        return false;
    }

    private void createViewUI(List recordList, String flag, String formula) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", (Object)this);
        ctx.put("records", recordList);
        ctx.put("formula", formula);
        String uiClassName = null;
        if (flag.equals("actual")) {
            uiClassName = BgViewActualCtrlUI.class.getName();
        } else if (flag.equals("budget")) {
            uiClassName = BgViewBudgetCtrlUI.class.getName();
        }
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(uiClassName, ctx);
            messageDialog.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected String[] getQueryConditions() {
        int beginRowIndex;
        CellBlock block;
        String formula;
        Sheet sheet = this.sc.getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        if (range == null || range.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PleaseSelect"));
            SysUtil.abort();
        }
        if ((formula = this.searchFormulaBySelectedBlock(sheet, block = (CellBlock)range.getAt(0), beginRowIndex = block.getRow())) == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectedRowWithNoFormula"));
            SysUtil.abort();
        }
        String orgUnitID = null;
        NumberExpandInfo expandInfo = BgNFCHelper.getNumberExpandInfo(sheet.getCell(beginRowIndex, 0, false));
        if (expandInfo != null) {
            orgUnitID = expandInfo.getId();
        } else if (sheet.getCell(beginRowIndex, 0, false) != null) {
            orgUnitID = (String)sheet.getCell(beginRowIndex, 0, false).getUserObjectValue("orgUnitId");
        }
        if (orgUnitID == null && formula == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectedRowWithNoFormula"));
            SysUtil.abort();
        }
        return new String[]{orgUnitID, formula};
    }

    private String getFormulaFromSelectedBlock(Sheet sheet, CellBlock block, int rowIndex) {
        int beginColIndex = block.getCol();
        String rtnBgItem = null;
        Cell cell = sheet.getCell(rowIndex, beginColIndex, false);
        String bgItem = BgNFSHelper.getFormulaOfCell(cell);
        if (bgItem != null && !"".equals(bgItem)) {
            rtnBgItem = bgItem;
        }
        return rtnBgItem;
    }

    private String searchFormulaBySelectedBlock(Sheet sheet, CellBlock block, int rowIndex) {
        int beginColIndex;
        int i;
        String rtnBgItem = this.getFormulaFromSelectedBlock(sheet, block, rowIndex);
        if (rtnBgItem != null) {
            return rtnBgItem;
        }
        for (i = beginColIndex = block.getCol(); i >= 0; --i) {
            String transFormedBgItem;
            Column col = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject(col, NEW_ANALYSIS_COL_KEY);
            if (!ANALYSIS_FLAG.equals(colKey)) continue;
            Cell cell = sheet.getCell(rowIndex, i, false);
            String bgItem = BgNFSHelper.getFormulaOfCell(cell);
            String bgFormula = BgNFSHelper.getExpression(cell);
            if (bgItem != null && !"".equals(bgItem)) {
                rtnBgItem = bgItem;
                break;
            }
            if (bgFormula == null || "".equals(bgFormula) || "".equals(transFormedBgItem = AnalysisColumnTool.changeBgFormulaToBgItem((String)bgFormula))) continue;
            String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray((String)transFormedBgItem);
            rtnBgItem = transFormedBgItem + "&" + bgFormulaAry[0];
            break;
        }
        if (rtnBgItem == null) {
            int num = sheet.getMaxColIndex() + 1;
            for (i = beginColIndex; i < num; ++i) {
                Cell cell = sheet.getCell(rowIndex, i, false);
                String bgItem = BgNFSHelper.getFormulaOfCell(cell);
                if (bgItem == null || "".equals(bgItem)) continue;
                rtnBgItem = bgItem;
                break;
            }
        }
        return rtnBgItem;
    }

    public void setUITitle(String title) {
        title = EASResource.getString((String)resourcePath, (String)"BgCompareAndAnalysisTitle");
        super.setUITitle(title);
    }

    public void allFormView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void cellFormCollectionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void setFilter2UI(NewBgCompareAndAnaylsisFilter2UI filter2UI) {
        this.filter2UI = filter2UI;
    }

    protected void setFilterUI(NewBgCompareAndAnalysisFilterUI filterUI) {
        this.filterUI = filterUI;
    }

    protected boolean hasSpreadContext() {
        return true;
    }

    protected SpreadContext getSpreadContext() {
        return this.getSc();
    }

    protected SpreadContext getSc() {
        return this.sc;
    }

    protected void setSc(SpreadContext sc) {
        this.sc = sc;
    }

    public static void setAllNumberRightA(Sheet sheet) {
        Row row = null;
        Cell cell = null;
        int ColCount = sheet.getMaxColIndex() + 1;
        int rowCount = sheet.getMaxRowIndex() + 1;
        String valueStr = null;
        for (int i = 0; i < rowCount; ++i) {
            row = sheet.getRow(i, false);
            if (row == null || row.getUserObject(THIS_ROW_HAS_DAIL_NUMBER_FORMAT) != null && row.getUserObjectValue(THIS_ROW_HAS_DAIL_NUMBER_FORMAT) != null && row.getUserObjectValue(THIS_ROW_HAS_DAIL_NUMBER_FORMAT) instanceof Boolean && ((Boolean)row.getUserObjectValue(THIS_ROW_HAS_DAIL_NUMBER_FORMAT)).booleanValue()) continue;
            for (int j = 0; j < ColCount; ++j) {
                cell = row.getCell(j, false);
                if (cell == null || cell.getValue() == null) continue;
                valueStr = cell.getValue().toString();
                valueStr = valueStr.replaceAll(",", "");
                valueStr = valueStr.replaceAll("%", "");
                try {
                    new BigDecimal(valueStr);
                    StyleAttributes sa = Styles.getEmptySA();
                    StyleAttributes saInnerBorder = Styles.getEmptySA();
                    sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    sheet.getRange(cell).setStyle(sa, saInnerBorder);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            row.setUserObject(THIS_ROW_HAS_DAIL_NUMBER_FORMAT, (Object)Boolean.TRUE);
        }
    }

    public FilterParam getFilterParam() {
        return this.defaultFilterParam;
    }

    private class MyTableMouseController
    extends TableMouseController {
        public MyTableMouseController(SpreadContext context) {
            super(context);
        }

        public void mouseClicked(MouseEvent e) {
            Sheet activeSheet = BgFormColumnAnalyseMainUI.this.sc.getBook().getActiveSheet();
            Cell cell = activeSheet.getActiveCell();
            if (BgFormColumnAnalyseMainUI.this.render != null && cell != null) {
                OrgUnitRender.NumberExpendRender numRender = (OrgUnitRender.NumberExpendRender)BgFormColumnAnalyseMainUI.this.render.getRender(cell, -1);
                if (numRender == null) {
                    return;
                }
                NumberExpandInfo numberExpandInfo = BgNFCHelper.getNumberExpandInfo(cell);
                if (numberExpandInfo != null && numRender.inRect(numberExpandInfo, e.getX(), e.getY())) {
                    BgFormColumnAnalyseMainUI.this.setTreeDisplayStyle(cell, numberExpandInfo, activeSheet);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            BgFormColumnAnalyseMainUI.this.sc.getSpread().repaint();
        }
    }
}

