/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.nbudget.SheetInfo;
import com.kingdee.eas.ma.nbudget.client.AbstractBgFormSheetUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BgFormSheetUI
extends AbstractBgFormSheetUI {
    private static final long serialVersionUID = 5528644420625653065L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormSheetUI.class);
    private IBgForm ibgForm = null;
    private String bgFormId = null;
    private String bgFormName = null;
    private boolean isCanceled = false;
    private SheetInfo[] sheetsInfo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblSheet.checkParsed();
        this.tblSheet.getSelectManager().setSelectMode(2);
        this.tblSheet.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblSheet.getColumn(1).getStyleAttributes().setHided(true);
        this.tblSheet.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblSheet.getColumn(2).getStyleAttributes().setHided(true);
        this.tblSheet.getColumn(3).getStyleAttributes().setLocked(true);
        Object obj = this.getUIContext().get("BGFORM_ID");
        if (obj != null) {
            this.bgFormId = obj.toString();
            this.bgFormName = (String)this.getUIContext().get("BGFORM_NAME");
            List sheets = null;
            String[] sheetStr2 = null;
            SheetInfo sheetInfo2 = null;
            SheetInfo[] sheetsInfo = null;
            IRow row = null;
            try {
                obj = this.getUIContext().get("BGFORM_SHEET");
                if (obj == null) {
                    sheets = this.getInterface().getSheetName(this.bgFormId);
                    if (sheets != null && !sheets.isEmpty()) {
                        for (String[] sheetStr2 : sheets) {
                            sheetInfo2 = new SheetInfo();
                            sheetInfo2.setBgFormId(this.bgFormId);
                            sheetInfo2.setSheetId(sheetStr2[0]);
                            sheetInfo2.setSheetName(sheetStr2[1]);
                            row = this.tblSheet.addRow();
                            row.getCell(0).setValue((Object)Boolean.FALSE);
                            row.getCell(1).setValue((Object)this.bgFormName);
                            row.getCell(2).setValue((Object)sheetInfo2.getSheetId());
                            row.getCell(3).setValue((Object)sheetInfo2.getSheetName());
                        }
                    }
                } else {
                    for (SheetInfo sheetInfo2 : (SheetInfo[])obj) {
                        row = this.tblSheet.addRow();
                        row.getCell(0).setValue((Object)Boolean.FALSE);
                        row.getCell(1).setValue((Object)this.bgFormName);
                        row.getCell(2).setValue((Object)sheetInfo2.getSheetId());
                        row.getCell(3).setValue((Object)sheetInfo2.getSheetName());
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handUIException(ex);
            }
        }
    }

    protected IBgForm getInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnSubmit_actionPerformed(e);
        IRow row = null;
        SheetInfo sheetInfo = null;
        ArrayList<SheetInfo> resultList = new ArrayList<SheetInfo>();
        int in = this.tblSheet.getRowCount();
        for (i = 0; i < in; ++i) {
            row = this.tblSheet.getRow(i);
            if (!row.getCell(0).getValue().equals(Boolean.TRUE)) continue;
            sheetInfo = new SheetInfo();
            sheetInfo.setBgFormId(this.bgFormId);
            sheetInfo.setSheetId(row.getCell(2).getValue().toString());
            sheetInfo.setSheetName(row.getCell(3).getValue().toString());
            resultList.add(sheetInfo);
        }
        if (resultList.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("selectSheet"));
        } else {
            this.sheetsInfo = new SheetInfo[resultList.size()];
            in = resultList.size();
            for (i = 0; i < in; ++i) {
                this.sheetsInfo[i] = (SheetInfo)resultList.get(i);
            }
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public void setBgFormId(String bgFormId) {
        this.bgFormId = bgFormId;
    }

    public void setBgFormName(String bgFormName) {
        this.bgFormName = bgFormName;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Object getData() {
        return this.sheetsInfo;
    }
}

