/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.ICellEditorProvider;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ModifyManager;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.framework.client.mutex.VOChangeEvent;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.client.BgEnumerateRender;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.ErrorBudgetItemListUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgCourseException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.BgSpecialFormDisplayValueProvider;
import com.kingdee.eas.ma.nbudget.IBgNFFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgFormSpecialEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNCWfHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNumberCellTextEditor;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.BgUserCellDisplayProvider;
import com.kingdee.eas.ma.nbudget.client.BudgetCourseProvider;
import com.kingdee.eas.ma.nbudget.client.IBgCellValueProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgFormSpecialEditUI
extends AbstractBgFormSpecialEditUI
implements IBgCellValueProvider {
    private static final long serialVersionUID = 8153327843568892878L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormSpecialEditUI.class);
    KDPanel panel = null;
    private Map bgFormMap = null;
    private BgSpecialFormDisplayValueProvider cellProvider = null;
    private Map currencyMap = null;
    private Map measureUnitMap = null;
    private Map formulaMap = null;
    private BgFormInfo currentFormInfo = null;
    private Book _book = null;
    private boolean isRequestNetControl = false;
    private BgItemInfo selectedInfo = null;
    private boolean isCancel = false;
    private ICellEditor editor = null;
    private String orgUnitId = null;
    private boolean isAutoCalcTag = false;
    private SpreadManager spreadManager = null;
    private boolean calcBeforeSave = false;
    private boolean calcWhenOpen = false;
    private boolean isLockedOfOpen = false;
    private ProgressDialog progressDialog;
    private TimeMark mk = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.calcBeforeSave = BgNSHelper.isCalculateOfUpdate();
        this.calcWhenOpen = BgNSHelper.isCalculateOfAddNew();
        this.isLockedOfOpen = BgParamCHelper.isLockedOfOpen();
        this.initBaseData();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.calcBeforeSave) {
            this.calcForSave();
        } else {
            this.saveBgValue();
        }
        this.currentFormInfo.setBook(this._book);
        BgNFSHelper.setBudget((IObjectValue)this.currentFormInfo);
        this.getBgFormInterface().save((CoreBaseInfo)this.currentFormInfo);
        StringBuffer sql = new StringBuffer("update T_BG_BgForm set FSTATE='1' where fid in ( ");
        int in = 1;
        boolean boo = false;
        if (this.bgFormMap != null) {
            BgFormInfo info = null;
            Iterator it = this.bgFormMap.keySet().iterator();
            while (it.hasNext()) {
                info = (BgFormInfo)this.bgFormMap.get(it.next());
                boo = !info.getId().equals((Object)this.currentFormInfo.getId()) && info.getState().getValue() == 42;
                if (!boo) continue;
                if (in >= 2) {
                    sql.append(",");
                }
                sql.append("'" + info.getId() + "'");
                ++in;
            }
        }
        sql.append(" )");
        if (in >= 2) {
            IFMIsqlFacade isql = FMIsqlFacadeFactory.getRemoteInstance();
            isql.executeSql(sql.toString());
        }
        this.getModifyManager().discardAllEdits();
        this.setMessageText(SHOW_MESSAGE_TEXT_OK);
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)this.getMessageFile(), (String)key) : "";
    }

    protected String getMessageStr(String sourceStr, String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key) : "";
    }

    protected String getMessageFile() {
        return "com.kingdee.eas.ma.nbudget.client.BgNFormResource";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calcForSave() {
        Map _formulaMap = BgNFSHelper.getFormulaMapOfBook(this.getBook(), this.getBgFormInfo().getOrgUnit().getId().toString(), this.getBgFormInfo().getBgScheme().getId().toString());
        BgNFSHelper.setFormulaMap(this.getBgFormInfo(), _formulaMap);
        logger.info((Object)"begin calculate...");
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog != null) {
            dialog.setTitle(this.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "calculate"));
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    try {
                        BgFormSpecialEditUI.this.getBook().setSkipListeners(true);
                        BgFormSpecialEditUI.this.getBook().calc();
                        BgFormSpecialEditUI.this.saveBgValue();
                    }
                    finally {
                        BgFormSpecialEditUI.this.getBook().setSkipListeners(false);
                        BgFormSpecialEditUI.this.getSpreadManager().getSpreadContainer().repaint();
                    }
                    return null;
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            dialog.show();
        } else {
            try {
                this.getBook().setSkipListeners(true);
                this.getBook().calc();
                this.saveBgValue();
            }
            finally {
                this.getBook().setSkipListeners(false);
                this.getSpreadManager().getSpreadContainer().repaint();
            }
        }
        logger.info((Object)"end calculate!");
        _formulaMap.clear();
        BgNFSHelper.clearFormulaMap(this.getBgFormInfo());
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int re;
        String bgFormStr = this.currentFormInfo.getId().toString();
        final BOSUuid bgFormId = this.currentFormInfo.getId();
        this.checkCanSingleRefer(bgFormStr);
        Object obj = this.getUIContext().get("Owner");
        if (obj != null && !(obj instanceof MessageCenterUI) && BgFormHelper.checkInProInst((String)bgFormStr)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"bgFormInWorkNoSubmit"));
            SysUtil.abort();
        }
        if (this.isModify()) {
            this.actionSave_actionPerformed(e);
        }
        if (BgParamCHelper.isFodian()) {
            Vector result = this.getFacadeInterface().checkMonthBudget(false, bgFormId, null);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"monthItem", (Object)result);
            if (result != null && result.size() != 0) {
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ErrorBudgetItemListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                boolean isContinue = ((ErrorBudgetItemListUI)uiWindow.getUIObject()).isContinue();
                if (!isContinue) {
                    SysUtil.abort();
                }
            }
        }
        if ((re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormWork"))) == 1 || re == 2) {
            return;
        }
        if (BgParamCHelper.isCompulsionReportCheck() && !this.checkReport(bgFormStr)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"cantSubmitOfCheck"));
            SysUtil.abort();
        }
        if (this.getExamineInterface().canExamine(new BOSUuid[]{bgFormId})) {
            final String xNum = BgNFCHelper.returnExamineX(new BOSUuid[]{bgFormId}, this);
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    Object[] result = BgFormSpecialEditUI.this.getExamineInterface().examines(new BOSUuid[]{bgFormId}, xNum);
                    HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                    bgExamineCheckMap.put("BgExamineChecked", result[0]);
                    bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                    return bgExamineCheckMap;
                }

                public void afterExec(Object result) throws Exception {
                    if (result != null && result instanceof HashMap) {
                        BgFormSpecialEditUI.this.openBgExamineViewUI(result);
                        Map bgExamineCheckMap = (Map)result;
                        Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                        if (bgExCheck.booleanValue()) {
                            boolean flag = !BgNCWfHelper.isNextPersonSubmit() ? BgFormSpecialEditUI.this.getFacadeInterface().submitFormWork(bgFormId) : BgNCWfHelper.submitFormWork(bgFormId, BgFormSpecialEditUI.this, BgFormSpecialEditUI.this.getFacadeInterface(), (ICoreBase)BgFormSpecialEditUI.this.getBgFormInterface());
                            if (flag) {
                                if (xNum != null) {
                                    BgFormSpecialEditUI.this.getBgFormInterface().saveXNum(new BOSUuid[]{bgFormId}, xNum);
                                }
                                BgFormSpecialEditUI.this.setMessageText(BgFormSpecialEditUI.this.getBgFormInfo().getName() + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormSucceed"));
                            } else {
                                BgFormSpecialEditUI.this.setMessageText(BgFormSpecialEditUI.this.getBgFormInfo().getName() + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormDefeat"));
                            }
                            BgFormSpecialEditUI.this.showMessage();
                            boolean canEdit = 1 == BgFormSpecialEditUI.this.currentFormInfo.getState().getValue() && BgFormSpecialEditUI.this.isRequestNetControl && !BgFormHelper.checkInProInst((String)BgFormSpecialEditUI.this.currentFormInfo.getId().toString());
                            BgFormSpecialEditUI.this.btnSave.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.btnSubmit.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.btnCalc.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.btnLock.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.btnUnLock.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.menuItemSave.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.menuItemSubmit.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.menuItemCalc.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.menuItemLock.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.menuUnLock.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.menuItemCalcSelectSheet.setEnabled(canEdit);
                            BgFormSpecialEditUI.this.btnCalcSelectSheet.setEnabled(canEdit);
                            if (canEdit) {
                                BgFormSpecialEditUI.this.setOprtState(OprtState.EDIT);
                            } else {
                                BgFormSpecialEditUI.this.setOprtState(OprtState.VIEW);
                                BgFormSpecialEditUI.this.releaseNetControl();
                            }
                        } else {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"cantsubmit"));
                        }
                    } else {
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                    }
                }
            });
            dialog.show();
        } else {
            boolean flag = !BgNCWfHelper.isNextPersonSubmit() ? this.getFacadeInterface().submitFormWork(bgFormId) : BgNCWfHelper.submitFormWork(bgFormId, this, this.getFacadeInterface(), (ICoreBase)this.getBgFormInterface());
            if (flag) {
                this.setMessageText(this.getBgFormInfo().getName() + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormSucceed"));
            } else {
                this.setMessageText(this.getBgFormInfo().getName() + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormDefeat"));
            }
            this.showMessage();
            boolean canEdit = 1 == this.currentFormInfo.getState().getValue() && this.isRequestNetControl && !BgFormHelper.checkInProInst((String)this.currentFormInfo.getId().toString());
            this.btnSave.setEnabled(canEdit);
            this.btnSubmit.setEnabled(canEdit);
            this.btnCalc.setEnabled(canEdit);
            this.btnLock.setEnabled(canEdit);
            this.btnUnLock.setEnabled(canEdit);
            this.menuItemSave.setEnabled(canEdit);
            this.menuItemSubmit.setEnabled(canEdit);
            this.menuItemCalc.setEnabled(canEdit);
            this.menuItemLock.setEnabled(canEdit);
            this.menuUnLock.setEnabled(canEdit);
            this.menuItemCalcSelectSheet.setEnabled(canEdit);
            this.btnCalcSelectSheet.setEnabled(canEdit);
            if (canEdit) {
                this.setOprtState(OprtState.EDIT);
            } else {
                this.setOprtState(OprtState.VIEW);
                this.releaseNetControl();
            }
        }
    }

    @Override
    public void actionCalcSelectSheet_actionPerformed(ActionEvent e) throws Exception {
        int i;
        boolean oldstate = this.getBook().isAutoCalculate();
        for (i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setEnableCalculation(false);
        }
        this.getBook().getActiveSheet().setEnableCalculation(true);
        this.calculate();
        for (i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setEnableCalculation(true);
        }
        this.getSpreadContext().repaint();
        this.getBook().setCalculate(oldstate);
    }

    @Override
    public void actionCalc_actionPerformed(ActionEvent e) throws Exception {
        boolean oldstate = this.getBook().isAutoCalculate();
        this.getBook().setCalculate(true);
        this.calculate();
        this.getSpreadContext().repaint();
        this.getBook().setCalculate(oldstate);
    }

    @Override
    public void actionLock_actionPerformed(ActionEvent e) throws Exception {
        Range r = this.getSpreadContext().getRangeManager().getSelectionRange();
        r.setIgnoreProtected(true);
        r.setCellLocked(true);
    }

    @Override
    public void actionUnLock_actionPerformed(ActionEvent e) throws Exception {
        this.beforeUnLockCell();
        Range r = this.getSpreadContext().getRangeManager().getSelectionRange();
        r.setIgnoreProtected(true);
        r.setCellLocked(false);
    }

    @Override
    public void comItemSelect_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2) {
            return;
        }
        boolean save = this.saveCurrentData(false);
        if (this.isCancel) {
            this.isCancel = false;
            return;
        }
        if (!save) {
            this.isCancel = true;
            this.comItemSelect.setSelectedItem((Object)this.selectedInfo);
            return;
        }
        this.selectedInfo = (BgItemInfo)this.comItemSelect.getSelectedItem();
        this.clearAll();
        this.processData();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnCalc.setIcon(EASResource.getIcon((String)"imgTbtn_autocount"));
        this.btnUnLock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnLock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemCalc.setIcon(EASResource.getIcon((String)"imgTbtn_autocount"));
        this.menuItemLock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.menuUnLock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnCalcSelectSheet.setIcon(EASResource.getIcon((String)"imgTbtn_manualcount"));
        this.menuItemCalcSelectSheet.setIcon(EASResource.getIcon((String)"imgTbtn_manualcount"));
        this.menuEdit.setVisible(false);
    }

    private void initBaseData() throws Exception {
        this.panel = new KDPanel();
        this.panel.setLayout((LayoutManager)new BorderLayout());
        this.cellProvider = new BgSpecialFormDisplayValueProvider((Component)((Object)this));
        this.spreadManager = SpreadManager.getInstance();
        this.getSpreadContext().getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)this.getCellDisplayRender());
        this.panel.add((Component)this.getSpreadContext(), (Object)"Center");
        this.initCurrencyInfo();
        String id = (String)this.getUIContext().get("ID");
        this.bgFormMap = this.getNFFacadeInterface().getAllBgFormByID(id);
        ItemListener[] listeners = this.comItemSelect.getItemListeners();
        this.removeListeners(listeners);
        BgItemCollection bgItemCol = new BgItemCollection();
        if (this.bgFormMap != null) {
            BgFormInfo info = null;
            Iterator it = this.bgFormMap.keySet().iterator();
            while (it.hasNext()) {
                info = (BgFormInfo)this.bgFormMap.get(it.next());
                bgItemCol.add(info.getBgItem());
                if (!id.equals(info.getId().toString())) continue;
                this.selectedInfo = info.getBgItem();
            }
        }
        BgHelper.sortCollection((AbstractObjectCollection)bgItemCol, (String[])new String[]{"number"}, (boolean)true);
        this.comItemSelect.addItems(bgItemCol.toArray());
        this.comItemSelect.setSelectedItem((Object)this.selectedInfo);
        this.formulaMap = new HashMap();
        this.getSpreadContext().addSheetChangeListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                if (e.hasState(SheetChangeEvent.Changed_Content)) {
                    try {
                        BgFormSpecialEditUI.this.cell_Content_Changed(e);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                        BgFormSpecialEditUI.this.handleException(ex);
                    }
                }
                if (e.hasState(SheetChangeEvent.Changed_Selection) || e.hasState(SheetChangeEvent.Changed_SelectionActive)) {
                    try {
                        BgFormSpecialEditUI.this.cell_Selection_Changed(e);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                        BgFormSpecialEditUI.this.handleException(ex);
                    }
                }
            }
        });
        this.getSpreadContext().getEditManager().setEditorProvider(new ICellEditorProvider(){

            public ICellEditor getEditor(Sheet sheet, int row, int col) {
                BgFormSpecialEditUI.this.editor = (ICellEditor)new BgNumberCellTextEditor(BgFormSpecialEditUI.this);
                return BgFormSpecialEditUI.this.editor;
            }
        });
        this.processData();
        this.addListeners(listeners);
    }

    private void removeListeners(ItemListener[] listeners) {
        if (listeners != null && listeners.length > 0) {
            for (int i = 0; i < listeners.length; ++i) {
                this.comItemSelect.removeItemListener(listeners[i]);
            }
        }
    }

    private void addListeners(ItemListener[] listeners) {
        if (listeners != null && listeners.length > 0) {
            for (int i = 0; i < listeners.length; ++i) {
                this.comItemSelect.addItemListener(listeners[i]);
            }
        }
    }

    protected void cell_Content_Changed(SheetChangeEvent e) throws Exception {
        if (this.isAutoCalcTag) {
            this.saveBgValue();
        } else if (e.getChangedBlocks() != null && e.getSheet() != null) {
            Sheet _sheet = null;
            Cell _cell = null;
            CellBlock _block = null;
            SortedCellBlockArray _blocks = null;
            _sheet = e.getSheet();
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            _blocks = e.getChangedBlocks();
            int size = _blocks.size();
            for (int index = 0; index < size; ++index) {
                _block = _blocks.getBlock(index);
                if (_block == null) continue;
                int rowBegin = _block.getRow();
                int rowEnd = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                int colBegin = _block.getCol();
                int colEnd = _block.getCol2() > colCount ? colCount : _block.getCol2();
                for (int rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                    for (int colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        this.updateCellChangeValueInfo(_cell);
                    }
                }
            }
        }
    }

    protected void lockExprCell() {
        Sheet _sheet = null;
        Cell _cell = null;
        boolean hasCertificate = false;
        int count = this.getBook().getSheetCount();
        for (int sheetIndex = 0; sheetIndex < count; ++sheetIndex) {
            _sheet = this.getBook().getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell == null) continue;
                    if (this.isLockedOfOpen && BgNFSHelper.checkHasExpression(_cell)) {
                        BgNFSHelper.setCellLocked(_cell, true);
                        continue;
                    }
                    if (hasCertificate) {
                        if (_cell.isLocked()) continue;
                        BgNFSHelper.setCellLocked(_cell, true);
                        continue;
                    }
                    if (!_cell.isLocked()) continue;
                    BgNFSHelper.setCellLocked(_cell, false);
                }
            }
        }
    }

    protected void saveBgValue() {
        Sheet _sheet = null;
        Cell _cell = null;
        int count = this.getBook().getSheetCount();
        for (int sheetIndex = 0; sheetIndex < count; ++sheetIndex) {
            _sheet = this.getBook().getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    this.updateCellChangeValueInfo(_cell);
                }
            }
        }
    }

    private void updateCellChangeValueInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            Object _obj = null;
            BigDecimal _newValue = null;
            _obj = BgNFSHelper.getValue(cell);
            if (_obj instanceof BigDecimal) {
                _newValue = (BigDecimal)_obj;
            } else {
                try {
                    _newValue = new BigDecimal(_obj.toString());
                }
                catch (Exception ex) {
                    BgNFSHelper.setValue(cell, BgNConstants.ZERO);
                    _newValue = BgNConstants.ZERO;
                }
            }
            BgNFSHelper.setBudgetValue(cell, _newValue);
        }
    }

    protected void cell_Selection_Changed(SheetChangeEvent e) throws Exception {
        if (e.getChangedBlocks() != null && e.getSheet() != null) {
            e.hasState(SheetChangeEvent.Changed_SelectionActive);
            Sheet _sheet = e.getSheet();
            Cell _cell = null;
            CellBlock _block = null;
            SortedCellBlockArray _blocks = null;
            String _formulaStr = null;
            String _tmpFormulaStr = null;
            boolean isEnabled = true;
            isEnabled = false;
            String companyNumber = BgNExpressionHelper.getCompanyNumber(null, (IObjectValue)this.currentFormInfo);
            _blocks = e.getChangedBlocks();
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            int size = _blocks.size();
            for (int index = 0; index < size; ++index) {
                _block = _blocks.getBlock(index);
                int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
                int rowEnd = maxRow;
                for (int rowBegin = _block.getRow(); rowBegin <= rowEnd; ++rowBegin) {
                    int colEnd = maxCol;
                    for (int colBegin = _block.getCol(); colBegin <= colEnd; ++colBegin) {
                        _cell = _sheet.getCell(rowBegin, colBegin, false);
                        if ((BgNFSHelper.checkHasBgItemInfo(_cell) || BgNFSHelper.checkHasBgPeriodInfo(_cell) || BgNFSHelper.checkHasBgElementInfo(_cell) || BgNFSHelper.checkHasCurrencyInfo(_cell) || BgNFSHelper.checkHasLinked(_cell)) && !BgNFSHelper.checkHasTextOfCell(_cell)) {
                            BgNFSHelper.setNumberFormat(_cell, "@");
                        }
                        if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                            _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                            _tmpFormulaStr = BgNFSHelper.checkFormula(this.getFormulaMap(), _formulaStr, (IObjectValue)this.currentFormInfo);
                            if (StringUtils.isEmpty((String)_formulaStr)) {
                                throw new BgException(BgException.BGITEMPARSEERROR, (Object[])new String[]{_formulaStr});
                            }
                            if (!_formulaStr.equals(_tmpFormulaStr)) {
                                BgNFSHelper.setFormulaOfCell(_cell, _tmpFormulaStr);
                            }
                            if (isEnabled && !BgNFSHelper.checkCanEditFormulaOfCell(_cell)) {
                                isEnabled = false;
                            }
                        }
                        if (!BgNFSHelper.checkHasExpression(_cell)) continue;
                        BgNFSHelper.checkExpression(_cell, (IObjectValue)this.currentFormInfo, companyNumber);
                    }
                }
            }
        }
    }

    protected void initCurrencyInfo() throws Exception {
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = this.getCurrencyInterface().getCurrencyCollection();
        if (currencyCol != null && !currencyCol.isEmpty()) {
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                this.getCurrencyMap().put(currencyInfo2.getNumber(), currencyInfo2);
            }
        }
    }

    protected void initMeasureUnitInfo() throws Exception {
        this.measureUnitMap = BgNFSHelper.getMeasureUnitMap(this.getBgFormInfo());
    }

    private Book getBook() {
        if (this._book == null) {
            try {
                this._book = this.currentFormInfo.getBook();
                this._book.getUndoManager().enable(true);
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        return this._book;
    }

    public SelectorItemCollection getSelectors() {
        return BgNFSHelper.getSelectors();
    }

    protected BgUserCellDisplayProvider getCellDisplayRender() {
        BgUserCellDisplayProvider render = new BgUserCellDisplayProvider();
        render.setDisplayValueProvider(this.cellProvider);
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new DefaultItemRenderProvider());
        BgUserCellDisplayProvider.addRenderProvider(new BudgetCourseProvider());
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new BgEnumerateRender());
        return render;
    }

    protected KDTabbedPane getMainTabPane() {
        return this.TabPaneMain;
    }

    @Override
    public Map getMeasureUnitMap() {
        return this.measureUnitMap;
    }

    public Map getCurrencyMap() {
        if (this.currencyMap == null) {
            this.currencyMap = new HashMap();
        }
        return this.currencyMap;
    }

    @Override
    public Map getFormulaMap() {
        return this.formulaMap;
    }

    public BgFormInfo getBgFormInfo() {
        return this.currentFormInfo;
    }

    private boolean processSheetPer(Book _book, String templateId) {
        Sheet _sheet = null;
        boolean isSheetPer = BgSHelper.isBgSheetPermissionUsed();
        if (!isSheetPer) {
            return true;
        }
        Map sheetPer = null;
        if (isSheetPer) {
            sheetPer = this.addBgSheetPermission(templateId);
        }
        String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        boolean isShowSheet = false;
        if (_book != null) {
            int sheetIndex = 0;
            int sheetSize = _book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                if (isSheetPer) {
                    if (!isShowSheet) {
                        isShowSheet = this.hideSheet(_sheet, sheetPer, user);
                        continue;
                    }
                    this.hideSheet(_sheet, sheetPer, user);
                    continue;
                }
                _sheet.setHide(false);
            }
        }
        return isShowSheet;
    }

    protected boolean hideSheet(Sheet _sheet, Map sheetPer, String user) {
        String sheetCreater = null;
        boolean isShowSheet = false;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign(_sheet))) {
            _sheet.setHide(false);
            isShowSheet = true;
        } else {
            sheetCreater = (String)_sheet.getUserObjectValue("SHEET_CREATER_ID");
            if (sheetCreater != null) {
                if (!sheetCreater.equals(user)) {
                    _sheet.setHide(true);
                } else {
                    _sheet.setHide(false);
                    isShowSheet = true;
                }
            } else {
                _sheet.setHide(true);
            }
        }
        return isShowSheet;
    }

    protected Map addBgSheetPermission(String templateId) {
        if (templateId == null || templateId.trim().length() == 0) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(templateId, null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission(null, hasPer);
            if (hasPer != null && hasPer.get(templateId) != null) {
                sheetPer = (Map)hasPer.get(templateId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sheetPer;
    }

    private void processData() throws Exception {
        this.loadBgFormInfo();
        this.requestNetControl();
        this.initButtonAndState();
        this.initMeasureUnitInfo();
        this.processBook();
    }

    private void processBook() throws Exception {
        int i;
        int in;
        this.isAutoCalcTag = false;
        Book _book = null;
        Sheet _sheet = null;
        _book = this.getBook();
        if (!this.processSheetPer(_book, this.currentFormInfo.getBgTemplate().getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"hasnotPermissionSheet"));
            SysUtil.abort();
        }
        Boolean autoCalculate = null;
        try {
            autoCalculate = Boolean.valueOf(this.getVariables().get("autoCalculateState", _book.getName()).getValue());
        }
        catch (Exception e) {
            autoCalculate = Boolean.FALSE;
        }
        this.isAutoCalcTag = autoCalculate;
        _book.setAutoCalculate(false);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgNFSHelper.setBookProtection(_book, true, BgNFSHelper.getBookOperation());
            in = _book.getSheetCount();
            for (i = 0; i < in; ++i) {
                _sheet = _book.getSheet(i);
                BgNFSHelper.setSheetProtection(_sheet, true, BgNFSHelper.getOnlySelectCellOperation());
            }
        } else {
            BgNFSHelper.setBookProtection(_book, true, null);
            in = _book.getSheetCount();
            for (i = 0; i < in; ++i) {
                _sheet = _book.getSheet(i);
                BgNFSHelper.setSheetProtection(_sheet, true, BgNFSHelper.getIsNotEnumerateOperation());
            }
            BgNFSHelper.setIsNotEnumerateCellLocked(_book, false);
        }
        this.getSpreadContext().setBook(_book);
        this.getSpreadContext().setName(this.currentFormInfo.getName());
        this.getMainTabPane().addTab(this.currentFormInfo.getName(), (Component)this.panel);
        int sheetCount = this.getSpreadContext().getBook().getSheetCount();
        for (i = 0; i < sheetCount; ++i) {
            _sheet = this.getSpreadContext().getBook().getSheet(i);
            if (_sheet.isHide()) continue;
            Range selectRange = _sheet.getRange(0, 0);
            selectRange.select();
            this.getSpreadContext().getSpread().scrollCellVisible(0, 0);
            break;
        }
        FormulaDefinition.registerFormulaToBook((Book)_book, (ICalculateContextProvider)new CalculateContext());
        this.getSpreadContext().getFacadeManager().setErrorMessageBox(new FacadeManager.IErrorMessageBox(){

            public boolean show(Component parent, String title, String msg, int msgType) {
                if (msgType == 2) {
                    BgFormSpecialEditUI.this.showWarningMsg(msg);
                } else if (msgType == 0) {
                    BgFormSpecialEditUI.this.showErrorMsg(msg);
                } else {
                    BgFormSpecialEditUI.this.showWarningMsg(msg);
                }
                return false;
            }
        });
        ActionManager actions = this.getSpreadContext().getActionManager();
        SpreadAction action = actions.getAction("Show_Formula_Wizzard");
        action.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("F8"));
        this.getSpreadManager().getSpreadContainer().getActionManager().getAction("Cut", true).setEnabled(false);
        this.getSpreadManager().getSpreadContainer().getActionManager().getAction("Sort_Ascending", true).setEnabled(false);
        this.getSpreadManager().getSpreadContainer().getActionManager().getAction("Sort_Descending", true).setEnabled(false);
        this.getModifyManager().discardAllEdits();
        this.getSpreadContext().repaint();
        this.getSpreadManager().registerDefaultFormulaWizard(null);
        this.getSpreadManager().registerDefaultItemFormulaWizard();
        this.getSpreadManager().setItemFormulaProvider(new IItemFormulaProvider(){

            public String getDisplayingItemFormula(Range range, int viewMode) {
                Object obj = range.getUserObject("ITEM");
                if (obj != null && obj instanceof ItemFormula) {
                    return BgFormSpecialEditUI.this.getShowBgFormula(((ItemFormula)obj).getFormula());
                }
                return null;
            }

            public String defaultItemFormula() {
                return "=BgItem()";
            }

            public boolean editable() {
                return BgFormSpecialEditUI.this.editableFormulaBar();
            }
        });
        if (this.isLockedOfOpen) {
            this.lockExprCell();
        }
        if ((autoCalculate.booleanValue() || this.calcWhenOpen) && OprtState.EDIT.equals(this.getOprtState())) {
            this.actionCalc_actionPerformed(null);
        }
        _book.setCalculate(autoCalculate.booleanValue());
    }

    protected boolean editableFormulaBar() {
        return false;
    }

    protected String getShowBgFormula(String formulaStr) {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return null;
        }
        String[] parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), formulaStr);
        if (parameter != null) {
            StringBuffer _formulaStr = new StringBuffer();
            if (parameter.length == 6) {
                _formulaStr.append("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[5] + "\")");
                return _formulaStr.toString();
            }
            if (parameter.length == 4) {
                _formulaStr.append("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\")");
                return _formulaStr.toString();
            }
        }
        return formulaStr;
    }

    public void showSuccessMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.setMessageText(msg);
        this.showMessage();
    }

    public void showWarningMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
        this.setMessageBgcolor(Color.yellow);
        this.setMessageText(msg);
        this.showMessage();
    }

    public void showErrorMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_ERROR);
        this.setMessageText(msg);
        this.showMessage();
    }

    protected void beforeUnLockCell() throws Exception {
        Sheet _sheet = null;
        Cell _cell = null;
        ArrayList _blocks = null;
        CellBlock _block = null;
        int rowBegin = 0;
        int rowEnd = 0;
        int colBegin = 0;
        int colEnd = 0;
        int rowIndex = 0;
        int colIndex = 0;
        _sheet = this.getBook().getActiveSheet();
        _blocks = _sheet.getSheetOption().getSelection().toSelectionBlocks();
        int rowCount = _sheet.getMaxRowIndex();
        int colCount = _sheet.getMaxColIndex();
        if (_blocks != null) {
            int in = _blocks.size();
            for (int i = 0; i < in; ++i) {
                _block = (CellBlock)_blocks.get(i);
                if (_block == null) continue;
                rowBegin = _block.getRow();
                rowEnd = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                colBegin = _block.getCol();
                colEnd = _block.getCol2() > colCount ? colCount : _block.getCol2();
                for (rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                    for (colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasCertificate(_cell)) continue;
                        throw new BgCourseException(BgCourseException.CHECKCERTIFICATE);
                    }
                }
            }
        }
    }

    protected ReportVariables getVariables() {
        ReportVariables v = ReportVariables.loadFromBook((Book)this.getBook());
        if (v == null) {
            v = new ReportVariables();
            v.storeToBook(this.getBook());
        }
        return v;
    }

    protected BookProperties getBookProperties() {
        BookProperties p = BookProperties.loadFromBook((Book)this.getBook());
        if (p == null) {
            p = new BookProperties();
            p.restoreToBook(this.getBook());
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveCurrentData(boolean isFromExit) throws Exception {
        if (this.isModify() && !this.isCancel) {
            String msg = null;
            msg = isFromExit ? EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"isSaveAndExit") : EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"isSave");
            int confirm3 = MsgBox.showConfirm3((String)msg);
            if (confirm3 == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                finally {
                    this.releaseNetControl();
                }
                return true;
            }
            if (confirm3 == 1) {
                this.releaseNetControl();
                return true;
            }
            if (confirm3 == 2) {
                return false;
            }
        }
        return true;
    }

    private void clearAll() {
        try {
            this._book = null;
            this.cellProvider.clearAll();
            if (this.measureUnitMap != null) {
                this.measureUnitMap.clear();
                this.measureUnitMap = null;
            }
            if (this.formulaMap != null) {
                this.formulaMap.clear();
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private void loadBgFormInfo() throws Exception {
        BgFormInfo formInfo = (BgFormInfo)this.bgFormMap.get(((BgItemInfo)this.comItemSelect.getSelectedItem()).getId().toString());
        ObjectUuidPK pk = new ObjectUuidPK(formInfo.getId());
        this.currentFormInfo = (BgFormInfo)this.getBgFormInterface().getValue((IObjectPK)pk, this.getSelectors());
        if (this.currentFormInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"loadBgFormError"));
            SysUtil.abort();
        }
    }

    private void initButtonAndState() throws BOSException, EASBizException {
        boolean canEdit = (1 == this.currentFormInfo.getState().getValue() || 42 == this.currentFormInfo.getState().getValue()) && this.isRequestNetControl && !BgFormHelper.checkInProInst((String)this.currentFormInfo.getId().toString());
        this.btnSave.setEnabled(canEdit);
        this.btnSubmit.setEnabled(canEdit);
        this.btnCalc.setEnabled(canEdit);
        this.menuItemSave.setEnabled(canEdit);
        this.menuItemSubmit.setEnabled(canEdit);
        this.menuItemCalc.setEnabled(canEdit);
        this.menuItemCalcSelectSheet.setEnabled(canEdit);
        this.btnCalcSelectSheet.setEnabled(canEdit);
        if (canEdit) {
            this.setOprtState(OprtState.EDIT);
        } else {
            this.setOprtState(OprtState.VIEW);
        }
        IPermission iPer = PermissionFactory.getRemoteInstance();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (this.orgUnitId == null) {
            boolean isShowLock = false;
            boolean isShowUnLock = false;
            this.orgUnitId = this.getBgFormInfo().getOrgUnit().getId().toString();
            try {
                isShowLock = iPer.hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(this.orgUnitId), "bg_form27_lock");
                isShowUnLock = iPer.hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(this.orgUnitId), "bg_form28_unLock");
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            boolean lockFlag = canEdit && isShowLock;
            boolean unLockFlag = canEdit && isShowUnLock;
            this.btnLock.setEnabled(lockFlag);
            this.btnUnLock.setEnabled(unLockFlag);
            this.menuItemLock.setEnabled(lockFlag);
            this.menuUnLock.setEnabled(unLockFlag);
        }
    }

    private SpreadContext getSpreadContext() {
        return this.spreadManager.getSpreadContainer();
    }

    private ModifyManager getModifyManager() {
        return this.spreadManager.getModifyManager();
    }

    private SpreadManager getSpreadManager() {
        return this.spreadManager;
    }

    private boolean isModify() {
        return this.getModifyManager().isDirty() && OprtState.EDIT.equals(this.getOprtState());
    }

    protected void requestNetControl() {
        this.isRequestNetControl = false;
        if (1 != this.currentFormInfo.getState().getValue() && 42 != this.currentFormInfo.getState().getValue()) {
            return;
        }
        try {
            this.fireVOChangeListener((IObjectValue)this.currentFormInfo, true);
            this.isRequestNetControl = true;
        }
        catch (Throwable e) {
            this.setOprtState("RequestMutex_Failed");
            this.handUIException(e);
            this.isRequestNetControl = false;
        }
    }

    protected void releaseNetControl() {
        if (!"RequestMutex_Failed".equals(this.getOprtState())) {
            this.setOprtState("RELEASEALL");
            try {
                this.fireVOChangeListener((IObjectValue)this.currentFormInfo, false);
            }
            catch (Throwable e) {
                this.handUIException(e);
                this.abort();
            }
        }
    }

    private void fireVOChangeListener(IObjectValue newObject, boolean requestLock) throws Throwable {
        IVOChangeListener listener = this.getVOChangeListener();
        if (listener != null) {
            VOChangeEvent e = new VOChangeEvent((Object)this);
            e.setState(this.getOprtState());
            if (newObject != null && newObject.getPKField() != null) {
                if (requestLock) {
                    e.setNewObjectId(newObject.getBOSUuid(newObject.getPKField()).toString());
                } else {
                    e.setCurrentObjectId(newObject.getBOSUuid(newObject.getPKField()).toString());
                }
                listener.change(e);
            }
        }
    }

    private void calculate() {
        if (this.progressDialog == null) {
            this.progressDialog = ProgressDialog.createProgressDialog((Component)((Object)this), (boolean)true);
        }
        if (this.progressDialog.isVisible()) {
            return;
        }
        try {
            this.progressDialog.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    TimeMark mark = BgFormSpecialEditUI.this.getTimeMark();
                    try {
                        if (mark != null) {
                            mark.Start();
                        }
                        monitor.beginTask(DesignerResource.getString((String)"calculateBook"), -1);
                        monitor.setTaskName(DesignerResource.getString((String)"calculateBook_PlsWait"));
                        monitor.subTaskBegin(DesignerResource.getString((String)"prepareData"));
                        BgFormSpecialEditUI.this.getBook().setSkipListeners(true);
                        monitor.subTaskBegin(DesignerResource.getString((String)"calculate"));
                        BgFormSpecialEditUI.this.getBook().calc();
                        BgFormSpecialEditUI.this.saveBgValue();
                        monitor.subTaskBegin(DesignerResource.getString((String)"calculateComplete"));
                    }
                    finally {
                        monitor.done();
                        BgFormSpecialEditUI.this.getBook().setSkipListeners(false);
                        BgFormSpecialEditUI.this.getSpreadContext().repaint();
                        if (mark != null) {
                            mark.Stop();
                        }
                        BgFormSpecialEditUI.this.getModifyManager().setModified();
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"Report Calculate Progress Error", (Throwable)e);
        }
    }

    protected TimeMark getTimeMark() {
        if (this.mk == null) {
            this.mk = new TimeMark(this);
        }
        if (this.mk.isRuning()) {
            return null;
        }
        return this.mk;
    }

    private void checkCanSingleRefer(String bgFormId) throws Exception {
        boolean result = this.checkCanSchemeRefer(bgFormId);
        if (result) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSubmitBySchemeResource", (String)"formOnlySubmitByScheme"));
            SysUtil.abort();
        }
    }

    private boolean checkCanSchemeRefer(String bgFormId) throws Exception {
        boolean result = false;
        if (bgFormId == null) {
            return result;
        }
        try {
            String sql = "select a.FIsSubmitByScheme from T_BG_BgScheme a, T_BG_BgForm b  where a.FID = b.FBgSchemeId and b.fid = '" + bgFormId + "'";
            ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet rs = iSql.executeSQL();
            if (rs.next()) {
                result = rs.getBoolean(1);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return result;
    }

    protected boolean checkReport(String bgFormId) throws Exception {
        if (StringUtils.isEmpty((String)bgFormId)) {
            return false;
        }
        ArrayList<String> _bgFormIds = new ArrayList<String>();
        _bgFormIds.add(bgFormId);
        return this.checkReport(_bgFormIds);
    }

    protected boolean checkReport(List bgFormIds) throws Exception {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return false;
        }
        BOSUuid[] _bosUuids = new BOSUuid[bgFormIds.size()];
        int in = bgFormIds.size();
        for (int i = 0; i < in; ++i) {
            _bosUuids[i] = BOSUuid.read((String)bgFormIds.get(i).toString());
        }
        return this.checkReport(_bosUuids);
    }

    protected boolean checkReport(BOSUuid[] bgFormIds) throws Exception {
        List nopass;
        if (bgFormIds == null || bgFormIds.length == 0) {
            return false;
        }
        boolean isCheck = true;
        List check = this.getBgFormInterface().reportCheck(bgFormIds);
        if (Boolean.TRUE.equals(check.get(0))) {
            return isCheck;
        }
        if (Boolean.FALSE.equals(check.get(0))) {
            isCheck = false;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"String", (Object)check.get(3).toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        if (check.size() >= 3 && check.get(2) != null && (nopass = (List)check.get(2)).size() > 0) {
            isCheck = false;
            MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "ReportCheckError"));
        }
        return isCheck;
    }

    protected void openBgExamineViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.openBgExamineModel()).create(BgExamineViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String openBgExamineModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public boolean destroyWindow() {
        boolean flag = false;
        try {
            flag = this.saveCurrentData(true);
            if (!flag) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"erroe", (Throwable)e);
        }
        this.clearAll();
        return super.destroyWindow();
    }

    public ICurrency getCurrencyInterface() throws Exception {
        return CurrencyFactory.getRemoteInstance();
    }

    public IBgNFFacade getNFFacadeInterface() throws Exception {
        return BgNFFacadeFactory.getRemoteInstance();
    }

    public IBgForm getBgFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    public IBgFormFacade getFacadeInterface() throws Exception {
        return BgFormFacadeFactory.getRemoteInstance();
    }

    public IBgExamineFacade getExamineInterface() throws Exception {
        return BgExamineFacadeFactory.getRemoteInstance();
    }

    @Override
    public MeasureUnitInfo getMeasureUnit() {
        return this.getBgFormInfo().getMeasureUnit();
    }

    class TimeMark {
        BgFormSpecialEditUI ui;
        boolean isRuning = false;
        long time = 0L;

        public TimeMark(BgFormSpecialEditUI _ui) {
            this.ui = _ui;
        }

        public boolean isRuning() {
            return this.isRuning;
        }

        public void Start() {
            this.isRuning = true;
            this.time = System.currentTimeMillis();
        }

        public void Stop() {
            this.ui.showSuccessMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"calcTime"), Long.toString(System.currentTimeMillis() - this.time)));
            this.isRuning = false;
        }
    }

    protected final class CalculateContext
    implements ICalculateContextProvider {
        private static final long serialVersionUID = -2732525885313221629L;
        private IErrorResultProvider resultProvider = null;

        protected CalculateContext() {
        }

        public Context getServerContext() {
            return null;
        }

        public IReportPropertyAdapter getReportAdapter() {
            return new BgRptReportPropertyAdapter(BgFormSpecialEditUI.this.currentFormInfo);
        }

        public ReportVariables getReportVariables() {
            return ReportVariables.loadFromBook((Book)BgFormSpecialEditUI.this.getBook());
        }

        public IErrorProvider getErrorProvider() {
            return BgFormSpecialEditUI.this.getBookProperties().getErrorProvider();
        }

        public IErrorResultProvider getErrorResultProvider() {
            if (this.resultProvider == null) {
                this.resultProvider = new IErrorResultProvider(){

                    public String getText(long errorCode) {
                        ReportCalculateErrorProvider errorProvider = BgFormSpecialEditUI.this.getBookProperties().getErrorProvider();
                        if (errorProvider != null && errorCode == 128L) {
                            return errorProvider.getExceptionReplacer().toString();
                        }
                        if (errorProvider != null && errorCode == 2L) {
                            return errorProvider.getZeroDivDisplayAs();
                        }
                        return null;
                    }
                };
            }
            return this.resultProvider;
        }
    }
}

