/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgImportResultUI
extends BgExamineViewUI {
    private static final long serialVersionUID = -8249073165329659645L;
    private static final Logger logger = Logger.getLogger((String)BgImportResultUI.class.getName());

    public void onShow() throws Exception {
        super.onShow();
        this.setUITitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "title_import"));
    }

    protected void initTable() {
        int rowCount = 7;
        int colCount = 2;
        this.tblMain.setRefresh(false);
        this.tblMain.getScriptManager().setAutoRun(false);
        this.tblMain.addRows(rowCount);
        this.tblMain.addColumns(colCount);
        IRow row = this.tblMain.addHeadRow();
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            row.getCell(colIndex, true).setValue((Object)TableToolkit.int2pos((int)colIndex));
        }
        this.tblMain.getColumn(0).setWidth(300);
        this.tblMain.getColumn(1).setWidth(450);
        this.tblMain.setRefresh(true);
        this.tblMain.checkParsed(true);
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    protected void loadBgExamineCheckData() {
        Object obj = this.getUIContext().get("EXAMINE_DATA");
        if (obj != null && obj instanceof Map) {
            this.initReportInfo((Map)obj);
        }
    }

    protected void initReportInfo(Map resultMap) {
        IRow row = null;
        String _orgUnitId = null;
        String _orgUnitName = null;
        String _filename = null;
        String _result = null;
        String _importType = null;
        Integer type = (Integer)resultMap.get("IMPORT_TYPE");
        switch (type) {
            case 0: {
                _importType = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "import_budget");
                break;
            }
            case 2: {
                _importType = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "import_actual");
                break;
            }
            case 1: {
                _importType = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "import_adjust");
                break;
            }
            case 3: {
                _importType = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "import_add");
                break;
            }
            default: {
                _importType = "";
            }
        }
        this.tblMain.getCell(0, 0).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "title_import"));
        this.tblMain.getCell(1, 0).setValue((Object)(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "importTime") + BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date())));
        this.tblMain.getCell(2, 0).setValue((Object)(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "importUser") + SysContext.getSysContext().getCurrentUserInfo().getName()));
        this.tblMain.getCell(3, 0).setValue((Object)(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "importType") + _importType));
        this.tblMain.getCell(4, 0).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "importResult"));
        this.tblMain.getCell(6, 0).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "importList"));
        List orgUnitList = (List)resultMap.get("IMPORT_ORGUNIT_LIST");
        Map imOrgUnitMap = (Map)resultMap.get("IMPORT_ORGUNIT_INFO");
        Map imOrgFileMap = (Map)resultMap.get("IMPORT_ORGUNIT_FILES");
        Map imFileResultMap = null;
        List imFileName = null;
        List imFileResult = null;
        int succCount = 0;
        int errorCount = 0;
        String succStr = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "import_succeed");
        if (orgUnitList.isEmpty()) {
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "errorResultset"));
        } else {
            int size = orgUnitList.size();
            for (int index = 0; index < size; ++index) {
                _orgUnitId = (String)orgUnitList.get(index);
                _orgUnitName = (String)imOrgUnitMap.get(_orgUnitId);
                imFileResultMap = (Map)imOrgFileMap.get(_orgUnitId);
                imFileName = (List)imFileResultMap.get("IMPORT_FILES_NAME");
                imFileResult = (List)imFileResultMap.get("IMPORT_FILES_RESULT");
                int jn = imFileName.size();
                for (int j = 0; j < jn; ++j) {
                    _filename = (String)imFileName.get(j);
                    _result = (String)imFileResult.get(j);
                    if (succStr.equals(_result)) {
                        ++succCount;
                    } else {
                        ++errorCount;
                    }
                    row = this.tblMain.addRow();
                    row.getStyleAttributes().setWrapText(true);
                    row.getCell(0).setValue((Object)_filename);
                    row.getCell(1).setValue((Object)_result);
                    KDTableHelper.autoFitRowHeight((KDTable)this.tblMain, (int)row.getRowIndex());
                }
            }
        }
        succStr = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "importDetail");
        if (!StringUtils.isEmpty((String)succStr)) {
            succStr = MessageFormat.format(succStr, new Integer(succCount + errorCount), new Integer(succCount), new Integer(errorCount));
        }
        this.tblMain.getCell(5, 0).setValue((Object)succStr);
    }
}

