/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgElimTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgInnerDataCheckFilterParam;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.client.AbstractBgInnerDataCheckFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgInnerDataCheckMainUI;
import com.kingdee.eas.ma.nbudget.client.UnionBudgetF7;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

public class BgInnerDataCheckFilterUI
extends AbstractBgInnerDataCheckFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BgInnerDataCheckFilterUI.class);
    private static final String FILTERPARAM = "FILTERPARAM";
    private static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    private IBgElimContext ctx = BgElimContextHelper.getBgElimContext();
    protected Object ui = null;
    private UnionBudgetF7 UnionBudgetF7Cache = null;
    private String orgUnitLongNum = null;

    public BgInnerDataCheckFilterUI() throws Exception {
    }

    public BgInnerDataCheckFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (BgElimContextHelper.isInitialized(this.getUIContext())) {
            this.initDefaultUI();
        } else {
            SysUtil.abort();
        }
    }

    protected void initDefaultUI() throws Exception {
        this.refreshOrgUnitF7();
        this.refreshElimTemplateF7();
        this.refreshBgSchemeF7();
        this.refreshBgPeriodF7();
        this.prmtBgElement.setEditable(false);
        this.prmtCurrency.setEditable(false);
    }

    private void refreshOrgUnitF7() throws BOSException {
        if (this.UnionBudgetF7Cache != null) {
            this.prmtOrgUnit.setSelector((KDPromptSelector)this.UnionBudgetF7Cache);
        } else {
            UnionBudgetF7 oldf7 = (UnionBudgetF7)this.prmtOrgUnit.getSelector();
            UnionBudgetF7 UnionBudgetF72 = new UnionBudgetF7((IUIObject)this, 3);
            OrgTreeInfo orgTreeInfo = this.ctx.getCurOrgBound();
            if (oldf7 == null || !orgTreeInfo.getId().toString().equals(oldf7.getTreeID())) {
                UnionBudgetF72.setTreeID(orgTreeInfo.getId().toString());
            } else {
                UnionBudgetF72 = oldf7;
            }
            OrgUnitInfo orgUnitInfo = this.ctx.getCurOrgGroup();
            UnionBudgetF72.setRootUnitID(orgUnitInfo.getId().toString());
            this.prmtOrgUnit.setSelector((KDPromptSelector)UnionBudgetF72);
            this.UnionBudgetF7Cache = UnionBudgetF72;
        }
        this.prmtOrgUnit.setEditable(false);
    }

    private void refreshElimTemplateF7() throws BOSException {
        this.prmtElimTemplate.setQueryInfo("com.kingdee.eas.ma.nbudget.BgElimTemplateQuery");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isEffective", (Object)"1"));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("elimType");
        sic.add("diffDeal");
        sic.add("creator.name");
        sic.add("createTime");
        view.setFilter(filter);
        view.setSorter(sorter);
        view.setSelector(sic);
        this.prmtElimTemplate.setEntityViewInfo(view);
        this.prmtElimTemplate.setEditable(false);
    }

    private void refreshBgSchemeF7() throws BOSException {
        String orgUnitId = null;
        OrgUnitInfo orgUnit = this.ctx.getCurMappedOrgUnit();
        orgUnitId = orgUnit != null ? orgUnit.getId().toString() : "NONE_ORGUNIT_ID";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.Id", (Object)orgUnitId));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setFilter(filter);
        view.setSorter(sorter);
        this.prmtBgScheme.setEntityViewInfo(view);
        this.prmtBgScheme.setEditable(false);
    }

    private void refreshBgPeriodF7() {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriod.setEditable(false);
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        this.prmtOrgUnitRange.setData(null);
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.prmtOrgUnit.getData();
        if (orgUnitInfo != null) {
            UnionBudgetF7 UnionBudgetF72 = new UnionBudgetF7((IUIObject)this, 1);
            OrgTreeInfo orgTreeInfo = this.ctx.getCurOrgBound();
            UnionBudgetF72.setTreeID(orgTreeInfo.getId().toString());
            if (orgUnitInfo.isIsGrouping()) {
                UnionBudgetF72.setRootUnitID(orgUnitInfo.getId().toString());
                this.setOrgUnitLongNum(orgUnitInfo.getLongNumber());
            } else {
                this.setOrgUnitLongNum(null);
            }
            UnionBudgetF72.setMultiSelect(true);
            this.prmtOrgUnitRange.setSelector((KDPromptSelector)UnionBudgetF72);
        } else {
            UnionBudgetF7 UnionBudgetF73 = new UnionBudgetF7((IUIObject)this);
            UnionBudgetF73.setTreeID("NULL_TREEID");
            this.prmtOrgUnitRange.setSelector((KDPromptSelector)UnionBudgetF73);
        }
        this.prmtOrgUnitRange.setEditable(false);
        this.prmtOrgUnitRange.setEnabledMultiSelection(true);
    }

    public String getUITitle() {
        return null;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        if (cp == null) {
            cp = new CustomerParams();
        }
        FilterParam filterParam = null;
        filterParam = cp.getCustomerParam(FILTERPARAM) == null ? this.createNewFilterParam() : (FilterParam)this.getFilterObject(cp);
        if (this.ui != null && this.ui instanceof BgInnerDataCheckMainUI) {
            if (((BgInnerDataCheckMainUI)this.ui).getFilterParam() == null) {
                ((BgInnerDataCheckMainUI)this.ui).setFilterParam(new BgInnerDataCheckFilterParam());
            }
            filterParam = this.getFilterParam(((BgInnerDataCheckMainUI)this.ui).getFilterParam(), filterParam);
        }
        this.setFilterParam(filterParam);
        this.setFilterObject(cp, filterParam);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam(FILTERPARAM) != null) {
            FilterParam filterParam = (FilterParam)this.getFilterObject(cp);
            this.getFilterParam(filterParam);
        }
    }

    protected void getFilterParam(FilterParam filterParam) {
        if (filterParam instanceof BgInnerDataCheckFilterParam) {
            BgInnerDataCheckFilterParam _filterParam = (BgInnerDataCheckFilterParam)filterParam;
            this.prmtOrgUnit.setData((Object)_filterParam.getOrgUnit());
            this.prmtOrgUnitRange.setData((Object)_filterParam.getOrgUnitRange());
            this.prmtElimTemplate.setData((Object)_filterParam.getElimTemplateInfo());
            this.prmtBgScheme.setData((Object)_filterParam.getBgSchemeInfo());
            this.prmtBgPeriod.setData((Object)_filterParam.getPeriodInfo());
            this.prmtBgElement.setData((Object)_filterParam.getBgElementInfo());
            this.prmtCurrency.setData((Object)_filterParam.getCurrencyInfo());
            this.comboDataType.setSelectedItem((Object)_filterParam.getDataType());
        }
    }

    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        BgInnerDataCheckFilterParam _mainParam = null;
        BgInnerDataCheckFilterParam _filterParam = null;
        if (mainParam != null && filterParam != null) {
            _mainParam = (BgInnerDataCheckFilterParam)mainParam;
            _filterParam = (BgInnerDataCheckFilterParam)filterParam;
            _mainParam.setOrgUnit(_filterParam.getOrgUnit());
            _mainParam.setOrgUnitRange(_filterParam.getOrgUnitRange());
            _mainParam.setElimTemplateInfo(_filterParam.getElimTemplateInfo());
            _mainParam.setBgSchemeInfo(_filterParam.getBgSchemeInfo());
            _mainParam.setPeriodInfo(_filterParam.getPeriodInfo());
            _mainParam.setBgElementInfo(_filterParam.getBgElementInfo());
            _mainParam.setCurrencyInfo(_filterParam.getCurrencyInfo());
            _mainParam.setDataType(_filterParam.getDataType());
            return _mainParam;
        }
        return mainParam;
    }

    protected void setFilterParam(FilterParam filterParam) {
        if (filterParam instanceof BgInnerDataCheckFilterParam) {
            BgInnerDataCheckFilterParam _filterParam = (BgInnerDataCheckFilterParam)filterParam;
            _filterParam.setOrgUnit((OrgUnitInfo)this.prmtOrgUnit.getData());
            if (this.prmtOrgUnitRange.getData() instanceof OrgUnitInfo) {
                _filterParam.setOrgUnitRange(new OrgUnitInfo[]{(OrgUnitInfo)this.prmtOrgUnitRange.getData()});
            } else if (this.prmtOrgUnitRange.getData() instanceof OrgUnitInfo[]) {
                _filterParam.setOrgUnitRange((OrgUnitInfo[])this.prmtOrgUnitRange.getData());
            } else if (this.prmtOrgUnitRange.getData() == null) {
                _filterParam.setOrgUnitRange(null);
            }
            _filterParam.setElimTemplateInfo((BgElimTemplateInfo)this.prmtElimTemplate.getData());
            _filterParam.setDataType((BgDataTypeEnum)this.comboDataType.getSelectedItem());
            _filterParam.setBgSchemeInfo((BgSchemeInfo)this.prmtBgScheme.getData());
            _filterParam.setPeriodInfo((BgPeriodInfo)this.prmtBgPeriod.getData());
            _filterParam.setBgElementInfo((BgElementInfo)this.prmtBgElement.getData());
            _filterParam.setCurrencyInfo((CurrencyInfo)this.prmtCurrency.getData());
        }
    }

    protected FilterParam createNewFilterParam() {
        return new BgInnerDataCheckFilterParam();
    }

    public Object getFilterObject(CustomerParams cp) {
        return this.getFilterObject(cp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFilterObject(CustomerParams cp, String key) {
        if (cp == null) {
            return null;
        }
        FilterParam param = null;
        String objStr = null;
        objStr = key == null || key.length() == 0 ? cp.getCustomerParam(FILTERPARAM) : cp.getCustomerParam(key);
        if (objStr == null) {
            return null;
        }
        byte[] objByte = Base64.decode((String)objStr);
        if (objByte == null || objByte.length == 0) {
            return null;
        }
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            param = (FilterParam)bais.readObject();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterObject(CustomerParams cp, Object param, String key) {
        if (cp == null || param == null) {
            return;
        }
        byte[] objByte = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(param);
            objByte = ZipUtil.pack((ByteArrayOutputStream)baos);
        }
        catch (IOException iOException) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!StringUtils.isEmpty((String)key)) {
            cp.addCustomerParam(key, Base64.encodeBytes(objByte));
        } else {
            cp.addCustomerParam(FILTERPARAM, Base64.encodeBytes(objByte));
        }
    }

    public void setFilterObject(CustomerParams cp, Object param) {
        this.setFilterObject(cp, param, null);
    }

    public String getOrgUnitLongNum() {
        return this.orgUnitLongNum;
    }

    public void setOrgUnitLongNum(String orgUnitLongNum) {
        this.orgUnitLongNum = orgUnitLongNum;
    }

    public void clear() {
        super.clear();
        this.prmtOrgUnit.setData(null);
        this.prmtOrgUnitRange.setData(null);
        this.prmtElimTemplate.setData(null);
        this.prmtBgScheme.setData(null);
        this.prmtBgPeriod.setData(null);
        this.prmtBgElement.setData(null);
        this.prmtCurrency.setData(null);
        try {
            this.prmtOrgUnit.setData((Object)this.ctx.getCurOrgGroup());
            if (this.ctx.getCurBgScheme() != null) {
                this.prmtBgScheme.setData((Object)this.ctx.getCurBgScheme());
                this.prmtBgScheme.setEnabled(false);
            }
            if (this.ctx.getCurBgPeriod() != null) {
                this.prmtBgPeriod.setData((Object)this.ctx.getCurBgPeriod());
                this.prmtBgPeriod.setEnabled(false);
            }
            this.comboDataType.setSelectedItem((Object)this.ctx.getCurBgDataType());
            this.comboDataType.setEnabled(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        boolean v = super.verify();
        if (v) {
            if (this.prmtOrgUnit.getData() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"defaultOrgUnitEmpty"));
                SysUtil.abort();
            }
            if (this.prmtElimTemplate.getData() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"elimTemplateEmpty"));
                SysUtil.abort();
            }
            if (this.prmtBgScheme.getData() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"schemeEmpty"));
                SysUtil.abort();
            }
            if (this.prmtBgPeriod.getData() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"periodEmpty"));
                SysUtil.abort();
            }
            if (this.prmtBgElement.getData() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"elementEmpty"));
                SysUtil.abort();
            }
            if (this.prmtCurrency.getData() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"currencyEmpty"));
                SysUtil.abort();
            }
        }
        return v;
    }
}

