/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgElimDiffDealEnum;
import com.kingdee.eas.ma.nbudget.BgElimFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgElimTemplateEntryCollection;
import com.kingdee.eas.ma.nbudget.BgElimTemplateEntryInfo;
import com.kingdee.eas.ma.nbudget.BgElimTemplateFactory;
import com.kingdee.eas.ma.nbudget.BgElimTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgInnerDataCheckFilterParam;
import com.kingdee.eas.ma.nbudget.BgInnerDataCheckInfo;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataEntryFactory;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataEntryInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BizDirectionEnum;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.IBgElimFacade;
import com.kingdee.eas.ma.nbudget.IBgElimTemplate;
import com.kingdee.eas.ma.nbudget.IBgInnerFillDataEntry;
import com.kingdee.eas.ma.nbudget.client.AbstractBgInnerDataCheckMainUI;
import com.kingdee.eas.ma.nbudget.client.BgInnerDataCheckFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgInnerDataDiffDealUI;
import com.kingdee.eas.ma.nbudget.client.BgInnerFillDataEditUI;
import com.kingdee.eas.ma.nbudget.client.IBgElimContextUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BgInnerDataCheckMainUI
extends AbstractBgInnerDataCheckMainUI
implements IBgElimContextUI {
    private static final Logger logger = CoreUIObject.getLogger(BgInnerDataCheckMainUI.class);
    protected BgInnerDataCheckFilterUI defaultFilterUI = null;
    protected FilterParam defaultFilterParam = null;
    private CommonQueryDialog dialog = null;
    protected IMetaDataPK mainQueryPk = null;
    private List datas = null;
    private static final String SUMROW = "SUMROW";
    private String sumStr = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAnalyseResource", (String)"sum");
    private static final String NUM_FOTMATTER = BgNationalFormatUIUtil.getNumberFormat((int)2);
    boolean hasOnLoad = false;
    private IBgElimContext ctx = BgElimContextHelper.getBgElimContext();
    private static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    private int selectedRowIndex = -1;
    private static final String col_selected = "selected";
    private static final String col_orgUnit = "orgUnit";
    private static final String col_orgUnitId = "orgUnitId";
    private static final String col_oppOrgUnit = "oppOrgUnit";
    private static final String col_oppOrgUnitId = "oppOrgUnitId";
    private static final String col_bgItemNumber = "bgItemNumber";
    private static final String col_bgItemName = "bgItemName";
    private static final String col_debitFilled = "debitFilled";
    private static final String col_creditFilled = "creditFilled";
    private static final String col_debitAmount = "debitAmount";
    private static final String col_creditAmount = "creditAmount";
    private static final String col_diff = "diff";
    private static final String col_confirmed = "confirmed";
    private static final String col_elimGen = "elimGen";
    private static final String col_affireman = "affireman";
    private static final String col_confirmDate = "confirmDate";
    private static final String col_dataId = "dataId";
    private static final String col_bgItemId = "bgItemId";
    private static final String BTN_TEXT = "com.kingdee.eas.ma.nbudget.BgNWorkPaperResource";
    private BgElimDiffDealEnum diffDeal = null;
    BgElimTemplateInfo elimTemplateInfo = null;
    ArrayList dealRows = new ArrayList();

    public BgInnerDataCheckMainUI() throws Exception {
        this.mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.budget", "BgElementQuery");
    }

    public void onLoad() throws Exception {
        if (BgElimContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            BgElimContextHelper.registUIObject(this);
            this.hasOnLoad = false;
            this.init();
            boolean hasDefaultQuery = this.getDefaultFilterParam();
            if (hasDefaultQuery) {
                this.execQuery();
            } else {
                this.dialog = this.getCommonQueryDialog();
                if (this.dialog.show()) {
                    CustomerParams params = this.getFilterUI().getCustomerParams();
                    this.setFilterParam(params);
                    this.execQuery();
                } else {
                    SysUtil.abort();
                }
            }
            BgNationalFormatUIUtil.setDateTimeOrNumberFormat((KDTable)this.kDTable1);
        } else {
            SysUtil.abort();
        }
    }

    protected void init() {
        this.getTblMain().checkParsed();
        this.getTblMain().getSelectManager().setSelectMode(2);
        this.getTblMain().getColumn(col_selected).setWidth(40);
        int columnCount = this.getTblMain().getColumnCount();
        for (int i = 1; i < columnCount; ++i) {
            this.getTblMain().getColumn(i).getStyleAttributes().setLocked(true);
        }
        this.getTblMain().setUserCellDisplayParser((IUserCellDisplayParser)new UserCellDisplayParser());
        this.btnBatchDiffDeal.setIcon(EASResource.getIcon((String)"imgTbtn_usercollocatemanage"));
        this.itemBig.setVisible(true);
        this.itemLower.setVisible(true);
        this.itemManual.setVisible(true);
        this.itemBig.setEnabled(true);
        this.itemLower.setEnabled(true);
        this.itemManual.setEnabled(true);
        this.btnBatchDiffDeal.addAssistMenuItem((JMenuItem)this.itemBig);
        this.btnBatchDiffDeal.addAssistMenuItem((JMenuItem)this.itemLower);
        this.btnBatchDiffDeal.addAssistMenuItem((JMenuItem)this.itemManual);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuTool.setEnabled(false);
        this.menuTool.setVisible(false);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnEditInnerData.setIcon(EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.menuItemEditInnerData.setIcon(EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.btnAutoCheck.setIcon(EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.menuItemAutoCheck.setIcon(EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.btnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.menuItemCheck.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.btnDiffDeal.setIcon(EASResource.getIcon((String)"imgTbtn_differencedispose"));
        this.menuItemDiffDeal.setIcon(EASResource.getIcon((String)"imgTbtn_differencedispose"));
        this.btnCancelConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.menuItemCancelConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.btnGenElimination.setIcon(EASResource.getIcon((String)"imgTbtn_associateentry"));
        this.menuItemGenElimination.setIcon(EASResource.getIcon((String)"imgTbtn_associateentry"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execQuery() {
        if (this.getFilterParam() != null) {
            try {
                Map map;
                BgInnerDataCheckFilterParam _filterParam = (BgInnerDataCheckFilterParam)this.getFilterParam();
                OrgUnitInfo orgUnitInfo = _filterParam.getOrgUnit();
                Map param = this.getQueryParamMap(_filterParam);
                OrgUnitInfo org = OrgUnitCommonFactory.getRemoteInstance().getOrgUnit(orgUnitInfo.getId());
                if (org != null) {
                    orgUnitInfo.setIsGrouping(org.isIsGrouping());
                }
                if (orgUnitInfo != null && orgUnitInfo.isIsGrouping()) {
                    param.put("ORG_GROUP", orgUnitInfo.getLongNumber());
                    param.put("ORG_TREE", this.ctx.getCurOrgBound().getId().toString());
                }
                if ((map = this.getBgElimFacade().queryInnerDataCheck(param)).get("datas") instanceof List) {
                    this.datas = (List)map.get("datas");
                } else if (map.get("datas") instanceof String) {
                    this.datas = (List)this.upPack((String)map.get("datas"));
                }
                this.getTblMain().removeRows();
                if (this.datas != null) {
                    this.fillData(this.datas);
                }
                this.selectedRowIndex = -1;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void fillData(List list) throws Exception {
        int bottom;
        int left;
        int right;
        int top;
        if (list == null || list.isEmpty()) {
            return;
        }
        this.getTblMain().setRefresh(false);
        IRow row = null;
        int size = list.size();
        BgInnerDataCheckInfo info = null;
        String key = null;
        boolean isSumRow = false;
        BigDecimal sumDebitFill = new BigDecimal("0.00");
        BigDecimal sumCreditFill = new BigDecimal("0.00");
        BigDecimal sumDebitAmount = new BigDecimal("0.00");
        BigDecimal sumCreditAmount = new BigDecimal("0.00");
        BigDecimal diffAmount = new BigDecimal("0.00");
        for (int i = 0; i < size; ++i) {
            info = (BgInnerDataCheckInfo)list.get(i);
            isSumRow = key != null && !key.equals(info.getKey());
            if (isSumRow) {
                row = this.getTblMain().addRow();
                row.setUserObject((Object)SUMROW);
                if (sumCreditFill != null && sumDebitFill != null) {
                    diffAmount = sumDebitFill.subtract(sumCreditFill);
                }
                row.getCell(col_debitFilled).setValue((Object)sumDebitFill);
                row.getCell(col_creditFilled).setValue((Object)sumCreditFill);
                row.getCell(col_debitAmount).setValue((Object)sumDebitAmount);
                row.getCell(col_creditAmount).setValue((Object)sumCreditAmount);
                row.getCell(col_diff).setValue((Object)diffAmount);
                row.getCell(col_bgItemNumber).setValue((Object)this.sumStr);
                row.getStyleAttributes().setBackground(BgNConstants.LITILE_SUM_COROR);
                row.getCell(col_bgItemNumber).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                this.getTblMain().getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 6);
                int rowCount = this.getTblMain().getRowCount();
                Object rowObj = null;
                top = rowCount - 2;
                left = right = this.getTblMain().getColumn(col_diff).getColumnIndex();
                bottom = rowCount - 2;
                int rowIndex = rowCount - 2;
                while (rowIndex >= 0 && (rowObj = (row = this.getTblMain().getRow(rowIndex)).getUserObject()) != null && !rowObj.equals(SUMROW)) {
                    row.getCell(col_diff).setValue((Object)diffAmount);
                    top = rowIndex--;
                }
                this.getTblMain().getMergeManager().mergeBlock(top, left, bottom, right);
                sumDebitFill = new BigDecimal("0.00");
                sumCreditFill = new BigDecimal("0.00");
                sumDebitAmount = new BigDecimal("0.00");
                sumCreditAmount = new BigDecimal("0.00");
            }
            row = this.getTblMain().addRow();
            row.setUserObject((Object)info.getKey());
            row.getCell(col_selected).setValue((Object)new Boolean(false));
            row.getCell(col_dataId).setValue((Object)info.getId());
            row.getCell(col_orgUnit).setValue((Object)info.getOrgUnitName());
            row.getCell(col_orgUnitId).setValue((Object)info.getOrgUnitId());
            row.getCell(col_oppOrgUnit).setValue((Object)info.getOppOrgUnitName());
            row.getCell(col_oppOrgUnitId).setValue((Object)info.getOppOrgUnitId());
            row.getCell(col_bgItemNumber).setValue((Object)info.getBgItemNumber());
            row.getCell(col_bgItemName).setValue((Object)info.getBgItemName());
            if (info.getBizDirection() == BizDirectionEnum.Borrow.getValue()) {
                row.getCell(col_debitFilled).setValue((Object)info.getFillAmount());
                row.getCell(col_debitAmount).setValue((Object)info.getAmount());
                sumDebitFill = sumDebitFill.add(info.getFillAmount() == null ? BgNConstants.ZERO : info.getFillAmount());
                sumDebitAmount = sumDebitAmount.add(info.getAmount() == null ? BgNConstants.ZERO : info.getAmount());
            } else {
                row.getCell(col_creditFilled).setValue((Object)info.getFillAmount());
                row.getCell(col_creditAmount).setValue((Object)info.getAmount());
                sumCreditFill = sumCreditFill.add(info.getFillAmount() == null ? BgNConstants.ZERO : info.getFillAmount());
                sumCreditAmount = sumCreditAmount.add(info.getAmount() == null ? BgNConstants.ZERO : info.getAmount());
            }
            if (!StringUtils.isEmpty((String)info.getAffirmant())) {
                row.getCell(col_confirmed).setValue((Object)new Boolean(true));
                row.getCell(col_affireman).setValue((Object)info.getAffirmant());
                row.getCell(col_confirmDate).setValue((Object)info.getConfirmDate());
            } else {
                row.getCell(col_confirmed).setValue((Object)new Boolean(false));
            }
            row.getCell(col_elimGen).setValue((Object)new Boolean(info.isHasGenElim()));
            key = info.getKey();
        }
        row = this.getTblMain().addRow();
        row.setUserObject((Object)SUMROW);
        if (sumCreditFill != null && sumDebitFill != null) {
            diffAmount = sumDebitFill.subtract(sumCreditFill);
        }
        row.getCell(col_debitFilled).setValue((Object)sumDebitFill);
        row.getCell(col_creditFilled).setValue((Object)sumCreditFill);
        row.getCell(col_debitAmount).setValue((Object)sumDebitAmount);
        row.getCell(col_creditAmount).setValue((Object)sumCreditAmount);
        row.getCell(col_diff).setValue((Object)diffAmount);
        row.getCell(col_bgItemNumber).setValue((Object)this.sumStr);
        row.getStyleAttributes().setBackground(BgNConstants.LITILE_SUM_COROR);
        row.getCell(col_bgItemNumber).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.getTblMain().getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 6);
        int rowCount = this.getTblMain().getRowCount();
        Object rowObj = null;
        top = rowCount - 2;
        left = right = this.getTblMain().getColumn(col_diff).getColumnIndex();
        bottom = rowCount - 2;
        int rowIndex = rowCount - 2;
        while (rowIndex >= 0 && (rowObj = (row = this.getTblMain().getRow(rowIndex)).getUserObject()) != null && !rowObj.equals(SUMROW)) {
            row.getCell(col_diff).setValue((Object)diffAmount);
            top = rowIndex--;
        }
        this.getTblMain().getMergeManager().mergeBlock(top, left, bottom, right);
        this.getTblMain().setRefresh(true);
        this.getTblMain().reLayoutAndPaint();
        this.displayZeroLow();
    }

    public void displayZeroLow() {
        int rowCount = this.getTblMain().getRowCount();
        IRow row = null;
        boolean isNeedZero = false;
        for (int i = 0; i < rowCount; ++i) {
            Object creditAmount;
            Object creditFilled;
            Object debitAmount;
            Object debitFilled;
            row = this.getTblMain().getRow(i);
            if (row.getCell(col_selected).getValue() instanceof Boolean && row.getCell(col_confirmed).getValue() instanceof Boolean && ((Boolean)row.getCell(col_confirmed).getValue()).booleanValue() && row.getCell(col_dataId) != null && row.getCell(col_dataId).getValue() != null) {
                if (row.getCell(col_debitFilled).getValue() == null && row.getCell(col_creditFilled).getValue() == null) {
                    return;
                }
                if (row.getCell(col_debitFilled).getValue() instanceof BigDecimal) {
                    debitFilled = row.getCell(col_debitFilled).getValue().toString();
                    debitAmount = row.getCell(col_debitAmount).getValue().toString();
                    if (!((String)debitFilled).equals(col_debitAmount) && "0".equals(debitAmount)) {
                        row.getCell(col_debitAmount).setValue((Object)"0.00");
                        row.getCell(col_debitAmount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        isNeedZero = true;
                    }
                }
                if (!(row.getCell(col_creditFilled).getValue() instanceof BigDecimal) || ((String)(creditFilled = row.getCell(col_creditFilled).getValue().toString())).equals(creditAmount = row.getCell(col_creditAmount).getValue().toString()) || !"0".equals(creditAmount)) continue;
                row.getCell(col_creditAmount).setValue((Object)"0.00");
                row.getCell(col_creditAmount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                isNeedZero = true;
                continue;
            }
            if (!isNeedZero) continue;
            if (row.getCell(col_debitFilled).getValue() == null && row.getCell(col_creditFilled).getValue() == null) {
                return;
            }
            if (row.getCell(col_debitFilled).getValue() instanceof BigDecimal && ((BigDecimal)(debitFilled = new BigDecimal(row.getCell(col_debitFilled).getValue().toString()))).compareTo((BigDecimal)(debitAmount = new BigDecimal(row.getCell(col_debitAmount).getValue().toString()))) != 0 && BgNConstants.ZERO.compareTo((BigDecimal)debitAmount) == 0) {
                row.getCell(col_debitAmount).setValue((Object)"0.00");
                row.getCell(col_debitAmount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            if (row.getCell(col_creditFilled).getValue() instanceof BigDecimal && ((BigDecimal)(creditFilled = new BigDecimal(row.getCell(col_creditFilled).getValue().toString()))).compareTo((BigDecimal)(creditAmount = new BigDecimal(row.getCell(col_creditAmount).getValue().toString()))) != 0 && BgNConstants.ZERO.compareTo((BigDecimal)creditAmount) == 0) {
                row.getCell(col_creditAmount).setValue((Object)"0.00");
                row.getCell(col_creditAmount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            isNeedZero = false;
        }
    }

    private Map getQueryParamMap(BgInnerDataCheckFilterParam filterParam) throws BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (filterParam.getOrgUnit() != null) {
            param.put("ORG_UNIT", filterParam.getOrgUnit().getId().toString());
        }
        if (filterParam.getOrgUnitRange() != null) {
            OrgUnitInfo[] orgs = filterParam.getOrgUnitRange();
            String[] orgIds = new String[orgs.length];
            for (int i = 0; i < orgs.length; ++i) {
                orgIds[i] = orgs[i].getId().toString();
            }
            param.put("ORG_UNIT_RANGE", orgIds);
        }
        if (filterParam.getElimTemplateInfo() != null) {
            param.put("BG_ELIM_TEMPLATE", filterParam.getElimTemplateInfo().getId().toString());
        }
        if (filterParam.getBgSchemeInfo() != null) {
            param.put("BG_SCHEME", filterParam.getBgSchemeInfo().getId().toString());
        }
        if (filterParam.getPeriodInfo() != null) {
            param.put("BG_PERIOD", filterParam.getPeriodInfo().getId().toString());
        }
        if (filterParam.getBgElementInfo() != null) {
            param.put("BG_ELEMENT", filterParam.getBgElementInfo().getId().toString());
        }
        if (filterParam.getCurrencyInfo() != null) {
            param.put("CURRENCY", filterParam.getCurrencyInfo().getId().toString());
        }
        if (filterParam.getDataType() != null) {
            param.put("DATA_TYPE", filterParam.getDataType());
        }
        if (this.getFilterUI().getOrgUnitLongNum() != null) {
            param.put("ORG_GROUP", this.getFilterUI().getOrgUnitLongNum());
            param.put("ORG_TREE", this.ctx.getCurOrgBound().getId().toString());
        }
        return param;
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new CommonQueryDialog();
        this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
        this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.dialog.setEntityViewInfo(new EntityViewInfo());
        this.dialog.setQueryObjectPK(this.mainQueryPk);
        this.dialog.setTitle(this.getFilterUI().getUITitle());
        this.dialog.setWidth(290);
        this.dialog.setHeight(280);
        this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        this.dialog.setShowFilter(false);
        this.dialog.setShowSorter(false);
        return this.dialog;
    }

    protected boolean getDefaultFilterParam() throws Exception {
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getQueryMainName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION) && ds.getQueryPanelInfo().size() > 0) {
            CustomerParams cp = new CustomerParams().getCustomerParams(ds.getQueryPanelInfo().get(0).getCustomerParams());
            this.setFilterParam(cp);
        }
        return this.getFilterParam() != null;
    }

    public FilterParam getFilterParam() {
        return this.defaultFilterParam;
    }

    protected String getQueryMainName() {
        return BgInnerDataCheckMainUI.class.getName();
    }

    protected void setFilterParam(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.setFilterParam((FilterParam)this.getFilterUI().getFilterObject(cp));
    }

    public void setFilterParam(FilterParam filterParam) {
        if (filterParam == null) {
            filterParam = new BgInnerDataCheckFilterParam();
        }
        this.defaultFilterParam = filterParam;
        if (this.getFilterParam() != null) {
            BgInnerDataCheckFilterParam _filterParam = (BgInnerDataCheckFilterParam)this.defaultFilterParam;
            this.prmtOrgUnit.setData((Object)_filterParam.getOrgUnit());
            this.prmtElimTemplate.setData((Object)_filterParam.getElimTemplateInfo());
            if (_filterParam.getElimTemplateInfo() != null) {
                this.comboElimType.setSelectedItem((Object)_filterParam.getElimTemplateInfo().getElimType());
            }
            this.comboDataType.setSelectedItem((Object)_filterParam.getDataType());
            this.prmtBgScheme.setData((Object)_filterParam.getBgSchemeInfo());
            this.prmtBgPeriod.setData((Object)_filterParam.getPeriodInfo());
            this.prmtBgElement.setData((Object)_filterParam.getBgElementInfo());
            this.prmtCurrency.setData((Object)_filterParam.getCurrencyInfo());
        }
    }

    protected BgInnerDataCheckFilterUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new BgInnerDataCheckFilterUI(this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handleException(ex);
            }
        }
        return this.defaultFilterUI;
    }

    @Override
    protected void kDTable1_editValueChanged(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        int rowCount = this.getTblMain().getRowCount();
        IRow row = null;
        Object rowKey = null;
        Boolean selected = null;
        if (colIndex == 0 && (row = this.getTblMain().getRow(rowIndex)).getUserObject() != null && row.getUserObject() != SUMROW) {
            int i;
            rowKey = row.getUserObject();
            selected = (Boolean)row.getCell(col_selected).getValue();
            for (i = rowIndex; i < rowCount; ++i) {
                if (this.getTblMain().getRow(i) == null || this.getTblMain().getRow(i).getCell(col_selected) == null) continue;
                if (!rowKey.equals(this.getTblMain().getRow(i).getUserObject())) break;
                this.getTblMain().getRow(i).getCell(col_selected).setValue((Object)new Boolean(selected == false));
            }
            for (i = rowIndex - 1; i >= 0; --i) {
                if (this.getTblMain().getRow(i) == null || this.getTblMain().getRow(i).getCell(col_selected) == null) continue;
                if (!rowKey.equals(this.getTblMain().getRow(i).getUserObject())) break;
                this.getTblMain().getRow(i).getCell(col_selected).setValue((Object)new Boolean(selected == false));
            }
        }
    }

    @Override
    protected void kDTable1_tableClicked(KDTMouseEvent e) throws Exception {
        super.kDTable1_tableClicked(e);
        this.selectedRowIndex = e.getRowIndex();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.dialog = this.getCommonQueryDialog();
        if (this.dialog.show()) {
            CustomerParams params = this.getFilterUI().getCustomerParams();
            this.setFilterParam(params);
            this.execQuery();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.execQuery();
    }

    @Override
    public void actionAutoCheck_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.getTblMain().getRowCount();
        if (rowCount <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        IRow row = null;
        HashMap<Object, List<BgInnerDataCheckInfo>> map = new HashMap<Object, List<BgInnerDataCheckInfo>>();
        List<BgInnerDataCheckInfo> checkList = null;
        ArrayList<String> lockIds = new ArrayList<String>();
        BgInnerDataCheckInfo info = null;
        Object key2 = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.getTblMain().getRow(i);
            if (row.getCell(col_dataId) == null || row.getCell(col_dataId).getValue() == null || !(row.getCell(col_confirmed).getValue() instanceof Boolean) || ((Boolean)row.getCell(col_confirmed).getValue()).booleanValue() || !(row.getCell(col_diff).getValue() instanceof BigDecimal) || ((Boolean)row.getCell(col_confirmed).getValue()).booleanValue() || (key2 = row.getUserObject()) == null) continue;
            checkList = (List)map.get(key2);
            if (checkList == null) {
                checkList = new ArrayList();
                map.put(key2, checkList);
            }
            info = new BgInnerDataCheckInfo();
            info.setId((String)row.getCell(col_dataId).getValue());
            info.setOrgUnitId((String)row.getCell(col_orgUnitId).getValue());
            if (row.getCell(col_creditFilled).getValue() instanceof BigDecimal) {
                info.setBizDirection(0);
                info.setFillAmount((BigDecimal)row.getCell(col_creditFilled).getValue());
                info.setAmount((BigDecimal)row.getCell(col_creditFilled).getValue());
            } else if (row.getCell(col_debitFilled).getValue() instanceof BigDecimal) {
                info.setBizDirection(1);
                info.setFillAmount(((BigDecimal)row.getCell(col_debitFilled).getValue()).multiply(new BigDecimal("-1")));
                info.setAmount((BigDecimal)row.getCell(col_debitFilled).getValue());
            }
            checkList.add(info);
        }
        if (!map.isEmpty()) {
            ArrayList<Object> keyToRemove = new ArrayList<Object>();
            for (Object key2 : map.keySet()) {
                BigDecimal diffAmount = new BigDecimal("0.00");
                checkList = (List)map.get(key2);
                int size = checkList.size();
                for (int i = 0; i < size; ++i) {
                    info = (BgInnerDataCheckInfo)checkList.get(i);
                    diffAmount = diffAmount.add(info.getFillAmount());
                }
                if (diffAmount.compareTo(new BigDecimal("0.00")) == 0) continue;
                keyToRemove.add(key2);
            }
            if (!keyToRemove.isEmpty()) {
                for (int i = 0; i < keyToRemove.size(); ++i) {
                    map.remove(keyToRemove.get(i));
                }
            }
        }
        checkList = new ArrayList();
        if (!map.isEmpty()) {
            for (Object key2 : map.keySet()) {
                checkList.addAll((List)map.get(key2));
            }
            map = new HashMap();
            map.put("datas", checkList);
            for (int i = 0; i < checkList.size(); ++i) {
                info = (BgInnerDataCheckInfo)checkList.get(i);
                if (lockIds.contains(info.getOrgUnitId())) continue;
                lockIds.add(info.getOrgUnitId());
            }
        }
        if (this.getBgElimFacade().confirmInnerData(map)) {
            this.refresh();
            this.showSuccessMsg(EASResource.getString((String)RES_PATH, (String)"autoCheckSuccess"));
        }
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        boolean checkSelected = false;
        int rowCount = this.getTblMain().getRowCount();
        IRow row = null;
        HashMap<Object, List<BgInnerDataCheckInfo>> map = new HashMap<Object, List<BgInnerDataCheckInfo>>();
        List<BgInnerDataCheckInfo> checkList = null;
        ArrayList<String> lockIds = new ArrayList<String>();
        BgInnerDataCheckInfo info = null;
        Object key2 = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.getTblMain().getRow(i);
            if (!(row.getCell(col_selected).getValue() instanceof Boolean) || !((Boolean)row.getCell(col_selected).getValue()).booleanValue() || row.getCell(col_dataId) == null || row.getCell(col_dataId).getValue() == null) continue;
            checkSelected = true;
            if (!(row.getCell(col_confirmed).getValue() instanceof Boolean) || ((Boolean)row.getCell(col_confirmed).getValue()).booleanValue() || (key2 = row.getUserObject()) == null) continue;
            checkList = (List)map.get(key2);
            if (checkList == null) {
                checkList = new ArrayList();
                map.put(key2, checkList);
            }
            info = new BgInnerDataCheckInfo();
            info.setId((String)row.getCell(col_dataId).getValue());
            info.setOrgUnitId((String)row.getCell(col_orgUnitId).getValue());
            info.setOrgUnitName((String)row.getCell(col_orgUnit).getValue());
            info.setOppOrgUnitName((String)row.getCell(col_oppOrgUnit).getValue());
            if (row.getCell(col_creditFilled).getValue() instanceof BigDecimal) {
                info.setAmount((BigDecimal)row.getCell(col_creditFilled).getValue());
                info.setFillAmount((BigDecimal)row.getCell(col_creditFilled).getValue());
            } else if (row.getCell(col_debitFilled).getValue() instanceof BigDecimal) {
                info.setAmount(((BigDecimal)row.getCell(col_debitFilled).getValue()).multiply(new BigDecimal("-1")));
                info.setFillAmount((BigDecimal)row.getCell(col_debitFilled).getValue());
            }
            checkList.add(info);
        }
        if (!checkSelected) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (!map.isEmpty()) {
            ArrayList<Object> deleteKey = new ArrayList<Object>();
            String[] orgNames = null;
            for (Object key2 : map.keySet()) {
                BigDecimal diffAmount = new BigDecimal("0.00");
                checkList = (List)map.get(key2);
                int size = checkList.size();
                for (int i = 0; i < size; ++i) {
                    info = (BgInnerDataCheckInfo)checkList.get(i);
                    diffAmount = diffAmount.add(info.getAmount());
                }
                if (diffAmount.compareTo(new BigDecimal("0.00")) == 0) continue;
                if (!deleteKey.contains(key2)) {
                    deleteKey.add(key2);
                }
                if (orgNames != null || info == null) continue;
                orgNames = new String[]{info.getOrgUnitName(), info.getOppOrgUnitName()};
            }
            for (int i = 0; i < deleteKey.size(); ++i) {
                map.remove(deleteKey.get(i));
            }
            if (orgNames != null) {
                MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"dataDiffCantConfirm"), orgNames));
            }
        }
        if (map.isEmpty()) {
            SysUtil.abort();
        }
        if (!map.isEmpty()) {
            checkList = new ArrayList();
            for (Object key2 : map.keySet()) {
                checkList.addAll((List)map.get(key2));
            }
            for (int i = 0; i < checkList.size(); ++i) {
                info = (BgInnerDataCheckInfo)checkList.get(i);
                info.setAmount(info.getFillAmount());
                if (lockIds.contains(info.getOrgUnitId())) continue;
                lockIds.add(info.getOrgUnitId());
            }
            map = new HashMap();
            map.put("datas", checkList);
        }
        if (this.getBgElimFacade().confirmInnerData(map)) {
            this.refresh();
            this.showSuccessMsg(EASResource.getString((String)RES_PATH, (String)"checkSuccess"));
        }
    }

    @Override
    public void actionCancelConfirm_actionPerformed(ActionEvent e) throws Exception {
        boolean checkSelected = false;
        int rowCount = this.getTblMain().getRowCount();
        IRow row = null;
        ArrayList<BgInnerDataCheckInfo> checkList = new ArrayList<BgInnerDataCheckInfo>();
        ArrayList<String> lockIds = new ArrayList<String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        BgInnerDataCheckInfo info = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.getTblMain().getRow(i);
            if (!(row.getCell(col_selected).getValue() instanceof Boolean) || !((Boolean)row.getCell(col_selected).getValue()).booleanValue() || row.getCell(col_dataId) == null || row.getCell(col_dataId).getValue() == null) continue;
            checkSelected = true;
            if (row.getCell(col_elimGen).getValue() instanceof Boolean && ((Boolean)row.getCell(col_elimGen).getValue()).booleanValue()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"genElimRecordCantCancelConfirm"));
                SysUtil.abort();
                continue;
            }
            if (!(row.getCell(col_confirmed).getValue() instanceof Boolean) || !((Boolean)row.getCell(col_confirmed).getValue()).booleanValue()) continue;
            info = new BgInnerDataCheckInfo();
            info.setId((String)row.getCell(col_dataId).getValue());
            info.setOrgUnitId((String)row.getCell(col_orgUnitId).getValue());
            info.setOppOrgUnitId((String)row.getCell(col_oppOrgUnitId).getValue());
            info.setBgItemNumber((String)row.getCell(col_bgItemNumber).getValue());
            checkList.add(info);
        }
        if (!checkSelected) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (!checkList.isEmpty()) {
            String elimTemplateId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getElimTemplateInfo().getId().toString();
            String bgSchemeId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getBgSchemeInfo().getId().toString();
            String bgPeriodId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getPeriodInfo().getId().toString();
            String bgElementId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getBgElementInfo().getId().toString();
            String currencyId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getCurrencyInfo().getId().toString();
            BgDataTypeEnum dataType = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getDataType();
            map.put("BG_ELIM_TEMPLATE", elimTemplateId);
            map.put("BG_SCHEME", bgSchemeId);
            map.put("BG_PERIOD", bgPeriodId);
            map.put("BG_ELEMENT", bgElementId);
            map.put("CURRENCY", currencyId);
            map.put("DATA_TYPE", dataType);
            map.put("datas", checkList);
            for (int i = 0; i < checkList.size(); ++i) {
                info = (BgInnerDataCheckInfo)checkList.get(i);
                if (lockIds.contains(info.getOrgUnitId())) continue;
                lockIds.add(info.getOrgUnitId());
            }
            if (this.getBgElimFacade().cancelConfirmInnerData(map)) {
                this.refresh();
                this.showSuccessMsg(EASResource.getString((String)RES_PATH, (String)"cancelCheckSuccess"));
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"noFitRecord"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionDiffDeal_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int rowCount = this.getTblMain().getRowCount();
        boolean checkSelected = false;
        IRow row = null;
        ArrayList<BgInnerDataCheckInfo> checkList = new ArrayList<BgInnerDataCheckInfo>();
        ArrayList<String> lockIds = new ArrayList<String>();
        BgInnerDataCheckInfo info = null;
        Object rowKey = null;
        Object orgNums = null;
        boolean viewMode = false;
        BigDecimal diffAmount = new BigDecimal("0.00");
        for (i = 0; i < rowCount; ++i) {
            row = this.getTblMain().getRow(i);
            if (!(row.getCell(col_selected).getValue() instanceof Boolean) || !((Boolean)row.getCell(col_selected).getValue()).booleanValue() || row.getCell(col_dataId) == null || row.getCell(col_dataId).getValue() == null) continue;
            checkSelected = true;
            if (row.getUserObject() != null) {
                if (rowKey == null) {
                    rowKey = row.getUserObject();
                }
                if (!rowKey.equals(row.getUserObject())) break;
                if (orgNums == null) {
                    orgNums = row.getUserObject();
                }
                info = new BgInnerDataCheckInfo();
                info.setId((String)row.getCell(col_dataId).getValue());
                info.setKey((String)rowKey);
                info.setOrgUnitId((String)row.getCell(col_orgUnitId).getValue());
                info.setOrgUnitName((String)row.getCell(col_orgUnit).getValue());
                info.setOppOrgUnitId((String)row.getCell(col_oppOrgUnitId).getValue());
                info.setOppOrgUnitName((String)row.getCell(col_oppOrgUnit).getValue());
                if (row.getCell(col_debitFilled).getValue() instanceof BigDecimal) {
                    info.setBizDirection(0);
                    info.setFillAmount(new BigDecimal(row.getCell(col_debitFilled).getValue().toString()));
                    info.setAmount(new BigDecimal(row.getCell(col_debitAmount).getValue().toString()));
                    diffAmount = diffAmount.add(info.getFillAmount());
                } else if (row.getCell(col_creditFilled).getValue() instanceof BigDecimal) {
                    info.setBizDirection(1);
                    info.setFillAmount(new BigDecimal(row.getCell(col_creditFilled).getValue().toString()));
                    info.setAmount(new BigDecimal(row.getCell(col_creditAmount).getValue().toString()));
                    diffAmount = diffAmount.subtract(info.getFillAmount());
                }
                info.setBgItemId((String)row.getCell(col_bgItemId).getValue());
                info.setBgItemNumber((String)row.getCell(col_bgItemNumber).getValue());
                info.setBgItemName((String)row.getCell(col_bgItemName).getValue());
                checkList.add(info);
            }
            if ((!(row.getCell(col_confirmed).getValue() instanceof Boolean) || !((Boolean)row.getCell(col_confirmed).getValue()).booleanValue()) && (!(row.getCell(col_elimGen).getValue() instanceof Boolean) || !((Boolean)row.getCell(col_elimGen).getValue()).booleanValue())) continue;
            viewMode = true;
        }
        if (!checkSelected) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (!checkList.isEmpty()) {
            for (i = 0; i < checkList.size(); ++i) {
                info = (BgInnerDataCheckInfo)checkList.get(i);
                if (lockIds.contains(info.getOrgUnitId())) continue;
                lockIds.add(info.getOrgUnitId());
            }
            String elimTemplateId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getElimTemplateInfo().getId().toString();
            String bgSchemeId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getBgSchemeInfo().getId().toString();
            String bgPeriodId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getPeriodInfo().getId().toString();
            String bgElementId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getBgElementInfo().getId().toString();
            String currencyId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getCurrencyInfo().getId().toString();
            BgDataTypeEnum dataType = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getDataType();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BG_ELIM_TEMPLATE", (Object)elimTemplateId);
            uiContext.put((Object)"BG_SCHEME", (Object)bgSchemeId);
            uiContext.put((Object)"BG_PERIOD", (Object)bgPeriodId);
            uiContext.put((Object)"BG_ELEMENT", (Object)bgElementId);
            uiContext.put((Object)"CURRENCY", (Object)currencyId);
            uiContext.put((Object)"DATA_TYPE", (Object)dataType);
            uiContext.put((Object)"datas", checkList);
            uiContext.put((Object)"diffAmount", (Object)diffAmount);
            uiContext.put((Object)"viewMode", (Object)new Boolean(viewMode));
            uiContext.put((Object)"orgNums", orgNums);
            uiContext.put((Object)"diffDeal", (Object)this.diffDeal);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getDiffDealUIName(), (Map)uiContext);
            window.show();
            this.diffDeal = null;
            this.refresh();
        } else {
            this.diffDeal = null;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"noFitRecord"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionBatchDiffDealUpper_actionPerformed(ActionEvent e) throws Exception {
        this.diffDeal = BgElimDiffDealEnum.Up;
        this.readlyBatchDiffDeal();
    }

    @Override
    public void actionBatchDiffDealLower_actionPerformed(ActionEvent e) throws Exception {
        this.diffDeal = BgElimDiffDealEnum.low;
        this.readlyBatchDiffDeal();
    }

    @Override
    public void actionBatchDiffDealManual_actionPerformed(ActionEvent e) throws Exception {
        this.diffDeal = BgElimDiffDealEnum.manual;
        this.actionDiffDeal_actionPerformed(e);
    }

    @Override
    public void actionEditInnerData_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        if (this.selectedRowIndex == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((row = this.getTblMain().getRow(this.selectedRowIndex)) != null) {
            String orgUnitId = (String)row.getCell(col_orgUnitId).getValue();
            if (StringUtils.isEmpty((String)orgUnitId)) {
                return;
            }
            FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
            orgUnitInfo.setId(BOSUuid.read((String)orgUnitId));
            String id = (String)row.getCell(col_dataId).getValue();
            if (StringUtils.isEmpty((String)id)) {
                return;
            }
            IPermission iPer = PermissionFactory.getRemoteInstance();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            iPer.checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(orgUnitId), "BgInnerFillData004_edit");
            String infoId = null;
            try {
                IBgInnerFillDataEntry iInnerFillDataEntry = BgInnerFillDataEntryFactory.getRemoteInstance();
                BgInnerFillDataEntryInfo entryInfo = iInnerFillDataEntry.getBgInnerFillDataEntryInfo("select bgInnerFillData where id = '" + id + "'");
                infoId = entryInfo.getBgInnerFillData().getId().toString();
            }
            catch (Exception ex) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"notInnerFillDataCantEdit"));
                SysUtil.abort();
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", infoId);
            uiContext.put((Object)"OrgUnitInfo", (Object)orgUnitInfo);
            uiContext.put((Object)"isFromInnerDataCheck", (Object)new Boolean(true));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getInnerFillDataEditUIName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
    }

    @Override
    public void actionGenElim_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.getTblMain().getRowCount();
        boolean checkSelected = false;
        boolean isAllEdit = true;
        IRow row = null;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        List<BgInnerDataCheckInfo> checkList = null;
        BgInnerDataCheckInfo info = null;
        Object key2 = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.getTblMain().getRow(i);
            if (!(row.getCell(col_selected).getValue() instanceof Boolean) || !((Boolean)row.getCell(col_selected).getValue()).booleanValue() || row.getCell(col_dataId) == null || row.getCell(col_dataId).getValue() == null) continue;
            checkSelected = true;
            if (!(row.getCell(col_confirmed).getValue() instanceof Boolean) || !((Boolean)row.getCell(col_confirmed).getValue()).booleanValue()) continue;
            isAllEdit = false;
            if (!(row.getCell(col_elimGen).getValue() instanceof Boolean) || ((Boolean)row.getCell(col_elimGen).getValue()).booleanValue() || (key2 = row.getUserObject()) == null) continue;
            checkList = (List)map.get(key2);
            if (checkList == null) {
                checkList = new ArrayList<BgInnerDataCheckInfo>();
                map.put(key2, checkList);
            }
            info = new BgInnerDataCheckInfo();
            info.setId((String)row.getCell(col_dataId).getValue());
            info.setOrgUnitId((String)row.getCell(col_orgUnitId).getValue());
            info.setOrgUnitName((String)row.getCell(col_orgUnit).getValue());
            info.setOppOrgUnitName((String)row.getCell(col_oppOrgUnit).getValue());
            info.setBgItemId((String)row.getCell(col_bgItemId).getValue());
            info.setBgItemNumber((String)row.getCell(col_bgItemNumber).getValue());
            info.setBgItemName((String)row.getCell(col_bgItemName).getValue());
            if (row.getCell(col_creditAmount).getValue() instanceof BigDecimal) {
                info.setFillAmount(new BigDecimal(row.getCell(col_creditAmount).getValue().toString()));
                info.setAmount(new BigDecimal(row.getCell(col_creditAmount).getValue().toString()));
                info.setBizDirection(1);
            } else if (row.getCell(col_debitAmount).getValue() instanceof BigDecimal) {
                info.setFillAmount(new BigDecimal(row.getCell(col_debitAmount).getValue().toString()).multiply(new BigDecimal("-1")));
                info.setAmount(new BigDecimal(row.getCell(col_debitAmount).getValue().toString()));
                info.setBizDirection(0);
            }
            checkList.add(info);
        }
        if (!checkSelected) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (!map.isEmpty()) {
            ArrayList<Object> keyToDelete = new ArrayList<Object>();
            String[] orgNames = null;
            for (Object key2 : map.keySet()) {
                BigDecimal diffAmount = new BigDecimal("0.00");
                checkList = (ArrayList<BgInnerDataCheckInfo>)map.get(key2);
                int size = checkList.size();
                for (int i = 0; i < size; ++i) {
                    info = (BgInnerDataCheckInfo)checkList.get(i);
                    diffAmount = info.getFillAmount() == null ? diffAmount.add(new BigDecimal("0.00")) : diffAmount.add(info.getFillAmount());
                }
                if (diffAmount.compareTo(new BigDecimal("0.00")) == 0) continue;
                if (!keyToDelete.contains(key2)) {
                    keyToDelete.add(key2);
                }
                if (orgNames != null || info == null) continue;
                orgNames = new String[]{info.getOrgUnitName(), info.getOppOrgUnitName()};
            }
            for (int i = 0; i < keyToDelete.size(); ++i) {
                map.remove(keyToDelete.get(i));
            }
            if (orgNames != null) {
                MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"dataDiffCantGenElim"), orgNames));
            }
            if (map.isEmpty()) {
                return;
            }
        } else if (isAllEdit) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"editStateCantGenElim"));
            SysUtil.abort();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"noFitRecord"));
            SysUtil.abort();
        }
        map.put("ORG_TREE", this.ctx.getCurOrgBound().getId().toString());
        map.put("BG_ELIM_TEMPLATE", ((BgInnerDataCheckFilterParam)this.getFilterParam()).getElimTemplateInfo().getId().toString());
        map.put("BG_SCHEME", ((BgInnerDataCheckFilterParam)this.getFilterParam()).getBgSchemeInfo().getId().toString());
        map.put("BG_PERIOD", ((BgInnerDataCheckFilterParam)this.getFilterParam()).getPeriodInfo().getId().toString());
        map.put("BG_ELEMENT", ((BgInnerDataCheckFilterParam)this.getFilterParam()).getBgElementInfo().getId().toString());
        map.put("CURRENCY", ((BgInnerDataCheckFilterParam)this.getFilterParam()).getCurrencyInfo().getId().toString());
        map.put("DATA_TYPE", ((BgInnerDataCheckFilterParam)this.getFilterParam()).getDataType());
        map.put("ELIM_TYPE", (Object)((BgInnerDataCheckFilterParam)this.getFilterParam()).getElimTemplateInfo().getElimType());
        if (this.getBgElimFacade().genElimination(map)) {
            this.refresh();
            this.showSuccessMsg(EASResource.getString((String)RES_PATH, (String)"genElimSuccess"));
        }
    }

    protected void refresh() {
        this.execQuery();
        this.kDTable1.setScrollStateVertical(0);
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, this);
    }

    protected IObjectPK getOrgPK() {
        try {
            if (this.ctx.getCurOrgGroup() != null) {
                return new ObjectUuidPK(this.ctx.getCurOrgGroup().getId());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            this.handUIException(e);
        }
        return super.getOrgPK();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        try {
            if (this.ctx.getCurOrgGroup() != null) {
                return new ObjectUuidPK(this.ctx.getCurOrgGroup().getId());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            this.handUIException(e);
        }
        return super.getOrgPK(action);
    }

    private IBgElimFacade getBgElimFacade() throws BOSException {
        return BgElimFacadeFactory.getRemoteInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object upPack(String objStr) {
        if (objStr == null) {
            return null;
        }
        byte[] objByte = Base64.decode((String)objStr);
        if (objByte == null || objByte.length == 0) {
            return null;
        }
        Object obj = null;
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            obj = bais.readObject();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return obj;
    }

    protected KDTable getTblMain() {
        return this.kDTable1;
    }

    protected String getDiffDealUIName() {
        return BgInnerDataDiffDealUI.class.getName();
    }

    protected String getInnerFillDataEditUIName() {
        return BgInnerFillDataEditUI.class.getName();
    }

    public void showSuccessMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.setMessageText(msg);
        this.showMessage();
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (value instanceof BigDecimal) {
            if (BgNConstants.ZERO.compareTo((BigDecimal)value) == 0) {
                return null;
            }
            if (StringUtils.isEmpty((String)cell.getFormattedStyleAttributes().getNumberFormat())) {
                cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                cell.getStyleAttributes().setNumberFormat(NUM_FOTMATTER);
            }
        }
        return value;
    }

    private IBgElimTemplate getBgElimTemplateInterface() throws BOSException {
        return BgElimTemplateFactory.getRemoteInstance();
    }

    private BgElimTemplateInfo getElimTemplate() throws Exception {
        String elimTemplateId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getElimTemplateInfo().getId().toString();
        this.elimTemplateInfo = this.getBgElimTemplateInterface().getBgElimTemplateInfo("select diffDeal, elimType, entries.bgItemId, entries.bgItemNumber, entries.bgItemName, entries.bizDirection where id = '" + elimTemplateId + "'");
        return this.elimTemplateInfo;
    }

    public List getCheckList() throws Exception {
        ArrayList<BgInnerDataCheckInfo> checkList = new ArrayList<BgInnerDataCheckInfo>();
        int rowCount = this.getTblMain().getRowCount();
        boolean checkSelected = false;
        IRow row = null;
        BgInnerDataCheckInfo info = null;
        Object rowKey = null;
        Object orgNums = null;
        BigDecimal diffAmount = new BigDecimal("0.00");
        boolean isConfirme = false;
        for (int i = 0; i < rowCount; ++i) {
            row = this.getTblMain().getRow(i);
            if (row.getCell(col_selected).getValue() instanceof Boolean && ((Boolean)row.getCell(col_selected).getValue()).booleanValue() && row.getCell(col_dataId) != null && row.getCell(col_dataId).getValue() != null) {
                if (row.getCell(col_confirmed).getValue() instanceof Boolean && ((Boolean)row.getCell(col_confirmed).getValue()).booleanValue()) {
                    isConfirme = true;
                }
                checkSelected = true;
                if (row.getUserObject() == null) continue;
                if (rowKey == null) {
                    rowKey = row.getUserObject();
                }
                if (orgNums == null) {
                    orgNums = row.getUserObject();
                }
                info = new BgInnerDataCheckInfo();
                info.setId((String)row.getCell(col_dataId).getValue());
                info.setKey((String)rowKey);
                info.setOrgUnitId((String)row.getCell(col_orgUnitId).getValue());
                info.setOrgUnitName((String)row.getCell(col_orgUnit).getValue());
                info.setOppOrgUnitId((String)row.getCell(col_oppOrgUnitId).getValue());
                info.setOppOrgUnitName((String)row.getCell(col_oppOrgUnit).getValue());
                if (row.getCell(col_debitFilled).getValue() instanceof BigDecimal) {
                    info.setBizDirection(0);
                    info.setFillAmount((BigDecimal)row.getCell(col_debitFilled).getValue());
                    info.setAmount(new BigDecimal(row.getCell(col_debitAmount).getValue().toString()));
                    diffAmount = diffAmount.add(info.getFillAmount());
                } else if (row.getCell(col_creditFilled).getValue() instanceof BigDecimal) {
                    info.setBizDirection(1);
                    info.setFillAmount((BigDecimal)row.getCell(col_creditFilled).getValue());
                    info.setAmount(new BigDecimal(row.getCell(col_creditAmount).getValue().toString()));
                    diffAmount = diffAmount.subtract(info.getFillAmount());
                }
                info.setBgItemId((String)row.getCell(col_bgItemId).getValue());
                info.setBgItemNumber((String)row.getCell(col_bgItemNumber).getValue());
                info.setBgItemName((String)row.getCell(col_bgItemName).getValue());
                checkList.add(info);
                continue;
            }
            if (row.getCell(col_selected).getValue() instanceof Boolean && !((Boolean)row.getCell(col_selected).getValue()).booleanValue() && row.getCell(col_dataId) != null && row.getCell(col_dataId).getValue() != null) continue;
            if (isConfirme) {
                isConfirme = false;
                checkList.clear();
                continue;
            }
            this.dealRows.clear();
            this.dealData(this.getElimTemplate(), checkList, diffAmount);
            checkList.clear();
            diffAmount = new BigDecimal("0.00");
        }
        this.diffDeal = null;
        if (!checkSelected) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        return checkList;
    }

    private void dealData(BgElimTemplateInfo elimTemplateInfo, List datas, BigDecimal diffAmountA) throws Exception {
        if (elimTemplateInfo == null || datas == null || datas.isEmpty()) {
            return;
        }
        BgInnerDataCheckInfo info = (BgInnerDataCheckInfo)datas.get(0);
        String[] orgUnitId = new String[]{info.getOrgUnitId(), info.getOppOrgUnitId()};
        String[] orgUnitName = new String[]{info.getOrgUnitName(), info.getOppOrgUnitName()};
        String[] oppOrgUnitId = new String[]{info.getOppOrgUnitId(), info.getOrgUnitId()};
        String[] oppOrgUnitName = new String[]{info.getOppOrgUnitName(), info.getOrgUnitName()};
        BgElimTemplateEntryCollection entryCol = elimTemplateInfo.getEntries();
        BgElimTemplateEntryInfo entryInfo = null;
        int size = entryCol.size();
        HashMap<String, Object> rowMap = null;
        BigDecimal sumDebitFill = new BigDecimal("0.00");
        BigDecimal sumCreditFill = new BigDecimal("0.00");
        BigDecimal diffAmount = diffAmountA;
        diffAmount = this.preHandleDiff(datas, diffAmount);
        for (int orgIndex = 0; orgIndex < orgUnitId.length; ++orgIndex) {
            for (int i = 0; i < size; ++i) {
                int j;
                entryInfo = entryCol.get(i);
                rowMap = new HashMap<String, Object>();
                rowMap.put(col_orgUnitId, orgUnitId[orgIndex]);
                rowMap.put(col_orgUnit, orgUnitName[orgIndex]);
                rowMap.put(col_oppOrgUnitId, oppOrgUnitId[orgIndex]);
                rowMap.put(col_oppOrgUnit, oppOrgUnitName[orgIndex]);
                rowMap.put(col_bgItemNumber, entryInfo.getBgItemNumber());
                rowMap.put(col_bgItemName, entryInfo.getBgItemName());
                if (entryInfo.getBizDirection() == BizDirectionEnum.Borrow) {
                    rowMap.put("way", "borrow");
                    rowMap.put(col_debitFilled, new BigDecimal("0.00"));
                    rowMap.put(col_debitAmount, new BigDecimal("0.00"));
                    for (j = 0; j < datas.size(); ++j) {
                        info = (BgInnerDataCheckInfo)datas.get(j);
                        if (!orgUnitId[orgIndex].equals(info.getOrgUnitId()) || !oppOrgUnitId[orgIndex].equals(info.getOppOrgUnitId()) || !entryInfo.getBgItemNumber().equals(info.getBgItemNumber())) continue;
                        if (rowMap.containsKey(col_debitFilled)) {
                            rowMap.remove(col_debitFilled);
                        }
                        if (rowMap.containsKey(col_debitAmount)) {
                            rowMap.remove(col_debitAmount);
                        }
                        rowMap.put(col_debitFilled, info.getFillAmount());
                        rowMap.put(col_debitAmount, info.getAmount());
                        sumDebitFill = sumDebitFill.add(info.getFillAmount());
                        rowMap.put(col_dataId, info.getId());
                        rowMap.put("UserObject", info.getKey());
                        datas.remove(info);
                        break;
                    }
                } else if (entryInfo.getBizDirection() == BizDirectionEnum.loan) {
                    rowMap.put("way", "loan");
                    rowMap.put(col_creditFilled, new BigDecimal("0.00"));
                    rowMap.put(col_creditAmount, new BigDecimal("0.00"));
                    for (j = 0; j < datas.size(); ++j) {
                        info = (BgInnerDataCheckInfo)datas.get(j);
                        if (!orgUnitId[orgIndex].equals(info.getOrgUnitId()) || !oppOrgUnitId[orgIndex].equals(info.getOppOrgUnitId()) || !entryInfo.getBgItemNumber().equals(info.getBgItemNumber())) continue;
                        if (rowMap.containsKey(col_debitFilled)) {
                            rowMap.remove(col_debitFilled);
                        }
                        if (rowMap.containsKey(col_debitAmount)) {
                            rowMap.remove(col_debitAmount);
                        }
                        rowMap.put(col_creditFilled, info.getFillAmount());
                        rowMap.put(col_creditAmount, info.getAmount());
                        sumCreditFill = sumCreditFill.add(info.getFillAmount());
                        rowMap.put(col_dataId, info.getId());
                        rowMap.put("UserObject", info.getKey());
                        datas.remove(info);
                        break;
                    }
                }
                rowMap.put(col_diff, diffAmount);
                this.dealRows.add(rowMap);
            }
        }
        if (diffAmount.compareTo(new BigDecimal("0.00")) != 0) {
            this.handleDiff();
        }
        this.submit();
    }

    public void submit() throws Exception {
        int rowCount = this.dealRows.size();
        Map rowMap = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<BgInnerDataCheckInfo> checkList = new ArrayList<BgInnerDataCheckInfo>();
        BgInnerDataCheckInfo info = null;
        Object key = null;
        BigDecimal diffAmount = new BigDecimal("0.00");
        for (int i = 0; i < rowCount; ++i) {
            rowMap = (Map)this.dealRows.get(i);
            if (this.isEmptyRow(rowMap)) continue;
            if (key == null && rowMap.containsKey("UserObject")) {
                key = rowMap.get("UserObject");
            }
            info = new BgInnerDataCheckInfo();
            if (rowMap.containsKey(col_dataId)) {
                info.setId(rowMap.get(col_dataId).toString());
            }
            info.setOrgUnitId(rowMap.get(col_orgUnitId).toString());
            info.setOppOrgUnitId(rowMap.get(col_oppOrgUnitId).toString());
            if (rowMap.containsKey(col_bgItemId)) {
                info.setBgItemId(rowMap.get(col_bgItemId).toString());
            }
            info.setBgItemNumber(rowMap.get(col_bgItemNumber).toString());
            info.setBgItemName(rowMap.get(col_bgItemName).toString());
            if (rowMap.get(col_debitAmount) != null) {
                info.setAmount(new BigDecimal(rowMap.get(col_debitAmount).toString()));
                diffAmount = diffAmount.add(info.getAmount());
            } else if (rowMap.get(col_creditAmount) != null) {
                info.setAmount(new BigDecimal(rowMap.get(col_creditAmount).toString()));
                diffAmount = diffAmount.subtract(info.getAmount());
            }
            checkList.add(info);
        }
        if (!checkList.isEmpty()) {
            String bgSchemeId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getBgSchemeInfo().getId().toString();
            String bgPeriodId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getPeriodInfo().getId().toString();
            String bgElementId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getBgElementInfo().getId().toString();
            String currencyId = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getCurrencyInfo().getId().toString();
            BgDataTypeEnum dataType = ((BgInnerDataCheckFilterParam)this.getFilterParam()).getDataType();
            map.put("datas", checkList);
            map.put("BG_SCHEME", bgSchemeId);
            map.put("BG_PERIOD", bgPeriodId);
            map.put("BG_ELEMENT", bgElementId);
            map.put("CURRENCY", currencyId);
            map.put("DATA_TYPE", dataType);
            if (this.getBgElimFacade().confirmInnerData(map)) {
                String Message = EASResource.getString((String)BTN_TEXT, (String)"batchDiffMessage");
                this.showSuccessMsg(Message);
            }
        }
    }

    private void handleDiff() {
        block12: {
            BigDecimal amount;
            BigDecimal diffAmount;
            Map rowMap;
            int rowCount;
            block13: {
                block14: {
                    rowCount = this.dealRows.size();
                    if (rowCount <= 0) {
                        return;
                    }
                    Map diffMap = (Map)this.dealRows.get(0);
                    rowMap = null;
                    diffAmount = (BigDecimal)diffMap.get(col_diff);
                    amount = null;
                    if (!BgElimDiffDealEnum.Up.equals((Object)this.diffDeal)) break block13;
                    if (diffAmount == null || diffAmount.compareTo(BgNConstants.ZERO) <= 0) break block14;
                    for (int i = 0; i < rowCount; ++i) {
                        rowMap = (Map)this.dealRows.get(i);
                        amount = (BigDecimal)rowMap.get(col_creditAmount);
                        if (amount == null) continue;
                        if (rowMap.containsKey(col_creditAmount)) {
                            rowMap.remove(col_creditAmount);
                        }
                        rowMap.put(col_creditAmount, amount.add(diffAmount.abs()));
                        break block12;
                    }
                    break block12;
                }
                if (diffAmount == null || diffAmount.compareTo(BgNConstants.ZERO) >= 0) break block12;
                for (int i = 0; i < rowCount; ++i) {
                    rowMap = (Map)this.dealRows.get(i);
                    amount = (BigDecimal)rowMap.get(col_debitAmount);
                    if (amount == null) continue;
                    if (rowMap.containsKey(col_debitAmount)) {
                        rowMap.remove(col_debitAmount);
                    }
                    rowMap.put(col_debitAmount, amount.add(diffAmount.abs()));
                    break block12;
                }
                break block12;
            }
            if (!BgElimDiffDealEnum.low.equals((Object)this.diffDeal)) break block12;
            if (diffAmount != null && diffAmount.compareTo(BgNConstants.ZERO) > 0) {
                for (int i = 0; i < rowCount; ++i) {
                    rowMap = (Map)this.dealRows.get(i);
                    amount = (BigDecimal)rowMap.get(col_debitAmount);
                    if (amount == null) continue;
                    if (rowMap.containsKey(col_debitAmount)) {
                        rowMap.remove(col_debitAmount);
                    }
                    rowMap.put(col_debitAmount, amount.subtract(diffAmount.abs()));
                    break;
                }
            } else if (diffAmount != null && diffAmount.compareTo(BgNConstants.ZERO) < 0) {
                for (int i = 0; i < rowCount; ++i) {
                    rowMap = (Map)this.dealRows.get(i);
                    amount = (BigDecimal)rowMap.get(col_creditAmount);
                    if (amount == null) continue;
                    if (rowMap.containsKey(col_creditAmount)) {
                        rowMap.remove(col_creditAmount);
                    }
                    rowMap.put(col_creditAmount, amount.subtract(diffAmount.abs()));
                    break;
                }
            }
        }
    }

    private BigDecimal preHandleDiff(List datas, BigDecimal diffAmount) {
        block17: {
            int i;
            int debitIndex;
            int creditIndex;
            int debitSize;
            int creditSize;
            int size;
            BigDecimal adjAmount;
            BgInnerDataCheckInfo info;
            block16: {
                if (datas == null || datas.isEmpty()) {
                    return diffAmount;
                }
                info = null;
                adjAmount = null;
                size = datas.size();
                creditSize = 0;
                debitSize = 0;
                creditIndex = 0;
                debitIndex = 0;
                for (i = 0; i < size; ++i) {
                    info.setAmount((info = (BgInnerDataCheckInfo)datas.get(i)).getFillAmount() == null ? BgNConstants.ZERO : info.getFillAmount());
                    if (info.getBizDirection() == 0) {
                        ++debitSize;
                        continue;
                    }
                    ++creditSize;
                }
                if (diffAmount == null || diffAmount.compareTo(BgNConstants.ZERO) == 0) {
                    return diffAmount;
                }
                if (!BgElimDiffDealEnum.Up.equals((Object)this.diffDeal)) break block16;
                if (diffAmount.compareTo(BgNConstants.ZERO) > 0) {
                    for (i = 0; i < size; ++i) {
                        info = (BgInnerDataCheckInfo)datas.get(i);
                        if (info.getBizDirection() != 1) continue;
                        adjAmount = info.getAmount().add(diffAmount.abs());
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        info = (BgInnerDataCheckInfo)datas.get(i);
                        if (info.getBizDirection() != 0) continue;
                        adjAmount = info.getAmount().add(diffAmount.abs());
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                }
                break block17;
            }
            if (!BgElimDiffDealEnum.low.equals((Object)this.diffDeal)) break block17;
            if (diffAmount.compareTo(BgNConstants.ZERO) > 0) {
                for (i = 0; i < size; ++i) {
                    info = (BgInnerDataCheckInfo)datas.get(i);
                    if (info.getBizDirection() != 0) continue;
                    if (++debitIndex >= debitSize) {
                        adjAmount = info.getAmount().subtract(diffAmount.abs());
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                    if (info.getAmount().compareTo(BgNConstants.ZERO) < 0) continue;
                    if (info.getAmount().subtract(diffAmount.abs()).compareTo(BgNConstants.ZERO) >= 0) {
                        adjAmount = info.getAmount().subtract(diffAmount.abs());
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                    diffAmount = info.getAmount().subtract(diffAmount.abs());
                    info.setAmount(BgNConstants.ZERO);
                }
            } else {
                for (i = 0; i < size; ++i) {
                    info = (BgInnerDataCheckInfo)datas.get(i);
                    if (info.getBizDirection() != 1) continue;
                    if (++creditIndex >= creditSize) {
                        adjAmount = info.getAmount().subtract(diffAmount.abs());
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                    if (info.getAmount().compareTo(BgNConstants.ZERO) < 0) continue;
                    if (info.getAmount().compareTo(diffAmount.abs()) >= 0) {
                        adjAmount = info.getAmount().add(diffAmount);
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                    diffAmount = info.getAmount().subtract(diffAmount.abs());
                    info.setAmount(BgNConstants.ZERO);
                }
            }
        }
        return diffAmount;
    }

    private boolean isEmptyRow(Map row) {
        if (row == null) {
            return true;
        }
        return !(row.get(col_creditFilled) instanceof BigDecimal && BgNConstants.ZERO.compareTo((BigDecimal)row.get(col_creditFilled)) != 0 || row.get(col_debitFilled) instanceof BigDecimal && BgNConstants.ZERO.compareTo((BigDecimal)row.get(col_debitFilled)) != 0 || row.get(col_creditAmount) instanceof BigDecimal && BgNConstants.ZERO.compareTo((BigDecimal)row.get(col_creditAmount)) != 0) && (!(row.get(col_debitAmount) instanceof BigDecimal) || BgNConstants.ZERO.compareTo((BigDecimal)row.get(col_debitAmount)) == 0);
    }

    private void readlyBatchDiffDeal() throws Exception {
        this.dealRows.clear();
        this.getCheckList();
        this.refresh();
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 20;
    }

    private final class UserCellDisplayParser
    implements IUserCellDisplayParser {
        private UserCellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return BgInnerDataCheckMainUI.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }
}

