/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgElimContext;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgElimException;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataEntryCollection;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataEntryFactory;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataEntryInfo;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataFactory;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataInfo;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataStatusEnum;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.IBgInnerFillData;
import com.kingdee.eas.ma.nbudget.IBgInnerFillDataEntry;
import com.kingdee.eas.ma.nbudget.client.AbstractBgInnerFillDataEditUI;
import com.kingdee.eas.ma.nbudget.client.BgCodeNumberCHelper;
import com.kingdee.eas.ma.nbudget.client.BgInnerDataCheckMainUI;
import com.kingdee.eas.ma.nbudget.client.BgInnerFillDataLoadUI;
import com.kingdee.eas.ma.nbudget.client.IBgElimContextUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgInnerFillDataEditUI
extends AbstractBgInnerFillDataEditUI
implements IBgElimContextUI {
    private static final long serialVersionUID = 3575010863874889081L;
    private static final Logger logger = CoreUIObject.getLogger(BgInnerFillDataEditUI.class);
    private BgElimContext ctx = null;
    private FullOrgUnitInfo orgUnitInfo = null;
    private static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    private String[] especialChar = new String[]{"|", "_", "*", "/", "%"};
    protected String bgItemNumberColIndex = "bgItemNumber";
    protected String bgItemNameColIndex = "bgItemName";
    protected String bgOppOrgUnitColIndex = "oppOrgUnit";
    protected String bgStatusColIndex = "status";
    protected String valueIndex = "value";
    private boolean isFromCheckUI = false;
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;

    public BgInnerFillDataEditUI() throws Exception {
        this.ctx = BgElimContext.getInstance();
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo");
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgInnerFillDataFactory.getRemoteInstance();
    }

    protected ICoreBase getBizEntryInterface() throws Exception {
        return BgInnerFillDataEntryFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        FullOrgUnitInfo orgUnit;
        super.onLoad();
        this.initialization();
        BgElimContextHelper.registUIObject(this);
        this.refreshBgScheme();
        if (this.ctx.isInitialized()) {
            this.bgElimContextToUI(this.ctx);
        }
        this.btnAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.MenuItemAttachment.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.MenuItemAttachment.getAction().setEnabled(false);
        Boolean isFromInnerDataCheck = (Boolean)this.getUIContext().get("isFromInnerDataCheck");
        if (isFromInnerDataCheck != null) {
            this.isFromCheckUI = isFromInnerDataCheck;
        }
        if ((orgUnit = (FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo")) != null) {
            String OUID = orgUnit.getId().toString();
            this.setHasCodeNumber(BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, OUID));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, OUID));
            }
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.getDetailTable() != null) {
                this.addLine(this.getDetailTable());
            }
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.menuItemRemove.setEnabled(false);
            this.menuItemRemove.setVisible(false);
            this.setRowsStatus();
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.workBtnAddLine.setEnabled(false);
            this.workbtnRemoveLine.setEnabled(false);
            this.actionAddNewLine.setEnabled(false);
            this.actionDeleteLine.setEnabled(false);
            this.btnAddNew.setEnabled(false);
            this.actionAddNew.setEnabled(false);
            this.btnAddLine.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.btnQuickLoad.setEnabled(false);
            this.actionQuickLoad.setEnabled(false);
            this.menuItemInsertLine.setEnabled(false);
            this.menuItemRemoveLine.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
        if (this.kdtEntries != null) {
            KDTMenuManager tm = this.getMenuManager(this.kdtEntries);
            Component[] menus = tm.getMenu().getComponents();
            for (int i = 0; i < menus.length; ++i) {
                if (!(menus[i] instanceof JMenuItem)) continue;
                JMenuItem menu = (JMenuItem)menus[i];
                menu.setVisible(false);
            }
            this.kdtEntries.getColumn("oppOrgUnit").setRequired(true);
            this.kdtEntries.getColumn("bgItemNumber").setRequired(true);
            this.kdtEntries.getColumn("value").setRequired(true);
            this.kdtEntries.getColumn("status").getStyleAttributes().setBackground(new Color(230, 230, 230));
        }
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        if (number != null && number.length() > 0) {
            caller.put("number", (Object)number);
            this.txtNumber.setText(number);
        }
    }

    protected void setNumberTextEnabled() {
        this.txtNumber.setEnabled(true);
        this.txtNumber.setEditable(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.workBtnAddLine.setText("");
        this.workbtnRemoveLine.setText("");
        this.workBtnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.workbtnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        if (this.isFromCheckUI) {
            this.resetUI4InnerDataCheck();
            this.setUnEnabledContent(false);
        }
        if (this.isHasCodeNumber()) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
        }
        this.actionCopy.setEnabled(true);
        this.actionCopy.setVisible(true);
        this.btnCopy.setEnabled(true);
        this.btnCopy.setVisible(true);
        this.menuItemCopy.setEnabled(true);
        this.menuItemCopy.setVisible(true);
        this.MenuItemAttachment.getAction().setEnabled(false);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.setRowsStatus();
        this.btnAttachment.setVisible(false);
    }

    private void setRowsStatus() {
        boolean canEdit = true;
        IRow row = null;
        int rowCount = 0;
        rowCount = this.getDetailTable().getBody().size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.getDetailTable().getRow(rowIndex);
            if (row == null) continue;
            BgInnerFillDataStatusEnum status = (BgInnerFillDataStatusEnum)((Object)row.getCell("status").getValue());
            if (status.getValue() != 1) {
                row.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(new Color(230, 230, 230));
                canEdit = false;
                continue;
            }
            this.actionDeleteLine.setEnabled(true);
            this.workbtnRemoveLine.setEnabled(true);
        }
        if (!canEdit) {
            this.setUnEnabledContent(false);
        }
    }

    private void setUnEnabledContent(boolean bool) {
        this.txtNumber.setEnabled(bool);
        this.txtName.setEnabled(bool);
        this.comboDataType.setEnabled(bool);
        this.comboElimType.setEnabled(bool);
        this.prmtBgScheme.setEnabled(bool);
        this.prmtBgPeriod.setEnabled(bool);
        this.prmtBgElement.setEnabled(bool);
        this.prmtCurrency.setEnabled(bool);
    }

    private void resetUI4InnerDataCheck() {
        this.btnAddNew.setEnabled(false);
        this.menuItemAddNew.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.menuItemRemove.setEnabled(false);
        this.btnAddLine.setEnabled(false);
        this.menuItemAddLine.setEnabled(false);
        this.btnInsertLine.setEnabled(false);
        this.menuItemInsertLine.setEnabled(false);
        this.btnRemoveLine.setEnabled(false);
        this.menuItemRemoveLine.setEnabled(false);
        this.btnCopyLine.setEnabled(false);
        this.menuItemCopyLine.setEnabled(false);
        this.btnQuickLoad.setEnabled(false);
        this.workBtnAddLine.setEnabled(false);
        this.workbtnRemoveLine.setEnabled(false);
        int colCount = this.getDetailTable().getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            if (i == 4) continue;
            this.getDetailTable().getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected void kdtEntries_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return;
        }
        int rowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        IRow row = this.kdtEntries.getRow(rowIndex);
        if (row != null && !this.isFromCheckUI) {
            BgInnerFillDataStatusEnum status = (BgInnerFillDataStatusEnum)((Object)row.getCell("status").getValue());
            if (status.getValue() != 1) {
                this.actionDeleteLine.setEnabled(false);
                this.workbtnRemoveLine.setEnabled(false);
                this.menuItemRemoveLine.setEnabled(false);
                this.actionRemoveLine.setEnabled(false);
                this.btnRemoveLine.setEnabled(false);
            } else {
                this.actionDeleteLine.setEnabled(true);
                this.workbtnRemoveLine.setEnabled(true);
                this.menuItemRemoveLine.setEnabled(true);
                this.actionRemoveLine.setEnabled(true);
                this.btnRemoveLine.setEnabled(true);
            }
        }
    }

    private void bgElimContextToUI(IBgElimContext ctx) {
        try {
            if (ctx.getCurBgScheme() != null) {
                this.prmtBgScheme.setData((Object)ctx.getCurBgScheme());
                this.prmtBgScheme.setEnabled(false);
            }
            if (ctx.getCurBgPeriod() != null) {
                this.prmtBgPeriod.setData((Object)ctx.getCurBgPeriod());
                this.prmtBgPeriod.setEnabled(false);
            }
            if (ctx.getCurBgDataType() != null) {
                this.comboDataType.setSelectedItem((Object)ctx.getCurBgDataType());
                this.comboDataType.setEnabled(false);
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuickLoad.setEnabled(true);
        this.btnQuickLoad.setIcon(EASResource.getIcon((String)"imgTbtn_inceptreport"));
    }

    private void initialization() throws EASBizException, BOSException {
        KDFormattedTextField formattedTextField = null;
        formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(10);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.comboDataType.setSelectedItem((Object)BgDataTypeEnum.BgData);
        }
        this.comboElimType.removeItem((Object)BgElimTypeEnum.None);
        this.comboElimType.removeItem((Object)BgElimTypeEnum.All);
        BgPeriodDialog dialog = new BgPeriodDialog();
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.resetBgItemF7();
        this.getDetailTable().getColumn(this.bgItemNameColIndex).getStyleAttributes().setLocked(true);
        this.getDetailTable().getColumn(this.bgStatusColIndex).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(this.valueIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.resetOppOrgUnitF7();
        this.resetStatus();
        this.workBtnAddLine.setEnabled(true);
        this.workbtnRemoveLine.setEnabled(true);
    }

    protected IObjectValue createNewData() {
        BgInnerFillDataInfo bgInnerFillDataInfo = new BgInnerFillDataInfo();
        bgInnerFillDataInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        bgInnerFillDataInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        FullOrgUnitInfo org = (FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo");
        bgInnerFillDataInfo.setOrgUnit(org);
        bgInnerFillDataInfo.setCU(org.getCU());
        CompanyOrgUnitInfo companyInfo = null;
        try {
            companyInfo = BgNWorkPaperHelper.getCompanyByOrgUnit(null, (OrgUnitInfo)bgInnerFillDataInfo.getOrgUnit());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (companyInfo != null) {
            bgInnerFillDataInfo.setCompany(companyInfo);
        } else {
            companyInfo = SysContext.getSysContext().getCurrentFIUnit();
            bgInnerFillDataInfo.setCompany(companyInfo);
        }
        try {
            if (this.ctx.getCurBgScheme() instanceof BgSchemeInfo) {
                bgInnerFillDataInfo.setBgScheme(this.ctx.getCurBgScheme());
            }
            if (this.ctx.getCurBgPeriod() instanceof BgPeriodInfo) {
                bgInnerFillDataInfo.setBgPeriod(this.ctx.getCurBgPeriod());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            this.handUIException(e);
        }
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            bgInnerFillDataInfo.setBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
        }
        if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo) {
            bgInnerFillDataInfo.setBgPeriod((BgPeriodInfo)this.prmtBgPeriod.getData());
        }
        if (this.prmtBgElement.getData() instanceof BgElementInfo) {
            bgInnerFillDataInfo.setBgElement((BgElementInfo)this.prmtBgElement.getData());
        }
        if (this.prmtCurrency.getData() instanceof CurrencyInfo) {
            bgInnerFillDataInfo.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
        }
        if (this.comboElimType.getSelectedItem() instanceof BgElimTypeEnum) {
            bgInnerFillDataInfo.setElimType((BgElimTypeEnum)((Object)this.comboElimType.getSelectedItem()));
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = bgInnerFillDataInfo.getOrgUnit().getId().toString();
            this.setHasCodeNumber(BgCodeNumberCHelper.hasCodeNumber((IObjectValue)bgInnerFillDataInfo, OUID));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)bgInnerFillDataInfo, OUID));
            }
            if (this.isHasCodeNumber()) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
            this.getNumberByCodingRule((IObjectValue)bgInnerFillDataInfo, OUID);
        }
        return bgInnerFillDataInfo;
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            BgCodeNumberCHelper.applyNumber(this.txtNumber, caller, orgId, this.isHasCodeNumber(), this.isHasShowCodeNumber());
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BgInnerFillDataEntryInfo entry = new BgInnerFillDataEntryInfo();
        entry.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        entry.setCreateTime(new Timestamp(System.currentTimeMillis()));
        entry.setStatus(BgInnerFillDataStatusEnum.edit);
        entry.setOrgUnitId(((FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo")).getId().toString());
        return entry;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setUnEnabledContent(true);
        if (this.ctx.isInitialized()) {
            this.bgElimContextToUI(this.ctx);
        }
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable());
        }
        if (this.isHasCodeNumber()) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        BgInnerFillDataInfo info = (BgInnerFillDataInfo)newData;
        BgInnerFillDataEntryCollection entries = info.getEntries();
        info.setNumber(null);
        info.setName(null);
        if (entries != null && !entries.isEmpty()) {
            for (int i = 0; i < entries.size(); ++i) {
                entries.get(i).setStatus(BgInnerFillDataStatusEnum.edit);
                entries.get(i).setAffirmant(null);
                entries.get(i).setConfirmTime(null);
                entries.get(i).setAmount(null);
                entries.get(i).setEliminationId(null);
            }
        }
        this.setUnEnabledContent(true);
        this.bgElimContextToUI(this.ctx);
        if (this.isHasCodeNumber()) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getOrgUnit() == null && this.orgUnitInfo != null) {
            this.editData.setOrgUnit(this.orgUnitInfo);
        }
    }

    @Override
    public void actionAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNewLine_actionPerformed(e);
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable());
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.actionDeleteLine_actionPerformed(e);
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        int rowBegin = 0;
        int rowEnd = 0;
        int size = 0;
        KDTSelectBlock block = null;
        IRow row = null;
        ArrayList<String> rowIndexs = new ArrayList<String>();
        super.actionDeleteLine_actionPerformed(e);
        KDTRange range = this.getDetailTable().getSelectManager().toRange();
        if (range != null) {
            int k;
            size = range.size();
            if (size <= 0) {
                MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"entryDelNull"));
                SysUtil.abort();
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"ifDel")) == 2) {
                SysUtil.abort();
            }
            for (int i = 0; i < size; ++i) {
                block = (KDTSelectBlock)range.get(i);
                rowBegin = block.getBeginRow();
                rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    BgInnerFillDataStatusEnum state;
                    row = this.getDetailTable().getRow(j);
                    if (row == null || (state = (BgInnerFillDataStatusEnum)((Object)row.getCell("status").getValue())).getValue() != 1 || rowIndexs.contains(String.valueOf(j))) continue;
                    rowIndexs.add(String.valueOf(j));
                }
            }
            Object[] indexArray = rowIndexs.toArray();
            int[] indexArr = new int[indexArray.length];
            for (k = 0; k < indexArray.length; ++k) {
                indexArr[k] = Integer.parseInt(indexArray[k].toString());
            }
            Arrays.sort(indexArr);
            for (k = indexArr.length; k > 0; --k) {
                this.getDetailTable().removeRow(indexArr[k - 1]);
            }
        }
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScheme_willShow(e);
        Object orgUnitInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        orgUnitInfo = this.ctx.isInitialized() ? this.ctx.getCurMappedOrgUnit() : (FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo");
        if (orgUnitInfo == null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"AABBCC", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    private void refreshBgScheme() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object orgUnitInfo = null;
        view.setFilter(filter);
        orgUnitInfo = this.ctx.isInitialized() ? this.ctx.getCurMappedOrgUnit() : (FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo");
        if (orgUnitInfo == null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"AABBCC", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"AABBCC", CompareType.EQUALS));
        }
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    private void resetBgItemF7() throws BOSException {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        NewBgItemDialog dialog = new NewBgItemDialog((IUIObject)this);
        String orgUnitId = null;
        OrgUnitInfo orgUnitInfo = null;
        if (this.ctx.isInitialized()) {
            orgUnitInfo = this.ctx.getCurMappedOrgUnit();
            if (orgUnitInfo != null) {
                orgUnitId = orgUnitInfo.getId().toString();
            }
        } else {
            orgUnitId = ((FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo")).getId().toString();
        }
        if (StringUtils.isEmpty(orgUnitId)) {
            dialog.setOrgUnitId("NULL_ORGUNITID");
        } else {
            dialog.setOrgUnitId(orgUnitId);
        }
        dialog.setElimType((BgElimTypeEnum)((Object)this.comboElimType.getSelectedItem()));
        dialog.setSelectCombinItem(false);
        dialog.setMulSelect(false);
        prmtSelect.setSelector((KDPromptSelector)dialog);
        prmtSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgInnerFillDataEditUI.this.bgVisualItemInfo_dataChanged(eventObj);
            }
        });
        this.getDetailTable().getColumn(this.bgItemNumberColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
    }

    private void resetOppOrgUnitF7() {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage((String)"orgUnitTitle"));
        orgView.disablePerm();
        orgView.setCuID("00000000-0000-0000-0000-000000000000CCE7AED4");
        orgView.setMultiSelect(false);
        orgView.setReturnSuperior(false);
        orgView.setNeedAddOrgRange(false);
        prmtSelect.setSelector((KDPromptSelector)orgView);
        this.getDetailTable().getColumn(this.bgOppOrgUnitColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setCommitFormat("$number$");
    }

    private void resetStatus() {
        KDComboBox cmbDC = new KDComboBox();
        cmbDC.addItems(BgInnerFillDataStatusEnum.getEnumList().toArray());
        this.getDetailTable().getColumn(this.bgStatusColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDC));
    }

    protected void bgVisualItemInfo_dataChanged(DataChangeEvent e) {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        int n = rowIndex = rowIndex <= -1 ? 0 : rowIndex;
        if (e.getNewValue() != null) {
            if (e.getNewValue() instanceof BgItemObject) {
                BgItemObject bgItem = (BgItemObject)e.getNewValue();
                this.getDetailTable().getCell(rowIndex, this.bgItemNumberColIndex).setUserObject((Object)bgItem);
                this.getDetailTable().getCell(rowIndex, this.bgItemNameColIndex).setValue((Object)bgItem.getResult().get(0).getName());
                this.getDetailTable().getCell(rowIndex, this.bgItemNumberColIndex).setValue((Object)bgItem.getResult().get(0).getNumber());
            } else if (e.getNewValue() instanceof String) {
                this.getDetailTable().getCell(rowIndex, this.bgItemNumberColIndex).setValue(e.getNewValue());
                SysUtil.abort();
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        String textNum = this.txtNumber.getText();
        if (this.isHasCodeNumber()) {
            if (this.isHasShowCodeNumber() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"numberEmpty"));
                SysUtil.abort();
            }
        } else {
            if (StringUtil.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"numberEmpty"));
                SysUtil.abort();
            }
            IBgInnerFillData ibgfd = (IBgInnerFillData)this.getBizInterface();
            String orgUnitId = ((FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo")).getId().toString();
            boolean isExist = false;
            isExist = this.editData.getId() != null ? ibgfd.existNum(textNum, orgUnitId, this.editData.getId().toString()) : ibgfd.existNum(textNum, orgUnitId, null);
            if (isExist) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"existNum"));
                SysUtil.abort();
            }
        }
        if (StringUtil.isEmpty((String)this.txtName.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"nameEmpty"));
            SysUtil.abort();
        }
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"schemeEmpty"));
            SysUtil.abort();
        }
        if (this.prmtBgPeriod.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"periodEmpty"));
            SysUtil.abort();
        }
        if (this.prmtBgElement.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"elementEmpty"));
            SysUtil.abort();
        }
        if (this.prmtCurrency.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"currencyEmpty"));
            SysUtil.abort();
        }
        for (int i = 0; i < this.especialChar.length; ++i) {
            if (textNum.indexOf(this.especialChar[i]) == -1) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"numberHasEspecialChar"));
            SysUtil.abort();
        }
        this.beforeSave();
    }

    protected void beforeSave() throws Exception {
        if (this.getDetailTable() != null && this.getDetailTable().getBody().size() > 0) {
            this.checkCells();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"entryIsNull"));
            SysUtil.abort();
        }
    }

    private void checkCells() throws Exception {
        IRow row = null;
        int rowCount = 0;
        rowCount = this.getDetailTable().getBody().size();
        HashMap<BOSUuid, HashMap> bgItemMap = new HashMap<BOSUuid, HashMap>();
        HashMap bgItemRowMap = null;
        OrgUnitInfo org = null;
        String bgItemNum = null;
        BgInnerFillDataInfo bgInnerFillDataInfo = new BgInnerFillDataInfo();
        bgInnerFillDataInfo.setDataType((BgDataTypeEnum)this.comboDataType.getSelectedItem());
        bgInnerFillDataInfo.setBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
        bgInnerFillDataInfo.setBgPeriod((BgPeriodInfo)this.prmtBgPeriod.getData());
        bgInnerFillDataInfo.setBgElement((BgElementInfo)this.prmtBgElement.getData());
        bgInnerFillDataInfo.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
        bgInnerFillDataInfo.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo"));
        bgInnerFillDataInfo.setId(this.editData.getId());
        IBgInnerFillDataEntry ibgfd = (IBgInnerFillDataEntry)this.getBizEntryInterface();
        Map unitBgItemMap = new HashMap();
        unitBgItemMap = ibgfd.getCheckMap(bgInnerFillDataInfo);
        ArrayList bgItemList = new ArrayList();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.getDetailTable().getRow(rowIndex);
            if (row == null) continue;
            if (!(row.getCell(this.bgOppOrgUnitColIndex).getValue() instanceof OrgUnitInfo)) {
                MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"oppOrgUnitEmpty"));
                SysUtil.abort();
            } else {
                org = (OrgUnitInfo)row.getCell(this.bgOppOrgUnitColIndex).getValue();
                row.getCell(this.bgOppOrgUnitColIndex).setValue((Object)org.castToFullOrgUnitInfo());
                this.editData.getEntries().get(rowIndex).setOppOrgUnit(org.castToFullOrgUnitInfo());
            }
            if (row.getCell(this.bgItemNumberColIndex).getValue() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"bgItemNumberEmpty"));
                SysUtil.abort();
            }
            if (row.getCell(this.valueIndex).getValue() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"valueEmpty"));
                SysUtil.abort();
            }
            org = (OrgUnitInfo)row.getCell(this.bgOppOrgUnitColIndex).getValue();
            String orgUnitId = ((FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo")).getId().toString();
            if (orgUnitId.equals(org.getId())) {
                MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"sameOrg"));
                SysUtil.abort();
            }
            bgItemNum = row.getCell(this.bgItemNumberColIndex).getValue().toString();
            if (bgItemMap.containsKey(org.getId())) {
                bgItemRowMap = (HashMap)bgItemMap.get(org.getId());
            } else {
                bgItemRowMap = new HashMap();
                bgItemMap.put(org.getId(), bgItemRowMap);
            }
            if (bgItemRowMap.containsKey(bgItemNum)) {
                throw new BgElimException(BgElimException.BGITEMDUPLACTED, new String[]{String.valueOf(bgItemRowMap.get(bgItemNum)), String.valueOf(rowIndex + 1)});
            }
            bgItemRowMap.put(bgItemNum, new Integer(rowIndex + 1));
            unitBgItemMap.keySet();
            if (!unitBgItemMap.containsKey(org.getId().toString()) || (bgItemList = (ArrayList)unitBgItemMap.get(org.getId().toString())).indexOf(bgItemNum) == -1) continue;
            throw new BgElimException(BgElimException.BGFILLDATAEXIST, new String[]{String.valueOf(rowIndex + 1), bgItemNum});
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    protected void showCopyAddNew() {
        super.showCopyAddNew();
        this.actionQuickLoad.setEnabled(true);
        this.btnAddLine.setEnabled(true);
        this.btnRemoveLine.setEnabled(true);
        this.workBtnAddLine.setEnabled(true);
        this.workbtnRemoveLine.setEnabled(true);
    }

    @Override
    protected void comboElimType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboElimType_itemStateChanged(e);
        IRow row = null;
        int rowCount = 0;
        rowCount = this.getDetailTable().getBody().size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.getDetailTable().getRow(rowIndex);
            if (row == null) continue;
            row.getCell(this.bgItemNumberColIndex).setValue(null);
            row.getCell(this.bgItemNameColIndex).setValue(null);
        }
        this.resetBgItemF7();
    }

    @Override
    public void actionQuickLoad_actionPerformed(ActionEvent e) throws Exception {
        ArrayList orgList = null;
        ArrayList bgItemList = null;
        String uiClass = BgInnerFillDataLoadUI.class.getName();
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"comboElimType", (Object)((BgElimTypeEnum)((Object)this.comboElimType.getSelectedItem())));
        String orgUnitId = null;
        OrgUnitInfo orgUnitInfo = null;
        if (this.ctx.isInitialized()) {
            orgUnitInfo = this.ctx.getCurMappedOrgUnit();
            if (orgUnitInfo != null) {
                orgUnitId = orgUnitInfo.getId().toString();
            }
        } else {
            orgUnitId = ((FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo")).getId().toString();
        }
        orgUnitId = BgSHelper.getIsolateOrg(orgUnitId);
        uiContext.put((Object)"OrgUnitInfo", (Object)orgUnitId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        orgList = ((BgInnerFillDataLoadUI)uiWindow.getUIObject()).getOrgList();
        bgItemList = ((BgInnerFillDataLoadUI)uiWindow.getUIObject()).getBgItemList();
        if (orgList != null && bgItemList != null) {
            for (int i = 0; i < orgList.size(); ++i) {
                for (int j = 0; j < bgItemList.size(); ++j) {
                    this.addLine(this.getDetailTable());
                    this.getDetailTable().getCell(this.getDetailTable().getRowCount() - 1, this.bgOppOrgUnitColIndex).setValue(orgList.get(i));
                    this.getDetailTable().getCell(this.getDetailTable().getRowCount() - 1, this.bgItemNumberColIndex).setUserObject(bgItemList.get(j));
                    this.getDetailTable().getCell(this.getDetailTable().getRowCount() - 1, this.bgItemNumberColIndex).setValue((Object)((BgItemInfo)bgItemList.get(j)).getNumber());
                    this.getDetailTable().getCell(this.getDetailTable().getRowCount() - 1, this.bgItemNameColIndex).setValue((Object)((BgItemInfo)bgItemList.get(j)).getName());
                }
            }
        }
    }

    public boolean destroyWindow() {
        BgInnerDataCheckMainUI ownerUI;
        if (OprtState.EDIT.equals(this.getOprtState()) && this.isFromCheckUI && (ownerUI = (BgInnerDataCheckMainUI)this.getUIContext().get("Owner")) != null) {
            ownerUI.refresh();
        }
        BgElimContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    protected IObjectPK getOrgPK() {
        if (this.orgUnitInfo == null) {
            this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo");
        }
        if (this.orgUnitInfo != null && this.orgUnitInfo.getId() != null) {
            return new ObjectUuidPK(this.orgUnitInfo.getId());
        }
        return super.getOrgPK();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.orgUnitInfo == null) {
            this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("OrgUnitInfo");
        }
        if (this.orgUnitInfo != null && this.orgUnitInfo.getId() != null) {
            return new ObjectUuidPK(this.orgUnitInfo.getId());
        }
        return super.getOrgPK(action);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, (CoreUI)this);
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    public KDMenuItem getAttachMenuItem(KDTable table) {
        return null;
    }
}

