/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.myeas.OpenModelInfo;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgElimContext;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.BgInnerFillDataFactory;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.IBgInnerFillData;
import com.kingdee.eas.ma.nbudget.client.AbstractBgInnerFillDataListUI;
import com.kingdee.eas.ma.nbudget.client.BgInnerFillDataEditUI;
import com.kingdee.eas.ma.nbudget.client.IBgElimContextUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Observable;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgInnerFillDataListUI
extends AbstractBgInnerFillDataListUI
implements IBgElimContextUI {
    private static final long serialVersionUID = -8770528853118298128L;
    private static final Logger logger = CoreUIObject.getLogger(BgInnerFillDataListUI.class);
    private BgElimContext ctx = null;
    protected IBgElimContext bgElimContext = BgElimContextHelper.getBgElimContext();
    protected boolean isCtxInit = BgElimContextHelper.getBgElimContext().isInitialized();

    public BgInnerFillDataListUI() throws Exception {
        this.ctx = BgElimContext.getInstance();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        OrgUnitInfo currentOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        this.rbCurrOrgUnit.setSelected(true);
        BgPeriodDialog dialog = new BgPeriodDialog();
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage((String)"orgUnitTitle"));
        orgView.disablePerm();
        orgView.setCuID("00000000-0000-0000-0000-000000000000CCE7AED4");
        orgView.setMultiSelect(false);
        orgView.setReturnSuperior(false);
        orgView.setNeedAddOrgRange(false);
        this.prmtBgOrg.setSelector((KDPromptSelector)orgView);
        this.refreshBgScheme();
        if (!currentOrgUnit.isIsCostOrgUnit() && !currentOrgUnit.isIsGrouping()) {
            this.disabledTools();
        }
        BgElimContextHelper.registUIObject(this);
        if (this.isCtxInit) {
            this.bgElimContextToUI(this.bgElimContext);
        }
        KDFormattedTextField formattedTextField = null;
        formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(10);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.tblMain.getColumn("entries.fillAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    private void bgElimContextToUI(IBgElimContext bgx) {
        try {
            if (bgx.getCurBgScheme() != null) {
                this.prmtBgScheme.setData((Object)bgx.getCurBgScheme());
                this.prmtBgScheme.setEnabled(false);
            }
            if (bgx.getCurBgPeriod() != null) {
                this.prmtBgPeriod.setData((Object)bgx.getCurBgPeriod());
                this.prmtBgPeriod.setEnabled(false);
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.comElimType.removeItem((Object)BgElimTypeEnum.None);
        this.comElimType.setSelectedIndex(0);
    }

    protected String getEditUIName() {
        return BgInnerFillDataEditUI.class.getName();
    }

    protected String getEditUIModal() {
        OpenModelInfo openModelInfo = (OpenModelInfo)UIFrameContext.getInstance().getProperty((Object)"OpenModel");
        if (openModelInfo != null) {
            if (openModelInfo.isIsOpenInFour()) {
                return "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
            }
            if (openModelInfo.isIsOpenInNewTab()) {
                return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            }
            if (openModelInfo.isIsOpenInWindow()) {
                return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
            }
        }
        return "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
    }

    @Override
    protected void prmtBgOrg_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
    }

    @Override
    protected void cmbSubSystem_itemStateChanged(ItemEvent e) throws Exception {
        this.refreshTable();
    }

    private void refreshTable() {
        FilterInfo _filter = new FilterInfo();
        try {
            this.refreshFilter(_filter);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        this.mainQuery.setFilter(_filter);
        try {
            this.execQuery();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private void refreshFilter(FilterInfo filter) throws Exception {
        int selectedValue;
        if (filter == null) {
            return;
        }
        Object obj = this.prmtBgOrg.getData();
        if (obj != null) {
            if (obj instanceof CostCenterOrgUnitInfo) {
                CostCenterOrgUnitInfo _constCenterInfo = (CostCenterOrgUnitInfo)obj;
                this.replaceFilterItems(filter, new FilterItemInfo("oppOrgUnit.number", (Object)_constCenterInfo.getNumber(), CompareType.EQUALS));
            } else if (obj instanceof String) {
                String _name = (String)obj;
                this.replaceFilterItems(filter, new FilterItemInfo("oppOrgUnit.number", (Object)_name, CompareType.EQUALS));
            }
        }
        if ((selectedValue = ((BgElimTypeEnum)((Object)this.comElimType.getSelectedItem())).getValue()) == 4) {
            HashSet<Integer> elimTypeSet = new HashSet<Integer>();
            elimTypeSet.add(new Integer(BgElimTypeEnum.ComeAndGo.getValue()));
            elimTypeSet.add(new Integer(BgElimTypeEnum.InnerExchange.getValue()));
            elimTypeSet.add(new Integer(BgElimTypeEnum.InnerInvest.getValue()));
            this.replaceFilterItems(filter, new FilterItemInfo("elimType", elimTypeSet, CompareType.INCLUDE));
        } else {
            this.replaceFilterItems(filter, new FilterItemInfo("elimType", (Object)String.valueOf(selectedValue), CompareType.EQUALS));
        }
        obj = this.prmtBgScheme.getData();
        if (obj != null) {
            if (obj instanceof BgSchemeInfo) {
                BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)obj;
                this.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)_bgSchemeInfo.getNumber(), CompareType.EQUALS));
            } else if (obj instanceof String) {
                String _name = (String)obj;
                this.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)_name, CompareType.EQUALS));
            }
        }
        if ((obj = this.prmtBgPeriod.getData()) != null && obj instanceof BgPeriodInfo) {
            BgPeriodInfo _bgPeriodInfo = (BgPeriodInfo)obj;
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.id", (Object)_bgPeriodInfo.getId(), CompareType.EQUALS));
        }
        if (this.bgElimContext.getCurBgDataType() != null) {
            int dataTypeValue = this.bgElimContext.getCurBgDataType().getValue();
            this.replaceFilterItems(filter, new FilterItemInfo("dataType", (Object)String.valueOf(dataTypeValue), CompareType.EQUALS));
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        String orgUnitId = this.getOrgUnitId();
        if (this.bgElimContext.getCurBgScheme() != null) {
            BgSchemeInfo bgSchemeInfo = this.bgElimContext.getCurBgScheme();
            IBgInnerFillData ibgfd = (IBgInnerFillData)this.getBizInterface();
            boolean isExist = ibgfd.existScheme(bgSchemeInfo.getRootId().toString(), orgUnitId);
            if (!isExist) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgEliminationResource", (String)"notExistScheme"));
                return;
            }
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        int curIndex = this.getTopLocation();
        if (curIndex > -1 && (row = this.tblMain.getRow(curIndex)) != null) {
            String id = row.getCell("id").getValue().toString();
            IBgInnerFillData ibgfd = (IBgInnerFillData)this.getBizInterface();
            boolean canDele = ibgfd.checkCanDele(id);
            if (!canDele) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgEliminationResource", (String)"canNotDele"));
                return;
            }
        }
        this.actionRemove_actionPerformed();
        this.refreshTable();
    }

    public int getTopLocation() {
        int eachBlockIndex = 0;
        int resultIndex = -1;
        int blockSize = this.tblMain.getSelectManager().getBlocks().size();
        if (blockSize > 0) {
            resultIndex = ((KDTSelectBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getTop();
            for (int j = 0; j < blockSize; ++j) {
                KDTSelectBlock selectBlock = (KDTSelectBlock)this.tblMain.getSelectManager().getBlocks().get(j);
                eachBlockIndex = selectBlock.getTop();
                if (eachBlockIndex >= resultIndex) continue;
                resultIndex = eachBlockIndex;
            }
        }
        return resultIndex;
    }

    public void actionRemove_actionPerformed() throws Exception {
        this.checkSelected();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgEliminationResource", (String)"deleteInnerData"));
        if (re == 1 || re == 2) {
            return;
        }
        int rowBegin = 0;
        int rowEnd = 0;
        int size = 0;
        IRow row = null;
        KDTSelectBlock block = null;
        String bgInnerDataId = null;
        ArrayList<String> bgDataIds = new ArrayList<String>();
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            size = range.size();
            for (int i = 0; i < size; ++i) {
                block = (KDTSelectBlock)range.get(i);
                rowBegin = block.getBeginRow();
                rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    row = this.tblMain.getRow(j);
                    if (row == null) continue;
                    bgInnerDataId = row.getCell("id").getValue().toString();
                    if (bgDataIds.indexOf(bgInnerDataId) == -1) {
                        bgDataIds.add(bgInnerDataId);
                    }
                    if (!iMC.requestObjIDForUpdate(bgInnerDataId)) {
                        throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
                    }
                    iMC.requestObjIDForUpdate(bgInnerDataId, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                }
            }
        }
        try {
            if (!bgDataIds.isEmpty()) {
                IBgInnerFillData ibgfd = (IBgInnerFillData)this.getBizInterface();
                ibgfd.batchRemove(bgDataIds);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            for (int i = 0; i < bgDataIds.size(); ++i) {
                iMC.releaseObjIDForUpdate(bgDataIds.get(i).toString());
            }
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"OrgUnitInfo", (Object)this.getOrgUnitInfo());
        super.prepareUIContext(uiContext, e);
    }

    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(node);
        if (orgUnitInfo != null) {
            if (orgUnitInfo.isIsGrouping()) {
                this.disabledTools();
            } else {
                this.enabledTools();
            }
        }
    }

    private void enabledTools() {
        this.btnAddNew.setEnabled(true);
        this.btnView.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnRemove.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnLocate.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
    }

    private void disabledTools() {
        this.btnAddNew.setEnabled(false);
        this.btnView.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnQuery.setEnabled(false);
        this.btnRefresh.setEnabled(false);
        this.btnLocate.setEnabled(false);
        this.btnPrint.setEnabled(false);
        this.btnPrintPreview.setEnabled(false);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = null;
        filter = this.getUnSelectedQueryFilterInfo(viewInfo);
        try {
            this.refreshFilter(filter);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        viewInfo.setFilter(filter);
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScheme_willShow(e);
        OrgUnitInfo orgUnitInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        orgUnitInfo = this.ctx.isInitialized() ? this.ctx.getCurMappedOrgUnit() : this.getOrgUnitInfo();
        if (orgUnitInfo == null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"AABBCC", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    private void refreshBgScheme() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        OrgUnitInfo orgUnitInfo = null;
        view.setFilter(filter);
        orgUnitInfo = this.ctx.isInitialized() ? this.ctx.getCurMappedOrgUnit() : this.getOrgUnitInfo();
        if (orgUnitInfo == null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"AABBCC", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"AABBCC", CompareType.EQUALS));
        }
        this.prmtBgScheme.setData(null);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    public String getPermissionNum() {
        return "BgInnerFillData001_list";
    }

    public boolean destroyWindow() {
        BgElimContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgInnerFillDataFactory.getRemoteInstance();
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, (CoreUI)this);
    }

    protected boolean isUseForElim() {
        return true;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }
}

