/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemGroupListF7UI;
import com.kingdee.eas.ma.nbudget.BgElimContext;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.client.AbstractBgInnerFillDataLoadUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class BgInnerFillDataLoadUI
extends AbstractBgInnerFillDataLoadUI {
    private static final long serialVersionUID = 6236757076188684993L;
    private static final Logger logger = CoreUIObject.getLogger(BgInnerFillDataLoadUI.class);
    private static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    private ArrayList orgList = new ArrayList();
    private ArrayList bgItemList = new ArrayList();
    private BgElimContext ctx = BgElimContext.getInstance();
    private static final String TOP_COST_CENTER_ID = "00000000-0000-0000-0000-000000000000CCE7AED4";

    public ArrayList getBgItemList() {
        return this.bgItemList;
    }

    public ArrayList getOrgList() {
        return this.orgList;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Icon bg = EASResource.getIcon((String)"imgGuide_pic338");
        this.kDEndImage.setIcon(bg);
        this.KDPersonalImage.setIcon(bg);
        this.InitTable();
        this.startPanelShow();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void startPanelShow() {
        this.kDPanelEnd.setVisible(false);
        this.kDPanelStart.setVisible(true);
        super.setUITitle(EASResource.getString((String)RES_PATH, (String)"quickLoadOne"));
        this.kDTextArea1.setVisible(true);
        this.kDTable.setEnabled(true);
        this.kDTable.setVisible(true);
        this.kDTable.getSelectManager().setSelectMode(10);
        this.btnAddOrg.setEnabled(true);
        this.btnAddOrg.setVisible(true);
        this.btnDelOrg.setEnabled(true);
        this.btnDelOrg.setVisible(true);
        this.kDButStartCancel.setEnabled(true);
        this.kDButStartCancel.setVisible(true);
        this.kDButStartPrevious.setEnabled(false);
        this.kDButStartPrevious.setVisible(true);
        this.kDButStartNext.setEnabled(true);
        this.kDButStartNext.setVisible(true);
        this.kDButStartFinish.setEnabled(false);
        this.kDButStartFinish.setVisible(true);
    }

    private void nextPanelShow() {
        this.kDPanelStart.setVisible(false);
        this.kDPanelEnd.setVisible(true);
        super.setUITitle(EASResource.getString((String)RES_PATH, (String)"quickLoadTwo"));
        this.kDTextArea2.setVisible(true);
        this.kDTable1.setEnabled(true);
        this.kDTable1.setVisible(true);
        this.kDTable1.getSelectManager().setSelectMode(10);
        this.btnAddBgItem.setEnabled(true);
        this.btnAddBgItem.setVisible(true);
        this.btnDelBgItem.setEnabled(true);
        this.btnDelBgItem.setVisible(true);
        this.kDButEndCancel.setEnabled(true);
        this.kDButEndCancel.setVisible(true);
        this.kDButEndPrevious.setEnabled(true);
        this.kDButEndPrevious.setVisible(true);
        this.kDButEndNext.setEnabled(false);
        this.kDButEndNext.setVisible(true);
        this.kDButEndFinish.setEnabled(true);
        this.kDButEndFinish.setVisible(true);
    }

    private void InitTable() throws BOSException {
        int colCount = 2;
        for (int i = 0; i < colCount; ++i) {
            this.kDTable.addColumn(i);
            this.kDTable1.addColumn(i);
        }
        IRow row = this.kDTable.addHeadRow();
        IRow row1 = this.kDTable1.addHeadRow();
        if (row != null) {
            row.getCell(0).setValue((Object)EASResource.getString((String)RES_PATH, (String)"orgUnitNum"));
            row.getCell(1).setValue((Object)EASResource.getString((String)RES_PATH, (String)"orgUnitName"));
            row1.getCell(0).setValue((Object)EASResource.getString((String)RES_PATH, (String)"bgItemNum"));
            row1.getCell(1).setValue((Object)EASResource.getString((String)RES_PATH, (String)"bgItemName"));
        }
        IColumn col1 = null;
        IColumn col = this.kDTable.getColumn(0);
        col1 = this.kDTable1.getColumn(0);
        if (col != null) {
            col.setWidth(150);
            col1.setWidth(150);
        }
        col = this.kDTable.getColumn(1);
        col1 = this.kDTable1.getColumn(1);
        if (col != null) {
            col.setWidth(175);
            col1.setWidth(175);
            col.getStyleAttributes().setLocked(true);
            col1.getStyleAttributes().setLocked(true);
        }
        this.resetOppOrgUnitF7();
        this.resetBgItemF7();
    }

    private void resetOppOrgUnitF7() {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage((String)"orgUnitTitle"));
        orgView.disablePerm();
        orgView.setCuID(TOP_COST_CENTER_ID);
        orgView.setMultiSelect(false);
        orgView.setReturnSuperior(false);
        orgView.setNeedAddOrgRange(false);
        prmtSelect.setSelector((KDPromptSelector)orgView);
        prmtSelect.setDisplayFormat("$number$");
        prmtSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgInnerFillDataLoadUI.this.bgVisualOrgInfo_dataChanged(eventObj);
            }
        });
        this.kDTable.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
    }

    protected void bgVisualOrgInfo_dataChanged(DataChangeEvent e) {
        IRow iRow;
        ICell iCell;
        int inputN = 0;
        boolean isHad = false;
        int rowIndex = this.kDTable.getSelectManager().getActiveRowIndex();
        int n = rowIndex = rowIndex <= -1 ? 0 : rowIndex;
        if (e.getNewValue() != null) {
            if (e.getNewValue() instanceof OrgUnitInfo) {
                OrgUnitInfo org = (OrgUnitInfo)e.getNewValue();
                this.kDTable.getCell(rowIndex, 0).setValue((Object)org);
            } else {
                this.kDTable.getCell(rowIndex, 0).setValue(e.getNewValue());
                SysUtil.abort();
            }
        }
        if (!((iCell = (iRow = this.kDTable.getRow(rowIndex)).getCell(0)).getValue() instanceof OrgUnitInfo)) {
            return;
        }
        OrgUnitInfo col = (OrgUnitInfo)iCell.getValue();
        OrgUnitInfo element = new OrgUnitInfo();
        this.kDTable.removeRow(rowIndex);
        inputN = rowIndex;
        for (int n2 = 0; n2 < 1; ++n2) {
            isHad = false;
            element = col;
            for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
                String tempNumber;
                if (this.kDTable.getRow(i).getCell(0).getValue() == null || !(tempNumber = this.kDTable.getRow(i).getCell(0).getValue().toString()).equals(element.getNumber())) continue;
                isHad = true;
            }
            if (isHad) continue;
            element = col;
            iRow = this.kDTable.addRow(inputN);
            if (element == null) {
                return;
            }
            iRow.setUserObject((Object)element);
            iRow.getCell(0).setValue((Object)element.getNumber());
            iRow.getCell(1).setValue((Object)element.getName());
            ++inputN;
        }
    }

    private void resetBgItemF7() throws BOSException {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        NewBgItemDialog dialog = new NewBgItemDialog((IUIObject)this);
        String orgUnitId = null;
        orgUnitId = this.getUIContext().get("OrgUnitInfo").toString();
        if (StringUtils.isEmpty((String)orgUnitId)) {
            dialog.setOrgUnitId("NULL_ORGUNITID");
        } else {
            dialog.setOrgUnitId(orgUnitId);
        }
        dialog.setElimType((BgElimTypeEnum)((Object)this.getUIContext().get("comboElimType")));
        dialog.setSelectCombinItem(false);
        dialog.setMulSelect(false);
        prmtSelect.setSelector((KDPromptSelector)dialog);
        prmtSelect.setDisplayFormat("$number$");
        prmtSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgInnerFillDataLoadUI.this.bgVisualItemInfo_dataChanged(eventObj);
            }
        });
        this.kDTable1.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
    }

    protected void bgVisualItemInfo_dataChanged(DataChangeEvent e) {
        IRow iRow;
        ICell iCell;
        int inputN = 0;
        boolean isHad = false;
        int rowIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
        int n = rowIndex = rowIndex <= -1 ? 0 : rowIndex;
        if (e.getNewValue() != null) {
            if (e.getNewValue() instanceof BgItemObject) {
                BgItemObject bgItem = (BgItemObject)e.getNewValue();
                this.kDTable1.getCell(rowIndex, 0).setValue((Object)bgItem);
            } else if (e.getNewValue() instanceof String) {
                this.kDTable1.getCell(rowIndex, 0).setValue(e.getNewValue());
                SysUtil.abort();
            }
        }
        if (!((iCell = (iRow = this.kDTable1.getRow(rowIndex)).getCell(0)).getValue() instanceof BgItemObject)) {
            return;
        }
        BgItemObject col = (BgItemObject)iCell.getValue();
        BgItemInfo element = new BgItemInfo();
        this.kDTable1.removeRow(rowIndex);
        inputN = rowIndex;
        for (int n2 = 0; n2 < col.getResult().size(); ++n2) {
            isHad = false;
            element = col.getResult().get(n2);
            for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
                String tempNumber;
                if (this.kDTable1.getRow(i).getCell(0).getValue() == null || !(tempNumber = this.kDTable1.getRow(i).getCell(0).getValue().toString()).equals(element.getNumber())) continue;
                isHad = true;
            }
            if (isHad) continue;
            element = col.getResult().get(n2);
            iRow = this.kDTable1.addRow(inputN);
            if (element == null) {
                return;
            }
            iRow.setUserObject((Object)element);
            iRow.getCell(0).setValue((Object)element.getNumber());
            iRow.getCell(1).setValue((Object)element.getName());
            ++inputN;
        }
    }

    @Override
    public void actionAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNewLine_actionPerformed(e);
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7();
        orgView.setTitle(BgAnalyseHelper.getMessage((String)"orgUnitTitle"));
        orgView.disablePerm();
        orgView.setCuID(TOP_COST_CENTER_ID);
        orgView.setMultiSelect(true);
        orgView.setReturnSuperior(false);
        orgView.setNeedAddOrgRange(false);
        orgView.show();
        OrgUnitInfo[] orgInfos = (OrgUnitInfo[])orgView.getData();
        if (orgInfos != null && orgInfos.length != 0) {
            this.fillOrgUnit(orgInfos, this.kDTable);
        }
    }

    private void fillBgItem(BgItemCollection coll, KDTable tblMap) {
        int index = 0;
        int endRowIndex = -1;
        int rowCount = tblMap.getRowCount();
        BgItemCollection newColl = new BgItemCollection();
        IRow _row = null;
        ICell _cell = null;
        BgItemInfo info = null;
        for (int i = 0; i < rowCount; ++i) {
            _row = tblMap.getRow(i);
            _cell = _row.getCell(0);
            if (coll == null) continue;
            for (int j = 0; j < coll.size(); ++j) {
                info = coll.get(j);
                if (_cell.getValue() != null && _cell.getValue().equals(info.getNumber())) continue;
                newColl.add(info);
            }
        }
        endRowIndex = endRowIndex == -1 ? (tblMap.getRowCount() != 0 ? tblMap.getRowCount() : ++endRowIndex) : ++endRowIndex;
        if (rowCount == 0) {
            newColl = coll;
        }
        while (index < newColl.size()) {
            IRow row = tblMap.getRow(endRowIndex) == null ? tblMap.addRow() : tblMap.getRow(endRowIndex);
            row.getCell(0).setValue((Object)newColl.get(index).getNumber());
            row.setUserObject(newColl.get(index).clone());
            tblMap.getCell(endRowIndex, 1).setValue((Object)newColl.get(index).getName());
            ++endRowIndex;
            ++index;
        }
    }

    private void fillOrgUnit(OrgUnitInfo[] coll, KDTable tblMap) {
        int i;
        HashMap<String, String> oldMap = new HashMap<String, String>();
        if (tblMap != null && tblMap.getRowCount() > 0) {
            IRow row = null;
            String number = null;
            String name = null;
            ICell cell = null;
            for (i = 0; i < tblMap.getRowCount(); ++i) {
                row = tblMap.getRow(i);
                if (row == null) continue;
                cell = row.getCell(0);
                if (cell != null && cell.getValue() != null) {
                    number = (String)cell.getValue();
                }
                if ((cell = row.getCell(1)) != null && cell.getValue() != null) {
                    name = (String)cell.getValue();
                }
                oldMap.put(number, name);
            }
        }
        int index = 0;
        boolean isOverFlow = false;
        KDTRange range = tblMap.getSelectManager().toRange();
        int endRowIndex = -1;
        for (i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            for (int x = block.getBeginRow(); x <= block.getEndRow(); ++x) {
                for (int y = block.getBeginCol(); y <= block.getEndCol(); ++y) {
                    if (y != 0) continue;
                    ICell cell = tblMap.getCell(x, y);
                    if (cell != null) {
                        CostCenterOrgUnitInfo org = (CostCenterOrgUnitInfo)coll[index];
                        cell.setValue((Object)org.getNumber());
                        tblMap.getRow(x).setUserObject(coll[index].clone());
                        tblMap.getCell(x, y + 1).setValue((Object)org.getName());
                        if (index == coll.length - 1) {
                            index = 0;
                            isOverFlow = true;
                        } else {
                            ++index;
                        }
                    }
                    endRowIndex = x > endRowIndex ? x : endRowIndex;
                }
            }
        }
        if (!isOverFlow) {
            endRowIndex = endRowIndex == -1 ? (tblMap.getRowCount() != 0 ? tblMap.getRowCount() : ++endRowIndex) : ++endRowIndex;
            while (index < coll.length) {
                if (!oldMap.containsKey(coll[index].getNumber())) {
                    IRow row = tblMap.getRow(endRowIndex) == null ? tblMap.addRow() : tblMap.getRow(endRowIndex);
                    row.getCell(0).setValue((Object)coll[index].getNumber());
                    row.setUserObject(coll[index].clone());
                    tblMap.getCell(endRowIndex, 1).setValue((Object)coll[index].getName());
                    ++endRowIndex;
                }
                ++index;
            }
        }
    }

    @Override
    public void actionAddNewLineEnd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNewLine_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isSelectCombinItem", (Object)Boolean.FALSE);
        uiContext.put((Object)"ELIMTYPE", (Object)((BgElimTypeEnum)((Object)this.getUIContext().get("comboElimType"))));
        String orgUnitId = this.getUIContext().get("OrgUnitInfo").toString();
        if (StringUtils.isEmpty((String)orgUnitId)) {
            uiContext.put((Object)"ORGUNITID", (Object)"NULL_ORGUNITID");
        } else {
            uiContext.put((Object)"ORGUNITID", (Object)orgUnitId);
        }
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.NewBgItemGroupListF7UI", (Map)uiContext);
        }
        catch (UIException e1) {
            logger.error((Object)e1);
            this.handUIException(e1);
        }
        uiWindow.show();
        NewBgItemGroupListF7UI f7ui = (NewBgItemGroupListF7UI)uiWindow.getUIObject();
        if (f7ui.getResult() != null && ((BgItemObject)f7ui.getResult()).getResult().size() != 0) {
            BgItemCollection coll = ((BgItemObject)f7ui.getResult()).getResult();
            this.fillBgItem(coll, this.kDTable1);
        }
    }

    @Override
    protected void kDButStartNext_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDTable != null && this.kDTable.getBody().size() > 0) {
            this.checkCells();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"selectOrg"));
            SysUtil.abort();
        }
        this.nextPanelShow();
    }

    private void checkCells() {
        IRow row = null;
        int rowCount = 0;
        rowCount = this.kDTable.getBody().size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.kDTable.getRow(rowIndex);
            if (row == null || row.getUserObject() instanceof OrgUnitInfo) continue;
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"orgTableEmpty"));
            SysUtil.abort();
        }
    }

    @Override
    protected void kDButStartCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    protected void kDButEndCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    protected void kDButEndPrevious_actionPerformed(ActionEvent e) throws Exception {
        this.startPanelShow();
    }

    @Override
    protected void kDButEndFinish_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        if (this.kDTable1 != null && this.kDTable1.getBody().size() > 0) {
            this.checkNextCells();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"selectBgItem"));
            SysUtil.abort();
        }
        this.nextPanelShow();
        IRow row = null;
        int rowCount = 0;
        rowCount = this.kDTable.getBody().size();
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.kDTable.getRow(rowIndex);
            if (row == null) continue;
            this.orgList.add(row.getUserObject());
        }
        rowCount = this.kDTable1.getBody().size();
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.kDTable1.getRow(rowIndex);
            if (row == null) continue;
            this.bgItemList.add(row.getUserObject());
        }
        this.uiWindow.close();
    }

    private void checkNextCells() {
        IRow row = null;
        int rowCount = 0;
        rowCount = this.kDTable1.getBody().size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.kDTable1.getRow(rowIndex);
            if (row == null || row.getUserObject() instanceof BgItemInfo) continue;
            MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"bgItemTableEmpty"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionStartAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartAddNewLine_actionPerformed(e);
        if (this.kDTable != null) {
            this.kDTable.addRow();
        }
    }

    @Override
    public void actionStartDelLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartDelLine_actionPerformed(e);
        if (this.kDTable != null) {
            this.deleteLine_actionPerformed(this.kDTable);
        }
    }

    @Override
    public void actionEndAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionEndAddNewLine_actionPerformed(e);
        if (this.kDTable1 != null) {
            this.kDTable1.addRow();
        }
    }

    @Override
    public void actionEndDelLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionEndDelLine_actionPerformed(e);
        if (this.kDTable1 != null) {
            this.deleteLine_actionPerformed(this.kDTable1);
        }
    }

    public void deleteLine_actionPerformed(KDTable kDTable) throws Exception {
        int rowBegin = 0;
        int rowEnd = 0;
        int size = 0;
        KDTSelectBlock block = null;
        IRow row = null;
        ArrayList<String> rowIndexs = new ArrayList<String>();
        KDTRange range = kDTable.getSelectManager().toRange();
        if (range != null) {
            int k;
            size = range.size();
            if (size <= 0) {
                MsgBox.showWarning((String)EASResource.getString((String)RES_PATH, (String)"entryDelNull"));
                SysUtil.abort();
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"ifDel")) == 2) {
                SysUtil.abort();
            }
            for (int i = 0; i < size; ++i) {
                block = (KDTSelectBlock)range.get(i);
                rowBegin = block.getBeginRow();
                rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    row = kDTable.getRow(j);
                    if (row == null || rowIndexs.contains(String.valueOf(j))) continue;
                    rowIndexs.add(String.valueOf(j));
                }
            }
            Object[] indexArray = rowIndexs.toArray();
            int[] indexArr = new int[indexArray.length];
            for (k = 0; k < indexArray.length; ++k) {
                indexArr[k] = Integer.parseInt(indexArray[k].toString());
            }
            Arrays.sort(indexArr);
            for (k = indexArr.length; k > 0; --k) {
                kDTable.removeRow(indexArr[k - 1]);
            }
        }
    }
}

