/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgCHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.client.BgFormActualListUI;
import com.kingdee.eas.ma.budget.client.BgOrgViewF7;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgDynaIntegrationFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgIntegrationFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgIntegrationInfo;
import com.kingdee.eas.ma.nbudget.IBgDynaIntegrationFacade;
import com.kingdee.eas.ma.nbudget.IBgIntegrationFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgIntegrationDataImportUI;
import com.kingdee.eas.ma.nbudget.client.BgCSLImportResultUI;
import com.kingdee.eas.ma.nbudget.client.BgNActualRecordListUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormListUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgIntegrationDataImportUI
extends AbstractBgIntegrationDataImportUI {
    private static final long serialVersionUID = 5915668161543566827L;
    private static final Logger logger = CoreUIObject.getLogger(BgIntegrationDataImportUI.class);
    private boolean isFudian = false;
    private CalendarHelper calendar = new CalendarHelper();
    private OrgUnitInfo currOrgUnit = null;
    private CostCenterOrgUnitInfo currCCOrgUnit = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    protected CostCenterOrgUnitInfo getCurrCostCenterOrgUnit() {
        return this.currCCOrgUnit;
    }

    public void setFudian(boolean isFudian) {
        this.isFudian = isFudian;
    }

    public boolean isFudian() {
        return this.isFudian;
    }

    protected IBgIntegrationFacade getImportface() throws Exception {
        return BgIntegrationFacadeFactory.getRemoteInstance();
    }

    protected IBgDynaIntegrationFacade getDynaImportface() throws Exception {
        return BgDynaIntegrationFacadeFactory.getRemoteInstance();
    }

    protected IBgAnalyseFacade getInterface() throws Exception {
        return BgAnalyseFacadeFactory.getRemoteInstance();
    }

    protected void init() throws Exception {
        this.setFudian(BgParamCHelper.isFodian());
        this.currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        this.currCCOrgUnit = SysContext.getSysContext().getCurrentCostUnit();
        this.initOrgUnit();
        this.initBgTemplate();
        this.initCurrency();
        this.initType();
        this.initArea();
    }

    protected void initOrgUnit() throws Exception {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage((String)"orgUnitTitle"));
        orgView.setCuID(this.getCurrOrgUnit().getId().toString());
        orgView.setMultiSelect(true);
        orgView.setReturnSuperior(false);
        this.prmtOrgUnit.setEnabledMultiSelection(true);
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
    }

    protected void initBgTemplate() throws Exception {
        this.prmtBgTemplate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    BgIntegrationDataImportUI.this.prmtBgTemplate_dataChanged(eventObj);
                }
                catch (Exception ex) {
                    BgIntegrationDataImportUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
        this.prmtBgTemplate.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    BgIntegrationDataImportUI.this.prmtBgTemplate_willShow(e);
                }
                catch (Exception ex) {
                    BgIntegrationDataImportUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    protected void initCurrency() throws Exception {
        BgNFCHelper.setCurrency(this.comCurrency, null, false);
    }

    protected void initType() throws Exception {
        Iterator iter = RptPeriodTypeEnum.iterator();
        while (iter.hasNext()) {
            this.comType.addItem(iter.next());
        }
        this.comType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
    }

    protected void initArea() throws Exception {
        this.comArea.removeAllItems();
        this.comArea.addItems(CslRptUIUtil.getOrgTreeCollection((Date)((Date)this.pickDate.getValue())).toArray());
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.comBgScheme.removeAllItems();
        Object obj = e.getNewValue();
        if (obj != null && obj instanceof OrgUnitInfo[]) {
            HashSet<BOSUuid> subOrgUnits = null;
            OrgUnitInfo[] orgUnits = null;
            CostCenterOrgUnitInfo cCOrgUnit = null;
            CostCenterOrgUnitInfo currCCOrgUnitInfo = null;
            orgUnits = (OrgUnitInfo[])obj;
            subOrgUnits = new HashSet<BOSUuid>();
            if (orgUnits != null && orgUnits.length > 1) {
                currCCOrgUnitInfo = this.getCurrCostCenterOrgUnit();
                if (!currCCOrgUnitInfo.getId().equals((Object)orgUnits[0].getId())) {
                    currCCOrgUnitInfo = (CostCenterOrgUnitInfo)orgUnits[0];
                }
                int n = orgUnits.length;
                for (int i = 0; i < n; ++i) {
                    cCOrgUnit = (CostCenterOrgUnitInfo)orgUnits[i];
                    if (cCOrgUnit.getId().equals((Object)currCCOrgUnitInfo.getId())) continue;
                    subOrgUnits.add(cCOrgUnit.getId());
                }
            } else {
                currCCOrgUnitInfo = (CostCenterOrgUnitInfo)orgUnits[0];
            }
            BgSchemeCollection bgSchemeCol = null;
            try {
                bgSchemeCol = this.getBgSchemeInfo(currCCOrgUnitInfo.getId(), subOrgUnits, this.isFudian(), false);
                this.comBgScheme.addItems(bgSchemeCol.toArray());
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
        }
    }

    protected BgSchemeCollection getBgSchemeInfo(BOSUuid currCCOrgUnitId, Set subOrgUnits, boolean hasUseFund, boolean isFund) throws Exception {
        return this.getInterface().getCommonBgScheme(currCCOrgUnitId, subOrgUnits, hasUseFund, isFund, true);
    }

    @Override
    protected void comBgScheme_actionPerformed(ActionEvent e) throws Exception {
        Object obj1 = this.prmtOrgUnit.getData();
        Object obj2 = this.comBgScheme.getSelectedItem();
        if (obj1 != null && obj1 instanceof OrgUnitInfo[] && obj2 != null && obj2 instanceof BgSchemeInfo) {
            OrgUnitInfo[] orgUnits = (OrgUnitInfo[])obj1;
            BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)obj2;
            HashSet<String> bgTemplatIdSet = new HashSet<String>();
            BOSUuid[] orgUnitIds = null;
            BgTemplateInfo _bgTemplateInfo2 = null;
            BgTemplateCollection _bgTemplateCol = null;
            EntityViewInfo view = null;
            FilterInfo filter = null;
            orgUnitIds = new BOSUuid[orgUnits.length];
            int in = orgUnitIds.length;
            for (int i = 0; i < in; ++i) {
                orgUnitIds[i] = ((CostCenterOrgUnitInfo)orgUnits[i]).getId();
            }
            _bgTemplateCol = this.getInterface().getCommonBgTemplate(_bgSchemeInfo.getId(), orgUnitIds);
            if (_bgTemplateCol != null) {
                for (BgTemplateInfo _bgTemplateInfo2 : _bgTemplateCol) {
                    bgTemplatIdSet.add(_bgTemplateInfo2.getId().toString());
                }
            }
            if (this.prmtBgTemplate.getEntityViewInfo() == null) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
            } else {
                view = this.prmtBgTemplate.getEntityViewInfo();
                filter = view.getFilter();
                filter.getFilterItems().clear();
            }
            filter.getFilterItems().add(new FilterItemInfo("id", bgTemplatIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("formType", (Object)4, CompareType.NOTEQUALS));
            view.setFilter(filter);
            this.prmtBgTemplate.setEntityViewInfo(view);
        }
    }

    protected void prmtBgTemplate_willShow(SelectorEvent e) throws Exception {
        Object obj = this.comBgScheme.getSelectedItem();
        if (obj == null) {
            this.comBgScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectJCBgScheme"));
            SysUtil.abort();
        }
    }

    protected void prmtBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        Object obj = e.getNewValue();
        if (obj != null && obj instanceof String) {
            e.setNewValue(null);
        }
    }

    @Override
    protected void comType_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.comType.getSelectedItem();
        if (obj != null && obj instanceof RptPeriodTypeEnum) {
            int type = ((RptPeriodTypeEnum)obj).getValue();
            switch (type) {
                case 1: {
                    this.setDayTime(this.pickDate.getSqlDate());
                    break;
                }
                case 3: {
                    this.setMonthTime(this.pickDate.getSqlDate());
                    break;
                }
                case 4: {
                    this.setQuarterTime(this.pickDate.getSqlDate());
                    break;
                }
                case 5: {
                    this.setHalfYearTime(this.pickDate.getSqlDate());
                    break;
                }
                case 2: {
                    this.setWeekTime(this.pickDate.getSqlDate());
                    break;
                }
                case 6: {
                    this.setYearTime(this.pickDate.getSqlDate());
                    break;
                }
            }
        }
    }

    @Override
    protected void pickDate_dataChanged(DataChangeEvent e) throws Exception {
        Date _oldDate;
        Date _newDate;
        if (e.getNewValue() != null && (_newDate = this.calendar.getStartDate((Date)e.getNewValue())).compareTo(_oldDate = this.calendar.getStartDate((Date)e.getOldValue())) != 0) {
            int type = ((RptPeriodTypeEnum)this.comType.getSelectedItem()).getValue();
            switch (type) {
                case 1: {
                    this.setDayTime(_newDate);
                    break;
                }
                case 3: {
                    this.setMonthTime(_newDate);
                    break;
                }
                case 4: {
                    this.setQuarterTime(_newDate);
                    break;
                }
                case 5: {
                    this.setHalfYearTime(_newDate);
                    break;
                }
                case 2: {
                    this.setWeekTime(_newDate);
                    break;
                }
                case 6: {
                    this.setYearTime(_newDate);
                    break;
                }
            }
            this.comArea.removeAllItems();
            this.comArea.addItems(CslRptUIUtil.getOrgTreeCollection((Date)((Date)this.pickDate.getValue())).toArray());
        }
    }

    protected void setYearTime(Date date) throws Exception {
        Date _date = date == null ? new Date() : date;
        int _year = this.calendar.getCurrentlyYear(_date);
        this.pickDate.setValue((Object)this.calendar.getLastDayOfYear(_year));
    }

    protected void setHalfYearTime(Date date) throws Exception {
        Date _date = date == null ? new Date() : date;
        int _year = this.calendar.getCurrentlyYear(_date);
        int _halfYear = this.calendar.getCurrentlyHalfYear(_date);
        this.pickDate.setValue((Object)this.calendar.getLastDayOfHalfYear(_year, _halfYear));
    }

    protected void setQuarterTime(Date date) throws Exception {
        Date _date = date == null ? new Date() : date;
        int _year = this.calendar.getCurrentlyYear(_date);
        int _quarter = this.calendar.getCurrentlyQuarter(_date);
        this.pickDate.setValue((Object)this.calendar.getLastDayOfQuarter(_year, _quarter));
    }

    protected void setMonthTime(Date date) throws Exception {
        Date _date = date == null ? new Date() : date;
        int _year = this.calendar.getCurrentlyYear(_date);
        int _month = this.calendar.getCurrentlyMonth(_date);
        this.pickDate.setValue((Object)this.calendar.getLastDayOfMonth(_year, _month));
    }

    protected void setWeekTime(Date date) throws Exception {
        Date _date = date == null ? new Date() : date;
        int _year = this.calendar.getCurrentlyYear(_date);
        int _week = this.calendar.getCurrentlyWeek(_date);
        this.pickDate.setValue((Object)this.calendar.getLastDayOfWeek(_year, _week));
    }

    protected void setDayTime(Date date) throws Exception {
        this.pickDate.setValue((Object)(date == null ? new Date() : date));
    }

    @Override
    protected void comArea_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgIntegrationInfo parameter = BgIntegrationDataImportUI.this.getIntegrationInfo();
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("CSL_PARAMETER", parameter);
                result.put("CSL_BULLETIN", BgIntegrationDataImportUI.this.getDynaImportface().importIntegration(parameter));
                return result;
            }

            public void afterExec(Object result) throws Exception {
                if (result != null && result instanceof Map) {
                    BgIntegrationDataImportUI.this.openImportResultViewUI(result);
                }
                BgIntegrationDataImportUI.this.getUIWindow().close();
            }
        });
        dialog.show();
    }

    protected void openImportResultViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"CSL_BULLETIN", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.openImportResultModel()).create(BgCSLImportResultUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected String openImportResultModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void verify() throws Exception {
        Object obj = this.prmtOrgUnit.getData();
        if (obj == null || !(obj instanceof OrgUnitInfo[])) {
            this.prmtOrgUnit.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectJCOrgUnit"));
            SysUtil.abort();
        }
        if ((obj = this.comBgScheme.getSelectedItem()) == null || !(obj instanceof BgSchemeInfo)) {
            this.comBgScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectJCBgScheme"));
            SysUtil.abort();
        }
        if ((obj = this.prmtBgTemplate.getData()) != null && obj instanceof Object[]) {
            Object[] _obj = (Object[])obj;
            int in = _obj.length;
            for (int i = 0; i < in; ++i) {
                if (_obj[i] == null || _obj[i] instanceof BgTemplateInfo) continue;
                this.prmtBgTemplate.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectJCBgTemplate"));
                SysUtil.abort();
            }
        } else {
            this.prmtBgTemplate.setData(null);
        }
        obj = this.comCurrency.getSelectedItem();
        if (obj == null || !(obj instanceof CurrencyInfo)) {
            this.comCurrency.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectJCurrency"));
            SysUtil.abort();
        }
        if ((obj = this.comType.getSelectedItem()) == null || !(obj instanceof RptPeriodTypeEnum)) {
            this.comType.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectJCType"));
            SysUtil.abort();
        }
        if ((obj = this.pickDate.getValue()) == null || !(obj instanceof Date)) {
            this.pickDate.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectJCDate"));
            SysUtil.abort();
        }
        if ((obj = this.comArea.getSelectedItem()) == null || !(obj instanceof OrgTreeInfo)) {
            this.comArea.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectJCArea"));
            SysUtil.abort();
        }
    }

    protected BgIntegrationInfo getIntegrationInfo() throws Exception {
        BgIntegrationInfo info = new BgIntegrationInfo();
        Object obj = this.getUIContext().get("Owner");
        if (obj != null) {
            if (obj instanceof BgNFormListUI) {
                info.setImportType(1);
            } else if (obj instanceof BgFormActualListUI) {
                info.setImportType(2);
            } else if (obj instanceof BgNActualRecordListUI) {
                info.setImportType(3);
            }
        }
        if ((obj = this.prmtOrgUnit.getData()) != null) {
            info.setOrgUnitInfos((OrgUnitInfo[])obj);
        }
        if ((obj = this.comBgScheme.getSelectedItem()) != null) {
            info.setBgSchemeInfo((BgSchemeInfo)obj);
        }
        if ((obj = this.prmtBgTemplate.getData()) != null) {
            Object[] _obj = (Object[])obj;
            if (_obj.length > 0 && null == _obj[0]) {
                info.setBgTemplateInfos(null);
            } else {
                info.setBgTemplateInfos((Object[])obj);
            }
        }
        if ((obj = this.comCurrency.getSelectedItem()) != null) {
            info.setCurrencyInfo((CurrencyInfo)obj);
        }
        if ((obj = this.comType.getSelectedItem()) != null) {
            info.setRptPeriodType(((RptPeriodTypeEnum)obj).getValue());
        }
        if ((obj = this.pickDate.getValue()) != null) {
            info.setDate((Date)obj);
        }
        if ((obj = this.comArea.getSelectedItem()) != null) {
            info.setOrgTreeInfo((OrgTreeInfo)obj);
        }
        return info;
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            try {
                BgCHelper.refreshListUI((CoreUI)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return re;
    }
}

