/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public class BgItemDisplayProvider
implements IDisplayValueProvider {
    public Object getDisplayValue(Cell cell, int viewMode) {
        if (viewMode == 0 && !BgNFSHelper.checkIsEmptyValue(cell)) {
            if (cell.getValue().getValue() instanceof GregorianCalendar) {
                return cell.getText();
            }
            String _text = cell.getText();
            if (!StringUtils.isEmpty((String)_text) && ("#DIV/0!".equals(_text) || _text.indexOf("#BAD FUNCTION") >= 0)) {
                Object obj = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
                if (obj instanceof ReportCalculateErrorProvider) {
                    ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj;
                    if ("#DIV/0!".equals(_text)) {
                        return rcep.getZeroDivDisplayAs();
                    }
                    if (_text.indexOf("#BAD FUNCTION") >= 0) {
                        return rcep.getExceptionReplacer();
                    }
                }
                return _text;
            }
        }
        if (viewMode == 10) {
            ItemFormula item = (ItemFormula)cell.getUserObjectValue("ITEM");
            if (item == null) {
                return null;
            }
            String formula = item.getFormula();
            if (!StringUtils.isEmpty((String)formula)) {
                List list = new ArrayList();
                try {
                    list = TableToolkit.parseFormula((String)formula, (boolean)false);
                }
                catch (ParserException e1) {
                    return null;
                }
                if (list == null || list.isEmpty()) {
                    return null;
                }
                FormulaHint hint = (FormulaHint)list.get(0);
                String[] params = hint.getParams();
                if (params.length == 6 && hint.name.equalsIgnoreCase("BgItem")) {
                    return "=BgItem(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[5] + "\")";
                }
                if (params.length == 4 && hint.name.equalsIgnoreCase("BgItem")) {
                    return formula;
                }
                return null;
            }
            return null;
        }
        return null;
    }
}

