/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.budget.BgItemGroupCollection;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.nbudget.client.AbstractBgItemGroupListF7UI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgItemGroupListF7UI
extends AbstractBgItemGroupListF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgItemGroupListF7UI.class);
    private VisualItemInfo returnData = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.rightItemGroupTbl.checkParsed();
        this.rightItemGroupTbl.getSelectManager().setSelectMode(10);
        this.buildTree();
    }

    public void buildTree() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longNumber"));
        view.setSorter(sorter);
        BgItemGroupCollection coll = BgItemGroupFactory.getRemoteInstance().getBgItemGroupCollection(view);
        BgItemGroupInfo info = new BgItemGroupInfo();
        info.setName("\u9884\u7b97\u9879\u76ee");
        info.setIsLeaf(false);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)info);
        if (coll != null && !coll.isEmpty()) {
            DefaultKingdeeTreeNode node = null;
            boolean isAddSuccess = false;
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                node = new DefaultKingdeeTreeNode((Object)info);
                isAddSuccess = this.addChildNode(root, node);
                if (isAddSuccess) continue;
                root.add((MutableTreeNode)node);
            }
        }
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        this.leftItemGroupTree.setModel((TreeModel)treeModel);
    }

    private boolean addChildNode(DefaultKingdeeTreeNode root, DefaultKingdeeTreeNode node) {
        if (root == null || node == null) {
            return false;
        }
        boolean success = false;
        DefaultKingdeeTreeNode childNode = null;
        BgItemGroupInfo childBgItemGroupInfo = null;
        BgItemGroupInfo bgItemGroupInfo = (BgItemGroupInfo)node.getUserObject();
        if (bgItemGroupInfo.getParent() == null) {
            return false;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            childNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
            childBgItemGroupInfo = (BgItemGroupInfo)childNode.getUserObject();
            if (childBgItemGroupInfo.getId().toString().equals(bgItemGroupInfo.getParent().getId().toString())) {
                childNode.add((MutableTreeNode)node);
                return true;
            }
            if (childNode.getChildCount() <= 0 || !(success = this.addChildNode(childNode, node))) continue;
            return true;
        }
        return success;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnToRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnToLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnToLeft.setEnabled(true);
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.leftItemGroupTree.getLastSelectedPathComponent();
        if (node != null) {
            BgItemGroupInfo info = (BgItemGroupInfo)node.getUserObject();
            if (!info.isIsLeaf()) {
                return;
            }
            if (!this.checkHasExist(info)) {
                IRow row = this.rightItemGroupTbl.addRow();
                row.getCell(0).setValue((Object)info.getId());
                row.getCell(1).setValue((Object)info.getNumber());
                row.getCell(2).setValue((Object)info.getName());
            }
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.returnData = new VisualItemInfo();
        StringBuffer name = new StringBuffer();
        StringBuffer number = new StringBuffer();
        int count = this.rightItemGroupTbl.getRowCount();
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            row = this.rightItemGroupTbl.getRow(i);
            if (i == count - 1) {
                number.append((String)row.getCell(1).getValue());
                name.append((String)row.getCell(2).getValue());
                continue;
            }
            number.append((String)row.getCell(1).getValue()).append(",");
            name.append((String)row.getCell(2).getValue()).append(",");
        }
        this.returnData.setName(name.toString());
        this.returnData.setNumber(number.toString());
        this.destroyWindow();
    }

    public VisualItemInfo getReturnData() {
        return this.returnData;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    private boolean checkHasExist(BgItemGroupInfo info) {
        int count = this.rightItemGroupTbl.getRowCount();
        IRow row = null;
        BOSUuid id = null;
        for (int i = 0; i < count; ++i) {
            row = this.rightItemGroupTbl.getRow(i);
            id = (BOSUuid)row.getCell(0).getValue();
            if (!info.getId().equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.rightItemGroupTbl);
        if (rows == null || rows.length == 0) {
            return;
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            this.rightItemGroupTbl.removeRow(rows[i]);
        }
    }
}

