/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.budget.BgAnalyseFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemAnalyseParam;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.client.AbstractBgItemReqUseAnalyseFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgItemReqUseAnalyseFilterUI
extends AbstractBgItemReqUseAnalyseFilterUI {
    private static final long serialVersionUID = 456807135261857896L;
    private static final Logger logger = CoreUIObject.getLogger(BgItemReqUseAnalyseFilterUI.class);
    private int Col_Element = -1;
    private int Col_MeasureUnit = -1;
    private static final String BGTEMPLATE_ID = "BGTEMPLATE_ID";
    private static final String BGITEM_BEGIN_NUMBER = "BGITEM_BEGIN_NUMBER";
    private static final String BGITEM_END_NUMBER = "BGITEM_END_NUMBER";
    private static final String BGELEMENT_MEASUREUNIT_ID = "BGELEMENT_MEASUREUNIT_ID";

    public BgItemReqUseAnalyseFilterUI() throws Exception {
    }

    public BgItemReqUseAnalyseFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    public String getUITitle() {
        return BgAnalyseHelper.getMessage((String)"bgItemReqUseAnalyse");
    }

    protected FilterParam createNewFilterParam() {
        return new BgItemAnalyseParam();
    }

    protected KDTable getMuTable() {
        return this.tblMeasureUnit;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.Col_Element = this.getMuTable().getColumnIndex("bgElement");
        this.Col_MeasureUnit = this.getMuTable().getColumnIndex("MeasureUnit");
        this.initMyListener();
    }

    protected void initMyListener() {
        this.tblMeasureUnit.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BgItemReqUseAnalyseFilterUI.this.tblMeasureUnit_editStopped(e);
                }
                catch (Exception e1) {
                    BgItemReqUseAnalyseFilterUI.this.handUIException(e1);
                }
            }
        });
    }

    protected void initFilter() throws Exception {
        super.initFilter();
        this.comAnalyseType.setSelectedItem((Object)BgAnalysisTypeEnum.BGREQUSE);
        this.comAnalyseType.setEnabled(false);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setQueryInfo("com.kingdee.eas.ma.budget.F7BgElementQuery");
        prmtSelect.setVisible(true);
        prmtSelect.setEditable(false);
        prmtSelect.setEnabledMultiSelection(true);
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setDisplayFormat("$name$");
        this.tblMeasureUnit.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        this.tblMeasureUnit.setUserCellDisplayParser((IUserCellDisplayParser)new AnalyseCellDisplayParser());
        NewBgItemDialog bgItemSelect = new NewBgItemDialog((IUIObject)this);
        this.prmtBeginBgItem.setSelector((KDPromptSelector)bgItemSelect);
        this.prmtEndBgItem.setSelector((KDPromptSelector)bgItemSelect);
    }

    public void clear() {
        super.clear();
        this.prmtBeginBgItem.setData(null);
        this.prmtEndBgItem.setData(null);
        this.getMuTable().removeRows();
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            if (this.prmtBgPeriodBegin.getData() instanceof BgPeriodInfo && !(this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo)) {
                this.prmtBgPeriodEnd.requestFocus();
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"selectBgPeriodEnd"));
                return false;
            }
            if (!(this.prmtBgPeriodBegin.getData() instanceof BgPeriodInfo) && this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo) {
                this.prmtBgPeriodBegin.requestFocus();
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"selectBgPeriodBegin"));
                return false;
            }
            if (this.getMuTable().getRowCount() > 0) {
                int i;
                HashSet<String> verifySet = new HashSet<String>();
                int size = 0;
                ArrayList<Integer> rowList = new ArrayList<Integer>();
                int rowCount = this.getMuTable().getRowCount();
                for (i = 0; i < rowCount; ++i) {
                    ICell elementCell = this.getMuTable().getCell(i, this.Col_Element);
                    ICell measureUnitCell = this.getMuTable().getCell(i, this.Col_MeasureUnit);
                    if (elementCell.getValue() == null && measureUnitCell.getValue() == null) {
                        rowList.add(new Integer(i));
                        continue;
                    }
                    if (elementCell.getValue() == null) {
                        MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"elementIsNull"));
                        return false;
                    }
                    String elementNumber = ((BgElementInfo)elementCell.getValue()).getNumber();
                    verifySet.add(elementNumber);
                    ++size;
                }
                for (i = rowList.size() - 1; i >= 0; --i) {
                    int rowIndex = (Integer)rowList.get(i);
                    this.getMuTable().removeRow(rowIndex);
                }
                if (verifySet.size() < size) {
                    MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"elementIsRepeat"));
                    return false;
                }
            }
        }
        return re;
    }

    @Override
    protected void btnAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddNew_actionPerformed(e);
        if (this.getMuTable() != null) {
            this.getMuTable().addRow();
        }
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        if (this.getMuTable() != null && this.getMuTable().getSelectManager().getActiveRowIndex() >= 0) {
            this.getMuTable().removeRow(this.getMuTable().getSelectManager().getActiveRowIndex());
        }
    }

    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgItemAnalyseParam) {
            BgItemAnalyseParam _filterParam = (BgItemAnalyseParam)filterParam;
            if (_filterParam.getBgTemplateInfo() != null) {
                for (int i = 0; i < this.comBgTemplate.getItemCount(); ++i) {
                    if (this.comBgTemplate.getItemAt(i) == null) continue;
                    BOSUuid id = ((BgTemplateInfo)this.comBgTemplate.getItemAt(i)).getId();
                    if (!_filterParam.getBgTemplateInfo().getId().equals((Object)id)) continue;
                    this.comBgTemplate.setSelectedIndex(i);
                    break;
                }
            } else if (this.comBgTemplate.getItemCount() > 0) {
                this.comBgTemplate.setSelectedIndex(0);
            }
            if (_filterParam.getBeginBgItem() != null) {
                this.prmtBeginBgItem.setData((Object)_filterParam.getBeginBgItem());
            } else {
                this.prmtBeginBgItem.setData(null);
            }
            if (_filterParam.getEndBgItem() != null) {
                this.prmtEndBgItem.setData((Object)_filterParam.getEndBgItem());
            } else {
                this.prmtEndBgItem.setData(null);
            }
            this.getMuTable().removeRows();
            if (_filterParam.getMuMap() != null && !_filterParam.getMuMap().isEmpty() && this.getMuTable() != null) {
                Map.Entry _entry2 = null;
                IRow _row = null;
                for (Map.Entry _entry2 : _filterParam.getMuMap().entrySet()) {
                    _row = this.getMuTable().addRow();
                    _row.getCell(0).setValue(_entry2.getKey());
                    _row.getCell(1).setValue(_entry2.getValue());
                }
            }
        }
    }

    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgItemAnalyseParam) {
            BgItemAnalyseParam _filterParam = (BgItemAnalyseParam)filterParam;
            Object _obj = this.comBgTemplate.getSelectedItem();
            if (_obj instanceof BgTemplateInfo) {
                _filterParam.setBgTemplateInfo((BgTemplateInfo)_obj);
            } else {
                _filterParam.setBgTemplateInfo(null);
            }
            _obj = this.prmtBeginBgItem.getData();
            if (_obj instanceof VisualItemInfo) {
                _filterParam.setBeginBgItem((VisualItemInfo)_obj);
            } else {
                _filterParam.setBeginBgItem(null);
            }
            _obj = this.prmtEndBgItem.getData();
            if (_obj instanceof VisualItemInfo) {
                _filterParam.setEndBgItem((VisualItemInfo)_obj);
            } else {
                _filterParam.setEndBgItem(null);
            }
            _obj = this.comBgTemplate.getSelectedItem();
            if (_obj instanceof BgTemplateInfo) {
                _filterParam.setBgTemplateInfo((BgTemplateInfo)_obj);
            } else {
                _filterParam.setBgTemplateInfo(null);
            }
            if (this.getMuTable() != null && this.getMuTable().getRowCount() > 0) {
                IRow row = null;
                Object bgElementInfo = null;
                MeasureUnitInfo unitInfo = null;
                int in = this.getMuTable().getRowCount();
                for (int i = 0; i < in; ++i) {
                    Object[] _objs;
                    row = this.getMuTable().getRow(i);
                    _obj = row.getCell(0).getValue();
                    bgElementInfo = _obj instanceof BgElementInfo ? (BgElementInfo)_obj : (_obj instanceof Object[] ? ((_objs = (Object[])_obj).length > 0 && _objs[0] instanceof BgElementInfo ? (BgElementInfo)_objs[0] : null) : null);
                    _obj = row.getCell(1).getValue();
                    unitInfo = _obj instanceof MeasureUnitInfo ? (MeasureUnitInfo)_obj : null;
                    if (bgElementInfo == null || unitInfo == null) continue;
                    _filterParam.getMuMap().put(bgElementInfo, unitInfo);
                }
            }
        }
    }

    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        FilterParam _tmpParam = super.getFilterParam(mainParam, filterParam);
        BgItemAnalyseParam _mainParam = null;
        BgItemAnalyseParam _filterParam = null;
        if (_tmpParam != null && filterParam != null) {
            _mainParam = (BgItemAnalyseParam)_tmpParam;
            _filterParam = (BgItemAnalyseParam)filterParam;
            if (_mainParam != null && _filterParam != null) {
                if (_filterParam.getBgTemplateInfo() != null) {
                    _mainParam.setBgTemplateInfo(_filterParam.getBgTemplateInfo());
                } else {
                    _mainParam.setBgTemplateInfo(null);
                }
                if (_filterParam.getBeginBgItem() != null) {
                    _mainParam.setBeginBgItem(_filterParam.getBeginBgItem());
                } else {
                    _mainParam.setBeginBgItem(null);
                }
                if (_filterParam.getEndBgItem() != null) {
                    _mainParam.setEndBgItem(_filterParam.getEndBgItem());
                } else {
                    _mainParam.setEndBgItem(null);
                }
                if (_filterParam.getMuMap() != null && !_filterParam.getMuMap().isEmpty()) {
                    _mainParam.setMuMap(_filterParam.getMuMap());
                } else {
                    _mainParam.setMuMap(null);
                }
            }
        }
        return _mainParam;
    }

    protected void bgScheme_actionPerformed(ActionEvent e) throws Exception {
        BgTemplateCollection templateCollection;
        super.bgScheme_actionPerformed(e);
        Object _obj = this.comBgScheme.getSelectedItem();
        BOSUuid[] orgUnitIds = this.getOrgUnitIds();
        this.comBgTemplate.removeAllItems();
        if (_obj != null && _obj instanceof BgSchemeInfo && orgUnitIds != null && (templateCollection = this.getBgTemplateInfo(((BgSchemeInfo)_obj).getId(), orgUnitIds)) != null) {
            this.comBgTemplate.addItems(templateCollection.toArray());
        }
    }

    protected BgTemplateCollection getBgTemplateInfo(BOSUuid bgSchemeId, BOSUuid[] orgUnitIds) throws Exception {
        return this.getInterface().getCommonBgTemplate(bgSchemeId, orgUnitIds);
    }

    protected void initMeasureUnit() throws Exception {
        MeasureUnitCollection muCol = this.getMeasureUnitInfo();
        if (muCol != null && !muCol.isEmpty()) {
            this.comMeasureUnit.removeAllItems();
            this.comMeasureUnit.addItems(muCol.toArray());
            if (this.ui != null) {
                Method method = null;
                try {
                    BgAnalyseFilterParam filterParam;
                    method = this.ui.getClass().getMethod("getFilterParam", null);
                    if (method != null && (filterParam = (BgAnalyseFilterParam)method.invoke(this.ui, null)) != null) {
                        BgAnalyseHelper.setSelectObject((KDComboBox)this.comMeasureUnit, (Object)filterParam.getMeasureUnit());
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            KDTDefaultCellEditor editor = null;
            KDComboBox comboBox = new KDComboBox();
            DefaultComboBoxModel<MeasureUnitInfo> model = new DefaultComboBoxModel<MeasureUnitInfo>();
            int in = muCol.size();
            for (int i = 0; i < in; ++i) {
                model.addElement(muCol.get(i));
            }
            comboBox.setModel(model);
            editor = new KDTDefaultCellEditor((JComboBox)comboBox);
            this.tblMeasureUnit.checkParsed();
            this.tblMeasureUnit.getColumn(1).setEditor((ICellEditor)editor);
        }
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (value instanceof Object[]) {
            Object[] _objs = (Object[])value;
            if (_objs[0] != null) {
                return this.formatCellDisplay(rowIndex, colIndex, cell, _objs[0]);
            }
        } else if (value instanceof BgElementInfo) {
            return ((BgElementInfo)value).getName();
        }
        return value;
    }

    public void tblMeasureUnit_editStopped(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.Col_Element) {
            KDTRange range = this.tblMeasureUnit.getSelectManager().toRange();
            KDTSelectBlock block = (KDTSelectBlock)range.get(0);
            int firstInsertRow = block.getBeginRow();
            Object object = this.tblMeasureUnit.getCell(rowIndex, colIndex).getValue();
            if (object instanceof Object[]) {
                int i;
                Object[] result = (Object[])object;
                int size = result.length;
                int maxRow = this.tblMeasureUnit.getRowCount();
                int leftRow = maxRow - (firstInsertRow + 1);
                if (size > leftRow) {
                    for (i = leftRow; i < size - 1; ++i) {
                        this.tblMeasureUnit.addRow();
                    }
                }
                int length = result.length;
                for (i = 0; i < length; ++i) {
                    BgElementInfo info = (BgElementInfo)result[i];
                    this.tblMeasureUnit.getCell(firstInsertRow, this.Col_Element).setValue((Object)info);
                    ++firstInsertRow;
                }
            }
        }
    }

    protected boolean hasNewScheme() {
        return true;
    }

    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgItemAnalyseParam)) {
            return;
        }
        String tmpStr = null;
        Map tmpMap = null;
        BgItemAnalyseParam _filterParam = (BgItemAnalyseParam)filterParam;
        tmpStr = cp.getCustomerParam(BGTEMPLATE_ID);
        if (!StringUtils.isEmpty((String)tmpStr)) {
            _filterParam.setBgTemplateInfo(new BgTemplateInfo());
            _filterParam.getBgTemplateInfo().setId(BOSUuid.read((String)tmpStr));
        } else {
            _filterParam.setBgTemplateInfo(null);
        }
        tmpStr = cp.getCustomerParam(BGITEM_BEGIN_NUMBER);
        if (!StringUtils.isEmpty((String)tmpStr)) {
            _filterParam.setBeginBgItem(new VisualItemInfo());
            _filterParam.getBeginBgItem().setNumber(tmpStr);
        } else {
            _filterParam.setBeginBgItem(null);
        }
        tmpStr = cp.getCustomerParam(BGITEM_END_NUMBER);
        if (!StringUtils.isEmpty((String)tmpStr)) {
            _filterParam.setEndBgItem(new VisualItemInfo());
            _filterParam.getEndBgItem().setNumber(tmpStr);
        } else {
            _filterParam.setEndBgItem(null);
        }
        tmpMap = (Map)BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.decode((String)cp.getCustomerParam(BGELEMENT_MEASUREUNIT_ID)));
        if (tmpMap != null) {
            _filterParam.setMuMap(tmpMap);
        } else {
            _filterParam.setMuMap(null);
        }
    }

    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgItemAnalyseParam)) {
            return;
        }
        HashMap<String, String> tmpMap = null;
        Map.Entry _entry2 = null;
        BgElementInfo bgElementInfo = null;
        MeasureUnitInfo measureUnitInfo = null;
        BgItemAnalyseParam _filterParam = (BgItemAnalyseParam)filterParam;
        if (_filterParam.getBgTemplateInfo() != null && _filterParam.getBgTemplateInfo().getId() != null) {
            cp.addCustomerParam(BGTEMPLATE_ID, _filterParam.getBgTemplateInfo().getId().toString());
        } else {
            cp.removeCustomerParam(BGTEMPLATE_ID);
        }
        if (_filterParam.getBeginBgItem() != null) {
            cp.addCustomerParam(BGITEM_BEGIN_NUMBER, _filterParam.getBeginBgItem().getNumber());
        } else {
            cp.removeCustomerParam(BGITEM_BEGIN_NUMBER);
        }
        if (_filterParam.getEndBgItem() != null) {
            cp.addCustomerParam(BGITEM_END_NUMBER, _filterParam.getEndBgItem().getNumber());
        } else {
            cp.removeCustomerParam(BGITEM_END_NUMBER);
        }
        if (_filterParam.getMuMap() != null && !_filterParam.getMuMap().isEmpty()) {
            tmpMap = new HashMap<String, String>();
            for (Map.Entry _entry2 : _filterParam.getMuMap().entrySet()) {
                bgElementInfo = (BgElementInfo)_entry2.getKey();
                measureUnitInfo = (MeasureUnitInfo)_entry2.getValue();
                if (bgElementInfo == null || measureUnitInfo == null) continue;
                tmpMap.put(bgElementInfo.getId().toString(), measureUnitInfo.getId().toString());
            }
            if (!tmpMap.isEmpty()) {
                cp.addCustomerParam(BGELEMENT_MEASUREUNIT_ID, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(tmpMap)));
            } else {
                cp.removeCustomerParam(BGELEMENT_MEASUREUNIT_ID);
            }
        } else {
            cp.removeCustomerParam(BGELEMENT_MEASUREUNIT_ID);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            if (request == null) {
                request = new RequestContext();
                request.setClassName(this.getUIHandlerClassName());
                handler.setRequestContext((Serializable)request);
            }
            request.put("ORGUNIT_ID", (Object)this.getCurrOrgUnit().getId().toString());
        }
        return handler;
    }

    private final class AnalyseCellDisplayParser
    implements IUserCellDisplayParser {
        private AnalyseCellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return BgItemReqUseAnalyseFilterUI.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }
}

